/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.ErrorManager;
import com.github.jhoenicke.javacup.Grammar;
import com.github.jhoenicke.javacup.action_part;
import com.github.jhoenicke.javacup.lr_item;
import com.github.jhoenicke.javacup.non_terminal;
import com.github.jhoenicke.javacup.symbol;
import com.github.jhoenicke.javacup.symbol_part;
import com.github.jhoenicke.javacup.terminal;
import com.github.jhoenicke.javacup.terminal_set;

public class production {
    private final non_terminal _lhs;
    private int _rhs_prec = -1;
    private int _rhs_assoc = -1;
    private final symbol_part[] _rhs;
    private final action_part _action;
    private final int _index;
    private final int _action_index;
    private lr_item _itm;
    private boolean _nullable_known = false;
    private boolean _nullable = false;
    private int indexOfIntermediateResult;

    public production(int index, int action_index, non_terminal lhs_sym, symbol_part[] rhs, int last_act_loc, action_part action, terminal precedence) {
        if (precedence != null) {
            this._rhs_prec = precedence.precedence_num();
            this._rhs_assoc = precedence.precedence_side();
        }
        this._lhs = lhs_sym;
        this._rhs = rhs;
        this._action = action;
        this._index = index;
        this._action_index = action_index;
        int i = 0;
        while (i < rhs.length) {
            terminal term;
            symbol rhs_sym = rhs[i].the_symbol;
            rhs_sym.note_use();
            if (precedence == null && rhs_sym instanceof terminal && (term = (terminal)rhs_sym).precedence_num() != -1) {
                if (this._rhs_prec == -1) {
                    this._rhs_prec = term.precedence_num();
                    this._rhs_assoc = term.precedence_side();
                } else if (term.precedence_num() != this._rhs_prec) {
                    ErrorManager.getManager().emit_error("Production " + this + " has more than one precedence symbol");
                }
            }
            ++i;
        }
        this.indexOfIntermediateResult = last_act_loc;
        lhs_sym.add_production(this);
    }

    public non_terminal lhs() {
        return this._lhs;
    }

    public int precedence_num() {
        return this._rhs_prec;
    }

    public int precedence_side() {
        return this._rhs_assoc;
    }

    public symbol_part rhs(int indx) {
        return this._rhs[indx];
    }

    public int rhs_length() {
        return this._rhs.length;
    }

    public int rhs_stackdepth() {
        return this._rhs.length;
    }

    public action_part action() {
        return this._action;
    }

    public int index() {
        return this._index;
    }

    public int action_index() {
        return this._action_index;
    }

    public lr_item item() {
        if (this._itm == null) {
            this._itm = new lr_item(this);
        }
        return this._itm;
    }

    public int getIndexOfIntermediateResult() {
        return this.indexOfIntermediateResult;
    }

    public boolean check_nullable() {
        if (this._nullable_known) {
            return this._nullable;
        }
        if (this.rhs_length() == 0) {
            return this.set_nullable(true);
        }
        int pos = 0;
        while (pos < this.rhs_length()) {
            symbol sym2 = this._rhs[pos].the_symbol;
            if (!sym2.is_non_term()) {
                return this.set_nullable(false);
            }
            if (!((non_terminal)sym2).nullable()) {
                return false;
            }
            ++pos;
        }
        return this.set_nullable(true);
    }

    private boolean set_nullable(boolean v) {
        this._nullable_known = true;
        this._nullable = v;
        return v;
    }

    public boolean is_proxy() {
        return this._rhs.length == 1 && this.action() == null;
    }

    public terminal_set first_set(Grammar grammar) {
        return this.item().calc_lookahead(grammar);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.lhs().name()).append(" ::= ");
        int i = 0;
        while (i < this.rhs_length()) {
            result.append(this.rhs((int)i).the_symbol.name()).append(" ");
            ++i;
        }
        return result.toString();
    }
}

