/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.runtime;

import com.github.jhoenicke.javacup.runtime.Symbol;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;

public class ComplexSymbolFactory
implements SymbolFactory {
    public Symbol newSymbol(String name, int id, Location left, Location right, Object value) {
        return new ComplexSymbol(name, id, left, right, value);
    }

    public Symbol newSymbol(String name, int id, Location left, Location right) {
        return new ComplexSymbol(name, id, left, right);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Symbol right, Object value) {
        return new ComplexSymbol(name, id, left, right, value);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Symbol right) {
        return new ComplexSymbol(name, id, left, right);
    }

    @Override
    public Symbol newSymbol(String name, int id) {
        return new ComplexSymbol(name, id);
    }

    @Override
    public Symbol newSymbol(String name, int id, Object value) {
        return new ComplexSymbol(name, id, value);
    }

    @Override
    public Symbol startSymbol(String name, int id, int state) {
        return new ComplexSymbol(name, id, state);
    }

    public static class ComplexSymbol
    extends Symbol {
        protected String name;
        protected Location xleft;
        protected Location xright;

        public ComplexSymbol(String name, int id) {
            super(id);
            this.name = name;
        }

        public ComplexSymbol(String name, int id, Object value) {
            super(id, value);
            this.name = name;
        }

        @Override
        public String toString() {
            if (this.xleft == null || this.xright == null) {
                return "Symbol: " + this.name;
            }
            return "#" + this.sym + "[" + this.name + "](" + this.xleft + " - " + this.xright + ")";
        }

        public ComplexSymbol(String name, int id, int state) {
            super(id, state);
            this.name = name;
        }

        public ComplexSymbol(String name, int id, Symbol left, Symbol right) {
            super(id, left, right);
            this.name = name;
            if (left != null) {
                this.xleft = ((ComplexSymbol)left).xleft;
            }
            if (right != null) {
                this.xright = ((ComplexSymbol)right).xright;
            }
        }

        public ComplexSymbol(String name, int id, Location left, Location right) {
            super(id);
            this.name = name;
            this.xleft = left;
            this.xright = right;
        }

        public ComplexSymbol(String name, int id, Symbol left, Symbol right, Object value) {
            super(id, value);
            this.name = name;
            if (left != null) {
                this.xleft = ((ComplexSymbol)left).xleft;
            }
            if (right != null) {
                this.xright = ((ComplexSymbol)right).xright;
            }
        }

        public ComplexSymbol(String name, int id, Location left, Location right, Object value) {
            super(id, value);
            this.name = name;
            this.xleft = left;
            this.xright = right;
        }

        public Location getLeft() {
            return this.xleft;
        }

        public Location getRight() {
            return this.xright;
        }
    }

    public static class Location {
        private String unit = null;
        private int line;
        private int column;

        public Location(String unit, int line, int column) {
            this.unit = unit;
            this.line = line;
            this.column = column;
        }

        public Location(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public String toString() {
            return String.valueOf(this.unit == null ? "" : String.valueOf(this.unit) + ":") + this.line + "/" + this.column;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

