/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.runtime;

import com.github.jhoenicke.javacup.runtime.Symbol;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;

public class SimpleSymbolFactory
implements SymbolFactory {
    public Symbol newSymbol(String name, int id, int lline, int lcol, int rline, int rcol, Object value) {
        return new LineColumnSymbol(name, id, lline, lcol, rline, rcol, value);
    }

    public Symbol newSymbol(String name, int id, int lline, int lcol, int rline, int rcol) {
        return new LineColumnSymbol(name, id, lline, lcol, rline, rcol, null);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Symbol right, Object value) {
        return new LineColumnSymbol(name, id, left, right, value);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Symbol right) {
        return new LineColumnSymbol(name, id, left, right, null);
    }

    @Override
    public Symbol newSymbol(String name, int id) {
        return new LineColumnSymbol(name, id, -1, -1, -1, -1, null);
    }

    @Override
    public Symbol newSymbol(String name, int id, Object value) {
        return new LineColumnSymbol(name, id, -1, -1, -1, -1, value);
    }

    @Override
    public Symbol startSymbol(String name, int id, int state) {
        return new LineColumnSymbol(name, id, state);
    }

    public static final class LineColumnSymbol
    extends Symbol {
        private final String mName;
        private final int mLcolumn;
        private final int mRcolumn;

        public LineColumnSymbol(String name, int id, int state) {
            super(id);
            this.parse_state = state;
            this.mName = name;
            this.mLcolumn = -1;
            this.mRcolumn = -1;
        }

        public LineColumnSymbol(String name, int id, int left, int lcolumn, int right, int rcolumn, Object o) {
            super(id, left, right, o);
            this.mName = name;
            this.mLcolumn = lcolumn;
            this.mRcolumn = rcolumn;
        }

        public LineColumnSymbol(String name, int id, Symbol left, Symbol right, Object o) {
            super(id, left, right, o);
            this.mName = name;
            this.mLcolumn = left instanceof LineColumnSymbol ? ((LineColumnSymbol)left).mLcolumn : 0;
            this.mRcolumn = right instanceof LineColumnSymbol ? ((LineColumnSymbol)left).mRcolumn : 0;
        }

        public String getLocation() {
            if (this.mLcolumn >= 0) {
                return String.valueOf(this.left) + ":" + this.mLcolumn;
            }
            return Integer.toString(this.left);
        }

        public String getName() {
            return this.mName;
        }

        @Override
        public String toString() {
            return "(" + this.mName + " " + this.left + ":" + this.mLcolumn + "-" + this.right + ":" + this.mRcolumn + ")";
        }
    }
}

