/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.runtime;

final class TableDecoder {
    private String[] coded_tables;
    private int array_idx;
    private int string_idx;

    public TableDecoder(String[] tables) {
        this.coded_tables = tables;
        this.string_idx = 0;
        this.array_idx = 0;
    }

    private char advance() {
        if (this.string_idx == this.coded_tables[this.array_idx].length()) {
            this.string_idx = 0;
            ++this.array_idx;
        }
        return this.coded_tables[this.array_idx].charAt(this.string_idx++);
    }

    public short decodeShort() {
        return (short)this.advance();
    }

    public int decodeInt() {
        int val = this.advance();
        if (val >= 32768) {
            val = ((val & Short.MAX_VALUE) << 16) + this.advance();
        }
        return val;
    }

    public int[] decodeIntArray() {
        int size = this.decodeInt();
        int[] arr = new int[size];
        int i = 0;
        while (i < size) {
            arr[i] = this.decodeInt();
            ++i;
        }
        return arr;
    }

    public short[] decodeShortArray() {
        int size = this.decodeInt();
        short[] arr = new short[size];
        int i = 0;
        while (i < size) {
            arr[i] = this.decodeShort();
            ++i;
        }
        return arr;
    }
}

