/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.Grammar;
import com.github.jhoenicke.javacup.terminal;

public class terminal_set {
    private static final int LOG_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private long[] _elements;
    private Grammar _grammar;

    public terminal_set(Grammar g) {
        this._grammar = g;
        this._elements = new long[(g.num_terminals() - 1 >>> 6) + 1];
    }

    public terminal_set(terminal_set other) {
        this(other._grammar);
        this._elements = (long[])other._elements.clone();
    }

    public boolean empty() {
        int i = 0;
        while (i < this._elements.length) {
            if (this._elements[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(terminal sym2) {
        return this.contains(sym2.index());
    }

    public boolean contains(int indx) {
        int idx = indx >> 6;
        long mask = 1L << (indx & 0x3F);
        return (this._elements[idx] & mask) != 0L;
    }

    public boolean is_subset_of(terminal_set other) {
        assert (other._elements.length == this._elements.length);
        int i = 0;
        while (i < this._elements.length) {
            if ((this._elements[i] & (other._elements[i] ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean add(terminal sym2) {
        long mask;
        int indx = sym2.index();
        int idx = indx >> 6;
        boolean result = (this._elements[idx] & (mask = 1L << (indx & 0x3F))) == 0L;
        int n = idx;
        this._elements[n] = this._elements[n] | mask;
        return result;
    }

    public void remove(terminal sym2) {
        int indx = sym2.index();
        int idx = indx >> 6;
        long mask = 1L << (indx & 0x3F);
        int n = idx;
        this._elements[n] = this._elements[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean add(terminal_set other) {
        assert (other._elements.length == this._elements.length);
        boolean changed = false;
        int i = 0;
        while (i < this._elements.length) {
            if (((this._elements[i] ^ 0xFFFFFFFFFFFFFFFFL) & other._elements[i]) != 0L) {
                changed = true;
            }
            int n = i;
            this._elements[n] = this._elements[n] | other._elements[i];
            ++i;
        }
        return changed;
    }

    public boolean intersects(terminal_set other) {
        assert (other._elements.length == this._elements.length);
        int i = 0;
        while (i < this._elements.length) {
            if ((this._elements[i] & other._elements[i]) != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(terminal_set other) {
        assert (other._elements.length == this._elements.length);
        int i = 0;
        while (i < this._elements.length) {
            if (this._elements[i] != other._elements[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof terminal_set)) {
            return false;
        }
        return this.equals((terminal_set)other);
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this._elements.length) {
            hash = 13 * hash + 157 * (int)(this._elements[i] >> 16) + (int)this._elements[i];
            ++i;
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{");
        String comma = "";
        int t = 0;
        while (t < this._grammar.num_terminals()) {
            if (this.contains(t)) {
                result.append(comma).append(this._grammar.get_terminal(t));
                comma = ", ";
            }
            ++t;
        }
        result.append("}");
        return result.toString();
    }
}

