package apron;

import java.util.Arrays;
import java.lang.reflect.Field;
import java.io.File;

public class SetUp {

  /**
   * This method trys to add the given path to
   * the java library path. This is for example
   * necessary because of differenct locations
   * of the jar file and the .so files
   */
  public static void init(String path) {
    try {
       addLibraryPath(path);
    } catch (Exception e) {
      e.printStackTrace();
      throw new RuntimeException("Could not add the necessary path to java.library.path");
    }
  }

  /**
  * Adds the specified path to the java library path
  *
  * @param pathToAdd the path to add
  * @throws Exception
  */
  private static void addLibraryPath(String pathToAdd) throws Exception{
    final Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
    usrPathsField.setAccessible(true);

    //get array of paths
    final String[] paths = (String[])usrPathsField.get(null);

    //check if the path to add is already present
    for(String path : paths) {
      if(path.equals(pathToAdd)) {
         return;
      }
    }

    //add the new path
    final String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
    newPaths[newPaths.length-1] = pathToAdd;
    usrPathsField.set(null, newPaths);
  }

}
