<!--
This file is part of CPAchecker,
a tool for configurable software verification:
https://cpachecker.sosy-lab.org

SPDX-FileCopyrightText: 2007-2020 Dirk Beyer <https://www.sosy-lab.org>

SPDX-License-Identifier: Apache-2.0
-->

# Achievements

## Awards

CPAchecker has won many awards in the International Competition on Software Verification (SV-COMP).
The full list can be found here:
https://cpachecker.sosy-lab.org/achieve.php

In 2014, the CPAchecker team received a Goedel medal at the Vienna Summer of Logic
“for their contributions to the development of efficient verification methods and algorithms,
for technology transfer by implementing the techniques in robust software systems,
and for the successful participation of their verifiers in the last three years of SV-COMP.”

## Bugs Found with CPAchecker

Note: If you have further bugs in real-world software that were found with CPAchecker,
please report them here.

CPAchecker is used to verify Linux kernel drivers
by the [Linux Driver Verification project](http://linuxtesting.org/ldv)
and [Klever](https://forge.ispras.ru/projects/klever).
The following fixes to the Linux kernel were all developed by LDV/Klever
for bugs found with CPAchecker:

- 2021-10-02: [`hwmon: (w83793) Fix NULL pointer dereference by removing unnecessary structur...`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=dd4d747ef05addab887dc8ff0d6ab9860bbcd783)
- 2021-10-02: [`hwmon: (w83792d) Fix NULL pointer dereference by removing unnecessary structu...`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0f36b88173f028e372668ae040ab1a496834d278)
- 2021-10-02: [`hwmon: (w83791d) Fix NULL pointer dereference by removing unnecessary structu...`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=943c15ac1b84d378da26bba41c83c67e16499ac4)
- 2021-09-16: [`HID: amd_sfh: Fix potential NULL pointer dereference`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d46ef750ed58cbeeba2d9a55c99231c30a172764)
- 2021-08-26: [`usb: musb: musb_dsps: request_irq() after initializing musb`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7c75bde329d7e2a93cf86a5c15c61f96f1446cdc)
- 2021-08-26: [`usb: dwc3: imx8mp: request irq after initializing dwc3`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6a48d0ae01a6ab05ae5e78328546a2f5f6d3054a)
- 2021-08-26: [`usb: ehci-orion: Handle errors of clk_prepare_enable() in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4720f1bf4ee4a784d9ece05420ba33c9222a3004)
- 2021-08-20: [`HID: thrustmaster: Fix memory leak in thrustmaster_interrupts()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c3800eed22d21c66912b4461a403b4448ed88d95)
- 2021-08-20: [`HID: thrustmaster: Fix memory leak in remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=df3a97bdbc252d3421f1c5d6d713ad6e4f36a469)
- 2021-08-20: [`HID: thrustmaster: Fix memory leaks in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d0f1d5ae23803bd82647a337fa508fa8615defc5)
- 2021-08-18: [`usb: gadget: mv_u3d: request_irq() after initializing UDC`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2af0c5ffadaf9d13eca28409d4238b4e672942d3)
- 2021-08-17: [`mtd: rawnand: intel: Fix error handling in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0792ec82175ec45a0f45af6e0f2d3cb49c527cd4)
- 2021-08-04: [`media: tegra-cec: Handle errors of clk_prepare_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=38367073c796a37a61549b1f66a71b3adb03802d)
- 2021-07-22: [`media: platform: stm32: unprepare clocks at handling errors in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=055d2db28ec2fa3ab5c527c5604f1b32b89fa13a)
- 2021-07-21: [`USB: EHCI: ehci-mv: improve error handling in mv_ehci_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=61136a12cbed234374ec6f588af57c580b20b772)
- 2021-06-17: [`media: marvell-ccic: set error code in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2b889a4afcacef4888ac8203a60e68004816e1fd)
- 2021-06-08: [`media: st_rc: Handle errors of clk_prepare_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=04297b00dfb45277b8b661d48a7a5e29876fc6ae)
- 2021-06-02: [`media: st-hva: Fix potential NULL pointer dereferences`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b7fdd208687ba59ebfb09b2199596471c63b69e3)
- 2021-06-02: [`media: v4l: cadence: Handle errors of clk_prepare_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=cca65f64045523f923380171bf6d329bfd79970f)
- 2021-06-02: [`media: v4l: cadence: Handle errors of clk_prepare_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e6001f6922cfda7b76f594595ebb38351c313da2)
- 2021-05-24: [`net: appletalk: cops: Fix data race in cops_probe1`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a4dd4fc6105e54393d637450a11d4cddb5fabc4f)
- 2021-03-10: [`net: pxa168_eth: Fix a potential data race in pxa168_eth_remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0571a753cb07982cc82f4a5115e0b321da89e1f3)
- 2020-12-10: [`mtd: plat-ram: correctly free memory on error path in platram_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=8c293f545419c0d3da9a2a70df0311aa4027a820)
- 2020-12-03: [`media: s5p-jpeg: handle error condition in s5p_jpeg_probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0862d95b437b7687622bfc274e410549853825c3)
- 2020-11-16: [`media: isif: reset global state`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6651dba2bd838f34cf5a1e84229aaa579b1a94fe)
- 2020-11-16: [`media: zr364xx: propagate errors from zr364xx_start_readpipe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=af0321a5be3e5647441eb6b79355beaa592df97a)
- 2020-10-27: [`usb: gadget: goku_udc: fix potential crashes in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0d66e04875c5aae876cf3d4f4be7978fa2b00523)
- 2020-10-14: [`drivers: watchdog: rdc321x_wdt: Fix race condition bugs`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4b2e7f99cdd314263c9d172bc17193b8b6bba463)
- 2020-09-30: [`mtd: rawnand: vf610: disable clk on error handling path in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=cb7dc3178a9862614b1e7567d77f4679f027a074)
- 2020-09-27: [`media: dvb-frontends: rtl2832_sdr: set error code in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ce5d72b6f5a0b694b19cd812788d8e1ea49aea21)
- 2020-09-08: [`fbdev: sm712fb: handle ioremap() errors in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=bcee1609ba9623f35597f06a2ad118ac4ade2974)
- 2020-09-07: [`mmc: via-sdmmc: Fix data race bug`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=87d7ad089b318b4f319bf57f1daa64eb6d1d10ad)
- 2020-08-25: [`drivers/dma/dma-jz4780: Fix race condition between probe and irq handler`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6d6018fc30bee67290dbed2fa51123f7c6f3d691)
- 2020-08-23: [`drm/brige/megachips: Add checking if ge_b850v3_lvds_init() is working correctly`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f688a345f0d7a6df4dd2aeca8e4f3c05e123a0ee)
- 2020-08-21: [`crypto: picoxcell - Fix potential race condition bug`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=64f4a62e3b17f1e473f971127c2924cae42afc82)
- 2020-08-18: [`USB: lvtest: return proper error code in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=531412492ce93ea29b9ca3b4eb5e3ed771f851dd)
- 2020-08-06: [`media: camss: fix memory leaks on error handling paths in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f45882cfb152f5d3a421fd58f177f227e44843b9)
- 2020-08-06: [`media: davinci: vpif_capture: fix potential double free`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=602649eadaa0c977e362e641f51ec306bc1d365d)
- 2020-07-24: [`usb: gadget: net2280: fix memory leak on probe error handling paths`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2468c877da428ebfd701142c4cdfefcfb7d4c00e)
- 2020-07-24: [`usb: gadget: net2272: skip BAR1 on error handling paths in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ae90cc8237bf4ee416a326c51052ddcc7918ee43)
- 2020-07-19: [`media: vpss: clean up resources in init`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=9c487b0b0ea7ff22127fe99a7f67657d8730ff94)
- 2020-07-10: [`fbdev: sm712fb: set error code in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=19e55a87ad621b1ccba52ba781d29d97220154de)
- 2020-07-10: [`fbdev: da8xx-fb: go to proper label on error handling paths in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=80a00e90dedec514686ac1eb7e7b8e60e1d9aec9)
- 2020-07-10: [`video: fbdev: neofb: fix memory leak in neo_scan_monitor()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=edcb3895a751c762a18d25c8d9846ce9759ed7e1)
- 2020-07-10: [`video: fbdev: savage: fix memory leak on error handling path in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e8d35898a78e34fc854ed9680bc3f9caedab08cd)
- 2020-07-09: [`usb: gadget: udc: gr_udc: fix memleak on error handling path in gr_ep_init()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c8f8529e2c4141afa2ebb487ad48e8a6ec3e8c99)
- 2020-07-05: [`hwmon: (aspeed-pwm-tacho) Avoid possible buffer overflow`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=bc4071aafcf4d0535ee423b69167696d6c03207d)
- 2020-07-04: [`media: rc: return proper error code on error handling path in init`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3b4cfc6966ecaefdf46a1369923a55e7bdc86d19)
- 2020-06-25: [`staging: rts5208: fix memleaks on error handling paths in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=11507bf9a8832741db69efd32bf09a2ab26426bf)
- 2020-06-25: [`staging: kpc2000: kpc_dma: set error code in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=8ce8668bfb64f2973cc1276c54619aceede6498a)
- 2020-06-04: [`rapidio: avoid data race between file operation callbacks and mport_cdev_add().`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e1c3cdb26ab881b77486dc50370356a349077c74)
- 2020-04-23: [`drivers: char: tlclk.c: Avoid data race between init and interrupt handler`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=44b8fb6eaa7c3fb770bf1e37619cdb3902cca1fc)
- 2020-04-23: [`dmaengine: pch_dma.c: Avoid data race between probe and irq handler`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2e45676a4d33af47259fa186ea039122ce263ba9)
- 2020-04-16: [`usb: host: u132-hcd: Remove u132_static_list and list head u132_list`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=48ce9e4119ce24131d188746118e948e9e97fc1d)
- 2019-04-25: [`mwl8k: fix error handling in mwl8k_post_cmd()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d1717282afd54a34f01628e5a4559f913c6b0317)
- 2019-02-17: [`net: mv643xx_eth: disable clk on error path in mv643xx_eth_shared_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e928b5d6b75e239feb9c6d5488974b6646a0ebc8)
- 2019-02-01: [`soc: qcom: gsbi: Fix error handling in gsbi_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=8cd09a3dd3e176c62da67efcd477a44a8d87185e)
- 2019-01-28: [`usb: dwc3: exynos: Fix error handling of clk_prepare_enable`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=512e6fb589bc18f9321457632e89b95017447db9)
- 2019-01-27: [`net: stmmac: dwmac-rk: fix error handling in rk_gmac_powerup()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c69c29a1a0a8f68cd87e98ba4a5a79fb8ef2a58c)
- 2019-01-16: [`media: tw9910: fix failure handling in tw9910_power_on()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d6b10dd0017641fee31daa84e478708a33d2f00a)
- 2018-12-20: [`video: clps711x-fb: release disp device node in probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=fdac751355cd76e049f628afe6acb8ff4b1399f7)
- 2018-12-03: [`media: DaVinci-VPBE: fix error handling in vpbe_initialize()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=aa35dc3c71950e3fec3e230c06c27c0fbd0067f8)
- 2018-11-23: [`media: mtk-vcodec: Release device nodes in mtk_vcodec_init_enc_pm()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=8ea0f2ba0fa3f91ea1b8d823a54b042026ada6b3)
- 2018-11-09: [`mac80211_hwsim: fix module init error paths for netlink`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=05cc09de4c017663a217630682041066f2f9a5cd)
- 2018-10-22: [`watchdog: ts4800: release syscon device node in ts4800_wdt_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=cd6ba41c192deca20d9add5554bc8c51d0f07de2)
- 2018-10-02: [`staging: axis-fifo: add error handling of class_create()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a24b420bb30e4baea66f4467fdcdabb456e30993)
- 2018-09-22: [`iio: adc: imx25-gcq: Fix leak of device_node in mx25_gcq_setup_cfgs()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d3fa21c73c391975488818b085b894c2980ea052)
- 2018-09-18: [`serial: mxs-auart: Fix potential infinite loop`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5963e8a3122471cadfe0eba41c4ceaeaa5c8bb4d)
- 2018-09-17: [`spi: pic32-sqi: remove unnecessary of_node_get()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3356d9f4cb45b1aef3dd4b1a6ea9ceaca0f68a53)
- 2018-09-07: [`spi: pic32: remove unnecessary of_node_get()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b9a947dd756b7af84ababa57e0524788f91a5382)
- 2018-08-31: [`media: ov772x: Disable clk on error path`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=1d18c2cd9d38ad639b2e00546b9ee638f2cef4b0)
- 2018-08-30: [`clk: cdce925: release child device nodes`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0b85de7cef013eeaf5cc873f0fd127ccfc2413be)
- 2018-08-29: [`gpio: dwapb: Fix error handling in dwapb_gpio_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a618cf4800970d260871c159b7eec014a1da2e81)
- 2018-08-29: [`usb: gadget: fotg210-udc: Fix memory leak of fotg210-&gt`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c37bd52836296ecc9a0fc8060b819089aebdbcde)
- 2018-08-10: [`pinctrl: axp209: Fix NULL pointer dereference after allocation`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=504c76979bccec66e4c2e41f6a006e49e284466f)
- 2018-08-10: [`drm: qxl: Fix NULL pointer dereference at qxl_alloc_client_monitors_config`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=66e0c8a5bcfd292606a70268376b44b468c316e8)
- 2018-08-10: [`drm: qxl: Fix error handling at qxl_device_init`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5043348a4969ae1661c008efe929abd0d76e3792)
- 2018-08-02: [`media: davinci: vpif_display: Mix memory leak on probe error path`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=61e641f36ed81ae473177c085f0bfd83ad3b55ed)
- 2018-08-02: [`media: vimc: Remove redundant free`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b9f0f653ea2c214933b16884bd40baf26ff61895)
- 2018-08-02: [`media: dm1105: Limit number of cards to avoid buffer over read`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=65b40a986fc68cb3b362bb855303b73a2b8538c2)
- 2018-08-02: [`media: dw2102: Fix memleak on sequence of probes`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=299c7007e93645067e1d2743f4e50156de78c4ff)
- 2018-08-02: [`HID: intel_ish-hid: tx_buf memory leak on probe/remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=50fa92594a2bc76265f4bb357f9a25dd3bdb2c0a)
- 2018-08-02: [`misc: ti-st: Fix memory leak in the error path of probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=81ae962d7f180c0092859440c82996cccb254976)
- 2018-08-02: [`firmware: vpd: Fix section enabled flag on vpd_section_destroy`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=45ca3f76de0507ecf143f770570af2942f263812)
- 2018-08-02: [`tty: rocket: Fix possible buffer overwrite on register_PCI`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0419056ec8fd01ddf5460d2dba0491aad22657dd)
- 2018-07-30: [`scsi: 3ware: fix return 0 on the error path of probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4dc98c1995482262e70e83ef029135247fafe0f2)
- 2018-07-30: [`ASoC: tegra_alc5632: fix device_node refcounting`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4321723648b0abb456f7a9af51bb09a4ec60799d)
- 2018-07-30: [`can: ems_usb: Fix memory leak on ems_usb_disconnect()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=72c05f32f4a5055c9c8fe889bb6903ec959c0aad)
- 2018-07-30: [`regulator: tps65217: Fix NULL pointer dereference on probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4f919ca2bf6da826ba1a4316e1b8e9c94e5dbeb2)
- 2018-07-29: [`gpio: ml-ioh: Fix buffer underwrite on probe error path`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4bf4eed44bfe288f459496eaf38089502ef91a79)
- 2018-07-28: [`net: mdio-mux: bcm-iproc: fix wrong getter and setter pair`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b0753408aadf32c7ece9e6b765017881e54af833)
- 2018-07-24: [`video: goldfishfb: fix memory leak on driver remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5958fde72d04e7b8c6de3669d1f794a90997e3eb)
- 2018-07-11: [`sample: vfio-mdev: avoid deadlock in mdev_access()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=498e8bf51c633cc4496343e6113f340f8e9301ae)
- 2018-07-06: [`uwb: hwa-rc: fix memory leak at probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=11b71782c1d10d9bccc31825cf84291cd7588a1e)
- 2018-07-04: [`media: fsl-viu: fix error handling in viu_of_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=662a99e145661c2b35155cf375044deae9b79896)
- 2018-06-28: [`power: reset: zx-reboot: put device node in zx_reboot_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f052df96c46dbe52fbacd02189e7906f41686f27)
- 2018-06-28: [`media: tc358743: release device_node in tc358743_probe_of()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=64bac6916ef7d9cc57367893aea1544fcad91b9b)
- 2018-06-22: [`mtd: spi-nor: nxp-spifi: release flash_np in nxp_spifi_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=38ebbe2b7282e985a7acc862892564e8fbbde866)
- 2018-06-18: [`ASoC: tegra: fix device_node refcounting`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7c5dfd549617b87db8e891ff4ecaa4a582b6c4cc)
- 2018-06-18: [`ASoC: rockchip: put device_node on remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a56df73ba5960848f60f609c68770d2638bf1dd5)
- 2018-06-17: [`staging: rts5208: add error handling into rtsx_probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=70ce2440e20833d1b08222749cba780291a66e30)
- 2018-05-14: [`w1: mxc_w1: Enable clock before calling clk_get_rate() on it`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=955bc61328dc0a297fb3baccd84e9d3aee501ed8)
- 2018-05-08: [`i2c: axxia: enable clock before calling clk_get_rate()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e6faa71034f6d0692a3a20d6b55565a36b6b8156)
- 2018-05-04: [`spi: pxa2xx: check clk_prepare_enable() return value`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=62bbc864d1946c715063bd481bff3641fd1324e2)
- 2018-05-02: [`spi: meson-spicc: Fix error handling in meson_spicc_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ded5fa4e8bac25612caab8f0822691308a28a552)
- 2018-04-26: [`spi/bcm63xx-hspi: Enable the clock before calling clk_get_rate().`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0d7412ed1f5dc0858eb4f29650a8c9c5cce8b285)
- 2018-04-25: [`sc16is7xx: Check for an error when the clock is enabled.`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e76785d092ab8356d24996754f0ff1917021fcb6)
- 2018-04-17: [`spi: stm32: Fix error handling in stm32_spi_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3dbb3eef91fdb246c7d366b960fe37b66af8ffa9)
- 2018-03-26: [`watchdog: davinci_wdt: fix error handling in davinci_wdt_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d66e53649c18377edc08d48901e658e4fd491d46)
- 2018-03-18: [`spi: jcore: disable ref_clk after getting its rate`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7c2861a6fb2c502d7b7aa85415e178f3c527a468)
- 2018-03-16: [`phy: lpc18xx-usb-otg: error handling in lpc18xx_usb_otg_phy_power_on()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=124380cb0e7a5fb704a81d135e5b7b4904c1ef95)
- 2018-03-13: [`watchdog: sprd_wdt: Fix error handling in sprd_wdt_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3c578cd4bc52b6e65d65be1abad9a8aa489ec207)
- 2018-03-09: [`serial: mxs-auart: disable clks of Alphascale ASM9260`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ca7c22fc9e8d16b11b8be81254d5f59c5a9f5bcf)
- 2018-03-03: [`watchdog: asm9260_wdt: fix error handling in asm9260_wdt_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3c829f47e33eb0398a9a14e357a05199a7be0277)
- 2018-02-14: [`media: rc: ir-hix5hd2: fix error handling of clk_prepare_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=de5b22d98705a4c103492e36a5220faca5a2d0a0)
- 2018-02-12: [`mtd: nand: vf610: check mtd_device_register() return code`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=1b8c90985f59ccd8a1adb723b58b42628b36e668)
- 2018-01-26: [`crypto: picoxcell - Fix error handling in spacc_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2d55807b7f7bf62bb05a8b91247c5eb7cd19ac04)
- 2018-01-13: [`thermal: int3400_thermal: fix error handling in int3400_thermal_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0be86969ae385c5c944286bd9f66068525de15ee)
- 2017-12-21: [`clk: si5351: implement remove handler`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=758231d5a80a784d60ce7c96b27f8771ca4c682b)
- 2017-12-20: [`RDMA/ocrdma: Fix permissions for OCRDMA_RESET_STATS`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=744820869166c8c78be891240cf5f66e8a333694)
- 2017-12-18: [`rtc: omap: fix unbalanced clk_prepare_enable/clk_disable_unprepare`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2da6877f0e2ced7825a31556ada6b2ac2e50877f)
- 2017-12-18: [`media: s5p-jpeg: Fix off-by-one problem`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b6852a6dda2cfc16faf48ca075c120d2a3ba6b04)
- 2017-12-18: [`net: phy: xgene: disable clk on error paths`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ab14436065c8066c265540312742390d6d07ddd2)
- 2017-12-18: [`media: pxa_camera: disable and unprepare the clock source on error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=9392483122e8818c0bf38e82ccf01b71e0c2151e)
- 2017-12-18: [`fpga: socfpga-a10: disable clk on error in socfpga_a10_fpga_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d9cc5a0edb705ced4ce91b4c6ee73ec6f5bfa49a)
- 2017-12-15: [`tty: serial: mxs-auart: fix error handling in mxs_auart_probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5c3055393f5fdd0bdc4b69b1fb362b1c3f4266b4)
- 2017-12-15: [`serial: 8250_dw: Disable clock on error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=8af016aa5a27c6a2505460eb4d83f1e70c38dc43)
- 2017-12-15: [`dmaengine: fsl-edma: disable clks on all error paths`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2610acf46b9ed528ec2cacd717bc9d354e452b73)
- 2017-12-13: [`spi: jcore: disable clock when registering spi conroller failed`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=16eab16ef9382704ff12c68ef52d62c68219cbb9)
- 2017-12-13: [`net: ethernet: arc: fix error handling in emac_rockchip_probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2a9ee696c72a24d63529c76483fcd92d04b1d2b7)
- 2017-12-11: [`usb: dwc3: of-simple: fix missing clk_disable_unprepare`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ded600ea9fb51a495d2fcd21e90351df876488e8)
- 2017-12-11: [`dmaengine: jz4740: disable/unprepare clk if probe fails`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=eb9436966fdc84cebdf222952a99898ab46d9bb0)
- 2017-12-08: [`media: v4l: mt9v032: Disable clock on error paths`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7df66d778317353c94c3a2832cd26e320ca28b7d)
- 2017-12-07: [`net: ethernet: arc: fix error handling in emac_rockchip_probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e46772a6946a7d1f3fbbc1415871851d6651f1d4)
- 2017-12-07: [`net: mvmdio: disable/unprepare clocks in EPROBE_DEFER case`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=589bf32f09852041fbd3b7ce1a9e703f95c230ba)
- 2017-12-07: [`spi: sun6i: disable/unprepare clocks on remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2d9bbd02c54094ceffa555143b0d68cd06504d63)
- 2017-12-07: [`spi: sun4i: disable clocks in the remove function`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c810daba0ab5226084a56893a789af427a801146)
- 2017-12-06: [`ASoC: rockchip: disable clock on error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c7b92172a61b91936be985cb9bc499a4ebc6489b)
- 2017-11-29: [`rtc: brcmstb-waketimer: fix error handling in brcmstb_waketmr_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f2eef045de9defbc6fc6b72b17f0941cbe26c81d)
- 2017-11-08: [`w1: keep balance of mutex locks and refcnts`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f53459c00871a7c3db5b69b49d840ca9d497a695)
- 2017-11-06: [`mtd: plat-ram: Replace manual resource management by devm`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2e442aebed99fd27eaa4e3539d9c50ef1cc67013)
- 2017-10-24: [`usb: phy: tahvo: fix error handling in tahvo_usb_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ce035409bfa892a2fabb89720b542e1b335c3426)
- 2017-10-24: [`mfd: mxs-lradc: Fix error handling in mxs_lradc_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=362741a21a5c4b9ee31e75ce28d63c6d238a745c)
- 2017-10-12: [`misc: ibmasm: Return error on error path`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f403f85f5334fb169d5c00deac106f140b62d3c9)
- 2017-09-18: [`serial: sccnxp: Fix error handling in sccnxp_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c91261437985d481c472639d4397931d77f5d4e9)
- 2017-09-11: [`Input: ucb1400_ts - fix suspend and resume handling`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=39467fc1054a91efa697162a94e5b0e1a4b7b580)
- 2017-08-28: [`parport: use release_mem_region instead of release_resource`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=ed779b275b27bea231dae0aebd048d72ff5a010d)
- 2017-08-27: [`media: dvb-usb: Add memory free on error path in dw2102_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=be90cc8e4ac08bcb4ca517cd4ae25aa8441e2d88)
- 2017-08-25: [`dmaengine: rcar-dmac: initialize all data before registering IRQ handler`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5e857047ba1e748002088bf44b6b0873664d9567)
- 2017-08-21: [`dmaengine: qcom_hidma: avoid freeing an uninitialized pointer`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a63efead7f8eeefcf08e4e7d0b033ac552f7da23)
- 2017-08-21: [`video: fbdev: udlfb: Fix use after free on dlfb_usb_probe error path`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7af9a52e33ea07937fc216104e2cf3d4e690b43f)
- 2017-08-18: [`USB: Gadget core: fix inconsistency in the interface tousb_add_gadget_udc_release()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=afd7fd81f22bf90474216515dbd6088f9bd70343)
- 2017-08-15: [`loop: fix to a race condition due to the early registration of device`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a8c1d064d3e80aa9e3ca39e908391e433cc53f78)
- 2017-08-15: [`ASoC: samsung: i2s: Null pointer dereference on samsung_i2s_remove`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7b814a7d4e83b0917efef9dd11a8c095371f987c)
- 2017-08-14: [`i2c: simtec: use release_mem_region instead of release_resource`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=42543aeb48e3701b49e0a83654248afc38feb88f)
- 2017-08-13: [`hwmon: (stts751) buffer overrun on wrong chip configuration`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3be6bd690da0dafa55eb65279fb25297fcfe19d5)
- 2017-08-11: [`mISDN: Fix null pointer dereference at mISDN_FsmNew`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=54a6a043fb8580d5a741774669ef6049f402f228)
- 2017-08-11: [`wan: dscc4: add checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6aa200058e4df8a60681ddd67d7932fdf2ce58ab)
- 2017-08-07: [`hysdn: fix to a race condition in put_log_buffer`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b925ef37b0a152b0c06aa43bc9204d0116f676d7)
- 2017-07-30: [`drivers/serial: Do not leave sysfs group in case of error in aspeed_vuart_pro...`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=cbafe9d5c346735d6ac5d5c905fd9c215fbbb941)
- 2017-07-30: [`serial: 8250: fix error handling in of_platform_serial_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=fa9ba3acb557e444fe4a736ab654f0d0a0fbccde)
- 2017-07-21: [`platform/x86: wmi: Fix error handling in acpi_wmi_init()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=972777171f33f9932f51feebe42dbcc1b475d01a)
- 2017-07-12: [`smsc911x: Add check for ioremap_nocache() return code`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=57fe14790b88122fb34b68308b9aa9a643457ea7)
- 2017-07-04: [`vmlfb: Fix error handling in cr_pll_init()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6af574e826740bf17663b48ba3f8fadb81d2113f)
- 2017-06-24: [`x86/paravirt: Remove unnecessary return from void function`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e8ad8bc403f49f8cb95448acfdeee39b459eded4)
- 2017-05-28: [`staging: iio: ad7152: Fix deadlock in ad7152_write_raw_samp_freq()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=95264c8c6a9040e84edda883dbbe9d193c41f46c)
- 2017-05-22: [`net: atheros: atl2: don't return zero on failure path in atl2_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=bd703a1524e851b8d6d646be9dafd794d4eb6045)
- 2017-05-18: [`serial: altera_jtaguart: adding iounmap()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5c9d6abed9e0a061de252a53ab687a1171502e81)
- 2017-05-02: [`sm501fb: don't return zero on failure path in sm501fb_start()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=dc85e9a87420613b3129d5cc5ecd79c58351c546)
- 2017-04-24: [`mmc: sdhci-pxav2: add error handling of clk_prepare_enable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=21b22284619bbb201775c125af53f2834eb91674)
- 2017-04-11: [`usb: gadget: mv_u3d: fix error handling in mv_u3d_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=374a1020d21b238d566e523a3bfd8fd9ee628c6b)
- 2017-04-10: [`[media] m2m-deinterlace: don't return zero on failure paths in deinterlace_pr...`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=41309271448e559afe208f1e89d4d30b83259678)
- 2017-03-25: [`irda: vlsi_ir: fix check for DMA mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6ac3b77a6ffff7513ff86b684aa256ea01c0e5b5)
- 2017-03-16: [`z3fold: fix spinlock unlocking in page reclaim`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=271df90e4e530c17f237b27034d6341cb2c2f536)
- 2017-03-07: [`net/sched: act_skbmod: remove unneeded rcu_read_unlock in tcf_skbmod_dump`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6c4dc75c251721f517e9daeb5370ea606b5b35ce)
- 2017-03-07: [`mtd: spi-nor: hisi: do not ignore clk_prepare_enable() failure`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0a5165a83c624cddb3dfa227a9324acac9ec413c)
- 2017-02-13: [`mmc: wbsd: safer check if dma_addr is valid DMA address`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e81c022a00cd91b0d555d9d9194d421e3b8d642c)
- 2017-01-29: [`net: adaptec: starfire: add checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d1156b489fa734d1af763d6a07b1637c01bb0aed)
- 2017-01-04: [`backlight: adp5520: Fix error handling in adp5520_bl_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0eb3fba8c68275f0122f65f7316efaaf86448016)
- 2017-01-04: [`vfio-mdev: fix some error codes in the sample code`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d293dbaa540b5800817cc10832d764b17cc211b5)
- 2016-12-14: [`IB/isert: do not ignore errors in dma_map_single()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=def4a6ffc9d178d6bb14178f56873c4831fb05a7)
- 2016-12-05: [`adm80211: add checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d15697de60db5570532fdedb8e13b2251d65b8e3)
- 2016-11-29: [`uio: pruss: add clk_disable()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e663c5dbad2999aa824045c8e01fed459d1fc833)
- 2016-11-29: [`mmc: wbsd: implement check for dma mapping error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=a5488a35bae7e607224275c4c1b807d0d352354f)
- 2016-11-19: [`net: macb: add check for dma mapping error in start_xmit()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=178c7ae944444c198a1d9646477ab10d2d51f03e)
- 2016-11-08: [`usb: gadget: mv_u3d: add check for dma mapping error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6ffd65154e23a4cf5d2da400e0fa7142a4474b98)
- 2016-10-26: [`SoC: mxs-saif: check validity of ids in mxs_saif_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e1b790a8720192e1cfdd46a9b20d0f56de99c73d)
- 2016-10-15: [`vmxnet3: avoid assumption about invalid dma_pa in vmxnet3_set_mc()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=fb5c6cfaec126d9a96b9dd471d4711bf4c737a6f)
- 2016-10-09: [`firewire: nosy: do not ignore errors in ioremap_nocache()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6449e31ddebdce68508cfaf0915d31aad3835f4f)
- 2016-10-03: [`net: mvmdio: do not clk_disable_unprepare() NULL clock`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f814bfd765218908b23e21ca7f0b6f403fb88972)
- 2016-09-24: [`i2c: axxia: disable clks in case of failure in probe`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=662786a5429c3a992c6f884a647ee32424822358)
- 2016-09-19: [`rapidio/rio_cm: avoid GFP_KERNEL in atomic context`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b92ae139c308c5223521ed6ec022148b81312809)
- 2016-09-16: [`IB/rxe: fix GFP_KERNEL in spinlock context`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5e102b3b4fa944815aead89e63eec2a35069a07b)
- 2016-09-12: [`speakup: Add spinlock in synth_direct_store`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=777953182ea9a750e744bd0a50fb8893cd061397)
- 2016-09-09: [`dwc_eth_qos: do not register semi-initialized device`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=47b02f7294a483387772a46931da942b2ca9d845)
- 2016-09-03: [`wl3501_cs: Add spinlock to wl3501_reset`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=bd6b0242652a8a284eed2adec5ac1fc043b8f2ef)
- 2016-08-29: [`usb: gadget: goku_udc: fix memory leak in goku_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2a334cfaf393187d592999d1039135e000a68e9a)
- 2016-08-15: [`i2c: ocores: add missed clk_disable_unprepare() on failure paths`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=97ccd4af120c6ee183f424f17672870809bd6efd)
- 2016-07-26: [`ide-tape: fix misprint in failure handling in idetape_init()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=79f18a0637033f588accaa05621225c60301514a)
- 2016-07-19: [`i2c: efm32: fix a failure path in efm32_i2c_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7dd91d52a813f99a95d20f539b777e9e6198b931)
- 2016-07-12: [`drm_aux-dev: fix error handling in drm_dp_aux_dev_init()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=da82ee99eef9817416ea9b8a23973da062d5c8fe)
- 2016-07-08: [`[media] bt8xx: remove needless module refcounting`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=654043f002b5ec954aef5baafeb37b3158b0352d)
- 2016-07-05: [`rtlwifi: rtl8723ae: Fix potential race condition`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=4f29b348bdc08e6a30242f0d14d6672019ffd1bb)
- 2016-07-05: [`rtlwifi: rtl8723be: Fix potential race condition`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=31c2e76c77fba56bd52d704802dd63aafabd5320)
- 2016-07-05: [`rtlwifi: rtl8192ee: Fix potential race condition`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c3ae8ec4a26468f4b1a0b329ca9f57d19be32be8)
- 2016-07-05: [`rtlwifi: rtl8188ee: Fix potential race condition`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=204e2ab22e1e2d0eb7b4cb929bc4b417226474b8)
- 2016-07-05: [`rtlwifi: rtl8821ae: Fix potential race condition`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=300c32ca84f5006ccbbf37f5207b6311aeccc5c8)
- 2016-06-29: [`libertas: Add spinlock to avoid race condition`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f52b041aed77592862c97726b98d78e8dccd72c9)
- 2016-06-28: [`[media] radio-maxiradio: fix memory leak when device is removed`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=04bc936591469433b6ad3b16b04e07cb1b86690a)
- 2016-06-23: [`act_ife: only acquire tcf_lock for existing actions`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=067a7cd06f7bf860f2e3415394b065b9a0983802)
- 2016-04-29: [`mptsas: fix checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=1354379b13f190ae5da21c26836a16ba56566ab3)
- 2016-04-19: [`USB: whci-hcd: add more checks for dma mapping error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e352506e8a871890278ba66a2d77167193ffbfa9)
- 2016-03-18: [`mtip32xx: fix checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5173cb814b36439a9d9537016965e75798b9f130)
- 2016-03-04: [`usb: gadget: bdc_udc: fix race condition in bdc_udc_exit()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=cff5638ef7852196879f9687e70d49ea291bbb33)
- 2016-02-23: [`be2iscsi: add checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e0493627c32f7d04683c44d195c0f3e1fc4678d4)
- 2016-02-08: [`mmc: mmc_spi: add checks for dma mapping error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b00663124c76f69e71d118d778842471e85c6f11)
- 2016-02-06: [`tty: synclinkmp: do not ignore errors in probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b1209983d2c012be8d253ed118f9281ed9f46af6)
- 2016-01-07: [`ipw2x00: add checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f7b7caa488eb209f1c63cc98104407c62753e406)
- 2015-12-31: [`prism54: fix checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=49f2a47d913184b97ef84b2e4fd438dbee341487)
- 2015-12-19: [`natsemi: add checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=45af55006c2c8f49bddc6296224e70d752a1372c)
- 2015-12-11: [`nfit: acpi_nfit_notify(): Do not leave device locked`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=d91e892825ae6f0ed4f8b07ae5d348eff86ab2ea)
- 2015-12-01: [`USB: whci-hcd: add check for dma mapping error`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f9fa1887dcf26bd346665a6ae3d3f53dec54cba1)
- 2015-12-01: [`vmxnet3: fix checks for dma mapping errors`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=5738a09d58d5ad2871f1f9a42bf6a3aa9ece5b3c)
- 2015-11-19: [`[media] lirc_imon: do not leave imon_probe() with mutex held`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=b833d0df943d70682e288c38c96b8e7bfff4023a)
- 2015-09-14: [`usb: gadget: amd5536udc: fix error handling in udc_pci_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6527cc27761a124de8c08e6488ce17fdcc74dbba)
- 2015-08-18: [`mtd: nettel: do not ignore mtd_device_register() failure in nettel_init()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=11c7e0e2f91fdfdf9f7b4d107bc93d6c298c95fe)
- 2015-08-17: [`gpio/grgpio: fix deadlock in grgpio_irq_unmap()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7fa25937542358bfa01ef5c5a1e9a00bd164c000)
- 2015-08-12: [`bfa: fix leak of bfad_im_port_index on module unload`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=3ff448b5b7dc7ad4d664588c343da1e5e2ce18dd)
- 2015-05-12: [`iio: light: hid-sensor-prox: Fix memory leak in probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=f0828ba96d02d4d4b197c531b34c662ee3c928df)
- 2015-05-01: [`[media] marvell-ccic: fix memory leak on failure path in cafe_smbus_setup()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=90ca75fd1945d9e51e21cbde0aae1aad68730dc5)
- 2015-04-17: [`dmaengine: pch_dma: fix memory leak on failure path in pch_dma_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=12d7b7a23694b4d3dba58d7ae971ee9120a617e5)
- 2015-03-02: [`[media] sh_vou: fix memory leak on error paths in sh_vou_open()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=2160abb2945831aaf50d176ef6d070bdbd19130d)
- 2015-02-26: [`i40e: Fix memory leak at failure path in i40e_dbg_command_write()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=dda094a312dbb2cd96e3e46fce7784aca999bcf1)
- 2014-12-24: [`rsi: fix memory leak in rsi_load_ta_instructions()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=eae79b4f3e82ca63a53478a161b190a0d38fe526)
- 2014-11-18: [`can: esd_usb2: fix memory leak on disconnect`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=efbd50d2f62fc1f69a3dcd153e63ba28cc8eb27f)
- 2014-11-06: [`m501fb: don't return zero on failure path in sm501fb_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=816764859a5347315cb2f1578cf0252ee129c128)
- 2014-10-05: [`dm log userspace: fix memory leak in dm_ulog_tfr_init failure path`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=56ec16cb1e1ce46354de8511eef962a417c32c92)
- 2014-07-29: [`isdn/bas_gigaset: fix a leak on failure path in gigaset_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=86b7987dd7a8acbaa54a446a73e2431da88b3ca1)
- 2014-07-04: [`[media] tlg2300: fix leak at failure path in poseidon_probe()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=e7d40c37215b2048685e72a0bb0101578c2b0a62)
- 2014-06-19: [`staging: line6: do not return 0 from probe if no initialization done`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c7f268df3f4e80513271aea8e91f3fd0701aae1b)
- 2014-04-16: [`USB: cdc-acm: fix double usb_autopm_put_interface() in acm_port_activate()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=070c0b17f6a1ba39dff9be112218127e7e8fd456)
- 2013-11-29: [`[media] dvb_demux: fix deadlock in dmx_section_feed_release_filter()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=6633327d59067fe16128d66968cd50a10ca7a09c)
- 2013-03-28: [`drbd: add module_put() on error path in drbd_proc_open()`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=193d01532a730a53cbc74462799dbc43968b97fd)
- 2012-03-08: [`[media] staging: go7007: fix mismatch in mutex lock-unlock in [read|write]_re...`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=0c07aec31a98a63ee83f2bbad4a2fab0e0f58d33)
