<!--
This file is part of CPAchecker,
a tool for configurable software verification:
https://cpachecker.sosy-lab.org

SPDX-FileCopyrightText: 2007-2020 Dirk Beyer <https://www.sosy-lab.org>

SPDX-License-Identifier: Apache-2.0
-->

# CPAchecker Documentation

## General

- Achievements of the project
  - [Achievements](Achievements.md)
  - [Competitions and Medals](https://cpachecker.sosy-lab.org/achieve.php)
- [Mailing](Mailing.md)
- References
  - [List of Publications](https://cpachecker.sosy-lab.org/publications.php) generated from the below bib file
  - [Bib file](cpachecker.bib): Please add work based on CPAchecker

## Using CPAchecker

- [Benchmarking](Benchmark.md) CPAchecker with [BenchExec](https://github.com/sosy-lab/benchexec)
- [Configuring](Configuration.md) CPAchecker's analyses
  - [List of Configuration Options](ConfigurationOptions.txt)
- [Report](Report.md)
- Specifications
  - [Automata](SpecificationAutomata.md)
  - LTL
  - [Properties used in SV-COMP](https://gitlab.com/sosy-lab/benchmarking/sv-benchmarks/-/tree/main/c/properties)
      (mostly supported by CPAchecker)
- [Tutorials](tutorials)
  - [Examples](examples) for tutorials

## Developing with CPAchecker

- [Developing](Developing.md)
- [Logging](Logging.md)
- [Profiling](Profile.md)
- Style Guides for CPAchecker
  - [Java](StyleGuide.md)
  - [Python](PythonStyleGuide.md)
  - [for Report Template](ReportTemplateStyleGuide.md)
- Testing
  - [Javascript Testing](JavascriptTesting.md)
  - [Testing](Test.md)
- [Version Control](VersionControl.md)

