/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.gui.controls.TextControl_;
import org.dbgl.gui.dialog.BrowseArchiveDialog;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.ImageMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.conf.mount.PhysFsMount;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ITextService;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class Button_ {
    public static final String DATA_CANONICALIZER = "canonicalizer";
    public static final String DATA_COMBO = "combo";
    public static final String DATA_ALT_CONTROL = "altControl";
    public static final String DATA_CONTROL = "control";
    private final Button button_;

    private Button_(final Builder builder, TextControl_ textControl) {
        this.button_ = new Button(builder.composite_, builder.style_);
        this.button_.setEnabled(builder.enabled_);
        if (DarkTheme.forced()) {
            this.button_.setBackground(builder.composite_.getBackground());
            this.button_.setForeground(DarkTheme.defaultForeground);
        }
        this.button_.setLayoutData(builder.layoutData());
        if (builder.tooltip_ != null) {
            this.button_.setToolTipText(builder.tooltip_);
        }
        if (builder.text_ != null) {
            this.button_.setText(builder.text_);
        }
        if (builder.image_ != null) {
            this.button_.setImage(builder.image_);
        }
        if (builder.selected_) {
            this.button_.setSelection(true);
        }
        if (builder.browseType_ != null) {
            this.button_.setData(DATA_CONTROL, (Object)textControl);
            this.button_.setData(DATA_ALT_CONTROL, null);
            this.button_.setData(DATA_COMBO, null);
            this.button_.setData(DATA_CANONICALIZER, (Object)builder.canonicalizer_);
            builder.listener_ = (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextControl_ control = (TextControl_)Button_.this.button_.getData(Button_.DATA_CONTROL);
                    Text altControl = (Text)Button_.this.button_.getData(Button_.DATA_ALT_CONTROL);
                    Combo combo = (Combo)Button_.this.button_.getData(Button_.DATA_COMBO);
                    String result = null;
                    File filterPath = null;
                    String[] filenames = null;
                    Button_.this.button_.getShell().setEnabled(false);
                    String rawFilterPath = Button_.filterPath(builder, control, altControl);
                    File fpath = new File(rawFilterPath);
                    if (!fpath.isDirectory()) {
                        fpath = fpath.getParentFile();
                    }
                    if (builder.browseType_ == BrowseType.DIR) {
                        DirectoryDialog dialog = new DirectoryDialog(Button_.this.button_.getShell());
                        if (fpath != null) {
                            dialog.setFilterPath(fpath.getPath());
                        }
                        result = dialog.open();
                    } else if (builder.browseType_ == BrowseType.FILE && (builder.browseCanonicalType_ == CanonicalType.EXE || builder.browseCanonicalType_ == CanonicalType.INSTALLER) && (FilesUtils.isArchive(rawFilterPath) || FilesUtils.isCdImageFile(rawFilterPath) || FilesUtils.isFatImage(rawFilterPath))) {
                        result = rawFilterPath;
                    } else if (builder.browseType_ == BrowseType.FILE) {
                        int style = builder.browseSave_ ? 8192 : (builder.browseCanonicalType_ == CanonicalType.CDIMAGE ? 4098 : 4096);
                        FileDialog dialog = new FileDialog(Button_.this.button_.getShell(), style);
                        if (fpath != null) {
                            dialog.setFilterPath(fpath.getPath());
                        }
                        ITextService text = TextService.getInstance();
                        String[] filterNames = null;
                        String[] filterExts = null;
                        switch (builder.browseCanonicalType_) {
                            case DOC: {
                                filterNames = new String[]{"*"};
                                filterExts = new String[]{"*"};
                                break;
                            }
                            case EXE: 
                            case DOSBOXEXE: 
                            case INSTALLER: {
                                filterNames = new String[]{text.get("filetype.applicable"), text.get("filetype.exe"), text.get("filetype.hdimage"), text.get("filetype.cdimage"), text.get("filetype.floppyimage"), text.get("filetype.archive"), "*"};
                                filterExts = new String[]{"*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.hdi;*.HDI;*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT", "*.hdi;*.HDI", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*.zip;*.ZIP;*.7z;*.7Z", "*"};
                                break;
                            }
                            case DOSBOX: 
                            case NATIVE_EXE: {
                                filterNames = new String[]{text.get("filetype.native_exe"), "*"};
                                filterExts = new String[]{FilesUtils.NATIVE_EXE_FILTER, "*"};
                                break;
                            }
                            case ZIP: {
                                filterNames = new String[]{text.get("filetype.archive"), "*"};
                                filterExts = new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*"};
                                break;
                            }
                            case DBGLZIP: {
                                filterNames = new String[]{text.get("filetype.gamepack"), "*"};
                                filterExts = new String[]{"*.dbgl.zip;*.DBGL.ZIP", "*"};
                                break;
                            }
                            case BOOTER: {
                                filterNames = new String[]{text.get("filetype.booterimage"), "*"};
                                filterExts = new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0;*.fdd;*.FDD;*.fdi;*.FDI;*.d88;*.D88;*.hdi;*.HDI;*.hdm;*.HDM", "*"};
                                break;
                            }
                            case DFEND: {
                                filterNames = new String[]{text.get("filetype.dfendprofile")};
                                filterExts = new String[]{"Profiles.dat"};
                                break;
                            }
                            case CDIMAGE: {
                                filterNames = new String[]{text.get("filetype.applicable"), text.get("filetype.hdimage"), text.get("filetype.cdimage"), text.get("filetype.floppyimage"), "*"};
                                filterExts = new String[]{"*.hdi;*.HDI;*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;", "*.hdi;*.HDI", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*"};
                                break;
                            }
                            case DOSBOXCONF: {
                                filterNames = new String[]{text.get("filetype.conf"), "*"};
                                filterExts = new String[]{"*.conf;*.CONF", "*"};
                                break;
                            }
                            case GLSHADER: {
                                filterNames = new String[]{text.get("filetype.glshader"), "*"};
                                filterExts = new String[]{"*.glsl;*.GLSL", "*"};
                                break;
                            }
                        }
                        if (filterNames != null) {
                            dialog.setFilterNames(filterNames);
                        }
                        if (filterExts != null) {
                            dialog.setFilterExtensions(filterExts);
                        }
                        if (builder.browseCanonicalType_ == CanonicalType.DFEND) {
                            dialog.setFileName("Profiles.dat");
                        }
                        result = dialog.open();
                        if (builder.browseCanonicalType_ == CanonicalType.CDIMAGE) {
                            filterPath = new File(dialog.getFilterPath());
                            filenames = dialog.getFileNames();
                        }
                    }
                    if (result != null && (result = Button_.getResult(Button_.this.button_.getShell(), builder, control, result, filterPath, filenames)) != null) {
                        String dir;
                        control.setText(result);
                        if (builder.browseCanonicalType_ == CanonicalType.DOSBOX && altControl != null) {
                            File confFile = new File(result, "dosbox.conf");
                            String confText = new FileLocation(confFile.getPath(), builder.canonicalizer_).getFile().getPath();
                            altControl.setText(confText);
                        } else if (builder.browseCanonicalType_ == CanonicalType.CDIMAGE && combo != null && filenames != null) {
                            if (FilesUtils.isCdImageFile((String)filenames[0])) {
                                combo.setText("iso");
                            } else if (FilesUtils.isFatImage((String)filenames[0])) {
                                combo.setText("floppy");
                            }
                        } else if (builder.browseCanonicalType_ == CanonicalType.NATIVE_EXE && altControl != null && (dir = new FileLocation(result, builder.canonicalizer_).getFile().getParent()) != null) {
                            altControl.setText(dir);
                        }
                    }
                    while (Button_.this.button_.getDisplay().readAndDispatch()) {
                    }
                    Button_.this.button_.getShell().setEnabled(true);
                }
            };
        }
        if (builder.grabListSource_ != null) {
            this.button_.setData(DATA_CONTROL, (Object)textControl);
            builder.listener_ = (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextControl_ control = (TextControl_)Button_.this.button_.getData(Button_.DATA_CONTROL);
                    int index = builder.grabListSource_.getSelectionIndex();
                    if (index == -1 && builder.grabListSource_.getItemCount() == 1) {
                        builder.grabListSource_.select(0);
                        index = 0;
                    }
                    if (index != -1) {
                        try {
                            Mount mnt = MountFactory.create(builder.grabListSource_.getItem(index));
                            if (builder.grabIsBooter_ && mnt instanceof ImageMount) {
                                control.setText(((ImageMount)mnt).getImgPaths()[0].getPath());
                            } else if (mnt instanceof DirMount) {
                                control.setText(((DirMount)mnt).getPath().getPath() + File.separatorChar);
                            } else if (mnt instanceof ImageMount) {
                                control.setText(((ImageMount)mnt).getImgPaths()[0].getPath() + File.separatorChar);
                            } else if (mnt instanceof PhysFsMount) {
                                control.setText(((PhysFsMount)mnt).getPath().getPath() + File.separatorChar);
                            }
                            control.selectAll();
                            control.setFocus();
                        }
                        catch (InvalidMountstringException invalidMountstringException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        if (builder.dispose_) {
            this.button_.addDisposeListener(e -> {
                this.button_.getImage().dispose();
                if (this.button_.getData("selectedImage") != null) {
                    ((Image)this.button_.getData("selectedImage")).dispose();
                }
            });
        }
        if (builder.listener_ != null) {
            this.button_.addSelectionListener(builder.listener_);
        }
    }

    public Button ctrl() {
        return this.button_;
    }

    private static String filterPath(Builder builder, TextControl_ control, Text altControl) {
        String path;
        String fieldValue = StringUtils.isBlank((CharSequence)control.getText()) && altControl != null ? altControl.getText() : control.getText();
        switch (builder.browseCanonicalType_) {
            case EXE: {
                File main;
                if (StringUtils.isNotBlank((CharSequence)fieldValue) && (main = FilesUtils.determineMainFile(new File(fieldValue))) != null && main.getParentFile() != null && !main.getPath().equals(fieldValue) && !(main.getPath() + File.separator).equals(fieldValue)) {
                    path = main.getParent();
                    break;
                }
                path = fieldValue;
                break;
            }
            case DOC: 
            case DOSBOXEXE: 
            case INSTALLER: 
            case DOSBOX: 
            case NATIVE_EXE: 
            case ZIP: 
            case DBGLZIP: 
            case BOOTER: 
            case DOSBOXCONF: 
            case GLSHADER: 
            case DOSROOT: 
            case NONE: {
                path = fieldValue;
                break;
            }
            case CDIMAGE: {
                String[] fPaths = StringRelatedUtils.textAreaToStringArray(fieldValue, control.getLineDelimiter());
                path = fPaths.length > 0 ? fPaths[0] : "";
                break;
            }
            case DFEND: {
                path = FileLocationService.DFEND_PATH_STRING;
                break;
            }
            default: {
                path = "";
            }
        }
        return new FileLocation(path, builder.canonicalizer_).getCanonicalFile().getPath();
    }

    private static String getResult(Shell shell, Builder builder, TextControl_ textControl, String result, File filterPath, String[] filenames) {
        if (builder.browseCanonicalType_ == CanonicalType.DOSBOX && SystemUtils.IS_OSX) {
            File f = new FileLocation(result, builder.canonicalizer_).getFile();
            if (f.getName().endsWith(".app")) {
                File exe = new File(f, FileLocationService.DB_APP_EXE);
                if (FilesUtils.isExistingFile(exe)) {
                    return exe.getParent();
                }
            } else if (f.getName().equals(FileLocationService.DOSBOX_EXE_STRING)) {
                return f.getParent();
            }
        } else if (builder.browseCanonicalType_ == CanonicalType.EXE || builder.browseCanonicalType_ == CanonicalType.INSTALLER) {
            if (FilesUtils.isArchive(result) || FilesUtils.isCdImageFile(result) || FilesUtils.isFatImage(result)) {
                BrowseArchiveDialog dialog = new BrowseArchiveDialog(shell, result);
                String choice = (String)dialog.open();
                return choice == null ? null : new FileLocation(choice, builder.canonicalizer_).getFile().getPath();
            }
        } else if (builder.browseCanonicalType_ == CanonicalType.CDIMAGE && filterPath != null) {
            File path = new FileLocation(filterPath.getPath(), builder.canonicalizer_).getFile();
            StringBuilder images = new StringBuilder();
            for (String file : filenames) {
                images.append(FilesUtils.concat(path, file)).append(textControl.getLineDelimiter());
            }
            return images.toString();
        }
        return new FileLocation(result, builder.canonicalizer_).getFile().getPath();
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static final class Builder
    extends ControlBuilder<Builder> {
        private String text_;
        private Image image_;
        private boolean dispose_;
        private String tooltip_;
        private boolean selected_;
        private boolean enabled_ = true;
        private SelectionListener listener_;
        private BrowseType browseType_;
        private CanonicalType browseCanonicalType_;
        private boolean browseSave_;
        private ICanonicalize canonicalizer_;
        private List grabListSource_;
        private boolean grabIsBooter_;

        Builder(Composite composite) {
            super(composite, 32, 4, 0x1000000, false, false);
        }

        public Builder tooltipTxt(String text) {
            this.tooltip_ = text;
            return this;
        }

        public Builder tooltip(String key) {
            return this.tooltipTxt(TextService.getInstance().get(key));
        }

        public Builder tooltip(String key, String param) {
            return this.tooltipTxt(TextService.getInstance().get(key, param));
        }

        public Builder txt(String text) {
            this.text_ = text;
            return this;
        }

        public Builder key(String key) {
            return this.txt(TextService.getInstance().get(key));
        }

        public Builder key(String key, String param) {
            return this.txt(TextService.getInstance().get(key, param));
        }

        public Builder select(boolean select) {
            this.selected_ = select;
            return this;
        }

        public Builder disable() {
            this.enabled_ = false;
            return this;
        }

        public Builder text() {
            this.style_ = 0;
            return this;
        }

        public Builder radio() {
            this.style_ = 16;
            return this;
        }

        public Builder toggle() {
            this.style_ = 2;
            return this;
        }

        public Builder threedots() {
            this.text();
            this.text_ = "...";
            return this;
        }

        public Builder star() {
            this.text();
            this.text_ = "*";
            return this;
        }

        public Builder arrow(boolean up) {
            this.style_ = 4 | (up ? 128 : 1024);
            return this;
        }

        public Builder image(Image image, boolean dispose) {
            this.image_ = image;
            this.dispose_ = dispose;
            return this.text();
        }

        public Builder imageText(String path, String text) {
            this.text();
            int display = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
            if (display != 1) {
                this.image_ = ImageService.getResourceImage(this.composite_.getDisplay(), path);
            }
            if (display == 2) {
                this.tooltip(text);
            } else {
                this.key(text);
            }
            return this;
        }

        public Builder imageText(String path, String text, String param) {
            this.text();
            int display = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
            if (display != 1) {
                this.image_ = ImageService.getResourceImage(this.composite_.getDisplay(), path);
            }
            if (display == 2) {
                this.tooltip(text, param);
            } else {
                this.key(text, param);
            }
            return this;
        }

        public Builder browse(boolean small, BrowseType browse, CanonicalType canon, boolean save) {
            if (small) {
                this.threedots();
                this.tooltip("button.browse");
            } else {
                this.imageText("folder.png", "button.browse");
            }
            this.browseType_ = browse;
            this.browseCanonicalType_ = canon;
            this.browseSave_ = save;
            switch (this.browseCanonicalType_) {
                case DOC: 
                case NATIVE_EXE: 
                case DBGLZIP: {
                    this.canonicalizer_ = FileLocationService.getInstance().dataRelative();
                    break;
                }
                case EXE: 
                case INSTALLER: 
                case ZIP: 
                case BOOTER: 
                case CDIMAGE: 
                case DOSROOT: {
                    this.canonicalizer_ = FileLocationService.getInstance().dosrootRelative();
                    break;
                }
                case DOSBOXEXE: 
                case DOSBOX: 
                case DOSBOXCONF: {
                    this.canonicalizer_ = FileLocationService.getInstance().dosboxRelative();
                    break;
                }
                default: {
                    this.canonicalizer_ = FileLocationService.standard();
                }
            }
            return this;
        }

        public Builder grab(List source, boolean isBooter) {
            this.imageText("grab.png", "button.grab");
            this.grabListSource_ = source;
            this.grabIsBooter_ = isBooter;
            return this;
        }

        public Builder listen(SelectionListener listener) {
            this.listener_ = listener;
            return this;
        }

        public Button_ build() {
            return new Button_(this, null);
        }

        public Button_ build(TextControl_ textControl) {
            return new Button_(this, textControl);
        }

        public Button ctrl() {
            return this.build().ctrl();
        }

        public Button ctrl(TextControl_ textControl) {
            return this.build(textControl).ctrl();
        }
    }

    public static enum BrowseType {
        DIR,
        FILE;

    }

    public static enum CanonicalType {
        DOSROOT,
        DFEND,
        CDIMAGE,
        ZIP,
        DBGLZIP,
        DOSBOX,
        DOSBOXEXE,
        DOSBOXCONF,
        DOC,
        BOOTER,
        EXE,
        INSTALLER,
        NATIVE_EXE,
        GLSHADER,
        NONE;

    }
}

