/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.interfaces.DaControlConvertor;

public class DaControlConvertorAdapter
implements DaControlConvertor {
    @Override
    public String toConfValue(String existingValue, String[] values) {
        String joinedValues = String.join((CharSequence)",", values);
        if (StringUtils.isBlank((CharSequence)existingValue)) {
            return joinedValues;
        }
        String[] exVals = this.toControlValues(existingValue);
        if (exVals.length != values.length) {
            System.err.println("configuration values mismatch: [" + existingValue + "] vs. [" + joinedValues + "]");
            return existingValue;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            String part = StringUtils.isBlank((CharSequence)values[i]) ? exVals[i] : values[i];
            builder.append(part);
        }
        return builder.toString();
    }

    @Override
    public String toConfValueForDisplay(String[] values) {
        String[] parts = this.toConfValue(null, values).split(",", -1);
        return Stream.of(parts).map(x -> StringUtils.isBlank((CharSequence)x) ? "..." : x).collect(Collectors.joining(", "));
    }

    @Override
    public String[] toControlValues(String value) {
        return value == null ? new String[]{} : value.split(",", -1);
    }

    @Override
    public String[] toConfValues(String[] values) {
        return new String[0];
    }

    @Override
    public String[] toControlValues(String[] values) {
        return new String[0];
    }
}

