/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.ProgressBar_;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressDialog
extends BaseDialog<Object>
implements ProgressNotifyable {
    private final String title_;
    private Thread thread_;
    private ProgressBar progressBar_;

    public ProgressDialog(Shell parent, String title) {
        super(parent);
        this.title_ = title;
    }

    public void setThread(Thread thread) {
        this.thread_ = thread;
    }

    @Override
    protected String getDialogTitle() {
        return this.title_;
    }

    @Override
    protected void onShellCreated() {
        this.shell_.setSize(600, 140);
        this.shell_.setLayout((Layout)new GridLayout());
        Group progressGroup = ((Group_.Builder)Group_.on((Composite)this.shell_).layout((Layout)new GridLayout()).layoutData(new GridData(4, 0x1000000, true, true))).key("dialog.migration.progress").build();
        this.progressBar_ = ProgressBar_.on((Composite)progressGroup).build();
    }

    @Override
    protected void onShellOpened() {
        this.thread_.start();
    }

    @Override
    protected void shellDispatchCallback() {
        if (!this.thread_.isAlive()) {
            this.shell_.close();
        }
    }

    @Override
    public void setTotal(long total) {
        if (!this.display_.isDisposed()) {
            this.display_.asyncExec(() -> {
                if (!this.progressBar_.isDisposed()) {
                    this.progressBar_.setMaximum((int)(total / 1024L));
                }
            });
        }
    }

    @Override
    public void incrProgress(long progress) {
        if (!this.display_.isDisposed()) {
            this.display_.asyncExec(() -> {
                if (!this.progressBar_.isDisposed()) {
                    this.progressBar_.setSelection(this.progressBar_.getSelection() + (int)(progress / 1024L));
                }
            });
        }
    }

    @Override
    public void setProgress(long progress) {
        if (!this.display_.isDisposed()) {
            this.display_.asyncExec(() -> {
                if (!this.progressBar_.isDisposed()) {
                    this.progressBar_.setSelection((int)(progress / 1024L));
                }
            });
        }
    }
}

