/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf.mount;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;

public class PhysFsMount
extends DirMount {
    private FileLocation write_ = null;

    public File getWrite() {
        return this.write_ == null ? null : this.write_.getFile();
    }

    public File getCanonicalWrite() {
        return this.write_ == null ? null : this.write_.getCanonicalFile();
    }

    public void setWrite(String location) {
        this.write_ = StringUtils.isBlank((CharSequence)location) ? null : new FileLocation(location, FileLocationService.getInstance().dosrootRelative());
    }

    @Override
    public void setBaseDir(File baseDir) {
        super.setBaseDir(baseDir);
        if (this.write_ != null) {
            this.setWrite(FilesUtils.concat(baseDir, this.getWrite()));
        }
    }

    @Override
    public void migrate(FileLocation from, FileLocation to) {
        super.migrate(from, to);
        if (this.write_ != null) {
            this.write_ = FilesUtils.migrate(this.write_, from, to);
        }
    }

    @Override
    public String toString(boolean forUI) {
        StringBuilder result = new StringBuilder();
        result.append("mount ").append(this.drive_).append(" \"");
        if (this.write_ != null) {
            result.append(this.write_.getFile()).append(':');
        }
        result.append(this.getPath()).append(":\\\"");
        return this.extString(result, forUI);
    }
}

