/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.iso;

import java.io.IOException;
import org.dbgl.util.iso.ISO9660FileEntry;
import org.dbgl.util.iso.ISO9660FileSystem;
import org.dbgl.util.iso.Util;

public class ISO9660VolumeDescriptorSet {
    private static final int TYPE_PRIMARY_DESCRIPTOR = 1;
    private static final int TYPE_SUPPLEMENTARY_DESCRIPTOR = 2;
    private static final int TYPE_TERMINATOR = 255;
    private final ISO9660FileSystem fileSystem_;
    private ISO9660FileEntry rootDirectoryEntry_;
    private String encoding = "US-ASCII";
    private boolean hasPrimary_ = false;
    private boolean hasSupplementary_ = false;

    public ISO9660VolumeDescriptorSet(ISO9660FileSystem fileSystem) {
        this.fileSystem_ = fileSystem;
    }

    public ISO9660FileEntry getRootEntry() {
        return this.rootDirectoryEntry_;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean deserialize(byte[] descriptor) throws IOException {
        boolean terminator = false;
        switch (Util.getUInt8(descriptor, 0)) {
            case 255: {
                if (!this.hasPrimary_) {
                    throw new IOException("No primary volume descriptor found");
                }
                terminator = true;
                break;
            }
            case 1: {
                this.deserializePrimary(descriptor);
                break;
            }
            case 2: {
                this.deserializeSupplementary(descriptor);
                break;
            }
        }
        return terminator;
    }

    private void deserializePrimary(byte[] descriptor) throws IOException {
        if (this.hasPrimary_) {
            return;
        }
        if (!Util.getDChars(descriptor, 2, 5, this.fileSystem_.getEncoding()).equals("CD001") || Util.getUInt8(descriptor, 6) != 1) {
            throw new IOException("Invalid primary volume descriptor");
        }
        ISO9660VolumeDescriptorSet.validateBlockSize(descriptor);
        if (!this.hasSupplementary_) {
            this.deserializeCommon(descriptor);
        }
        this.hasPrimary_ = true;
    }

    private void deserializeCommon(byte[] descriptor) {
        this.rootDirectoryEntry_ = new ISO9660FileEntry(this.fileSystem_, descriptor, 157);
    }

    private void deserializeSupplementary(byte[] descriptor) throws IOException {
        if (this.hasSupplementary_) {
            return;
        }
        ISO9660VolumeDescriptorSet.validateBlockSize(descriptor);
        String enc = ISO9660VolumeDescriptorSet.getEncoding(Util.getDChars(descriptor, 89, 32));
        if (enc != null) {
            this.encoding = enc;
            this.deserializeCommon(descriptor);
            this.hasSupplementary_ = true;
        }
    }

    private static void validateBlockSize(byte[] descriptor) throws IOException {
        int blockSize = Util.getUInt16(descriptor, 128);
        if (blockSize != 2048) {
            throw new IOException("Invalid block size: " + blockSize);
        }
    }

    private static String getEncoding(String escapeSequences) {
        if (escapeSequences.equals("%/@") || escapeSequences.equals("%/C") || escapeSequences.equals("%/E")) {
            return "UTF-16BE";
        }
        return null;
    }
}

