/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;
import java.util.jar.Attributes;
import org.eclipse.swt.internal.Platform;

public class Library {
    static int MAJOR_VERSION = 4;
    static int MINOR_VERSION = 944;
    static int REVISION = 26;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    public static final String USER_HOME;
    static final String SEPARATOR;
    static final String DELIMITER;
    static final String JAVA_LIB_PATH = "java.library.path";
    static final String SWT_LIB_PATH = "swt.library.path";
    static final String SUFFIX_64 = "-64";
    static final String SWT_LIB_DIR;

    static String arch() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("amd64")) {
            return "x86_64";
        }
        return osArch;
    }

    static String os() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            return "linux";
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        if (osName.startsWith("Win")) {
            return "win32";
        }
        return osName;
    }

    static void chmod(String permision, String path) {
        if (Library.os().equals("win32")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", permision, path}).waitFor();
        }
        catch (Throwable e) {
            try {
                new File(path).setExecutable(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static long longConst() {
        return 0x1FFFFFFFFL;
    }

    static int parseVersion(String version) {
        int index;
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int length = version.length();
        int start = 0;
        for (index = 0; index < length && Character.isDigit(version.charAt(index)); ++index) {
        }
        try {
            if (start < length) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Library.JAVA_VERSION(major, minor, micro);
    }

    public static int JAVA_VERSION(int major, int minor, int micro) {
        return (major << 16) + (minor << 8) + micro;
    }

    public static int SWT_VERSION(int major, int minor) {
        return major * 1000 + minor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractResource(String resourceName, File outFile) {
        try (InputStream inputStream = Library.class.getResourceAsStream(resourceName);){
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            Files.copy(inputStream, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean extract(String extractToFilePath, String mappedName) {
        File tempFile;
        File file = new File(extractToFilePath);
        if (file.exists()) {
            return true;
        }
        try {
            tempFile = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
        }
        catch (Throwable e) {
            return false;
        }
        String resourceName = "/" + mappedName.replace('\\', '/');
        if (!Library.extractResource(resourceName, tempFile)) {
            tempFile.delete();
            return false;
        }
        Library.chmod("755", tempFile.getPath());
        try {
            Files.move(tempFile.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (Throwable e) {
            tempFile.delete();
        }
        return true;
    }

    static boolean isLoadable() {
        URL url = Platform.class.getClassLoader().getResource("org/eclipse/swt/internal/Library.class");
        if (!url.getProtocol().equals("jar")) {
            return true;
        }
        Attributes attributes = null;
        try {
            URLConnection connection = url.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                return false;
            }
            JarURLConnection jc = (JarURLConnection)connection;
            attributes = jc.getMainAttributes();
        }
        catch (IOException e) {
            return false;
        }
        String os = Library.os();
        String arch = Library.arch();
        String manifestOS = attributes.getValue("SWT-OS");
        String manifestArch = attributes.getValue("SWT-Arch");
        return arch.equals(manifestArch) && os.equals(manifestOS);
    }

    static boolean load(String libName, StringBuilder message) {
        try {
            if (libName.contains(SEPARATOR)) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (message.length() == 0) {
                message.append(DELIMITER);
            }
            message.append('\t');
            message.append(e.getMessage());
            message.append(DELIMITER);
            return false;
        }
    }

    public static void loadLibrary(String name) {
        Library.loadLibrary(name, true);
    }

    public static void loadLibrary(String name, boolean mapName) {
        int i;
        int i2;
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null && "32".equals(prop)) {
            throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
        }
        int candidates = 3;
        String[] libNames = new String[3];
        String[] mappedNames = new String[3];
        if (mapName) {
            String version = Library.getVersionString();
            libNames[0] = name + "-" + "gtk" + "-" + version;
            libNames[1] = name + "-" + "gtk";
            libNames[2] = name;
            for (int i3 = 0; i3 < 3; ++i3) {
                mappedNames[i3] = Library.mapLibraryName(libNames[i3]);
            }
        } else {
            for (int i4 = 0; i4 < 3; ++i4) {
                libNames[i4] = mappedNames[i4] = name;
            }
        }
        StringBuilder message = new StringBuilder();
        String path = System.getProperty(SWT_LIB_PATH);
        if (path != null) {
            path = new File(path).getAbsolutePath();
            for (i2 = 0; i2 < 3; ++i2) {
                if (i2 != 0 && !mapName || !Library.load(path + SEPARATOR + mappedNames[i2], message)) continue;
                return;
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            if (i2 != 0 && !mapName || !Library.load(libNames[i2], message)) continue;
            return;
        }
        String[] fileNames = new String[3];
        for (i = 0; i < 3; ++i) {
            fileNames[i] = mappedNames[i];
        }
        if (path == null) {
            int i5;
            path = USER_HOME;
            File dir = new File(path, SWT_LIB_DIR);
            if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
                path = dir.getAbsolutePath();
            } else {
                for (i5 = 0; i5 < 3; ++i5) {
                    fileNames[i5] = Library.mapLibraryName(libNames[i5] + SUFFIX_64);
                }
            }
            for (i5 = 0; i5 < 3; ++i5) {
                if (i5 != 0 && !mapName || !Library.load(path + SEPARATOR + fileNames[i5], message)) continue;
                return;
            }
        }
        if (path != null) {
            for (i = 0; i < 3; ++i) {
                if (i != 0 && !mapName || !Library.extract(path + SEPARATOR + fileNames[i], mappedNames[i]) || !Library.load(path + SEPARATOR + fileNames[i], message)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("Could not load SWT library. Reasons: " + message.toString());
    }

    static String mapLibraryName(String libName) {
        return Library.mapLibraryName(libName, true);
    }

    static String mapLibraryName(String libName, boolean replaceDylib) {
        String ext;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext = ".dylib") && replaceDylib) {
            libName = libName.substring(0, libName.length() - ext.length()) + ".jnilib";
        }
        return libName;
    }

    public static String getVersionString() {
        String version = System.getProperty("swt.version");
        if (version == null) {
            version = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                version = version + "00";
            } else if (MINOR_VERSION < 100) {
                version = version + "0";
            }
            version = version + MINOR_VERSION;
            if (REVISION > 0) {
                version = version + "r" + REVISION;
            }
        }
        return version;
    }

    public static File findResource(String subDir, String resourceName, boolean mapResourceName) {
        return Library.findResource(subDir, resourceName, mapResourceName, true, true);
    }

    public static File findResource(String subDir, String resourceName, boolean mapResourceName, boolean replaceDylib, boolean searchInOsgi) {
        File file;
        String maybeSubDirPath = subDir != null ? subDir + SEPARATOR : "";
        String maybeSubDirPathWithPrefix = subDir != null ? SEPARATOR + maybeSubDirPath : "";
        String finalResourceName = mapResourceName ? Library.mapLibraryName(resourceName + "-" + "gtk" + "-" + Library.getVersionString(), replaceDylib) : resourceName;
        Function<String, File> lookForFileInPath = searchPath -> {
            String classpath = System.getProperty(searchPath);
            if (classpath != null) {
                String[] paths;
                for (String path : paths = classpath.split(File.pathSeparator)) {
                    File file = new File(path + SEPARATOR + maybeSubDirPath + finalResourceName);
                    if (!file.exists()) continue;
                    return file;
                }
            }
            return null;
        };
        File result = null;
        for (String path : new String[]{JAVA_LIB_PATH, SWT_LIB_PATH}) {
            result = lookForFileInPath.apply(path);
            if (result == null) continue;
            return result;
        }
        if (searchInOsgi) {
            URL url = Library.class.getClassLoader().getResource(maybeSubDirPathWithPrefix + finalResourceName);
            try {
                URLConnection connection = url.openConnection();
                Method getFileURLMethod = connection.getClass().getMethod("getFileURL", new Class[0]);
                if (getFileURLMethod != null) {
                    URL result2 = (URL)getFileURLMethod.invoke((Object)connection, new Object[0]);
                    return new File(result2.toURI());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((file = new File(USER_HOME + SEPARATOR + SWT_LIB_DIR + maybeSubDirPathWithPrefix, finalResourceName)).exists()) {
            return file;
        }
        File tempDir = new File(USER_HOME, SWT_LIB_DIR + maybeSubDirPathWithPrefix);
        if (!tempDir.exists() || tempDir.isDirectory()) {
            tempDir.mkdirs();
        }
        if (Library.extract(file.getPath(), maybeSubDirPath + finalResourceName) && file.exists()) {
            return file;
        }
        throw new UnsatisfiedLinkError("Could not find resource " + resourceName + (subDir != null ? " (in subdirectory: " + subDir + " )" : ""));
    }

    static {
        DELIMITER = System.lineSeparator();
        SEPARATOR = File.separator;
        USER_HOME = System.getProperty("user.home");
        SWT_LIB_DIR = ".swt" + SEPARATOR + "lib" + SEPARATOR + Library.os() + SEPARATOR + Library.arch();
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }
}

