/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.IntVector;
import Common.LongVector;
import SevenZip.Archive.SevenZip.ArchiveDatabase;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.InArchiveInfo;
import java.io.IOException;

public class ArchiveDatabaseEx
extends ArchiveDatabase {
    InArchiveInfo ArchiveInfo = new InArchiveInfo();
    LongVector PackStreamStartPositions = new LongVector();
    IntVector FolderStartPackStreamIndex = new IntVector();
    IntVector FolderStartFileIndex = new IntVector();
    IntVector FileIndexToFolderIndexMap = new IntVector();

    void Clear() {
        super.Clear();
        this.ArchiveInfo.Clear();
        this.PackStreamStartPositions.clear();
        this.FolderStartPackStreamIndex.clear();
        this.FolderStartFileIndex.clear();
        this.FileIndexToFolderIndexMap.clear();
    }

    void FillFolderStartPackStream() {
        this.FolderStartPackStreamIndex.clear();
        this.FolderStartPackStreamIndex.Reserve(this.Folders.size());
        int n = 0;
        for (int i = 0; i < this.Folders.size(); ++i) {
            this.FolderStartPackStreamIndex.add(n);
            n += ((Folder)this.Folders.get((int)i)).PackStreams.size();
        }
    }

    void FillStartPos() {
        this.PackStreamStartPositions.clear();
        this.PackStreamStartPositions.Reserve(this.PackSizes.size());
        long l = 0L;
        for (int i = 0; i < this.PackSizes.size(); ++i) {
            this.PackStreamStartPositions.add(l);
            l += this.PackSizes.get(i);
        }
    }

    public void Fill() throws IOException {
        this.FillFolderStartPackStream();
        this.FillStartPos();
        this.FillFolderStartFileIndex();
    }

    public long GetFolderFullPackSize(int n) {
        int n2 = this.FolderStartPackStreamIndex.get(n);
        Folder folder = (Folder)this.Folders.get(n);
        long l = 0L;
        for (int i = 0; i < folder.PackStreams.size(); ++i) {
            l += this.PackSizes.get(n2 + i);
        }
        return l;
    }

    void FillFolderStartFileIndex() throws IOException {
        this.FolderStartFileIndex.clear();
        this.FolderStartFileIndex.Reserve(this.Folders.size());
        this.FileIndexToFolderIndexMap.clear();
        this.FileIndexToFolderIndexMap.Reserve(this.Files.size());
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.Files.size(); ++i) {
            boolean bl;
            FileItem fileItem = (FileItem)this.Files.get(i);
            boolean bl2 = bl = !fileItem.HasStream;
            if (bl && n2 == 0) {
                this.FileIndexToFolderIndexMap.add(-1);
                continue;
            }
            if (n2 == 0) {
                while (true) {
                    if (n >= this.Folders.size()) {
                        throw new IOException("Incorrect Header");
                    }
                    this.FolderStartFileIndex.add(i);
                    if (this.NumUnPackStreamsVector.get(n) != 0) break;
                    ++n;
                }
            }
            this.FileIndexToFolderIndexMap.add(n);
            if (bl || ++n2 < this.NumUnPackStreamsVector.get(n)) continue;
            ++n;
            n2 = 0;
        }
    }

    public long GetFolderStreamPos(int n, int n2) {
        return this.ArchiveInfo.DataStartPosition + this.PackStreamStartPositions.get(this.FolderStartPackStreamIndex.get(n) + n2);
    }
}

