/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.ArchiveExtractCallback;
import SevenZip.MyRandomAccessFile;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J7zip {
    static void PrintHelp() {
        System.out.println("\nUsage:  JZip <l|t|x> <archive_name> [<file_names>...]\n  l : Lists files\n  t : Tests archive.7z\n  x : eXtracts files\n");
    }

    static void listing(IInArchive iInArchive, Vector<String> vector, boolean bl) {
        if (!bl) {
            System.out.println("  Date   Time   Attr         Size   Compressed  Name");
            System.out.println("-------------- ----- ------------ ------------  ------------");
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < iInArchive.size(); ++i) {
            SevenZipEntry sevenZipEntry = iInArchive.getEntry(i);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            String string = dateFormat.format(new Date(sevenZipEntry.getTime()));
            if (!vector.contains(sevenZipEntry.getName())) continue;
            if (bl) {
                System.out.println("Path = " + sevenZipEntry.getName());
                System.out.println("Size = " + sevenZipEntry.getSize());
                System.out.println("Packed Size = " + sevenZipEntry.getCompressedSize());
                System.out.println("Modified = " + string);
                System.out.println("   Attributes : " + sevenZipEntry.getAttributesString());
                long l4 = sevenZipEntry.getCrc();
                if (l4 != -1L) {
                    System.out.println("CRC = " + Long.toHexString(l4).toUpperCase());
                } else {
                    System.out.println("CRC =");
                }
                System.out.println("Method = " + sevenZipEntry.getMethods());
                System.out.println("");
            } else {
                System.out.print(string + " " + sevenZipEntry.getAttributesString());
                System.out.print(String.format("%13d", sevenZipEntry.getSize()));
                System.out.print(String.format("%13d", sevenZipEntry.getCompressedSize()));
                System.out.println("  " + sevenZipEntry.getName());
            }
            l += sevenZipEntry.getSize();
            l2 += sevenZipEntry.getCompressedSize();
            ++l3;
        }
        if (!bl) {
            System.out.println("-------------- ----- ------------ ------------  ------------");
            System.out.print(String.format("                    %13d%13d %d files", l, l2, l3));
        }
    }

    static void testOrExtract(IInArchive iInArchive, Vector<String> vector, int n) throws Exception {
        ArchiveExtractCallback archiveExtractCallback;
        ArchiveExtractCallback archiveExtractCallback2 = archiveExtractCallback = new ArchiveExtractCallback();
        archiveExtractCallback.Init(iInArchive);
        archiveExtractCallback.PasswordIsDefined = false;
        try {
            int n2;
            int n3 = 0;
            int[] nArray = null;
            if (vector.size() >= 1) {
                nArray = new int[vector.size()];
                for (n2 = 0; n2 < iInArchive.size(); ++n2) {
                    if (!vector.contains(iInArchive.getEntry(n2).getName())) continue;
                    nArray[n3++] = n2;
                }
            }
            if ((n2 = n3 == 0 ? iInArchive.Extract(null, -1, n, archiveExtractCallback2) : iInArchive.Extract(nArray, n3, n, archiveExtractCallback2)) == 0) {
                if (archiveExtractCallback.NumErrors == 0L) {
                    System.out.println("Ok Done");
                } else {
                    System.out.println(" " + archiveExtractCallback.NumErrors + " errors");
                }
            } else {
                System.out.println("ERROR !!");
            }
        }
        catch (IOException iOException) {
            System.out.println("IO error : " + iOException.getLocalizedMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\nJ7zip 4.43 ALPHA 2 (" + Runtime.getRuntime().availableProcessors() + " CPUs)");
        if (stringArray.length < 2) {
            J7zip.PrintHelp();
            return;
        }
        int n = -1;
        Vector<String> vector = new Vector<String>();
        for (int i = 2; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (stringArray[0].equals("l")) {
            n = 0;
        } else if (stringArray[0].equals("t")) {
            n = 1;
        } else if (stringArray[0].equals("x")) {
            n = 2;
        } else {
            J7zip.PrintHelp();
            return;
        }
        String string = stringArray[1];
        MyRandomAccessFile myRandomAccessFile = new MyRandomAccessFile(string, "r");
        Handler handler = new Handler();
        int n2 = handler.Open(myRandomAccessFile);
        if (n2 != 0) {
            System.out.println("ERROR !");
            return;
        }
        switch (n) {
            case 0: {
                J7zip.listing(handler, vector, false);
                break;
            }
            case 1: {
                J7zip.testOrExtract(handler, vector, 1);
                break;
            }
            case 2: {
                J7zip.testOrExtract(handler, vector, 0);
            }
        }
        handler.close();
    }
}

