/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.service.TextService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class Spinner_ {
    private Spinner_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static class Builder
    extends ControlBuilder<Builder> {
        String tooltip_;
        Integer minimum_ = null;
        Integer maximum_ = null;
        Integer digits_ = null;
        Integer increment_ = null;
        Integer pageIncrement_ = null;
        Integer selection_ = null;

        Builder(Composite composite) {
            super(composite, 2048, 4, 0x1000000, false, false);
        }

        public Builder tooltip(String key) {
            this.tooltip_ = TextService.getInstance().get(key);
            return this;
        }

        public Builder min(int min) {
            this.minimum_ = min;
            return this;
        }

        public Builder max(int max) {
            this.maximum_ = max;
            return this;
        }

        public Builder digits(int digits) {
            this.digits_ = digits;
            return this;
        }

        public Builder incr(int incr) {
            this.increment_ = incr;
            return this;
        }

        public Builder pageIncr(int pageIncr) {
            this.pageIncrement_ = pageIncr;
            return this;
        }

        public Builder select(int select) {
            this.selection_ = select;
            return this;
        }

        public Spinner build() {
            Spinner spinner = new Spinner(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                spinner.setBackground(DarkTheme.inputBackground);
                spinner.setForeground(DarkTheme.defaultForeground);
            }
            spinner.setLayoutData(this.layoutData());
            if (this.minimum_ != null) {
                spinner.setMinimum(this.minimum_);
            }
            if (this.maximum_ != null) {
                spinner.setMaximum(this.maximum_);
            }
            if (this.digits_ != null) {
                spinner.setDigits(this.digits_);
            }
            if (this.increment_ != null) {
                spinner.setIncrement(this.increment_);
            }
            if (this.pageIncrement_ != null) {
                spinner.setPageIncrement(this.pageIncrement_);
            }
            if (this.tooltip_ != null) {
                spinner.setToolTipText(this.tooltip_);
            }
            if (this.selection_ != null) {
                spinner.setSelection(this.selection_);
            }
            return spinner;
        }
    }
}

