/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.GamePack;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.GamePackEntry;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.SettingsService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.archive.ZipUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class ImportThread
extends UIThread<GamePackEntry> {
    private GamePack gamePack_;
    private boolean useExistingConf_;
    private boolean importFullSettings_;
    private boolean customValues_;
    private boolean customFields_;

    public ImportThread(Text log, ProgressBar progressBar, Label status, GamePack packageData, boolean useExistingConf, boolean fullSettings, boolean customValues, boolean customFields) throws IOException {
        super(log, progressBar, status, true);
        this.gamePack_ = packageData;
        this.useExistingConf_ = useExistingConf;
        this.importFullSettings_ = fullSettings;
        this.customValues_ = customValues;
        this.customFields_ = customFields;
        File[] zipfiles = (File[])this.gamePack_.getEntries().stream().map(x -> x.getGamePack().getArchive()).distinct().toArray(File[]::new);
        List archiveGameDirs = this.gamePack_.getEntries().parallelStream().map(GamePackEntry::getArchiveGameDir).collect(Collectors.toList());
        List archiveCaptureDirs = this.gamePack_.getEntries().parallelStream().map(GamePackEntry::getArchiveCapturesDir).collect(Collectors.toList());
        List archiveMapperFiles = this.gamePack_.getEntries().parallelStream().filter(GamePackEntry::hasMapper).map(GamePackEntry::getArchiveMapper).collect(Collectors.toList());
        long bytes = 0L;
        for (File zipfile : zipfiles) {
            List<ZipEntry> archiveEntries;
            List<ZipEntry> allZipEntries = ZipUtils.readEntriesInZip(zipfile);
            Map<File, List<ZipEntry>> gameDirMap = allZipEntries.parallelStream().collect(Collectors.groupingBy(x -> archiveGameDirs.stream().filter(y -> FilesUtils.areRelated(y, new File(x.getName()))).findAny().orElse(new File("."))));
            Map<File, List<ZipEntry>> captureDirMap = allZipEntries.parallelStream().collect(Collectors.groupingBy(x -> archiveCaptureDirs.stream().filter(y -> FilesUtils.areRelated(y, new File(x.getName()))).findAny().orElse(new File("."))));
            Map<File, List<ZipEntry>> mapperFileMap = allZipEntries.parallelStream().collect(Collectors.groupingBy(x -> archiveMapperFiles.stream().filter(y -> y.equals(new File(x.getName()))).findAny().orElse(new File("."))));
            if (this.gamePack_.isGamedataAvailable()) {
                for (GamePackEntry entry : this.gamePack_.getEntries()) {
                    if (!entry.getGamePack().getArchive().equals(zipfile)) continue;
                    archiveEntries = gameDirMap.get(entry.getArchiveGameDir());
                    if (archiveEntries == null) {
                        entry.setGameArchiveEntries(new ArrayList<ZipEntry>());
                        continue;
                    }
                    bytes += archiveEntries.stream().mapToLong(ZipEntry::getSize).sum();
                    entry.setGameArchiveEntries(archiveEntries);
                }
            }
            if (this.gamePack_.isCapturesAvailable()) {
                for (GamePackEntry entry : this.gamePack_.getEntries()) {
                    if (!entry.getGamePack().getArchive().equals(zipfile)) continue;
                    archiveEntries = captureDirMap.get(entry.getArchiveCapturesDir());
                    if (archiveEntries == null) {
                        entry.setCaptureArchiveEntries(new ArrayList<ZipEntry>());
                        continue;
                    }
                    bytes += archiveEntries.stream().mapToLong(ZipEntry::getSize).sum();
                    entry.setCaptureArchiveEntries(archiveEntries);
                }
            }
            if (!this.gamePack_.isMapperfilesAvailable()) continue;
            for (GamePackEntry entry : this.gamePack_.getEntries()) {
                if (!entry.hasMapper() || !entry.getGamePack().getArchive().equals(zipfile)) continue;
                archiveEntries = mapperFileMap.get(entry.getArchiveMapper());
                if (archiveEntries == null) {
                    entry.setMapperArchiveEntries(new ArrayList<ZipEntry>());
                    continue;
                }
                bytes += archiveEntries.stream().mapToLong(ZipEntry::getSize).sum();
                entry.setMapperArchiveEntries(archiveEntries);
            }
        }
        this.setObjects(this.gamePack_.getEntries());
        this.setTotal(bytes);
    }

    @Override
    public String work(GamePackEntry entry) throws IOException, SQLException {
        this.displayTitle(text_.get("dialog.import.importing", new Object[]{this.getTitle(entry)}));
        Profile prof = entry.getProfile();
        if (!this.customValues_) {
            prof.resetAllCustomValues();
        }
        if (!entry.getGamePack().isNativecommandsAvailable()) {
            prof.resetNativeCommands();
        }
        prof.loadConfigurationData(text_, this.importFullSettings_ ? entry.getFullConfig() : entry.getIncrConfig(), entry.getGamePack().getArchive());
        if (entry.getGamePack().isMapperfilesAvailable() && entry.hasMapper()) {
            prof.setValue("sdl", "mapperfile", entry.getNewMapper().getName());
        }
        prof.setBaseDir(entry.getBaseDir());
        prof = new ProfileRepository().add(prof, this.useExistingConf_);
        if (entry.getGamePack().isCapturesAvailable()) {
            try {
                ZipUtils.extractDirInZip(entry.getCaptureArchiveEntries(), entry.getGamePack().getArchive(), entry.getArchiveCapturesDir(), prof.getCanonicalCaptures(), true, this);
                this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.extractedcaptures", new Object[]{prof.getCanonicalCaptures()})).append("\n");
            }
            catch (IOException e) {
                this.messageLog_.append("  - ").append(text_.get("dialog.import.error.capturesextraction", new Object[]{StringRelatedUtils.toString(e)})).append("\n");
            }
        }
        if (entry.getGamePack().isGamedataAvailable()) {
            File canonicalFullDir = entry.getCanonicalFullDir();
            if (!canonicalFullDir.exists()) {
                FilesUtils.createDir(canonicalFullDir);
                this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.createddir", new Object[]{canonicalFullDir})).append("\n");
            }
            try {
                ZipUtils.extractDirInZip(entry.getGameArchiveEntries(), entry.getGamePack().getArchive(), entry.getArchiveGameDir(), canonicalFullDir, false, this);
                this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.extractedgamedata", new Object[]{canonicalFullDir})).append("\n");
            }
            catch (IOException e) {
                throw new IOException(text_.get("dialog.import.error.gamedataextraction", new Object[]{StringRelatedUtils.toString(e)}), e);
            }
        }
        if (entry.getGamePack().isMapperfilesAvailable() && entry.hasMapper()) {
            File dstFile = entry.getNewMapper();
            try {
                ZipUtils.extractDirInZip(entry.getMapperArchiveEntries(), entry.getGamePack().getArchive(), entry.getArchiveMapper(), dstFile, false, this);
                this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.extractedmapperfile", new Object[]{dstFile})).append("\n");
            }
            catch (IOException e) {
                this.messageLog_.append("  - ").append(text_.get("dialog.import.error.mapperfileextraction", new Object[]{StringRelatedUtils.toString(e)})).append("\n");
            }
        }
        this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.createddbentry", new Object[]{prof.getId(), prof.getConfigurationFile(), prof.getCapturesString(), prof.getDosboxVersion().getTitle()})).append("\n");
        return null;
    }

    @Override
    public String getTitle(GamePackEntry entry) {
        return entry.getProfile().getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        if (this.customFields_) {
            for (int i = 0; i < 14; ++i) {
                String customField = this.gamePack_.getCustomFieldTitles()[i];
                if (!StringUtils.isNotBlank(customField) || customField.equalsIgnoreCase("Custom" + (i + 1))) continue;
                SettingsService.getInstance().setValue("gui", "custom" + (i + 1), customField);
            }
        }
    }
}

