/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.abstractdialog.EditProfileDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.gui.dialog.wizard.UpdateMultiProfileDialog;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class EditMultiProfileDialog
extends EditProfileDialog<List<Profile>> {
    private static final boolean MULTI_EDIT = true;
    private List<Profile> profiles_;
    private List<Profile> orgProfiles_;
    private Profile profile_;
    private boolean dbversionChanged_;
    private boolean templateReloaded_;

    public EditMultiProfileDialog(Shell parent, List<Profile> profiles) {
        super(parent);
        this.profiles_ = profiles;
        this.orgProfiles_ = this.profiles_.stream().map(ProfileFactory::createCopy).toList();
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.multiprofile.title.edit", new Object[]{this.profiles_.size()});
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            StringBuilder warningsLog = new StringBuilder();
            this.profile_ = ProfileFactory.combine(this.dbversionsList_, this.profiles_, warningsLog);
            this.dbversionIndex_ = BaseRepository.indexOf(this.dbversionsList_, this.profile_.getDosboxVersion());
            this.templateIndex_ = -1;
            if (StringUtils.isNotEmpty(warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction action, DosboxVersion newDosboxVersion) {
        try {
            StringBuilder warningsLog = new StringBuilder();
            for (Profile prof : this.profiles_) {
                Template templ;
                Configuration combinedConf = prof.getCombinedConfiguration();
                this.metaControls_.stream().filter(Chain::hasChangedValue).forEach(x -> x.updateConfigurableByControl(prof, combinedConf));
                Stream.of(this.nativeCommandControl_).filter(Chain::hasChangedValue).forEach(x -> x.updateConfigurableByControl(prof, combinedConf));
                warningsLog.append(newDosboxVersion.resetAndLoadConfiguration());
                if (action == EditConfigurableDialog.DosboxConfAction.SET) {
                    warningsLog.append(prof.setToDosboxVersion(newDosboxVersion));
                    this.dbversionChanged_ = true;
                    continue;
                }
                if (action == EditConfigurableDialog.DosboxConfAction.SWITCH) {
                    warningsLog.append(prof.switchToDosboxVersion(newDosboxVersion));
                    this.dbversionChanged_ = true;
                    continue;
                }
                if (action == EditConfigurableDialog.DosboxConfAction.RELOAD) {
                    warningsLog.append(prof.reloadDosboxVersion(newDosboxVersion));
                    this.dbversionChanged_ = true;
                    continue;
                }
                if (action == EditConfigurableDialog.DosboxConfAction.LOAD_TEMPLATE) {
                    templ = (Template)this.templatesList_.get(this.templateCombo_.getSelectionIndex());
                    templ.setDosboxVersion(newDosboxVersion);
                    warningsLog.append(templ.resetAndLoadConfiguration());
                    warningsLog.append(prof.loadTemplate(newDosboxVersion, templ));
                    continue;
                }
                if (action != EditConfigurableDialog.DosboxConfAction.RELOAD_TEMPLATE) continue;
                templ = (Template)this.templatesList_.get(this.templateCombo_.getSelectionIndex());
                templ.setDosboxVersion(newDosboxVersion);
                warningsLog.append(templ.resetAndLoadConfiguration());
                warningsLog.append(prof.reloadTemplate(newDosboxVersion, templ));
                this.templateReloaded_ = true;
            }
            this.profile_ = ProfileFactory.combine(this.dbversionsList_, this.profiles_, warningsLog);
            this.updateControlsByConfigurable(this.profile_);
            if (StringUtils.isNotEmpty(warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
        }
    }

    @Override
    protected void updateControlsByConfigurable(TemplateProfileBase configurable) {
        super.updateControlsByConfigurable(configurable);
        this.loadfixValue_.setEnabled(this.loadfix_.getSelection());
    }

    @Override
    protected void onShellCreated() {
        this.createInfoTab();
        this.createGeneralTab(this.text_.get("dialog.profile.automatic"), SettingsDialog.getConfLocations().get(this.settings_.getIntValue("profiledefaults", "confpath")) + ", " + SettingsDialog.getConfFilenames().get(this.settings_.getIntValue("profiledefaults", "conffile")));
        this.createDisplayTab();
        this.createMachineTab();
        this.createAudioTab();
        this.createIOTab();
        this.createCustomCommandsTab();
        this.createMountingTab(this.profile_, true);
        this.createOkCancelButtons();
        this.metaControls_.forEach(Chain::multiEdit);
        this.nativeCommandControl_.multiEdit();
        this.updateControlsByConfigurable(this.profile_);
        if (this.profile_.getNativeCommands() == null) {
            ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
            NativeCommand.insertDosboxCommand(nativeCommands);
            this.nativeCommandControl_.setControlByNativeCommands(nativeCommands);
        }
        this.metaControls_.forEach(Chain::bindListenersAndSetLabelColor);
        this.nativeCommandControl_.bindListenersAndSetLabelColor();
    }

    @Override
    protected ToolBar createInfoTab() {
        ToolBar toolBar = super.createInfoTab();
        this.engineSelector_.addToggleSelectionListener(false);
        return toolBar;
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!EditMultiProfileDialog.this.isValid()) {
                    return;
                }
                try {
                    UpdateMultiProfileDialog empDialog = new UpdateMultiProfileDialog(EditMultiProfileDialog.this.shell_, EditMultiProfileDialog.this.orgProfiles_, EditMultiProfileDialog.this.profiles_, EditMultiProfileDialog.this.dbversionChanged_, EditMultiProfileDialog.this.templateReloaded_, EditMultiProfileDialog.this.metaControls_, EditMultiProfileDialog.this.nativeCommandControl_, EditMultiProfileDialog.this.engineSelector_.isSelected() ? WebSearchEngine.getBySimpleName(EditMultiProfileDialog.this.settings_.getValue("gui", "searchengine")) : null);
                    if (empDialog.open() != null) {
                        EditMultiProfileDialog.this.result_ = EditMultiProfileDialog.this.profiles_;
                        EditMultiProfileDialog.this.shell_.close();
                    }
                }
                catch (Exception e) {
                    Mess_.on(EditMultiProfileDialog.this.shell_).exception(e).warning();
                }
            }
        });
    }

    protected boolean isValid() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (this.setButton_.isEnabled()) {
            mess.key("dialog.template.required.dosboxassociation").bind(this.setButton_, this.getTabItemByControl(this.setButton_));
        }
        return mess.valid();
    }
}

