/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.util.stream.Stream;
import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class Thumb
extends BaseDialog<Object> {
    private static final int BUTTON_BORDER_WIDTH = 0;
    private static final int BUTTON_BORDER_HEIGHT = 24;
    private File[] files_;
    private int index_;
    private int mxh_;
    private Rectangle monitorClientArea_;
    private Rectangle butSize_;
    private Rectangle imgSize_;
    private Button imgButton_;
    private Image thumbImage_;

    public Thumb(Shell parent, File[] files, int index) {
        super(parent, 67680);
        this.files_ = files;
        this.index_ = index;
        this.imgSize_ = new Rectangle(0, 0, 0, 0);
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.screenshot.title", new Object[]{this.files_[this.index_].getPath(), this.imgSize_.width, this.imgSize_.height});
    }

    @Override
    protected boolean prepare() {
        this.monitorClientArea_ = Stream.of(this.display_.getMonitors()).filter(x -> x.getBounds().intersects(this.getParent().getBounds())).findFirst().orElse(this.display_.getPrimaryMonitor()).getClientArea();
        return true;
    }

    @Override
    protected void onShellCreated() {
        this.shell_.setBounds(this.monitorClientArea_);
        this.shell_.setLayout(new GridLayout(3, true));
        this.imgButton_ = ((Button_.Builder)Button_.on(this.shell_).layoutData(new GridData(4, 4, true, true, 3, 1))).text().listen(this.closeShellAdapter).ctrl();
        this.imgButton_.addTraverseListener(e -> {
            if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                this.nextPrev(e.keyCode == 0x1000004);
                e.doit = false;
            }
        });
        Button_.on(this.shell_).text().key("button.previousimage").listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thumb.this.nextPrev(false);
            }
        }).build();
        Button_.on(this.shell_).text().key("button.close").listen(this.closeShellAdapter).build();
        Button_.on(this.shell_).text().key("button.nextimage").listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thumb.this.nextPrev(true);
            }
        }).build();
    }

    @Override
    protected void onShellOpened() {
        this.butSize_ = this.imgButton_.getBounds();
        this.butSize_.x = SettingsService.getInstance().getIntValue("gui", "screenshotsmaxwidth");
        this.butSize_.y = SettingsService.getInstance().getIntValue("gui", "screenshotsmaxheight");
        this.butSize_.width -= 0;
        this.butSize_.height -= 24;
        this.mxh_ = SettingsService.getInstance().getIntValue("gui", "screenshotsmaxheight");
        this.adjustShellBounds();
    }

    @Override
    protected void onClose() {
        if (this.thumbImage_ != null && !this.thumbImage_.isDisposed()) {
            this.thumbImage_.dispose();
        }
    }

    private void nextPrev(boolean next) {
        if (next) {
            ++this.index_;
            if (this.index_ >= this.files_.length) {
                this.index_ = 0;
            }
        } else {
            --this.index_;
            if (this.index_ < 0) {
                this.index_ = this.files_.length - 1;
            }
        }
        this.adjustShellBounds();
    }

    private void adjustShellBounds() {
        if (this.thumbImage_ != null && !this.thumbImage_.isDisposed()) {
            this.thumbImage_.dispose();
        }
        Image orgThumb = ImageService.getImage(this.display_, this.files_[this.index_].getPath());
        this.imgSize_ = orgThumb.getBounds();
        double factor = Thumb.calcFactor(this.imgSize_.width, this.imgSize_.height, this.butSize_.x, this.butSize_.y, this.butSize_.width, this.butSize_.height, this.mxh_);
        this.thumbImage_ = ImageService.createScaledImage(this.display_, orgThumb, this.imgSize_.width, this.imgSize_.height, (int)((double)this.imgSize_.width * factor), (int)((double)this.imgSize_.height * factor), false, null);
        orgThumb.dispose();
        this.imgButton_.setImage(this.thumbImage_);
        this.shell_.pack();
        Rectangle shellBounds = this.shell_.getBounds();
        this.shell_.setText(this.getDialogTitle());
        this.shell_.setLocation(this.monitorClientArea_.x + (this.monitorClientArea_.width - shellBounds.width) / 2, this.monitorClientArea_.y + (this.monitorClientArea_.height - shellBounds.height) / 2);
    }

    private static double calcFactor(int w, int h, int mx, int my, int bw, int bh, int mxh) {
        double factor = Math.min(Math.min((double)bw / (double)w, (double)bh / (double)h), (double)mxh / 100.0);
        if ((double)w * factor > (double)mx) {
            factor = (double)mx / (double)w;
        }
        if ((double)h * factor > (double)my) {
            factor = (double)my / (double)h;
        }
        return factor;
    }
}

