/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class StringRelatedUtils {
    private StringRelatedUtils() {
    }

    public static String[] textAreaToStringArray(String contents, String del) {
        return StringUtils.splitByWholeSeparator(StringUtils.strip(contents, del), del);
    }

    public static String stringArrayToString(String[] values, String delimiter) {
        return ArrayUtils.isEmpty(values) ? "" : StringUtils.join((Object[])values, delimiter) + delimiter;
    }

    public static int[] stringToIntArray(String input) {
        try {
            return Stream.of(input.split(" ")).filter(StringUtils::isNumeric).mapToInt(Integer::parseInt).toArray();
        }
        catch (NumberFormatException e) {
            return new int[0];
        }
    }

    public static boolean[] stringToBooleanArray(String input) {
        return ArrayUtils.toPrimitive((Boolean[])Stream.of(input.split(" ")).map(Boolean::parseBoolean).toArray(Boolean[]::new));
    }

    public static Map<String, String> stringArrayToMap(String[] list) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : list) {
            String[] pair = entry.split("=");
            if (pair.length != 2) continue;
            String key = pair[0].trim();
            String value = pair[1].trim();
            if (key.length() <= 0 || value.length() <= 0) continue;
            result.put(key, value);
        }
        return result;
    }

    public static int findBestMatchIndex(String search, String[] titles) {
        if (ArrayUtils.isEmpty(titles)) {
            return -1;
        }
        String s = search.toLowerCase();
        int minDistance = Integer.MAX_VALUE;
        int result = 0;
        for (int i = 0; i < titles.length; ++i) {
            String title = titles[i].toLowerCase();
            int distance = i == 0 ? LevenshteinDistance.getDefaultInstance().apply(s, title) : new LevenshteinDistance(minDistance - 1).apply(s, title);
            if (distance == 0) {
                return i;
            }
            if (distance == -1) continue;
            minDistance = distance;
            result = i;
        }
        return result;
    }

    public static String toSwtGuiString(String s) {
        return StringUtils.replace(s, "&", "&&");
    }

    public static String toString(Exception exception) {
        return exception.getMessage() != null ? exception.getMessage() : exception.toString();
    }
}

