/* ActionCache.c generated by valac 0.56.3, the Vala compiler
 * generated from ActionCache.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	FEED_READER_ACTION_CACHE_0_PROPERTY,
	FEED_READER_ACTION_CACHE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_action_cache_properties[FEED_READER_ACTION_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderActionCachePrivate {
	GeeList* m_list;
};

static gint FeedReaderActionCache_private_offset;
static gpointer feed_reader_action_cache_parent_class = NULL;
static FeedReaderActionCache* feed_reader_action_cache_m_cache;
static FeedReaderActionCache* feed_reader_action_cache_m_cache = NULL;

static FeedReaderActionCache* feed_reader_action_cache_new (void);
static FeedReaderActionCache* feed_reader_action_cache_construct (GType object_type);
static void feed_reader_action_cache_addAction (FeedReaderActionCache* self,
                                         FeedReaderCachedAction* action);
static void feed_reader_action_cache_removeOpposite (FeedReaderActionCache* self,
                                              FeedReaderCachedAction* action);
static void feed_reader_action_cache_removeForFeed (FeedReaderActionCache* self,
                                             const gchar* feedID);
static void feed_reader_action_cache_removeForCategory (FeedReaderActionCache* self,
                                                 const gchar* catID);
static void feed_reader_action_cache_removeForALL (FeedReaderActionCache* self);
static void feed_reader_action_cache_finalize (GObject * obj);
static GType feed_reader_action_cache_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_action_cache_get_instance_private (FeedReaderActionCache* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderActionCache_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderActionCache*
feed_reader_action_cache_get_default (void)
{
	FeedReaderActionCache* _tmp0_;
	FeedReaderActionCache* _tmp2_;
	FeedReaderActionCache* _tmp3_;
	FeedReaderActionCache* result;
	_tmp0_ = feed_reader_action_cache_m_cache;
	if (_tmp0_ == NULL) {
		FeedReaderActionCache* _tmp1_;
		_tmp1_ = feed_reader_action_cache_new ();
		_g_object_unref0 (feed_reader_action_cache_m_cache);
		feed_reader_action_cache_m_cache = _tmp1_;
	}
	_tmp2_ = feed_reader_action_cache_m_cache;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static FeedReaderActionCache*
feed_reader_action_cache_construct (GType object_type)
{
	FeedReaderActionCache * self = NULL;
	GeeArrayList* _tmp0_;
	self = (FeedReaderActionCache*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_CACHED_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_list);
	self->priv->m_list = (GeeList*) _tmp0_;
	return self;
}

static FeedReaderActionCache*
feed_reader_action_cache_new (void)
{
	return feed_reader_action_cache_construct (FEED_READER_TYPE_ACTION_CACHE);
}

void
feed_reader_action_cache_markArticleRead (FeedReaderActionCache* self,
                                          const gchar* id,
                                          FeedReaderArticleStatus read)
{
	FeedReaderCachedActions cachedAction = 0;
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	cachedAction = FEED_READER_CACHED_ACTIONS_MARK_READ;
	if (read == FEED_READER_ARTICLE_STATUS_UNREAD) {
		cachedAction = FEED_READER_CACHED_ACTIONS_MARK_UNREAD;
	}
	_tmp0_ = feed_reader_cached_action_new (cachedAction, id, "");
	action = _tmp0_;
	feed_reader_action_cache_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_action_cache_markArticleStarred (FeedReaderActionCache* self,
                                             const gchar* id,
                                             FeedReaderArticleStatus marked)
{
	FeedReaderCachedActions cachedAction = 0;
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	cachedAction = FEED_READER_CACHED_ACTIONS_MARK_STARRED;
	if (marked == FEED_READER_ARTICLE_STATUS_UNMARKED) {
		cachedAction = FEED_READER_CACHED_ACTIONS_MARK_UNSTARRED;
	}
	_tmp0_ = feed_reader_cached_action_new (cachedAction, id, "");
	action = _tmp0_;
	feed_reader_action_cache_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_action_cache_markFeedRead (FeedReaderActionCache* self,
                                       const gchar* id)
{
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = feed_reader_cached_action_new (FEED_READER_CACHED_ACTIONS_MARK_READ_FEED, id, "");
	action = _tmp0_;
	feed_reader_action_cache_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_action_cache_markCategoryRead (FeedReaderActionCache* self,
                                           const gchar* id)
{
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = feed_reader_cached_action_new (FEED_READER_CACHED_ACTIONS_MARK_READ_CATEGORY, id, "");
	action = _tmp0_;
	feed_reader_action_cache_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_action_cache_markAllRead (FeedReaderActionCache* self)
{
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = feed_reader_cached_action_new (FEED_READER_CACHED_ACTIONS_MARK_READ_ALL, "", "");
	action = _tmp0_;
	feed_reader_action_cache_addAction (self, action);
	_g_object_unref0 (action);
}

static void
feed_reader_action_cache_addAction (FeedReaderActionCache* self,
                                    FeedReaderCachedAction* action)
{
	GeeList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	switch (feed_reader_cached_action_getType (action)) {
		case FEED_READER_CACHED_ACTIONS_MARK_READ:
		case FEED_READER_CACHED_ACTIONS_MARK_UNREAD:
		case FEED_READER_CACHED_ACTIONS_MARK_STARRED:
		case FEED_READER_CACHED_ACTIONS_MARK_UNSTARRED:
		{
			feed_reader_action_cache_removeOpposite (self, action);
			break;
		}
		case FEED_READER_CACHED_ACTIONS_MARK_READ_FEED:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = feed_reader_cached_action_getID (action);
			_tmp1_ = _tmp0_;
			feed_reader_action_cache_removeForFeed (self, _tmp1_);
			_g_free0 (_tmp1_);
			break;
		}
		case FEED_READER_CACHED_ACTIONS_MARK_READ_CATEGORY:
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = feed_reader_cached_action_getID (action);
			_tmp3_ = _tmp2_;
			feed_reader_action_cache_removeForCategory (self, _tmp3_);
			_g_free0 (_tmp3_);
			break;
		}
		case FEED_READER_CACHED_ACTIONS_MARK_READ_ALL:
		{
			feed_reader_action_cache_removeForALL (self);
			break;
		}
		default:
		break;
	}
	_tmp4_ = self->priv->m_list;
	gee_collection_add ((GeeCollection*) _tmp4_, action);
}

static void
feed_reader_action_cache_removeOpposite (FeedReaderActionCache* self,
                                         FeedReaderCachedAction* action)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GeeList* _a_list = NULL;
		GeeList* _tmp0_;
		gint _a_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _a_index = 0;
		_tmp0_ = self->priv->m_list;
		_a_list = _tmp0_;
		_tmp1_ = _a_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_a_size = _tmp3_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderCachedAction* a = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FeedReaderCachedAction* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_a_index = _a_index + 1;
			_tmp4_ = _a_index;
			_tmp5_ = _a_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _a_list;
			_tmp7_ = gee_list_get (_tmp6_, _a_index);
			a = (FeedReaderCachedAction*) _tmp7_;
			_tmp9_ = a;
			_tmp10_ = feed_reader_cached_action_getID (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = feed_reader_cached_action_getID (action);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp11_, _tmp13_) == 0;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			if (_tmp14_) {
				FeedReaderCachedAction* _tmp15_;
				_tmp15_ = a;
				_tmp8_ = feed_reader_cached_action_getType (_tmp15_) == feed_reader_cached_action_opposite (action);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GeeList* _tmp16_;
				FeedReaderCachedAction* _tmp17_;
				_tmp16_ = self->priv->m_list;
				_tmp17_ = a;
				gee_collection_remove ((GeeCollection*) _tmp16_, _tmp17_);
				_g_object_unref0 (a);
				break;
			}
			_g_object_unref0 (a);
		}
	}
}

static void
feed_reader_action_cache_removeForFeed (FeedReaderActionCache* self,
                                        const gchar* feedID)
{
	FeedReaderDataBaseReadOnly* db = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	db = NULL;
	{
		GeeList* _a_list = NULL;
		GeeList* _tmp0_;
		gint _a_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _a_index = 0;
		_tmp0_ = self->priv->m_list;
		_a_list = _tmp0_;
		_tmp1_ = _a_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_a_size = _tmp3_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderCachedAction* a = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FeedReaderCachedAction* _tmp9_;
			_a_index = _a_index + 1;
			_tmp4_ = _a_index;
			_tmp5_ = _a_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _a_list;
			_tmp7_ = gee_list_get (_tmp6_, _a_index);
			a = (FeedReaderCachedAction*) _tmp7_;
			_tmp9_ = a;
			if (feed_reader_cached_action_getType (_tmp9_) == FEED_READER_CACHED_ACTIONS_MARK_READ) {
				_tmp8_ = TRUE;
			} else {
				FeedReaderCachedAction* _tmp10_;
				_tmp10_ = a;
				_tmp8_ = feed_reader_cached_action_getType (_tmp10_) == FEED_READER_CACHED_ACTIONS_MARK_UNREAD;
			}
			if (_tmp8_) {
				FeedReaderDataBaseReadOnly* _tmp11_;
				FeedReaderDataBaseReadOnly* _tmp13_;
				FeedReaderCachedAction* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp11_ = db;
				if (_tmp11_ == NULL) {
					FeedReaderDataBaseReadOnly* _tmp12_;
					_tmp12_ = feed_reader_data_base_readOnly ();
					_g_object_unref0 (db);
					db = _tmp12_;
				}
				_tmp13_ = db;
				_tmp14_ = a;
				_tmp15_ = feed_reader_cached_action_getID (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = feed_reader_data_base_read_only_getFeedIDofArticle (_tmp13_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strcmp0 (feedID, _tmp18_) == 0;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				if (_tmp19_) {
					GeeList* _tmp20_;
					FeedReaderCachedAction* _tmp21_;
					_tmp20_ = self->priv->m_list;
					_tmp21_ = a;
					gee_collection_remove ((GeeCollection*) _tmp20_, _tmp21_);
				}
			}
			_g_object_unref0 (a);
		}
	}
	_g_object_unref0 (db);
}

static void
feed_reader_action_cache_removeForCategory (FeedReaderActionCache* self,
                                            const gchar* catID)
{
	GeeList* feedIDs = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_getFeedIDofCategorie (_tmp1_, catID);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	feedIDs = _tmp3_;
	{
		GeeList* _feedID_list = NULL;
		GeeList* _tmp4_;
		gint _feedID_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _feedID_index = 0;
		_tmp4_ = feedIDs;
		_feedID_list = _tmp4_;
		_tmp5_ = _feedID_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_feedID_size = _tmp7_;
		_feedID_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gchar* feedID = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp28_;
			_feedID_index = _feedID_index + 1;
			_tmp8_ = _feedID_index;
			_tmp9_ = _feedID_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _feedID_list;
			_tmp11_ = gee_list_get (_tmp10_, _feedID_index);
			feedID = (gchar*) _tmp11_;
			{
				GeeList* _a_list = NULL;
				GeeList* _tmp12_;
				gint _a_size = 0;
				GeeList* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _a_index = 0;
				_tmp12_ = self->priv->m_list;
				_a_list = _tmp12_;
				_tmp13_ = _a_list;
				_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
				_tmp15_ = _tmp14_;
				_a_size = _tmp15_;
				_a_index = -1;
				while (TRUE) {
					gint _tmp16_;
					gint _tmp17_;
					FeedReaderCachedAction* a = NULL;
					GeeList* _tmp18_;
					gpointer _tmp19_;
					gboolean _tmp20_ = FALSE;
					FeedReaderCachedAction* _tmp21_;
					_a_index = _a_index + 1;
					_tmp16_ = _a_index;
					_tmp17_ = _a_size;
					if (!(_tmp16_ < _tmp17_)) {
						break;
					}
					_tmp18_ = _a_list;
					_tmp19_ = gee_list_get (_tmp18_, _a_index);
					a = (FeedReaderCachedAction*) _tmp19_;
					_tmp21_ = a;
					if (feed_reader_cached_action_getType (_tmp21_) == FEED_READER_CACHED_ACTIONS_MARK_READ_FEED) {
						FeedReaderCachedAction* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp22_ = a;
						_tmp23_ = feed_reader_cached_action_getID (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = feedID;
						_tmp20_ = g_strcmp0 (_tmp24_, _tmp25_) == 0;
						_g_free0 (_tmp24_);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						GeeList* _tmp26_;
						FeedReaderCachedAction* _tmp27_;
						_tmp26_ = self->priv->m_list;
						_tmp27_ = a;
						gee_collection_remove ((GeeCollection*) _tmp26_, _tmp27_);
					}
					_g_object_unref0 (a);
				}
			}
			_tmp28_ = feedID;
			feed_reader_action_cache_removeForFeed (self, _tmp28_);
			_g_free0 (feedID);
		}
	}
	_g_object_unref0 (feedIDs);
}

static void
feed_reader_action_cache_removeForALL (FeedReaderActionCache* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeList* _a_list = NULL;
		GeeList* _tmp0_;
		gint _a_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _a_index = 0;
		_tmp0_ = self->priv->m_list;
		_a_list = _tmp0_;
		_tmp1_ = _a_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_a_size = _tmp3_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderCachedAction* a = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			FeedReaderCachedAction* _tmp8_;
			_a_index = _a_index + 1;
			_tmp4_ = _a_index;
			_tmp5_ = _a_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _a_list;
			_tmp7_ = gee_list_get (_tmp6_, _a_index);
			a = (FeedReaderCachedAction*) _tmp7_;
			_tmp8_ = a;
			switch (feed_reader_cached_action_getType (_tmp8_)) {
				case FEED_READER_CACHED_ACTIONS_MARK_READ:
				case FEED_READER_CACHED_ACTIONS_MARK_UNREAD:
				case FEED_READER_CACHED_ACTIONS_MARK_READ_FEED:
				case FEED_READER_CACHED_ACTIONS_MARK_READ_CATEGORY:
				case FEED_READER_CACHED_ACTIONS_MARK_READ_ALL:
				{
					GeeList* _tmp9_;
					FeedReaderCachedAction* _tmp10_;
					_tmp9_ = self->priv->m_list;
					_tmp10_ = a;
					gee_collection_remove ((GeeCollection*) _tmp9_, _tmp10_);
					break;
				}
				default:
				break;
			}
			_g_object_unref0 (a);
		}
	}
}

FeedReaderArticleStatus
feed_reader_action_cache_checkStarred (FeedReaderActionCache* self,
                                       const gchar* articleID,
                                       FeedReaderArticleStatus marked)
{
	FeedReaderCachedActions type = 0;
	FeedReaderArticleStatus result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (articleID != NULL, 0);
	type = FEED_READER_CACHED_ACTIONS_NONE;
	if (marked == FEED_READER_ARTICLE_STATUS_UNMARKED) {
		type = FEED_READER_CACHED_ACTIONS_MARK_STARRED;
	} else {
		if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
			type = FEED_READER_CACHED_ACTIONS_MARK_UNSTARRED;
		}
	}
	{
		GeeList* _a_list = NULL;
		GeeList* _tmp0_;
		gint _a_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _a_index = 0;
		_tmp0_ = self->priv->m_list;
		_a_list = _tmp0_;
		_tmp1_ = _a_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_a_size = _tmp3_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderCachedAction* a = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FeedReaderCachedAction* _tmp9_;
			_a_index = _a_index + 1;
			_tmp4_ = _a_index;
			_tmp5_ = _a_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _a_list;
			_tmp7_ = gee_list_get (_tmp6_, _a_index);
			a = (FeedReaderCachedAction*) _tmp7_;
			_tmp9_ = a;
			if (feed_reader_cached_action_getType (_tmp9_) == type) {
				FeedReaderCachedAction* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp10_ = a;
				_tmp11_ = feed_reader_cached_action_getID (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp8_ = g_strcmp0 (_tmp12_, articleID) == 0;
				_g_free0 (_tmp12_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				if (type == FEED_READER_CACHED_ACTIONS_MARK_STARRED) {
					result = FEED_READER_ARTICLE_STATUS_MARKED;
					_g_object_unref0 (a);
					return result;
				}
				if (type == FEED_READER_CACHED_ACTIONS_MARK_UNSTARRED) {
					result = FEED_READER_ARTICLE_STATUS_UNMARKED;
					_g_object_unref0 (a);
					return result;
				}
			}
			_g_object_unref0 (a);
		}
	}
	result = marked;
	return result;
}

FeedReaderArticleStatus
feed_reader_action_cache_checkRead (FeedReaderActionCache* self,
                                    FeedReaderArticle* a)
{
	FeedReaderArticleStatus result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	if (feed_reader_article_getUnread (a) == FEED_READER_ARTICLE_STATUS_READ) {
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp0_;
			gint _action_size = 0;
			GeeList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _action_index = 0;
			_tmp0_ = self->priv->m_list;
			_action_list = _tmp0_;
			_tmp1_ = _action_list;
			_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_action_size = _tmp3_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				FeedReaderCachedAction* action = NULL;
				GeeList* _tmp6_;
				gpointer _tmp7_;
				gboolean _tmp8_ = FALSE;
				FeedReaderCachedAction* _tmp9_;
				_action_index = _action_index + 1;
				_tmp4_ = _action_index;
				_tmp5_ = _action_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _action_list;
				_tmp7_ = gee_list_get (_tmp6_, _action_index);
				action = (FeedReaderCachedAction*) _tmp7_;
				_tmp9_ = action;
				if (feed_reader_cached_action_getType (_tmp9_) == FEED_READER_CACHED_ACTIONS_MARK_UNREAD) {
					FeedReaderCachedAction* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp10_ = action;
					_tmp11_ = feed_reader_cached_action_getID (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = feed_reader_article_getArticleID (a);
					_tmp14_ = _tmp13_;
					_tmp8_ = g_strcmp0 (_tmp12_, _tmp14_) == 0;
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					result = FEED_READER_ARTICLE_STATUS_UNREAD;
					_g_object_unref0 (action);
					return result;
				}
				_g_object_unref0 (action);
			}
		}
	} else {
		if (feed_reader_article_getUnread (a) == FEED_READER_ARTICLE_STATUS_UNREAD) {
			FeedReaderDataBaseReadOnly* db = NULL;
			db = NULL;
			{
				GeeList* _action_list = NULL;
				GeeList* _tmp15_;
				gint _action_size = 0;
				GeeList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _action_index = 0;
				_tmp15_ = self->priv->m_list;
				_action_list = _tmp15_;
				_tmp16_ = _action_list;
				_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_action_size = _tmp18_;
				_action_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					FeedReaderCachedAction* action = NULL;
					GeeList* _tmp21_;
					gpointer _tmp22_;
					FeedReaderCachedAction* _tmp23_;
					_action_index = _action_index + 1;
					_tmp19_ = _action_index;
					_tmp20_ = _action_size;
					if (!(_tmp19_ < _tmp20_)) {
						break;
					}
					_tmp21_ = _action_list;
					_tmp22_ = gee_list_get (_tmp21_, _action_index);
					action = (FeedReaderCachedAction*) _tmp22_;
					_tmp23_ = action;
					switch (feed_reader_cached_action_getType (_tmp23_)) {
						case FEED_READER_CACHED_ACTIONS_MARK_READ_ALL:
						{
							result = FEED_READER_ARTICLE_STATUS_READ;
							_g_object_unref0 (action);
							_g_object_unref0 (db);
							return result;
						}
						case FEED_READER_CACHED_ACTIONS_MARK_READ_FEED:
						{
							FeedReaderCachedAction* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gboolean _tmp29_;
							_tmp24_ = action;
							_tmp25_ = feed_reader_cached_action_getID (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = feed_reader_article_getFeedID (a);
							_tmp28_ = _tmp27_;
							_tmp29_ = g_strcmp0 (_tmp26_, _tmp28_) == 0;
							_g_free0 (_tmp28_);
							_g_free0 (_tmp26_);
							if (_tmp29_) {
								result = FEED_READER_ARTICLE_STATUS_READ;
								_g_object_unref0 (action);
								_g_object_unref0 (db);
								return result;
							}
							break;
						}
						case FEED_READER_CACHED_ACTIONS_MARK_READ_CATEGORY:
						{
							FeedReaderDataBaseReadOnly* _tmp30_;
							GeeList* feedIDs = NULL;
							FeedReaderDataBaseReadOnly* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							GeeList* _tmp35_;
							GeeList* _tmp36_;
							_tmp30_ = db;
							if (_tmp30_ == NULL) {
								FeedReaderDataBaseReadOnly* _tmp31_;
								_tmp31_ = feed_reader_data_base_readOnly ();
								_g_object_unref0 (db);
								db = _tmp31_;
							}
							_tmp32_ = db;
							_tmp33_ = feed_reader_article_getArticleID (a);
							_tmp34_ = _tmp33_;
							_tmp35_ = feed_reader_data_base_read_only_getFeedIDofCategorie (_tmp32_, _tmp34_);
							_tmp36_ = _tmp35_;
							_g_free0 (_tmp34_);
							feedIDs = _tmp36_;
							{
								GeeList* _feedID_list = NULL;
								GeeList* _tmp37_;
								gint _feedID_size = 0;
								GeeList* _tmp38_;
								gint _tmp39_;
								gint _tmp40_;
								gint _feedID_index = 0;
								_tmp37_ = feedIDs;
								_feedID_list = _tmp37_;
								_tmp38_ = _feedID_list;
								_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
								_tmp40_ = _tmp39_;
								_feedID_size = _tmp40_;
								_feedID_index = -1;
								while (TRUE) {
									gint _tmp41_;
									gint _tmp42_;
									gchar* feedID = NULL;
									GeeList* _tmp43_;
									gpointer _tmp44_;
									const gchar* _tmp45_;
									gchar* _tmp46_;
									gchar* _tmp47_;
									gboolean _tmp48_;
									_feedID_index = _feedID_index + 1;
									_tmp41_ = _feedID_index;
									_tmp42_ = _feedID_size;
									if (!(_tmp41_ < _tmp42_)) {
										break;
									}
									_tmp43_ = _feedID_list;
									_tmp44_ = gee_list_get (_tmp43_, _feedID_index);
									feedID = (gchar*) _tmp44_;
									_tmp45_ = feedID;
									_tmp46_ = feed_reader_article_getFeedID (a);
									_tmp47_ = _tmp46_;
									_tmp48_ = g_strcmp0 (_tmp45_, _tmp47_) == 0;
									_g_free0 (_tmp47_);
									if (_tmp48_) {
										result = FEED_READER_ARTICLE_STATUS_READ;
										_g_free0 (feedID);
										_g_object_unref0 (feedIDs);
										_g_object_unref0 (action);
										_g_object_unref0 (db);
										return result;
									}
									_g_free0 (feedID);
								}
							}
							_g_object_unref0 (feedIDs);
							break;
						}
						default:
						break;
					}
					_g_object_unref0 (action);
				}
			}
			_g_object_unref0 (db);
		}
	}
	result = feed_reader_article_getUnread (a);
	return result;
}

static void
feed_reader_action_cache_class_init (FeedReaderActionCacheClass * klass,
                                     gpointer klass_data)
{
	feed_reader_action_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderActionCache_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_action_cache_finalize;
}

static void
feed_reader_action_cache_instance_init (FeedReaderActionCache * self,
                                        gpointer klass)
{
	self->priv = feed_reader_action_cache_get_instance_private (self);
}

static void
feed_reader_action_cache_finalize (GObject * obj)
{
	FeedReaderActionCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_ACTION_CACHE, FeedReaderActionCache);
	_g_object_unref0 (self->priv->m_list);
	G_OBJECT_CLASS (feed_reader_action_cache_parent_class)->finalize (obj);
}

static GType
feed_reader_action_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderActionCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_action_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderActionCache), 0, (GInstanceInitFunc) feed_reader_action_cache_instance_init, NULL };
	GType feed_reader_action_cache_type_id;
	feed_reader_action_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderActionCache", &g_define_type_info, 0);
	FeedReaderActionCache_private_offset = g_type_add_instance_private (feed_reader_action_cache_type_id, sizeof (FeedReaderActionCachePrivate));
	return feed_reader_action_cache_type_id;
}

GType
feed_reader_action_cache_get_type (void)
{
	static volatile gsize feed_reader_action_cache_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_action_cache_type_id__once)) {
		GType feed_reader_action_cache_type_id;
		feed_reader_action_cache_type_id = feed_reader_action_cache_get_type_once ();
		g_once_init_leave (&feed_reader_action_cache_type_id__once, feed_reader_action_cache_type_id);
	}
	return feed_reader_action_cache_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

