/* FeedServer.c generated by valac 0.56.3, the Vala compiler
 * generated from FeedServer.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General public License for more details.*/
/**/
/*You should have received a copy of the GNU General public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <glib.h>
#include <libpeas/peas.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <libsecret/secret.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <libxml/HTMLparser.h>
#include <libxml/HTMLtree.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <glib/gstdio.h>

enum  {
	FEED_READER_FEED_SERVER_0_PROPERTY,
	FEED_READER_FEED_SERVER_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feed_server_properties[FEED_READER_FEED_SERVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
typedef struct _Block75Data Block75Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block76Data Block76Data;
typedef struct _Block77Data Block77Data;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _feed_reader_feed_server_grabContentData feed_reader_feed_server_grabContentData;
#define _htmlFreeParserCtxt0(var) ((var == NULL) ? NULL : (var = (htmlFreeParserCtxt (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	FEED_READER_FEED_SERVER_PLUGINS_CHANED_EVENT_SIGNAL,
	FEED_READER_FEED_SERVER_NUM_SIGNALS
};
static guint feed_reader_feed_server_signals[FEED_READER_FEED_SERVER_NUM_SIGNALS] = {0};

struct _FeedReaderFeedServerPrivate {
	gboolean m_pluginLoaded;
	PeasExtensionSet* m_extensions;
	gchar* m_activeExtension;
	FeedReaderFeedServerInterface* m_plugin;
	PeasEngine* m_engine;
};

struct _Block75Data {
	int _ref_count_;
	FeedReaderFeedServer* self;
	gchar* pluginID;
};

struct _Block76Data {
	int _ref_count_;
	FeedReaderFeedServer* self;
	gint size;
	gint i;
	GeeArrayList* new_article_content;
	GMutex mutex;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _Block77Data {
	int _ref_count_;
	Block76Data * _data76_;
	SoupSession* session;
};

struct _feed_reader_feed_server_grabContentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FeedReaderFeedServer* self;
	GCancellable* cancellable;
	Block76Data* _data76_;
	gboolean _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	FeedReaderDataBase* db;
	FeedReaderDataBase* _tmp6_;
	GeeList* articles;
	FeedReaderDataBase* _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeArrayList* _tmp12_;
	Block77Data* _data77_;
	SoupSession* _tmp13_;
	SoupSession* _tmp14_;
	SoupSession* _tmp15_;
	SoupSession* _tmp16_;
	GThreadPool* threads;
	GThreadPool* _tmp17_;
	GeeList* _Article_list;
	GeeList* _tmp18_;
	gint _Article_size;
	GeeList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _Article_index;
	gint _tmp22_;
	gint _tmp23_;
	FeedReaderArticle* Article;
	GeeList* _tmp24_;
	gpointer _tmp25_;
	GThreadPool* _tmp26_;
	FeedReaderArticle* _tmp27_;
	FeedReaderArticle* _tmp28_;
	gboolean immediate;
	gboolean wait;
	GThreadPool* _tmp29_;
	GError* e;
	GError* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GeeArrayList* _content_list;
	GeeArrayList* _tmp34_;
	gint _content_size;
	GeeArrayList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _content_index;
	gint _tmp38_;
	gint _tmp39_;
	FeedReaderArticle* content;
	GeeArrayList* _tmp40_;
	gpointer _tmp41_;
	gboolean _tmp42_;
	FeedReaderDataBase* _tmp43_;
	FeedReaderArticle* _tmp44_;
	gboolean _tmp45_;
	FeedReaderDataBase* _tmp46_;
	GError* _inner_error0_;
};

static gint FeedReaderFeedServer_private_offset;
static gpointer feed_reader_feed_server_parent_class = NULL;
static FeedReaderFeedServer* feed_reader_feed_server_m_server;
static FeedReaderFeedServer* feed_reader_feed_server_m_server = NULL;

static FeedReaderFeedServer* feed_reader_feed_server_new (void);
static FeedReaderFeedServer* feed_reader_feed_server_construct (GType object_type);
static void __lambda92_ (FeedReaderFeedServer* self,
                  PeasPluginInfo* info,
                  GObject* extension);
static void ___lambda92__peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                      PeasPluginInfo* info,
                                                      GObject* exten,
                                                      gpointer self);
static void __lambda93_ (FeedReaderFeedServer* self,
                  PeasPluginInfo* info,
                  GObject* extension);
static void ___lambda93__peas_extension_set_extension_removed (PeasExtensionSet* _sender,
                                                        PeasPluginInfo* info,
                                                        GObject* exten,
                                                        gpointer self);
static void __lambda94_ (FeedReaderFeedServer* self,
                  PeasPluginInfo* info);
static void ___lambda94__peas_engine_load_plugin (PeasEngine* _sender,
                                           PeasPluginInfo* info,
                                           gpointer self);
static void __lambda95_ (FeedReaderFeedServer* self,
                  PeasPluginInfo* info);
static void ___lambda95__peas_engine_unload_plugin (PeasEngine* _sender,
                                             PeasPluginInfo* info,
                                             gpointer self);
static void feed_reader_feed_server_LoadPlugin (FeedReaderFeedServer* self,
                                         const gchar* pluginID);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static Block75Data* block75_data_ref (Block75Data* _data75_);
static void block75_data_unref (void * _userdata_);
static void __lambda5_ (Block75Data* _data75_,
                 PeasExtensionSet* extSet,
                 PeasPluginInfo* info,
                 PeasExtension* ext);
static void ___lambda6_ (FeedReaderFeedServer* self);
static void ____lambda6__feed_reader_feed_server_interface_try_login (FeedReaderFeedServerInterface* _sender,
                                                               gpointer self);
static void ___lambda7_ (FeedReaderFeedServer* self);
static void ____lambda7__feed_reader_feed_server_interface_new_feed_list (FeedReaderFeedServerInterface* _sender,
                                                                   gpointer self);
static void ___lambda8_ (FeedReaderFeedServer* self);
static void ____lambda8__feed_reader_feed_server_interface_refresh_feed_list_counter (FeedReaderFeedServerInterface* _sender,
                                                                               gpointer self);
static void ___lambda9_ (FeedReaderFeedServer* self);
static void ____lambda9__feed_reader_feed_server_interface_update_article_list (FeedReaderFeedServerInterface* _sender,
                                                                         gpointer self);
static void ___lambda10_ (FeedReaderFeedServer* self);
static void ____lambda10__feed_reader_feed_server_interface_show_article_list_overlay (FeedReaderFeedServerInterface* _sender,
                                                                                gpointer self);
static void ___lambda11_ (FeedReaderFeedServer* self,
                   GeeList* articles);
static void feed_reader_feed_server_writeArticles (FeedReaderFeedServer* self,
                                            GeeList* articles);
static void ____lambda11__feed_reader_feed_server_interface_write_articles (FeedReaderFeedServerInterface* _sender,
                                                                     GeeList* articles,
                                                                     gpointer self);
static void ___lambda5__peas_extension_set_foreach_func (PeasExtensionSet* set,
                                                  PeasPluginInfo* info,
                                                  PeasExtension* exten,
                                                  gpointer self);
static void feed_reader_feed_server_syncProgress (FeedReaderFeedServer* self,
                                           const gchar* text);
static gint feed_reader_feed_server_ArticleSyncCount (FeedReaderFeedServer* self);
static void feed_reader_feed_server_grabContent_data_free (gpointer _data);
static gboolean feed_reader_feed_server_grabContent_co (feed_reader_feed_server_grabContentData* _data_);
static Block76Data* block76_data_ref (Block76Data* _data76_);
static void block76_data_unref (void * _userdata_);
static Block77Data* block77_data_ref (Block77Data* _data77_);
static void block77_data_unref (void * _userdata_);
static void ____lambda14_ (Block77Data* _data77_,
                    FeedReaderArticle* article);
static void feed_reader_feed_server_downloadImages (FeedReaderFeedServer* self,
                                             SoupSession* session,
                                             FeedReaderArticle* article,
                                             GCancellable* cancellable);
static void _____lambda14__gfunc (gpointer data,
                           gpointer self);
static void feed_reader_feed_server_finalize (GObject * obj);
static GType feed_reader_feed_server_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_feed_server_get_instance_private (FeedReaderFeedServer* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedServer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderFeedServer*
feed_reader_feed_server_get_default (void)
{
	FeedReaderFeedServer* _tmp0_;
	FeedReaderFeedServer* _tmp2_;
	FeedReaderFeedServer* _tmp3_;
	FeedReaderFeedServer* result;
	_tmp0_ = feed_reader_feed_server_m_server;
	if (_tmp0_ == NULL) {
		FeedReaderFeedServer* _tmp1_;
		_tmp1_ = feed_reader_feed_server_new ();
		_g_object_unref0 (feed_reader_feed_server_m_server);
		feed_reader_feed_server_m_server = _tmp1_;
	}
	_tmp2_ = feed_reader_feed_server_m_server;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda92_ (FeedReaderFeedServer* self,
             PeasPluginInfo* info,
             GObject* extension)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (info != NULL);
	g_return_if_fail (extension != NULL);
	_tmp0_ = peas_plugin_info_get_name (info);
	_tmp1_ = g_strdup_printf ("feedserver: plugin loaded %s", _tmp0_);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	{
		SecretService* secret_service = NULL;
		SecretService* _tmp3_;
		SecretCollection* secrets = NULL;
		SecretService* _tmp4_;
		SecretCollection* _tmp5_;
		SecretCollection* _tmp6_;
		gpointer settings_backend = NULL;
		gpointer _tmp11_;
		SecretCollection* _tmp12_;
		_tmp3_ = secret_service_get_sync (SECRET_SERVICE_OPEN_SESSION, NULL, &_inner_error0_);
		secret_service = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = secret_service;
		_tmp5_ = secret_collection_for_alias_sync (_tmp4_, SECRET_COLLECTION_DEFAULT, SECRET_COLLECTION_NONE, NULL, &_inner_error0_);
		secrets = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (secret_service);
			goto __catch0_g_error;
		}
		_tmp6_ = secrets;
		if (_tmp6_ == NULL) {
			SecretCollection* _tmp7_ = NULL;
			SecretService* _tmp8_;
			SecretCollection* _tmp9_;
			SecretCollection* _tmp10_;
			_tmp8_ = secret_service;
			_tmp9_ = secret_collection_create_sync (_tmp8_, "Login", SECRET_COLLECTION_DEFAULT, SECRET_COLLECTION_CREATE_NONE, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (secrets);
				_g_object_unref0 (secret_service);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (secrets);
			secrets = _tmp10_;
			_g_object_unref0 (_tmp7_);
		}
		settings_backend = NULL;
		_tmp11_ = settings_backend;
		_tmp12_ = secrets;
		feed_reader_feed_server_interface_init (FEED_READER_IS_FEED_SERVER_INTERFACE (extension) ? ((FeedReaderFeedServerInterface*) extension) : NULL, _tmp11_, _tmp12_);
		g_signal_emit (self, feed_reader_feed_server_signals[FEED_READER_FEED_SERVER_PLUGINS_CHANED_EVENT_SIGNAL], 0);
		_g_object_unref0 (secrets);
		_g_object_unref0 (secret_service);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strconcat ("FeedServer: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		feed_reader_logger_error (_tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda92__peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                 PeasPluginInfo* info,
                                                 GObject* exten,
                                                 gpointer self)
{
	__lambda92_ ((FeedReaderFeedServer*) self, info, exten);
}

static void
__lambda93_ (FeedReaderFeedServer* self,
             PeasPluginInfo* info,
             GObject* extension)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (info != NULL);
	g_return_if_fail (extension != NULL);
	_tmp0_ = peas_plugin_info_get_name (info);
	_tmp1_ = g_strdup_printf ("feedserver: plugin removed %s", _tmp0_);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	g_signal_emit (self, feed_reader_feed_server_signals[FEED_READER_FEED_SERVER_PLUGINS_CHANED_EVENT_SIGNAL], 0);
}

static void
___lambda93__peas_extension_set_extension_removed (PeasExtensionSet* _sender,
                                                   PeasPluginInfo* info,
                                                   GObject* exten,
                                                   gpointer self)
{
	__lambda93_ ((FeedReaderFeedServer*) self, info, exten);
}

static void
__lambda94_ (FeedReaderFeedServer* self,
             PeasPluginInfo* info)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (info != NULL);
	_tmp0_ = peas_plugin_info_get_name (info);
	_tmp1_ = g_strdup_printf ("feedserver: engine load %s", _tmp0_);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
}

static void
___lambda94__peas_engine_load_plugin (PeasEngine* _sender,
                                      PeasPluginInfo* info,
                                      gpointer self)
{
	__lambda94_ ((FeedReaderFeedServer*) self, info);
}

static void
__lambda95_ (FeedReaderFeedServer* self,
             PeasPluginInfo* info)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (info != NULL);
	_tmp0_ = peas_plugin_info_get_name (info);
	_tmp1_ = g_strdup_printf ("feedserver: engine unload %s", _tmp0_);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
}

static void
___lambda95__peas_engine_unload_plugin (PeasEngine* _sender,
                                        PeasPluginInfo* info,
                                        gpointer self)
{
	__lambda95_ ((FeedReaderFeedServer*) self, info);
}

static FeedReaderFeedServer*
feed_reader_feed_server_construct (GType object_type)
{
	FeedReaderFeedServer * self = NULL;
	gchar* pluginPath = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PeasEngine* _tmp5_;
	PeasEngine* _tmp6_;
	PeasEngine* _tmp7_;
	const gchar* _tmp8_;
	PeasEngine* _tmp9_;
	PeasEngine* _tmp10_;
	PeasExtensionSet* _tmp11_;
	PeasExtensionSet* _tmp12_;
	PeasExtensionSet* _tmp13_;
	PeasEngine* _tmp14_;
	PeasEngine* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	self = (FeedReaderFeedServer*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (FEED_READER_CONSTANTS_INSTALL_LIBDIR "/plugins/");
	pluginPath = _tmp0_;
	_tmp1_ = pluginPath;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("FeedServer: search path for plugins is ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_logger_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = peas_engine_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->m_engine);
	self->priv->m_engine = _tmp6_;
	_tmp7_ = self->priv->m_engine;
	_tmp8_ = pluginPath;
	peas_engine_add_search_path (_tmp7_, _tmp8_, NULL);
	_tmp9_ = self->priv->m_engine;
	peas_engine_enable_loader (_tmp9_, "python3");
	_tmp10_ = self->priv->m_engine;
	_tmp11_ = peas_extension_set_new (_tmp10_, FEED_READER_TYPE_FEED_SERVER_INTERFACE, NULL);
	_g_object_unref0 (self->priv->m_extensions);
	self->priv->m_extensions = _tmp11_;
	_tmp12_ = self->priv->m_extensions;
	g_signal_connect_object (_tmp12_, "extension-added", (GCallback) ___lambda92__peas_extension_set_extension_added, self, 0);
	_tmp13_ = self->priv->m_extensions;
	g_signal_connect_object (_tmp13_, "extension-removed", (GCallback) ___lambda93__peas_extension_set_extension_removed, self, 0);
	_tmp14_ = self->priv->m_engine;
	g_signal_connect_object (_tmp14_, "load-plugin", (GCallback) ___lambda94__peas_engine_load_plugin, self, 0);
	_tmp15_ = self->priv->m_engine;
	g_signal_connect_object (_tmp15_, "unload-plugin", (GCallback) ___lambda95__peas_engine_unload_plugin, self, 0);
	_tmp16_ = feed_reader_settings_general ();
	_tmp17_ = _tmp16_;
	_tmp18_ = g_settings_get_string (_tmp17_, "plugin");
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strcmp0 (_tmp19_, "none") == 0;
	_g_free0 (_tmp19_);
	_g_object_unref0 (_tmp17_);
	if (_tmp20_) {
		feed_reader_feed_server_LoadAllPlugins (self);
	} else {
		GSettings* _tmp21_;
		GSettings* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = feed_reader_settings_general ();
		_tmp22_ = _tmp21_;
		_tmp23_ = g_settings_get_string (_tmp22_, "plugin");
		_tmp24_ = _tmp23_;
		feed_reader_feed_server_LoadPlugin (self, _tmp24_);
		_g_free0 (_tmp24_);
		_g_object_unref0 (_tmp22_);
	}
	_g_free0 (pluginPath);
	return self;
}

static FeedReaderFeedServer*
feed_reader_feed_server_new (void)
{
	return feed_reader_feed_server_construct (FEED_READER_TYPE_FEED_SERVER);
}

static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

void
feed_reader_feed_server_LoadAllPlugins (FeedReaderFeedServer* self)
{
	PeasEngine* _tmp0_;
	GList* _tmp1_;
	GtkIconTheme* _tmp5_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_debug ("FeedServer: load all available plugins");
	_tmp0_ = self->priv->m_engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* plugin_collection = NULL;
		GList* plugin_it = NULL;
		plugin_collection = _tmp1_;
		for (plugin_it = plugin_collection; plugin_it != NULL; plugin_it = plugin_it->next) {
			PeasPluginInfo* _tmp2_;
			PeasPluginInfo* plugin = NULL;
			_tmp2_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_it->data);
			plugin = _tmp2_;
			{
				PeasEngine* _tmp3_;
				PeasPluginInfo* _tmp4_;
				_tmp3_ = self->priv->m_engine;
				_tmp4_ = plugin;
				peas_engine_load_plugin (_tmp3_, _tmp4_);
				__vala_PeasPluginInfo_free0 (plugin);
			}
		}
	}
	_tmp5_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_add_resource_path (_tmp5_, "/org/gnome/FeedReader/icons");
}

static void
feed_reader_feed_server_LoadPlugin (FeedReaderFeedServer* self,
                                    const gchar* pluginID)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PeasPluginInfo* plugin = NULL;
	PeasEngine* _tmp3_;
	PeasPluginInfo* _tmp4_;
	PeasPluginInfo* _tmp5_;
	PeasEngine* _tmp6_;
	PeasPluginInfo* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pluginID != NULL);
	_tmp0_ = string_to_string (pluginID);
	_tmp1_ = g_strconcat ("FeedServer: load plugin ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->m_engine;
	_tmp4_ = peas_engine_get_plugin_info (_tmp3_, pluginID);
	_tmp5_ = __vala_PeasPluginInfo_copy0 (_tmp4_);
	plugin = _tmp5_;
	_tmp6_ = self->priv->m_engine;
	_tmp7_ = plugin;
	if (!peas_engine_load_plugin (_tmp6_, _tmp7_)) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = string_to_string (pluginID);
		_tmp9_ = g_strconcat ("FeedServer: loading plugin ", _tmp8_, " failed", NULL);
		_tmp10_ = _tmp9_;
		feed_reader_logger_error (_tmp10_);
		_g_free0 (_tmp10_);
		feed_reader_feed_server_LoadAllPlugins (self);
	}
	__vala_PeasPluginInfo_free0 (plugin);
}

gboolean
feed_reader_feed_server_pluginLoaded (FeedReaderFeedServer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->m_pluginLoaded;
	return result;
}

PeasExtensionSet*
feed_reader_feed_server_getPlugins (FeedReaderFeedServer* self)
{
	PeasExtensionSet* _tmp0_;
	PeasExtensionSet* _tmp1_;
	PeasExtensionSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_extensions;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Block75Data*
block75_data_ref (Block75Data* _data75_)
{
	g_atomic_int_inc (&_data75_->_ref_count_);
	return _data75_;
}

static void
block75_data_unref (void * _userdata_)
{
	Block75Data* _data75_;
	_data75_ = (Block75Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data75_->_ref_count_)) {
		FeedReaderFeedServer* self;
		self = _data75_->self;
		_g_free0 (_data75_->pluginID);
		_g_object_unref0 (self);
		g_slice_free (Block75Data, _data75_);
	}
}

static void
___lambda6_ (FeedReaderFeedServer* self)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "try-login");
	_g_object_unref0 (_tmp1_);
}

static void
____lambda6__feed_reader_feed_server_interface_try_login (FeedReaderFeedServerInterface* _sender,
                                                          gpointer self)
{
	___lambda6_ ((FeedReaderFeedServer*) self);
}

static void
___lambda7_ (FeedReaderFeedServer* self)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "new-feed-list");
	_g_object_unref0 (_tmp1_);
}

static void
____lambda7__feed_reader_feed_server_interface_new_feed_list (FeedReaderFeedServerInterface* _sender,
                                                              gpointer self)
{
	___lambda7_ ((FeedReaderFeedServer*) self);
}

static void
___lambda8_ (FeedReaderFeedServer* self)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "refresh-feed-list-counter");
	_g_object_unref0 (_tmp1_);
}

static void
____lambda8__feed_reader_feed_server_interface_refresh_feed_list_counter (FeedReaderFeedServerInterface* _sender,
                                                                          gpointer self)
{
	___lambda8_ ((FeedReaderFeedServer*) self);
}

static void
___lambda9_ (FeedReaderFeedServer* self)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "update-article-list");
	_g_object_unref0 (_tmp1_);
}

static void
____lambda9__feed_reader_feed_server_interface_update_article_list (FeedReaderFeedServerInterface* _sender,
                                                                    gpointer self)
{
	___lambda9_ ((FeedReaderFeedServer*) self);
}

static void
___lambda10_ (FeedReaderFeedServer* self)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "show-article-list-overlay");
	_g_object_unref0 (_tmp1_);
}

static void
____lambda10__feed_reader_feed_server_interface_show_article_list_overlay (FeedReaderFeedServerInterface* _sender,
                                                                           gpointer self)
{
	___lambda10_ ((FeedReaderFeedServer*) self);
}

static void
___lambda11_ (FeedReaderFeedServer* self,
              GeeList* articles)
{
	g_return_if_fail (articles != NULL);
	feed_reader_feed_server_writeArticles (self, articles);
}

static void
____lambda11__feed_reader_feed_server_interface_write_articles (FeedReaderFeedServerInterface* _sender,
                                                                GeeList* articles,
                                                                gpointer self)
{
	___lambda11_ ((FeedReaderFeedServer*) self, articles);
}

static void
__lambda5_ (Block75Data* _data75_,
            PeasExtensionSet* extSet,
            PeasPluginInfo* info,
            PeasExtension* ext)
{
	FeedReaderFeedServer* self;
	FeedReaderFeedServerInterface* plug = NULL;
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FeedReaderFeedServerInterface* _tmp2_;
	self = _data75_->self;
	g_return_if_fail (extSet != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (ext != NULL);
	_tmp0_ = _g_object_ref0 (FEED_READER_IS_FEED_SERVER_INTERFACE (ext) ? ((FeedReaderFeedServerInterface*) ext) : NULL);
	plug = _tmp0_;
	_tmp2_ = plug;
	if (_tmp2_ != NULL) {
		FeedReaderFeedServerInterface* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = plug;
		_tmp4_ = feed_reader_feed_server_interface_getID (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = g_strcmp0 (_tmp5_, _data75_->pluginID) == 0;
		_g_free0 (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FeedReaderFeedServerInterface* _tmp6_;
		FeedReaderFeedServerInterface* _tmp7_;
		FeedReaderFeedServerInterface* _tmp8_;
		FeedReaderFeedServerInterface* _tmp9_;
		FeedReaderFeedServerInterface* _tmp10_;
		FeedReaderFeedServerInterface* _tmp11_;
		FeedReaderFeedServerInterface* _tmp12_;
		FeedReaderFeedServerInterface* _tmp13_;
		_tmp6_ = plug;
		g_signal_connect_object (_tmp6_, "try-login", (GCallback) ____lambda6__feed_reader_feed_server_interface_try_login, self, 0);
		_tmp7_ = plug;
		g_signal_connect_object (_tmp7_, "new-feed-list", (GCallback) ____lambda7__feed_reader_feed_server_interface_new_feed_list, self, 0);
		_tmp8_ = plug;
		g_signal_connect_object (_tmp8_, "refresh-feed-list-counter", (GCallback) ____lambda8__feed_reader_feed_server_interface_refresh_feed_list_counter, self, 0);
		_tmp9_ = plug;
		g_signal_connect_object (_tmp9_, "update-article-list", (GCallback) ____lambda9__feed_reader_feed_server_interface_update_article_list, self, 0);
		_tmp10_ = plug;
		g_signal_connect_object (_tmp10_, "show-article-list-overlay", (GCallback) ____lambda10__feed_reader_feed_server_interface_show_article_list_overlay, self, 0);
		_tmp11_ = plug;
		g_signal_connect_object (_tmp11_, "write-articles", (GCallback) ____lambda11__feed_reader_feed_server_interface_write_articles, self, 0);
		_tmp12_ = plug;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (self->priv->m_plugin);
		self->priv->m_plugin = _tmp13_;
		self->priv->m_pluginLoaded = TRUE;
	}
	_g_object_unref0 (plug);
}

static void
___lambda5__peas_extension_set_foreach_func (PeasExtensionSet* set,
                                             PeasPluginInfo* info,
                                             PeasExtension* exten,
                                             gpointer self)
{
	__lambda5_ (self, set, info, exten);
}

gboolean
feed_reader_feed_server_setActivePlugin (FeedReaderFeedServer* self,
                                         const gchar* pluginID)
{
	Block75Data* _data75_;
	gchar* _tmp0_;
	PeasPluginInfo* plugin = NULL;
	PeasEngine* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasPluginInfo* _tmp3_;
	PeasPluginInfo* _tmp4_;
	PeasPluginInfo* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	PeasPluginInfo* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	PeasPluginInfo* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	PeasPluginInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	PeasExtensionSet* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pluginID != NULL, FALSE);
	_data75_ = g_slice_new0 (Block75Data);
	_data75_->_ref_count_ = 1;
	_data75_->self = g_object_ref (self);
	_tmp0_ = g_strdup (pluginID);
	_g_free0 (_data75_->pluginID);
	_data75_->pluginID = _tmp0_;
	self->priv->m_pluginLoaded = FALSE;
	_g_object_unref0 (self->priv->m_plugin);
	self->priv->m_plugin = NULL;
	_tmp1_ = self->priv->m_engine;
	_tmp2_ = peas_engine_get_plugin_info (_tmp1_, _data75_->pluginID);
	_tmp3_ = __vala_PeasPluginInfo_copy0 (_tmp2_);
	plugin = _tmp3_;
	_tmp4_ = plugin;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = string_to_string (_data75_->pluginID);
		_tmp6_ = g_strconcat ("feedserver: failed to load info for \"", _tmp5_, "\"", NULL);
		_tmp7_ = _tmp6_;
		feed_reader_logger_error (_tmp7_);
		_g_free0 (_tmp7_);
		result = self->priv->m_pluginLoaded;
		__vala_PeasPluginInfo_free0 (plugin);
		block75_data_unref (_data75_);
		_data75_ = NULL;
		return result;
	}
	_tmp8_ = plugin;
	_tmp9_ = peas_plugin_info_get_name (_tmp8_);
	_tmp10_ = g_strconcat ("Plugin Name: ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	feed_reader_logger_info (_tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = plugin;
	_tmp13_ = peas_plugin_info_get_version (_tmp12_);
	_tmp14_ = g_strconcat ("Plugin Version: ", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	feed_reader_logger_info (_tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = plugin;
	_tmp17_ = peas_plugin_info_get_website (_tmp16_);
	_tmp18_ = g_strconcat ("Plugin Website: ", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	feed_reader_logger_info (_tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = plugin;
	_tmp21_ = peas_plugin_info_get_module_dir (_tmp20_);
	_tmp22_ = g_strconcat ("Plugin Dir: ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	feed_reader_logger_info (_tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = g_strdup (_data75_->pluginID);
	_g_free0 (self->priv->m_activeExtension);
	self->priv->m_activeExtension = _tmp24_;
	_tmp25_ = self->priv->m_extensions;
	peas_extension_set_foreach (_tmp25_, ___lambda5__peas_extension_set_foreach_func, _data75_);
	result = self->priv->m_pluginLoaded;
	__vala_PeasPluginInfo_free0 (plugin);
	block75_data_unref (_data75_);
	_data75_ = NULL;
	return result;
}

FeedReaderFeedServerInterface*
feed_reader_feed_server_getActivePlugin (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	FeedReaderFeedServerInterface* _tmp1_;
	FeedReaderFeedServerInterface* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_plugin;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
feed_reader_feed_server_syncContent (FeedReaderFeedServer* self,
                                     GCancellable* cancellable)
{
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp0_;
	gboolean _tmp27_ = FALSE;
	FeedReaderDropArticles drop_articles = 0;
	GSettings* _tmp28_;
	GSettings* _tmp29_;
	FeedReaderDropArticles _tmp30_;
	GDateTime* since = NULL;
	GDateTime* _tmp31_;
	FeedReaderDataBase* _tmp32_;
	gint unread = 0;
	gint max = 0;
	gchar* row_id = NULL;
	FeedReaderDataBase* _tmp43_;
	gchar* _tmp44_;
	gint _tmp45_ = 0;
	const gchar* _tmp46_;
	gint before = 0;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp52_ = FALSE;
	FeedReaderDataBase* _tmp53_;
	gint _tmp54_ = 0;
	const gchar* _tmp55_;
	gint new_and_unread = 0;
	FeedReaderDataBase* _tmp57_;
	FeedReaderDataBase* _tmp58_;
	gchar* _tmp59_;
	gint _tmp60_ = 0;
	const gchar* _tmp61_;
	gint after = 0;
	gint newArticles = 0;
	gint* article_max_age_days = NULL;
	gint* _tmp63_;
	gint* _tmp64_;
	gint last_modified = 0;
	FeedReaderDataBase* _tmp67_;
	GSettings* _tmp70_;
	GSettings* _tmp71_;
	FeedReaderDataBase* _tmp72_;
	FeedReaderFeedReaderBackend* _tmp73_;
	FeedReaderFeedReaderBackend* _tmp74_;
	g_return_if_fail (self != NULL);
	if (!feed_reader_feed_server_serverAvailable (self)) {
		feed_reader_logger_debug ("FeedServer: can't sync - not logged in or unreachable");
		return;
	}
	_tmp0_ = feed_reader_data_base_writeAccess ();
	db = _tmp0_;
	if (feed_reader_feed_server_syncFeedsAndCategories (self)) {
		GeeLinkedList* categories = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* feeds = NULL;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* tags = NULL;
		GeeLinkedList* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GeeLinkedList* _tmp5_;
		GeeLinkedList* _tmp6_;
		GeeLinkedList* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		FeedReaderDataBase* _tmp10_;
		FeedReaderDataBase* _tmp11_;
		GeeLinkedList* _tmp12_;
		FeedReaderDataBase* _tmp13_;
		FeedReaderDataBase* _tmp14_;
		FeedReaderDataBase* _tmp15_;
		GeeLinkedList* _tmp16_;
		FeedReaderDataBase* _tmp17_;
		FeedReaderDataBase* _tmp18_;
		FeedReaderDataBase* _tmp19_;
		FeedReaderDataBase* _tmp20_;
		GeeLinkedList* _tmp21_;
		FeedReaderDataBase* _tmp22_;
		GeeLinkedList* _tmp23_;
		FeedReaderDataBase* _tmp24_;
		FeedReaderFeedReaderBackend* _tmp25_;
		FeedReaderFeedReaderBackend* _tmp26_;
		_tmp1_ = gee_linked_list_new (FEED_READER_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		categories = _tmp1_;
		_tmp2_ = gee_linked_list_new (FEED_READER_TYPE_FEED, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		feeds = _tmp2_;
		_tmp3_ = gee_linked_list_new (FEED_READER_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		tags = _tmp3_;
		if (cancellable != NULL) {
			_tmp4_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_g_object_unref0 (tags);
			_g_object_unref0 (feeds);
			_g_object_unref0 (categories);
			_g_object_unref0 (db);
			return;
		}
		feed_reader_feed_server_syncProgress (self, _ ("Getting feeds and categories"));
		_tmp5_ = feeds;
		_tmp6_ = categories;
		_tmp7_ = tags;
		if (!feed_reader_feed_server_getFeedsAndCats (self, (GeeList*) _tmp5_, (GeeList*) _tmp6_, (GeeList*) _tmp7_, cancellable)) {
			feed_reader_logger_error ("FeedServer: something went wrong getting categories and feeds");
			_g_object_unref0 (tags);
			_g_object_unref0 (feeds);
			_g_object_unref0 (categories);
			_g_object_unref0 (db);
			return;
		}
		if (cancellable != NULL) {
			_tmp8_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_g_object_unref0 (tags);
			_g_object_unref0 (feeds);
			_g_object_unref0 (categories);
			_g_object_unref0 (db);
			return;
		}
		if (cancellable != NULL) {
			_tmp9_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_g_object_unref0 (tags);
			_g_object_unref0 (feeds);
			_g_object_unref0 (categories);
			_g_object_unref0 (db);
			return;
		}
		_tmp10_ = db;
		feed_reader_data_base_reset_exists_flag (_tmp10_);
		_tmp11_ = db;
		_tmp12_ = categories;
		feed_reader_data_base_write_categories (_tmp11_, (GeeList*) _tmp12_);
		_tmp13_ = db;
		feed_reader_data_base_delete_nonexisting_categories (_tmp13_);
		_tmp14_ = db;
		feed_reader_data_base_reset_subscribed_flag (_tmp14_);
		_tmp15_ = db;
		_tmp16_ = feeds;
		feed_reader_data_base_write_feeds (_tmp15_, (GeeCollection*) _tmp16_);
		_tmp17_ = db;
		feed_reader_data_base_delete_articles_without_feed (_tmp17_);
		_tmp18_ = db;
		feed_reader_data_base_delete_unsubscribed_feeds (_tmp18_);
		_tmp19_ = db;
		feed_reader_data_base_reset_exists_tag (_tmp19_);
		_tmp20_ = db;
		_tmp21_ = tags;
		feed_reader_data_base_write_tags (_tmp20_, (GeeCollection*) _tmp21_);
		_tmp22_ = db;
		_tmp23_ = tags;
		feed_reader_data_base_update_tags (_tmp22_, (GeeList*) _tmp23_);
		_tmp24_ = db;
		feed_reader_data_base_delete_nonexisting_tags (_tmp24_);
		_tmp25_ = feed_reader_feed_reader_backend_get_default ();
		_tmp26_ = _tmp25_;
		g_signal_emit_by_name (_tmp26_, "new-feed-list");
		_g_object_unref0 (_tmp26_);
		_g_object_unref0 (tags);
		_g_object_unref0 (feeds);
		_g_object_unref0 (categories);
	}
	if (cancellable != NULL) {
		_tmp27_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		_g_object_unref0 (db);
		return;
	}
	_tmp28_ = feed_reader_settings_general ();
	_tmp29_ = _tmp28_;
	_tmp30_ = (FeedReaderDropArticles) g_settings_get_enum (_tmp29_, "drop-articles-after");
	_g_object_unref0 (_tmp29_);
	drop_articles = _tmp30_;
	_tmp31_ = feed_reader_drop_articles_to_start_date (drop_articles);
	since = _tmp31_;
	_tmp32_ = db;
	if (!feed_reader_data_base_read_only_isTableEmpty ((FeedReaderDataBaseReadOnly*) _tmp32_, "articles")) {
		GDateTime* last_sync = NULL;
		GSettings* _tmp33_;
		GSettings* _tmp34_;
		GDateTime* _tmp35_;
		GDateTime* _tmp36_;
		gboolean _tmp37_ = FALSE;
		GDateTime* _tmp38_;
		_tmp33_ = feed_reader_settings_state ();
		_tmp34_ = _tmp33_;
		_tmp35_ = g_date_time_new_from_unix_utc ((gint64) g_settings_get_int (_tmp34_, "last-sync"));
		_tmp36_ = _tmp35_;
		_g_object_unref0 (_tmp34_);
		last_sync = _tmp36_;
		_tmp38_ = since;
		if (_tmp38_ == NULL) {
			_tmp37_ = TRUE;
		} else {
			GDateTime* _tmp39_;
			GDateTime* _tmp40_;
			_tmp39_ = last_sync;
			_tmp40_ = since;
			_tmp37_ = g_date_time_to_unix (_tmp39_) > g_date_time_to_unix (_tmp40_);
		}
		if (_tmp37_) {
			GDateTime* _tmp41_;
			GDateTime* _tmp42_;
			_tmp41_ = last_sync;
			_tmp42_ = _g_date_time_ref0 (_tmp41_);
			_g_date_time_unref0 (since);
			since = _tmp42_;
		}
		_g_date_time_unref0 (last_sync);
	}
	unread = feed_reader_feed_server_getUnreadCount (self);
	max = feed_reader_feed_server_ArticleSyncCount (self);
	feed_reader_feed_server_syncProgress (self, _ ("Getting articles"));
	_tmp43_ = db;
	_tmp44_ = feed_reader_data_base_read_only_getMaxID ((FeedReaderDataBaseReadOnly*) _tmp43_, "articles", "rowid");
	row_id = _tmp44_;
	_tmp46_ = row_id;
	if (_tmp46_ != NULL) {
		const gchar* _tmp47_;
		_tmp47_ = row_id;
		_tmp45_ = atoi (_tmp47_);
	} else {
		_tmp45_ = 0;
	}
	before = _tmp45_;
	if (unread > max) {
		_tmp48_ = feed_reader_feed_server_useMaxArticles (self);
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		GDateTime* _tmp49_;
		GDateTime* _tmp50_;
		_tmp49_ = since;
		feed_reader_feed_server_getArticles (self, 20, FEED_READER_ARTICLE_STATUS_MARKED, _tmp49_, NULL, FALSE, cancellable);
		_tmp50_ = since;
		feed_reader_feed_server_getArticles (self, unread, FEED_READER_ARTICLE_STATUS_UNREAD, _tmp50_, NULL, FALSE, cancellable);
	} else {
		GDateTime* _tmp51_;
		_tmp51_ = since;
		feed_reader_feed_server_getArticles (self, max, FEED_READER_ARTICLE_STATUS_ALL, _tmp51_, NULL, FALSE, cancellable);
	}
	if (cancellable != NULL) {
		_tmp52_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		_g_free0 (row_id);
		_g_date_time_unref0 (since);
		_g_object_unref0 (db);
		return;
	}
	_tmp53_ = db;
	feed_reader_data_base_updateFTS (_tmp53_);
	_tmp55_ = row_id;
	if (_tmp55_ != NULL) {
		const gchar* _tmp56_;
		_tmp56_ = row_id;
		_tmp54_ = atoi (_tmp56_);
	} else {
		_tmp54_ = 0;
	}
	_tmp57_ = db;
	new_and_unread = feed_reader_data_base_read_only_get_new_unread_count ((FeedReaderDataBaseReadOnly*) _tmp57_, _tmp54_);
	_tmp58_ = db;
	_tmp59_ = feed_reader_data_base_read_only_getMaxID ((FeedReaderDataBaseReadOnly*) _tmp58_, "articles", "rowid");
	_g_free0 (row_id);
	row_id = _tmp59_;
	_tmp61_ = row_id;
	if (_tmp61_ != NULL) {
		const gchar* _tmp62_;
		_tmp62_ = row_id;
		_tmp60_ = atoi (_tmp62_);
	} else {
		_tmp60_ = 0;
	}
	after = _tmp60_;
	newArticles = after - before;
	if (newArticles > 0) {
		feed_reader_notification_send ((guint) newArticles, new_and_unread);
	}
	_tmp63_ = feed_reader_drop_articles_to_days (drop_articles);
	article_max_age_days = _tmp63_;
	_tmp64_ = article_max_age_days;
	if (_tmp64_ != NULL) {
		FeedReaderDataBase* _tmp65_;
		gint* _tmp66_;
		_tmp65_ = db;
		_tmp66_ = article_max_age_days;
		feed_reader_data_base_dropOldArticles (_tmp65_, *_tmp66_);
	}
	_tmp67_ = db;
	last_modified = feed_reader_data_base_read_only_getLastModified ((FeedReaderDataBaseReadOnly*) _tmp67_);
	if (last_modified == 0) {
		GDateTime* _tmp68_;
		GDateTime* _tmp69_;
		_tmp68_ = g_date_time_new_now_local ();
		_tmp69_ = _tmp68_;
		last_modified = (gint) g_date_time_to_unix (_tmp69_);
		_g_date_time_unref0 (_tmp69_);
	}
	_tmp70_ = feed_reader_settings_state ();
	_tmp71_ = _tmp70_;
	g_settings_set_int (_tmp71_, "last-sync", last_modified);
	_g_object_unref0 (_tmp71_);
	_tmp72_ = db;
	feed_reader_data_base_checkpoint (_tmp72_);
	_tmp73_ = feed_reader_feed_reader_backend_get_default ();
	_tmp74_ = _tmp73_;
	g_signal_emit_by_name (_tmp74_, "new-feed-list");
	_g_object_unref0 (_tmp74_);
	_g_free0 (article_max_age_days);
	_g_free0 (row_id);
	_g_date_time_unref0 (since);
	_g_object_unref0 (db);
	return;
}

void
feed_reader_feed_server_InitSyncContent (FeedReaderFeedServer* self,
                                         GCancellable* cancellable)
{
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp0_;
	gboolean _tmp17_ = FALSE;
	FeedReaderDropArticles drop_articles = 0;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	FeedReaderDropArticles _tmp20_;
	GDateTime* since = NULL;
	GDateTime* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	GDateTime* _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GDateTime* _tmp46_;
	gboolean _tmp47_ = FALSE;
	FeedReaderDataBase* _tmp48_;
	GSettings* _tmp49_;
	GSettings* _tmp50_;
	gint last_modified = 0;
	FeedReaderDataBase* _tmp51_;
	GSettings* _tmp54_;
	GSettings* _tmp55_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_debug ("FeedServer: initial sync");
	_tmp0_ = feed_reader_data_base_writeAccess ();
	db = _tmp0_;
	if (feed_reader_feed_server_syncFeedsAndCategories (self)) {
		GeeLinkedList* categories = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* feeds = NULL;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* tags = NULL;
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		GeeLinkedList* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		FeedReaderDataBase* _tmp9_;
		GeeLinkedList* _tmp10_;
		FeedReaderDataBase* _tmp11_;
		GeeLinkedList* _tmp12_;
		FeedReaderDataBase* _tmp13_;
		GeeLinkedList* _tmp14_;
		FeedReaderFeedReaderBackend* _tmp15_;
		FeedReaderFeedReaderBackend* _tmp16_;
		_tmp1_ = gee_linked_list_new (FEED_READER_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		categories = _tmp1_;
		_tmp2_ = gee_linked_list_new (FEED_READER_TYPE_FEED, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		feeds = _tmp2_;
		_tmp3_ = gee_linked_list_new (FEED_READER_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		tags = _tmp3_;
		feed_reader_feed_server_syncProgress (self, _ ("Getting feeds and categories"));
		_tmp4_ = feeds;
		_tmp5_ = categories;
		_tmp6_ = tags;
		feed_reader_feed_server_getFeedsAndCats (self, (GeeList*) _tmp4_, (GeeList*) _tmp5_, (GeeList*) _tmp6_, cancellable);
		if (cancellable != NULL) {
			_tmp7_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_g_object_unref0 (tags);
			_g_object_unref0 (feeds);
			_g_object_unref0 (categories);
			_g_object_unref0 (db);
			return;
		}
		if (cancellable != NULL) {
			_tmp8_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_g_object_unref0 (tags);
			_g_object_unref0 (feeds);
			_g_object_unref0 (categories);
			_g_object_unref0 (db);
			return;
		}
		_tmp9_ = db;
		_tmp10_ = categories;
		feed_reader_data_base_write_categories (_tmp9_, (GeeList*) _tmp10_);
		_tmp11_ = db;
		_tmp12_ = feeds;
		feed_reader_data_base_write_feeds (_tmp11_, (GeeCollection*) _tmp12_);
		_tmp13_ = db;
		_tmp14_ = tags;
		feed_reader_data_base_write_tags (_tmp13_, (GeeCollection*) _tmp14_);
		_tmp15_ = feed_reader_feed_reader_backend_get_default ();
		_tmp16_ = _tmp15_;
		g_signal_emit_by_name (_tmp16_, "new-feed-list");
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (tags);
		_g_object_unref0 (feeds);
		_g_object_unref0 (categories);
	}
	if (cancellable != NULL) {
		_tmp17_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_g_object_unref0 (db);
		return;
	}
	_tmp18_ = feed_reader_settings_general ();
	_tmp19_ = _tmp18_;
	_tmp20_ = (FeedReaderDropArticles) g_settings_get_enum (_tmp19_, "drop-articles-after");
	_g_object_unref0 (_tmp19_);
	drop_articles = _tmp20_;
	_tmp21_ = feed_reader_drop_articles_to_start_date (drop_articles);
	since = _tmp21_;
	feed_reader_feed_server_syncProgress (self, _ ("Getting starred articles"));
	_tmp22_ = feed_reader_settings_general ();
	_tmp23_ = _tmp22_;
	_tmp24_ = since;
	feed_reader_feed_server_getArticles (self, g_settings_get_int (_tmp23_, "max-articles"), FEED_READER_ARTICLE_STATUS_MARKED, _tmp24_, NULL, FALSE, cancellable);
	_g_object_unref0 (_tmp23_);
	if (cancellable != NULL) {
		_tmp25_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		_g_date_time_unref0 (since);
		_g_object_unref0 (db);
		return;
	}
	feed_reader_feed_server_syncProgress (self, _ ("Getting tagged articles"));
	{
		GeeList* _tag_item_list = NULL;
		FeedReaderDataBase* _tmp26_;
		GeeList* _tmp27_;
		gint _tag_item_size = 0;
		GeeList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _tag_item_index = 0;
		_tmp26_ = db;
		_tmp27_ = feed_reader_data_base_read_only_read_tags ((FeedReaderDataBaseReadOnly*) _tmp26_);
		_tag_item_list = _tmp27_;
		_tmp28_ = _tag_item_list;
		_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tag_item_size = _tmp30_;
		_tag_item_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			FeedReaderTag* tag_item = NULL;
			GeeList* _tmp33_;
			gpointer _tmp34_;
			GSettings* _tmp35_;
			GSettings* _tmp36_;
			GDateTime* _tmp37_;
			FeedReaderTag* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_ = FALSE;
			_tag_item_index = _tag_item_index + 1;
			_tmp31_ = _tag_item_index;
			_tmp32_ = _tag_item_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _tag_item_list;
			_tmp34_ = gee_list_get (_tmp33_, _tag_item_index);
			tag_item = (FeedReaderTag*) _tmp34_;
			_tmp35_ = feed_reader_settings_general ();
			_tmp36_ = _tmp35_;
			_tmp37_ = since;
			_tmp38_ = tag_item;
			_tmp39_ = feed_reader_tag_getTagID (_tmp38_);
			_tmp40_ = _tmp39_;
			feed_reader_feed_server_getArticles (self, g_settings_get_int (_tmp36_, "max-articles") / 8, FEED_READER_ARTICLE_STATUS_ALL, _tmp37_, _tmp40_, TRUE, cancellable);
			_g_free0 (_tmp40_);
			_g_object_unref0 (_tmp36_);
			if (cancellable != NULL) {
				_tmp41_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp41_ = FALSE;
			}
			if (_tmp41_) {
				_g_object_unref0 (tag_item);
				_g_object_unref0 (_tag_item_list);
				_g_date_time_unref0 (since);
				_g_object_unref0 (db);
				return;
			}
			_g_object_unref0 (tag_item);
		}
		_g_object_unref0 (_tag_item_list);
	}
	if (feed_reader_feed_server_useMaxArticles (self)) {
		GSettings* _tmp42_;
		GSettings* _tmp43_;
		GDateTime* _tmp44_;
		_tmp42_ = feed_reader_settings_general ();
		_tmp43_ = _tmp42_;
		_tmp44_ = since;
		feed_reader_feed_server_getArticles (self, g_settings_get_int (_tmp43_, "max-articles"), FEED_READER_ARTICLE_STATUS_ALL, _tmp44_, NULL, FALSE, cancellable);
		_g_object_unref0 (_tmp43_);
	}
	if (cancellable != NULL) {
		_tmp45_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		_g_date_time_unref0 (since);
		_g_object_unref0 (db);
		return;
	}
	feed_reader_feed_server_syncProgress (self, _ ("Getting unread articles"));
	_tmp46_ = since;
	feed_reader_feed_server_getArticles (self, feed_reader_feed_server_getUnreadCount (self), FEED_READER_ARTICLE_STATUS_UNREAD, _tmp46_, NULL, FALSE, cancellable);
	if (cancellable != NULL) {
		_tmp47_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		_g_date_time_unref0 (since);
		_g_object_unref0 (db);
		return;
	}
	_tmp48_ = db;
	feed_reader_data_base_updateFTS (_tmp48_);
	_tmp49_ = feed_reader_settings_general ();
	_tmp50_ = _tmp49_;
	g_settings_reset (_tmp50_, "content-grabber");
	_g_object_unref0 (_tmp50_);
	_tmp51_ = db;
	last_modified = feed_reader_data_base_read_only_getLastModified ((FeedReaderDataBaseReadOnly*) _tmp51_);
	if (last_modified == 0) {
		GDateTime* _tmp52_;
		GDateTime* _tmp53_;
		_tmp52_ = g_date_time_new_now_local ();
		_tmp53_ = _tmp52_;
		last_modified = (gint) g_date_time_to_unix (_tmp53_);
		_g_date_time_unref0 (_tmp53_);
	}
	_tmp54_ = feed_reader_settings_state ();
	_tmp55_ = _tmp54_;
	g_settings_set_int (_tmp55_, "last-sync", last_modified);
	_g_object_unref0 (_tmp55_);
	_g_date_time_unref0 (since);
	_g_object_unref0 (db);
	return;
}

static void
feed_reader_feed_server_writeArticles (FeedReaderFeedServer* self,
                                       GeeList* articles)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) articles);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		FeedReaderDataBase* db = NULL;
		FeedReaderDataBase* _tmp2_;
		FeedReaderDataBase* _tmp3_;
		GeeArrayList* new_articles = NULL;
		GeeArrayList* _tmp4_;
		FeedReaderDataBase* _tmp14_;
		GeeArrayList* _tmp15_;
		FeedReaderFeedReaderBackend* _tmp16_;
		FeedReaderFeedReaderBackend* _tmp17_;
		FeedReaderFeedReaderBackend* _tmp18_;
		FeedReaderFeedReaderBackend* _tmp19_;
		_tmp2_ = feed_reader_data_base_writeAccess ();
		db = _tmp2_;
		_tmp3_ = db;
		feed_reader_data_base_update_articles (_tmp3_, articles);
		_tmp4_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		new_articles = _tmp4_;
		{
			GeeList* _article_list = NULL;
			gint _article_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _article_index = 0;
			_article_list = articles;
			_tmp5_ = _article_list;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_article_size = _tmp7_;
			_article_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				FeedReaderArticle* article = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				GeeArrayList* _tmp12_;
				FeedReaderArticle* _tmp13_;
				_article_index = _article_index + 1;
				_tmp8_ = _article_index;
				_tmp9_ = _article_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _article_list;
				_tmp11_ = gee_list_get (_tmp10_, _article_index);
				article = (FeedReaderArticle*) _tmp11_;
				_tmp12_ = new_articles;
				_tmp13_ = article;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp12_, 0, _tmp13_);
				_g_object_unref0 (article);
			}
		}
		_tmp14_ = db;
		_tmp15_ = new_articles;
		feed_reader_data_base_write_articles (_tmp14_, (GeeList*) _tmp15_);
		_tmp16_ = feed_reader_feed_reader_backend_get_default ();
		_tmp17_ = _tmp16_;
		g_signal_emit_by_name (_tmp17_, "refresh-feed-list-counter");
		_g_object_unref0 (_tmp17_);
		_tmp18_ = feed_reader_feed_reader_backend_get_default ();
		_tmp19_ = _tmp18_;
		g_signal_emit_by_name (_tmp19_, "update-article-list");
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (new_articles);
		_g_object_unref0 (db);
	}
}

static void
feed_reader_feed_server_grabContent_data_free (gpointer _data)
{
	feed_reader_feed_server_grabContentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (feed_reader_feed_server_grabContentData, _data_);
}

void
feed_reader_feed_server_grabContent (FeedReaderFeedServer* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	feed_reader_feed_server_grabContentData* _data_;
	FeedReaderFeedServer* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (feed_reader_feed_server_grabContentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_feed_server_grabContent_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	feed_reader_feed_server_grabContent_co (_data_);
}

void
feed_reader_feed_server_grabContent_finish (FeedReaderFeedServer* self,
                                            GAsyncResult* _res_)
{
	feed_reader_feed_server_grabContentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static Block76Data*
block76_data_ref (Block76Data* _data76_)
{
	g_atomic_int_inc (&_data76_->_ref_count_);
	return _data76_;
}

static void
block76_data_unref (void * _userdata_)
{
	Block76Data* _data76_;
	_data76_ = (Block76Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data76_->_ref_count_)) {
		FeedReaderFeedServer* self;
		self = _data76_->self;
		_vala_clear_GMutex (&_data76_->mutex);
		_g_object_unref0 (_data76_->new_article_content);
		_g_object_unref0 (_data76_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block76Data, _data76_);
	}
}

static Block77Data*
block77_data_ref (Block77Data* _data77_)
{
	g_atomic_int_inc (&_data77_->_ref_count_);
	return _data77_;
}

static void
block77_data_unref (void * _userdata_)
{
	Block77Data* _data77_;
	_data77_ = (Block77Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data77_->_ref_count_)) {
		FeedReaderFeedServer* self;
		self = _data77_->_data76_->self;
		_g_object_unref0 (_data77_->session);
		block76_data_unref (_data77_->_data76_);
		_data77_->_data76_ = NULL;
		g_slice_free (Block77Data, _data77_);
	}
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
____lambda14_ (Block77Data* _data77_,
               FeedReaderArticle* article)
{
	Block76Data* _data76_;
	FeedReaderFeedServer* self;
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp44_ = FALSE;
	gint _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	_data76_ = _data77_->_data76_;
	self = _data76_->self;
	g_return_if_fail (article != NULL);
	if (_data76_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data76_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_g_object_unref0 (article);
		return;
	}
	_tmp1_ = feed_reader_settings_general ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "content-grabber");
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		FeedReaderGrabber* grabber = NULL;
		SoupSession* _tmp4_;
		FeedReaderGrabber* _tmp5_;
		FeedReaderGrabber* _tmp6_;
		_tmp4_ = _data77_->session;
		_tmp5_ = feed_reader_grabber_new (_tmp4_, article);
		grabber = _tmp5_;
		_tmp6_ = grabber;
		if (feed_reader_grabber_process (_tmp6_, _data76_->cancellable)) {
			FeedReaderGrabber* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			gchar* html = NULL;
			FeedReaderGrabber* _tmp28_;
			gchar* _tmp29_;
			gchar* xml = NULL;
			gchar* _tmp30_;
			const gchar* _tmp41_;
			_tmp7_ = grabber;
			feed_reader_grabber_print (_tmp7_);
			_tmp9_ = feed_reader_article_getAuthor (article);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, "") == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				FeedReaderGrabber* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = grabber;
				_tmp13_ = feed_reader_grabber_getAuthor (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_ != NULL;
				_g_free0 (_tmp14_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				FeedReaderGrabber* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp15_ = grabber;
				_tmp16_ = feed_reader_grabber_getAuthor (_tmp15_);
				_tmp17_ = _tmp16_;
				feed_reader_article_setAuthor (article, _tmp17_);
				_g_free0 (_tmp17_);
			}
			_tmp19_ = feed_reader_article_getTitle (article);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				FeedReaderGrabber* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp22_ = grabber;
				_tmp23_ = feed_reader_grabber_getTitle (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp18_ = _tmp24_ != NULL;
				_g_free0 (_tmp24_);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				FeedReaderGrabber* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp25_ = grabber;
				_tmp26_ = feed_reader_grabber_getTitle (_tmp25_);
				_tmp27_ = _tmp26_;
				feed_reader_article_setTitle (article, _tmp27_);
				_g_free0 (_tmp27_);
			}
			_tmp28_ = grabber;
			_tmp29_ = feed_reader_grabber_getArticle (_tmp28_);
			html = _tmp29_;
			_tmp30_ = g_strdup ("<?xml");
			xml = _tmp30_;
			while (TRUE) {
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gint end = 0;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp31_ = html;
				_tmp32_ = xml;
				if (!g_str_has_prefix (_tmp31_, _tmp32_)) {
					break;
				}
				_tmp33_ = html;
				end = string_index_of_char (_tmp33_, (gunichar) '>', 0);
				_tmp34_ = html;
				_tmp35_ = html;
				_tmp36_ = strlen (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = string_slice (_tmp34_, (glong) (end + 1), (glong) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = string_chug (_tmp39_);
				_g_free0 (html);
				html = _tmp40_;
				_g_free0 (_tmp39_);
			}
			_tmp41_ = html;
			feed_reader_article_setHTML (article, _tmp41_);
			_g_free0 (xml);
			_g_free0 (html);
		} else {
			SoupSession* _tmp42_;
			_tmp42_ = _data77_->session;
			feed_reader_feed_server_downloadImages (self, _tmp42_, article, _data76_->cancellable);
		}
		_g_object_unref0 (grabber);
	} else {
		SoupSession* _tmp43_;
		_tmp43_ = _data77_->session;
		feed_reader_feed_server_downloadImages (self, _tmp43_, article, _data76_->cancellable);
	}
	if (_data76_->cancellable == NULL) {
		_tmp44_ = TRUE;
	} else {
		_tmp44_ = !g_cancellable_is_cancelled (_data76_->cancellable);
	}
	if (_tmp44_) {
		GeeArrayList* _tmp45_;
		g_mutex_lock (&_data76_->mutex);
		_tmp45_ = _data76_->new_article_content;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, article);
		g_mutex_unlock (&_data76_->mutex);
	}
	_data76_->i = _data76_->i + 1;
	_tmp46_ = _data76_->i;
	_tmp47_ = g_strdup_printf ("%i", _data76_->i);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_strdup_printf ("%i", _data76_->size);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strconcat ("Grabbing full content: ", _tmp48_, " / ", _tmp50_, NULL);
	_tmp52_ = _tmp51_;
	feed_reader_feed_server_syncProgress (self, _ (_tmp52_));
	_g_free0 (_tmp52_);
	_g_free0 (_tmp50_);
	_g_free0 (_tmp48_);
	_g_object_unref0 (article);
}

static void
_____lambda14__gfunc (gpointer data,
                      gpointer self)
{
	____lambda14_ (self, (FeedReaderArticle*) data);
}

static void
vala__g_thread_pool_free_wrapper (GThreadPool* pool,
                                  gboolean immediate,
                                  gboolean wait)
{
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
	_tmp0_ = pool;
	pool = NULL;
	ptr = _tmp0_;
	_tmp1_ = ptr;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_;
		_tmp2_ = ptr;
		g_thread_pool_free ((GThreadPool*) _tmp2_, immediate, wait);
	}
	_g_thread_pool_free0 (pool);
}

static gboolean
feed_reader_feed_server_grabContent_co (feed_reader_feed_server_grabContentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data76_ = g_slice_new0 (Block76Data);
	_data_->_data76_->_ref_count_ = 1;
	_data_->_data76_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data76_->cancellable);
	_data_->_data76_->cancellable = _data_->cancellable;
	_data_->_data76_->_async_data_ = _data_;
	_data_->_tmp1_ = feed_reader_settings_general ();
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = !g_settings_get_boolean (_data_->_tmp2_, "download-images");
	_g_object_unref0 (_data_->_tmp2_);
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = feed_reader_settings_general ();
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp0_ = !g_settings_get_boolean (_data_->_tmp5_, "content-grabber");
		_g_object_unref0 (_data_->_tmp5_);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		block76_data_unref (_data_->_data76_);
		_data_->_data76_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	feed_reader_logger_debug ("FeedServer: grabContent");
	_data_->_tmp6_ = feed_reader_data_base_writeAccess ();
	_data_->db = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->db;
	_data_->_tmp8_ = feed_reader_data_base_read_only_readUnfetchedArticles ((FeedReaderDataBaseReadOnly*) _data_->_tmp7_);
	_data_->articles = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->articles;
	_data_->_tmp10_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_data76_->size = _data_->_tmp11_;
	_data_->_data76_->i = 0;
	_data_->_tmp12_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->_data76_->new_article_content = _data_->_tmp12_;
	g_mutex_init (&_data_->_data76_->mutex);
	if (_data_->_data76_->size > 0) {
		_data_->_data77_ = g_slice_new0 (Block77Data);
		_data_->_data77_->_ref_count_ = 1;
		_data_->_data77_->_data76_ = block76_data_ref (_data_->_data76_);
		_data_->_tmp13_ = soup_session_new ();
		_data_->_data77_->session = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->_data77_->session;
		g_object_set (_data_->_tmp14_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
		_data_->_tmp15_ = _data_->_data77_->session;
		g_object_set (_data_->_tmp15_, "timeout", (guint) 5, NULL);
		_data_->_tmp16_ = _data_->_data77_->session;
		g_object_set (_data_->_tmp16_, "ssl-strict", FALSE, NULL);
		{
			_data_->_tmp17_ = g_thread_pool_new (_____lambda14__gfunc, _data_->_data77_, (gint) g_get_num_processors (), TRUE, &_data_->_inner_error0_);
			_data_->threads = _data_->_tmp17_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			{
				_data_->_tmp18_ = _data_->articles;
				_data_->_Article_list = _data_->_tmp18_;
				_data_->_tmp19_ = _data_->_Article_list;
				_data_->_tmp20_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp19_);
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_Article_size = _data_->_tmp21_;
				_data_->_Article_index = -1;
				while (TRUE) {
					_data_->_Article_index = _data_->_Article_index + 1;
					_data_->_tmp22_ = _data_->_Article_index;
					_data_->_tmp23_ = _data_->_Article_size;
					if (!(_data_->_tmp22_ < _data_->_tmp23_)) {
						break;
					}
					_data_->_tmp24_ = _data_->_Article_list;
					_data_->_tmp25_ = gee_list_get (_data_->_tmp24_, _data_->_Article_index);
					_data_->Article = (FeedReaderArticle*) _data_->_tmp25_;
					_data_->_tmp26_ = _data_->threads;
					_data_->_tmp27_ = _data_->Article;
					_data_->_tmp28_ = _g_object_ref0 (_data_->_tmp27_);
					g_thread_pool_push (_data_->_tmp26_, _data_->_tmp28_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->Article);
						_g_thread_pool_free0 (_data_->threads);
						goto __catch0_g_error;
					}
					_g_object_unref0 (_data_->Article);
				}
			}
			_data_->immediate = FALSE;
			_data_->wait = TRUE;
			_data_->_tmp29_ = _data_->threads;
			_data_->threads = NULL;
			vala__g_thread_pool_free_wrapper (_data_->_tmp29_, _data_->immediate, _data_->wait);
			_g_thread_pool_free0 (_data_->threads);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp30_ = _data_->e;
			_data_->_tmp31_ = _data_->_tmp30_->message;
			_data_->_tmp32_ = g_strconcat ("FeedServer.grabContent: ", _data_->_tmp31_, NULL);
			_data_->_tmp33_ = _data_->_tmp32_;
			feed_reader_logger_error (_data_->_tmp33_);
			_g_free0 (_data_->_tmp33_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block77_data_unref (_data_->_data77_);
			_data_->_data77_ = NULL;
			_g_object_unref0 (_data_->articles);
			_g_object_unref0 (_data_->db);
			block76_data_unref (_data_->_data76_);
			_data_->_data76_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp34_ = _data_->_data76_->new_article_content;
			_data_->_content_list = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->_content_list;
			_data_->_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp35_);
			_data_->_tmp37_ = _data_->_tmp36_;
			_data_->_content_size = _data_->_tmp37_;
			_data_->_content_index = -1;
			while (TRUE) {
				_data_->_content_index = _data_->_content_index + 1;
				_data_->_tmp38_ = _data_->_content_index;
				_data_->_tmp39_ = _data_->_content_size;
				if (!(_data_->_tmp38_ < _data_->_tmp39_)) {
					break;
				}
				_data_->_tmp40_ = _data_->_content_list;
				_data_->_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp40_, _data_->_content_index);
				_data_->content = (FeedReaderArticle*) _data_->_tmp41_;
				if (_data_->_data76_->cancellable != NULL) {
					_data_->_tmp42_ = g_cancellable_is_cancelled (_data_->_data76_->cancellable);
				} else {
					_data_->_tmp42_ = FALSE;
				}
				if (_data_->_tmp42_) {
					_g_object_unref0 (_data_->content);
					block77_data_unref (_data_->_data77_);
					_data_->_data77_ = NULL;
					_g_object_unref0 (_data_->articles);
					_g_object_unref0 (_data_->db);
					block76_data_unref (_data_->_data76_);
					_data_->_data76_ = NULL;
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp43_ = _data_->db;
				_data_->_tmp44_ = _data_->content;
				feed_reader_data_base_writeContent (_data_->_tmp43_, _data_->_tmp44_);
				_g_object_unref0 (_data_->content);
			}
		}
		if (_data_->_data76_->cancellable != NULL) {
			_data_->_tmp45_ = g_cancellable_is_cancelled (_data_->_data76_->cancellable);
		} else {
			_data_->_tmp45_ = FALSE;
		}
		if (_data_->_tmp45_) {
			block77_data_unref (_data_->_data77_);
			_data_->_data77_ = NULL;
			_g_object_unref0 (_data_->articles);
			_g_object_unref0 (_data_->db);
			block76_data_unref (_data_->_data76_);
			_data_->_data76_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp46_ = _data_->db;
		feed_reader_data_base_updateFTS (_data_->_tmp46_);
		block77_data_unref (_data_->_data77_);
		_data_->_data77_ = NULL;
	}
	_g_object_unref0 (_data_->articles);
	_g_object_unref0 (_data_->db);
	block76_data_unref (_data_->_data76_);
	_data_->_data76_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
feed_reader_feed_server_downloadImages (FeedReaderFeedServer* self,
                                        SoupSession* session,
                                        FeedReaderArticle* article,
                                        GCancellable* cancellable)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gboolean _tmp2_;
	htmlParserCtxt* html_cntx = NULL;
	htmlParserCtxt* _tmp3_;
	htmlParserCtxt* _tmp4_;
	xmlDoc* doc = NULL;
	htmlParserCtxt* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	xmlDoc* _tmp8_;
	xmlDoc* _tmp9_;
	xmlDoc* _tmp10_;
	xmlDoc* _tmp11_;
	xmlDoc* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	xmlDoc* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	xmlDoc* _tmp18_;
	xmlDoc* _tmp19_;
	xmlDoc* _tmp20_;
	xmlDoc* _tmp21_;
	xmlDoc* _tmp22_;
	xmlDoc* _tmp23_;
	gboolean _tmp24_ = FALSE;
	xmlDoc* _tmp26_;
	gchar* html = NULL;
	gchar* _tmp27_;
	xmlDoc* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	xmlDoc* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (session != NULL);
	g_return_if_fail (article != NULL);
	_tmp0_ = feed_reader_settings_general ();
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_settings_get_boolean (_tmp1_, "download-images");
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = htmlNewParserCtxt ();
	html_cntx = _tmp3_;
	_tmp4_ = html_cntx;
	htmlCtxtUseOptions (_tmp4_, (gint) (HTML_PARSE_NOERROR + HTML_PARSE_NOWARNING));
	_tmp5_ = html_cntx;
	_tmp6_ = feed_reader_article_getHTML (article);
	_tmp7_ = _tmp6_;
	_tmp8_ = htmlCtxtReadDoc (_tmp5_, (xmlChar*) _tmp7_, "", NULL, 0);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	doc = _tmp9_;
	_tmp10_ = doc;
	if (_tmp10_ == NULL) {
		feed_reader_logger_debug ("Grabber: parsing failed");
		_htmlFreeParserCtxt0 (html_cntx);
		return;
	}
	_tmp11_ = doc;
	feed_reader_grabber_utils_fixIframeSize (_tmp11_, "youtube.com");
	_tmp12_ = doc;
	_tmp13_ = feed_reader_article_getURL (article);
	_tmp14_ = _tmp13_;
	feed_reader_grabber_utils_repairURL ("//img", "src", _tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = doc;
	_tmp16_ = feed_reader_article_getURL (article);
	_tmp17_ = _tmp16_;
	feed_reader_grabber_utils_repairURL ("//iframe", "src", _tmp15_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp18_, "//a[not(node())]");
	_tmp19_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp19_, NULL, "style");
	_tmp20_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp20_, "a", "onclick");
	_tmp21_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp21_, "img", "srcset");
	_tmp22_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp22_, "img", "sizes");
	_tmp23_ = doc;
	feed_reader_grabber_utils_addAttributes (_tmp23_, "a", "target", "_blank");
	if (cancellable != NULL) {
		_tmp24_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		xmlDoc* _tmp25_;
		_tmp25_ = doc;
		_xmlFreeDoc0 (_tmp25_);
		_htmlFreeParserCtxt0 (html_cntx);
		return;
	}
	_tmp26_ = doc;
	feed_reader_grabber_utils_saveImages (session, _tmp26_, article, cancellable);
	_tmp27_ = g_strdup ("");
	html = _tmp27_;
	_tmp28_ = doc;
	xmlDocDumpMemoryEnc (_tmp28_, (xmlChar**) (&_tmp29_), NULL, "UTF-8");
	_g_free0 (html);
	html = _tmp29_;
	_tmp30_ = feed_reader_grabber_utils_postProcessing (&html);
	_g_free0 (html);
	html = _tmp30_;
	_tmp31_ = html;
	feed_reader_article_setHTML (article, _tmp31_);
	_tmp32_ = doc;
	_xmlFreeDoc0 (_tmp32_);
	_g_free0 (html);
	_htmlFreeParserCtxt0 (html_cntx);
}

static gint
feed_reader_feed_server_ArticleSyncCount (FeedReaderFeedServer* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (!feed_reader_feed_server_useMaxArticles (self)) {
		result = -1;
		return result;
	}
	_tmp0_ = feed_reader_settings_general ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_int (_tmp1_, "max-articles");
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
feed_reader_feed_server_grabArticle (const gchar* url)
{
	SoupSession* session = NULL;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	FeedReaderArticle* a = NULL;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	FeedReaderArticle* _tmp6_;
	FeedReaderArticle* _tmp7_;
	FeedReaderGrabber* grabber = NULL;
	SoupSession* _tmp8_;
	FeedReaderArticle* _tmp9_;
	FeedReaderGrabber* _tmp10_;
	FeedReaderGrabber* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (url != NULL);
	_tmp0_ = soup_session_new ();
	session = _tmp0_;
	_tmp1_ = session;
	g_object_set (_tmp1_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp2_ = session;
	g_object_set (_tmp2_, "timeout", (guint) 5, NULL);
	_tmp3_ = session;
	g_object_set (_tmp3_, "ssl-strict", FALSE, NULL);
	_tmp4_ = g_date_time_new_now_local ();
	_tmp5_ = _tmp4_;
	_tmp6_ = feed_reader_article_new ("", "", url, "", FEED_READER_ARTICLE_STATUS_UNREAD, FEED_READER_ARTICLE_STATUS_UNMARKED, "", "", NULL, _tmp5_, 0, NULL, NULL, "", 0);
	_tmp7_ = _tmp6_;
	_g_date_time_unref0 (_tmp5_);
	a = _tmp7_;
	_tmp8_ = session;
	_tmp9_ = a;
	_tmp10_ = feed_reader_grabber_new (_tmp8_, _tmp9_);
	grabber = _tmp10_;
	_tmp11_ = grabber;
	if (feed_reader_grabber_process (_tmp11_, NULL)) {
		FeedReaderGrabber* _tmp12_;
		gchar* html = NULL;
		FeedReaderGrabber* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* title = NULL;
		FeedReaderGrabber* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* xml = NULL;
		gchar* _tmp23_;
		gchar* path = NULL;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp12_ = grabber;
		feed_reader_grabber_print (_tmp12_);
		_tmp13_ = grabber;
		_tmp14_ = feed_reader_grabber_getArticle (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = feed_reader_utils_UTF8fix (_tmp15_, FALSE);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		html = _tmp17_;
		_tmp18_ = grabber;
		_tmp19_ = feed_reader_grabber_getTitle (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = feed_reader_utils_UTF8fix (_tmp20_, TRUE);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		title = _tmp22_;
		_tmp23_ = g_strdup ("<?xml");
		xml = _tmp23_;
		while (TRUE) {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gint end = 0;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp24_ = html;
			_tmp25_ = xml;
			if (!g_str_has_prefix (_tmp24_, _tmp25_)) {
				break;
			}
			_tmp26_ = html;
			end = string_index_of_char (_tmp26_, (gunichar) '>', 0);
			_tmp27_ = html;
			_tmp28_ = html;
			_tmp29_ = strlen (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = string_slice (_tmp27_, (glong) (end + 1), (glong) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = string_chug (_tmp32_);
			_g_free0 (html);
			html = _tmp33_;
			_g_free0 (_tmp32_);
		}
		_tmp34_ = g_get_user_data_dir ();
		_tmp35_ = title;
		_tmp36_ = g_strdup_printf ("/feedreader/debug-article/%s.html", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		path = _tmp39_;
		_tmp40_ = path;
		if (g_file_test (_tmp40_, G_FILE_TEST_EXISTS)) {
			const gchar* _tmp41_;
			_tmp41_ = path;
			g_remove (_tmp41_);
		}
		{
			GFile* file = NULL;
			const gchar* _tmp42_;
			GFile* _tmp43_;
			GFile* parent = NULL;
			GFile* _tmp44_;
			GFile* _tmp45_;
			GFile* _tmp46_;
			GFileOutputStream* stream = NULL;
			GFile* _tmp48_;
			GFileOutputStream* _tmp49_;
			GFileOutputStream* _tmp50_;
			const gchar* _tmp51_;
			guint8* _tmp52_;
			gint _tmp52__length1;
			gint _tmp53_ = 0;
			guint8* _tmp54_;
			gint _tmp54__length1;
			const gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* output = NULL;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp74_;
			GFile* _tmp75_;
			GFileOutputStream* _tmp76_ = NULL;
			GFile* _tmp77_;
			GFileOutputStream* _tmp78_;
			GFileOutputStream* _tmp79_;
			GFileOutputStream* _tmp80_;
			const gchar* _tmp81_;
			guint8* _tmp82_;
			gint _tmp82__length1;
			gint _tmp83_ = 0;
			guint8* _tmp84_;
			gint _tmp84__length1;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			_tmp42_ = path;
			_tmp43_ = g_file_new_for_path (_tmp42_);
			file = _tmp43_;
			_tmp44_ = file;
			_tmp45_ = g_file_get_parent (_tmp44_);
			parent = _tmp45_;
			_tmp46_ = parent;
			if (!g_file_query_exists (_tmp46_, NULL)) {
				GFile* _tmp47_;
				_tmp47_ = parent;
				g_file_make_directory_with_parents (_tmp47_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (parent);
					_g_object_unref0 (file);
					goto __catch0_g_error;
				}
			}
			_tmp48_ = file;
			_tmp49_ = g_file_create (_tmp48_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
			stream = _tmp49_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp50_ = stream;
			_tmp51_ = html;
			_tmp52_ = string_get_data (_tmp51_, &_tmp53_);
			_tmp52__length1 = _tmp53_;
			_tmp54_ = _tmp52_;
			_tmp54__length1 = _tmp52__length1;
			g_output_stream_write ((GOutputStream*) _tmp50_, _tmp54_, (gsize) _tmp54__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp55_ = path;
			_tmp56_ = g_strconcat ("Grabber: article html written to ", _tmp55_, NULL);
			_tmp57_ = _tmp56_;
			feed_reader_logger_debug (_tmp57_);
			_g_free0 (_tmp57_);
			_tmp58_ = html;
			_tmp59_ = feed_reader_utils_UTF8fix (_tmp58_, TRUE);
			output = _tmp59_;
			_tmp61_ = output;
			if (g_strcmp0 (_tmp61_, "") == 0) {
				_tmp60_ = TRUE;
			} else {
				const gchar* _tmp62_;
				_tmp62_ = output;
				_tmp60_ = _tmp62_ == NULL;
			}
			if (_tmp60_) {
				feed_reader_logger_error ("could not generate preview text");
				_g_free0 (output);
				_g_object_unref0 (stream);
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_free0 (xml);
				_g_free0 (title);
				_g_free0 (html);
				_g_object_unref0 (grabber);
				_g_object_unref0 (a);
				_g_object_unref0 (session);
				return;
			}
			_tmp63_ = output;
			_tmp64_ = string_replace (_tmp63_, "\n", " ");
			_g_free0 (output);
			output = _tmp64_;
			_tmp65_ = output;
			_tmp66_ = string_replace (_tmp65_, "_", " ");
			_g_free0 (output);
			output = _tmp66_;
			_tmp67_ = g_get_user_data_dir ();
			_tmp68_ = title;
			_tmp69_ = g_strdup_printf ("/feedreader/debug-article/%s.txt", _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strconcat (_tmp67_, _tmp70_, NULL);
			_g_free0 (path);
			path = _tmp71_;
			_g_free0 (_tmp70_);
			_tmp72_ = path;
			if (g_file_test (_tmp72_, G_FILE_TEST_EXISTS)) {
				const gchar* _tmp73_;
				_tmp73_ = path;
				g_remove (_tmp73_);
			}
			_tmp74_ = path;
			_tmp75_ = g_file_new_for_path (_tmp74_);
			_g_object_unref0 (file);
			file = _tmp75_;
			_tmp77_ = file;
			_tmp78_ = g_file_create (_tmp77_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
			_tmp76_ = _tmp78_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (output);
				_g_object_unref0 (stream);
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp79_ = _tmp76_;
			_tmp76_ = NULL;
			_g_object_unref0 (stream);
			stream = _tmp79_;
			_tmp80_ = stream;
			_tmp81_ = output;
			_tmp82_ = string_get_data (_tmp81_, &_tmp83_);
			_tmp82__length1 = _tmp83_;
			_tmp84_ = _tmp82_;
			_tmp84__length1 = _tmp82__length1;
			g_output_stream_write ((GOutputStream*) _tmp80_, _tmp84_, (gsize) _tmp84__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp76_);
				_g_free0 (output);
				_g_object_unref0 (stream);
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp85_ = path;
			_tmp86_ = g_strconcat ("Grabber: preview written to ", _tmp85_, NULL);
			_tmp87_ = _tmp86_;
			feed_reader_logger_debug (_tmp87_);
			_g_free0 (_tmp87_);
			_g_object_unref0 (_tmp76_);
			_g_free0 (output);
			_g_object_unref0 (stream);
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp88_ = e;
			_tmp89_ = _tmp88_->message;
			_tmp90_ = g_strdup_printf ("FeedServer.grabArticle: %s", _tmp89_);
			_tmp91_ = _tmp90_;
			feed_reader_logger_error (_tmp91_);
			_g_free0 (_tmp91_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_free0 (xml);
			_g_free0 (title);
			_g_free0 (html);
			_g_object_unref0 (grabber);
			_g_object_unref0 (a);
			_g_object_unref0 (session);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (path);
		_g_free0 (xml);
		_g_free0 (title);
		_g_free0 (html);
	} else {
		gchar* _tmp92_;
		gchar* _tmp93_;
		_tmp92_ = g_strconcat ("FeedServer.grabArticle: article could not be processed ", url, NULL);
		_tmp93_ = _tmp92_;
		feed_reader_logger_error (_tmp93_);
		_g_free0 (_tmp93_);
	}
	_g_object_unref0 (grabber);
	_g_object_unref0 (a);
	_g_object_unref0 (session);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
feed_reader_feed_server_grabImages (const gchar* htmlFile,
                                    const gchar* url)
{
	SoupSession* session = NULL;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	htmlParserCtxt* html_cntx = NULL;
	htmlParserCtxt* _tmp4_;
	htmlParserCtxt* _tmp5_;
	xmlDoc* doc = NULL;
	htmlParserCtxt* _tmp6_;
	xmlDoc* _tmp7_;
	xmlDoc* _tmp8_;
	FeedReaderArticle* a = NULL;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	FeedReaderArticle* _tmp11_;
	FeedReaderArticle* _tmp12_;
	xmlDoc* _tmp13_;
	SoupSession* _tmp14_;
	xmlDoc* _tmp15_;
	FeedReaderArticle* _tmp16_;
	gchar* html = NULL;
	gchar* _tmp17_;
	xmlDoc* _tmp18_;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gint pos1 = 0;
	const gchar* _tmp22_;
	gint pos2 = 0;
	xmlDoc* _tmp55_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (htmlFile != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = soup_session_new ();
	session = _tmp0_;
	_tmp1_ = session;
	g_object_set (_tmp1_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp2_ = session;
	g_object_set (_tmp2_, "timeout", (guint) 5, NULL);
	_tmp3_ = session;
	g_object_set (_tmp3_, "ssl-strict", FALSE, NULL);
	_tmp4_ = htmlNewParserCtxt ();
	html_cntx = _tmp4_;
	_tmp5_ = html_cntx;
	htmlCtxtUseOptions (_tmp5_, (gint) (HTML_PARSE_NOERROR + HTML_PARSE_NOWARNING));
	_tmp6_ = html_cntx;
	_tmp7_ = htmlCtxtReadFile (_tmp6_, htmlFile, NULL, 0);
	doc = _tmp7_;
	_tmp8_ = doc;
	if (_tmp8_ == NULL) {
		feed_reader_logger_debug ("Grabber: parsing failed");
		_htmlFreeParserCtxt0 (html_cntx);
		_g_object_unref0 (session);
		return;
	}
	_tmp9_ = g_date_time_new_now_local ();
	_tmp10_ = _tmp9_;
	_tmp11_ = feed_reader_article_new ("", "", url, "", FEED_READER_ARTICLE_STATUS_UNREAD, FEED_READER_ARTICLE_STATUS_UNMARKED, "", "", NULL, _tmp10_, 0, NULL, NULL, "", 0);
	_tmp12_ = _tmp11_;
	_g_date_time_unref0 (_tmp10_);
	a = _tmp12_;
	_tmp13_ = doc;
	feed_reader_grabber_utils_repairURL ("//img", "src", _tmp13_, url);
	_tmp14_ = session;
	_tmp15_ = doc;
	_tmp16_ = a;
	feed_reader_grabber_utils_saveImages (_tmp14_, _tmp15_, _tmp16_, NULL);
	_tmp17_ = g_strdup ("");
	html = _tmp17_;
	_tmp18_ = doc;
	xmlDocDumpMemoryEnc (_tmp18_, (xmlChar**) (&_tmp19_), NULL, "UTF-8");
	_g_free0 (html);
	html = _tmp19_;
	_tmp20_ = html;
	_tmp21_ = string_replace (_tmp20_, "<h3/>", "<h3></h3>");
	_g_free0 (html);
	html = _tmp21_;
	_tmp22_ = html;
	pos1 = string_index_of (_tmp22_, "<iframe", 0);
	pos2 = -1;
	while (TRUE) {
		const gchar* _tmp23_;
		gchar* broken_iframe = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* fixed_iframe = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gint pos3 = 0;
		const gchar* _tmp38_;
		if (!(pos1 != -1)) {
			break;
		}
		_tmp23_ = html;
		pos2 = string_index_of (_tmp23_, "/>", pos1);
		_tmp24_ = html;
		_tmp25_ = string_substring (_tmp24_, (glong) pos1, (glong) ((pos2 + 2) - pos1));
		broken_iframe = _tmp25_;
		_tmp26_ = broken_iframe;
		_tmp27_ = broken_iframe;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = string_substring (_tmp26_, (glong) 0, (glong) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "></iframe>", NULL);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		fixed_iframe = _tmp33_;
		_tmp34_ = html;
		_tmp35_ = broken_iframe;
		_tmp36_ = fixed_iframe;
		_tmp37_ = string_replace (_tmp34_, _tmp35_, _tmp36_);
		_g_free0 (html);
		html = _tmp37_;
		_tmp38_ = html;
		pos3 = string_index_of (_tmp38_, "<iframe", pos1 + 7);
		if (pos3 == pos1) {
			_g_free0 (fixed_iframe);
			_g_free0 (broken_iframe);
			break;
		} else {
			pos1 = pos3;
		}
		_g_free0 (fixed_iframe);
		_g_free0 (broken_iframe);
	}
	{
		GFile* file = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		GFile* _tmp42_;
		GFile* _tmp43_;
		GFileOutputStream* stream = NULL;
		GFile* _tmp44_;
		GFileOutputStream* _tmp45_;
		GFileOutputStream* _tmp46_;
		const gchar* _tmp47_;
		guint8* _tmp48_;
		gint _tmp48__length1;
		gint _tmp49_ = 0;
		guint8* _tmp50_;
		gint _tmp50__length1;
		_tmp39_ = g_get_user_data_dir ();
		_tmp40_ = g_strconcat (_tmp39_, "/debug-article/ArticleLocalImages.html", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_file_new_for_path (_tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		file = _tmp43_;
		_tmp44_ = file;
		_tmp45_ = g_file_create (_tmp44_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		stream = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp46_ = stream;
		_tmp47_ = html;
		_tmp48_ = string_get_data (_tmp47_, &_tmp49_);
		_tmp48__length1 = _tmp49_;
		_tmp50_ = _tmp48_;
		_tmp50__length1 = _tmp48__length1;
		g_output_stream_write ((GOutputStream*) _tmp46_, _tmp50_, (gsize) _tmp50__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (stream);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		_tmp53_ = g_strdup_printf ("FeedServer.grabImages: %s", _tmp52_);
		_tmp54_ = _tmp53_;
		feed_reader_logger_error (_tmp54_);
		_g_free0 (_tmp54_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (html);
		_g_object_unref0 (a);
		_htmlFreeParserCtxt0 (html_cntx);
		_g_object_unref0 (session);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp55_ = doc;
	_xmlFreeDoc0 (_tmp55_);
	_g_free0 (html);
	_g_object_unref0 (a);
	_htmlFreeParserCtxt0 (html_cntx);
	_g_object_unref0 (session);
}

gboolean
feed_reader_feed_server_supportTags (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_supportTags (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_doInitSync (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_doInitSync (_tmp0_);
	return result;
}

gchar*
feed_reader_feed_server_symbolicIcon (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	feed_reader_logger_debug ("feedserver: symbolicIcon");
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("none");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp2_ = feed_reader_feed_server_interface_symbolicIcon (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
feed_reader_feed_server_accountName (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("none");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp2_ = feed_reader_feed_server_interface_accountName (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
feed_reader_feed_server_getServerURL (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("none");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp2_ = feed_reader_feed_server_interface_getServerURL (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
feed_reader_feed_server_uncategorizedID (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp2_ = feed_reader_feed_server_interface_uncategorizedID (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
feed_reader_feed_server_hideCategoryWhenEmpty (FeedReaderFeedServer* self,
                                               const gchar* catID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (catID != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_hideCategoryWhenEmpty (_tmp0_, catID);
	return result;
}

gboolean
feed_reader_feed_server_supportCategories (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_supportCategories (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_supportFeedManipulation (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_supportFeedManipulation (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_supportMultiLevelCategories (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_supportMultiLevelCategories (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_supportMultiCategoriesPerFeed (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_supportMultiCategoriesPerFeed (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_syncFeedsAndCategories (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_syncFeedsAndCategories (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_tagIDaffectedByNameChange (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_tagIDaffectedByNameChange (_tmp0_);
	return result;
}

void
feed_reader_feed_server_resetAccount (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_resetAccount (_tmp0_);
}

gboolean
feed_reader_feed_server_useMaxArticles (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_useMaxArticles (_tmp0_);
	return result;
}

FeedReaderLoginResponse
feed_reader_feed_server_login (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_login (_tmp0_);
	return result;
}

gboolean
feed_reader_feed_server_logout (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_logout (_tmp0_);
	return result;
}

void
feed_reader_feed_server_setArticleIsRead (FeedReaderFeedServer* self,
                                          const gchar* articleIDs,
                                          FeedReaderArticleStatus read)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleIDs != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_setArticleIsRead (_tmp0_, articleIDs, read);
}

void
feed_reader_feed_server_setArticleIsMarked (FeedReaderFeedServer* self,
                                            const gchar* articleID,
                                            FeedReaderArticleStatus marked)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_setArticleIsMarked (_tmp0_, articleID, marked);
}

gboolean
feed_reader_feed_server_alwaysSetReadByID (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_alwaysSetReadByID (_tmp0_);
	return result;
}

void
feed_reader_feed_server_setFeedRead (FeedReaderFeedServer* self,
                                     const gchar* feedID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_setFeedRead (_tmp0_, feedID);
}

void
feed_reader_feed_server_setCategoryRead (FeedReaderFeedServer* self,
                                         const gchar* catID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_setCategoryRead (_tmp0_, catID);
}

void
feed_reader_feed_server_markAllItemsRead (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_markAllItemsRead (_tmp0_);
}

void
feed_reader_feed_server_tagArticle (FeedReaderFeedServer* self,
                                    FeedReaderArticle* article,
                                    FeedReaderTag* tag)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (article != NULL);
	g_return_if_fail (tag != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	_tmp1_ = feed_reader_article_getArticleID (article);
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_tag_getTagID (tag);
	_tmp4_ = _tmp3_;
	feed_reader_feed_server_interface_tagArticle (_tmp0_, _tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

void
feed_reader_feed_server_removeArticleTag (FeedReaderFeedServer* self,
                                          FeedReaderArticle* article,
                                          FeedReaderTag* tag)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (article != NULL);
	g_return_if_fail (tag != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	_tmp1_ = feed_reader_article_getArticleID (article);
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_tag_getTagID (tag);
	_tmp4_ = _tmp3_;
	feed_reader_feed_server_interface_removeArticleTag (_tmp0_, _tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

gchar*
feed_reader_feed_server_createTag (FeedReaderFeedServer* self,
                                   const gchar* caption)
{
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (caption != NULL, NULL);
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp2_ = feed_reader_feed_server_interface_createTag (_tmp1_, caption);
	result = _tmp2_;
	return result;
}

void
feed_reader_feed_server_deleteTag (FeedReaderFeedServer* self,
                                   const gchar* tagID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_deleteTag (_tmp0_, tagID);
}

void
feed_reader_feed_server_renameTag (FeedReaderFeedServer* self,
                                   const gchar* tagID,
                                   const gchar* title)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_renameTag (_tmp0_, tagID, title);
}

gboolean
feed_reader_feed_server_serverAvailable (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_serverAvailable (_tmp0_);
	return result;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

gboolean
feed_reader_feed_server_addFeed (FeedReaderFeedServer* self,
                                 const gchar* feedURL,
                                 const gchar* catID,
                                 const gchar* newCatName,
                                 gchar** feedID,
                                 gchar** errmsg)
{
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gint maxArticles = 0;
	GDateTime* since = NULL;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_ = NULL;
	GDateTime* _tmp10_;
	gchar* sinceStr = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GDateTime* _tmp24_;
	const gchar* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feedURL != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_g_free0 (_vala_feedID);
		_vala_feedID = NULL;
		_tmp0_ = g_strdup ("Plugin not loaded");
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp0_;
		result = FALSE;
		if (feedID) {
			*feedID = _vala_feedID;
		} else {
			_g_free0 (_vala_feedID);
		}
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp4_ = feed_reader_feed_server_interface_addFeed (_tmp1_, feedURL, catID, newCatName, &_tmp2_, &_tmp3_);
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp2_;
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp3_;
	if (!_tmp4_) {
		result = FALSE;
		if (feedID) {
			*feedID = _vala_feedID;
		} else {
			_g_free0 (_vala_feedID);
		}
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	maxArticles = feed_reader_feed_server_ArticleSyncCount (self);
	_tmp5_ = feed_reader_settings_general ();
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_drop_articles_to_start_date ((FeedReaderDropArticles) g_settings_get_enum (_tmp6_, "drop-articles-after"));
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	since = _tmp8_;
	_tmp10_ = since;
	if (_tmp10_ == NULL) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("(null)");
		_g_free0 (_tmp9_);
		_tmp9_ = _tmp11_;
	} else {
		GDateTime* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = since;
		_tmp13_ = g_date_time_to_string (_tmp12_);
		_g_free0 (_tmp9_);
		_tmp9_ = _tmp13_;
	}
	_tmp14_ = g_strdup (_tmp9_);
	sinceStr = _tmp14_;
	_tmp15_ = g_strdup_printf ("%i", maxArticles);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_feedID;
	_tmp18_ = string_to_string (_tmp17_);
	_tmp19_ = string_to_string (feedURL);
	_tmp20_ = sinceStr;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("Downloading up to ", _tmp16_, " articles for feed ", _tmp18_, " (", _tmp19_, "), since ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	feed_reader_logger_info (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp16_);
	_tmp24_ = since;
	_tmp25_ = _vala_feedID;
	feed_reader_feed_server_getArticles (self, maxArticles, FEED_READER_ARTICLE_STATUS_ALL, _tmp24_, _tmp25_, FALSE, NULL);
	result = TRUE;
	_g_free0 (sinceStr);
	_g_free0 (_tmp9_);
	_g_date_time_unref0 (since);
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
feed_reader_feed_server_addFeeds (FeedReaderFeedServer* self,
                                  GeeList* feeds)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feeds != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_addFeeds (_tmp0_, feeds);
}

void
feed_reader_feed_server_removeFeed (FeedReaderFeedServer* self,
                                    const gchar* feedID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_removeFeed (_tmp0_, feedID);
}

void
feed_reader_feed_server_renameFeed (FeedReaderFeedServer* self,
                                    const gchar* feedID,
                                    const gchar* title)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_renameFeed (_tmp0_, feedID, title);
}

void
feed_reader_feed_server_moveFeed (FeedReaderFeedServer* self,
                                  const gchar* feedID,
                                  const gchar* newCatID,
                                  const gchar* currentCatID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_moveFeed (_tmp0_, feedID, newCatID, currentCatID);
}

gchar*
feed_reader_feed_server_createCategory (FeedReaderFeedServer* self,
                                        const gchar* title,
                                        const gchar* parentID)
{
	FeedReaderFeedServerInterface* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	if (!self->priv->m_pluginLoaded) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->m_plugin;
	_tmp2_ = feed_reader_feed_server_interface_createCategory (_tmp1_, title, parentID);
	result = _tmp2_;
	return result;
}

void
feed_reader_feed_server_renameCategory (FeedReaderFeedServer* self,
                                        const gchar* catID,
                                        const gchar* title)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_renameCategory (_tmp0_, catID, title);
}

void
feed_reader_feed_server_moveCategory (FeedReaderFeedServer* self,
                                      const gchar* catID,
                                      const gchar* newParentID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_moveCategory (_tmp0_, catID, newParentID);
}

void
feed_reader_feed_server_deleteCategory (FeedReaderFeedServer* self,
                                        const gchar* catID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_deleteCategory (_tmp0_, catID);
}

void
feed_reader_feed_server_removeCatFromFeed (FeedReaderFeedServer* self,
                                           const gchar* feedID,
                                           const gchar* catID)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_removeCatFromFeed (_tmp0_, feedID, catID);
}

void
feed_reader_feed_server_importOPML (FeedReaderFeedServer* self,
                                    const gchar* opml)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (opml != NULL);
	if (!self->priv->m_pluginLoaded) {
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_importOPML (_tmp0_, opml);
}

gboolean
feed_reader_feed_server_getFeedsAndCats (FeedReaderFeedServer* self,
                                         GeeList* feeds,
                                         GeeList* categories,
                                         GeeList* tags,
                                         GCancellable* cancellable)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	if (!self->priv->m_pluginLoaded) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_getFeedsAndCats (_tmp0_, feeds, categories, tags, NULL);
	return result;
}

gint
feed_reader_feed_server_getUnreadCount (FeedReaderFeedServer* self)
{
	FeedReaderFeedServerInterface* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (!self->priv->m_pluginLoaded) {
		result = 0;
		return result;
	}
	_tmp0_ = self->priv->m_plugin;
	result = feed_reader_feed_server_interface_getUnreadCount (_tmp0_);
	return result;
}

void
feed_reader_feed_server_getArticles (FeedReaderFeedServer* self,
                                     gint count,
                                     FeedReaderArticleStatus whatToGet,
                                     GDateTime* since,
                                     const gchar* feedID,
                                     gboolean isTagID,
                                     GCancellable* cancellable)
{
	FeedReaderFeedServerInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->m_pluginLoaded) {
		feed_reader_logger_error ("getArticles() called with no plugin loaded");
		return;
	}
	_tmp0_ = self->priv->m_plugin;
	feed_reader_feed_server_interface_getArticles (_tmp0_, count, whatToGet, since, feedID, isTagID, NULL);
}

static void
feed_reader_feed_server_syncProgress (FeedReaderFeedServer* self,
                                      const gchar* text)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "update-sync-progress", text);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = feed_reader_settings_state ();
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp3_, "sync-status", text);
	_g_object_unref0 (_tmp3_);
}

static void
feed_reader_feed_server_class_init (FeedReaderFeedServerClass * klass,
                                    gpointer klass_data)
{
	feed_reader_feed_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedServer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feed_server_finalize;
	feed_reader_feed_server_signals[FEED_READER_FEED_SERVER_PLUGINS_CHANED_EVENT_SIGNAL] = g_signal_new ("plugins-chaned-event", FEED_READER_TYPE_FEED_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
feed_reader_feed_server_instance_init (FeedReaderFeedServer * self,
                                       gpointer klass)
{
	self->priv = feed_reader_feed_server_get_instance_private (self);
	self->priv->m_pluginLoaded = FALSE;
	self->priv->m_activeExtension = NULL;
}

static void
feed_reader_feed_server_finalize (GObject * obj)
{
	FeedReaderFeedServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEED_SERVER, FeedReaderFeedServer);
	_g_object_unref0 (self->priv->m_extensions);
	_g_free0 (self->priv->m_activeExtension);
	_g_object_unref0 (self->priv->m_plugin);
	_g_object_unref0 (self->priv->m_engine);
	G_OBJECT_CLASS (feed_reader_feed_server_parent_class)->finalize (obj);
}

static GType
feed_reader_feed_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feed_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedServer), 0, (GInstanceInitFunc) feed_reader_feed_server_instance_init, NULL };
	GType feed_reader_feed_server_type_id;
	feed_reader_feed_server_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderFeedServer", &g_define_type_info, 0);
	FeedReaderFeedServer_private_offset = g_type_add_instance_private (feed_reader_feed_server_type_id, sizeof (FeedReaderFeedServerPrivate));
	return feed_reader_feed_server_type_id;
}

GType
feed_reader_feed_server_get_type (void)
{
	static volatile gsize feed_reader_feed_server_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_feed_server_type_id__once)) {
		GType feed_reader_feed_server_type_id;
		feed_reader_feed_server_type_id = feed_reader_feed_server_get_type_once ();
		g_once_init_leave (&feed_reader_feed_server_type_id__once, feed_reader_feed_server_type_id);
	}
	return feed_reader_feed_server_type_id__once;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

