/* FeedServerInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from FeedServerInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General public License for more details.*/
/**/
/*You should have received a copy of the GNU General public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>

enum  {
	FEED_READER_FEED_SERVER_INTERFACE_0_PROPERTY,
	FEED_READER_FEED_SERVER_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feed_server_interface_properties[FEED_READER_FEED_SERVER_INTERFACE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _feed_reader_feed_server_interface_postLoginActionData feed_reader_feed_server_interface_postLoginActionData;
enum  {
	FEED_READER_FEED_SERVER_INTERFACE_NEW_FEED_LIST_SIGNAL,
	FEED_READER_FEED_SERVER_INTERFACE_REFRESH_FEED_LIST_COUNTER_SIGNAL,
	FEED_READER_FEED_SERVER_INTERFACE_UPDATE_ARTICLE_LIST_SIGNAL,
	FEED_READER_FEED_SERVER_INTERFACE_SHOW_ARTICLE_LIST_OVERLAY_SIGNAL,
	FEED_READER_FEED_SERVER_INTERFACE_WRITE_ARTICLES_SIGNAL,
	FEED_READER_FEED_SERVER_INTERFACE_TRY_LOGIN_SIGNAL,
	FEED_READER_FEED_SERVER_INTERFACE_NUM_SIGNALS
};
static guint feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_NUM_SIGNALS] = {0};

struct _feed_reader_feed_server_interface_postLoginActionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FeedReaderFeedServerInterface* self;
};

static gpointer feed_reader_feed_server_interface_parent_class = NULL;

static void feed_reader_feed_server_interface_real_init (FeedReaderFeedServerInterface* self,
                                                  GSettingsBackend* settings_backend,
                                                  SecretCollection* secrets);
static gboolean feed_reader_feed_server_interface_real_supportTags (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_doInitSync (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_symbolicIcon (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_accountName (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_getServerURL (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_uncategorizedID (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* self,
                                                                       const gchar* catID);
static gboolean feed_reader_feed_server_interface_real_supportCategories (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_resetAccount (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_useMaxArticles (FeedReaderFeedServerInterface* self);
static FeedReaderLoginResponse feed_reader_feed_server_interface_real_login (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_logout (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* self,
                                                              const gchar* articleIDs,
                                                              FeedReaderArticleStatus read);
static void feed_reader_feed_server_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* self,
                                                                const gchar* articleID,
                                                                FeedReaderArticleStatus marked);
static void feed_reader_feed_server_interface_real_setFeedRead (FeedReaderFeedServerInterface* self,
                                                         const gchar* feedID);
static void feed_reader_feed_server_interface_real_setCategoryRead (FeedReaderFeedServerInterface* self,
                                                             const gchar* catID);
static void feed_reader_feed_server_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_tagArticle (FeedReaderFeedServerInterface* self,
                                                        const gchar* articleID,
                                                        const gchar* tagID);
static void feed_reader_feed_server_interface_real_removeArticleTag (FeedReaderFeedServerInterface* self,
                                                              const gchar* articleID,
                                                              const gchar* tagID);
static gchar* feed_reader_feed_server_interface_real_createTag (FeedReaderFeedServerInterface* self,
                                                         const gchar* caption);
static void feed_reader_feed_server_interface_real_deleteTag (FeedReaderFeedServerInterface* self,
                                                       const gchar* tagID);
static void feed_reader_feed_server_interface_real_renameTag (FeedReaderFeedServerInterface* self,
                                                       const gchar* tagID,
                                                       const gchar* title);
static gboolean feed_reader_feed_server_interface_real_serverAvailable (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_addFeed (FeedReaderFeedServerInterface* self,
                                                         const gchar* feedURL,
                                                         const gchar* catID,
                                                         const gchar* newCatName,
                                                         gchar** feedID,
                                                         gchar** errmsg);
static void feed_reader_feed_server_interface_real_addFeeds (FeedReaderFeedServerInterface* self,
                                                      GeeList* feeds);
static void feed_reader_feed_server_interface_real_removeFeed (FeedReaderFeedServerInterface* self,
                                                        const gchar* feedID);
static void feed_reader_feed_server_interface_real_renameFeed (FeedReaderFeedServerInterface* self,
                                                        const gchar* feedID,
                                                        const gchar* title);
static void feed_reader_feed_server_interface_real_moveFeed (FeedReaderFeedServerInterface* self,
                                                      const gchar* feedID,
                                                      const gchar* newCatID,
                                                      const gchar* currentCatID);
static gchar* feed_reader_feed_server_interface_real_createCategory (FeedReaderFeedServerInterface* self,
                                                              const gchar* title,
                                                              const gchar* parentID);
static void feed_reader_feed_server_interface_real_renameCategory (FeedReaderFeedServerInterface* self,
                                                            const gchar* catID,
                                                            const gchar* title);
static void feed_reader_feed_server_interface_real_moveCategory (FeedReaderFeedServerInterface* self,
                                                          const gchar* catID,
                                                          const gchar* newParentID);
static void feed_reader_feed_server_interface_real_deleteCategory (FeedReaderFeedServerInterface* self,
                                                            const gchar* catID);
static void feed_reader_feed_server_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* self,
                                                               const gchar* feedID,
                                                               const gchar* catID);
static void feed_reader_feed_server_interface_real_importOPML (FeedReaderFeedServerInterface* self,
                                                        const gchar* opml);
static gboolean feed_reader_feed_server_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* self,
                                                                 GeeList* feeds,
                                                                 GeeList* categories,
                                                                 GeeList* tags,
                                                                 GCancellable* cancellable);
static gint feed_reader_feed_server_interface_real_getUnreadCount (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_getArticles (FeedReaderFeedServerInterface* self,
                                                         gint count,
                                                         FeedReaderArticleStatus whatToGet,
                                                         GDateTime* since,
                                                         const gchar* feedID,
                                                         gboolean isTagID,
                                                         GCancellable* cancellable);
static gchar* feed_reader_feed_server_interface_real_getWebsite (FeedReaderFeedServerInterface* self);
static FeedReaderBackendFlags feed_reader_feed_server_interface_real_getFlags (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_getID (FeedReaderFeedServerInterface* self);
static GtkBox* feed_reader_feed_server_interface_real_getWidget (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_iconName (FeedReaderFeedServerInterface* self);
static gchar* feed_reader_feed_server_interface_real_serviceName (FeedReaderFeedServerInterface* self);
static gboolean feed_reader_feed_server_interface_real_needWebLogin (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_showHtAccess (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_writeData (FeedReaderFeedServerInterface* self);
static void feed_reader_feed_server_interface_real_postLoginAction_data_free (gpointer _data);
static void feed_reader_feed_server_interface_real_postLoginAction (FeedReaderFeedServerInterface* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean feed_reader_feed_server_interface_real_postLoginAction_co (feed_reader_feed_server_interface_postLoginActionData* _data_);
static gboolean feed_reader_feed_server_interface_real_extractCode (FeedReaderFeedServerInterface* self,
                                                             const gchar* redirectURL);
static gchar* feed_reader_feed_server_interface_real_buildLoginURL (FeedReaderFeedServerInterface* self);
static GType feed_reader_feed_server_interface_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
feed_reader_feed_server_interface_real_init (FeedReaderFeedServerInterface* self,
                                             GSettingsBackend* settings_backend,
                                             SecretCollection* secrets)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_init'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_init (FeedReaderFeedServerInterface* self,
                                        GSettingsBackend* settings_backend,
                                        SecretCollection* secrets)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->init) {
		_klass_->init (self, settings_backend, secrets);
	}
}

static gboolean
feed_reader_feed_server_interface_real_supportTags (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_supportTags'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_supportTags (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->supportTags) {
		return _klass_->supportTags (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_doInitSync (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_doInitSync'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_doInitSync (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->doInitSync) {
		return _klass_->doInitSync (self);
	}
	return FALSE;
}

static gchar*
feed_reader_feed_server_interface_real_symbolicIcon (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_symbolicIcon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_symbolicIcon (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->symbolicIcon) {
		return _klass_->symbolicIcon (self);
	}
	return NULL;
}

static gchar*
feed_reader_feed_server_interface_real_accountName (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_accountName'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_accountName (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->accountName) {
		return _klass_->accountName (self);
	}
	return NULL;
}

static gchar*
feed_reader_feed_server_interface_real_getServerURL (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getServerURL'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_getServerURL (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getServerURL) {
		return _klass_->getServerURL (self);
	}
	return NULL;
}

static gchar*
feed_reader_feed_server_interface_real_uncategorizedID (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_uncategorizedID'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_uncategorizedID (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->uncategorizedID) {
		return _klass_->uncategorizedID (self);
	}
	return NULL;
}

static gboolean
feed_reader_feed_server_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* self,
                                                              const gchar* catID)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_hideCategoryWhenEmpty'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* self,
                                                         const gchar* catID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->hideCategoryWhenEmpty) {
		return _klass_->hideCategoryWhenEmpty (self, catID);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_supportCategories (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_supportCategories'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_supportCategories (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->supportCategories) {
		return _klass_->supportCategories (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_supportFeedManipulation'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_supportFeedManipulation (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->supportFeedManipulation) {
		return _klass_->supportFeedManipulation (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_supportMultiLevelCategories'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_supportMultiLevelCategories (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->supportMultiLevelCategories) {
		return _klass_->supportMultiLevelCategories (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_supportMultiCategoriesPerFeed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->supportMultiCategoriesPerFeed) {
		return _klass_->supportMultiCategoriesPerFeed (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_syncFeedsAndCategories'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_syncFeedsAndCategories (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->syncFeedsAndCategories) {
		return _klass_->syncFeedsAndCategories (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_tagIDaffectedByNameChange'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->tagIDaffectedByNameChange) {
		return _klass_->tagIDaffectedByNameChange (self);
	}
	return FALSE;
}

static void
feed_reader_feed_server_interface_real_resetAccount (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_resetAccount'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_resetAccount (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->resetAccount) {
		_klass_->resetAccount (self);
	}
}

static gboolean
feed_reader_feed_server_interface_real_useMaxArticles (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_useMaxArticles'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_useMaxArticles (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->useMaxArticles) {
		return _klass_->useMaxArticles (self);
	}
	return FALSE;
}

static FeedReaderLoginResponse
feed_reader_feed_server_interface_real_login (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_login'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

FeedReaderLoginResponse
feed_reader_feed_server_interface_login (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->login) {
		return _klass_->login (self);
	}
	return 0;
}

static gboolean
feed_reader_feed_server_interface_real_logout (FeedReaderFeedServerInterface* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
feed_reader_feed_server_interface_logout (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->logout) {
		return _klass_->logout (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_alwaysSetReadByID'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_alwaysSetReadByID (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->alwaysSetReadByID) {
		return _klass_->alwaysSetReadByID (self);
	}
	return FALSE;
}

static void
feed_reader_feed_server_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* self,
                                                         const gchar* articleIDs,
                                                         FeedReaderArticleStatus read)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_setArticleIsRead'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_setArticleIsRead (FeedReaderFeedServerInterface* self,
                                                    const gchar* articleIDs,
                                                    FeedReaderArticleStatus read)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->setArticleIsRead) {
		_klass_->setArticleIsRead (self, articleIDs, read);
	}
}

static void
feed_reader_feed_server_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* self,
                                                           const gchar* articleID,
                                                           FeedReaderArticleStatus marked)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_setArticleIsMarked'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_setArticleIsMarked (FeedReaderFeedServerInterface* self,
                                                      const gchar* articleID,
                                                      FeedReaderArticleStatus marked)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->setArticleIsMarked) {
		_klass_->setArticleIsMarked (self, articleID, marked);
	}
}

static void
feed_reader_feed_server_interface_real_setFeedRead (FeedReaderFeedServerInterface* self,
                                                    const gchar* feedID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_setFeedRead'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_setFeedRead (FeedReaderFeedServerInterface* self,
                                               const gchar* feedID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->setFeedRead) {
		_klass_->setFeedRead (self, feedID);
	}
}

static void
feed_reader_feed_server_interface_real_setCategoryRead (FeedReaderFeedServerInterface* self,
                                                        const gchar* catID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_setCategoryRead'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_setCategoryRead (FeedReaderFeedServerInterface* self,
                                                   const gchar* catID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->setCategoryRead) {
		_klass_->setCategoryRead (self, catID);
	}
}

static void
feed_reader_feed_server_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_markAllItemsRead'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_markAllItemsRead (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->markAllItemsRead) {
		_klass_->markAllItemsRead (self);
	}
}

static void
feed_reader_feed_server_interface_real_tagArticle (FeedReaderFeedServerInterface* self,
                                                   const gchar* articleID,
                                                   const gchar* tagID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_tagArticle'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_tagArticle (FeedReaderFeedServerInterface* self,
                                              const gchar* articleID,
                                              const gchar* tagID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->tagArticle) {
		_klass_->tagArticle (self, articleID, tagID);
	}
}

static void
feed_reader_feed_server_interface_real_removeArticleTag (FeedReaderFeedServerInterface* self,
                                                         const gchar* articleID,
                                                         const gchar* tagID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_removeArticleTag'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_removeArticleTag (FeedReaderFeedServerInterface* self,
                                                    const gchar* articleID,
                                                    const gchar* tagID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->removeArticleTag) {
		_klass_->removeArticleTag (self, articleID, tagID);
	}
}

static gchar*
feed_reader_feed_server_interface_real_createTag (FeedReaderFeedServerInterface* self,
                                                  const gchar* caption)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_createTag'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_createTag (FeedReaderFeedServerInterface* self,
                                             const gchar* caption)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->createTag) {
		return _klass_->createTag (self, caption);
	}
	return NULL;
}

static void
feed_reader_feed_server_interface_real_deleteTag (FeedReaderFeedServerInterface* self,
                                                  const gchar* tagID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_deleteTag'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_deleteTag (FeedReaderFeedServerInterface* self,
                                             const gchar* tagID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->deleteTag) {
		_klass_->deleteTag (self, tagID);
	}
}

static void
feed_reader_feed_server_interface_real_renameTag (FeedReaderFeedServerInterface* self,
                                                  const gchar* tagID,
                                                  const gchar* title)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_renameTag'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_renameTag (FeedReaderFeedServerInterface* self,
                                             const gchar* tagID,
                                             const gchar* title)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->renameTag) {
		_klass_->renameTag (self, tagID, title);
	}
}

static gboolean
feed_reader_feed_server_interface_real_serverAvailable (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_serverAvailable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_serverAvailable (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->serverAvailable) {
		return _klass_->serverAvailable (self);
	}
	return FALSE;
}

static gboolean
feed_reader_feed_server_interface_real_addFeed (FeedReaderFeedServerInterface* self,
                                                const gchar* feedURL,
                                                const gchar* catID,
                                                const gchar* newCatName,
                                                gchar** feedID,
                                                gchar** errmsg)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_addFeed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_addFeed (FeedReaderFeedServerInterface* self,
                                           const gchar* feedURL,
                                           const gchar* catID,
                                           const gchar* newCatName,
                                           gchar** feedID,
                                           gchar** errmsg)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->addFeed) {
		return _klass_->addFeed (self, feedURL, catID, newCatName, feedID, errmsg);
	}
	return FALSE;
}

static void
feed_reader_feed_server_interface_real_addFeeds (FeedReaderFeedServerInterface* self,
                                                 GeeList* feeds)
{
	gchar* feedID = NULL;
	gchar* errmsg = NULL;
	g_return_if_fail (feeds != NULL);
	{
		GeeList* _feed_list = NULL;
		gint _feed_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _feed_index = 0;
		_feed_list = feeds;
		_tmp0_ = _feed_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_feed_size = _tmp2_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			gchar* catString = NULL;
			FeedReaderFeed* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_;
			FeedReaderFeed* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			_feed_index = _feed_index + 1;
			_tmp3_ = _feed_index;
			_tmp4_ = _feed_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _feed_list;
			_tmp6_ = gee_list_get (_tmp5_, _feed_index);
			feed = (FeedReaderFeed*) _tmp6_;
			_tmp7_ = feed;
			_tmp8_ = feed_reader_feed_getCatString (_tmp7_);
			catString = _tmp8_;
			_tmp10_ = catString;
			if (g_strcmp0 (_tmp10_, "") != 0) {
				const gchar* _tmp11_;
				_tmp11_ = catString;
				_tmp9_ = _tmp11_;
			} else {
				_tmp9_ = NULL;
			}
			_tmp12_ = feed;
			_tmp13_ = feed_reader_feed_getXmlUrl (_tmp12_);
			_tmp14_ = _tmp13_;
			feed_reader_feed_server_interface_addFeed (self, _tmp14_, _tmp9_, NULL, &_tmp15_, &_tmp16_);
			_g_free0 (feedID);
			feedID = _tmp15_;
			_g_free0 (errmsg);
			errmsg = _tmp16_;
			_g_free0 (_tmp14_);
			_g_free0 (catString);
			_g_object_unref0 (feed);
		}
	}
	_g_free0 (errmsg);
	_g_free0 (feedID);
}

void
feed_reader_feed_server_interface_addFeeds (FeedReaderFeedServerInterface* self,
                                            GeeList* feeds)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->addFeeds) {
		_klass_->addFeeds (self, feeds);
	}
}

static void
feed_reader_feed_server_interface_real_removeFeed (FeedReaderFeedServerInterface* self,
                                                   const gchar* feedID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_removeFeed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_removeFeed (FeedReaderFeedServerInterface* self,
                                              const gchar* feedID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->removeFeed) {
		_klass_->removeFeed (self, feedID);
	}
}

static void
feed_reader_feed_server_interface_real_renameFeed (FeedReaderFeedServerInterface* self,
                                                   const gchar* feedID,
                                                   const gchar* title)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_renameFeed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_renameFeed (FeedReaderFeedServerInterface* self,
                                              const gchar* feedID,
                                              const gchar* title)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->renameFeed) {
		_klass_->renameFeed (self, feedID, title);
	}
}

static void
feed_reader_feed_server_interface_real_moveFeed (FeedReaderFeedServerInterface* self,
                                                 const gchar* feedID,
                                                 const gchar* newCatID,
                                                 const gchar* currentCatID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_moveFeed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_moveFeed (FeedReaderFeedServerInterface* self,
                                            const gchar* feedID,
                                            const gchar* newCatID,
                                            const gchar* currentCatID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->moveFeed) {
		_klass_->moveFeed (self, feedID, newCatID, currentCatID);
	}
}

static gchar*
feed_reader_feed_server_interface_real_createCategory (FeedReaderFeedServerInterface* self,
                                                       const gchar* title,
                                                       const gchar* parentID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_createCategory'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_createCategory (FeedReaderFeedServerInterface* self,
                                                  const gchar* title,
                                                  const gchar* parentID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->createCategory) {
		return _klass_->createCategory (self, title, parentID);
	}
	return NULL;
}

static void
feed_reader_feed_server_interface_real_renameCategory (FeedReaderFeedServerInterface* self,
                                                       const gchar* catID,
                                                       const gchar* title)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_renameCategory'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_renameCategory (FeedReaderFeedServerInterface* self,
                                                  const gchar* catID,
                                                  const gchar* title)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->renameCategory) {
		_klass_->renameCategory (self, catID, title);
	}
}

static void
feed_reader_feed_server_interface_real_moveCategory (FeedReaderFeedServerInterface* self,
                                                     const gchar* catID,
                                                     const gchar* newParentID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_moveCategory'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_moveCategory (FeedReaderFeedServerInterface* self,
                                                const gchar* catID,
                                                const gchar* newParentID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->moveCategory) {
		_klass_->moveCategory (self, catID, newParentID);
	}
}

static void
feed_reader_feed_server_interface_real_deleteCategory (FeedReaderFeedServerInterface* self,
                                                       const gchar* catID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_deleteCategory'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_deleteCategory (FeedReaderFeedServerInterface* self,
                                                  const gchar* catID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->deleteCategory) {
		_klass_->deleteCategory (self, catID);
	}
}

static void
feed_reader_feed_server_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* self,
                                                          const gchar* feedID,
                                                          const gchar* catID)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_removeCatFromFeed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_removeCatFromFeed (FeedReaderFeedServerInterface* self,
                                                     const gchar* feedID,
                                                     const gchar* catID)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->removeCatFromFeed) {
		_klass_->removeCatFromFeed (self, feedID, catID);
	}
}

static void
feed_reader_feed_server_interface_real_importOPML (FeedReaderFeedServerInterface* self,
                                                   const gchar* opml)
{
	FeedReaderOPMLparser* parser = NULL;
	FeedReaderOPMLparser* _tmp0_;
	GeeList* feeds = NULL;
	GeeList* _tmp1_;
	g_return_if_fail (opml != NULL);
	_tmp0_ = feed_reader_opm_lparser_new (opml);
	parser = _tmp0_;
	_tmp1_ = feed_reader_opm_lparser_parse (parser);
	feeds = _tmp1_;
	feed_reader_feed_server_interface_addFeeds (self, feeds);
	_g_object_unref0 (feeds);
	_g_object_unref0 (parser);
}

void
feed_reader_feed_server_interface_importOPML (FeedReaderFeedServerInterface* self,
                                              const gchar* opml)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->importOPML) {
		_klass_->importOPML (self, opml);
	}
}

static gboolean
feed_reader_feed_server_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* self,
                                                        GeeList* feeds,
                                                        GeeList* categories,
                                                        GeeList* tags,
                                                        GCancellable* cancellable)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getFeedsAndCats'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_getFeedsAndCats (FeedReaderFeedServerInterface* self,
                                                   GeeList* feeds,
                                                   GeeList* categories,
                                                   GeeList* tags,
                                                   GCancellable* cancellable)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getFeedsAndCats) {
		return _klass_->getFeedsAndCats (self, feeds, categories, tags, cancellable);
	}
	return FALSE;
}

static gint
feed_reader_feed_server_interface_real_getUnreadCount (FeedReaderFeedServerInterface* self)
{
	gint _tmp0_ = 0;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getUnreadCount'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gint
feed_reader_feed_server_interface_getUnreadCount (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getUnreadCount) {
		return _klass_->getUnreadCount (self);
	}
	return -1;
}

static void
feed_reader_feed_server_interface_real_getArticles (FeedReaderFeedServerInterface* self,
                                                    gint count,
                                                    FeedReaderArticleStatus whatToGet,
                                                    GDateTime* since,
                                                    const gchar* feedID,
                                                    gboolean isTagID,
                                                    GCancellable* cancellable)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getArticles'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
feed_reader_feed_server_interface_getArticles (FeedReaderFeedServerInterface* self,
                                               gint count,
                                               FeedReaderArticleStatus whatToGet,
                                               GDateTime* since,
                                               const gchar* feedID,
                                               gboolean isTagID,
                                               GCancellable* cancellable)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getArticles) {
		_klass_->getArticles (self, count, whatToGet, since, feedID, isTagID, cancellable);
	}
}

static gchar*
feed_reader_feed_server_interface_real_getWebsite (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getWebsite'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_getWebsite (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getWebsite) {
		return _klass_->getWebsite (self);
	}
	return NULL;
}

static FeedReaderBackendFlags
feed_reader_feed_server_interface_real_getFlags (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getFlags'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}

FeedReaderBackendFlags
feed_reader_feed_server_interface_getFlags (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getFlags) {
		return _klass_->getFlags (self);
	}
	return 0U;
}

static gchar*
feed_reader_feed_server_interface_real_getID (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_getID'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_getID (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getID) {
		return _klass_->getID (self);
	}
	return NULL;
}

static GtkBox*
feed_reader_feed_server_interface_real_getWidget (FeedReaderFeedServerInterface* self)
{
	GtkBox* result;
	result = NULL;
	return result;
}

GtkBox*
feed_reader_feed_server_interface_getWidget (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->getWidget) {
		return _klass_->getWidget (self);
	}
	return NULL;
}

static gchar*
feed_reader_feed_server_interface_real_iconName (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_iconName'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_iconName (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->iconName) {
		return _klass_->iconName (self);
	}
	return NULL;
}

static gchar*
feed_reader_feed_server_interface_real_serviceName (FeedReaderFeedServerInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_serviceName'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
feed_reader_feed_server_interface_serviceName (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->serviceName) {
		return _klass_->serviceName (self);
	}
	return NULL;
}

static gboolean
feed_reader_feed_server_interface_real_needWebLogin (FeedReaderFeedServerInterface* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `feed_reader_feed_server_interface_needWebLogin'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
feed_reader_feed_server_interface_needWebLogin (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->needWebLogin) {
		return _klass_->needWebLogin (self);
	}
	return FALSE;
}

static void
feed_reader_feed_server_interface_real_showHtAccess (FeedReaderFeedServerInterface* self)
{
}

void
feed_reader_feed_server_interface_showHtAccess (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->showHtAccess) {
		_klass_->showHtAccess (self);
	}
}

static void
feed_reader_feed_server_interface_real_writeData (FeedReaderFeedServerInterface* self)
{
}

void
feed_reader_feed_server_interface_writeData (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->writeData) {
		_klass_->writeData (self);
	}
}

static void
feed_reader_feed_server_interface_real_postLoginAction_data_free (gpointer _data)
{
	feed_reader_feed_server_interface_postLoginActionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (feed_reader_feed_server_interface_postLoginActionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
feed_reader_feed_server_interface_real_postLoginAction (FeedReaderFeedServerInterface* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	feed_reader_feed_server_interface_postLoginActionData* _data_;
	FeedReaderFeedServerInterface* _tmp0_;
	_data_ = g_slice_new0 (feed_reader_feed_server_interface_postLoginActionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_feed_server_interface_real_postLoginAction_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	feed_reader_feed_server_interface_real_postLoginAction_co (_data_);
}

static void
feed_reader_feed_server_interface_real_postLoginAction_finish (FeedReaderFeedServerInterface* self,
                                                               GAsyncResult* _res_)
{
	feed_reader_feed_server_interface_postLoginActionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
feed_reader_feed_server_interface_real_postLoginAction_co (feed_reader_feed_server_interface_postLoginActionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
feed_reader_feed_server_interface_postLoginAction (FeedReaderFeedServerInterface* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->postLoginAction) {
		_klass_->postLoginAction (self, _callback_, _user_data_);
	}
}

void
feed_reader_feed_server_interface_postLoginAction_finish (FeedReaderFeedServerInterface* self,
                                                          GAsyncResult* _res_)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->postLoginAction_finish) {
		_klass_->postLoginAction_finish (self, _res_);
	}
}

static gboolean
feed_reader_feed_server_interface_real_extractCode (FeedReaderFeedServerInterface* self,
                                                    const gchar* redirectURL)
{
	gboolean result;
	g_return_val_if_fail (redirectURL != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
feed_reader_feed_server_interface_extractCode (FeedReaderFeedServerInterface* self,
                                               const gchar* redirectURL)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->extractCode) {
		return _klass_->extractCode (self, redirectURL);
	}
	return FALSE;
}

static gchar*
feed_reader_feed_server_interface_real_buildLoginURL (FeedReaderFeedServerInterface* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

gchar*
feed_reader_feed_server_interface_buildLoginURL (FeedReaderFeedServerInterface* self)
{
	FeedReaderFeedServerInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FEED_READER_FEED_SERVER_INTERFACE_GET_CLASS (self);
	if (_klass_->buildLoginURL) {
		return _klass_->buildLoginURL (self);
	}
	return NULL;
}

FeedReaderFeedServerInterface*
feed_reader_feed_server_interface_construct (GType object_type)
{
	FeedReaderFeedServerInterface * self = NULL;
	self = (FeedReaderFeedServerInterface*) g_object_new (object_type, NULL);
	return self;
}

static void
feed_reader_feed_server_interface_class_init (FeedReaderFeedServerInterfaceClass * klass,
                                              gpointer klass_data)
{
	feed_reader_feed_server_interface_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_feed_server_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->logout = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_logout;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feed_server_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feed_server_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_feed_server_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeeds = (void (*) (FeedReaderFeedServerInterface*, GeeList*)) feed_reader_feed_server_interface_real_addFeeds;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_server_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->importOPML = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_importOPML;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_feed_server_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_feed_server_interface_real_getArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->showHtAccess = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_showHtAccess;
	((FeedReaderFeedServerInterfaceClass *) klass)->writeData = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_writeData;
	((FeedReaderFeedServerInterfaceClass *) klass)->postLoginAction = (void (*) (FeedReaderFeedServerInterface*, GAsyncReadyCallback, gpointer)) feed_reader_feed_server_interface_real_postLoginAction;
	((FeedReaderFeedServerInterfaceClass *) klass)->postLoginAction_finish = (void (*) (FeedReaderFeedServerInterface*, GAsyncResult*)) feed_reader_feed_server_interface_real_postLoginAction_finish;
	((FeedReaderFeedServerInterfaceClass *) klass)->extractCode = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_server_interface_real_extractCode;
	((FeedReaderFeedServerInterfaceClass *) klass)->buildLoginURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_server_interface_real_buildLoginURL;
	feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_NEW_FEED_LIST_SIGNAL] = g_signal_new ("new-feed-list", FEED_READER_TYPE_FEED_SERVER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_REFRESH_FEED_LIST_COUNTER_SIGNAL] = g_signal_new ("refresh-feed-list-counter", FEED_READER_TYPE_FEED_SERVER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_UPDATE_ARTICLE_LIST_SIGNAL] = g_signal_new ("update-article-list", FEED_READER_TYPE_FEED_SERVER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_SHOW_ARTICLE_LIST_OVERLAY_SIGNAL] = g_signal_new ("show-article-list-overlay", FEED_READER_TYPE_FEED_SERVER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_WRITE_ARTICLES_SIGNAL] = g_signal_new ("write-articles", FEED_READER_TYPE_FEED_SERVER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_LIST);
	feed_reader_feed_server_interface_signals[FEED_READER_FEED_SERVER_INTERFACE_TRY_LOGIN_SIGNAL] = g_signal_new ("try-login", FEED_READER_TYPE_FEED_SERVER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
feed_reader_feed_server_interface_instance_init (FeedReaderFeedServerInterface * self,
                                                 gpointer klass)
{
}

static GType
feed_reader_feed_server_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedServerInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feed_server_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedServerInterface), 0, (GInstanceInitFunc) feed_reader_feed_server_interface_instance_init, NULL };
	GType feed_reader_feed_server_interface_type_id;
	feed_reader_feed_server_interface_type_id = g_type_register_static (peas_extension_base_get_type (), "FeedReaderFeedServerInterface", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return feed_reader_feed_server_interface_type_id;
}

GType
feed_reader_feed_server_interface_get_type (void)
{
	static volatile gsize feed_reader_feed_server_interface_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_feed_server_interface_type_id__once)) {
		GType feed_reader_feed_server_interface_type_id;
		feed_reader_feed_server_interface_type_id = feed_reader_feed_server_interface_get_type_once ();
		g_once_init_leave (&feed_reader_feed_server_interface_type_id__once, feed_reader_feed_server_interface_type_id);
	}
	return feed_reader_feed_server_interface_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

