/* CachedActionManager.c generated by valac 0.56.3, the Vala compiler
 * generated from CachedActionManager.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

enum  {
	FEED_READER_CACHED_ACTION_MANAGER_0_PROPERTY,
	FEED_READER_CACHED_ACTION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* feed_reader_cached_action_manager_properties[FEED_READER_CACHED_ACTION_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FeedReaderCachedActionManagerPrivate {
	FeedReaderCachedActions m_lastAction;
	gchar* m_ids;
};

static gint FeedReaderCachedActionManager_private_offset;
static gpointer feed_reader_cached_action_manager_parent_class = NULL;
static FeedReaderCachedActionManager* feed_reader_cached_action_manager_m_manager;
static FeedReaderCachedActionManager* feed_reader_cached_action_manager_m_manager = NULL;

static FeedReaderCachedActionManager* feed_reader_cached_action_manager_new (void);
static FeedReaderCachedActionManager* feed_reader_cached_action_manager_construct (GType object_type);
static void feed_reader_cached_action_manager_addAction (FeedReaderCachedActionManager* self,
                                                  FeedReaderCachedAction* action);
static void feed_reader_cached_action_manager_execute (FeedReaderCachedActionManager* self,
                                                const gchar* ids,
                                                FeedReaderCachedActions action);
static void feed_reader_cached_action_manager_finalize (GObject * obj);
static GType feed_reader_cached_action_manager_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_cached_action_manager_get_instance_private (FeedReaderCachedActionManager* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderCachedActionManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderCachedActionManager*
feed_reader_cached_action_manager_get_default (void)
{
	FeedReaderCachedActionManager* _tmp0_;
	FeedReaderCachedActionManager* _tmp2_;
	FeedReaderCachedActionManager* _tmp3_;
	FeedReaderCachedActionManager* result;
	_tmp0_ = feed_reader_cached_action_manager_m_manager;
	if (_tmp0_ == NULL) {
		FeedReaderCachedActionManager* _tmp1_;
		_tmp1_ = feed_reader_cached_action_manager_new ();
		_g_object_unref0 (feed_reader_cached_action_manager_m_manager);
		feed_reader_cached_action_manager_m_manager = _tmp1_;
	}
	_tmp2_ = feed_reader_cached_action_manager_m_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static FeedReaderCachedActionManager*
feed_reader_cached_action_manager_construct (GType object_type)
{
	FeedReaderCachedActionManager * self = NULL;
	self = (FeedReaderCachedActionManager*) g_object_new (object_type, NULL);
	return self;
}

static FeedReaderCachedActionManager*
feed_reader_cached_action_manager_new (void)
{
	return feed_reader_cached_action_manager_construct (FEED_READER_TYPE_CACHED_ACTION_MANAGER);
}

void
feed_reader_cached_action_manager_markArticleRead (FeedReaderCachedActionManager* self,
                                                   const gchar* id,
                                                   FeedReaderArticleStatus read)
{
	FeedReaderCachedActions cachedAction = 0;
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	cachedAction = FEED_READER_CACHED_ACTIONS_MARK_READ;
	if (read == FEED_READER_ARTICLE_STATUS_UNREAD) {
		cachedAction = FEED_READER_CACHED_ACTIONS_MARK_UNREAD;
	}
	_tmp0_ = feed_reader_cached_action_new (cachedAction, id, "");
	action = _tmp0_;
	feed_reader_cached_action_manager_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_cached_action_manager_markArticleStarred (FeedReaderCachedActionManager* self,
                                                      const gchar* id,
                                                      FeedReaderArticleStatus marked)
{
	FeedReaderCachedActions cachedAction = 0;
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	cachedAction = FEED_READER_CACHED_ACTIONS_MARK_STARRED;
	if (marked == FEED_READER_ARTICLE_STATUS_UNMARKED) {
		cachedAction = FEED_READER_CACHED_ACTIONS_MARK_UNSTARRED;
	}
	_tmp0_ = feed_reader_cached_action_new (cachedAction, id, "");
	action = _tmp0_;
	feed_reader_cached_action_manager_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_cached_action_manager_markFeedRead (FeedReaderCachedActionManager* self,
                                                const gchar* id)
{
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = feed_reader_cached_action_new (FEED_READER_CACHED_ACTIONS_MARK_READ_FEED, id, "");
	action = _tmp0_;
	feed_reader_cached_action_manager_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_cached_action_manager_markCategoryRead (FeedReaderCachedActionManager* self,
                                                    const gchar* id)
{
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = feed_reader_cached_action_new (FEED_READER_CACHED_ACTIONS_MARK_READ_CATEGORY, id, "");
	action = _tmp0_;
	feed_reader_cached_action_manager_addAction (self, action);
	_g_object_unref0 (action);
}

void
feed_reader_cached_action_manager_markAllRead (FeedReaderCachedActionManager* self)
{
	FeedReaderCachedAction* action = NULL;
	FeedReaderCachedAction* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = feed_reader_cached_action_new (FEED_READER_CACHED_ACTIONS_MARK_READ_ALL, "", "");
	action = _tmp0_;
	feed_reader_cached_action_manager_addAction (self, action);
	_g_object_unref0 (action);
}

static void
feed_reader_cached_action_manager_addAction (FeedReaderCachedActionManager* self,
                                             FeedReaderCachedAction* action)
{
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp0_;
	FeedReaderDataBase* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = feed_reader_data_base_writeAccess ();
	db = _tmp0_;
	_tmp1_ = db;
	if (feed_reader_data_base_cachedActionNecessary (_tmp1_, action)) {
		FeedReaderDataBase* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = db;
		_tmp3_ = feed_reader_cached_action_getID (action);
		_tmp4_ = _tmp3_;
		feed_reader_data_base_addCachedAction (_tmp2_, feed_reader_cached_action_getType (action), _tmp4_, "");
		_g_free0 (_tmp4_);
	} else {
		FeedReaderDataBase* _tmp5_;
		_tmp5_ = db;
		feed_reader_data_base_deleteOppositeCachedAction (_tmp5_, action);
	}
	_g_object_unref0 (db);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
feed_reader_cached_action_manager_executeActions (FeedReaderCachedActionManager* self)
{
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp0_;
	FeedReaderDataBase* _tmp1_;
	GeeList* actions = NULL;
	FeedReaderDataBase* _tmp2_;
	GeeList* _tmp3_;
	const gchar* _tmp62_;
	FeedReaderDataBase* _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = feed_reader_data_base_writeAccess ();
	db = _tmp0_;
	_tmp1_ = db;
	if (feed_reader_data_base_read_only_isTableEmpty ((FeedReaderDataBaseReadOnly*) _tmp1_, "CachedActions")) {
		feed_reader_logger_debug ("CachedActionManager - executeActions: no actions to perform");
		_g_object_unref0 (db);
		return;
	}
	feed_reader_logger_debug ("CachedActionManager: executeActions");
	_tmp2_ = db;
	_tmp3_ = feed_reader_data_base_readCachedActions (_tmp2_);
	actions = _tmp3_;
	{
		GeeList* _action_list = NULL;
		GeeList* _tmp4_;
		gint _action_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _action_index = 0;
		_tmp4_ = actions;
		_action_list = _tmp4_;
		_tmp5_ = _action_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_action_size = _tmp7_;
		_action_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			FeedReaderCachedAction* action = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			FeedReaderCachedAction* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			FeedReaderCachedAction* _tmp15_;
			GEnumValue* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			FeedReaderCachedAction* _tmp19_;
			FeedReaderCachedAction* _tmp61_;
			_action_index = _action_index + 1;
			_tmp8_ = _action_index;
			_tmp9_ = _action_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _action_list;
			_tmp11_ = gee_list_get (_tmp10_, _action_index);
			action = (FeedReaderCachedAction*) _tmp11_;
			_tmp12_ = action;
			_tmp13_ = feed_reader_cached_action_getID (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = action;
			_tmp16_ = g_enum_get_value (g_type_class_ref (FEED_READER_TYPE_CACHED_ACTIONS), feed_reader_cached_action_getType (_tmp15_));
			_tmp17_ = g_strdup_printf ("CachedActionManager: executeActions %s %s", _tmp14_, (_tmp16_ != NULL) ? _tmp16_->value_name : NULL);
			_tmp18_ = _tmp17_;
			feed_reader_logger_debug (_tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp14_);
			_tmp19_ = action;
			switch (feed_reader_cached_action_getType (_tmp19_)) {
				case FEED_READER_CACHED_ACTIONS_MARK_READ:
				case FEED_READER_CACHED_ACTIONS_MARK_UNREAD:
				{
					gboolean _tmp20_ = FALSE;
					FeedReaderCachedAction* _tmp21_;
					_tmp21_ = action;
					if (feed_reader_cached_action_getType (_tmp21_) != self->priv->m_lastAction) {
						const gchar* _tmp22_;
						_tmp22_ = self->priv->m_ids;
						_tmp20_ = g_strcmp0 (_tmp22_, "") != 0;
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						const gchar* _tmp23_;
						FeedReaderCachedAction* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						_tmp23_ = self->priv->m_ids;
						_tmp24_ = action;
						_tmp25_ = feed_reader_cached_action_getID (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
						_g_free0 (self->priv->m_ids);
						self->priv->m_ids = _tmp27_;
						_g_free0 (_tmp26_);
						_tmp28_ = self->priv->m_ids;
						_tmp29_ = string_substring (_tmp28_, (glong) 1, (glong) -1);
						_tmp30_ = _tmp29_;
						feed_reader_cached_action_manager_execute (self, _tmp30_, self->priv->m_lastAction);
						_g_free0 (_tmp30_);
						self->priv->m_lastAction = FEED_READER_CACHED_ACTIONS_NONE;
						_tmp31_ = g_strdup ("");
						_g_free0 (self->priv->m_ids);
						self->priv->m_ids = _tmp31_;
					} else {
						const gchar* _tmp32_;
						FeedReaderCachedAction* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp32_ = self->priv->m_ids;
						_tmp33_ = action;
						_tmp34_ = feed_reader_cached_action_getID (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strconcat (",", _tmp35_, NULL);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat (_tmp32_, _tmp37_, NULL);
						_g_free0 (self->priv->m_ids);
						self->priv->m_ids = _tmp38_;
						_g_free0 (_tmp37_);
						_g_free0 (_tmp35_);
					}
					break;
				}
				case FEED_READER_CACHED_ACTIONS_MARK_STARRED:
				{
					FeedReaderFeedServer* _tmp39_;
					FeedReaderFeedServer* _tmp40_;
					FeedReaderCachedAction* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp39_ = feed_reader_feed_server_get_default ();
					_tmp40_ = _tmp39_;
					_tmp41_ = action;
					_tmp42_ = feed_reader_cached_action_getID (_tmp41_);
					_tmp43_ = _tmp42_;
					feed_reader_feed_server_setArticleIsMarked (_tmp40_, _tmp43_, FEED_READER_ARTICLE_STATUS_MARKED);
					_g_free0 (_tmp43_);
					_g_object_unref0 (_tmp40_);
					break;
				}
				case FEED_READER_CACHED_ACTIONS_MARK_UNSTARRED:
				{
					FeedReaderFeedServer* _tmp44_;
					FeedReaderFeedServer* _tmp45_;
					FeedReaderCachedAction* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					_tmp44_ = feed_reader_feed_server_get_default ();
					_tmp45_ = _tmp44_;
					_tmp46_ = action;
					_tmp47_ = feed_reader_cached_action_getID (_tmp46_);
					_tmp48_ = _tmp47_;
					feed_reader_feed_server_setArticleIsMarked (_tmp45_, _tmp48_, FEED_READER_ARTICLE_STATUS_UNMARKED);
					_g_free0 (_tmp48_);
					_g_object_unref0 (_tmp45_);
					break;
				}
				case FEED_READER_CACHED_ACTIONS_MARK_READ_FEED:
				{
					FeedReaderFeedServer* _tmp49_;
					FeedReaderFeedServer* _tmp50_;
					FeedReaderCachedAction* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp49_ = feed_reader_feed_server_get_default ();
					_tmp50_ = _tmp49_;
					_tmp51_ = action;
					_tmp52_ = feed_reader_cached_action_getID (_tmp51_);
					_tmp53_ = _tmp52_;
					feed_reader_feed_server_setFeedRead (_tmp50_, _tmp53_);
					_g_free0 (_tmp53_);
					_g_object_unref0 (_tmp50_);
					break;
				}
				case FEED_READER_CACHED_ACTIONS_MARK_READ_CATEGORY:
				{
					FeedReaderFeedServer* _tmp54_;
					FeedReaderFeedServer* _tmp55_;
					FeedReaderCachedAction* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp54_ = feed_reader_feed_server_get_default ();
					_tmp55_ = _tmp54_;
					_tmp56_ = action;
					_tmp57_ = feed_reader_cached_action_getID (_tmp56_);
					_tmp58_ = _tmp57_;
					feed_reader_feed_server_setCategoryRead (_tmp55_, _tmp58_);
					_g_free0 (_tmp58_);
					_g_object_unref0 (_tmp55_);
					break;
				}
				case FEED_READER_CACHED_ACTIONS_MARK_READ_ALL:
				{
					FeedReaderFeedServer* _tmp59_;
					FeedReaderFeedServer* _tmp60_;
					_tmp59_ = feed_reader_feed_server_get_default ();
					_tmp60_ = _tmp59_;
					feed_reader_feed_server_markAllItemsRead (_tmp60_);
					_g_object_unref0 (_tmp60_);
					break;
				}
				default:
				break;
			}
			_tmp61_ = action;
			self->priv->m_lastAction = feed_reader_cached_action_getType (_tmp61_);
			_g_object_unref0 (action);
		}
	}
	_tmp62_ = self->priv->m_ids;
	if (g_strcmp0 (_tmp62_, "") != 0) {
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp63_ = self->priv->m_ids;
		_tmp64_ = string_substring (_tmp63_, (glong) 1, (glong) -1);
		_tmp65_ = _tmp64_;
		feed_reader_cached_action_manager_execute (self, _tmp65_, self->priv->m_lastAction);
		_g_free0 (_tmp65_);
	}
	_tmp66_ = db;
	feed_reader_data_base_resetCachedActions (_tmp66_);
	_g_object_unref0 (actions);
	_g_object_unref0 (db);
}

static void
feed_reader_cached_action_manager_execute (FeedReaderCachedActionManager* self,
                                           const gchar* ids,
                                           FeedReaderCachedActions action)
{
	GEnumValue* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ids != NULL);
	_tmp0_ = g_enum_get_value (g_type_class_ref (FEED_READER_TYPE_CACHED_ACTIONS), action);
	_tmp1_ = g_strdup_printf ("CachedActionManager: execute %s %s", ids, (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	switch (action) {
		case FEED_READER_CACHED_ACTIONS_MARK_READ:
		{
			FeedReaderFeedServer* _tmp3_;
			FeedReaderFeedServer* _tmp4_;
			_tmp3_ = feed_reader_feed_server_get_default ();
			_tmp4_ = _tmp3_;
			feed_reader_feed_server_setArticleIsRead (_tmp4_, ids, FEED_READER_ARTICLE_STATUS_READ);
			_g_object_unref0 (_tmp4_);
			break;
		}
		case FEED_READER_CACHED_ACTIONS_MARK_UNREAD:
		{
			FeedReaderFeedServer* _tmp5_;
			FeedReaderFeedServer* _tmp6_;
			_tmp5_ = feed_reader_feed_server_get_default ();
			_tmp6_ = _tmp5_;
			feed_reader_feed_server_setArticleIsRead (_tmp6_, ids, FEED_READER_ARTICLE_STATUS_UNREAD);
			_g_object_unref0 (_tmp6_);
			break;
		}
		default:
		break;
	}
}

static void
feed_reader_cached_action_manager_class_init (FeedReaderCachedActionManagerClass * klass,
                                              gpointer klass_data)
{
	feed_reader_cached_action_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderCachedActionManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_cached_action_manager_finalize;
}

static void
feed_reader_cached_action_manager_instance_init (FeedReaderCachedActionManager * self,
                                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = feed_reader_cached_action_manager_get_instance_private (self);
	self->priv->m_lastAction = FEED_READER_CACHED_ACTIONS_NONE;
	_tmp0_ = g_strdup ("");
	self->priv->m_ids = _tmp0_;
}

static void
feed_reader_cached_action_manager_finalize (GObject * obj)
{
	FeedReaderCachedActionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_CACHED_ACTION_MANAGER, FeedReaderCachedActionManager);
	_g_free0 (self->priv->m_ids);
	G_OBJECT_CLASS (feed_reader_cached_action_manager_parent_class)->finalize (obj);
}

static GType
feed_reader_cached_action_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderCachedActionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_cached_action_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderCachedActionManager), 0, (GInstanceInitFunc) feed_reader_cached_action_manager_instance_init, NULL };
	GType feed_reader_cached_action_manager_type_id;
	feed_reader_cached_action_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderCachedActionManager", &g_define_type_info, 0);
	FeedReaderCachedActionManager_private_offset = g_type_add_instance_private (feed_reader_cached_action_manager_type_id, sizeof (FeedReaderCachedActionManagerPrivate));
	return feed_reader_cached_action_manager_type_id;
}

GType
feed_reader_cached_action_manager_get_type (void)
{
	static volatile gsize feed_reader_cached_action_manager_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_cached_action_manager_type_id__once)) {
		GType feed_reader_cached_action_manager_type_id;
		feed_reader_cached_action_manager_type_id = feed_reader_cached_action_manager_get_type_once ();
		g_once_init_leave (&feed_reader_cached_action_manager_type_id__once, feed_reader_cached_action_manager_type_id);
	}
	return feed_reader_cached_action_manager_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

