/* grabber.c generated by valac 0.56.3, the Vala compiler
 * generated from grabber.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <libxml/HTMLtree.h>
#include <libxml/HTMLparser.h>
#include <libxml/tree.h>
#include <glib-object.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <libxml/parser.h>

enum  {
	FEED_READER_GRABBER_0_PROPERTY,
	FEED_READER_GRABBER_NUM_PROPERTIES
};
static GParamSpec* feed_reader_grabber_properties[FEED_READER_GRABBER_NUM_PROPERTIES];
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _xmlFreeNs0(var) ((var == NULL) ? NULL : (var = (xmlFreeNs (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block78Data Block78Data;
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _htmlFreeParserCtxt0(var) ((var == NULL) ? NULL : (var = (htmlFreeParserCtxt (var), NULL)))

struct _FeedReaderGrabberPrivate {
	FeedReaderArticle* m_article;
	gchar* m_articleURL;
	gchar* m_rawHtml;
	gchar* m_nexPageURL;
	FeedReaderGrabberConfig* m_config;
	SoupSession* m_session;
	gboolean m_firstPage;
	xmlDoc* m_doc;
	xmlNode* m_root;
	xmlNs* m_ns;
	gboolean m_foundSomething;
	gboolean m_singlePage;
};

struct _Block78Data {
	int _ref_count_;
	FeedReaderGrabber* self;
	SoupMessage* msg;
};

static gint FeedReaderGrabber_private_offset;
static gpointer feed_reader_grabber_parent_class = NULL;

static gboolean feed_reader_grabber_checkConfigFile (FeedReaderGrabber* self);
static void _vala_SoupURI_free (SoupURI* self);
static gboolean feed_reader_grabber_checkContentType (FeedReaderGrabber* self);
static gboolean feed_reader_grabber_download (FeedReaderGrabber* self);
static void feed_reader_grabber_prepArticle (FeedReaderGrabber* self);
static gboolean feed_reader_grabber_parse (FeedReaderGrabber* self,
                                    GCancellable* cancellable);
static void _g_free0_ (gpointer var);
static Block78Data* block78_data_ref (Block78Data* _data78_);
static void block78_data_unref (void * _userdata_);
static void __lambda15_ (Block78Data* _data78_);
static void ___lambda15__soup_message_restarted (SoupMessage* _sender,
                                          gpointer self);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static void feed_reader_grabber_finalize (GObject * obj);
static GType feed_reader_grabber_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_grabber_get_instance_private (FeedReaderGrabber* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderGrabber_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderGrabber*
feed_reader_grabber_construct (GType object_type,
                               SoupSession* session,
                               FeedReaderArticle* article)
{
	FeedReaderGrabber * self = NULL;
	FeedReaderArticle* _tmp0_;
	FeedReaderArticle* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	FeedReaderArticle* _tmp11_;
	gchar* _tmp12_;
	SoupSession* _tmp13_;
	g_return_val_if_fail (session != NULL, NULL);
	g_return_val_if_fail (article != NULL, NULL);
	self = (FeedReaderGrabber*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (article);
	_g_object_unref0 (self->priv->m_article);
	self->priv->m_article = _tmp0_;
	_tmp1_ = self->priv->m_article;
	_tmp2_ = feed_reader_article_getURL (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (_tmp3_, "//");
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		FeedReaderArticle* _tmp5_;
		FeedReaderArticle* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = self->priv->m_article;
		_tmp6_ = self->priv->m_article;
		_tmp7_ = feed_reader_article_getURL (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("http:", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		feed_reader_article_setURL (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	_tmp11_ = self->priv->m_article;
	_tmp12_ = feed_reader_article_getURL (_tmp11_);
	_g_free0 (self->priv->m_articleURL);
	self->priv->m_articleURL = _tmp12_;
	self->priv->m_firstPage = TRUE;
	self->priv->m_foundSomething = FALSE;
	self->priv->m_singlePage = FALSE;
	_tmp13_ = _g_object_ref0 (session);
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp13_;
	return self;
}

FeedReaderGrabber*
feed_reader_grabber_new (SoupSession* session,
                         FeedReaderArticle* article)
{
	return feed_reader_grabber_construct (FEED_READER_TYPE_GRABBER, session, article);
}

static gboolean
feed_reader_grabber_checkConfigFile (FeedReaderGrabber* self)
{
	GeeArrayList* filepaths = NULL;
	GeeArrayList* _tmp0_;
	gchar* userconf = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* globalconf = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* hostName = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* newHostName = NULL;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	filepaths = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_strconcat (_tmp1_, "/feedreader/GrabberConfig/", NULL);
	userconf = _tmp2_;
	_tmp3_ = userconf;
	if (g_file_test (_tmp3_, G_FILE_TEST_EXISTS)) {
		GeeArrayList* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = filepaths;
		_tmp5_ = userconf;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
	}
	_tmp6_ = g_strdup (FEED_READER_CONSTANTS_INSTALL_PREFIX "/share/feedreader/GrabberConfig/");
	globalconf = _tmp6_;
	_tmp7_ = globalconf;
	if (g_file_test (_tmp7_, G_FILE_TEST_EXISTS)) {
		GeeArrayList* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = filepaths;
		_tmp9_ = globalconf;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->m_articleURL;
	_tmp11_ = feed_reader_grabber_utils_buildHostName (_tmp10_, FALSE);
	hostName = _tmp11_;
	{
		GeeArrayList* _filepath_list = NULL;
		GeeArrayList* _tmp12_;
		gint _filepath_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _filepath_index = 0;
		_tmp12_ = filepaths;
		_filepath_list = _tmp12_;
		_tmp13_ = _filepath_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_filepath_size = _tmp15_;
		_filepath_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gchar* filepath = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			gchar* filename = NULL;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			_filepath_index = _filepath_index + 1;
			_tmp16_ = _filepath_index;
			_tmp17_ = _filepath_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _filepath_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _filepath_index);
			filepath = (gchar*) _tmp19_;
			_tmp20_ = filepath;
			_tmp21_ = hostName;
			_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat (_tmp23_, ".txt", NULL);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			filename = _tmp25_;
			_tmp26_ = filename;
			if (g_file_test (_tmp26_, G_FILE_TEST_EXISTS)) {
				const gchar* _tmp27_;
				FeedReaderGrabberConfig* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp27_ = filename;
				_tmp28_ = feed_reader_grabber_config_new (_tmp27_);
				_g_object_unref0 (self->priv->m_config);
				self->priv->m_config = _tmp28_;
				_tmp29_ = hostName;
				_tmp30_ = g_strdup_printf ("Grabber: using config %s.txt", _tmp29_);
				_tmp31_ = _tmp30_;
				feed_reader_logger_debug (_tmp31_);
				_g_free0 (_tmp31_);
				result = TRUE;
				_g_free0 (filename);
				_g_free0 (filepath);
				_g_free0 (hostName);
				_g_free0 (globalconf);
				_g_free0 (userconf);
				_g_object_unref0 (filepaths);
				return result;
			}
			_g_free0 (filename);
			_g_free0 (filepath);
		}
	}
	_tmp32_ = hostName;
	_tmp33_ = self->priv->m_articleURL;
	_tmp34_ = g_strdup_printf ("Grabber: no config (%s.txt) found for article: %s", _tmp32_, _tmp33_);
	_tmp35_ = _tmp34_;
	feed_reader_logger_debug (_tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = self->priv->m_articleURL;
	_tmp37_ = feed_reader_grabber_utils_buildHostName (_tmp36_, TRUE);
	newHostName = _tmp37_;
	_tmp38_ = hostName;
	_tmp39_ = newHostName;
	if (g_strcmp0 (_tmp38_, _tmp39_) != 0) {
		{
			GeeArrayList* _filepath_list = NULL;
			GeeArrayList* _tmp40_;
			gint _filepath_size = 0;
			GeeArrayList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _filepath_index = 0;
			_tmp40_ = filepaths;
			_filepath_list = _tmp40_;
			_tmp41_ = _filepath_list;
			_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_filepath_size = _tmp43_;
			_filepath_index = -1;
			while (TRUE) {
				gint _tmp44_;
				gint _tmp45_;
				gchar* filepath = NULL;
				GeeArrayList* _tmp46_;
				gpointer _tmp47_;
				gchar* filename = NULL;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gboolean _tmp58_;
				_filepath_index = _filepath_index + 1;
				_tmp44_ = _filepath_index;
				_tmp45_ = _filepath_size;
				if (!(_tmp44_ < _tmp45_)) {
					break;
				}
				_tmp46_ = _filepath_list;
				_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _filepath_index);
				filepath = (gchar*) _tmp47_;
				_tmp48_ = filepath;
				_tmp49_ = newHostName;
				_tmp50_ = g_strconcat (_tmp48_, _tmp49_, NULL);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (_tmp51_, ".txt", NULL);
				_tmp53_ = _tmp52_;
				_g_free0 (_tmp51_);
				filename = _tmp53_;
				_tmp54_ = filename;
				_tmp55_ = newHostName;
				_tmp56_ = g_strdup_printf ("%s%s.txt", _tmp54_, _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = g_file_test (_tmp57_, G_FILE_TEST_EXISTS);
				_g_free0 (_tmp57_);
				if (_tmp58_) {
					const gchar* _tmp59_;
					FeedReaderGrabberConfig* _tmp60_;
					const gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp59_ = filename;
					_tmp60_ = feed_reader_grabber_config_new (_tmp59_);
					_g_object_unref0 (self->priv->m_config);
					self->priv->m_config = _tmp60_;
					_tmp61_ = newHostName;
					_tmp62_ = g_strdup_printf ("Grabber: using config %s.txt", _tmp61_);
					_tmp63_ = _tmp62_;
					feed_reader_logger_debug (_tmp63_);
					_g_free0 (_tmp63_);
					result = TRUE;
					_g_free0 (filename);
					_g_free0 (filepath);
					_g_free0 (newHostName);
					_g_free0 (hostName);
					_g_free0 (globalconf);
					_g_free0 (userconf);
					_g_object_unref0 (filepaths);
					return result;
				}
				_g_free0 (filename);
				_g_free0 (filepath);
			}
		}
	}
	_tmp64_ = newHostName;
	_tmp65_ = self->priv->m_articleURL;
	_tmp66_ = g_strdup_printf ("Grabber: no config (%s.txt) - cutSubdomain - found for article: %s", _tmp64_, _tmp65_);
	_tmp67_ = _tmp66_;
	feed_reader_logger_debug (_tmp67_);
	_g_free0 (_tmp67_);
	result = FALSE;
	_g_free0 (newHostName);
	_g_free0 (hostName);
	_g_free0 (globalconf);
	_g_free0 (userconf);
	_g_object_unref0 (filepaths);
	return result;
}

static void
_vala_SoupURI_free (SoupURI* self)
{
	g_boxed_free (soup_uri_get_type (), self);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
feed_reader_grabber_process (FeedReaderGrabber* self,
                             GCancellable* cancellable)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupURI* uri = NULL;
	const gchar* _tmp3_;
	SoupURI* _tmp4_;
	SoupURI* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean downloaded = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_articleURL;
	_tmp1_ = g_strconcat ("Grabber: process article: ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->m_articleURL;
	_tmp4_ = soup_uri_new (_tmp3_);
	uri = _tmp4_;
	_tmp5_ = uri;
	if (_tmp5_ == NULL) {
		feed_reader_logger_error ("No valid article-url?!?");
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	if (!feed_reader_grabber_checkContentType (self)) {
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	if (cancellable != NULL) {
		_tmp6_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	downloaded = FALSE;
	if (!feed_reader_grabber_checkConfigFile (self)) {
		gchar* youtube = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* oldURL = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp7_ = g_strdup ("youtube.com/watch?v=");
		youtube = _tmp7_;
		_tmp8_ = self->priv->m_articleURL;
		_tmp9_ = youtube;
		if (string_contains (_tmp8_, _tmp9_)) {
			gchar* ytHTML = NULL;
			gchar* _tmp10_;
			gint start = 0;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint end = 0;
			const gchar* _tmp16_;
			gint _tmp17_ = 0;
			gchar* id = NULL;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			feed_reader_logger_debug ("Grabber: special treatment - youtube video");
			_tmp10_ = g_strdup ("<div class=\"videoWrapper\"><iframe width=\"100%\" src=\"https://www.y" \
"outube.com/embed/%s\" frameborder=\"0\" allowfullscreen></iframe></div" \
">");
			ytHTML = _tmp10_;
			_tmp11_ = self->priv->m_articleURL;
			_tmp12_ = youtube;
			_tmp13_ = youtube;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			start = string_index_of (_tmp11_, _tmp12_, 0) + _tmp15_;
			_tmp16_ = self->priv->m_articleURL;
			end = string_index_of (_tmp16_, "?", start);
			if (end == -1) {
				_tmp17_ = -1;
			} else {
				_tmp17_ = end - start;
			}
			_tmp18_ = self->priv->m_articleURL;
			_tmp19_ = string_substring (_tmp18_, (glong) start, (glong) _tmp17_);
			id = _tmp19_;
			_tmp20_ = ytHTML;
			_tmp21_ = id;
			_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
			_g_free0 (self->m_html);
			self->m_html = _tmp22_;
			result = TRUE;
			_g_free0 (id);
			_g_free0 (ytHTML);
			_g_free0 (youtube);
			__vala_SoupURI_free0 (uri);
			return result;
		}
		_tmp23_ = self->priv->m_articleURL;
		_tmp24_ = g_strdup (_tmp23_);
		oldURL = _tmp24_;
		downloaded = feed_reader_grabber_download (self);
		_tmp25_ = self->priv->m_articleURL;
		_tmp26_ = oldURL;
		if (g_strcmp0 (_tmp25_, _tmp26_) != 0) {
			if (!feed_reader_grabber_checkConfigFile (self)) {
				result = FALSE;
				_g_free0 (oldURL);
				_g_free0 (youtube);
				__vala_SoupURI_free0 (uri);
				return result;
			}
		} else {
			result = FALSE;
			_g_free0 (oldURL);
			_g_free0 (youtube);
			__vala_SoupURI_free0 (uri);
			return result;
		}
		_g_free0 (oldURL);
		_g_free0 (youtube);
	}
	if (cancellable != NULL) {
		_tmp27_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	feed_reader_logger_debug ("Grabber: config found");
	if (!downloaded) {
		_tmp28_ = !feed_reader_grabber_download (self);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	feed_reader_logger_debug ("Grabber: download success");
	feed_reader_grabber_prepArticle (self);
	feed_reader_logger_debug ("Grabber: empty article preped");
	if (!feed_reader_grabber_parse (self, cancellable)) {
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	if (!self->priv->m_foundSomething) {
		feed_reader_logger_error ("Grabber: no body found");
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	result = TRUE;
	__vala_SoupURI_free0 (uri);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
feed_reader_grabber_checkContentType (FeedReaderGrabber* self)
{
	SoupMessage* message = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupSession* _tmp6_;
	SoupMessage* _tmp7_;
	GHashTable* params = NULL;
	GHashTable* _tmp8_;
	gchar* contentType = NULL;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	GHashTable* _tmp11_ = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	feed_reader_logger_debug ("Grabber: check contentType");
	_tmp0_ = self->priv->m_articleURL;
	_tmp1_ = g_strescape (_tmp0_, "");
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new ("HEAD", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	message = _tmp4_;
	_tmp5_ = message;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (message);
		return result;
	}
	_tmp6_ = self->priv->m_session;
	_tmp7_ = message;
	soup_session_send_message (_tmp6_, _tmp7_);
	_tmp8_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_free0_);
	params = _tmp8_;
	_tmp9_ = message;
	_tmp10_ = _tmp9_->response_headers;
	_tmp12_ = soup_message_headers_get_content_type (_tmp10_, &_tmp11_);
	_g_hash_table_unref0 (params);
	params = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	contentType = _tmp13_;
	_tmp14_ = contentType;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		_tmp15_ = contentType;
		if (g_strcmp0 (_tmp15_, "text/html") == 0) {
			result = TRUE;
			_g_free0 (contentType);
			_g_hash_table_unref0 (params);
			_g_object_unref0 (message);
			return result;
		}
	}
	_tmp16_ = contentType;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("Grabber: type ", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	feed_reader_logger_debug (_tmp19_);
	_g_free0 (_tmp19_);
	feed_reader_logger_debug ("Grabber: type != text/html so not going to proceed further");
	result = FALSE;
	_g_free0 (contentType);
	_g_hash_table_unref0 (params);
	_g_object_unref0 (message);
	return result;
}

static Block78Data*
block78_data_ref (Block78Data* _data78_)
{
	g_atomic_int_inc (&_data78_->_ref_count_);
	return _data78_;
}

static void
block78_data_unref (void * _userdata_)
{
	Block78Data* _data78_;
	_data78_ = (Block78Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data78_->_ref_count_)) {
		FeedReaderGrabber* self;
		self = _data78_->self;
		_g_object_unref0 (_data78_->msg);
		_g_object_unref0 (self);
		g_slice_free (Block78Data, _data78_);
	}
}

static void
__lambda15_ (Block78Data* _data78_)
{
	FeedReaderGrabber* self;
	SoupMessage* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	SoupMessage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	self = _data78_->self;
	_tmp0_ = _data78_->msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("Grabber: download redirected - ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	feed_reader_logger_debug (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp8_ = _data78_->msg;
	g_object_get (_tmp8_, "status-code", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == ((guint) SOUP_STATUS_MOVED_TEMPORARILY)) {
		_tmp7_ = TRUE;
	} else {
		SoupMessage* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp11_ = _data78_->msg;
		g_object_get (_tmp11_, "status-code", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp7_ = _tmp13_ == ((guint) SOUP_STATUS_MOVED_PERMANENTLY);
	}
	if (_tmp7_) {
		SoupMessage* _tmp14_;
		SoupURI* _tmp15_;
		SoupURI* _tmp16_;
		gchar* _tmp17_;
		FeedReaderArticle* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp14_ = _data78_->msg;
		_tmp15_ = soup_message_get_uri (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = soup_uri_to_string (_tmp16_, FALSE);
		_g_free0 (self->priv->m_articleURL);
		self->priv->m_articleURL = _tmp17_;
		_tmp18_ = self->priv->m_article;
		_tmp19_ = self->priv->m_articleURL;
		feed_reader_article_setURL (_tmp18_, _tmp19_);
		_tmp20_ = self->priv->m_articleURL;
		_tmp21_ = g_strconcat ("Grabber: new url is: ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		feed_reader_logger_debug (_tmp22_);
		_g_free0 (_tmp22_);
	}
}

static void
___lambda15__soup_message_restarted (SoupMessage* _sender,
                                     gpointer self)
{
	__lambda15_ (self);
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gboolean
feed_reader_grabber_download (FeedReaderGrabber* self)
{
	Block78Data* _data78_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	gulong handlerID = 0UL;
	SoupMessage* _tmp5_;
	gulong _tmp6_;
	SoupMessage* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	gboolean _tmp10_;
	SoupSession* _tmp13_;
	SoupMessage* _tmp14_;
	SoupMessage* _tmp15_;
	SoupMessage* _tmp16_;
	SoupMessageBody* _tmp17_;
	SoupMessage* _tmp18_;
	SoupMessageBody* _tmp19_;
	SoupBuffer* _tmp20_;
	SoupBuffer* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	gboolean _tmp23_;
	SoupMessage* _tmp24_;
	SoupMessageBody* _tmp25_;
	SoupBuffer* _tmp26_;
	SoupBuffer* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data78_ = g_slice_new0 (Block78Data);
	_data78_->_ref_count_ = 1;
	_data78_->self = g_object_ref (self);
	_tmp0_ = self->priv->m_articleURL;
	_tmp1_ = g_strescape (_tmp0_, "");
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new ("GET", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_data78_->msg = _tmp4_;
	_tmp5_ = _data78_->msg;
	_tmp6_ = g_signal_connect_data (_tmp5_, "restarted", (GCallback) ___lambda15__soup_message_restarted, block78_data_ref (_data78_), (GClosureNotify) block78_data_unref, 0);
	handlerID = _tmp6_;
	_tmp7_ = _data78_->msg;
	if (_tmp7_ == NULL) {
		result = FALSE;
		block78_data_unref (_data78_);
		_data78_ = NULL;
		return result;
	}
	_tmp8_ = feed_reader_settings_tweaks ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "do-not-track");
	_g_object_unref0 (_tmp9_);
	if (_tmp10_) {
		SoupMessage* _tmp11_;
		SoupMessageHeaders* _tmp12_;
		_tmp11_ = _data78_->msg;
		_tmp12_ = _tmp11_->request_headers;
		soup_message_headers_append (_tmp12_, "DNT", "1");
	}
	_tmp13_ = self->priv->m_session;
	_tmp14_ = _data78_->msg;
	soup_session_send_message (_tmp13_, _tmp14_);
	_tmp15_ = _data78_->msg;
	g_signal_handler_disconnect ((GObject*) _tmp15_, handlerID);
	_tmp16_ = _data78_->msg;
	_tmp17_ = _tmp16_->response_body;
	if (_tmp17_ == NULL) {
		feed_reader_logger_debug ("Grabber: download failed - no response");
		result = FALSE;
		block78_data_unref (_data78_);
		_data78_ = NULL;
		return result;
	}
	_tmp18_ = _data78_->msg;
	_tmp19_ = _tmp18_->response_body;
	_tmp20_ = soup_message_body_flatten (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_->data;
	_tmp22__length1 = _tmp21_->length;
	_tmp23_ = g_strcmp0 ((const gchar*) _tmp22_, "") == 0;
	__vala_SoupBuffer_free0 (_tmp21_);
	if (_tmp23_) {
		feed_reader_logger_debug ("Grabber: download failed - empty response");
		result = FALSE;
		block78_data_unref (_data78_);
		_data78_ = NULL;
		return result;
	}
	_tmp24_ = _data78_->msg;
	_tmp25_ = _tmp24_->response_body;
	_tmp26_ = soup_message_body_flatten (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_->data;
	_tmp28__length1 = _tmp27_->length;
	_tmp29_ = g_strdup ((const gchar*) _tmp28_);
	_g_free0 (self->priv->m_rawHtml);
	self->priv->m_rawHtml = _tmp29_;
	__vala_SoupBuffer_free0 (_tmp27_);
	_tmp30_ = self->priv->m_rawHtml;
	if (!g_utf8_validate (_tmp30_, (gssize) -1, NULL)) {
		gchar* needle = NULL;
		gchar* _tmp31_;
		gint start = 0;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gchar* locale = NULL;
		gchar* _tmp37_;
		const gchar* _tmp50_;
		_tmp31_ = g_strdup ("content=\"text/html; charset=");
		needle = _tmp31_;
		_tmp32_ = self->priv->m_rawHtml;
		_tmp33_ = needle;
		_tmp34_ = needle;
		_tmp35_ = strlen (_tmp34_);
		_tmp36_ = _tmp35_;
		start = string_index_of (_tmp32_, _tmp33_, 0) + _tmp36_;
		_tmp37_ = g_strdup ("");
		locale = _tmp37_;
		if (start != -1) {
			gint end = 0;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp38_ = self->priv->m_rawHtml;
			end = string_index_of (_tmp38_, "\"", start);
			_tmp39_ = self->priv->m_rawHtml;
			_tmp40_ = string_substring (_tmp39_, (glong) start, (glong) (end - start));
			_g_free0 (locale);
			locale = _tmp40_;
		} else {
			gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			_tmp41_ = g_strdup ("charset=\"");
			_g_free0 (needle);
			needle = _tmp41_;
			_tmp42_ = self->priv->m_rawHtml;
			_tmp43_ = needle;
			_tmp44_ = needle;
			_tmp45_ = strlen (_tmp44_);
			_tmp46_ = _tmp45_;
			start = string_index_of (_tmp42_, _tmp43_, 0) + _tmp46_;
			if (start != -1) {
				gint end = 0;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp47_ = self->priv->m_rawHtml;
				end = string_index_of (_tmp47_, "\"", start);
				_tmp48_ = self->priv->m_rawHtml;
				_tmp49_ = string_substring (_tmp48_, (glong) start, (glong) (end - start));
				_g_free0 (locale);
				locale = _tmp49_;
			} else {
				result = FALSE;
				_g_free0 (locale);
				_g_free0 (needle);
				block78_data_unref (_data78_);
				_data78_ = NULL;
				return result;
			}
		}
		_tmp50_ = locale;
		feed_reader_logger_info (_tmp50_);
		{
			gchar* _tmp51_ = NULL;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp56_;
			_tmp52_ = self->priv->m_rawHtml;
			_tmp53_ = locale;
			_tmp54_ = g_convert (_tmp52_, (gssize) -1, "utf-8", _tmp53_, NULL, NULL, &_inner_error0_);
			_tmp51_ = _tmp54_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp55_ = FALSE;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				_g_free0 (locale);
				_g_free0 (needle);
				block78_data_unref (_data78_);
				_data78_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp55_;
			}
			_tmp56_ = _tmp51_;
			_tmp51_ = NULL;
			_g_free0 (self->priv->m_rawHtml);
			self->priv->m_rawHtml = _tmp56_;
			_g_free0 (_tmp51_);
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			GError* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp57_ = e;
			_tmp58_ = _tmp57_->message;
			_tmp59_ = g_strconcat ("grabber: failed to convert locale - ", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			feed_reader_logger_error (_tmp60_);
			_g_free0 (_tmp60_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp61_ = FALSE;
			_g_free0 (locale);
			_g_free0 (needle);
			block78_data_unref (_data78_);
			_data78_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp61_;
		}
		_g_free0 (locale);
		_g_free0 (needle);
	}
	result = TRUE;
	block78_data_unref (_data78_);
	_data78_ = NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gboolean
feed_reader_grabber_parse (FeedReaderGrabber* self,
                           GCancellable* cancellable)
{
	GeeList* replace = NULL;
	FeedReaderGrabberConfig* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	htmlParserCtxt* html_cntx = NULL;
	htmlParserCtxt* _tmp21_;
	htmlParserCtxt* _tmp22_;
	xmlDoc* doc = NULL;
	htmlParserCtxt* _tmp23_;
	const gchar* _tmp24_;
	xmlDoc* _tmp25_;
	xmlDoc* _tmp26_;
	FeedReaderGrabberConfig* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp36_ = FALSE;
	FeedReaderGrabberConfig* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gboolean _tmp40_;
	GeeList* title = NULL;
	FeedReaderGrabberConfig* _tmp61_;
	GeeList* _tmp62_;
	gboolean _tmp63_ = FALSE;
	GeeList* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gboolean _tmp85_ = FALSE;
	GeeList* author = NULL;
	FeedReaderGrabberConfig* _tmp87_;
	GeeList* _tmp88_;
	GeeList* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	gboolean _tmp108_ = FALSE;
	GeeList* date = NULL;
	FeedReaderGrabberConfig* _tmp110_;
	GeeList* _tmp111_;
	GeeList* _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	gboolean _tmp131_ = FALSE;
	GeeList* strip = NULL;
	FeedReaderGrabberConfig* _tmp133_;
	GeeList* _tmp134_;
	GeeList* _tmp135_;
	gint _tmp136_;
	gint _tmp137_;
	gboolean _tmp151_ = FALSE;
	GeeList* _stripIDorClass = NULL;
	FeedReaderGrabberConfig* _tmp153_;
	GeeList* _tmp154_;
	GeeList* _tmp155_;
	gint _tmp156_;
	gint _tmp157_;
	gboolean _tmp168_ = FALSE;
	GeeList* stripImgSrc = NULL;
	FeedReaderGrabberConfig* _tmp170_;
	GeeList* _tmp171_;
	GeeList* _tmp172_;
	gint _tmp173_;
	gint _tmp174_;
	gboolean _tmp187_ = FALSE;
	xmlDoc* _tmp189_;
	xmlDoc* _tmp190_;
	xmlDoc* _tmp191_;
	xmlDoc* _tmp192_;
	xmlDoc* _tmp193_;
	xmlDoc* _tmp194_;
	xmlDoc* _tmp195_;
	gboolean _tmp196_ = FALSE;
	xmlDoc* _tmp198_;
	const gchar* _tmp199_;
	xmlDoc* _tmp200_;
	const gchar* _tmp201_;
	xmlDoc* _tmp202_;
	const gchar* _tmp203_;
	xmlDoc* _tmp204_;
	const gchar* _tmp205_;
	xmlDoc* _tmp206_;
	const gchar* _tmp207_;
	xmlDoc* _tmp208_;
	gboolean _tmp209_ = FALSE;
	xmlDoc* _tmp211_;
	xmlDoc* _tmp212_;
	xmlDoc* _tmp213_;
	xmlDoc* _tmp214_;
	xmlDoc* _tmp215_;
	xmlDoc* _tmp216_;
	gboolean _tmp217_ = FALSE;
	GeeList* bodyList = NULL;
	FeedReaderGrabberConfig* _tmp219_;
	GeeList* _tmp220_;
	GeeList* _tmp221_;
	gint _tmp222_;
	gint _tmp223_;
	xmlDoc* _tmp238_;
	gboolean _tmp239_ = FALSE;
	gboolean _tmp240_ = FALSE;
	const gchar* _tmp241_;
	GSettings* _tmp253_;
	GSettings* _tmp254_;
	gboolean _tmp255_;
	gboolean _tmp259_ = FALSE;
	xmlDoc* _tmp260_;
	gchar* _tmp261_ = NULL;
	gchar* _tmp262_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_g_free0 (self->priv->m_nexPageURL);
	self->priv->m_nexPageURL = NULL;
	feed_reader_logger_debug ("Grabber: start parsing");
	_tmp0_ = self->priv->m_config;
	_tmp1_ = feed_reader_grabber_config_getReplace (_tmp0_);
	replace = _tmp1_;
	_tmp2_ = replace;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != 0) {
		{
			GeeList* _pair_list = NULL;
			GeeList* _tmp5_;
			gint _pair_size = 0;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _pair_index = 0;
			_tmp5_ = replace;
			_pair_list = _tmp5_;
			_tmp6_ = _pair_list;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_pair_size = _tmp8_;
			_pair_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				FeedReaderStringPair* pair = NULL;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				const gchar* _tmp13_;
				FeedReaderStringPair* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				FeedReaderStringPair* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_pair_index = _pair_index + 1;
				_tmp9_ = _pair_index;
				_tmp10_ = _pair_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _pair_list;
				_tmp12_ = gee_list_get (_tmp11_, _pair_index);
				pair = (FeedReaderStringPair*) _tmp12_;
				_tmp13_ = self->priv->m_rawHtml;
				_tmp14_ = pair;
				_tmp15_ = feed_reader_string_pair_getString1 (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = pair;
				_tmp18_ = feed_reader_string_pair_getString2 (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = string_replace (_tmp13_, _tmp16_, _tmp19_);
				_g_free0 (self->priv->m_rawHtml);
				self->priv->m_rawHtml = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp16_);
				_g_object_unref0 (pair);
			}
		}
	}
	feed_reader_logger_debug ("Grabber: parse html");
	_tmp21_ = htmlNewParserCtxt ();
	html_cntx = _tmp21_;
	_tmp22_ = html_cntx;
	htmlCtxtUseOptions (_tmp22_, (gint) (HTML_PARSE_NOERROR + HTML_PARSE_NOWARNING));
	_tmp23_ = html_cntx;
	_tmp24_ = self->priv->m_rawHtml;
	_tmp25_ = htmlCtxtReadDoc (_tmp23_, (xmlChar*) _tmp24_, "", NULL, 0);
	doc = _tmp25_;
	_tmp26_ = doc;
	if (_tmp26_ == NULL) {
		feed_reader_logger_debug ("Grabber: parsing failed");
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	feed_reader_logger_debug ("Grabber: html parsed");
	_tmp27_ = self->priv->m_config;
	_tmp28_ = feed_reader_grabber_config_getXPathNextPageURL (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_ != NULL;
	_g_free0 (_tmp29_);
	if (_tmp30_) {
		xmlDoc* _tmp31_;
		FeedReaderGrabberConfig* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		feed_reader_logger_debug ("Grabber: grab next page url");
		_tmp31_ = doc;
		_tmp32_ = self->priv->m_config;
		_tmp33_ = feed_reader_grabber_config_getXPathNextPageURL (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = feed_reader_grabber_utils_getURL (_tmp31_, _tmp34_);
		_g_free0 (self->priv->m_nexPageURL);
		self->priv->m_nexPageURL = _tmp35_;
		_g_free0 (_tmp34_);
	}
	_tmp37_ = self->priv->m_config;
	_tmp38_ = feed_reader_grabber_config_getXPathSinglePageURL (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_ != NULL;
	_g_free0 (_tmp39_);
	if (_tmp40_) {
		const gchar* _tmp41_;
		_tmp41_ = self->priv->m_nexPageURL;
		_tmp36_ = _tmp41_ == NULL;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gchar* url = NULL;
		xmlDoc* _tmp42_;
		FeedReaderGrabberConfig* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gboolean _tmp48_ = FALSE;
		const gchar* _tmp49_;
		feed_reader_logger_debug ("Grabber: grab single page view");
		_tmp42_ = doc;
		_tmp43_ = self->priv->m_config;
		_tmp44_ = feed_reader_grabber_config_getXPathSinglePageURL (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = feed_reader_grabber_utils_getURL (_tmp42_, _tmp45_);
		_tmp47_ = _tmp46_;
		_g_free0 (_tmp45_);
		url = _tmp47_;
		_tmp49_ = url;
		if (g_strcmp0 (_tmp49_, "") != 0) {
			const gchar* _tmp50_;
			_tmp50_ = url;
			_tmp48_ = _tmp50_ != NULL;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			const gchar* _tmp51_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
			xmlDoc* _tmp57_;
			htmlParserCtxt* _tmp58_;
			const gchar* _tmp59_;
			xmlDoc* _tmp60_;
			_tmp51_ = url;
			if (!g_str_has_prefix (_tmp51_, "http")) {
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp52_ = url;
				_tmp53_ = self->priv->m_articleURL;
				_tmp54_ = feed_reader_grabber_utils_completeURL (_tmp52_, _tmp53_);
				_g_free0 (url);
				url = _tmp54_;
			}
			self->priv->m_singlePage = TRUE;
			_tmp55_ = url;
			_tmp56_ = g_strdup (_tmp55_);
			_g_free0 (self->priv->m_articleURL);
			self->priv->m_articleURL = _tmp56_;
			feed_reader_grabber_download (self);
			_tmp57_ = doc;
			_xmlFreeDoc0 (_tmp57_);
			_tmp58_ = html_cntx;
			_tmp59_ = self->priv->m_rawHtml;
			_tmp60_ = htmlCtxtReadDoc (_tmp58_, (xmlChar*) _tmp59_, "", NULL, 0);
			doc = _tmp60_;
		}
		_g_free0 (url);
	}
	_tmp61_ = self->priv->m_config;
	_tmp62_ = feed_reader_grabber_config_getXPathTitle (_tmp61_);
	title = _tmp62_;
	_tmp64_ = title;
	_tmp65_ = gee_collection_get_size ((GeeCollection*) _tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != 0) {
		_tmp63_ = self->priv->m_firstPage;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		feed_reader_logger_debug ("Grabber: get title");
		{
			GeeList* _xpath_list = NULL;
			GeeList* _tmp67_;
			gint _xpath_size = 0;
			GeeList* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _xpath_index = 0;
			_tmp67_ = title;
			_xpath_list = _tmp67_;
			_tmp68_ = _xpath_list;
			_tmp69_ = gee_collection_get_size ((GeeCollection*) _tmp68_);
			_tmp70_ = _tmp69_;
			_xpath_size = _tmp70_;
			_xpath_index = -1;
			while (TRUE) {
				gint _tmp71_;
				gint _tmp72_;
				gchar* xpath = NULL;
				GeeList* _tmp73_;
				gpointer _tmp74_;
				gchar* tmptitle = NULL;
				xmlDoc* _tmp75_;
				const gchar* _tmp76_;
				gchar* _tmp77_;
				gboolean _tmp78_ = FALSE;
				const gchar* _tmp79_;
				_xpath_index = _xpath_index + 1;
				_tmp71_ = _xpath_index;
				_tmp72_ = _xpath_size;
				if (!(_tmp71_ < _tmp72_)) {
					break;
				}
				_tmp73_ = _xpath_list;
				_tmp74_ = gee_list_get (_tmp73_, _xpath_index);
				xpath = (gchar*) _tmp74_;
				_tmp75_ = doc;
				_tmp76_ = xpath;
				_tmp77_ = feed_reader_grabber_utils_getValue (_tmp75_, _tmp76_, self->priv->m_firstPage);
				tmptitle = _tmp77_;
				_tmp79_ = tmptitle;
				if (_tmp79_ != NULL) {
					const gchar* _tmp80_;
					_tmp80_ = tmptitle;
					_tmp78_ = g_strcmp0 (_tmp80_, "") != 0;
				} else {
					_tmp78_ = FALSE;
				}
				if (_tmp78_) {
					const gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					_tmp81_ = tmptitle;
					_tmp82_ = string_chomp (_tmp81_);
					_tmp83_ = _tmp82_;
					_tmp84_ = string_chug (_tmp83_);
					_g_free0 (self->m_title);
					self->m_title = _tmp84_;
					_g_free0 (_tmp83_);
				}
				_g_free0 (tmptitle);
				_g_free0 (xpath);
			}
		}
	}
	if (cancellable != NULL) {
		_tmp85_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp85_ = FALSE;
	}
	if (_tmp85_) {
		xmlDoc* _tmp86_;
		_tmp86_ = doc;
		_xmlFreeDoc0 (_tmp86_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp87_ = self->priv->m_config;
	_tmp88_ = feed_reader_grabber_config_getXPathAuthor (_tmp87_);
	author = _tmp88_;
	_tmp89_ = author;
	_tmp90_ = gee_collection_get_size ((GeeCollection*) _tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_ != 0) {
		feed_reader_logger_debug ("Grabber: get author");
		{
			GeeList* _xpath_list = NULL;
			GeeList* _tmp92_;
			gint _xpath_size = 0;
			GeeList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _xpath_index = 0;
			_tmp92_ = author;
			_xpath_list = _tmp92_;
			_tmp93_ = _xpath_list;
			_tmp94_ = gee_collection_get_size ((GeeCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_xpath_size = _tmp95_;
			_xpath_index = -1;
			while (TRUE) {
				gint _tmp96_;
				gint _tmp97_;
				gchar* xpath = NULL;
				GeeList* _tmp98_;
				gpointer _tmp99_;
				gchar* tmpAuthor = NULL;
				xmlDoc* _tmp100_;
				const gchar* _tmp101_;
				gchar* _tmp102_;
				const gchar* _tmp103_;
				_xpath_index = _xpath_index + 1;
				_tmp96_ = _xpath_index;
				_tmp97_ = _xpath_size;
				if (!(_tmp96_ < _tmp97_)) {
					break;
				}
				_tmp98_ = _xpath_list;
				_tmp99_ = gee_list_get (_tmp98_, _xpath_index);
				xpath = (gchar*) _tmp99_;
				_tmp100_ = doc;
				_tmp101_ = xpath;
				_tmp102_ = feed_reader_grabber_utils_getValue (_tmp100_, _tmp101_, FALSE);
				tmpAuthor = _tmp102_;
				_tmp103_ = tmpAuthor;
				if (_tmp103_ != NULL) {
					const gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					_tmp104_ = tmpAuthor;
					_tmp105_ = string_chomp (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = string_chug (_tmp106_);
					_g_free0 (self->m_author);
					self->m_author = _tmp107_;
					_g_free0 (_tmp106_);
				}
				_g_free0 (tmpAuthor);
				_g_free0 (xpath);
			}
		}
	}
	if (cancellable != NULL) {
		_tmp108_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		xmlDoc* _tmp109_;
		_tmp109_ = doc;
		_xmlFreeDoc0 (_tmp109_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp110_ = self->priv->m_config;
	_tmp111_ = feed_reader_grabber_config_getXPathDate (_tmp110_);
	date = _tmp111_;
	_tmp112_ = date;
	_tmp113_ = gee_collection_get_size ((GeeCollection*) _tmp112_);
	_tmp114_ = _tmp113_;
	if (_tmp114_ != 0) {
		feed_reader_logger_debug ("Grabber: get date");
		{
			GeeList* _xpath_list = NULL;
			GeeList* _tmp115_;
			gint _xpath_size = 0;
			GeeList* _tmp116_;
			gint _tmp117_;
			gint _tmp118_;
			gint _xpath_index = 0;
			_tmp115_ = date;
			_xpath_list = _tmp115_;
			_tmp116_ = _xpath_list;
			_tmp117_ = gee_collection_get_size ((GeeCollection*) _tmp116_);
			_tmp118_ = _tmp117_;
			_xpath_size = _tmp118_;
			_xpath_index = -1;
			while (TRUE) {
				gint _tmp119_;
				gint _tmp120_;
				gchar* xpath = NULL;
				GeeList* _tmp121_;
				gpointer _tmp122_;
				gchar* tmpDate = NULL;
				xmlDoc* _tmp123_;
				const gchar* _tmp124_;
				gchar* _tmp125_;
				const gchar* _tmp126_;
				_xpath_index = _xpath_index + 1;
				_tmp119_ = _xpath_index;
				_tmp120_ = _xpath_size;
				if (!(_tmp119_ < _tmp120_)) {
					break;
				}
				_tmp121_ = _xpath_list;
				_tmp122_ = gee_list_get (_tmp121_, _xpath_index);
				xpath = (gchar*) _tmp122_;
				_tmp123_ = doc;
				_tmp124_ = xpath;
				_tmp125_ = feed_reader_grabber_utils_getValue (_tmp123_, _tmp124_, FALSE);
				tmpDate = _tmp125_;
				_tmp126_ = tmpDate;
				if (_tmp126_ != NULL) {
					const gchar* _tmp127_;
					gchar* _tmp128_;
					gchar* _tmp129_;
					gchar* _tmp130_;
					_tmp127_ = tmpDate;
					_tmp128_ = string_chomp (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = string_chug (_tmp129_);
					_g_free0 (self->m_date);
					self->m_date = _tmp130_;
					_g_free0 (_tmp129_);
				}
				_g_free0 (tmpDate);
				_g_free0 (xpath);
			}
		}
	}
	if (cancellable != NULL) {
		_tmp131_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp131_ = FALSE;
	}
	if (_tmp131_) {
		xmlDoc* _tmp132_;
		_tmp132_ = doc;
		_xmlFreeDoc0 (_tmp132_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp133_ = self->priv->m_config;
	_tmp134_ = feed_reader_grabber_config_getXPathStrip (_tmp133_);
	strip = _tmp134_;
	_tmp135_ = strip;
	_tmp136_ = gee_collection_get_size ((GeeCollection*) _tmp135_);
	_tmp137_ = _tmp136_;
	if (_tmp137_ != 0) {
		feed_reader_logger_debug ("Grabber: strip junk");
		{
			GeeList* _xpath_list = NULL;
			GeeList* _tmp138_;
			gint _xpath_size = 0;
			GeeList* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gint _xpath_index = 0;
			_tmp138_ = strip;
			_xpath_list = _tmp138_;
			_tmp139_ = _xpath_list;
			_tmp140_ = gee_collection_get_size ((GeeCollection*) _tmp139_);
			_tmp141_ = _tmp140_;
			_xpath_size = _tmp141_;
			_xpath_index = -1;
			while (TRUE) {
				gint _tmp142_;
				gint _tmp143_;
				gchar* xpath = NULL;
				GeeList* _tmp144_;
				gpointer _tmp145_;
				const gchar* _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				xmlDoc* _tmp149_;
				const gchar* _tmp150_;
				_xpath_index = _xpath_index + 1;
				_tmp142_ = _xpath_index;
				_tmp143_ = _xpath_size;
				if (!(_tmp142_ < _tmp143_)) {
					break;
				}
				_tmp144_ = _xpath_list;
				_tmp145_ = gee_list_get (_tmp144_, _xpath_index);
				xpath = (gchar*) _tmp145_;
				_tmp146_ = xpath;
				_tmp147_ = g_strdup_printf ("Grabber: strip %s", _tmp146_);
				_tmp148_ = _tmp147_;
				feed_reader_logger_debug (_tmp148_);
				_g_free0 (_tmp148_);
				_tmp149_ = doc;
				_tmp150_ = xpath;
				feed_reader_grabber_utils_stripNode (_tmp149_, _tmp150_);
				_g_free0 (xpath);
			}
		}
	}
	if (cancellable != NULL) {
		_tmp151_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		xmlDoc* _tmp152_;
		_tmp152_ = doc;
		_xmlFreeDoc0 (_tmp152_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp153_ = self->priv->m_config;
	_tmp154_ = feed_reader_grabber_config_getXPathStripIDorClass (_tmp153_);
	_stripIDorClass = _tmp154_;
	_tmp155_ = _stripIDorClass;
	_tmp156_ = gee_collection_get_size ((GeeCollection*) _tmp155_);
	_tmp157_ = _tmp156_;
	if (_tmp157_ != 0) {
		feed_reader_logger_debug ("Grabber: strip id's and class");
		{
			GeeList* _IDorClass_list = NULL;
			GeeList* _tmp158_;
			gint _IDorClass_size = 0;
			GeeList* _tmp159_;
			gint _tmp160_;
			gint _tmp161_;
			gint _IDorClass_index = 0;
			_tmp158_ = _stripIDorClass;
			_IDorClass_list = _tmp158_;
			_tmp159_ = _IDorClass_list;
			_tmp160_ = gee_collection_get_size ((GeeCollection*) _tmp159_);
			_tmp161_ = _tmp160_;
			_IDorClass_size = _tmp161_;
			_IDorClass_index = -1;
			while (TRUE) {
				gint _tmp162_;
				gint _tmp163_;
				gchar* IDorClass = NULL;
				GeeList* _tmp164_;
				gpointer _tmp165_;
				xmlDoc* _tmp166_;
				const gchar* _tmp167_;
				_IDorClass_index = _IDorClass_index + 1;
				_tmp162_ = _IDorClass_index;
				_tmp163_ = _IDorClass_size;
				if (!(_tmp162_ < _tmp163_)) {
					break;
				}
				_tmp164_ = _IDorClass_list;
				_tmp165_ = gee_list_get (_tmp164_, _IDorClass_index);
				IDorClass = (gchar*) _tmp165_;
				_tmp166_ = doc;
				_tmp167_ = IDorClass;
				feed_reader_grabber_utils_stripIDorClass (_tmp166_, _tmp167_);
				_g_free0 (IDorClass);
			}
		}
	}
	if (cancellable != NULL) {
		_tmp168_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp168_ = FALSE;
	}
	if (_tmp168_) {
		xmlDoc* _tmp169_;
		_tmp169_ = doc;
		_xmlFreeDoc0 (_tmp169_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp170_ = self->priv->m_config;
	_tmp171_ = feed_reader_grabber_config_getXPathStripImgSrc (_tmp170_);
	stripImgSrc = _tmp171_;
	_tmp172_ = stripImgSrc;
	_tmp173_ = gee_collection_get_size ((GeeCollection*) _tmp172_);
	_tmp174_ = _tmp173_;
	if (_tmp174_ != 0) {
		feed_reader_logger_debug ("Grabber: strip img-tags");
		{
			GeeList* _ImgSrc_list = NULL;
			GeeList* _tmp175_;
			gint _ImgSrc_size = 0;
			GeeList* _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			gint _ImgSrc_index = 0;
			_tmp175_ = stripImgSrc;
			_ImgSrc_list = _tmp175_;
			_tmp176_ = _ImgSrc_list;
			_tmp177_ = gee_collection_get_size ((GeeCollection*) _tmp176_);
			_tmp178_ = _tmp177_;
			_ImgSrc_size = _tmp178_;
			_ImgSrc_index = -1;
			while (TRUE) {
				gint _tmp179_;
				gint _tmp180_;
				gchar* ImgSrc = NULL;
				GeeList* _tmp181_;
				gpointer _tmp182_;
				xmlDoc* _tmp183_;
				const gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				_ImgSrc_index = _ImgSrc_index + 1;
				_tmp179_ = _ImgSrc_index;
				_tmp180_ = _ImgSrc_size;
				if (!(_tmp179_ < _tmp180_)) {
					break;
				}
				_tmp181_ = _ImgSrc_list;
				_tmp182_ = gee_list_get (_tmp181_, _ImgSrc_index);
				ImgSrc = (gchar*) _tmp182_;
				_tmp183_ = doc;
				_tmp184_ = ImgSrc;
				_tmp185_ = g_strdup_printf ("//img[contains(@src,'%s')]", _tmp184_);
				_tmp186_ = _tmp185_;
				feed_reader_grabber_utils_stripNode (_tmp183_, _tmp186_);
				_g_free0 (_tmp186_);
				_g_free0 (ImgSrc);
			}
		}
	}
	if (cancellable != NULL) {
		_tmp187_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp187_ = FALSE;
	}
	if (_tmp187_) {
		xmlDoc* _tmp188_;
		_tmp188_ = doc;
		_xmlFreeDoc0 (_tmp188_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp189_ = doc;
	feed_reader_grabber_utils_fixLazyImg (_tmp189_, "lazyload", "data-src");
	_tmp190_ = doc;
	feed_reader_grabber_utils_fixIframeSize (_tmp190_, "youtube.com");
	_tmp191_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp191_, NULL, "style");
	_tmp192_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp192_, "a", "onclick");
	_tmp193_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp193_, "img", "srcset");
	_tmp194_ = doc;
	feed_reader_grabber_utils_removeAttributes (_tmp194_, "img", "sizes");
	_tmp195_ = doc;
	feed_reader_grabber_utils_addAttributes (_tmp195_, "a", "target", "_blank");
	if (cancellable != NULL) {
		_tmp196_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp196_ = FALSE;
	}
	if (_tmp196_) {
		xmlDoc* _tmp197_;
		_tmp197_ = doc;
		_xmlFreeDoc0 (_tmp197_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	feed_reader_logger_debug ("Grabber: complete urls");
	_tmp198_ = doc;
	_tmp199_ = self->priv->m_articleURL;
	feed_reader_grabber_utils_repairURL ("//img", "src", _tmp198_, _tmp199_);
	_tmp200_ = doc;
	_tmp201_ = self->priv->m_articleURL;
	feed_reader_grabber_utils_repairURL ("//a", "src", _tmp200_, _tmp201_);
	_tmp202_ = doc;
	_tmp203_ = self->priv->m_articleURL;
	feed_reader_grabber_utils_repairURL ("//a", "href", _tmp202_, _tmp203_);
	_tmp204_ = doc;
	_tmp205_ = self->priv->m_articleURL;
	feed_reader_grabber_utils_repairURL ("//object", "data", _tmp204_, _tmp205_);
	_tmp206_ = doc;
	_tmp207_ = self->priv->m_articleURL;
	feed_reader_grabber_utils_repairURL ("//iframe", "src", _tmp206_, _tmp207_);
	feed_reader_logger_debug ("Grabber: strip instapaper and readability");
	_tmp208_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp208_, "//*[contains(concat(' ',normalize-space(@class),' '),' entry-unrelated" \
" ') or contains(concat(' ',normalize-space(@class),' '),' instapaper_i" \
"gnore ')]");
	if (cancellable != NULL) {
		_tmp209_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp209_ = FALSE;
	}
	if (_tmp209_) {
		xmlDoc* _tmp210_;
		_tmp210_ = doc;
		_xmlFreeDoc0 (_tmp210_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	feed_reader_logger_debug ("Grabber: strip invisible elements");
	_tmp211_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp211_, "//*[contains(@style,'display:none')]");
	feed_reader_logger_debug ("Grabber: strip all scripts");
	_tmp212_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp212_, "//script");
	feed_reader_logger_debug ("Grabber: strip all <noscript>");
	_tmp213_ = doc;
	feed_reader_grabber_utils_onlyRemoveNode (_tmp213_, "//noscript");
	feed_reader_logger_debug ("Grabber: strip all comments");
	_tmp214_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp214_, "//comment()");
	feed_reader_logger_debug ("Grabber: strip all empty url-tags");
	_tmp215_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp215_, "//a[not(node())]");
	feed_reader_logger_debug ("Grabber: strip all external css and fonts");
	_tmp216_ = doc;
	feed_reader_grabber_utils_stripNode (_tmp216_, "//*[@type='text/css']");
	if (cancellable != NULL) {
		_tmp217_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp217_ = FALSE;
	}
	if (_tmp217_) {
		xmlDoc* _tmp218_;
		_tmp218_ = doc;
		_xmlFreeDoc0 (_tmp218_);
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp219_ = self->priv->m_config;
	_tmp220_ = feed_reader_grabber_config_getXPathBody (_tmp219_);
	bodyList = _tmp220_;
	_tmp221_ = bodyList;
	_tmp222_ = gee_collection_get_size ((GeeCollection*) _tmp221_);
	_tmp223_ = _tmp222_;
	if (_tmp223_ != 0) {
		feed_reader_logger_debug ("Grabber: get body");
		{
			GeeList* _bodyXPath_list = NULL;
			GeeList* _tmp224_;
			gint _bodyXPath_size = 0;
			GeeList* _tmp225_;
			gint _tmp226_;
			gint _tmp227_;
			gint _bodyXPath_index = 0;
			_tmp224_ = bodyList;
			_bodyXPath_list = _tmp224_;
			_tmp225_ = _bodyXPath_list;
			_tmp226_ = gee_collection_get_size ((GeeCollection*) _tmp225_);
			_tmp227_ = _tmp226_;
			_bodyXPath_size = _tmp227_;
			_bodyXPath_index = -1;
			while (TRUE) {
				gint _tmp228_;
				gint _tmp229_;
				gchar* bodyXPath = NULL;
				GeeList* _tmp230_;
				gpointer _tmp231_;
				xmlDoc* _tmp232_;
				const gchar* _tmp233_;
				xmlNode* _tmp234_;
				_bodyXPath_index = _bodyXPath_index + 1;
				_tmp228_ = _bodyXPath_index;
				_tmp229_ = _bodyXPath_size;
				if (!(_tmp228_ < _tmp229_)) {
					break;
				}
				_tmp230_ = _bodyXPath_list;
				_tmp231_ = gee_list_get (_tmp230_, _bodyXPath_index);
				bodyXPath = (gchar*) _tmp231_;
				_tmp232_ = doc;
				_tmp233_ = bodyXPath;
				_tmp234_ = self->priv->m_root;
				if (feed_reader_grabber_utils_extractBody (_tmp232_, _tmp233_, _tmp234_)) {
					self->priv->m_foundSomething = TRUE;
				} else {
					const gchar* _tmp235_;
					gchar* _tmp236_;
					gchar* _tmp237_;
					_tmp235_ = bodyXPath;
					_tmp236_ = g_strconcat ("Failed to find: ", _tmp235_, NULL);
					_tmp237_ = _tmp236_;
					feed_reader_logger_info (_tmp237_);
					_g_free0 (_tmp237_);
				}
				_g_free0 (bodyXPath);
			}
		}
		if (self->priv->m_foundSomething) {
			feed_reader_logger_debug ("Grabber: body found");
		} else {
			feed_reader_logger_debug ("Grabber: no body found");
			result = FALSE;
			_htmlFreeParserCtxt0 (html_cntx);
			return result;
		}
	} else {
		feed_reader_logger_error ("Grabber: config file has no rule for 'body'");
	}
	_tmp238_ = doc;
	_xmlFreeDoc0 (_tmp238_);
	if (cancellable != NULL) {
		_tmp239_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	self->priv->m_firstPage = FALSE;
	_tmp241_ = self->priv->m_nexPageURL;
	if (_tmp241_ != NULL) {
		_tmp240_ = !self->priv->m_singlePage;
	} else {
		_tmp240_ = FALSE;
	}
	if (_tmp240_) {
		const gchar* _tmp242_;
		const gchar* _tmp246_;
		const gchar* _tmp247_;
		feed_reader_logger_debug ("Grabber: load next page");
		_tmp242_ = self->priv->m_nexPageURL;
		if (!g_str_has_prefix (_tmp242_, "http")) {
			const gchar* _tmp243_;
			const gchar* _tmp244_;
			gchar* _tmp245_;
			_tmp243_ = self->priv->m_nexPageURL;
			_tmp244_ = self->priv->m_articleURL;
			_tmp245_ = feed_reader_grabber_utils_completeURL (_tmp243_, _tmp244_);
			_g_free0 (self->priv->m_nexPageURL);
			self->priv->m_nexPageURL = _tmp245_;
		}
		_tmp246_ = self->priv->m_articleURL;
		_tmp247_ = self->priv->m_nexPageURL;
		if (g_strcmp0 (_tmp246_, _tmp247_) != 0) {
			const gchar* _tmp248_;
			gchar* _tmp249_;
			const gchar* _tmp250_;
			gchar* _tmp251_;
			gchar* _tmp252_;
			_tmp248_ = self->priv->m_nexPageURL;
			_tmp249_ = g_strdup (_tmp248_);
			_g_free0 (self->priv->m_articleURL);
			self->priv->m_articleURL = _tmp249_;
			_tmp250_ = self->priv->m_nexPageURL;
			_tmp251_ = g_strdup_printf ("Grabber: next page url: %s", _tmp250_);
			_tmp252_ = _tmp251_;
			feed_reader_logger_debug (_tmp252_);
			_g_free0 (_tmp252_);
			feed_reader_grabber_download (self);
			feed_reader_grabber_parse (self, cancellable);
			result = TRUE;
			_htmlFreeParserCtxt0 (html_cntx);
			return result;
		}
	}
	_tmp253_ = feed_reader_settings_general ();
	_tmp254_ = _tmp253_;
	_tmp255_ = g_settings_get_boolean (_tmp254_, "download-images");
	_g_object_unref0 (_tmp254_);
	if (_tmp255_) {
		SoupSession* _tmp256_;
		xmlDoc* _tmp257_;
		FeedReaderArticle* _tmp258_;
		_tmp256_ = self->priv->m_session;
		_tmp257_ = self->priv->m_doc;
		_tmp258_ = self->priv->m_article;
		feed_reader_grabber_utils_saveImages (_tmp256_, _tmp257_, _tmp258_, cancellable);
	}
	if (cancellable != NULL) {
		_tmp259_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp259_ = FALSE;
	}
	if (_tmp259_) {
		result = FALSE;
		_htmlFreeParserCtxt0 (html_cntx);
		return result;
	}
	_tmp260_ = self->priv->m_doc;
	xmlDocDumpMemoryEnc (_tmp260_, (xmlChar**) (&_tmp261_), NULL, "UTF-8");
	_g_free0 (self->m_html);
	self->m_html = _tmp261_;
	_tmp262_ = feed_reader_grabber_utils_postProcessing (&self->m_html);
	_g_free0 (self->m_html);
	self->m_html = _tmp262_;
	result = TRUE;
	_htmlFreeParserCtxt0 (html_cntx);
	return result;
}

static void
feed_reader_grabber_prepArticle (FeedReaderGrabber* self)
{
	xmlDoc* _tmp0_;
	xmlNs* _tmp1_;
	xmlNs* _tmp2_;
	xmlNs* _tmp3_;
	xmlNode* _tmp4_;
	xmlDoc* _tmp5_;
	xmlNode* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = htmlNewDoc ((xmlChar*) "1.0", NULL);
	self->priv->m_doc = _tmp0_;
	_tmp1_ = xmlNewNs (NULL, (xmlChar*) "", (xmlChar*) "article");
	self->priv->m_ns = _tmp1_;
	_tmp2_ = self->priv->m_ns;
	_tmp2_->type = XML_ELEMENT_NODE;
	_tmp3_ = self->priv->m_ns;
	_tmp4_ = xmlNewNode (_tmp3_, (xmlChar*) "body");
	self->priv->m_root = _tmp4_;
	_tmp5_ = self->priv->m_doc;
	_tmp6_ = self->priv->m_root;
	xmlDocSetRootElement (_tmp5_, _tmp6_);
}

gchar*
feed_reader_grabber_getArticle (FeedReaderGrabber* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_html;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_grabber_print (FeedReaderGrabber* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->m_title;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->m_title;
		_tmp2_ = g_strdup_printf ("Grabber: title: %s", _tmp1_);
		_tmp3_ = _tmp2_;
		feed_reader_logger_debug (_tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = self->m_author;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->m_author;
		_tmp6_ = g_strdup_printf ("Grabber: author: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		feed_reader_logger_debug (_tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = self->m_date;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->m_date;
		_tmp10_ = g_strdup_printf ("Grabber: date: %s", _tmp9_);
		_tmp11_ = _tmp10_;
		feed_reader_logger_debug (_tmp11_);
		_g_free0 (_tmp11_);
	}
}

gchar*
feed_reader_grabber_getAuthor (FeedReaderGrabber* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_author;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_grabber_getTitle (FeedReaderGrabber* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
feed_reader_grabber_class_init (FeedReaderGrabberClass * klass,
                                gpointer klass_data)
{
	feed_reader_grabber_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderGrabber_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_grabber_finalize;
}

static void
feed_reader_grabber_instance_init (FeedReaderGrabber * self,
                                   gpointer klass)
{
	self->priv = feed_reader_grabber_get_instance_private (self);
}

static void
feed_reader_grabber_finalize (GObject * obj)
{
	FeedReaderGrabber * self;
	xmlDoc* _tmp0_;
	xmlNs* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_GRABBER, FeedReaderGrabber);
	_tmp0_ = self->priv->m_doc;
	_xmlFreeDoc0 (_tmp0_);
	_tmp1_ = self->priv->m_ns;
	_xmlFreeNs0 (_tmp1_);
	_g_object_unref0 (self->priv->m_article);
	_g_free0 (self->priv->m_articleURL);
	_g_free0 (self->priv->m_rawHtml);
	_g_free0 (self->priv->m_nexPageURL);
	_g_object_unref0 (self->priv->m_config);
	_g_object_unref0 (self->priv->m_session);
	_g_free0 (self->m_author);
	_g_free0 (self->m_title);
	_g_free0 (self->m_date);
	_g_free0 (self->m_html);
	G_OBJECT_CLASS (feed_reader_grabber_parent_class)->finalize (obj);
}

static GType
feed_reader_grabber_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderGrabberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_grabber_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderGrabber), 0, (GInstanceInitFunc) feed_reader_grabber_instance_init, NULL };
	GType feed_reader_grabber_type_id;
	feed_reader_grabber_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderGrabber", &g_define_type_info, 0);
	FeedReaderGrabber_private_offset = g_type_add_instance_private (feed_reader_grabber_type_id, sizeof (FeedReaderGrabberPrivate));
	return feed_reader_grabber_type_id;
}

GType
feed_reader_grabber_get_type (void)
{
	static volatile gsize feed_reader_grabber_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_grabber_type_id__once)) {
		GType feed_reader_grabber_type_id;
		feed_reader_grabber_type_id = feed_reader_grabber_get_type_once ();
		g_once_init_leave (&feed_reader_grabber_type_id__once, feed_reader_grabber_type_id);
	}
	return feed_reader_grabber_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

