/* grabberConfig.c generated by valac 0.56.3, the Vala compiler
 * generated from grabberConfig.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

enum  {
	FEED_READER_GRABBER_CONFIG_0_PROPERTY,
	FEED_READER_GRABBER_CONFIG_NUM_PROPERTIES
};
static GParamSpec* feed_reader_grabber_config_properties[FEED_READER_GRABBER_CONFIG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FeedReaderGrabberConfigPrivate {
	GeeList* m_xpath_title;
	GeeList* m_xpath_author;
	GeeList* m_xpath_date;
	GeeList* m_xpath_body;
	GeeList* m_xpath_strip;
	GeeList* m_xpath_stripIDorClass;
	GeeList* m_xpath_stripImgSrc;
	gboolean m_tidy;
	gboolean m_prune;
	gboolean m_autodetectOnFailure;
	gchar* m_singlePageLink;
	gchar* m_nextPageLink;
	GeeList* m_replace;
	gchar* m_testURL;
};

static gint FeedReaderGrabberConfig_private_offset;
static gpointer feed_reader_grabber_config_parent_class = NULL;

static void feed_reader_grabber_config_splitValues (FeedReaderGrabberConfig* self,
                                             GeeList** list,
                                             const gchar* line);
static gchar* feed_reader_grabber_config_extractValue (FeedReaderGrabberConfig* self,
                                                const gchar* identifier,
                                                const gchar* line);
static void feed_reader_grabber_config_finalize (GObject * obj);
static GType feed_reader_grabber_config_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_grabber_config_get_instance_private (FeedReaderGrabberConfig* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderGrabberConfig_private_offset);
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

FeedReaderGrabberConfig*
feed_reader_grabber_config_construct (GType object_type,
                                      const gchar* filename)
{
	FeedReaderGrabberConfig * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GFile* file = NULL;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (FeedReaderGrabberConfig*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_title);
	self->priv->m_xpath_title = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_author);
	self->priv->m_xpath_author = (GeeList*) _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_date);
	self->priv->m_xpath_date = (GeeList*) _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_body);
	self->priv->m_xpath_body = (GeeList*) _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_strip);
	self->priv->m_xpath_strip = (GeeList*) _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_stripIDorClass);
	self->priv->m_xpath_stripIDorClass = (GeeList*) _tmp5_;
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_xpath_stripImgSrc);
	self->priv->m_xpath_stripImgSrc = (GeeList*) _tmp6_;
	_tmp7_ = gee_array_list_new (FEED_READER_TYPE_STRING_PAIR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_replace);
	self->priv->m_replace = (GeeList*) _tmp7_;
	self->priv->m_tidy = TRUE;
	self->priv->m_prune = TRUE;
	self->priv->m_autodetectOnFailure = TRUE;
	_tmp8_ = g_file_new_for_path (filename);
	file = _tmp8_;
	_tmp9_ = file;
	if (!g_file_query_exists (_tmp9_, NULL)) {
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = file;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("File '%s' doesn't exist.", _tmp12_);
		_tmp14_ = _tmp13_;
		feed_reader_logger_error (_tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (file);
		return self;
	}
	{
		GFileInputStream* _tmp15_ = NULL;
		GFile* _tmp16_;
		GFileInputStream* _tmp17_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp18_;
		gchar* line = NULL;
		_tmp16_ = file;
		_tmp17_ = g_file_read (_tmp16_, NULL, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp18_ = g_data_input_stream_new ((GInputStream*) _tmp15_);
		dis = _tmp18_;
		while (TRUE) {
			gchar* _tmp19_ = NULL;
			GDataInputStream* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_ = FALSE;
			const gchar* _tmp27_;
			_tmp20_ = dis;
			_tmp21_ = g_data_input_stream_read_line (_tmp20_, NULL, NULL, &_inner_error0_);
			_tmp19_ = _tmp21_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp15_);
				goto __catch0_g_error;
			}
			_tmp22_ = _tmp19_;
			_tmp19_ = NULL;
			_g_free0 (line);
			line = _tmp22_;
			_tmp23_ = line;
			if (!(_tmp23_ != NULL)) {
				_g_free0 (_tmp19_);
				break;
			}
			_tmp24_ = line;
			_tmp25_ = string_chug (_tmp24_);
			_g_free0 (line);
			line = _tmp25_;
			_tmp27_ = line;
			if (!g_str_has_prefix (_tmp27_, "#")) {
				const gchar* _tmp28_;
				_tmp28_ = line;
				_tmp26_ = g_strcmp0 (_tmp28_, "") != 0;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				const gchar* _tmp29_;
				_tmp29_ = line;
				if (g_str_has_prefix (_tmp29_, "title:")) {
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp30_ = line;
					_tmp31_ = feed_reader_grabber_config_extractValue (self, "title:", _tmp30_);
					_tmp32_ = _tmp31_;
					feed_reader_grabber_config_splitValues (self, &self->priv->m_xpath_title, _tmp32_);
					_g_free0 (_tmp32_);
				} else {
					const gchar* _tmp33_;
					_tmp33_ = line;
					if (g_str_has_prefix (_tmp33_, "body:")) {
						const gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						_tmp34_ = line;
						_tmp35_ = feed_reader_grabber_config_extractValue (self, "body:", _tmp34_);
						_tmp36_ = _tmp35_;
						feed_reader_grabber_config_splitValues (self, &self->priv->m_xpath_body, _tmp36_);
						_g_free0 (_tmp36_);
					} else {
						const gchar* _tmp37_;
						_tmp37_ = line;
						if (g_str_has_prefix (_tmp37_, "date:")) {
							const gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							_tmp38_ = line;
							_tmp39_ = feed_reader_grabber_config_extractValue (self, "date:", _tmp38_);
							_tmp40_ = _tmp39_;
							feed_reader_grabber_config_splitValues (self, &self->priv->m_xpath_date, _tmp40_);
							_g_free0 (_tmp40_);
						} else {
							const gchar* _tmp41_;
							_tmp41_ = line;
							if (g_str_has_prefix (_tmp41_, "author:")) {
								const gchar* _tmp42_;
								gchar* _tmp43_;
								gchar* _tmp44_;
								_tmp42_ = line;
								_tmp43_ = feed_reader_grabber_config_extractValue (self, "author:", _tmp42_);
								_tmp44_ = _tmp43_;
								feed_reader_grabber_config_splitValues (self, &self->priv->m_xpath_author, _tmp44_);
								_g_free0 (_tmp44_);
							} else {
								const gchar* _tmp45_;
								_tmp45_ = line;
								if (g_str_has_prefix (_tmp45_, "strip:")) {
									GeeList* _tmp46_;
									const gchar* _tmp47_;
									gchar* _tmp48_;
									gchar* _tmp49_;
									_tmp46_ = self->priv->m_xpath_strip;
									_tmp47_ = line;
									_tmp48_ = feed_reader_grabber_config_extractValue (self, "strip:", _tmp47_);
									_tmp49_ = _tmp48_;
									gee_collection_add ((GeeCollection*) _tmp46_, _tmp49_);
									_g_free0 (_tmp49_);
								} else {
									const gchar* _tmp50_;
									_tmp50_ = line;
									if (g_str_has_prefix (_tmp50_, "strip_id_or_class:")) {
										GeeList* _tmp51_;
										const gchar* _tmp52_;
										gchar* _tmp53_;
										gchar* _tmp54_;
										_tmp51_ = self->priv->m_xpath_stripIDorClass;
										_tmp52_ = line;
										_tmp53_ = feed_reader_grabber_config_extractValue (self, "strip_id_or_class:", _tmp52_);
										_tmp54_ = _tmp53_;
										gee_collection_add ((GeeCollection*) _tmp51_, _tmp54_);
										_g_free0 (_tmp54_);
									} else {
										const gchar* _tmp55_;
										_tmp55_ = line;
										if (g_str_has_prefix (_tmp55_, "strip_image_src:")) {
											GeeList* _tmp56_;
											const gchar* _tmp57_;
											gchar* _tmp58_;
											gchar* _tmp59_;
											_tmp56_ = self->priv->m_xpath_stripImgSrc;
											_tmp57_ = line;
											_tmp58_ = feed_reader_grabber_config_extractValue (self, "strip_image_src:", _tmp57_);
											_tmp59_ = _tmp58_;
											gee_collection_add ((GeeCollection*) _tmp56_, _tmp59_);
											_g_free0 (_tmp59_);
										} else {
											const gchar* _tmp60_;
											_tmp60_ = line;
											if (g_str_has_prefix (_tmp60_, "tidy:")) {
												const gchar* _tmp61_;
												gchar* _tmp62_;
												gchar* _tmp63_;
												gboolean _tmp64_;
												_tmp61_ = line;
												_tmp62_ = feed_reader_grabber_config_extractValue (self, "tidy:", _tmp61_);
												_tmp63_ = _tmp62_;
												_tmp64_ = g_strcmp0 (_tmp63_, "no") == 0;
												_g_free0 (_tmp63_);
												if (_tmp64_) {
													self->priv->m_tidy = FALSE;
												}
											} else {
												const gchar* _tmp65_;
												_tmp65_ = line;
												if (g_str_has_prefix (_tmp65_, "prune:")) {
													const gchar* _tmp66_;
													gchar* _tmp67_;
													gchar* _tmp68_;
													gboolean _tmp69_;
													_tmp66_ = line;
													_tmp67_ = feed_reader_grabber_config_extractValue (self, "prune:", _tmp66_);
													_tmp68_ = _tmp67_;
													_tmp69_ = g_strcmp0 (_tmp68_, "no") == 0;
													_g_free0 (_tmp68_);
													if (_tmp69_) {
														self->priv->m_prune = FALSE;
													}
												} else {
													const gchar* _tmp70_;
													_tmp70_ = line;
													if (g_str_has_prefix (_tmp70_, "autodetect_on_failure:")) {
														const gchar* _tmp71_;
														gchar* _tmp72_;
														gchar* _tmp73_;
														gboolean _tmp74_;
														_tmp71_ = line;
														_tmp72_ = feed_reader_grabber_config_extractValue (self, "autodetect_on_failure:", _tmp71_);
														_tmp73_ = _tmp72_;
														_tmp74_ = g_strcmp0 (_tmp73_, "no") == 0;
														_g_free0 (_tmp73_);
														if (_tmp74_) {
															self->priv->m_autodetectOnFailure = FALSE;
														}
													} else {
														const gchar* _tmp75_;
														_tmp75_ = line;
														if (g_str_has_prefix (_tmp75_, "single_page_link:")) {
															const gchar* _tmp76_;
															gchar* _tmp77_;
															_tmp76_ = line;
															_tmp77_ = feed_reader_grabber_config_extractValue (self, "single_page_link:", _tmp76_);
															_g_free0 (self->priv->m_singlePageLink);
															self->priv->m_singlePageLink = _tmp77_;
														} else {
															const gchar* _tmp78_;
															_tmp78_ = line;
															if (g_str_has_prefix (_tmp78_, "next_page_link:")) {
																const gchar* _tmp79_;
																gchar* _tmp80_;
																_tmp79_ = line;
																_tmp80_ = feed_reader_grabber_config_extractValue (self, "next_page_link:", _tmp79_);
																_g_free0 (self->priv->m_nextPageLink);
																self->priv->m_nextPageLink = _tmp80_;
															} else {
																const gchar* _tmp81_;
																_tmp81_ = line;
																if (g_str_has_prefix (_tmp81_, "find_string:")) {
																	gchar* toReplace = NULL;
																	const gchar* _tmp82_;
																	gchar* _tmp83_;
																	gchar* _tmp84_ = NULL;
																	GDataInputStream* _tmp85_;
																	gchar* _tmp86_;
																	gchar* _tmp87_;
																	gchar* replaceWith = NULL;
																	const gchar* _tmp88_;
																	gchar* _tmp89_;
																	GeeList* _tmp90_;
																	const gchar* _tmp91_;
																	const gchar* _tmp92_;
																	FeedReaderStringPair* _tmp93_;
																	FeedReaderStringPair* _tmp94_;
																	_tmp82_ = line;
																	_tmp83_ = feed_reader_grabber_config_extractValue (self, "find_string:", _tmp82_);
																	toReplace = _tmp83_;
																	_tmp85_ = dis;
																	_tmp86_ = g_data_input_stream_read_line (_tmp85_, NULL, NULL, &_inner_error0_);
																	_tmp84_ = _tmp86_;
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
																		_g_free0 (toReplace);
																		_g_free0 (_tmp19_);
																		_g_free0 (line);
																		_g_object_unref0 (dis);
																		_g_object_unref0 (_tmp15_);
																		goto __catch0_g_error;
																	}
																	_tmp87_ = _tmp84_;
																	_tmp84_ = NULL;
																	_g_free0 (line);
																	line = _tmp87_;
																	_tmp88_ = line;
																	_tmp89_ = feed_reader_grabber_config_extractValue (self, "replace_string:", _tmp88_);
																	replaceWith = _tmp89_;
																	_tmp90_ = self->priv->m_replace;
																	_tmp91_ = toReplace;
																	_tmp92_ = replaceWith;
																	_tmp93_ = feed_reader_string_pair_new (_tmp91_, _tmp92_);
																	_tmp94_ = _tmp93_;
																	gee_collection_add ((GeeCollection*) _tmp90_, _tmp94_);
																	_g_object_unref0 (_tmp94_);
																	_g_free0 (replaceWith);
																	_g_free0 (_tmp84_);
																	_g_free0 (toReplace);
																} else {
																	const gchar* _tmp95_;
																	_tmp95_ = line;
																	if (g_str_has_prefix (_tmp95_, "replace_string(")) {
																		gchar* tmp = NULL;
																		const gchar* _tmp96_;
																		gchar* _tmp97_;
																		gchar** values = NULL;
																		const gchar* _tmp98_;
																		gchar** _tmp99_;
																		gchar** _tmp100_;
																		gint values_length1;
																		gint _values_size_;
																		GeeList* _tmp101_;
																		gchar** _tmp102_;
																		gint _tmp102__length1;
																		const gchar* _tmp103_;
																		gchar** _tmp104_;
																		gint _tmp104__length1;
																		const gchar* _tmp105_;
																		FeedReaderStringPair* _tmp106_;
																		FeedReaderStringPair* _tmp107_;
																		_tmp96_ = line;
																		_tmp97_ = feed_reader_grabber_config_extractValue (self, "replace_string(", _tmp96_);
																		tmp = _tmp97_;
																		_tmp98_ = tmp;
																		_tmp100_ = _tmp99_ = g_strsplit (_tmp98_, "): ", 0);
																		values = _tmp100_;
																		values_length1 = _vala_array_length (_tmp99_);
																		_values_size_ = values_length1;
																		_tmp101_ = self->priv->m_replace;
																		_tmp102_ = values;
																		_tmp102__length1 = values_length1;
																		_tmp103_ = _tmp102_[0];
																		_tmp104_ = values;
																		_tmp104__length1 = values_length1;
																		_tmp105_ = _tmp104_[1];
																		_tmp106_ = feed_reader_string_pair_new (_tmp103_, _tmp105_);
																		_tmp107_ = _tmp106_;
																		gee_collection_add ((GeeCollection*) _tmp101_, _tmp107_);
																		_g_object_unref0 (_tmp107_);
																		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
																		_g_free0 (tmp);
																	} else {
																		const gchar* _tmp108_;
																		_tmp108_ = line;
																		if (g_str_has_prefix (_tmp108_, "test_url:")) {
																			const gchar* _tmp109_;
																			gchar* _tmp110_;
																			_tmp109_ = line;
																			_tmp110_ = feed_reader_grabber_config_extractValue (self, "test_url:", _tmp109_);
																			_g_free0 (self->priv->m_testURL);
																			self->priv->m_testURL = _tmp110_;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_g_free0 (_tmp19_);
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp15_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp111_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp111_ = e->message;
		g_error ("grabberConfig.vala:146: %s", _tmp111_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_object_unref0 (file);
	return self;
}

FeedReaderGrabberConfig*
feed_reader_grabber_config_new (const gchar* filename)
{
	return feed_reader_grabber_config_construct (FEED_READER_TYPE_GRABBER_CONFIG, filename);
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
feed_reader_grabber_config_extractValue (FeedReaderGrabberConfig* self,
                                         const gchar* identifier,
                                         const gchar* line)
{
	gchar* res = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint index = 0;
	const gchar* _tmp3_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (identifier != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = strlen (identifier);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_splice (line, (glong) 0, (glong) _tmp1_, NULL);
	res = _tmp2_;
	_tmp3_ = res;
	index = string_index_of (_tmp3_, "#", 0);
	if (index != -1) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = res;
		_tmp5_ = res;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_splice (_tmp4_, (glong) index, (glong) _tmp7_, NULL);
		_g_free0 (res);
		res = _tmp8_;
	}
	_tmp9_ = res;
	_tmp10_ = string_chug (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_chomp (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	result = _tmp13_;
	_g_free0 (res);
	return result;
}

static void
feed_reader_grabber_config_splitValues (FeedReaderGrabberConfig* self,
                                        GeeList** list,
                                        const gchar* line)
{
	gchar** array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint array_length1;
	gint _array_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*list != NULL);
	g_return_if_fail (line != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (line, " | ", 0);
	array = _tmp1_;
	array_length1 = _vala_array_length (_tmp0_);
	_array_size_ = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	{
		gchar** tmp_collection = NULL;
		gint tmp_collection_length1 = 0;
		gint _tmp_collection_size_ = 0;
		gint tmp_it = 0;
		tmp_collection = _tmp2_;
		tmp_collection_length1 = _tmp2__length1;
		for (tmp_it = 0; tmp_it < tmp_collection_length1; tmp_it = tmp_it + 1) {
			gchar* _tmp3_;
			gchar* tmp = NULL;
			_tmp3_ = g_strdup (tmp_collection[tmp_it]);
			tmp = _tmp3_;
			{
				const gchar* _tmp4_;
				_tmp4_ = tmp;
				gee_collection_add ((GeeCollection*) (*list), _tmp4_);
				_g_free0 (tmp);
			}
		}
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}

void
feed_reader_grabber_config_print (FeedReaderGrabberConfig* self)
{
	static const char TAB[] = "     ";
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GeeList* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GeeList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	GeeList* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	GeeList* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	const gchar* _tmp98_;
	const gchar* _tmp102_;
	GeeList* _tmp106_;
	gint _tmp107_;
	gint _tmp108_;
	const gchar* _tmp125_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xpath_title;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		feed_reader_logger_debug ("title:");
		{
			GeeList* _title_list = NULL;
			GeeList* _tmp3_;
			gint _title_size = 0;
			GeeList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _title_index = 0;
			_tmp3_ = self->priv->m_xpath_title;
			_title_list = _tmp3_;
			_tmp4_ = _title_list;
			_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_title_size = _tmp6_;
			_title_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gchar* title = NULL;
				GeeList* _tmp9_;
				gpointer _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_title_index = _title_index + 1;
				_tmp7_ = _title_index;
				_tmp8_ = _title_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _title_list;
				_tmp10_ = gee_list_get (_tmp9_, _title_index);
				title = (gchar*) _tmp10_;
				_tmp11_ = title;
				_tmp12_ = g_strconcat (TAB, _tmp11_, NULL);
				_tmp13_ = _tmp12_;
				feed_reader_logger_debug (_tmp13_);
				_g_free0 (_tmp13_);
				_g_free0 (title);
			}
		}
	}
	_tmp14_ = self->priv->m_xpath_author;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != 0) {
		feed_reader_logger_debug ("author:");
		{
			GeeList* _author_list = NULL;
			GeeList* _tmp17_;
			gint _author_size = 0;
			GeeList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _author_index = 0;
			_tmp17_ = self->priv->m_xpath_author;
			_author_list = _tmp17_;
			_tmp18_ = _author_list;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_author_size = _tmp20_;
			_author_index = -1;
			while (TRUE) {
				gint _tmp21_;
				gint _tmp22_;
				gchar* author = NULL;
				GeeList* _tmp23_;
				gpointer _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_author_index = _author_index + 1;
				_tmp21_ = _author_index;
				_tmp22_ = _author_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _author_list;
				_tmp24_ = gee_list_get (_tmp23_, _author_index);
				author = (gchar*) _tmp24_;
				_tmp25_ = author;
				_tmp26_ = g_strconcat (TAB, _tmp25_, NULL);
				_tmp27_ = _tmp26_;
				feed_reader_logger_debug (_tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (author);
			}
		}
	}
	_tmp28_ = self->priv->m_xpath_date;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != 0) {
		feed_reader_logger_debug ("date:");
		{
			GeeList* _date_list = NULL;
			GeeList* _tmp31_;
			gint _date_size = 0;
			GeeList* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _date_index = 0;
			_tmp31_ = self->priv->m_xpath_date;
			_date_list = _tmp31_;
			_tmp32_ = _date_list;
			_tmp33_ = gee_collection_get_size ((GeeCollection*) _tmp32_);
			_tmp34_ = _tmp33_;
			_date_size = _tmp34_;
			_date_index = -1;
			while (TRUE) {
				gint _tmp35_;
				gint _tmp36_;
				gchar* date = NULL;
				GeeList* _tmp37_;
				gpointer _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_date_index = _date_index + 1;
				_tmp35_ = _date_index;
				_tmp36_ = _date_size;
				if (!(_tmp35_ < _tmp36_)) {
					break;
				}
				_tmp37_ = _date_list;
				_tmp38_ = gee_list_get (_tmp37_, _date_index);
				date = (gchar*) _tmp38_;
				_tmp39_ = date;
				_tmp40_ = g_strconcat (TAB, _tmp39_, NULL);
				_tmp41_ = _tmp40_;
				feed_reader_logger_debug (_tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (date);
			}
		}
	}
	_tmp42_ = self->priv->m_xpath_body;
	_tmp43_ = gee_collection_get_size ((GeeCollection*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != 0) {
		feed_reader_logger_debug ("body:");
		{
			GeeList* _body_list = NULL;
			GeeList* _tmp45_;
			gint _body_size = 0;
			GeeList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint _body_index = 0;
			_tmp45_ = self->priv->m_xpath_body;
			_body_list = _tmp45_;
			_tmp46_ = _body_list;
			_tmp47_ = gee_collection_get_size ((GeeCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_body_size = _tmp48_;
			_body_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				gchar* body = NULL;
				GeeList* _tmp51_;
				gpointer _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				_body_index = _body_index + 1;
				_tmp49_ = _body_index;
				_tmp50_ = _body_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _body_list;
				_tmp52_ = gee_list_get (_tmp51_, _body_index);
				body = (gchar*) _tmp52_;
				_tmp53_ = body;
				_tmp54_ = g_strconcat (TAB, _tmp53_, NULL);
				_tmp55_ = _tmp54_;
				feed_reader_logger_debug (_tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (body);
			}
		}
	}
	_tmp56_ = self->priv->m_xpath_strip;
	_tmp57_ = gee_collection_get_size ((GeeCollection*) _tmp56_);
	_tmp58_ = _tmp57_;
	if (_tmp58_ != 0) {
		feed_reader_logger_debug ("strip:");
		{
			GeeList* _strip_list = NULL;
			GeeList* _tmp59_;
			gint _strip_size = 0;
			GeeList* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _strip_index = 0;
			_tmp59_ = self->priv->m_xpath_strip;
			_strip_list = _tmp59_;
			_tmp60_ = _strip_list;
			_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			_strip_size = _tmp62_;
			_strip_index = -1;
			while (TRUE) {
				gint _tmp63_;
				gint _tmp64_;
				gchar* strip = NULL;
				GeeList* _tmp65_;
				gpointer _tmp66_;
				const gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				_strip_index = _strip_index + 1;
				_tmp63_ = _strip_index;
				_tmp64_ = _strip_size;
				if (!(_tmp63_ < _tmp64_)) {
					break;
				}
				_tmp65_ = _strip_list;
				_tmp66_ = gee_list_get (_tmp65_, _strip_index);
				strip = (gchar*) _tmp66_;
				_tmp67_ = strip;
				_tmp68_ = g_strconcat (TAB, _tmp67_, NULL);
				_tmp69_ = _tmp68_;
				feed_reader_logger_debug (_tmp69_);
				_g_free0 (_tmp69_);
				_g_free0 (strip);
			}
		}
	}
	_tmp70_ = self->priv->m_xpath_stripIDorClass;
	_tmp71_ = gee_collection_get_size ((GeeCollection*) _tmp70_);
	_tmp72_ = _tmp71_;
	if (_tmp72_ != 0) {
		feed_reader_logger_debug ("stripIDorClass:");
		{
			GeeList* _stripIDorClass_list = NULL;
			GeeList* _tmp73_;
			gint _stripIDorClass_size = 0;
			GeeList* _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			gint _stripIDorClass_index = 0;
			_tmp73_ = self->priv->m_xpath_stripIDorClass;
			_stripIDorClass_list = _tmp73_;
			_tmp74_ = _stripIDorClass_list;
			_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
			_tmp76_ = _tmp75_;
			_stripIDorClass_size = _tmp76_;
			_stripIDorClass_index = -1;
			while (TRUE) {
				gint _tmp77_;
				gint _tmp78_;
				gchar* stripIDorClass = NULL;
				GeeList* _tmp79_;
				gpointer _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				_stripIDorClass_index = _stripIDorClass_index + 1;
				_tmp77_ = _stripIDorClass_index;
				_tmp78_ = _stripIDorClass_size;
				if (!(_tmp77_ < _tmp78_)) {
					break;
				}
				_tmp79_ = _stripIDorClass_list;
				_tmp80_ = gee_list_get (_tmp79_, _stripIDorClass_index);
				stripIDorClass = (gchar*) _tmp80_;
				_tmp81_ = stripIDorClass;
				_tmp82_ = g_strconcat (TAB, _tmp81_, NULL);
				_tmp83_ = _tmp82_;
				feed_reader_logger_debug (_tmp83_);
				_g_free0 (_tmp83_);
				_g_free0 (stripIDorClass);
			}
		}
	}
	_tmp84_ = self->priv->m_xpath_stripImgSrc;
	_tmp85_ = gee_collection_get_size ((GeeCollection*) _tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ != 0) {
		feed_reader_logger_debug ("stripImgSrc:");
		{
			GeeList* _stripImgSrc_list = NULL;
			GeeList* _tmp87_;
			gint _stripImgSrc_size = 0;
			GeeList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			gint _stripImgSrc_index = 0;
			_tmp87_ = self->priv->m_xpath_stripImgSrc;
			_stripImgSrc_list = _tmp87_;
			_tmp88_ = _stripImgSrc_list;
			_tmp89_ = gee_collection_get_size ((GeeCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			_stripImgSrc_size = _tmp90_;
			_stripImgSrc_index = -1;
			while (TRUE) {
				gint _tmp91_;
				gint _tmp92_;
				gchar* stripImgSrc = NULL;
				GeeList* _tmp93_;
				gpointer _tmp94_;
				const gchar* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				_stripImgSrc_index = _stripImgSrc_index + 1;
				_tmp91_ = _stripImgSrc_index;
				_tmp92_ = _stripImgSrc_size;
				if (!(_tmp91_ < _tmp92_)) {
					break;
				}
				_tmp93_ = _stripImgSrc_list;
				_tmp94_ = gee_list_get (_tmp93_, _stripImgSrc_index);
				stripImgSrc = (gchar*) _tmp94_;
				_tmp95_ = stripImgSrc;
				_tmp96_ = g_strconcat (TAB, _tmp95_, NULL);
				_tmp97_ = _tmp96_;
				feed_reader_logger_debug (_tmp97_);
				_g_free0 (_tmp97_);
				_g_free0 (stripImgSrc);
			}
		}
	}
	if (self->priv->m_tidy) {
		feed_reader_logger_debug ("tidy: yes");
	} else {
		feed_reader_logger_debug ("tidy: no");
	}
	if (self->priv->m_prune) {
		feed_reader_logger_debug ("prune: yes");
	} else {
		feed_reader_logger_debug ("prune: no");
	}
	if (self->priv->m_autodetectOnFailure) {
		feed_reader_logger_debug ("autodetectOnFailure: yes");
	} else {
		feed_reader_logger_debug ("autodetectOnFailure: no");
	}
	_tmp98_ = self->priv->m_singlePageLink;
	if (_tmp98_ != NULL) {
		const gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		_tmp99_ = self->priv->m_singlePageLink;
		_tmp100_ = g_strconcat ("singlePageLink: ", _tmp99_, NULL);
		_tmp101_ = _tmp100_;
		feed_reader_logger_debug (_tmp101_);
		_g_free0 (_tmp101_);
	}
	_tmp102_ = self->priv->m_nextPageLink;
	if (_tmp102_ != NULL) {
		const gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		_tmp103_ = self->priv->m_nextPageLink;
		_tmp104_ = g_strconcat ("nextPageLink: ", _tmp103_, NULL);
		_tmp105_ = _tmp104_;
		feed_reader_logger_debug (_tmp105_);
		_g_free0 (_tmp105_);
	}
	_tmp106_ = self->priv->m_replace;
	_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
	_tmp108_ = _tmp107_;
	if (_tmp108_ != 0) {
		feed_reader_logger_debug ("replace:");
		{
			GeeList* _tmp_list = NULL;
			GeeList* _tmp109_;
			gint _tmp_size = 0;
			GeeList* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gint _tmp_index = 0;
			_tmp109_ = self->priv->m_replace;
			_tmp_list = _tmp109_;
			_tmp110_ = _tmp_list;
			_tmp111_ = gee_collection_get_size ((GeeCollection*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp_size = _tmp112_;
			_tmp_index = -1;
			while (TRUE) {
				gint _tmp113_;
				gint _tmp114_;
				FeedReaderStringPair* tmp = NULL;
				GeeList* _tmp115_;
				gpointer _tmp116_;
				FeedReaderStringPair* _tmp117_;
				gchar* _tmp118_;
				gchar* _tmp119_;
				FeedReaderStringPair* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				_tmp_index = _tmp_index + 1;
				_tmp113_ = _tmp_index;
				_tmp114_ = _tmp_size;
				if (!(_tmp113_ < _tmp114_)) {
					break;
				}
				_tmp115_ = _tmp_list;
				_tmp116_ = gee_list_get (_tmp115_, _tmp_index);
				tmp = (FeedReaderStringPair*) _tmp116_;
				_tmp117_ = tmp;
				_tmp118_ = feed_reader_string_pair_getString1 (_tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = tmp;
				_tmp121_ = feed_reader_string_pair_getString2 (_tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = g_strdup_printf ("replace %s with %s", _tmp119_, _tmp122_);
				_tmp124_ = _tmp123_;
				feed_reader_logger_debug (_tmp124_);
				_g_free0 (_tmp124_);
				_g_free0 (_tmp122_);
				_g_free0 (_tmp119_);
				_g_object_unref0 (tmp);
			}
		}
	}
	_tmp125_ = self->priv->m_testURL;
	if (_tmp125_ != NULL) {
		const gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		_tmp126_ = self->priv->m_testURL;
		_tmp127_ = g_strconcat ("testURL: ", _tmp126_, NULL);
		_tmp128_ = _tmp127_;
		feed_reader_logger_debug (_tmp128_);
		_g_free0 (_tmp128_);
	}
}

gchar*
feed_reader_grabber_config_getXPathNextPageURL (FeedReaderGrabberConfig* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_nextPageLink;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_grabber_config_getXPathSinglePageURL (FeedReaderGrabberConfig* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_singlePageLink;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathTitle (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_title;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathAuthor (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_author;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathDate (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_date;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathStrip (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_strip;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathStripIDorClass (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_stripIDorClass;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathStripImgSrc (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_stripImgSrc;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getXPathBody (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xpath_body;
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_grabber_config_getReplace (FeedReaderGrabberConfig* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_replace;
	result = _tmp0_;
	return result;
}

static void
feed_reader_grabber_config_class_init (FeedReaderGrabberConfigClass * klass,
                                       gpointer klass_data)
{
	feed_reader_grabber_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderGrabberConfig_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_grabber_config_finalize;
}

static void
feed_reader_grabber_config_instance_init (FeedReaderGrabberConfig * self,
                                          gpointer klass)
{
	self->priv = feed_reader_grabber_config_get_instance_private (self);
}

static void
feed_reader_grabber_config_finalize (GObject * obj)
{
	FeedReaderGrabberConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_GRABBER_CONFIG, FeedReaderGrabberConfig);
	_g_object_unref0 (self->priv->m_xpath_title);
	_g_object_unref0 (self->priv->m_xpath_author);
	_g_object_unref0 (self->priv->m_xpath_date);
	_g_object_unref0 (self->priv->m_xpath_body);
	_g_object_unref0 (self->priv->m_xpath_strip);
	_g_object_unref0 (self->priv->m_xpath_stripIDorClass);
	_g_object_unref0 (self->priv->m_xpath_stripImgSrc);
	_g_free0 (self->priv->m_singlePageLink);
	_g_free0 (self->priv->m_nextPageLink);
	_g_object_unref0 (self->priv->m_replace);
	_g_free0 (self->priv->m_testURL);
	G_OBJECT_CLASS (feed_reader_grabber_config_parent_class)->finalize (obj);
}

static GType
feed_reader_grabber_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderGrabberConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_grabber_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderGrabberConfig), 0, (GInstanceInitFunc) feed_reader_grabber_config_instance_init, NULL };
	GType feed_reader_grabber_config_type_id;
	feed_reader_grabber_config_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderGrabberConfig", &g_define_type_info, 0);
	FeedReaderGrabberConfig_private_offset = g_type_add_instance_private (feed_reader_grabber_config_type_id, sizeof (FeedReaderGrabberConfigPrivate));
	return feed_reader_grabber_config_type_id;
}

GType
feed_reader_grabber_config_get_type (void)
{
	static volatile gsize feed_reader_grabber_config_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_grabber_config_type_id__once)) {
		GType feed_reader_grabber_config_type_id;
		feed_reader_grabber_config_type_id = feed_reader_grabber_config_get_type_once ();
		g_once_init_leave (&feed_reader_grabber_config_type_id__once, feed_reader_grabber_config_type_id);
	}
	return feed_reader_grabber_config_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

