/* grabberUtils.c generated by valac 0.56.3, the Vala compiler
 * generated from grabberUtils.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <glib-object.h>
#include <libxml/HTMLtree.h>
#include <libxml/HTMLparser.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

enum  {
	FEED_READER_GRABBER_UTILS_0_PROPERTY,
	FEED_READER_GRABBER_UTILS_NUM_PROPERTIES
};
static GParamSpec* feed_reader_grabber_utils_properties[FEED_READER_GRABBER_UTILS_NUM_PROPERTIES];
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _xmlXPathFreeObject0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeObject (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkPixbufFormat_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkPixbufFormat_free (var), NULL)))

static gpointer feed_reader_grabber_utils_parent_class = NULL;

static gchar* feed_reader_grabber_utils_checkParent (SoupSession* session,
                                              xmlNode* node);
static gint feed_reader_grabber_utils_compareImageSize (const gchar* file1,
                                                 const gchar* file2);
static gchar* feed_reader_grabber_utils_resizeImg (const gchar* path);
static void _g_free0_ (gpointer var);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static gint* _int_dup (gint* self);
static GdkPixbufFormat* _vala_GdkPixbufFormat_copy (GdkPixbufFormat* self);
static void _vala_GdkPixbufFormat_free (GdkPixbufFormat* self);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static GType feed_reader_grabber_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

FeedReadergrabberUtils*
feed_reader_grabber_utils_construct (GType object_type)
{
	FeedReadergrabberUtils * self = NULL;
	self = (FeedReadergrabberUtils*) g_object_new (object_type, NULL);
	return self;
}

FeedReadergrabberUtils*
feed_reader_grabber_utils_new (void)
{
	return feed_reader_grabber_utils_construct (FEED_READER_TYPE_GRABBER_UTILS);
}

gboolean
feed_reader_grabber_utils_extractBody (xmlDoc* doc,
                                       const gchar* xpath,
                                       xmlNode* destination)
{
	gboolean foundSomething = FALSE;
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp1_;
	xmlXPathObject* _tmp2_;
	xmlXPathObject* _tmp3_;
	xmlXPathObject* _tmp20_;
	gboolean result;
	g_return_val_if_fail (xpath != NULL, FALSE);
	foundSomething = FALSE;
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = cntx;
	_tmp2_ = xmlXPathEvalExpression ((xmlChar*) xpath, _tmp1_);
	res = _tmp2_;
	_tmp3_ = res;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		xmlXPathObject* _tmp5_;
		_tmp5_ = res;
		if (_tmp5_->type != XPATH_NODESET) {
			_tmp4_ = TRUE;
		} else {
			xmlXPathObject* _tmp6_;
			xmlNodeSet* _tmp7_;
			_tmp6_ = res;
			_tmp7_ = _tmp6_->nodesetval;
			_tmp4_ = _tmp7_ == NULL;
		}
		if (_tmp4_) {
			xmlXPathObject* _tmp8_;
			_tmp8_ = res;
			_xmlXPathFreeObject0 (_tmp8_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp11_;
				xmlNodeSet* _tmp12_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp13_;
				xmlNodeSet* _tmp14_;
				xmlNode* _tmp15_;
				xmlNode* _tmp16_;
				xmlAttr* _tmp17_;
				xmlNode* _tmp18_;
				xmlNode* _tmp19_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = res;
				_tmp12_ = _tmp11_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp12_))) {
					break;
				}
				_tmp13_ = res;
				_tmp14_ = _tmp13_->nodesetval;
				_tmp15_ = xmlXPathNodeSetItem (_tmp14_, i);
				node = _tmp15_;
				_tmp16_ = node;
				_tmp17_ = xmlHasProp (_tmp16_, (xmlChar*) "style");
				xmlRemoveProp (_tmp17_);
				_tmp18_ = node;
				xmlUnlinkNode (_tmp18_);
				_tmp19_ = node;
				xmlAddChild (destination, _tmp19_);
				if (!foundSomething) {
					foundSomething = TRUE;
				}
			}
		}
	}
	_tmp20_ = res;
	_xmlXPathFreeObject0 (_tmp20_);
	result = foundSomething;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gchar*
feed_reader_grabber_utils_getURL (xmlDoc* doc,
                                  const gchar* xpath)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp1_;
	xmlXPathObject* _tmp2_;
	xmlXPathObject* _tmp3_;
	xmlNode* node = NULL;
	xmlXPathObject* _tmp9_;
	xmlNodeSet* _tmp10_;
	xmlNode* _tmp11_;
	gchar* URL = NULL;
	xmlNode* _tmp12_;
	gchar* _tmp13_;
	xmlNode* _tmp14_;
	xmlNode* _tmp15_;
	xmlXPathObject* _tmp16_;
	gchar* result;
	g_return_val_if_fail (xpath != NULL, NULL);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = cntx;
	_tmp2_ = xmlXPathEvalExpression ((xmlChar*) xpath, _tmp1_);
	res = _tmp2_;
	_tmp3_ = res;
	if (_tmp3_ == NULL) {
		result = NULL;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		xmlXPathObject* _tmp5_;
		_tmp5_ = res;
		if (_tmp5_->type != XPATH_NODESET) {
			_tmp4_ = TRUE;
		} else {
			xmlXPathObject* _tmp6_;
			xmlNodeSet* _tmp7_;
			_tmp6_ = res;
			_tmp7_ = _tmp6_->nodesetval;
			_tmp4_ = _tmp7_ == NULL;
		}
		if (_tmp4_) {
			xmlXPathObject* _tmp8_;
			_tmp8_ = res;
			_xmlXPathFreeObject0 (_tmp8_);
			result = NULL;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	_tmp9_ = res;
	_tmp10_ = _tmp9_->nodesetval;
	_tmp11_ = xmlXPathNodeSetItem (_tmp10_, 0);
	node = _tmp11_;
	_tmp12_ = node;
	_tmp13_ = (gchar*) xmlGetProp (_tmp12_, (xmlChar*) "href");
	URL = _tmp13_;
	_tmp14_ = node;
	xmlUnlinkNode (_tmp14_);
	_tmp15_ = node;
	xmlFreeNodeList (_tmp15_);
	_tmp16_ = res;
	_xmlXPathFreeObject0 (_tmp16_);
	result = URL;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gchar*
feed_reader_grabber_utils_getValue (xmlDoc* doc,
                                    const gchar* xpath,
                                    gboolean remove)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp1_;
	xmlXPathObject* _tmp2_;
	xmlXPathObject* _tmp3_;
	xmlNode* node = NULL;
	xmlXPathObject* _tmp9_;
	xmlNodeSet* _tmp10_;
	xmlNode* _tmp11_;
	gchar* _result_ = NULL;
	xmlNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	xmlXPathObject* _tmp19_;
	gchar* result;
	g_return_val_if_fail (xpath != NULL, NULL);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = cntx;
	_tmp2_ = xmlXPathEvalExpression ((xmlChar*) xpath, _tmp1_);
	res = _tmp2_;
	_tmp3_ = res;
	if (_tmp3_ == NULL) {
		result = NULL;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		xmlXPathObject* _tmp5_;
		_tmp5_ = res;
		if (_tmp5_->type != XPATH_NODESET) {
			_tmp4_ = TRUE;
		} else {
			xmlXPathObject* _tmp6_;
			xmlNodeSet* _tmp7_;
			_tmp6_ = res;
			_tmp7_ = _tmp6_->nodesetval;
			_tmp4_ = _tmp7_ == NULL;
		}
		if (_tmp4_) {
			xmlXPathObject* _tmp8_;
			_tmp8_ = res;
			_xmlXPathFreeObject0 (_tmp8_);
			result = NULL;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	_tmp9_ = res;
	_tmp10_ = _tmp9_->nodesetval;
	_tmp11_ = xmlXPathNodeSetItem (_tmp10_, 0);
	node = _tmp11_;
	_tmp12_ = node;
	_tmp13_ = (gchar*) xmlNodeGetContent (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = feed_reader_grabber_utils_cleanString (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_result_ = _tmp16_;
	if (remove) {
		xmlNode* _tmp17_;
		xmlNode* _tmp18_;
		_tmp17_ = node;
		xmlUnlinkNode (_tmp17_);
		_tmp18_ = node;
		xmlFreeNodeList (_tmp18_);
	}
	_tmp19_ = res;
	_xmlXPathFreeObject0 (_tmp19_);
	result = _result_;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gboolean
feed_reader_grabber_utils_repairURL (const gchar* xpath,
                                     const gchar* attr,
                                     xmlDoc* doc,
                                     const gchar* articleURL)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp2_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp3_;
	xmlXPathObject* _tmp4_;
	xmlXPathObject* _tmp5_;
	xmlXPathObject* _tmp28_;
	gboolean result;
	g_return_val_if_fail (xpath != NULL, FALSE);
	g_return_val_if_fail (attr != NULL, FALSE);
	g_return_val_if_fail (articleURL != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("GrabberUtils: repairURL xpath:\"%s\" attr:\"%s\"", xpath, attr);
	_tmp1_ = _tmp0_;
	feed_reader_logger_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = xmlXPathNewContext (doc);
	cntx = _tmp2_;
	_tmp3_ = cntx;
	_tmp4_ = xmlXPathEvalExpression ((xmlChar*) xpath, _tmp3_);
	res = _tmp4_;
	_tmp5_ = res;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		xmlXPathObject* _tmp7_;
		_tmp7_ = res;
		if (_tmp7_->type != XPATH_NODESET) {
			_tmp6_ = TRUE;
		} else {
			xmlXPathObject* _tmp8_;
			xmlNodeSet* _tmp9_;
			_tmp8_ = res;
			_tmp9_ = _tmp8_->nodesetval;
			_tmp6_ = _tmp9_ == NULL;
		}
		if (_tmp6_) {
			xmlXPathObject* _tmp10_;
			_tmp10_ = res;
			_xmlXPathFreeObject0 (_tmp10_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp13_;
				xmlNodeSet* _tmp14_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp15_;
				xmlNodeSet* _tmp16_;
				xmlNode* _tmp17_;
				xmlNode* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = res;
				_tmp14_ = _tmp13_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp14_))) {
					break;
				}
				_tmp15_ = res;
				_tmp16_ = _tmp15_->nodesetval;
				_tmp17_ = xmlXPathNodeSetItem (_tmp16_, i);
				node = _tmp17_;
				_tmp18_ = node;
				_tmp19_ = (gchar*) xmlGetProp (_tmp18_, (xmlChar*) attr);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_ != NULL;
				_g_free0 (_tmp20_);
				if (_tmp21_) {
					xmlNode* _tmp22_;
					xmlNode* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp22_ = node;
					_tmp23_ = node;
					_tmp24_ = (gchar*) xmlGetProp (_tmp23_, (xmlChar*) attr);
					_tmp25_ = _tmp24_;
					_tmp26_ = feed_reader_grabber_utils_completeURL (_tmp25_, articleURL);
					_tmp27_ = _tmp26_;
					xmlSetProp (_tmp22_, (xmlChar*) attr, (xmlChar*) _tmp27_);
					_g_free0 (_tmp27_);
					_g_free0 (_tmp25_);
				}
			}
		}
	}
	_tmp28_ = res;
	_xmlXPathFreeObject0 (_tmp28_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gboolean
feed_reader_grabber_utils_fixLazyImg (xmlDoc* doc,
                                      const gchar* className,
                                      const gchar* correctURL)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	xmlXPathObject* _tmp4_;
	xmlXPathObject* _tmp5_;
	xmlXPathObject* _tmp6_;
	xmlXPathObject* _tmp23_;
	gboolean result;
	g_return_val_if_fail (className != NULL, FALSE);
	g_return_val_if_fail (correctURL != NULL, FALSE);
	feed_reader_logger_debug ("grabberUtils: fixLazyImg");
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = cntx;
	_tmp2_ = g_strdup_printf ("//img[contains(@class, '%s')]", className);
	_tmp3_ = _tmp2_;
	_tmp4_ = xmlXPathEvalExpression ((xmlChar*) _tmp3_, _tmp1_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	res = _tmp5_;
	_tmp6_ = res;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp7_ = FALSE;
		xmlXPathObject* _tmp8_;
		_tmp8_ = res;
		if (_tmp8_->type != XPATH_NODESET) {
			_tmp7_ = TRUE;
		} else {
			xmlXPathObject* _tmp9_;
			xmlNodeSet* _tmp10_;
			_tmp9_ = res;
			_tmp10_ = _tmp9_->nodesetval;
			_tmp7_ = _tmp10_ == NULL;
		}
		if (_tmp7_) {
			xmlXPathObject* _tmp11_;
			_tmp11_ = res;
			_xmlXPathFreeObject0 (_tmp11_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp14_;
				xmlNodeSet* _tmp15_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp16_;
				xmlNodeSet* _tmp17_;
				xmlNode* _tmp18_;
				xmlNode* _tmp19_;
				xmlNode* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = res;
				_tmp15_ = _tmp14_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp15_))) {
					break;
				}
				_tmp16_ = res;
				_tmp17_ = _tmp16_->nodesetval;
				_tmp18_ = xmlXPathNodeSetItem (_tmp17_, i);
				node = _tmp18_;
				_tmp19_ = node;
				_tmp20_ = node;
				_tmp21_ = (gchar*) xmlGetProp (_tmp20_, (xmlChar*) correctURL);
				_tmp22_ = _tmp21_;
				xmlSetProp (_tmp19_, (xmlChar*) "src", (xmlChar*) _tmp22_);
				_g_free0 (_tmp22_);
			}
		}
	}
	_tmp23_ = res;
	_xmlXPathFreeObject0 (_tmp23_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
feed_reader_grabber_utils_fixIframeSize (xmlDoc* doc,
                                         const gchar* siteName)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	xmlXPathObject* _tmp5_;
	xmlXPathObject* _tmp6_;
	xmlXPathObject* _tmp7_;
	xmlXPathObject* _tmp31_;
	gboolean result;
	g_return_val_if_fail (siteName != NULL, FALSE);
	feed_reader_logger_debug ("grabberUtils: fixIframeSize");
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = cntx;
	_tmp2_ = string_to_string (siteName);
	_tmp3_ = g_strconcat ("//iframe[contains(@src, '", _tmp2_, "')]", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = xmlXPathEvalExpression ((xmlChar*) _tmp4_, _tmp1_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	res = _tmp6_;
	_tmp7_ = res;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp8_ = FALSE;
		xmlXPathObject* _tmp9_;
		_tmp9_ = res;
		if (_tmp9_->type != XPATH_NODESET) {
			_tmp8_ = TRUE;
		} else {
			xmlXPathObject* _tmp10_;
			xmlNodeSet* _tmp11_;
			_tmp10_ = res;
			_tmp11_ = _tmp10_->nodesetval;
			_tmp8_ = _tmp11_ == NULL;
		}
		if (_tmp8_) {
			xmlXPathObject* _tmp12_;
			_tmp12_ = res;
			_xmlXPathFreeObject0 (_tmp12_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp15_;
				xmlNodeSet* _tmp16_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp17_;
				xmlNodeSet* _tmp18_;
				xmlNode* _tmp19_;
				xmlNode* videoWrapper = NULL;
				xmlNode* _tmp20_;
				xmlNode* parent = NULL;
				xmlNode* _tmp21_;
				xmlNode* _tmp22_;
				xmlNode* _tmp23_;
				xmlNode* _tmp24_;
				xmlNode* _tmp25_;
				xmlNode* _tmp26_;
				xmlNode* _tmp27_;
				xmlNode* _tmp28_;
				xmlNode* _tmp29_;
				xmlNode* _tmp30_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = res;
				_tmp16_ = _tmp15_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp16_))) {
					break;
				}
				_tmp17_ = res;
				_tmp18_ = _tmp17_->nodesetval;
				_tmp19_ = xmlXPathNodeSetItem (_tmp18_, i);
				node = _tmp19_;
				_tmp20_ = xmlNewNode (NULL, (xmlChar*) "div");
				videoWrapper = _tmp20_;
				_tmp21_ = node;
				_tmp22_ = _tmp21_->parent;
				parent = _tmp22_;
				_tmp23_ = videoWrapper;
				xmlSetProp (_tmp23_, (xmlChar*) "class", (xmlChar*) "videoWrapper");
				_tmp24_ = node;
				xmlSetProp (_tmp24_, (xmlChar*) "width", (xmlChar*) "100%");
				_tmp25_ = node;
				xmlUnsetProp (_tmp25_, (xmlChar*) "height");
				_tmp26_ = node;
				xmlUnlinkNode (_tmp26_);
				_tmp27_ = videoWrapper;
				_tmp28_ = node;
				xmlAddChild (_tmp27_, _tmp28_);
				_tmp29_ = parent;
				_tmp30_ = videoWrapper;
				xmlAddChild (_tmp29_, _tmp30_);
			}
		}
	}
	_tmp31_ = res;
	_xmlXPathFreeObject0 (_tmp31_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
feed_reader_grabber_utils_stripNode (xmlDoc* doc,
                                     const gchar* xpath)
{
	gchar* ancestor = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* query = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp6_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp7_;
	const gchar* _tmp8_;
	xmlXPathObject* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	xmlXPathObject* _tmp12_;
	xmlXPathObject* _tmp26_;
	g_return_if_fail (xpath != NULL);
	_tmp0_ = g_strdup (xpath);
	ancestor = _tmp0_;
	_tmp1_ = ancestor;
	if (g_str_has_prefix (_tmp1_, "//")) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = ancestor;
		_tmp3_ = string_substring (_tmp2_, (glong) 2, (glong) -1);
		_g_free0 (ancestor);
		ancestor = _tmp3_;
	}
	_tmp4_ = ancestor;
	_tmp5_ = g_strdup_printf ("%s[not(ancestor::%s)]", xpath, _tmp4_);
	query = _tmp5_;
	_tmp6_ = xmlXPathNewContext (doc);
	cntx = _tmp6_;
	_tmp7_ = cntx;
	_tmp8_ = query;
	_tmp9_ = xmlXPathEvalExpression ((xmlChar*) _tmp8_, _tmp7_);
	res = _tmp9_;
	_tmp12_ = res;
	if (_tmp12_ != NULL) {
		xmlXPathObject* _tmp13_;
		_tmp13_ = res;
		_tmp11_ = _tmp13_->type == XPATH_NODESET;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		xmlXPathObject* _tmp14_;
		xmlNodeSet* _tmp15_;
		_tmp14_ = res;
		_tmp15_ = _tmp14_->nodesetval;
		_tmp10_ = _tmp15_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					xmlXPathObject* _tmp18_;
					xmlNodeSet* _tmp19_;
					xmlNode* node = NULL;
					xmlXPathObject* _tmp20_;
					xmlNodeSet* _tmp21_;
					xmlNode* _tmp22_;
					xmlNode* _tmp23_;
					xmlNode* _tmp24_;
					xmlNode* _tmp25_;
					if (!_tmp16_) {
						gint _tmp17_;
						i = i + 1;
						_tmp17_ = i;
					}
					_tmp16_ = FALSE;
					_tmp18_ = res;
					_tmp19_ = _tmp18_->nodesetval;
					if (!(i < xmlXPathNodeSetGetLength (_tmp19_))) {
						break;
					}
					_tmp20_ = res;
					_tmp21_ = _tmp20_->nodesetval;
					_tmp22_ = xmlXPathNodeSetItem (_tmp21_, i);
					node = _tmp22_;
					_tmp23_ = node;
					if (_tmp23_ == NULL) {
						continue;
					}
					_tmp24_ = node;
					xmlUnlinkNode (_tmp24_);
					_tmp25_ = node;
					xmlFreeNodeList (_tmp25_);
				}
			}
		}
	}
	_tmp26_ = res;
	_xmlXPathFreeObject0 (_tmp26_);
	_xmlXPathFreeContext0 (cntx);
	_g_free0 (query);
	_g_free0 (ancestor);
}

void
feed_reader_grabber_utils_onlyRemoveNode (xmlDoc* doc,
                                          const gchar* xpath)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	gboolean changed = FALSE;
	g_return_if_fail (xpath != NULL);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	changed = FALSE;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			xmlXPathObject* res = NULL;
			xmlXPathContext* _tmp2_;
			xmlXPathObject* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			xmlXPathObject* _tmp6_;
			xmlXPathObject* _tmp27_;
			if (!_tmp1_) {
				if (!changed) {
					break;
				}
			}
			_tmp1_ = FALSE;
			changed = FALSE;
			_tmp2_ = cntx;
			_tmp3_ = xmlXPathEvalExpression ((xmlChar*) xpath, _tmp2_);
			res = _tmp3_;
			_tmp6_ = res;
			if (_tmp6_ != NULL) {
				xmlXPathObject* _tmp7_;
				_tmp7_ = res;
				_tmp5_ = _tmp7_->type == XPATH_NODESET;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				xmlXPathObject* _tmp8_;
				xmlNodeSet* _tmp9_;
				_tmp8_ = res;
				_tmp9_ = _tmp8_->nodesetval;
				_tmp4_ = _tmp9_ != NULL;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							xmlXPathObject* _tmp12_;
							xmlNodeSet* _tmp13_;
							xmlNode* node = NULL;
							xmlXPathObject* _tmp14_;
							xmlNodeSet* _tmp15_;
							xmlNode* _tmp16_;
							xmlNode* _tmp17_;
							xmlNode* parent = NULL;
							xmlNode* _tmp18_;
							xmlNode* _tmp19_;
							xmlNode* children = NULL;
							xmlNode* _tmp20_;
							xmlNode* _tmp21_;
							xmlNode* _tmp22_;
							xmlNode* _tmp23_;
							xmlNode* _tmp24_;
							xmlNode* _tmp25_;
							xmlNode* _tmp26_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = i;
								i = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = res;
							_tmp13_ = _tmp12_->nodesetval;
							if (!(i < xmlXPathNodeSetGetLength (_tmp13_))) {
								break;
							}
							_tmp14_ = res;
							_tmp15_ = _tmp14_->nodesetval;
							_tmp16_ = xmlXPathNodeSetItem (_tmp15_, i);
							node = _tmp16_;
							_tmp17_ = node;
							if (_tmp17_ == NULL) {
								continue;
							}
							_tmp18_ = node;
							_tmp19_ = _tmp18_->parent;
							parent = _tmp19_;
							_tmp20_ = node;
							_tmp21_ = _tmp20_->children;
							children = _tmp21_;
							_tmp22_ = children;
							xmlUnlinkNode (_tmp22_);
							_tmp23_ = parent;
							_tmp24_ = children;
							xmlAddChild (_tmp23_, _tmp24_);
							_tmp25_ = node;
							xmlUnlinkNode (_tmp25_);
							_tmp26_ = node;
							xmlFreeNodeList (_tmp26_);
							changed = TRUE;
							break;
						}
					}
				}
			}
			_tmp27_ = res;
			_xmlXPathFreeObject0 (_tmp27_);
		}
	}
	_xmlXPathFreeContext0 (cntx);
}

gboolean
feed_reader_grabber_utils_setAttributes (xmlDoc* doc,
                                         const gchar* attribute,
                                         const gchar* newValue)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	xmlXPathObject* _tmp4_;
	xmlXPathObject* _tmp5_;
	xmlXPathObject* _tmp6_;
	xmlXPathObject* _tmp20_;
	gboolean result;
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (newValue != NULL, FALSE);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = cntx;
	_tmp2_ = g_strdup_printf ("//*[@%s]", attribute);
	_tmp3_ = _tmp2_;
	_tmp4_ = xmlXPathEvalExpression ((xmlChar*) _tmp3_, _tmp1_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	res = _tmp5_;
	_tmp6_ = res;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp7_ = FALSE;
		xmlXPathObject* _tmp8_;
		_tmp8_ = res;
		if (_tmp8_->type != XPATH_NODESET) {
			_tmp7_ = TRUE;
		} else {
			xmlXPathObject* _tmp9_;
			xmlNodeSet* _tmp10_;
			_tmp9_ = res;
			_tmp10_ = _tmp9_->nodesetval;
			_tmp7_ = _tmp10_ == NULL;
		}
		if (_tmp7_) {
			xmlXPathObject* _tmp11_;
			_tmp11_ = res;
			_xmlXPathFreeObject0 (_tmp11_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp14_;
				xmlNodeSet* _tmp15_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp16_;
				xmlNodeSet* _tmp17_;
				xmlNode* _tmp18_;
				xmlNode* _tmp19_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = res;
				_tmp15_ = _tmp14_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp15_))) {
					break;
				}
				_tmp16_ = res;
				_tmp17_ = _tmp16_->nodesetval;
				_tmp18_ = xmlXPathNodeSetItem (_tmp17_, i);
				node = _tmp18_;
				_tmp19_ = node;
				xmlSetProp (_tmp19_, (xmlChar*) attribute, (xmlChar*) newValue);
			}
		}
	}
	_tmp20_ = res;
	_xmlXPathFreeObject0 (_tmp20_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gboolean
feed_reader_grabber_utils_removeAttributes (xmlDoc* doc,
                                            const gchar* tag,
                                            const gchar* attribute)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathObject* _tmp9_;
	xmlXPathObject* _tmp23_;
	gboolean result;
	g_return_val_if_fail (attribute != NULL, FALSE);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	if (tag == NULL) {
		xmlXPathContext* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		xmlXPathObject* _tmp4_;
		_tmp1_ = cntx;
		_tmp2_ = g_strdup_printf ("//*[@%s]", attribute);
		_tmp3_ = _tmp2_;
		_tmp4_ = xmlXPathEvalExpression ((xmlChar*) _tmp3_, _tmp1_);
		res = _tmp4_;
		_g_free0 (_tmp3_);
	} else {
		xmlXPathContext* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		xmlXPathObject* _tmp8_;
		_tmp5_ = cntx;
		_tmp6_ = g_strdup_printf ("//%s[@%s]", tag, attribute);
		_tmp7_ = _tmp6_;
		_tmp8_ = xmlXPathEvalExpression ((xmlChar*) _tmp7_, _tmp5_);
		res = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_tmp9_ = res;
	if (_tmp9_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		xmlXPathObject* _tmp11_;
		_tmp11_ = res;
		if (_tmp11_->type != XPATH_NODESET) {
			_tmp10_ = TRUE;
		} else {
			xmlXPathObject* _tmp12_;
			xmlNodeSet* _tmp13_;
			_tmp12_ = res;
			_tmp13_ = _tmp12_->nodesetval;
			_tmp10_ = _tmp13_ == NULL;
		}
		if (_tmp10_) {
			xmlXPathObject* _tmp14_;
			_tmp14_ = res;
			_xmlXPathFreeObject0 (_tmp14_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp17_;
				xmlNodeSet* _tmp18_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp19_;
				xmlNodeSet* _tmp20_;
				xmlNode* _tmp21_;
				xmlNode* _tmp22_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = res;
				_tmp18_ = _tmp17_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp18_))) {
					break;
				}
				_tmp19_ = res;
				_tmp20_ = _tmp19_->nodesetval;
				_tmp21_ = xmlXPathNodeSetItem (_tmp20_, i);
				node = _tmp21_;
				_tmp22_ = node;
				xmlUnsetProp (_tmp22_, (xmlChar*) attribute);
			}
		}
	}
	_tmp23_ = res;
	_xmlXPathFreeObject0 (_tmp23_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gboolean
feed_reader_grabber_utils_addAttributes (xmlDoc* doc,
                                         const gchar* tag,
                                         const gchar* attribute,
                                         const gchar* val)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	xmlXPathObject* res = NULL;
	xmlXPathObject* _tmp17_;
	xmlXPathObject* _tmp31_;
	gboolean result;
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	if (tag == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		xmlXPathContext* _tmp5_;
		xmlXPathObject* _tmp6_;
		_tmp1_ = string_to_string (attribute);
		_tmp2_ = string_to_string (val);
		_tmp3_ = g_strconcat ("addAttributes: //* ", _tmp1_, " ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		feed_reader_logger_debug (_tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = cntx;
		_tmp6_ = xmlXPathEvalExpression ((xmlChar*) "//*", _tmp5_);
		res = _tmp6_;
	} else {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		xmlXPathContext* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		xmlXPathObject* _tmp16_;
		_tmp7_ = string_to_string (tag);
		_tmp8_ = string_to_string (attribute);
		_tmp9_ = string_to_string (val);
		_tmp10_ = g_strconcat ("addAttributes: //", _tmp7_, "  ", _tmp8_, " ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		feed_reader_logger_debug (_tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = cntx;
		_tmp13_ = string_to_string (tag);
		_tmp14_ = g_strconcat ("//", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = xmlXPathEvalExpression ((xmlChar*) _tmp15_, _tmp12_);
		res = _tmp16_;
		_g_free0 (_tmp15_);
	}
	_tmp17_ = res;
	if (_tmp17_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp18_ = FALSE;
		xmlXPathObject* _tmp19_;
		_tmp19_ = res;
		if (_tmp19_->type != XPATH_NODESET) {
			_tmp18_ = TRUE;
		} else {
			xmlXPathObject* _tmp20_;
			xmlNodeSet* _tmp21_;
			_tmp20_ = res;
			_tmp21_ = _tmp20_->nodesetval;
			_tmp18_ = _tmp21_ == NULL;
		}
		if (_tmp18_) {
			xmlXPathObject* _tmp22_;
			_tmp22_ = res;
			_xmlXPathFreeObject0 (_tmp22_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp25_;
				xmlNodeSet* _tmp26_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp27_;
				xmlNodeSet* _tmp28_;
				xmlNode* _tmp29_;
				xmlNode* _tmp30_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = res;
				_tmp26_ = _tmp25_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp26_))) {
					break;
				}
				_tmp27_ = res;
				_tmp28_ = _tmp27_->nodesetval;
				_tmp29_ = xmlXPathNodeSetItem (_tmp28_, i);
				node = _tmp29_;
				_tmp30_ = node;
				xmlSetProp (_tmp30_, (xmlChar*) attribute, (xmlChar*) val);
			}
		}
	}
	_tmp31_ = res;
	_xmlXPathFreeObject0 (_tmp31_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

void
feed_reader_grabber_utils_stripIDorClass (xmlDoc* doc,
                                          const gchar* IDorClass)
{
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp0_;
	gchar* xpath = NULL;
	gchar* _tmp1_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp2_;
	const gchar* _tmp3_;
	xmlXPathObject* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	xmlXPathObject* _tmp7_;
	xmlXPathObject* _tmp32_;
	g_return_if_fail (IDorClass != NULL);
	_tmp0_ = xmlXPathNewContext (doc);
	cntx = _tmp0_;
	_tmp1_ = g_strdup_printf ("//*[contains(@class, '%s') or contains(@id, '%s')]", IDorClass, IDorClass);
	xpath = _tmp1_;
	_tmp2_ = cntx;
	_tmp3_ = xpath;
	_tmp4_ = xmlXPathEvalExpression ((xmlChar*) _tmp3_, _tmp2_);
	res = _tmp4_;
	_tmp7_ = res;
	if (_tmp7_ != NULL) {
		xmlXPathObject* _tmp8_;
		_tmp8_ = res;
		_tmp6_ = _tmp8_->type == XPATH_NODESET;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		xmlXPathObject* _tmp9_;
		xmlNodeSet* _tmp10_;
		_tmp9_ = res;
		_tmp10_ = _tmp9_->nodesetval;
		_tmp5_ = _tmp10_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					xmlXPathObject* _tmp13_;
					xmlNodeSet* _tmp14_;
					xmlNode* node = NULL;
					xmlXPathObject* _tmp15_;
					xmlNodeSet* _tmp16_;
					xmlNode* _tmp17_;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					xmlNode* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gboolean _tmp23_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = res;
					_tmp14_ = _tmp13_->nodesetval;
					if (!(i < xmlXPathNodeSetGetLength (_tmp14_))) {
						break;
					}
					_tmp15_ = res;
					_tmp16_ = _tmp15_->nodesetval;
					_tmp17_ = xmlXPathNodeSetItem (_tmp16_, i);
					node = _tmp17_;
					_tmp20_ = node;
					_tmp21_ = (gchar*) xmlGetProp (_tmp20_, (xmlChar*) "class");
					_tmp22_ = _tmp21_;
					_tmp23_ = _tmp22_ != NULL;
					_g_free0 (_tmp22_);
					if (_tmp23_) {
						_tmp19_ = TRUE;
					} else {
						xmlNode* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						_tmp24_ = node;
						_tmp25_ = (gchar*) xmlGetProp (_tmp24_, (xmlChar*) "id");
						_tmp26_ = _tmp25_;
						_tmp19_ = _tmp26_ != NULL;
						_g_free0 (_tmp26_);
					}
					if (_tmp19_) {
						_tmp18_ = TRUE;
					} else {
						xmlNode* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp27_ = node;
						_tmp28_ = (gchar*) xmlGetProp (_tmp27_, (xmlChar*) "src");
						_tmp29_ = _tmp28_;
						_tmp18_ = _tmp29_ != NULL;
						_g_free0 (_tmp29_);
					}
					if (_tmp18_) {
						xmlNode* _tmp30_;
						xmlNode* _tmp31_;
						_tmp30_ = node;
						xmlUnlinkNode (_tmp30_);
						_tmp31_ = node;
						xmlFreeNodeList (_tmp31_);
					}
				}
			}
		}
	}
	_tmp32_ = res;
	_xmlXPathFreeObject0 (_tmp32_);
	_g_free0 (xpath);
	_xmlXPathFreeContext0 (cntx);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

gchar*
feed_reader_grabber_utils_cleanString (const gchar* text)
{
	gchar* tmpText = NULL;
	gchar* _tmp1_;
	gchar** array = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	if (text == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = string_replace (text, "\n", "");
	tmpText = _tmp1_;
	_tmp2_ = tmpText;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	array = _tmp4_;
	array_length1 = _vala_array_length (_tmp3_);
	_array_size_ = array_length1;
	_tmp5_ = g_strdup ("");
	_g_free0 (tmpText);
	tmpText = _tmp5_;
	_tmp6_ = array;
	_tmp6__length1 = array_length1;
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp6_;
		word_collection_length1 = _tmp6__length1;
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
			gchar* _tmp7_;
			gchar* word = NULL;
			_tmp7_ = g_strdup (word_collection[word_it]);
			word = _tmp7_;
			{
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp8_ = word;
				_tmp9_ = string_chug (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strcmp0 (_tmp10_, "") != 0;
				_g_free0 (_tmp10_);
				if (_tmp11_) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = tmpText;
					_tmp13_ = word;
					_tmp14_ = g_strconcat (_tmp13_, " ", NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
					_g_free0 (tmpText);
					tmpText = _tmp16_;
					_g_free0 (_tmp15_);
				}
				_g_free0 (word);
			}
		}
	}
	_tmp17_ = tmpText;
	_tmp18_ = string_chomp (_tmp17_);
	result = _tmp18_;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (tmpText);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
feed_reader_grabber_utils_completeURL (const gchar* incompleteURL,
                                       const gchar* articleURL)
{
	gint index = 0;
	gchar* baseURL = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (incompleteURL != NULL, NULL);
	g_return_val_if_fail (articleURL != NULL, NULL);
	index = 0;
	if (g_str_has_prefix (articleURL, "http")) {
		index = 8;
	} else {
		index = string_index_of_char (articleURL, (gunichar) '.', 0);
	}
	_tmp0_ = g_strdup ("");
	baseURL = _tmp0_;
	if (g_str_has_prefix (incompleteURL, "/")) {
		_tmp1_ = !g_str_has_prefix (incompleteURL, "//");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		index = string_index_of_char (articleURL, (gunichar) '/', index);
		_tmp2_ = string_substring (articleURL, (glong) 0, (glong) index);
		_g_free0 (baseURL);
		baseURL = _tmp2_;
		_tmp3_ = baseURL;
		if (g_str_has_suffix (_tmp3_, "/")) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = baseURL;
			_tmp5_ = baseURL;
			_tmp6_ = string_substring (_tmp4_, (glong) 0, (glong) (g_utf8_strlen (_tmp5_, (gssize) -1) - 1));
			_g_free0 (baseURL);
			baseURL = _tmp6_;
		}
		_tmp7_ = baseURL;
		_tmp8_ = g_strconcat (_tmp7_, incompleteURL, NULL);
		result = _tmp8_;
		_g_free0 (baseURL);
		return result;
	} else {
		if (g_str_has_prefix (incompleteURL, "?")) {
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			index = string_index_of_char (articleURL, (gunichar) '?', index);
			_tmp9_ = string_substring (articleURL, (glong) 0, (glong) index);
			_g_free0 (baseURL);
			baseURL = _tmp9_;
			_tmp10_ = baseURL;
			_tmp11_ = g_strconcat (_tmp10_, incompleteURL, NULL);
			result = _tmp11_;
			_g_free0 (baseURL);
			return result;
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_prefix (incompleteURL, "http")) {
				_tmp13_ = !g_str_has_prefix (incompleteURL, "www");
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				_tmp12_ = !g_str_has_prefix (incompleteURL, "//");
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				index = string_index_of_char (articleURL, (gunichar) '/', index);
				_tmp14_ = string_substring (articleURL, (glong) 0, (glong) index);
				_g_free0 (baseURL);
				baseURL = _tmp14_;
				_tmp15_ = baseURL;
				if (!g_str_has_suffix (_tmp15_, "/")) {
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp16_ = baseURL;
					_tmp17_ = g_strconcat (_tmp16_, "/", NULL);
					_g_free0 (baseURL);
					baseURL = _tmp17_;
				}
				_tmp18_ = baseURL;
				_tmp19_ = g_strconcat (_tmp18_, incompleteURL, NULL);
				result = _tmp19_;
				_g_free0 (baseURL);
				return result;
			} else {
				if (g_str_has_prefix (incompleteURL, "//")) {
					gchar* _tmp20_;
					_tmp20_ = g_strconcat ("http:", incompleteURL, NULL);
					result = _tmp20_;
					_g_free0 (baseURL);
					return result;
				}
			}
		}
	}
	_tmp21_ = g_strdup (incompleteURL);
	result = _tmp21_;
	_g_free0 (baseURL);
	return result;
}

gchar*
feed_reader_grabber_utils_buildHostName (const gchar* URL,
                                         gboolean cutSubdomain)
{
	gchar* hostname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	gint index = 0;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (URL != NULL, NULL);
	_tmp0_ = g_strdup (URL);
	hostname = _tmp0_;
	_tmp1_ = hostname;
	if (g_str_has_prefix (_tmp1_, "http://")) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = hostname;
		_tmp3_ = string_substring (_tmp2_, (glong) 7, (glong) -1);
		_g_free0 (hostname);
		hostname = _tmp3_;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = hostname;
		if (g_str_has_prefix (_tmp4_, "https://")) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = hostname;
			_tmp6_ = string_substring (_tmp5_, (glong) 8, (glong) -1);
			_g_free0 (hostname);
			hostname = _tmp6_;
		}
	}
	_tmp7_ = hostname;
	if (g_str_has_prefix (_tmp7_, "www.")) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = hostname;
		_tmp9_ = string_substring (_tmp8_, (glong) 4, (glong) -1);
		_g_free0 (hostname);
		hostname = _tmp9_;
	}
	_tmp10_ = hostname;
	index = string_index_of_char (_tmp10_, (gunichar) '/', 0);
	_tmp11_ = hostname;
	_tmp12_ = string_substring (_tmp11_, (glong) 0, (glong) index);
	_g_free0 (hostname);
	hostname = _tmp12_;
	if (cutSubdomain) {
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = hostname;
		index = string_index_of_char (_tmp13_, (gunichar) '.', 0);
		if (index != -1) {
			const gchar* _tmp15_;
			_tmp15_ = hostname;
			_tmp14_ = string_index_of_char (_tmp15_, (gunichar) '.', index + 1) != -1;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = hostname;
			_tmp17_ = string_substring (_tmp16_, (glong) index, (glong) -1);
			_g_free0 (hostname);
			hostname = _tmp17_;
		}
	}
	result = hostname;
	return result;
}

gboolean
feed_reader_grabber_utils_saveImages (SoupSession* session,
                                      xmlDoc* doc,
                                      FeedReaderArticle* article,
                                      GCancellable* cancellable)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	xmlXPathContext* cntx = NULL;
	xmlXPathContext* _tmp6_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp7_;
	xmlXPathObject* _tmp8_;
	xmlXPathObject* _tmp9_;
	xmlXPathObject* _tmp81_;
	gboolean result;
	g_return_val_if_fail (session != NULL, FALSE);
	g_return_val_if_fail (article != NULL, FALSE);
	_tmp0_ = feed_reader_article_getArticleID (article);
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_article_getFeedID (article);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("GrabberUtils: save Images: %s, %s", _tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_logger_debug (_tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = xmlXPathNewContext (doc);
	cntx = _tmp6_;
	_tmp7_ = cntx;
	_tmp8_ = xmlXPathEvalExpression ((xmlChar*) "//img", _tmp7_);
	res = _tmp8_;
	_tmp9_ = res;
	if (_tmp9_ == NULL) {
		result = FALSE;
		_xmlXPathFreeContext0 (cntx);
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		xmlXPathObject* _tmp11_;
		_tmp11_ = res;
		if (_tmp11_->type != XPATH_NODESET) {
			_tmp10_ = TRUE;
		} else {
			xmlXPathObject* _tmp12_;
			xmlNodeSet* _tmp13_;
			_tmp12_ = res;
			_tmp13_ = _tmp12_->nodesetval;
			_tmp10_ = _tmp13_ == NULL;
		}
		if (_tmp10_) {
			xmlXPathObject* _tmp14_;
			_tmp14_ = res;
			_xmlXPathFreeObject0 (_tmp14_);
			result = FALSE;
			_xmlXPathFreeContext0 (cntx);
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp17_;
				xmlNodeSet* _tmp18_;
				gboolean _tmp19_ = FALSE;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp20_;
				xmlNodeSet* _tmp21_;
				xmlNode* _tmp22_;
				xmlNode* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gboolean _tmp26_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = res;
				_tmp18_ = _tmp17_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp18_))) {
					break;
				}
				if (cancellable != NULL) {
					_tmp19_ = g_cancellable_is_cancelled (cancellable);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					break;
				}
				_tmp20_ = res;
				_tmp21_ = _tmp20_->nodesetval;
				_tmp22_ = xmlXPathNodeSetItem (_tmp21_, i);
				node = _tmp22_;
				_tmp23_ = node;
				_tmp24_ = (gchar*) xmlGetProp (_tmp23_, (xmlChar*) "src");
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_ != NULL;
				_g_free0 (_tmp25_);
				if (_tmp26_) {
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_ = FALSE;
					xmlNode* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gboolean _tmp33_;
					_tmp30_ = node;
					_tmp31_ = (gchar*) xmlGetProp (_tmp30_, (xmlChar*) "width");
					_tmp32_ = _tmp31_;
					_tmp33_ = _tmp32_ != NULL;
					_g_free0 (_tmp32_);
					if (_tmp33_) {
						xmlNode* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						_tmp34_ = node;
						_tmp35_ = (gchar*) xmlGetProp (_tmp34_, (xmlChar*) "width");
						_tmp36_ = _tmp35_;
						_tmp29_ = atoi (_tmp36_) > 1;
						_g_free0 (_tmp36_);
					} else {
						_tmp29_ = FALSE;
					}
					if (_tmp29_) {
						_tmp28_ = TRUE;
					} else {
						xmlNode* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp37_ = node;
						_tmp38_ = (gchar*) xmlGetProp (_tmp37_, (xmlChar*) "width");
						_tmp39_ = _tmp38_;
						_tmp28_ = _tmp39_ == NULL;
						_g_free0 (_tmp39_);
					}
					if (_tmp28_) {
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						xmlNode* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gboolean _tmp45_;
						_tmp42_ = node;
						_tmp43_ = (gchar*) xmlGetProp (_tmp42_, (xmlChar*) "height");
						_tmp44_ = _tmp43_;
						_tmp45_ = _tmp44_ != NULL;
						_g_free0 (_tmp44_);
						if (_tmp45_) {
							xmlNode* _tmp46_;
							gchar* _tmp47_;
							gchar* _tmp48_;
							_tmp46_ = node;
							_tmp47_ = (gchar*) xmlGetProp (_tmp46_, (xmlChar*) "height");
							_tmp48_ = _tmp47_;
							_tmp41_ = atoi (_tmp48_) > 1;
							_g_free0 (_tmp48_);
						} else {
							_tmp41_ = FALSE;
						}
						if (_tmp41_) {
							_tmp40_ = TRUE;
						} else {
							xmlNode* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							_tmp49_ = node;
							_tmp50_ = (gchar*) xmlGetProp (_tmp49_, (xmlChar*) "height");
							_tmp51_ = _tmp50_;
							_tmp40_ = _tmp51_ == NULL;
							_g_free0 (_tmp51_);
						}
						_tmp27_ = _tmp40_;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						gchar* original = NULL;
						xmlNode* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						const gchar* _tmp57_;
						gchar* parentURL = NULL;
						xmlNode* _tmp58_;
						gchar* _tmp59_;
						const gchar* _tmp60_;
						_tmp52_ = node;
						_tmp53_ = (gchar*) xmlGetProp (_tmp52_, (xmlChar*) "src");
						_tmp54_ = _tmp53_;
						_tmp55_ = feed_reader_grabber_utils_downloadImage (session, _tmp54_, article, i + 1, FALSE);
						_tmp56_ = _tmp55_;
						_g_free0 (_tmp54_);
						original = _tmp56_;
						_tmp57_ = original;
						if (_tmp57_ == NULL) {
							_g_free0 (original);
							continue;
						}
						_tmp58_ = node;
						_tmp59_ = feed_reader_grabber_utils_checkParent (session, _tmp58_);
						parentURL = _tmp59_;
						_tmp60_ = parentURL;
						if (_tmp60_ != NULL) {
							gchar* parent = NULL;
							const gchar* _tmp61_;
							gchar* _tmp62_;
							const gchar* _tmp63_;
							const gchar* _tmp64_;
							_tmp61_ = parentURL;
							_tmp62_ = feed_reader_grabber_utils_downloadImage (session, _tmp61_, article, i + 1, TRUE);
							parent = _tmp62_;
							_tmp63_ = parent;
							_tmp64_ = original;
							if (feed_reader_grabber_utils_compareImageSize (_tmp63_, _tmp64_) > 0) {
								xmlNode* _tmp65_;
								const gchar* _tmp66_;
								xmlNode* _tmp67_;
								const gchar* _tmp68_;
								_tmp65_ = node;
								_tmp66_ = original;
								xmlSetProp (_tmp65_, (xmlChar*) "src", (xmlChar*) _tmp66_);
								_tmp67_ = node;
								_tmp68_ = parent;
								xmlSetProp (_tmp67_, (xmlChar*) "FR_parent", (xmlChar*) _tmp68_);
							} else {
								const gchar* _tmp69_;
								xmlNode* _tmp70_;
								const gchar* _tmp71_;
								_tmp69_ = parent;
								g_remove (_tmp69_);
								_tmp70_ = node;
								_tmp71_ = original;
								xmlSetProp (_tmp70_, (xmlChar*) "src", (xmlChar*) _tmp71_);
							}
							_g_free0 (parent);
						} else {
							gchar* resized = NULL;
							const gchar* _tmp72_;
							gchar* _tmp73_;
							const gchar* _tmp74_;
							_tmp72_ = original;
							_tmp73_ = feed_reader_grabber_utils_resizeImg (_tmp72_);
							resized = _tmp73_;
							_tmp74_ = resized;
							if (_tmp74_ != NULL) {
								xmlNode* _tmp75_;
								const gchar* _tmp76_;
								xmlNode* _tmp77_;
								const gchar* _tmp78_;
								_tmp75_ = node;
								_tmp76_ = resized;
								xmlSetProp (_tmp75_, (xmlChar*) "src", (xmlChar*) _tmp76_);
								_tmp77_ = node;
								_tmp78_ = original;
								xmlSetProp (_tmp77_, (xmlChar*) "FR_huge", (xmlChar*) _tmp78_);
							} else {
								xmlNode* _tmp79_;
								const gchar* _tmp80_;
								_tmp79_ = node;
								_tmp80_ = original;
								xmlSetProp (_tmp79_, (xmlChar*) "src", (xmlChar*) _tmp80_);
							}
							_g_free0 (resized);
						}
						_g_free0 (parentURL);
						_g_free0 (original);
					}
				}
			}
		}
	}
	_tmp81_ = res;
	_xmlXPathFreeObject0 (_tmp81_);
	result = TRUE;
	_xmlXPathFreeContext0 (cntx);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

gchar*
feed_reader_grabber_utils_downloadImage (SoupSession* session,
                                         const gchar* url,
                                         FeedReaderArticle* article,
                                         gint nr,
                                         gboolean parent)
{
	gboolean _tmp0_ = FALSE;
	gchar* fixedURL = NULL;
	gchar* _tmp3_;
	gchar* imgPath = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GFile* path = NULL;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	gchar* localFilename = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp35_;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (session != NULL, NULL);
	g_return_val_if_fail (article != NULL, NULL);
	if (url == NULL) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_utf8_strdown (url, (gssize) -1);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_str_has_prefix (_tmp2_, "data:image");
		_g_free0 (_tmp2_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = g_strdup (url);
	fixedURL = _tmp3_;
	_tmp4_ = g_get_user_data_dir ();
	_tmp5_ = g_strdup (_tmp4_);
	imgPath = _tmp5_;
	_tmp6_ = fixedURL;
	if (g_str_has_prefix (_tmp6_, "//")) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = fixedURL;
		_tmp8_ = g_strconcat ("http:", _tmp7_, NULL);
		_g_free0 (fixedURL);
		fixedURL = _tmp8_;
	}
	_tmp10_ = feed_reader_article_getArticleID (article);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = feed_reader_article_getFeedID (article);
		_tmp14_ = _tmp13_;
		_tmp9_ = g_strcmp0 (_tmp14_, "") == 0;
		_g_free0 (_tmp14_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = imgPath;
		_tmp16_ = g_strconcat (_tmp15_, "/debug-article/ArticleImages/", NULL);
		_g_free0 (imgPath);
		imgPath = _tmp16_;
	} else {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp17_ = imgPath;
		_tmp18_ = feed_reader_article_getFeedFileName (article);
		_tmp19_ = _tmp18_;
		_tmp20_ = feed_reader_article_getArticleFileName (article);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("/feedreader/data/images/%s/%s/", _tmp19_, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp17_, _tmp23_, NULL);
		_g_free0 (imgPath);
		imgPath = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	}
	_tmp25_ = imgPath;
	_tmp26_ = g_file_new_for_path (_tmp25_);
	path = _tmp26_;
	{
		GFile* _tmp27_;
		_tmp27_ = path;
		g_file_make_directory_with_parents (_tmp27_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (path);
		_g_free0 (imgPath);
		_g_free0 (fixedURL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp28_ = imgPath;
	_tmp29_ = g_strdup_printf ("%i", nr);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp30_);
	localFilename = _tmp32_;
	if (parent) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp33_ = localFilename;
		_tmp34_ = g_strconcat (_tmp33_, "_parent", NULL);
		_g_free0 (localFilename);
		localFilename = _tmp34_;
	}
	_tmp35_ = localFilename;
	if (!g_file_test (_tmp35_, G_FILE_TEST_EXISTS)) {
		SoupMessage* message_dlImg = NULL;
		const gchar* _tmp36_;
		SoupMessage* _tmp37_;
		SoupMessage* _tmp38_;
		GSettings* _tmp44_;
		GSettings* _tmp45_;
		gboolean _tmp46_;
		guint status = 0U;
		SoupMessage* _tmp49_;
		_tmp36_ = fixedURL;
		_tmp37_ = soup_message_new ("GET", _tmp36_);
		message_dlImg = _tmp37_;
		_tmp38_ = message_dlImg;
		if (_tmp38_ == NULL) {
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp39_ = fixedURL;
			_tmp40_ = string_to_string (_tmp39_);
			_tmp41_ = g_strconcat ("grabberUtils.downloadImage: could not create soup message ", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			feed_reader_logger_warning (_tmp42_);
			_g_free0 (_tmp42_);
			_tmp43_ = g_strdup (url);
			result = _tmp43_;
			_g_object_unref0 (message_dlImg);
			_g_free0 (localFilename);
			_g_object_unref0 (path);
			_g_free0 (imgPath);
			_g_free0 (fixedURL);
			return result;
		}
		_tmp44_ = feed_reader_settings_tweaks ();
		_tmp45_ = _tmp44_;
		_tmp46_ = g_settings_get_boolean (_tmp45_, "do-not-track");
		_g_object_unref0 (_tmp45_);
		if (_tmp46_) {
			SoupMessage* _tmp47_;
			SoupMessageHeaders* _tmp48_;
			_tmp47_ = message_dlImg;
			_tmp48_ = _tmp47_->request_headers;
			soup_message_headers_append (_tmp48_, "DNT", "1");
		}
		_tmp49_ = message_dlImg;
		status = soup_session_send_message (session, _tmp49_);
		if (status == ((guint) 200)) {
			GHashTable* params = NULL;
			GHashTable* _tmp50_;
			gchar* contentType = NULL;
			SoupMessage* _tmp51_;
			SoupMessageHeaders* _tmp52_;
			GHashTable* _tmp53_ = NULL;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			const gchar* _tmp56_;
			_tmp50_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_free0_);
			params = _tmp50_;
			_tmp51_ = message_dlImg;
			_tmp52_ = _tmp51_->response_headers;
			_tmp54_ = soup_message_headers_get_content_type (_tmp52_, &_tmp53_);
			_g_hash_table_unref0 (params);
			params = _tmp53_;
			_tmp55_ = g_strdup (_tmp54_);
			contentType = _tmp55_;
			_tmp56_ = contentType;
			if (_tmp56_ != NULL) {
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				const gchar* _tmp61_;
				_tmp57_ = contentType;
				_tmp58_ = string_to_string (_tmp57_);
				_tmp59_ = g_strconcat ("Grabber: type ", _tmp58_, NULL);
				_tmp60_ = _tmp59_;
				feed_reader_logger_debug (_tmp60_);
				_g_free0 (_tmp60_);
				_tmp61_ = contentType;
				if (g_str_has_prefix (_tmp61_, "image/svg")) {
					const gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp62_ = localFilename;
					_tmp63_ = g_strconcat (_tmp62_, ".svg", NULL);
					_g_free0 (localFilename);
					localFilename = _tmp63_;
				}
			}
			{
				const gchar* _tmp64_;
				SoupMessage* _tmp65_;
				SoupMessageBody* _tmp66_;
				SoupBuffer* _tmp67_;
				SoupBuffer* _tmp68_;
				guint8* _tmp69_;
				gint _tmp69__length1;
				SoupMessage* _tmp70_;
				SoupMessageBody* _tmp71_;
				_tmp64_ = localFilename;
				_tmp65_ = message_dlImg;
				_tmp66_ = _tmp65_->response_body;
				_tmp67_ = soup_message_body_flatten (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = _tmp68_->data;
				_tmp69__length1 = _tmp68_->length;
				_tmp70_ = message_dlImg;
				_tmp71_ = _tmp70_->response_body;
				g_file_set_contents (_tmp64_, (const gchar*) _tmp69_, (gssize) ((glong) _tmp71_->length), &_inner_error0_);
				__vala_SoupBuffer_free0 (_tmp68_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_g_free0 (contentType);
					_g_hash_table_unref0 (params);
					_g_object_unref0 (message_dlImg);
					_g_free0 (localFilename);
					_g_object_unref0 (path);
					_g_free0 (imgPath);
					_g_free0 (fixedURL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally1;
			__catch1_g_file_error:
			{
				GError* e = NULL;
				GError* _tmp72_;
				const gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp72_ = e;
				_tmp73_ = _tmp72_->message;
				_tmp74_ = g_strdup_printf ("Error writing image: %s", _tmp73_);
				_tmp75_ = _tmp74_;
				feed_reader_logger_error (_tmp75_);
				_g_free0 (_tmp75_);
				_tmp76_ = g_strdup (url);
				result = _tmp76_;
				_g_error_free0 (e);
				_g_free0 (contentType);
				_g_hash_table_unref0 (params);
				_g_object_unref0 (message_dlImg);
				_g_free0 (localFilename);
				_g_object_unref0 (path);
				_g_free0 (imgPath);
				_g_free0 (fixedURL);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (contentType);
				_g_hash_table_unref0 (params);
				_g_object_unref0 (message_dlImg);
				_g_free0 (localFilename);
				_g_object_unref0 (path);
				_g_free0 (imgPath);
				_g_free0 (fixedURL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (contentType);
			_g_hash_table_unref0 (params);
		} else {
			const gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			_tmp77_ = fixedURL;
			_tmp78_ = g_strdup_printf ("Error downloading image: %s", _tmp77_);
			_tmp79_ = _tmp78_;
			feed_reader_logger_error (_tmp79_);
			_g_free0 (_tmp79_);
			_tmp80_ = g_strdup (url);
			result = _tmp80_;
			_g_object_unref0 (message_dlImg);
			_g_free0 (localFilename);
			_g_object_unref0 (path);
			_g_free0 (imgPath);
			_g_free0 (fixedURL);
			return result;
		}
		_g_object_unref0 (message_dlImg);
	}
	_tmp81_ = localFilename;
	_tmp82_ = string_replace (_tmp81_, "?", "%3F");
	result = _tmp82_;
	_g_free0 (localFilename);
	_g_object_unref0 (path);
	_g_free0 (imgPath);
	_g_free0 (fixedURL);
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static GdkPixbufFormat*
_vala_GdkPixbufFormat_copy (GdkPixbufFormat* self)
{
	return g_boxed_copy (gdk_pixbuf_format_get_type (), self);
}

static gpointer
__vala_GdkPixbufFormat_copy0 (gpointer self)
{
	return self ? _vala_GdkPixbufFormat_copy (self) : NULL;
}

static void
_vala_GdkPixbufFormat_free (GdkPixbufFormat* self)
{
	g_boxed_free (gdk_pixbuf_format_get_type (), self);
}

static gchar*
feed_reader_grabber_utils_resizeImg (const gchar* path)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	{
		gint* height = NULL;
		gint _tmp0_;
		gint* _tmp1_;
		gint* width = NULL;
		gint _tmp2_;
		gint* _tmp3_;
		GdkPixbufFormat* format = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GdkPixbufFormat* _tmp6_;
		gint _tmp7_;
		gint* _tmp8_;
		gint _tmp9_;
		gint* _tmp10_;
		GdkPixbufFormat* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		GdkPixbufFormat* _tmp14_;
		gboolean _tmp17_ = FALSE;
		gint* _tmp18_;
		_tmp0_ = 0;
		_tmp1_ = __int_dup0 (&_tmp0_);
		height = _tmp1_;
		_tmp2_ = 0;
		_tmp3_ = __int_dup0 (&_tmp2_);
		width = _tmp3_;
		_tmp6_ = gdk_pixbuf_get_file_info (path, &_tmp4_, &_tmp5_);
		_g_free0 (width);
		_tmp7_ = _tmp4_;
		_tmp8_ = __int_dup0 (&_tmp7_);
		width = _tmp8_;
		_g_free0 (height);
		_tmp9_ = _tmp5_;
		_tmp10_ = __int_dup0 (&_tmp9_);
		height = _tmp10_;
		_tmp11_ = __vala_GdkPixbufFormat_copy0 (_tmp6_);
		format = _tmp11_;
		_tmp14_ = format;
		if (_tmp14_ == NULL) {
			_tmp13_ = TRUE;
		} else {
			gint* _tmp15_;
			_tmp15_ = height;
			_tmp13_ = _tmp15_ == NULL;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gint* _tmp16_;
			_tmp16_ = width;
			_tmp12_ = _tmp16_ == NULL;
		}
		if (_tmp12_) {
			result = NULL;
			__vala_GdkPixbufFormat_free0 (format);
			_g_free0 (width);
			_g_free0 (height);
			return result;
		}
		_tmp18_ = width;
		if ((*_tmp18_) > 2000) {
			_tmp17_ = TRUE;
		} else {
			gint* _tmp19_;
			_tmp19_ = height;
			_tmp17_ = (*_tmp19_) > 2000;
		}
		if (_tmp17_) {
			gint nHeight = 0;
			gint nWidth = 0;
			gint* _tmp20_;
			gint* _tmp21_;
			GdkPixbuf* img = NULL;
			GdkPixbuf* _tmp24_;
			GdkPixbuf* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			nHeight = 1000;
			nWidth = 1000;
			_tmp20_ = width;
			_tmp21_ = height;
			if ((*_tmp20_) > (*_tmp21_)) {
				nHeight = -1;
			} else {
				gint* _tmp22_;
				gint* _tmp23_;
				_tmp22_ = height;
				_tmp23_ = width;
				if ((*_tmp22_) > (*_tmp23_)) {
					nWidth = -1;
				}
			}
			_tmp24_ = gdk_pixbuf_new_from_file_at_scale (path, nWidth, nHeight, TRUE, &_inner_error0_);
			img = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				__vala_GdkPixbufFormat_free0 (format);
				_g_free0 (width);
				_g_free0 (height);
				goto __catch0_g_error;
			}
			_tmp25_ = img;
			_tmp26_ = g_strconcat (path, "_resized", NULL);
			_tmp27_ = _tmp26_;
			gdk_pixbuf_save (_tmp25_, _tmp27_, "png", &_inner_error0_, NULL);
			_g_free0 (_tmp27_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (img);
				__vala_GdkPixbufFormat_free0 (format);
				_g_free0 (width);
				_g_free0 (height);
				goto __catch0_g_error;
			}
			_tmp28_ = g_strconcat (path, "_resized", NULL);
			result = _tmp28_;
			_g_object_unref0 (img);
			__vala_GdkPixbufFormat_free0 (format);
			_g_free0 (width);
			_g_free0 (height);
			return result;
		}
		__vala_GdkPixbufFormat_free0 (format);
		_g_free0 (width);
		_g_free0 (height);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = g_strdup_printf ("Error resizing image: %s", _tmp30_);
		_tmp32_ = _tmp31_;
		feed_reader_logger_error (_tmp32_);
		_g_free0 (_tmp32_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gint
feed_reader_grabber_utils_compareImageSize (const gchar* file1,
                                            const gchar* file2)
{
	gint* height1 = NULL;
	gint _tmp0_;
	gint* _tmp1_;
	gint* width1 = NULL;
	gint _tmp2_;
	gint* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gint* _tmp7_;
	gint _tmp8_;
	gint* _tmp9_;
	gint* height2 = NULL;
	gint _tmp10_;
	gint* _tmp11_;
	gint* width2 = NULL;
	gint _tmp12_;
	gint* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_;
	gint* _tmp17_;
	gint _tmp18_;
	gint* _tmp19_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gint* _tmp23_;
	gboolean _tmp27_ = FALSE;
	gint* _tmp28_;
	gint* _tmp29_;
	gint result;
	g_return_val_if_fail (file1 != NULL, 0);
	g_return_val_if_fail (file2 != NULL, 0);
	_tmp0_ = 0;
	_tmp1_ = __int_dup0 (&_tmp0_);
	height1 = _tmp1_;
	_tmp2_ = 0;
	_tmp3_ = __int_dup0 (&_tmp2_);
	width1 = _tmp3_;
	gdk_pixbuf_get_file_info (file1, &_tmp4_, &_tmp5_);
	_g_free0 (width1);
	_tmp6_ = _tmp4_;
	_tmp7_ = __int_dup0 (&_tmp6_);
	width1 = _tmp7_;
	_g_free0 (height1);
	_tmp8_ = _tmp5_;
	_tmp9_ = __int_dup0 (&_tmp8_);
	height1 = _tmp9_;
	_tmp10_ = 0;
	_tmp11_ = __int_dup0 (&_tmp10_);
	height2 = _tmp11_;
	_tmp12_ = 0;
	_tmp13_ = __int_dup0 (&_tmp12_);
	width2 = _tmp13_;
	gdk_pixbuf_get_file_info (file2, &_tmp14_, &_tmp15_);
	_g_free0 (width2);
	_tmp16_ = _tmp14_;
	_tmp17_ = __int_dup0 (&_tmp16_);
	width2 = _tmp17_;
	_g_free0 (height2);
	_tmp18_ = _tmp15_;
	_tmp19_ = __int_dup0 (&_tmp18_);
	height2 = _tmp19_;
	_tmp23_ = height1;
	if (_tmp23_ == NULL) {
		_tmp22_ = TRUE;
	} else {
		gint* _tmp24_;
		_tmp24_ = width1;
		_tmp22_ = _tmp24_ == NULL;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		gint* _tmp25_;
		_tmp25_ = height2;
		_tmp21_ = _tmp25_ == NULL;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gint* _tmp26_;
		_tmp26_ = width2;
		_tmp20_ = _tmp26_ == NULL;
	}
	if (_tmp20_) {
		feed_reader_logger_warning ("Utils.compareImageSize: couldn't read image sizes");
		result = 0;
		_g_free0 (width2);
		_g_free0 (height2);
		_g_free0 (width1);
		_g_free0 (height1);
		return result;
	}
	_tmp28_ = height1;
	_tmp29_ = height2;
	if (_int_equal (_tmp28_, _tmp29_) == TRUE) {
		gint* _tmp30_;
		gint* _tmp31_;
		_tmp30_ = width1;
		_tmp31_ = width2;
		_tmp27_ = _int_equal (_tmp30_, _tmp31_) == TRUE;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		result = 0;
		_g_free0 (width2);
		_g_free0 (height2);
		_g_free0 (width1);
		_g_free0 (height1);
		return result;
	} else {
		gint* _tmp32_;
		gint* _tmp33_;
		gint* _tmp34_;
		gint* _tmp35_;
		_tmp32_ = height1;
		_tmp33_ = width1;
		_tmp34_ = height2;
		_tmp35_ = width2;
		if (((*_tmp32_) * (*_tmp33_)) > ((*_tmp34_) * (*_tmp35_))) {
			result = 1;
			_g_free0 (width2);
			_g_free0 (height2);
			_g_free0 (width1);
			_g_free0 (height1);
			return result;
		} else {
			result = -1;
			_g_free0 (width2);
			_g_free0 (height2);
			_g_free0 (width1);
			_g_free0 (height1);
			return result;
		}
	}
}

static gchar*
feed_reader_grabber_utils_checkParent (SoupSession* session,
                                       xmlNode* node)
{
	gchar* smallImgURL = NULL;
	gchar* _tmp0_;
	gint64 origSize = 0LL;
	gint64 size = 0LL;
	xmlNode* parent = NULL;
	xmlNode* _tmp1_;
	gchar* name = NULL;
	xmlNode* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (session != NULL, NULL);
	feed_reader_logger_debug ("Grabber: checkParent");
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "src");
	smallImgURL = _tmp0_;
	origSize = (gint64) 0;
	size = (gint64) 0;
	_tmp1_ = node->parent;
	parent = _tmp1_;
	_tmp2_ = parent;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = g_strdup (_tmp3_);
	name = _tmp4_;
	_tmp5_ = name;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat ("Grabber: parent ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	feed_reader_logger_debug (_tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = name;
	if (g_strcmp0 (_tmp9_, "a") == 0) {
		gchar* url = NULL;
		xmlNode* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		_tmp10_ = parent;
		_tmp11_ = (gchar*) xmlGetProp (_tmp10_, (xmlChar*) "href");
		url = _tmp11_;
		_tmp13_ = url;
		if (g_strcmp0 (_tmp13_, "") != 0) {
			const gchar* _tmp14_;
			_tmp14_ = url;
			_tmp12_ = _tmp14_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			const gchar* _tmp15_;
			SoupMessage* message = NULL;
			const gchar* _tmp18_;
			SoupMessage* _tmp19_;
			SoupMessage* _tmp20_;
			SoupMessage* _tmp21_;
			GHashTable* params = NULL;
			GHashTable* _tmp22_;
			gchar* contentType = NULL;
			SoupMessage* _tmp23_;
			SoupMessageHeaders* _tmp24_;
			GHashTable* _tmp25_ = NULL;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			SoupMessage* _tmp28_;
			SoupMessageHeaders* _tmp29_;
			SoupMessage* message2 = NULL;
			const gchar* _tmp30_;
			SoupMessage* _tmp31_;
			SoupMessage* _tmp32_;
			SoupMessage* _tmp33_;
			SoupMessage* _tmp34_;
			SoupMessageHeaders* _tmp35_;
			const gchar* _tmp36_;
			_tmp15_ = url;
			if (g_str_has_prefix (_tmp15_, "//")) {
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = url;
				_tmp17_ = g_strconcat ("http:", _tmp16_, NULL);
				_g_free0 (url);
				url = _tmp17_;
			}
			_tmp18_ = url;
			_tmp19_ = soup_message_new ("HEAD", _tmp18_);
			message = _tmp19_;
			_tmp20_ = message;
			if (_tmp20_ == NULL) {
				result = NULL;
				_g_object_unref0 (message);
				_g_free0 (url);
				_g_free0 (name);
				_g_free0 (smallImgURL);
				return result;
			}
			_tmp21_ = message;
			soup_session_send_message (session, _tmp21_);
			_tmp22_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_free0_);
			params = _tmp22_;
			_tmp23_ = message;
			_tmp24_ = _tmp23_->response_headers;
			_tmp26_ = soup_message_headers_get_content_type (_tmp24_, &_tmp25_);
			_g_hash_table_unref0 (params);
			params = _tmp25_;
			_tmp27_ = g_strdup (_tmp26_);
			contentType = _tmp27_;
			_tmp28_ = message;
			_tmp29_ = _tmp28_->response_headers;
			size = soup_message_headers_get_content_length (_tmp29_);
			_tmp30_ = smallImgURL;
			_tmp31_ = soup_message_new ("HEAD", _tmp30_);
			message2 = _tmp31_;
			_tmp32_ = message2;
			if (_tmp32_ == NULL) {
				result = NULL;
				_g_object_unref0 (message2);
				_g_free0 (contentType);
				_g_hash_table_unref0 (params);
				_g_object_unref0 (message);
				_g_free0 (url);
				_g_free0 (name);
				_g_free0 (smallImgURL);
				return result;
			}
			_tmp33_ = message2;
			soup_session_send_message (session, _tmp33_);
			_tmp34_ = message2;
			_tmp35_ = _tmp34_->response_headers;
			origSize = soup_message_headers_get_content_length (_tmp35_);
			_tmp36_ = contentType;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp37_ = contentType;
				_tmp38_ = string_to_string (_tmp37_);
				_tmp39_ = g_strconcat ("Grabber: type ", _tmp38_, NULL);
				_tmp40_ = _tmp39_;
				feed_reader_logger_debug (_tmp40_);
				_g_free0 (_tmp40_);
				_tmp41_ = contentType;
				if (g_str_has_prefix (_tmp41_, "image/")) {
					gboolean _tmp42_ = FALSE;
					if (size != ((gint64) 0)) {
						_tmp42_ = origSize != ((gint64) 0);
					} else {
						_tmp42_ = FALSE;
					}
					if (_tmp42_) {
						if (size > origSize) {
							result = url;
							_g_object_unref0 (message2);
							_g_free0 (contentType);
							_g_hash_table_unref0 (params);
							_g_object_unref0 (message);
							_g_free0 (name);
							_g_free0 (smallImgURL);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (message2);
							_g_free0 (contentType);
							_g_hash_table_unref0 (params);
							_g_object_unref0 (message);
							_g_free0 (url);
							_g_free0 (name);
							_g_free0 (smallImgURL);
							return result;
						}
					} else {
						result = url;
						_g_object_unref0 (message2);
						_g_free0 (contentType);
						_g_hash_table_unref0 (params);
						_g_object_unref0 (message);
						_g_free0 (name);
						_g_free0 (smallImgURL);
						return result;
					}
				}
			}
			_g_object_unref0 (message2);
			_g_free0 (contentType);
			_g_hash_table_unref0 (params);
			_g_object_unref0 (message);
		}
		_g_free0 (url);
	}
	result = NULL;
	_g_free0 (name);
	_g_free0 (smallImgURL);
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
feed_reader_grabber_utils_postProcessing (gchar** html)
{
	gchar* _tmp0_;
	gint pos1 = 0;
	gint pos2 = 0;
	gint pos3 = 0;
	gchar* _tmp26_;
	gchar* result;
	g_return_val_if_fail (*html != NULL, NULL);
	feed_reader_logger_debug ("GrabberUtils: postProcessing");
	_tmp0_ = string_replace (*html, "<h3/>", "<h3></h3>");
	_g_free0 (*html);
	*html = _tmp0_;
	pos1 = string_index_of (*html, "<iframe", 0);
	pos2 = -1;
	pos3 = -1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gchar* broken_iframe = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* fixed_iframe = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		if (!(pos1 != -1)) {
			break;
		}
		pos2 = string_index_of (*html, "/>", pos1);
		pos3 = string_index_of (*html, "</iframe>", pos1);
		if (pos3 == -1) {
			_tmp1_ = pos2 == -1;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			feed_reader_logger_error ("GrabberUtils.postProcessing: could not find closing for iframe tag");
			pos1 = string_index_of (*html, "<iframe", pos1 + 7);
			continue;
		}
		if (pos2 != -1) {
			_tmp4_ = pos3 != -1;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = pos3 < pos2;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = pos2 == -1;
		}
		if (_tmp2_) {
			feed_reader_logger_debug ("GrabberUtils.postProcessing: iframe not broken");
			pos1 = string_index_of (*html, "<iframe", pos1 + 7);
			continue;
		}
		_tmp5_ = string_substring (*html, (glong) pos1, (glong) ((pos2 + 2) - pos1));
		broken_iframe = _tmp5_;
		_tmp6_ = broken_iframe;
		_tmp7_ = g_strdup_printf ("GrabberUtils: broken = %s", _tmp6_);
		_tmp8_ = _tmp7_;
		feed_reader_logger_debug (_tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = broken_iframe;
		_tmp10_ = broken_iframe;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_substring (_tmp9_, (glong) 0, (glong) (_tmp12_ - 2));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "></iframe>", NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		fixed_iframe = _tmp16_;
		_tmp17_ = fixed_iframe;
		_tmp18_ = g_strdup_printf ("GrabberUtils: fixed = %s", _tmp17_);
		_tmp19_ = _tmp18_;
		feed_reader_logger_debug (_tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = broken_iframe;
		_tmp21_ = fixed_iframe;
		_tmp22_ = string_replace (*html, _tmp20_, _tmp21_);
		_g_free0 (*html);
		*html = _tmp22_;
		pos3 = string_index_of (*html, "<iframe", pos1 + 7);
		if (pos3 == pos1) {
			_tmp23_ = TRUE;
		} else {
			gint _tmp24_;
			gint _tmp25_;
			_tmp24_ = strlen (*html);
			_tmp25_ = _tmp24_;
			_tmp23_ = pos3 > _tmp25_;
		}
		if (_tmp23_) {
			_g_free0 (fixed_iframe);
			_g_free0 (broken_iframe);
			break;
		} else {
			pos1 = pos3;
		}
		_g_free0 (fixed_iframe);
		_g_free0 (broken_iframe);
	}
	feed_reader_logger_debug ("GrabberUtils: postProcessing done");
	_tmp26_ = g_strdup (*html);
	result = _tmp26_;
	return result;
}

static void
feed_reader_grabber_utils_class_init (FeedReadergrabberUtilsClass * klass,
                                      gpointer klass_data)
{
	feed_reader_grabber_utils_parent_class = g_type_class_peek_parent (klass);
}

static void
feed_reader_grabber_utils_instance_init (FeedReadergrabberUtils * self,
                                         gpointer klass)
{
}

static GType
feed_reader_grabber_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReadergrabberUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_grabber_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReadergrabberUtils), 0, (GInstanceInitFunc) feed_reader_grabber_utils_instance_init, NULL };
	GType feed_reader_grabber_utils_type_id;
	feed_reader_grabber_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReadergrabberUtils", &g_define_type_info, 0);
	return feed_reader_grabber_utils_type_id;
}

GType
feed_reader_grabber_utils_get_type (void)
{
	static volatile gsize feed_reader_grabber_utils_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_grabber_utils_type_id__once)) {
		GType feed_reader_grabber_utils_type_id;
		feed_reader_grabber_utils_type_id = feed_reader_grabber_utils_get_type_once ();
		g_once_init_leave (&feed_reader_grabber_utils_type_id__once, feed_reader_grabber_utils_type_id);
	}
	return feed_reader_grabber_utils_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

