/* DataBaseReadOnly.c generated by valac 0.56.3, the Vala compiler
 * generated from DataBaseReadOnly.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

enum  {
	FEED_READER_DATA_BASE_READ_ONLY_0_PROPERTY,
	FEED_READER_DATA_BASE_READ_ONLY_NUM_PROPERTIES
};
static GParamSpec* feed_reader_data_base_read_only_properties[FEED_READER_DATA_BASE_READ_ONLY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_value_free0(var) ((var == NULL) ? NULL : (var = (sqlite3_value_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer feed_reader_data_base_read_only_parent_class = NULL;

static void feed_reader_data_base_read_only_errorLogCallback (FeedReaderDataBaseReadOnly* self,
                                                       gint code,
                                                       const gchar* msg);
static guint feed_reader_data_base_read_only_count_article_status (FeedReaderDataBaseReadOnly* self,
                                                            FeedReaderArticleStatus status);
static void _vala_GValue_free (GValue* self);
static guint feed_reader_data_base_read_only_count_status_uncategorized (FeedReaderDataBaseReadOnly* self,
                                                                  FeedReaderArticleStatus status);
static GeeList* feed_reader_data_base_read_only_read_taggings_by_article_id (FeedReaderDataBaseReadOnly* self,
                                                                      const gchar* articleID);
static GeeList* feed_reader_data_base_read_only_read_enclosures (FeedReaderDataBaseReadOnly* self,
                                                          const gchar* article_id);
static GeeList* feed_reader_data_base_read_only_read_taggings_by_tag_id (FeedReaderDataBaseReadOnly* self,
                                                                  const gchar* tagID);
static void feed_reader_data_base_read_only_finalize (GObject * obj);
static GType feed_reader_data_base_read_only_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const gchar* FEED_READER_CONSTANTS_COLORS[24];

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

FeedReaderDataBaseReadOnly*
feed_reader_data_base_read_only_construct (GType object_type,
                                           const gchar* db_file)
{
	FeedReaderDataBaseReadOnly * self = NULL;
	gchar* db_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderSQLite* _tmp8_;
	g_return_val_if_fail (db_file != NULL, NULL);
	self = (FeedReaderDataBaseReadOnly*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strconcat (_tmp0_, "/feedreader/data/", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, db_file, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	db_path = _tmp4_;
	_tmp5_ = string_to_string (db_path);
	_tmp6_ = g_strconcat ("Opening Database: ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	feed_reader_logger_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = feed_reader_sq_lite_new (db_path, 1000);
	_g_object_unref0 (self->m_db);
	self->m_db = _tmp8_;
	_g_free0 (db_path);
	return self;
}

FeedReaderDataBaseReadOnly*
feed_reader_data_base_read_only_new (const gchar* db_file)
{
	return feed_reader_data_base_read_only_construct (FEED_READER_TYPE_DATA_BASE_READ_ONLY, db_file);
}

static void
feed_reader_data_base_read_only_errorLogCallback (FeedReaderDataBaseReadOnly* self,
                                                  gint code,
                                                  const gchar* msg)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = g_strdup_printf ("%i", code);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (msg);
	_tmp3_ = g_strconcat ("dbErrorLog: ", _tmp1_, ": ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_logger_error (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}

void
feed_reader_data_base_read_only_init (FeedReaderDataBaseReadOnly* self)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderSQLite* _tmp1_;
	FeedReaderSQLite* _tmp2_;
	FeedReaderSQLite* _tmp3_;
	FeedReaderSQLite* _tmp4_;
	FeedReaderSQLite* _tmp5_;
	FeedReaderSQLite* _tmp6_;
	FeedReaderSQLite* _tmp7_;
	FeedReaderSQLite* _tmp8_;
	FeedReaderSQLite* _tmp9_;
	FeedReaderSQLite* _tmp10_;
	FeedReaderSQLite* _tmp11_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_debug ("init database");
	_tmp0_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "PRAGMA journal_mode = WAL");
	_tmp1_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp1_, "PRAGMA page_size = 4096");
	_tmp2_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp2_, "PRAGMA foreign_keys = ON");
	_tmp3_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp3_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"feeds\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"feed_id\" TEXT PRIMARY KEY NOT NULL UNIQUE,\n" \
"\t\t\t\t\"name\" TEXT NOT NULL,\n" \
"\t\t\t\t\"url\" TEXT NOT NULL,\n" \
"\t\t\t\t\"category_id\" TEXT,\n" \
"\t\t\t\t\"subscribed\" INTEGER DEFAULT 1,\n" \
"\t\t\t\t\"xmlURL\" TEXT,\n" \
"\t\t\t\t\"iconURL\" TEXT\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp4_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp4_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"categories\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"categorieID\" TEXT PRIMARY KEY NOT NULL UNIQUE,\n" \
"\t\t\t\t\"title\" TEXT NOT NULL,\n" \
"\t\t\t\t\"orderID\" INTEGER,\n" \
"\t\t\t\t\"exists\" INTEGER,\n" \
"\t\t\t\t\"Parent\" TEXT,\n" \
"\t\t\t\t\"Level\" INTEGER\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp5_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp5_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"articles\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"articleID\" TEXT PRIMARY KEY NOT NULL UNIQUE,\n" \
"\t\t\t\t\"feedID\" TEXT NOT NULL,\n" \
"\t\t\t\t\"title\" TEXT NOT NULL,\n" \
"\t\t\t\t\"author\" TEXT,\n" \
"\t\t\t\t\"url\" TEXT NOT NULL,\n" \
"\t\t\t\t\"html\" TEXT NOT NULL,\n" \
"\t\t\t\t\"preview\" TEXT NOT NULL,\n" \
"\t\t\t\t\"unread\" INTEGER NOT NULL,\n" \
"\t\t\t\t\"marked\" INTEGER NOT NULL,\n" \
"\t\t\t\t\"date\" INTEGER NOT NULL,\n" \
"\t\t\t\t\"guidHash\" TEXT,\n" \
"\t\t\t\t\"lastModified\" INTEGER,\n" \
"\t\t\t\t\"contentFetched\" INTEGER NOT NULL\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp6_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp6_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"tags\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"tagID\" TEXT PRIMARY KEY NOT NULL UNIQUE,\n" \
"\t\t\t\t\"title\" TEXT NOT NULL,\n" \
"\t\t\t\t\"exists\" INTEGER,\n" \
"\t\t\t\t\"color\" INTEGER\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp7_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp7_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"CachedActions\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"action\" INTEGER NOT NULL,\n" \
"\t\t\t\t\"id\" TEXT NOT NULL,\n" \
"\t\t\t\t\"argument\" INTEGER\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp8_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp8_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"Enclosures\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"articleID\" TEXT NOT NULL,\n" \
"\t\t\t\t\"url\" TEXT NOT NULL,\n" \
"\t\t\t\t\"type\" INTEGER NOT NULL,\n" \
"\t\t\t\tFOREIGN KEY(articleID) REFERENCES articles(articleID)\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp9_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp9_, "\n" \
"\t\t\tCREATE  TABLE  IF NOT EXISTS \"main\".\"taggings\"\n" \
"\t\t\t(\n" \
"\t\t\t\t\"articleID\" TEXT NOT NULL,\n" \
"\t\t\t\t\"tagID\" TEXT NOT NULL,\n" \
"\t\t\t\tFOREIGN KEY(articleID) REFERENCES articles(articleID),\n" \
"\t\t\t\tFOREIGN KEY(tagID) REFERENCES tags(tagID)\n" \
"\t\t\t)\n" \
"\t\t");
	_tmp10_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp10_, "\n" \
"\t\t\tCREATE INDEX IF NOT EXISTS \"index_articles\"\n" \
"\t\t\tON \"articles\" (\"feedID\" DESC, \"unread\" ASC, \"marked\" ASC" \
")\n" \
"\t\t");
	_tmp11_ = self->m_db;
	feed_reader_sq_lite_simple_query (_tmp11_, "\n" \
"\t\t\tCREATE VIRTUAL TABLE IF NOT EXISTS fts_table\n" \
"\t\t\tUSING fts4 (content='articles', articleID, preview, title, autho" \
"r)\n" \
"\t\t");
}

gboolean
feed_reader_data_base_read_only_uninitialized (FeedReaderDataBaseReadOnly* self)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GeeList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	sqlite3_value* _tmp17_;
	gboolean _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("SELECT count(*) FROM sqlite_master WHERE type='table' AND name='articl" \
"es'");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, NULL, (gint) 0);
	rows = _tmp3_;
	_tmp5_ = rows;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 1) {
		GeeList* _tmp8_;
		gpointer _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp8_ = rows;
		_tmp9_ = gee_list_get (_tmp8_, 0);
		_tmp10_ = (GeeList*) _tmp9_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp4_ = _tmp12_ == 1;
		_g_object_unref0 (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	_vala_assert (_tmp4_, "rows.size == 1 && rows[0].size == 1");
	_tmp13_ = rows;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (GeeList*) _tmp14_;
	_tmp16_ = gee_list_get (_tmp15_, 0);
	_tmp17_ = (sqlite3_value*) _tmp16_;
	_tmp18_ = sqlite3_value_int (_tmp17_) == 0;
	_sqlite3_value_free0 (_tmp17_);
	_g_object_unref0 (_tmp15_);
	result = _tmp18_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

gboolean
feed_reader_data_base_read_only_isEmpty (FeedReaderDataBaseReadOnly* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (feed_reader_data_base_read_only_isTableEmpty (self, "articles")) {
		_tmp2_ = feed_reader_data_base_read_only_isTableEmpty (self, "categories");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = feed_reader_data_base_read_only_isTableEmpty (self, "feeds");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = feed_reader_data_base_read_only_isTableEmpty (self, "tags");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
feed_reader_data_base_read_only_isTableEmpty (FeedReaderDataBaseReadOnly* self,
                                              const gchar* table)
{
	gchar* query = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp2_;
	const gchar* _tmp3_;
	GeeList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeList* _tmp14_;
	gpointer _tmp15_;
	GeeList* _tmp16_;
	gpointer _tmp17_;
	sqlite3_value* _tmp18_;
	gboolean _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (table != NULL, FALSE);
	_vala_return_val_if_fail (g_strcmp0 (table, "") != 0, "table != \"\"", FALSE);
	_tmp0_ = string_to_string (table);
	_tmp1_ = g_strconcat ("SELECT COUNT(*) FROM ", _tmp0_, NULL);
	query = _tmp1_;
	_tmp2_ = self->m_db;
	_tmp3_ = query;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp2_, _tmp3_, NULL, (gint) 0);
	rows = _tmp4_;
	_tmp6_ = rows;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 1) {
		GeeList* _tmp9_;
		gpointer _tmp10_;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp9_ = rows;
		_tmp10_ = gee_list_get (_tmp9_, 0);
		_tmp11_ = (GeeList*) _tmp10_;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp5_ = _tmp13_ == 1;
		_g_object_unref0 (_tmp11_);
	} else {
		_tmp5_ = FALSE;
	}
	_vala_assert (_tmp5_, "rows.size == 1 && rows[0].size == 1");
	_tmp14_ = rows;
	_tmp15_ = gee_list_get (_tmp14_, 0);
	_tmp16_ = (GeeList*) _tmp15_;
	_tmp17_ = gee_list_get (_tmp16_, 0);
	_tmp18_ = (sqlite3_value*) _tmp17_;
	_tmp19_ = sqlite3_value_int (_tmp18_) == 0;
	_sqlite3_value_free0 (_tmp18_);
	_g_object_unref0 (_tmp16_);
	result = _tmp19_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static guint
feed_reader_data_base_read_only_count_article_status (FeedReaderDataBaseReadOnly* self,
                                                      FeedReaderArticleStatus status)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	gchar* status_column = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp9_;
	const gchar* _tmp10_;
	GValue* _tmp11_ = NULL;
	GValue** _tmp12_;
	GValue** _tmp13_;
	gint _tmp13__length1;
	GeeList* _tmp14_;
	GeeList* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	GeeList* _tmp27_;
	gpointer _tmp28_;
	sqlite3_value* _tmp29_;
	guint _tmp30_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_strdup ("SELECT COUNT(*) FROM articles");
	query = _tmp0_;
	_tmp1_ = feed_reader_article_status_column (status);
	status_column = _tmp1_;
	_tmp2_ = status_column;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = query;
		_tmp4_ = status_column;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat (" WHERE ", _tmp5_, " = ?", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp3_, _tmp7_, NULL);
		_g_free0 (query);
		query = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_tmp9_ = self->m_db;
	_tmp10_ = query;
	_tmp11_ = g_new0 (GValue, 1);
	g_value_init (_tmp11_, FEED_READER_TYPE_ARTICLE_STATUS);
	g_value_set_enum (_tmp11_, status);
	_tmp12_ = g_new0 (GValue*, 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	_tmp14_ = feed_reader_sq_lite_execute (_tmp9_, _tmp10_, _tmp13_, (gint) 1);
	_tmp15_ = _tmp14_;
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp15_;
	_tmp17_ = rows;
	_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == 1) {
		GeeList* _tmp20_;
		gpointer _tmp21_;
		GeeList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp20_ = rows;
		_tmp21_ = gee_list_get (_tmp20_, 0);
		_tmp22_ = (GeeList*) _tmp21_;
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp16_ = _tmp24_ == 1;
		_g_object_unref0 (_tmp22_);
	} else {
		_tmp16_ = FALSE;
	}
	_vala_assert (_tmp16_, "rows.size == 1 && rows[0].size == 1");
	_tmp25_ = rows;
	_tmp26_ = gee_list_get (_tmp25_, 0);
	_tmp27_ = (GeeList*) _tmp26_;
	_tmp28_ = gee_list_get (_tmp27_, 0);
	_tmp29_ = (sqlite3_value*) _tmp28_;
	_tmp30_ = (guint) sqlite3_value_int (_tmp29_);
	_sqlite3_value_free0 (_tmp29_);
	_g_object_unref0 (_tmp27_);
	result = _tmp30_;
	_g_object_unref0 (rows);
	_g_free0 (status_column);
	_g_free0 (query);
	return result;
}

guint
feed_reader_data_base_read_only_get_unread_total (FeedReaderDataBaseReadOnly* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = feed_reader_data_base_read_only_count_article_status (self, FEED_READER_ARTICLE_STATUS_UNREAD);
	return result;
}

guint
feed_reader_data_base_read_only_get_marked_total (FeedReaderDataBaseReadOnly* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = feed_reader_data_base_read_only_count_article_status (self, FEED_READER_ARTICLE_STATUS_MARKED);
	return result;
}

static guint
feed_reader_data_base_read_only_count_status_uncategorized (FeedReaderDataBaseReadOnly* self,
                                                            FeedReaderArticleStatus status)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	gchar* status_column = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	FeedReaderQueryBuilder* subquery = NULL;
	FeedReaderQueryBuilder* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FeedReaderQueryBuilder* _tmp11_;
	FeedReaderQueryBuilder* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp17_;
	FeedReaderQueryBuilder* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	sqlite3_stmt* _tmp21_;
	sqlite3_stmt* _tmp22_;
	gint unread = 0;
	sqlite3_stmt* _tmp25_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "articles");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_select_field (_tmp1_, "count(*)");
	_tmp2_ = feed_reader_article_status_column (status);
	status_column = _tmp2_;
	_tmp3_ = status_column;
	if (_tmp3_ != NULL) {
		FeedReaderQueryBuilder* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = query;
		_tmp5_ = status_column;
		feed_reader_query_builder_where_equal_int (_tmp4_, _tmp5_, (gint64) feed_reader_article_status_to_int (status));
	}
	_tmp6_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "feeds");
	subquery = _tmp6_;
	_tmp7_ = subquery;
	feed_reader_query_builder_select_field (_tmp7_, "feed_id");
	_tmp8_ = subquery;
	_tmp9_ = feed_reader_data_base_read_only_getUncategorizedQuery (self);
	_tmp10_ = _tmp9_;
	feed_reader_query_builder_where (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = query;
	_tmp12_ = subquery;
	_tmp13_ = feed_reader_query_builder_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("feedID IN (%s)", _tmp14_);
	_tmp16_ = _tmp15_;
	feed_reader_query_builder_where (_tmp11_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = self->m_db;
	_tmp18_ = query;
	_tmp19_ = feed_reader_query_builder_to_string (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = feed_reader_sq_lite_prepare (_tmp17_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	stmt = _tmp22_;
	unread = 0;
	while (TRUE) {
		sqlite3_stmt* _tmp23_;
		sqlite3_stmt* _tmp24_;
		_tmp23_ = stmt;
		if (!(sqlite3_step (_tmp23_) == SQLITE_ROW)) {
			break;
		}
		_tmp24_ = stmt;
		unread = sqlite3_column_int (_tmp24_, 0);
	}
	_tmp25_ = stmt;
	sqlite3_reset (_tmp25_);
	result = (guint) unread;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (subquery);
	_g_free0 (status_column);
	_g_object_unref0 (query);
	return result;
}

guint
feed_reader_data_base_read_only_get_unread_uncategorized (FeedReaderDataBaseReadOnly* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = feed_reader_data_base_read_only_count_status_uncategorized (self, FEED_READER_ARTICLE_STATUS_UNREAD);
	return result;
}

guint
feed_reader_data_base_read_only_get_marked_uncategorized (FeedReaderDataBaseReadOnly* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = feed_reader_data_base_read_only_count_status_uncategorized (self, FEED_READER_ARTICLE_STATUS_MARKED);
	return result;
}

gint
feed_reader_data_base_read_only_get_new_unread_count (FeedReaderDataBaseReadOnly* self,
                                                      gint row_id)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeList* _tmp18_;
	gpointer _tmp19_;
	GeeList* _tmp20_;
	gpointer _tmp21_;
	sqlite3_value* _tmp22_;
	gint _tmp23_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (row_id == 0) {
		result = 0;
		return result;
	}
	_tmp0_ = g_strdup ("SELECT count(*) FROM articles WHERE unread = ? AND rowid > ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, FEED_READER_TYPE_ARTICLE_STATUS);
	g_value_set_enum (_tmp3_, FEED_READER_ARTICLE_STATUS_UNREAD);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT);
	g_value_set_int (_tmp4_, row_id);
	_tmp5_ = g_new0 (GValue*, 2);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp6_, (gint) 2);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp8_;
	_tmp10_ = rows;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 1) {
		GeeList* _tmp13_;
		gpointer _tmp14_;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp13_ = rows;
		_tmp14_ = gee_list_get (_tmp13_, 0);
		_tmp15_ = (GeeList*) _tmp14_;
		_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp9_ = _tmp17_ == 1;
		_g_object_unref0 (_tmp15_);
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "rows.size == 1 && rows[0].size == 1");
	_tmp18_ = rows;
	_tmp19_ = gee_list_get (_tmp18_, 0);
	_tmp20_ = (GeeList*) _tmp19_;
	_tmp21_ = gee_list_get (_tmp20_, 0);
	_tmp22_ = (sqlite3_value*) _tmp21_;
	_tmp23_ = sqlite3_value_int (_tmp22_);
	_sqlite3_value_free0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	result = _tmp23_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

gint
feed_reader_data_base_read_only_getTagColor (FeedReaderDataBaseReadOnly* self)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GeeList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint tagCount = 0;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	sqlite3_value* _tmp15_;
	gint _tmp16_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->m_db;
	_tmp1_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT COUNT(*) FROM tags WHERE instr(tagID, 'global.') = 0", NULL, (gint) 0);
	rows = _tmp1_;
	_tmp3_ = rows;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1) {
		GeeList* _tmp6_;
		gpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = rows;
		_tmp7_ = gee_list_get (_tmp6_, 0);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_ == 1;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	_vala_assert (_tmp2_, "rows.size == 1 && rows[0].size == 1");
	_tmp11_ = rows;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	_tmp13_ = (GeeList*) _tmp12_;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (sqlite3_value*) _tmp14_;
	_tmp16_ = sqlite3_value_int (_tmp15_);
	_sqlite3_value_free0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	tagCount = _tmp16_;
	result = tagCount % G_N_ELEMENTS (FEED_READER_CONSTANTS_COLORS);
	_g_object_unref0 (rows);
	return result;
}

gboolean
feed_reader_data_base_read_only_tag_still_used (FeedReaderDataBaseReadOnly* self,
                                                FeedReaderTag* tag)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	_tmp0_ = g_strdup ("SELECT 1 FROM main.taggings WHERE tagID = ? LIMIT 1");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = feed_reader_tag_getTagID (tag);
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_take_string (_tmp3_, _tmp2_);
	_tmp4_ = g_new0 (GValue*, 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, query, _tmp5_, (gint) 1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp7_;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) rows);
	_tmp9_ = _tmp8_;
	result = _tmp9_ > 0;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

gchar*
feed_reader_data_base_read_only_getTagName (FeedReaderDataBaseReadOnly* self,
                                            const gchar* tag_id)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gchar* _tmp32_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_id != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT title FROM tags WHERE tagID = ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, tag_id);
	_tmp4_ = g_new0 (GValue*, 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp5_, (gint) 1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp7_;
	_tmp9_ = rows;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 0) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp13_ = rows;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == 1) {
			GeeList* _tmp16_;
			gpointer _tmp17_;
			GeeList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp16_ = rows;
			_tmp17_ = gee_list_get (_tmp16_, 0);
			_tmp18_ = (GeeList*) _tmp17_;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp12_ = _tmp20_ == 1;
			_g_object_unref0 (_tmp18_);
		} else {
			_tmp12_ = FALSE;
		}
		_tmp8_ = _tmp12_;
	}
	_vala_assert (_tmp8_, "rows.size == 0 || (rows.size == 1 && rows[0].size == 1)");
	_tmp21_ = rows;
	_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == 1) {
		GeeList* _tmp24_;
		gpointer _tmp25_;
		GeeList* _tmp26_;
		gpointer _tmp27_;
		sqlite3_value* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = rows;
		_tmp25_ = gee_list_get (_tmp24_, 0);
		_tmp26_ = (GeeList*) _tmp25_;
		_tmp27_ = gee_list_get (_tmp26_, 0);
		_tmp28_ = (sqlite3_value*) _tmp27_;
		_tmp29_ = sqlite3_value_text (_tmp28_);
		_tmp30_ = g_strdup (_tmp29_);
		_tmp31_ = _tmp30_;
		_sqlite3_value_free0 (_tmp28_);
		_g_object_unref0 (_tmp26_);
		result = _tmp31_;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	}
	_tmp32_ = g_strdup (_ ("Unknown tag"));
	result = _tmp32_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

gint
feed_reader_data_base_read_only_getLastModified (FeedReaderDataBaseReadOnly* self)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GeeList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp17_ = FALSE;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_strdup ("SELECT MAX(lastModified) FROM articles");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, NULL, (gint) 0);
	rows = _tmp3_;
	_tmp5_ = rows;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = rows;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == 1) {
			GeeList* _tmp12_;
			gpointer _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp12_ = rows;
			_tmp13_ = gee_list_get (_tmp12_, 0);
			_tmp14_ = (GeeList*) _tmp13_;
			_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp8_ = _tmp16_ == 1;
			_g_object_unref0 (_tmp14_);
		} else {
			_tmp8_ = FALSE;
		}
		_tmp4_ = _tmp8_;
	}
	_vala_assert (_tmp4_, "rows.size == 0 || (rows.size == 1 && rows[0].size == 1)");
	_tmp18_ = rows;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == 1) {
		GeeList* _tmp21_;
		gpointer _tmp22_;
		GeeList* _tmp23_;
		gpointer _tmp24_;
		sqlite3_value* _tmp25_;
		_tmp21_ = rows;
		_tmp22_ = gee_list_get (_tmp21_, 0);
		_tmp23_ = (GeeList*) _tmp22_;
		_tmp24_ = gee_list_get (_tmp23_, 0);
		_tmp25_ = (sqlite3_value*) _tmp24_;
		_tmp17_ = _tmp25_ != NULL;
		_sqlite3_value_free0 (_tmp25_);
		_g_object_unref0 (_tmp23_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GeeList* _tmp26_;
		gpointer _tmp27_;
		GeeList* _tmp28_;
		gpointer _tmp29_;
		sqlite3_value* _tmp30_;
		gint _tmp31_;
		_tmp26_ = rows;
		_tmp27_ = gee_list_get (_tmp26_, 0);
		_tmp28_ = (GeeList*) _tmp27_;
		_tmp29_ = gee_list_get (_tmp28_, 0);
		_tmp30_ = (sqlite3_value*) _tmp29_;
		_tmp31_ = sqlite3_value_int (_tmp30_);
		_sqlite3_value_free0 (_tmp30_);
		_g_object_unref0 (_tmp28_);
		result = _tmp31_;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	} else {
		result = 0;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	}
}

gchar*
feed_reader_data_base_read_only_getCategoryName (FeedReaderDataBaseReadOnly* self,
                                                 const gchar* catID)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* query = NULL;
	gchar* _tmp4_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp5_;
	const gchar* _tmp6_;
	GValue* _tmp7_ = NULL;
	GValue** _tmp8_;
	GValue** _tmp9_;
	gint _tmp9__length1;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	gchar* _result_ = NULL;
	gchar* _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	const gchar* _tmp23_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (catID != NULL, NULL);
	_tmp0_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (catID, _tmp1_) == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("Tags");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("SELECT title FROM categories WHERE categorieID = ?");
	query = _tmp4_;
	_tmp5_ = self->m_db;
	_tmp6_ = query;
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_STRING);
	g_value_set_string (_tmp7_, catID);
	_tmp8_ = g_new0 (GValue*, 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 1;
	_tmp10_ = feed_reader_sq_lite_execute (_tmp5_, _tmp6_, _tmp9_, (gint) 1);
	_tmp11_ = _tmp10_;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp11_;
	_tmp12_ = g_strdup ("");
	_result_ = _tmp12_;
	_tmp13_ = rows;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != 0) {
		GeeList* _tmp16_;
		gpointer _tmp17_;
		GeeList* _tmp18_;
		gpointer _tmp19_;
		sqlite3_value* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp16_ = rows;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		_tmp18_ = (GeeList*) _tmp17_;
		_tmp19_ = gee_list_get (_tmp18_, 0);
		_tmp20_ = (sqlite3_value*) _tmp19_;
		_tmp21_ = sqlite3_value_text (_tmp20_);
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (_result_);
		_result_ = _tmp22_;
		_sqlite3_value_free0 (_tmp20_);
		_g_object_unref0 (_tmp18_);
	}
	_tmp23_ = _result_;
	if (g_strcmp0 (_tmp23_, "") == 0) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup (_ ("Uncategorized"));
		_g_free0 (_result_);
		_result_ = _tmp24_;
	}
	result = _result_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

gchar*
feed_reader_data_base_read_only_getCategoryID (FeedReaderDataBaseReadOnly* self,
                                               const gchar* catname)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (catname != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT categorieID FROM categories WHERE title = ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, catname);
	_tmp4_ = g_new0 (GValue*, 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp5_, (gint) 1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp7_;
	_tmp8_ = rows;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 0) {
		result = NULL;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	} else {
		GeeList* _tmp11_;
		gpointer _tmp12_;
		GeeList* _tmp13_;
		gpointer _tmp14_;
		sqlite3_value* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp11_ = rows;
		_tmp12_ = gee_list_get (_tmp11_, 0);
		_tmp13_ = (GeeList*) _tmp12_;
		_tmp14_ = gee_list_get (_tmp13_, 0);
		_tmp15_ = (sqlite3_value*) _tmp14_;
		_tmp16_ = sqlite3_value_text (_tmp15_);
		_tmp17_ = g_strdup (_tmp16_);
		_tmp18_ = _tmp17_;
		_sqlite3_value_free0 (_tmp15_);
		_g_object_unref0 (_tmp13_);
		result = _tmp18_;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	}
}

gboolean
feed_reader_data_base_read_only_preview_empty (FeedReaderDataBaseReadOnly* self,
                                               const gchar* articleID)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* _tmp17_;
	gpointer _tmp18_;
	GeeList* _tmp19_;
	gpointer _tmp20_;
	sqlite3_value* _tmp21_;
	gboolean _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (articleID != NULL, FALSE);
	_tmp0_ = g_strdup ("SELECT COUNT(*) FROM articles WHERE articleID = ? AND preview != ''");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, articleID);
	_tmp4_ = g_new0 (GValue*, 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp5_, (gint) 1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp7_;
	_tmp9_ = rows;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 1) {
		GeeList* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp12_ = rows;
		_tmp13_ = gee_list_get (_tmp12_, 0);
		_tmp14_ = (GeeList*) _tmp13_;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp8_ = _tmp16_ == 1;
		_g_object_unref0 (_tmp14_);
	} else {
		_tmp8_ = FALSE;
	}
	_vala_assert (_tmp8_, "rows.size == 1 && rows[0].size == 1");
	_tmp17_ = rows;
	_tmp18_ = gee_list_get (_tmp17_, 0);
	_tmp19_ = (GeeList*) _tmp18_;
	_tmp20_ = gee_list_get (_tmp19_, 0);
	_tmp21_ = (sqlite3_value*) _tmp20_;
	_tmp22_ = sqlite3_value_int (_tmp21_) != 0;
	_sqlite3_value_free0 (_tmp21_);
	_g_object_unref0 (_tmp19_);
	result = _tmp22_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_article_between (FeedReaderDataBaseReadOnly* self,
                                                      const gchar* feedID,
                                                      FeedReaderFeedListType selectedType,
                                                      FeedReaderArticleListState state,
                                                      const gchar* searchTerm,
                                                      const gchar* id1,
                                                      GDateTime* date1,
                                                      const gchar* id2,
                                                      GDateTime* date2)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderArticleListSort sorting = 0;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	FeedReaderArticleListSort _tmp3_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp20_;
	FeedReaderQueryBuilder* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	sqlite3_stmt* _tmp24_;
	sqlite3_stmt* _tmp25_;
	GeeArrayList* articles = NULL;
	GeeArrayList* _tmp26_;
	sqlite3_stmt* _tmp64_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (feedID != NULL, NULL);
	g_return_val_if_fail (searchTerm != NULL, NULL);
	g_return_val_if_fail (id1 != NULL, NULL);
	g_return_val_if_fail (date1 != NULL, NULL);
	g_return_val_if_fail (id2 != NULL, NULL);
	g_return_val_if_fail (date2 != NULL, NULL);
	_tmp0_ = feed_reader_data_base_read_only_articleQuery (self, feedID, selectedType, state, searchTerm);
	query = _tmp0_;
	_tmp1_ = feed_reader_settings_general ();
	_tmp2_ = _tmp1_;
	_tmp3_ = (FeedReaderArticleListSort) g_settings_get_enum (_tmp2_, "articlelist-sort-by");
	_g_object_unref0 (_tmp2_);
	sorting = _tmp3_;
	if (sorting == FEED_READER_ARTICLE_LIST_SORT_RECEIVED) {
		FeedReaderQueryBuilder* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = query;
		_tmp5_ = feed_reader_sq_lite_quote_string (id1);
		_tmp6_ = _tmp5_;
		_tmp7_ = feed_reader_sq_lite_quote_string (id2);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("date BETWEEN (SELECT rowid FROM articles WHERE articleID = %s) AND (SE" \
"LECT rowid FROM articles WHERE articleID = %s)", _tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		feed_reader_query_builder_where (_tmp4_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	} else {
		gboolean bigger = FALSE;
		gint64 _tmp11_ = 0LL;
		gint64 biggerDate = 0LL;
		gint64 _tmp12_ = 0LL;
		gint64 smallerDate = 0LL;
		FeedReaderQueryBuilder* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		bigger = g_date_time_to_unix (date1) > g_date_time_to_unix (date2);
		if (bigger) {
			_tmp11_ = g_date_time_to_unix (date1);
		} else {
			_tmp11_ = g_date_time_to_unix (date2);
		}
		biggerDate = _tmp11_;
		if (bigger) {
			_tmp12_ = g_date_time_to_unix (date2);
		} else {
			_tmp12_ = g_date_time_to_unix (date1);
		}
		smallerDate = _tmp12_;
		_tmp13_ = query;
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, smallerDate);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, biggerDate);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("date BETWEEN ", _tmp15_, " AND ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		feed_reader_query_builder_where (_tmp13_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
	}
	_tmp20_ = self->m_db;
	_tmp21_ = query;
	_tmp22_ = feed_reader_query_builder_to_string (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = feed_reader_sq_lite_prepare (_tmp20_, _tmp23_);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	stmt = _tmp25_;
	_tmp26_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp26_;
	while (TRUE) {
		sqlite3_stmt* _tmp27_;
		gboolean _tmp28_ = FALSE;
		sqlite3_stmt* _tmp29_;
		const gchar* _tmp30_;
		GeeArrayList* _tmp33_;
		sqlite3_stmt* _tmp34_;
		const gchar* _tmp35_;
		sqlite3_stmt* _tmp36_;
		const gchar* _tmp37_;
		sqlite3_stmt* _tmp38_;
		const gchar* _tmp39_;
		sqlite3_stmt* _tmp40_;
		const gchar* _tmp41_;
		sqlite3_stmt* _tmp42_;
		sqlite3_stmt* _tmp43_;
		sqlite3_stmt* _tmp44_;
		const gchar* _tmp45_;
		sqlite3_stmt* _tmp46_;
		const gchar* _tmp47_;
		sqlite3_stmt* _tmp48_;
		GDateTime* _tmp49_;
		GDateTime* _tmp50_;
		sqlite3_stmt* _tmp51_;
		sqlite3_stmt* _tmp52_;
		const gchar* _tmp53_;
		GeeList* _tmp54_;
		GeeList* _tmp55_;
		sqlite3_stmt* _tmp56_;
		const gchar* _tmp57_;
		GeeList* _tmp58_;
		GeeList* _tmp59_;
		sqlite3_stmt* _tmp60_;
		const gchar* _tmp61_;
		FeedReaderArticle* _tmp62_;
		FeedReaderArticle* _tmp63_;
		_tmp27_ = stmt;
		if (!(sqlite3_step (_tmp27_) == SQLITE_ROW)) {
			break;
		}
		_tmp29_ = stmt;
		_tmp30_ = sqlite3_column_text (_tmp29_, 2);
		if (g_strcmp0 (_tmp30_, id1) == 0) {
			_tmp28_ = TRUE;
		} else {
			sqlite3_stmt* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = stmt;
			_tmp32_ = sqlite3_column_text (_tmp31_, 2);
			_tmp28_ = g_strcmp0 (_tmp32_, id2) == 0;
		}
		if (_tmp28_) {
			continue;
		}
		_tmp33_ = articles;
		_tmp34_ = stmt;
		_tmp35_ = sqlite3_column_text (_tmp34_, 2);
		_tmp36_ = stmt;
		_tmp37_ = sqlite3_column_text (_tmp36_, 3);
		_tmp38_ = stmt;
		_tmp39_ = sqlite3_column_text (_tmp38_, 5);
		_tmp40_ = stmt;
		_tmp41_ = sqlite3_column_text (_tmp40_, 1);
		_tmp42_ = stmt;
		_tmp43_ = stmt;
		_tmp44_ = stmt;
		_tmp45_ = sqlite3_column_text (_tmp44_, 6);
		_tmp46_ = stmt;
		_tmp47_ = sqlite3_column_text (_tmp46_, 4);
		_tmp48_ = stmt;
		_tmp49_ = g_date_time_new_from_unix_local ((gint64) sqlite3_column_int (_tmp48_, 9));
		_tmp50_ = _tmp49_;
		_tmp51_ = stmt;
		_tmp52_ = stmt;
		_tmp53_ = sqlite3_column_text (_tmp52_, 2);
		_tmp54_ = feed_reader_data_base_read_only_read_taggings_by_article_id (self, _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = stmt;
		_tmp57_ = sqlite3_column_text (_tmp56_, 2);
		_tmp58_ = feed_reader_data_base_read_only_read_enclosures (self, _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = stmt;
		_tmp61_ = sqlite3_column_text (_tmp60_, 10);
		_tmp62_ = feed_reader_article_new (_tmp35_, _tmp37_, _tmp39_, _tmp41_, (FeedReaderArticleStatus) sqlite3_column_int (_tmp42_, 7), (FeedReaderArticleStatus) sqlite3_column_int (_tmp43_, 8), NULL, _tmp45_, _tmp47_, _tmp50_, sqlite3_column_int (_tmp51_, 0), _tmp55_, _tmp59_, _tmp61_, 0);
		_tmp63_ = _tmp62_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp63_);
		_g_object_unref0 (_tmp63_);
		_g_object_unref0 (_tmp59_);
		_g_object_unref0 (_tmp55_);
		_g_date_time_unref0 (_tmp50_);
	}
	_tmp64_ = stmt;
	sqlite3_reset (_tmp64_);
	result = (GeeList*) articles;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

static GeeList*
feed_reader_data_base_read_only_read_enclosures (FeedReaderDataBaseReadOnly* self,
                                                 const gchar* article_id)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* query = NULL;
	gchar* _tmp1_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp2_;
	const gchar* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (article_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = g_strdup ("SELECT url, type FROM Enclosures WHERE articleID = ?");
	query = _tmp1_;
	_tmp2_ = self->m_db;
	_tmp3_ = query;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, article_id);
	_tmp5_ = g_new0 (GValue*, 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp2_, _tmp3_, _tmp6_, (gint) 1);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp8_;
	{
		GeeList* _row_list = NULL;
		GeeList* _tmp9_;
		gint _row_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _row_index = 0;
		_tmp9_ = rows;
		_row_list = _tmp9_;
		_tmp10_ = _row_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_row_size = _tmp12_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			GeeList* row = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			GeeArrayList* _tmp17_;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			sqlite3_value* _tmp20_;
			const gchar* _tmp21_;
			GeeList* _tmp22_;
			gpointer _tmp23_;
			sqlite3_value* _tmp24_;
			FeedReaderEnclosure* _tmp25_;
			FeedReaderEnclosure* _tmp26_;
			_row_index = _row_index + 1;
			_tmp13_ = _row_index;
			_tmp14_ = _row_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _row_list;
			_tmp16_ = gee_list_get (_tmp15_, _row_index);
			row = (GeeList*) _tmp16_;
			_tmp17_ = list;
			_tmp18_ = row;
			_tmp19_ = gee_list_get (_tmp18_, 0);
			_tmp20_ = (sqlite3_value*) _tmp19_;
			_tmp21_ = sqlite3_value_text (_tmp20_);
			_tmp22_ = row;
			_tmp23_ = gee_list_get (_tmp22_, 1);
			_tmp24_ = (sqlite3_value*) _tmp23_;
			_tmp25_ = feed_reader_enclosure_new (article_id, _tmp21_, (FeedReaderEnclosureType) sqlite3_value_int (_tmp24_));
			_tmp26_ = _tmp25_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp26_);
			_g_object_unref0 (_tmp26_);
			_sqlite3_value_free0 (_tmp24_);
			_sqlite3_value_free0 (_tmp20_);
			_g_object_unref0 (row);
		}
	}
	result = (GeeList*) list;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

GeeHashMap*
feed_reader_data_base_read_only_read_article_stats (FeedReaderDataBaseReadOnly* self,
                                                    GeeList* ids)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	GeeHashMap* articles = NULL;
	GeeHashMap* _tmp9_;
	sqlite3_stmt* _tmp22_;
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ids != NULL, NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "articles");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_select_field (_tmp1_, "articleID, unread, marked");
	_tmp2_ = query;
	feed_reader_query_builder_where_in_strings (_tmp2_, "articleID", ids);
	_tmp3_ = self->m_db;
	_tmp4_ = query;
	_tmp5_ = feed_reader_query_builder_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_sq_lite_prepare (_tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	stmt = _tmp8_;
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	articles = _tmp9_;
	while (TRUE) {
		sqlite3_stmt* _tmp10_;
		GeeHashMap* _tmp11_;
		sqlite3_stmt* _tmp12_;
		const gchar* _tmp13_;
		sqlite3_stmt* _tmp14_;
		const gchar* _tmp15_;
		sqlite3_stmt* _tmp16_;
		sqlite3_stmt* _tmp17_;
		GDateTime* _tmp18_;
		GDateTime* _tmp19_;
		FeedReaderArticle* _tmp20_;
		FeedReaderArticle* _tmp21_;
		_tmp10_ = stmt;
		if (!(sqlite3_step (_tmp10_) == SQLITE_ROW)) {
			break;
		}
		_tmp11_ = articles;
		_tmp12_ = stmt;
		_tmp13_ = sqlite3_column_text (_tmp12_, 0);
		_tmp14_ = stmt;
		_tmp15_ = sqlite3_column_text (_tmp14_, 0);
		_tmp16_ = stmt;
		_tmp17_ = stmt;
		_tmp18_ = g_date_time_new_now_local ();
		_tmp19_ = _tmp18_;
		_tmp20_ = feed_reader_article_new (_tmp15_, NULL, NULL, NULL, (FeedReaderArticleStatus) sqlite3_column_int (_tmp16_, 1), (FeedReaderArticleStatus) sqlite3_column_int (_tmp17_, 2), NULL, NULL, NULL, _tmp19_, 0, NULL, NULL, "", 0);
		_tmp21_ = _tmp20_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp13_, _tmp21_);
		_g_object_unref0 (_tmp21_);
		_g_date_time_unref0 (_tmp19_);
	}
	_tmp22_ = stmt;
	sqlite3_reset (_tmp22_);
	result = articles;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

FeedReaderArticle*
feed_reader_data_base_read_only_read_article (FeedReaderDataBaseReadOnly* self,
                                              const gchar* articleID)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* row = NULL;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	gchar* author = NULL;
	GeeList* _tmp14_;
	gpointer _tmp15_;
	sqlite3_value* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GeeList* _tmp21_;
	gpointer _tmp22_;
	sqlite3_value* _tmp23_;
	const gchar* _tmp24_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	sqlite3_value* _tmp27_;
	const gchar* _tmp28_;
	GeeList* _tmp29_;
	gpointer _tmp30_;
	sqlite3_value* _tmp31_;
	const gchar* _tmp32_;
	GeeList* _tmp33_;
	gpointer _tmp34_;
	sqlite3_value* _tmp35_;
	GeeList* _tmp36_;
	gpointer _tmp37_;
	sqlite3_value* _tmp38_;
	GeeList* _tmp39_;
	gpointer _tmp40_;
	sqlite3_value* _tmp41_;
	const gchar* _tmp42_;
	GeeList* _tmp43_;
	gpointer _tmp44_;
	sqlite3_value* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	GeeList* _tmp48_;
	gpointer _tmp49_;
	sqlite3_value* _tmp50_;
	GDateTime* _tmp51_;
	GDateTime* _tmp52_;
	GeeList* _tmp53_;
	gpointer _tmp54_;
	sqlite3_value* _tmp55_;
	GeeList* _tmp56_;
	GeeList* _tmp57_;
	GeeList* _tmp58_;
	GeeList* _tmp59_;
	GeeList* _tmp60_;
	gpointer _tmp61_;
	sqlite3_value* _tmp62_;
	const gchar* _tmp63_;
	FeedReaderArticle* _tmp64_;
	FeedReaderArticle* _tmp65_;
	FeedReaderArticle* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articleID != NULL, NULL);
	_tmp0_ = string_to_string (articleID);
	_tmp1_ = g_strconcat ("DataBaseReadOnly.read_article(): ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->m_db;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, articleID);
	_tmp5_ = g_new0 (GValue*, 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp3_, "SELECT ROWID, * FROM articles WHERE articleID = ?", _tmp6_, (gint) 1);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp8_;
	_tmp9_ = rows;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 0) {
		result = NULL;
		_g_object_unref0 (rows);
		return result;
	}
	_tmp12_ = rows;
	_tmp13_ = gee_list_get (_tmp12_, 0);
	row = (GeeList*) _tmp13_;
	_tmp14_ = row;
	_tmp15_ = gee_list_get (_tmp14_, 4);
	_tmp16_ = (sqlite3_value*) _tmp15_;
	_tmp17_ = sqlite3_value_text (_tmp16_);
	_tmp18_ = g_strdup (_tmp17_);
	_tmp19_ = _tmp18_;
	_sqlite3_value_free0 (_tmp16_);
	author = _tmp19_;
	_tmp20_ = author;
	if (g_strcmp0 (_tmp20_, "") == 0) {
		_g_free0 (author);
		author = NULL;
	}
	_tmp21_ = row;
	_tmp22_ = gee_list_get (_tmp21_, 3);
	_tmp23_ = (sqlite3_value*) _tmp22_;
	_tmp24_ = sqlite3_value_text (_tmp23_);
	_tmp25_ = row;
	_tmp26_ = gee_list_get (_tmp25_, 5);
	_tmp27_ = (sqlite3_value*) _tmp26_;
	_tmp28_ = sqlite3_value_text (_tmp27_);
	_tmp29_ = row;
	_tmp30_ = gee_list_get (_tmp29_, 2);
	_tmp31_ = (sqlite3_value*) _tmp30_;
	_tmp32_ = sqlite3_value_text (_tmp31_);
	_tmp33_ = row;
	_tmp34_ = gee_list_get (_tmp33_, 8);
	_tmp35_ = (sqlite3_value*) _tmp34_;
	_tmp36_ = row;
	_tmp37_ = gee_list_get (_tmp36_, 9);
	_tmp38_ = (sqlite3_value*) _tmp37_;
	_tmp39_ = row;
	_tmp40_ = gee_list_get (_tmp39_, 6);
	_tmp41_ = (sqlite3_value*) _tmp40_;
	_tmp42_ = sqlite3_value_text (_tmp41_);
	_tmp43_ = row;
	_tmp44_ = gee_list_get (_tmp43_, 7);
	_tmp45_ = (sqlite3_value*) _tmp44_;
	_tmp46_ = sqlite3_value_text (_tmp45_);
	_tmp47_ = author;
	_tmp48_ = row;
	_tmp49_ = gee_list_get (_tmp48_, 10);
	_tmp50_ = (sqlite3_value*) _tmp49_;
	_tmp51_ = g_date_time_new_from_unix_local ((gint64) sqlite3_value_int (_tmp50_));
	_tmp52_ = _tmp51_;
	_tmp53_ = row;
	_tmp54_ = gee_list_get (_tmp53_, 0);
	_tmp55_ = (sqlite3_value*) _tmp54_;
	_tmp56_ = feed_reader_data_base_read_only_read_taggings_by_article_id (self, articleID);
	_tmp57_ = _tmp56_;
	_tmp58_ = feed_reader_data_base_read_only_read_enclosures (self, articleID);
	_tmp59_ = _tmp58_;
	_tmp60_ = row;
	_tmp61_ = gee_list_get (_tmp60_, 11);
	_tmp62_ = (sqlite3_value*) _tmp61_;
	_tmp63_ = sqlite3_value_text (_tmp62_);
	_tmp64_ = feed_reader_article_new (articleID, _tmp24_, _tmp28_, _tmp32_, (FeedReaderArticleStatus) sqlite3_value_int (_tmp35_), (FeedReaderArticleStatus) sqlite3_value_int (_tmp38_), _tmp42_, _tmp46_, _tmp47_, _tmp52_, sqlite3_value_int (_tmp55_), _tmp57_, _tmp59_, _tmp63_, 0);
	_tmp65_ = _tmp64_;
	_sqlite3_value_free0 (_tmp62_);
	_g_object_unref0 (_tmp59_);
	_g_object_unref0 (_tmp57_);
	_sqlite3_value_free0 (_tmp55_);
	_g_date_time_unref0 (_tmp52_);
	_sqlite3_value_free0 (_tmp50_);
	_sqlite3_value_free0 (_tmp45_);
	_sqlite3_value_free0 (_tmp41_);
	_sqlite3_value_free0 (_tmp38_);
	_sqlite3_value_free0 (_tmp35_);
	_sqlite3_value_free0 (_tmp31_);
	_sqlite3_value_free0 (_tmp27_);
	_sqlite3_value_free0 (_tmp23_);
	result = _tmp65_;
	_g_free0 (author);
	_g_object_unref0 (row);
	_g_object_unref0 (rows);
	return result;
}

gint
feed_reader_data_base_read_only_getMaxCatLevel (FeedReaderDataBaseReadOnly* self)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GeeList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint maxCatLevel = 0;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	sqlite3_value* _tmp15_;
	gint _tmp16_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->m_db;
	_tmp1_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT MAX(Level) FROM categories", NULL, (gint) 0);
	rows = _tmp1_;
	_tmp3_ = rows;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1) {
		GeeList* _tmp6_;
		gpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = rows;
		_tmp7_ = gee_list_get (_tmp6_, 0);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_ == 1;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	_vala_assert (_tmp2_, "rows.size == 1 && rows[0].size == 1");
	_tmp11_ = rows;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	_tmp13_ = (GeeList*) _tmp12_;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (sqlite3_value*) _tmp14_;
	_tmp16_ = sqlite3_value_int (_tmp15_);
	_sqlite3_value_free0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	maxCatLevel = _tmp16_;
	if (maxCatLevel == 0) {
		maxCatLevel = 1;
	}
	result = maxCatLevel;
	_g_object_unref0 (rows);
	return result;
}

gboolean
feed_reader_data_base_read_only_haveFeedsWithoutCat (FeedReaderDataBaseReadOnly* self)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "feeds");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_select_field (_tmp1_, "count(*)");
	_tmp2_ = query;
	_tmp3_ = feed_reader_data_base_read_only_getUncategorizedQuery (self);
	_tmp4_ = _tmp3_;
	feed_reader_query_builder_where (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->m_db;
	_tmp6_ = query;
	_tmp7_ = feed_reader_query_builder_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = feed_reader_sq_lite_prepare (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	stmt = _tmp10_;
	while (TRUE) {
		sqlite3_stmt* _tmp11_;
		gint count = 0;
		sqlite3_stmt* _tmp12_;
		_tmp11_ = stmt;
		if (!(sqlite3_step (_tmp11_) == SQLITE_ROW)) {
			break;
		}
		_tmp12_ = stmt;
		count = sqlite3_column_int (_tmp12_, 0);
		if (count > 0) {
			result = TRUE;
			_sqlite3_finalize0 (stmt);
			_g_object_unref0 (query);
			return result;
		}
	}
	result = FALSE;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

gboolean
feed_reader_data_base_read_only_haveCategories (FeedReaderDataBaseReadOnly* self)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GeeList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	sqlite3_value* _tmp15_;
	gboolean _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->m_db;
	_tmp1_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT COUNT(*) FROM categories", NULL, (gint) 0);
	rows = _tmp1_;
	_tmp3_ = rows;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1) {
		GeeList* _tmp6_;
		gpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = rows;
		_tmp7_ = gee_list_get (_tmp6_, 0);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_ == 1;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	_vala_assert (_tmp2_, "rows.size == 1 && rows[0].size == 1");
	_tmp11_ = rows;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	_tmp13_ = (GeeList*) _tmp12_;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (sqlite3_value*) _tmp14_;
	_tmp16_ = sqlite3_value_int (_tmp15_) > 0;
	_sqlite3_value_free0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	result = _tmp16_;
	_g_object_unref0 (rows);
	return result;
}

gboolean
feed_reader_data_base_read_only_article_exists (FeedReaderDataBaseReadOnly* self,
                                                const gchar* articleID)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (articleID != NULL, FALSE);
	_tmp0_ = self->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_STRING);
	g_value_set_string (_tmp1_, articleID);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT 1 FROM articles WHERE articleID = ? LIMIT 1", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp5_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) rows);
	_tmp7_ = _tmp6_;
	result = _tmp7_ != 0;
	_g_object_unref0 (rows);
	return result;
}

gint
feed_reader_data_base_read_only_getArticleCountNewerThanID (FeedReaderDataBaseReadOnly* self,
                                                            const gchar* articleID,
                                                            const gchar* feedID,
                                                            FeedReaderFeedListType selectedType,
                                                            FeedReaderArticleListState state,
                                                            const gchar* searchTerm)
{
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	gchar* order_by = NULL;
	gchar* _tmp4_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	FeedReaderQueryBuilder* query2 = NULL;
	FeedReaderQueryBuilder* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	FeedReaderQueryBuilder* _tmp9_;
	const gchar* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp34_ = FALSE;
	gboolean desc = FALSE;
	GSettings* _tmp70_;
	GSettings* _tmp71_;
	gboolean _tmp72_;
	FeedReaderQueryBuilder* _tmp73_;
	const gchar* _tmp74_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp75_;
	FeedReaderQueryBuilder* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	sqlite3_stmt* _tmp79_;
	sqlite3_stmt* _tmp80_;
	gint res = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (articleID != NULL, 0);
	g_return_val_if_fail (feedID != NULL, 0);
	g_return_val_if_fail (searchTerm != NULL, 0);
	_tmp1_ = feed_reader_settings_general ();
	_tmp2_ = _tmp1_;
	_tmp3_ = ((FeedReaderArticleListSort) g_settings_get_enum (_tmp2_, "articlelist-sort-by")) == FEED_READER_ARTICLE_LIST_SORT_RECEIVED;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = "rowid";
	} else {
		_tmp0_ = "date";
	}
	_tmp4_ = g_strdup (_tmp0_);
	order_by = _tmp4_;
	_tmp5_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "articles");
	query = _tmp5_;
	_tmp6_ = query;
	feed_reader_query_builder_where_equal_string (_tmp6_, "articleID", articleID);
	_tmp7_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "articles");
	query2 = _tmp7_;
	_tmp8_ = query2;
	feed_reader_query_builder_select_field (_tmp8_, "count(*)");
	_tmp9_ = query;
	_tmp10_ = order_by;
	feed_reader_query_builder_select_field (_tmp9_, _tmp10_);
	_tmp11_ = feed_reader_settings_general ();
	_tmp12_ = _tmp11_;
	_tmp13_ = g_settings_get_boolean (_tmp12_, "articlelist-oldest-first");
	_g_object_unref0 (_tmp12_);
	if (_tmp13_) {
		FeedReaderQueryBuilder* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		FeedReaderQueryBuilder* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp14_ = query2;
		_tmp15_ = order_by;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat (_tmp16_, " < (%s)", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = query;
		_tmp20_ = feed_reader_query_builder_to_string (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf (_tmp18_, _tmp21_);
		_tmp23_ = _tmp22_;
		feed_reader_query_builder_where (_tmp14_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
	} else {
		FeedReaderQueryBuilder* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		FeedReaderQueryBuilder* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp24_ = query2;
		_tmp25_ = order_by;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat (_tmp26_, " > (%s)", NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = query;
		_tmp30_ = feed_reader_query_builder_to_string (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf (_tmp28_, _tmp31_);
		_tmp33_ = _tmp32_;
		feed_reader_query_builder_where (_tmp24_, _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp28_);
	}
	if (selectedType == FEED_READER_FEED_LIST_TYPE_FEED) {
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
		_tmp36_ = _tmp35_;
		_tmp34_ = g_strcmp0 (feedID, _tmp36_) != 0;
		_g_free0 (_tmp36_);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		FeedReaderQueryBuilder* _tmp37_;
		_tmp37_ = query2;
		feed_reader_query_builder_where_equal_string (_tmp37_, "feedID", feedID);
	} else {
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		if (selectedType == FEED_READER_FEED_LIST_TYPE_CATEGORY) {
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp40_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
			_tmp41_ = _tmp40_;
			_tmp39_ = g_strcmp0 (feedID, _tmp41_) != 0;
			_g_free0 (_tmp41_);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp42_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
			_tmp43_ = _tmp42_;
			_tmp38_ = g_strcmp0 (feedID, _tmp43_) != 0;
			_g_free0 (_tmp43_);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			FeedReaderQueryBuilder* _tmp44_;
			GeeList* _tmp45_;
			GeeList* _tmp46_;
			_tmp44_ = query2;
			_tmp45_ = feed_reader_data_base_read_only_getFeedIDofCategorie (self, feedID);
			_tmp46_ = _tmp45_;
			feed_reader_query_builder_where_in_strings (_tmp44_, "feedID", _tmp46_);
			_g_object_unref0 (_tmp46_);
		} else {
			gchar* _tmp47_;
			gchar* _tmp48_;
			gboolean _tmp49_;
			_tmp47_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strcmp0 (feedID, _tmp48_) == 0;
			_g_free0 (_tmp48_);
			if (_tmp49_) {
				FeedReaderQueryBuilder* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp50_ = query2;
				_tmp51_ = feed_reader_data_base_read_only_getAllTagsCondition (self);
				_tmp52_ = _tmp51_;
				feed_reader_query_builder_where (_tmp50_, _tmp52_);
				_g_free0 (_tmp52_);
			} else {
				if (selectedType == FEED_READER_FEED_LIST_TYPE_TAG) {
					FeedReaderQueryBuilder* _tmp53_;
					GeeList* _tmp54_;
					GeeList* _tmp55_;
					_tmp53_ = query2;
					_tmp54_ = feed_reader_data_base_read_only_read_taggings_by_tag_id (self, feedID);
					_tmp55_ = _tmp54_;
					feed_reader_query_builder_where_in_strings (_tmp53_, "articleID", _tmp55_);
					_g_object_unref0 (_tmp55_);
				}
			}
		}
	}
	if (state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
		FeedReaderQueryBuilder* _tmp56_;
		_tmp56_ = query2;
		feed_reader_query_builder_where_equal_int (_tmp56_, "unread", (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_UNREAD));
	} else {
		if (state == FEED_READER_ARTICLE_LIST_STATE_MARKED) {
			FeedReaderQueryBuilder* _tmp57_;
			_tmp57_ = query2;
			feed_reader_query_builder_where_equal_int (_tmp57_, "marked", (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_MARKED));
		}
	}
	if (g_strcmp0 (searchTerm, "") != 0) {
		gchar* search_column = NULL;
		FeedReaderQueryBuilder* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		if (g_str_has_prefix (searchTerm, "title: ")) {
			gchar* _tmp58_;
			_tmp58_ = g_strdup ("title");
			_g_free0 (search_column);
			search_column = _tmp58_;
		} else {
			if (g_str_has_prefix (searchTerm, "author: ")) {
				gchar* _tmp59_;
				_tmp59_ = g_strdup ("author");
				_g_free0 (search_column);
				search_column = _tmp59_;
			} else {
				if (g_str_has_prefix (searchTerm, "content: ")) {
					gchar* _tmp60_;
					_tmp60_ = g_strdup ("preview");
					_g_free0 (search_column);
					search_column = _tmp60_;
				} else {
					gchar* _tmp61_;
					_tmp61_ = g_strdup ("fts_table");
					_g_free0 (search_column);
					search_column = _tmp61_;
				}
			}
		}
		_tmp62_ = query2;
		_tmp63_ = search_column;
		_tmp64_ = feed_reader_utils_prepareSearchQuery (searchTerm);
		_tmp65_ = _tmp64_;
		_tmp66_ = feed_reader_sq_lite_quote_string (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strdup_printf ("articleID IN (SELECT articleID FROM fts_table WHERE %s MATCH %s)", _tmp63_, _tmp67_);
		_tmp69_ = _tmp68_;
		feed_reader_query_builder_where (_tmp62_, _tmp69_);
		_g_free0 (_tmp69_);
		_g_free0 (_tmp67_);
		_g_free0 (_tmp65_);
		_g_free0 (search_column);
	}
	desc = TRUE;
	_tmp70_ = feed_reader_settings_general ();
	_tmp71_ = _tmp70_;
	_tmp72_ = g_settings_get_boolean (_tmp71_, "articlelist-oldest-first");
	_g_object_unref0 (_tmp71_);
	if (_tmp72_) {
		desc = FALSE;
	}
	_tmp73_ = query2;
	_tmp74_ = order_by;
	feed_reader_query_builder_order_by (_tmp73_, _tmp74_, desc);
	_tmp75_ = self->m_db;
	_tmp76_ = query2;
	_tmp77_ = feed_reader_query_builder_to_string (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = feed_reader_sq_lite_prepare (_tmp75_, _tmp78_);
	_tmp80_ = _tmp79_;
	_g_free0 (_tmp78_);
	stmt = _tmp80_;
	res = 0;
	while (TRUE) {
		sqlite3_stmt* _tmp81_;
		sqlite3_stmt* _tmp82_;
		_tmp81_ = stmt;
		if (!(sqlite3_step (_tmp81_) == SQLITE_ROW)) {
			break;
		}
		_tmp82_ = stmt;
		res = sqlite3_column_int (_tmp82_, 0);
	}
	result = res;
	_vala_warn_if_fail (result >= 0, "result >= 0");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query2);
	_g_object_unref0 (query);
	_g_free0 (order_by);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

GeeList*
feed_reader_data_base_read_only_getFeedIDofCategorie (FeedReaderDataBaseReadOnly* self,
                                                      const gchar* categorieID)
{
	GeeArrayList* feedIDs = NULL;
	GeeArrayList* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (categorieID != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	feedIDs = _tmp0_;
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "feeds");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_select_field (_tmp2_, "feed_id, category_id");
	_tmp3_ = self->m_db;
	_tmp4_ = query;
	_tmp5_ = feed_reader_query_builder_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_sq_lite_prepare (_tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	stmt = _tmp8_;
	while (TRUE) {
		sqlite3_stmt* _tmp9_;
		gchar* catString = NULL;
		sqlite3_stmt* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** categories = NULL;
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint categories_length1;
		gint _categories_size_;
		_tmp9_ = stmt;
		if (!(sqlite3_step (_tmp9_) == SQLITE_ROW)) {
			break;
		}
		_tmp10_ = stmt;
		_tmp11_ = sqlite3_column_text (_tmp10_, 1);
		_tmp12_ = g_strdup (_tmp11_);
		catString = _tmp12_;
		_tmp13_ = catString;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ",", 0);
		categories = _tmp15_;
		categories_length1 = _vala_array_length (_tmp14_);
		_categories_size_ = categories_length1;
		if (g_strcmp0 (categorieID, "") == 0) {
			gboolean _tmp16_ = FALSE;
			gchar** _tmp17_;
			gint _tmp17__length1;
			_tmp17_ = categories;
			_tmp17__length1 = categories_length1;
			if (_tmp17__length1 == 0) {
				_tmp16_ = TRUE;
			} else {
				gboolean _tmp18_ = FALSE;
				gchar** _tmp19_;
				gint _tmp19__length1;
				_tmp19_ = categories;
				_tmp19__length1 = categories_length1;
				if (_tmp19__length1 == 1) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					_tmp20_ = categories;
					_tmp20__length1 = categories_length1;
					_tmp21_ = _tmp20_[0];
					_tmp18_ = string_contains (_tmp21_, "global.must");
				} else {
					_tmp18_ = FALSE;
				}
				_tmp16_ = _tmp18_;
			}
			if (_tmp16_) {
				GeeArrayList* _tmp22_;
				sqlite3_stmt* _tmp23_;
				const gchar* _tmp24_;
				_tmp22_ = feedIDs;
				_tmp23_ = stmt;
				_tmp24_ = sqlite3_column_text (_tmp23_, 0);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
			}
		} else {
			gchar** _tmp25_;
			gint _tmp25__length1;
			_tmp25_ = categories;
			_tmp25__length1 = categories_length1;
			{
				gchar** cat_collection = NULL;
				gint cat_collection_length1 = 0;
				gint _cat_collection_size_ = 0;
				gint cat_it = 0;
				cat_collection = _tmp25_;
				cat_collection_length1 = _tmp25__length1;
				for (cat_it = 0; cat_it < cat_collection_length1; cat_it = cat_it + 1) {
					gchar* _tmp26_;
					gchar* cat = NULL;
					_tmp26_ = g_strdup (cat_collection[cat_it]);
					cat = _tmp26_;
					{
						const gchar* _tmp27_;
						_tmp27_ = cat;
						if (g_strcmp0 (_tmp27_, categorieID) == 0) {
							GeeArrayList* _tmp28_;
							sqlite3_stmt* _tmp29_;
							const gchar* _tmp30_;
							_tmp28_ = feedIDs;
							_tmp29_ = stmt;
							_tmp30_ = sqlite3_column_text (_tmp29_, 0);
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp30_);
						}
						_g_free0 (cat);
					}
				}
			}
		}
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (catString);
	}
	result = (GeeList*) feedIDs;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

gchar*
feed_reader_data_base_read_only_getUncategorizedQuery (FeedReaderDataBaseReadOnly* self)
{
	gchar* catID = NULL;
	FeedReaderFeedServer* _tmp0_;
	FeedReaderFeedServer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = feed_reader_feed_server_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_feed_server_uncategorizedID (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	catID = _tmp3_;
	_tmp4_ = feed_reader_sq_lite_quote_string (catID);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("category_id = %s", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	_g_free0 (catID);
	return result;
}

gboolean
feed_reader_data_base_read_only_showCategory (FeedReaderDataBaseReadOnly* self,
                                              const gchar* catID,
                                              GeeList* feeds)
{
	gboolean _tmp0_ = FALSE;
	FeedReaderFeedServer* _tmp1_;
	FeedReaderFeedServer* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (catID != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp1_ = feed_reader_feed_server_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_feed_server_hideCategoryWhenEmpty (_tmp2_, catID);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = !feed_reader_utils_categoryIsPopulated (catID, feeds);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gchar*
feed_reader_data_base_read_only_getFeedIDofArticle (FeedReaderDataBaseReadOnly* self,
                                                    const gchar* articleID)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	gchar* id = NULL;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articleID != NULL, NULL);
	_tmp0_ = self->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_STRING);
	g_value_set_string (_tmp1_, articleID);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT feedID FROM articles WHERE articleID = ?", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp5_;
	id = NULL;
	_tmp6_ = rows;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != 0) {
		GeeList* _tmp9_;
		gpointer _tmp10_;
		GeeList* _tmp11_;
		gpointer _tmp12_;
		sqlite3_value* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = rows;
		_tmp10_ = gee_list_get (_tmp9_, 0);
		_tmp11_ = (GeeList*) _tmp10_;
		_tmp12_ = gee_list_get (_tmp11_, 0);
		_tmp13_ = (sqlite3_value*) _tmp12_;
		_tmp14_ = sqlite3_value_text (_tmp13_);
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (id);
		id = _tmp15_;
		_sqlite3_value_free0 (_tmp13_);
		_g_object_unref0 (_tmp11_);
	}
	_tmp16_ = id;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = g_strdup ("");
		_g_free0 (id);
		id = _tmp17_;
	}
	result = id;
	_g_object_unref0 (rows);
	return result;
}

gchar*
feed_reader_data_base_read_only_getNewestArticle (FeedReaderDataBaseReadOnly* self)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	gchar* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue** _tmp3_;
	GValue** _tmp4_;
	gint _tmp4__length1;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	sqlite3_value* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_db;
	_tmp1_ = feed_reader_data_base_read_only_getMaxID (self, "articles", "rowid");
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_STRING);
	g_value_take_string (_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue*, 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT articleID FROM articles WHERE rowid = ?", _tmp4_, (gint) 1);
	_tmp6_ = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp6_;
	_tmp7_ = rows;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 0) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		_g_object_unref0 (rows);
		return result;
	}
	_tmp11_ = rows;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	_tmp13_ = (GeeList*) _tmp12_;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (sqlite3_value*) _tmp14_;
	_tmp16_ = sqlite3_value_text (_tmp15_);
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = _tmp17_;
	_sqlite3_value_free0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	result = _tmp18_;
	_g_object_unref0 (rows);
	return result;
}

gchar*
feed_reader_data_base_read_only_getMaxID (FeedReaderDataBaseReadOnly* self,
                                          const gchar* table,
                                          const gchar* field)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gchar* id = NULL;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	const gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (field != NULL, NULL);
	_tmp0_ = self->m_db;
	_tmp1_ = string_to_string (field);
	_tmp2_ = string_to_string (table);
	_tmp3_ = g_strconcat ("SELECT MAX(", _tmp1_, ") FROM ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = feed_reader_sq_lite_execute (_tmp0_, _tmp4_, NULL, (gint) 0);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	rows = _tmp6_;
	id = NULL;
	_tmp7_ = rows;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		GeeList* _tmp10_;
		gpointer _tmp11_;
		GeeList* _tmp12_;
		gpointer _tmp13_;
		sqlite3_value* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp10_ = rows;
		_tmp11_ = gee_list_get (_tmp10_, 0);
		_tmp12_ = (GeeList*) _tmp11_;
		_tmp13_ = gee_list_get (_tmp12_, 0);
		_tmp14_ = (sqlite3_value*) _tmp13_;
		_tmp15_ = sqlite3_value_text (_tmp14_);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (id);
		id = _tmp16_;
		_sqlite3_value_free0 (_tmp14_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp17_ = id;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("");
		_g_free0 (id);
		id = _tmp18_;
	}
	result = id;
	_g_object_unref0 (rows);
	return result;
}

gboolean
feed_reader_data_base_read_only_feed_exists (FeedReaderDataBaseReadOnly* self,
                                             const gchar* xml_url)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	GeeList* _tmp17_;
	gpointer _tmp18_;
	sqlite3_value* _tmp19_;
	gboolean _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (xml_url != NULL, FALSE);
	_tmp0_ = self->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_STRING);
	g_value_set_string (_tmp1_, xml_url);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT COUNT(*) FROM main.feeds WHERE xmlURL = ? LIMIT 1", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp5_;
	_tmp7_ = rows;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 1) {
		GeeList* _tmp10_;
		gpointer _tmp11_;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp10_ = rows;
		_tmp11_ = gee_list_get (_tmp10_, 0);
		_tmp12_ = (GeeList*) _tmp11_;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp6_ = _tmp14_ == 1;
		_g_object_unref0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	_vala_assert (_tmp6_, "rows.size == 1 && rows[0].size == 1");
	_tmp15_ = rows;
	_tmp16_ = gee_list_get (_tmp15_, 0);
	_tmp17_ = (GeeList*) _tmp16_;
	_tmp18_ = gee_list_get (_tmp17_, 0);
	_tmp19_ = (sqlite3_value*) _tmp18_;
	_tmp20_ = sqlite3_value_int (_tmp19_) > 0;
	_sqlite3_value_free0 (_tmp19_);
	_g_object_unref0 (_tmp17_);
	result = _tmp20_;
	_g_object_unref0 (rows);
	return result;
}

FeedReaderFeed*
feed_reader_data_base_read_only_read_feed (FeedReaderDataBaseReadOnly* self,
                                           const gchar* feedID)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeList* row = NULL;
	GeeList* _tmp9_;
	gpointer _tmp10_;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	sqlite3_value* _tmp13_;
	const gchar* _tmp14_;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	sqlite3_value* _tmp17_;
	const gchar* _tmp18_;
	GeeList* _tmp19_;
	gpointer _tmp20_;
	sqlite3_value* _tmp21_;
	const gchar* _tmp22_;
	GeeList* _tmp23_;
	GeeList* _tmp24_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	sqlite3_value* _tmp27_;
	const gchar* _tmp28_;
	GeeList* _tmp29_;
	gpointer _tmp30_;
	sqlite3_value* _tmp31_;
	const gchar* _tmp32_;
	FeedReaderFeed* _tmp33_;
	FeedReaderFeed* _tmp34_;
	FeedReaderFeed* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (feedID != NULL, NULL);
	_tmp0_ = self->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_STRING);
	g_value_set_string (_tmp1_, feedID);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT * FROM feeds WHERE feed_id = ?", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp5_;
	_tmp6_ = rows;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		result = NULL;
		_g_object_unref0 (rows);
		return result;
	}
	_tmp9_ = rows;
	_tmp10_ = gee_list_get (_tmp9_, 0);
	row = (GeeList*) _tmp10_;
	_tmp11_ = row;
	_tmp12_ = gee_list_get (_tmp11_, 1);
	_tmp13_ = (sqlite3_value*) _tmp12_;
	_tmp14_ = sqlite3_value_text (_tmp13_);
	_tmp15_ = row;
	_tmp16_ = gee_list_get (_tmp15_, 2);
	_tmp17_ = (sqlite3_value*) _tmp16_;
	_tmp18_ = sqlite3_value_text (_tmp17_);
	_tmp19_ = row;
	_tmp20_ = gee_list_get (_tmp19_, 3);
	_tmp21_ = (sqlite3_value*) _tmp20_;
	_tmp22_ = sqlite3_value_text (_tmp21_);
	_tmp23_ = feed_reader_string_utils_split (_tmp22_, ",", TRUE);
	_tmp24_ = _tmp23_;
	_tmp25_ = row;
	_tmp26_ = gee_list_get (_tmp25_, 6);
	_tmp27_ = (sqlite3_value*) _tmp26_;
	_tmp28_ = sqlite3_value_text (_tmp27_);
	_tmp29_ = row;
	_tmp30_ = gee_list_get (_tmp29_, 5);
	_tmp31_ = (sqlite3_value*) _tmp30_;
	_tmp32_ = sqlite3_value_text (_tmp31_);
	_tmp33_ = feed_reader_feed_new (feedID, _tmp14_, _tmp18_, feed_reader_data_base_read_only_getFeedUnread (self, feedID), _tmp24_, _tmp28_, _tmp32_);
	_tmp34_ = _tmp33_;
	_sqlite3_value_free0 (_tmp31_);
	_sqlite3_value_free0 (_tmp27_);
	_g_object_unref0 (_tmp24_);
	_sqlite3_value_free0 (_tmp21_);
	_sqlite3_value_free0 (_tmp17_);
	_sqlite3_value_free0 (_tmp13_);
	result = _tmp34_;
	_g_object_unref0 (row);
	_g_object_unref0 (rows);
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_feeds (FeedReaderDataBaseReadOnly* self,
                                            gboolean starredCount)
{
	GeeList* feeds = NULL;
	GeeArrayList* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gboolean _tmp5_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_FEED, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	feeds = (GeeList*) _tmp0_;
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "feeds");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_select_field (_tmp2_, "*");
	_tmp3_ = feed_reader_settings_general ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_settings_get_enum (_tmp4_, "feedlist-sort-by") == ((gint) FEED_READER_FEED_LIST_SORT_ALPHABETICAL);
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		FeedReaderQueryBuilder* _tmp6_;
		_tmp6_ = query;
		feed_reader_query_builder_order_by (_tmp6_, "name", TRUE);
	}
	_tmp7_ = self->m_db;
	_tmp8_ = query;
	_tmp9_ = feed_reader_query_builder_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = feed_reader_sq_lite_prepare (_tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	stmt = _tmp12_;
	while (TRUE) {
		sqlite3_stmt* _tmp13_;
		gchar* feedID = NULL;
		sqlite3_stmt* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* catString = NULL;
		sqlite3_stmt* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* xmlURL = NULL;
		sqlite3_stmt* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* iconURL = NULL;
		sqlite3_stmt* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* url = NULL;
		sqlite3_stmt* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* name = NULL;
		sqlite3_stmt* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		GeeList* categories = NULL;
		const gchar* _tmp32_;
		GeeList* _tmp33_;
		guint count = 0U;
		FeedReaderFeed* feed = NULL;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		GeeList* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		FeedReaderFeed* _tmp42_;
		GeeList* _tmp43_;
		FeedReaderFeed* _tmp44_;
		_tmp13_ = stmt;
		if (!(sqlite3_step (_tmp13_) == SQLITE_ROW)) {
			break;
		}
		_tmp14_ = stmt;
		_tmp15_ = sqlite3_column_text (_tmp14_, 0);
		_tmp16_ = g_strdup (_tmp15_);
		feedID = _tmp16_;
		_tmp17_ = stmt;
		_tmp18_ = sqlite3_column_text (_tmp17_, 3);
		_tmp19_ = g_strdup (_tmp18_);
		catString = _tmp19_;
		_tmp20_ = stmt;
		_tmp21_ = sqlite3_column_text (_tmp20_, 5);
		_tmp22_ = g_strdup (_tmp21_);
		xmlURL = _tmp22_;
		_tmp23_ = stmt;
		_tmp24_ = sqlite3_column_text (_tmp23_, 6);
		_tmp25_ = g_strdup (_tmp24_);
		iconURL = _tmp25_;
		_tmp26_ = stmt;
		_tmp27_ = sqlite3_column_text (_tmp26_, 2);
		_tmp28_ = g_strdup (_tmp27_);
		url = _tmp28_;
		_tmp29_ = stmt;
		_tmp30_ = sqlite3_column_text (_tmp29_, 1);
		_tmp31_ = g_strdup (_tmp30_);
		name = _tmp31_;
		_tmp32_ = catString;
		_tmp33_ = feed_reader_string_utils_split (_tmp32_, ",", TRUE);
		categories = _tmp33_;
		count = (guint) 0;
		if (starredCount) {
			const gchar* _tmp34_;
			_tmp34_ = feedID;
			count = feed_reader_data_base_read_only_getFeedStarred (self, _tmp34_);
		} else {
			const gchar* _tmp35_;
			_tmp35_ = feedID;
			count = feed_reader_data_base_read_only_getFeedUnread (self, _tmp35_);
		}
		_tmp36_ = feedID;
		_tmp37_ = name;
		_tmp38_ = url;
		_tmp39_ = categories;
		_tmp40_ = iconURL;
		_tmp41_ = xmlURL;
		_tmp42_ = feed_reader_feed_new (_tmp36_, _tmp37_, _tmp38_, count, _tmp39_, _tmp40_, _tmp41_);
		feed = _tmp42_;
		_tmp43_ = feeds;
		_tmp44_ = feed;
		gee_collection_add ((GeeCollection*) _tmp43_, _tmp44_);
		_g_object_unref0 (feed);
		_g_object_unref0 (categories);
		_g_free0 (name);
		_g_free0 (url);
		_g_free0 (iconURL);
		_g_free0 (xmlURL);
		_g_free0 (catString);
		_g_free0 (feedID);
	}
	result = feeds;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

guint
feed_reader_data_base_read_only_getFeedUnread (FeedReaderDataBaseReadOnly* self,
                                               const gchar* feedID)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeList* _tmp18_;
	gpointer _tmp19_;
	GeeList* _tmp20_;
	gpointer _tmp21_;
	sqlite3_value* _tmp22_;
	guint _tmp23_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (feedID != NULL, 0U);
	_tmp0_ = g_strdup ("SELECT COUNT(*) FROM articles WHERE unread = ? AND feedID = ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, FEED_READER_TYPE_ARTICLE_STATUS);
	g_value_set_enum (_tmp3_, FEED_READER_ARTICLE_STATUS_UNREAD);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, feedID);
	_tmp5_ = g_new0 (GValue*, 2);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp6_, (gint) 2);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp8_;
	_tmp10_ = rows;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 1) {
		GeeList* _tmp13_;
		gpointer _tmp14_;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp13_ = rows;
		_tmp14_ = gee_list_get (_tmp13_, 0);
		_tmp15_ = (GeeList*) _tmp14_;
		_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp9_ = _tmp17_ == 1;
		_g_object_unref0 (_tmp15_);
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "rows.size == 1 && rows[0].size == 1");
	_tmp18_ = rows;
	_tmp19_ = gee_list_get (_tmp18_, 0);
	_tmp20_ = (GeeList*) _tmp19_;
	_tmp21_ = gee_list_get (_tmp20_, 0);
	_tmp22_ = (sqlite3_value*) _tmp21_;
	_tmp23_ = (guint) sqlite3_value_int (_tmp22_);
	_sqlite3_value_free0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	result = _tmp23_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

guint
feed_reader_data_base_read_only_getFeedStarred (FeedReaderDataBaseReadOnly* self,
                                                const gchar* feedID)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeList* _tmp18_;
	gpointer _tmp19_;
	GeeList* _tmp20_;
	gpointer _tmp21_;
	sqlite3_value* _tmp22_;
	guint _tmp23_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (feedID != NULL, 0U);
	_tmp0_ = g_strdup ("SELECT COUNT(*) FROM articles WHERE marked = ? AND feedID = ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, FEED_READER_TYPE_ARTICLE_STATUS);
	g_value_set_enum (_tmp3_, FEED_READER_ARTICLE_STATUS_MARKED);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, feedID);
	_tmp5_ = g_new0 (GValue*, 2);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp6_, (gint) 2);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp8_;
	_tmp10_ = rows;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 1) {
		GeeList* _tmp13_;
		gpointer _tmp14_;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp13_ = rows;
		_tmp14_ = gee_list_get (_tmp13_, 0);
		_tmp15_ = (GeeList*) _tmp14_;
		_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp9_ = _tmp17_ == 1;
		_g_object_unref0 (_tmp15_);
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "rows.size == 1 && rows[0].size == 1");
	_tmp18_ = rows;
	_tmp19_ = gee_list_get (_tmp18_, 0);
	_tmp20_ = (GeeList*) _tmp19_;
	_tmp21_ = gee_list_get (_tmp20_, 0);
	_tmp22_ = (sqlite3_value*) _tmp21_;
	_tmp23_ = (guint) sqlite3_value_int (_tmp22_);
	_sqlite3_value_free0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	result = _tmp23_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_feeds_without_cat (FeedReaderDataBaseReadOnly* self)
{
	GeeArrayList* feeds = NULL;
	GeeArrayList* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	gboolean _tmp8_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp10_;
	FeedReaderQueryBuilder* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_FEED, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	feeds = _tmp0_;
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "feeds");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_select_field (_tmp2_, "*");
	_tmp3_ = query;
	_tmp4_ = feed_reader_data_base_read_only_getUncategorizedQuery (self);
	_tmp5_ = _tmp4_;
	feed_reader_query_builder_where (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = feed_reader_settings_general ();
	_tmp7_ = _tmp6_;
	_tmp8_ = g_settings_get_enum (_tmp7_, "feedlist-sort-by") == ((gint) FEED_READER_FEED_LIST_SORT_ALPHABETICAL);
	_g_object_unref0 (_tmp7_);
	if (_tmp8_) {
		FeedReaderQueryBuilder* _tmp9_;
		_tmp9_ = query;
		feed_reader_query_builder_order_by (_tmp9_, "name", TRUE);
	}
	_tmp10_ = self->m_db;
	_tmp11_ = query;
	_tmp12_ = feed_reader_query_builder_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = feed_reader_sq_lite_prepare (_tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	stmt = _tmp15_;
	while (TRUE) {
		sqlite3_stmt* _tmp16_;
		gchar* feedID = NULL;
		sqlite3_stmt* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* catString = NULL;
		sqlite3_stmt* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* xmlURL = NULL;
		sqlite3_stmt* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* iconURL = NULL;
		sqlite3_stmt* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* url = NULL;
		sqlite3_stmt* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* name = NULL;
		sqlite3_stmt* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		GeeList* categories = NULL;
		const gchar* _tmp35_;
		GeeList* _tmp36_;
		FeedReaderFeed* feed = NULL;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		GeeList* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		FeedReaderFeed* _tmp44_;
		GeeArrayList* _tmp45_;
		FeedReaderFeed* _tmp46_;
		_tmp16_ = stmt;
		if (!(sqlite3_step (_tmp16_) == SQLITE_ROW)) {
			break;
		}
		_tmp17_ = stmt;
		_tmp18_ = sqlite3_column_text (_tmp17_, 0);
		_tmp19_ = g_strdup (_tmp18_);
		feedID = _tmp19_;
		_tmp20_ = stmt;
		_tmp21_ = sqlite3_column_text (_tmp20_, 3);
		_tmp22_ = g_strdup (_tmp21_);
		catString = _tmp22_;
		_tmp23_ = stmt;
		_tmp24_ = sqlite3_column_text (_tmp23_, 5);
		_tmp25_ = g_strdup (_tmp24_);
		xmlURL = _tmp25_;
		_tmp26_ = stmt;
		_tmp27_ = sqlite3_column_text (_tmp26_, 6);
		_tmp28_ = g_strdup (_tmp27_);
		iconURL = _tmp28_;
		_tmp29_ = stmt;
		_tmp30_ = sqlite3_column_text (_tmp29_, 2);
		_tmp31_ = g_strdup (_tmp30_);
		url = _tmp31_;
		_tmp32_ = stmt;
		_tmp33_ = sqlite3_column_text (_tmp32_, 1);
		_tmp34_ = g_strdup (_tmp33_);
		name = _tmp34_;
		_tmp35_ = catString;
		_tmp36_ = feed_reader_string_utils_split (_tmp35_, ",", TRUE);
		categories = _tmp36_;
		_tmp37_ = feedID;
		_tmp38_ = name;
		_tmp39_ = url;
		_tmp40_ = feedID;
		_tmp41_ = categories;
		_tmp42_ = iconURL;
		_tmp43_ = xmlURL;
		_tmp44_ = feed_reader_feed_new (_tmp37_, _tmp38_, _tmp39_, feed_reader_data_base_read_only_getFeedUnread (self, _tmp40_), _tmp41_, _tmp42_, _tmp43_);
		feed = _tmp44_;
		_tmp45_ = feeds;
		_tmp46_ = feed;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
		_g_object_unref0 (feed);
		_g_object_unref0 (categories);
		_g_free0 (name);
		_g_free0 (url);
		_g_free0 (iconURL);
		_g_free0 (xmlURL);
		_g_free0 (catString);
		_g_free0 (feedID);
	}
	result = (GeeList*) feeds;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

FeedReaderCategory*
feed_reader_data_base_read_only_read_category (FeedReaderDataBaseReadOnly* self,
                                               const gchar* catID)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeList* row = NULL;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	sqlite3_value* _tmp15_;
	const gchar* _tmp16_;
	GeeList* _tmp17_;
	gpointer _tmp18_;
	sqlite3_value* _tmp19_;
	GeeList* _tmp20_;
	gpointer _tmp21_;
	sqlite3_value* _tmp22_;
	const gchar* _tmp23_;
	GeeList* _tmp24_;
	gpointer _tmp25_;
	sqlite3_value* _tmp26_;
	FeedReaderCategory* _tmp27_;
	FeedReaderCategory* _tmp28_;
	FeedReaderCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (catID != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT * FROM categories WHERE categorieID = ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, catID);
	_tmp4_ = g_new0 (GValue*, 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp5_, (gint) 1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp7_;
	_tmp8_ = rows;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 0) {
		result = NULL;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	}
	_tmp11_ = rows;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	row = (GeeList*) _tmp12_;
	_tmp13_ = row;
	_tmp14_ = gee_list_get (_tmp13_, 1);
	_tmp15_ = (sqlite3_value*) _tmp14_;
	_tmp16_ = sqlite3_value_text (_tmp15_);
	_tmp17_ = row;
	_tmp18_ = gee_list_get (_tmp17_, 3);
	_tmp19_ = (sqlite3_value*) _tmp18_;
	_tmp20_ = row;
	_tmp21_ = gee_list_get (_tmp20_, 4);
	_tmp22_ = (sqlite3_value*) _tmp21_;
	_tmp23_ = sqlite3_value_text (_tmp22_);
	_tmp24_ = row;
	_tmp25_ = gee_list_get (_tmp24_, 5);
	_tmp26_ = (sqlite3_value*) _tmp25_;
	_tmp27_ = feed_reader_category_new (catID, _tmp16_, (guint) 0, sqlite3_value_int (_tmp19_), _tmp23_, sqlite3_value_int (_tmp26_));
	_tmp28_ = _tmp27_;
	_sqlite3_value_free0 (_tmp26_);
	_sqlite3_value_free0 (_tmp22_);
	_sqlite3_value_free0 (_tmp19_);
	_sqlite3_value_free0 (_tmp15_);
	result = _tmp28_;
	_g_object_unref0 (row);
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_tags (FeedReaderDataBaseReadOnly* self)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GeeList* _tmp1_;
	GeeArrayList* tags = NULL;
	GeeArrayList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_db;
	_tmp1_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT * FROM tags WHERE instr(tagID, 'global.') = 0", NULL, (gint) 0);
	rows = _tmp1_;
	_tmp2_ = gee_array_list_new (FEED_READER_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	tags = _tmp2_;
	{
		GeeList* _row_list = NULL;
		GeeList* _tmp3_;
		gint _row_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _row_index = 0;
		_tmp3_ = rows;
		_row_list = _tmp3_;
		_tmp4_ = _row_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_row_size = _tmp6_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GeeList* row = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			FeedReaderTag* tag = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			sqlite3_value* _tmp13_;
			const gchar* _tmp14_;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			sqlite3_value* _tmp17_;
			const gchar* _tmp18_;
			GeeList* _tmp19_;
			gpointer _tmp20_;
			sqlite3_value* _tmp21_;
			FeedReaderTag* _tmp22_;
			FeedReaderTag* _tmp23_;
			GeeArrayList* _tmp24_;
			FeedReaderTag* _tmp25_;
			_row_index = _row_index + 1;
			_tmp7_ = _row_index;
			_tmp8_ = _row_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _row_list;
			_tmp10_ = gee_list_get (_tmp9_, _row_index);
			row = (GeeList*) _tmp10_;
			_tmp11_ = row;
			_tmp12_ = gee_list_get (_tmp11_, 0);
			_tmp13_ = (sqlite3_value*) _tmp12_;
			_tmp14_ = sqlite3_value_text (_tmp13_);
			_tmp15_ = row;
			_tmp16_ = gee_list_get (_tmp15_, 1);
			_tmp17_ = (sqlite3_value*) _tmp16_;
			_tmp18_ = sqlite3_value_text (_tmp17_);
			_tmp19_ = row;
			_tmp20_ = gee_list_get (_tmp19_, 3);
			_tmp21_ = (sqlite3_value*) _tmp20_;
			_tmp22_ = feed_reader_tag_new (_tmp14_, _tmp18_, sqlite3_value_int (_tmp21_));
			_tmp23_ = _tmp22_;
			_sqlite3_value_free0 (_tmp21_);
			_sqlite3_value_free0 (_tmp17_);
			_sqlite3_value_free0 (_tmp13_);
			tag = _tmp23_;
			_tmp24_ = tags;
			_tmp25_ = tag;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			_g_object_unref0 (tag);
			_g_object_unref0 (row);
		}
	}
	result = (GeeList*) tags;
	_g_object_unref0 (rows);
	return result;
}

static GeeList*
feed_reader_data_base_read_only_read_taggings_by_article_id (FeedReaderDataBaseReadOnly* self,
                                                             const gchar* articleID)
{
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue** _tmp3_;
	GValue** _tmp4_;
	gint _tmp4__length1;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articleID != NULL, NULL);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_STRING);
	g_value_set_string (_tmp2_, articleID);
	_tmp3_ = g_new0 (GValue*, 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = feed_reader_sq_lite_execute (_tmp1_, "SELECT tagID FROM taggings WHERE articleID = ?", _tmp4_, (gint) 1);
	_tmp6_ = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp6_;
	{
		GeeList* _row_list = NULL;
		GeeList* _tmp7_;
		gint _row_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _row_index = 0;
		_tmp7_ = rows;
		_row_list = _tmp7_;
		_tmp8_ = _row_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_row_size = _tmp10_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			GeeList* row = NULL;
			GeeList* _tmp13_;
			gpointer _tmp14_;
			GeeLinkedList* _tmp15_;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			sqlite3_value* _tmp18_;
			const gchar* _tmp19_;
			_row_index = _row_index + 1;
			_tmp11_ = _row_index;
			_tmp12_ = _row_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _row_list;
			_tmp14_ = gee_list_get (_tmp13_, _row_index);
			row = (GeeList*) _tmp14_;
			_tmp15_ = list;
			_tmp16_ = row;
			_tmp17_ = gee_list_get (_tmp16_, 0);
			_tmp18_ = (sqlite3_value*) _tmp17_;
			_tmp19_ = sqlite3_value_text (_tmp18_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp19_);
			_sqlite3_value_free0 (_tmp18_);
			_g_object_unref0 (row);
		}
	}
	result = (GeeList*) list;
	_g_object_unref0 (rows);
	return result;
}

static GeeList*
feed_reader_data_base_read_only_read_taggings_by_tag_id (FeedReaderDataBaseReadOnly* self,
                                                         const gchar* tagID)
{
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue** _tmp3_;
	GValue** _tmp4_;
	gint _tmp4__length1;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagID != NULL, NULL);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_STRING);
	g_value_set_string (_tmp2_, tagID);
	_tmp3_ = g_new0 (GValue*, 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = feed_reader_sq_lite_execute (_tmp1_, "SELECT articleID FROM taggings WHERE tagID = ?", _tmp4_, (gint) 1);
	_tmp6_ = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp6_;
	{
		GeeList* _row_list = NULL;
		GeeList* _tmp7_;
		gint _row_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _row_index = 0;
		_tmp7_ = rows;
		_row_list = _tmp7_;
		_tmp8_ = _row_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_row_size = _tmp10_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			GeeList* row = NULL;
			GeeList* _tmp13_;
			gpointer _tmp14_;
			GeeLinkedList* _tmp15_;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			sqlite3_value* _tmp18_;
			const gchar* _tmp19_;
			_row_index = _row_index + 1;
			_tmp11_ = _row_index;
			_tmp12_ = _row_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _row_list;
			_tmp14_ = gee_list_get (_tmp13_, _row_index);
			row = (GeeList*) _tmp14_;
			_tmp15_ = list;
			_tmp16_ = row;
			_tmp17_ = gee_list_get (_tmp16_, 0);
			_tmp18_ = (sqlite3_value*) _tmp17_;
			_tmp19_ = sqlite3_value_text (_tmp18_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp19_);
			_sqlite3_value_free0 (_tmp18_);
			_g_object_unref0 (row);
		}
	}
	result = (GeeList*) list;
	_g_object_unref0 (rows);
	return result;
}

FeedReaderTag*
feed_reader_data_base_read_only_read_tag (FeedReaderDataBaseReadOnly* self,
                                          const gchar* tagID)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeList* row = NULL;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	sqlite3_value* _tmp15_;
	const gchar* _tmp16_;
	GeeList* _tmp17_;
	gpointer _tmp18_;
	sqlite3_value* _tmp19_;
	const gchar* _tmp20_;
	GeeList* _tmp21_;
	gpointer _tmp22_;
	sqlite3_value* _tmp23_;
	FeedReaderTag* _tmp24_;
	FeedReaderTag* _tmp25_;
	FeedReaderTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagID != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT * FROM tags WHERE tagID = ?");
	query = _tmp0_;
	_tmp1_ = self->m_db;
	_tmp2_ = query;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, tagID);
	_tmp4_ = g_new0 (GValue*, 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp5_, (gint) 1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp7_;
	_tmp8_ = rows;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 0) {
		result = NULL;
		_g_object_unref0 (rows);
		_g_free0 (query);
		return result;
	}
	_tmp11_ = rows;
	_tmp12_ = gee_list_get (_tmp11_, 0);
	row = (GeeList*) _tmp12_;
	_tmp13_ = row;
	_tmp14_ = gee_list_get (_tmp13_, 0);
	_tmp15_ = (sqlite3_value*) _tmp14_;
	_tmp16_ = sqlite3_value_text (_tmp15_);
	_tmp17_ = row;
	_tmp18_ = gee_list_get (_tmp17_, 1);
	_tmp19_ = (sqlite3_value*) _tmp18_;
	_tmp20_ = sqlite3_value_text (_tmp19_);
	_tmp21_ = row;
	_tmp22_ = gee_list_get (_tmp21_, 3);
	_tmp23_ = (sqlite3_value*) _tmp22_;
	_tmp24_ = feed_reader_tag_new (_tmp16_, _tmp20_, sqlite3_value_int (_tmp23_));
	_tmp25_ = _tmp24_;
	_sqlite3_value_free0 (_tmp23_);
	_sqlite3_value_free0 (_tmp19_);
	_sqlite3_value_free0 (_tmp15_);
	result = _tmp25_;
	_g_object_unref0 (row);
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

gchar*
feed_reader_data_base_read_only_getAllTagsCondition (FeedReaderDataBaseReadOnly* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("articleID IN (SELECT articleID FROM taggings WHERE instr(tagID, 'globa" \
"l.') = 0)");
	result = _tmp0_;
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_categories_level (FeedReaderDataBaseReadOnly* self,
                                                       gint level,
                                                       GeeList* feeds)
{
	GeeList* categories = NULL;
	GeeList* _tmp0_;
	GeeArrayList* results = NULL;
	GeeArrayList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = feed_reader_data_base_read_only_read_categories (self, feeds);
	categories = _tmp0_;
	_tmp1_ = gee_array_list_new (FEED_READER_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	results = _tmp1_;
	{
		GeeList* _cat_list = NULL;
		GeeList* _tmp2_;
		gint _cat_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _cat_index = 0;
		_tmp2_ = categories;
		_cat_list = _tmp2_;
		_tmp3_ = _cat_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_cat_size = _tmp5_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			FeedReaderCategory* cat = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			FeedReaderCategory* _tmp10_;
			_cat_index = _cat_index + 1;
			_tmp6_ = _cat_index;
			_tmp7_ = _cat_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _cat_list;
			_tmp9_ = gee_list_get (_tmp8_, _cat_index);
			cat = (FeedReaderCategory*) _tmp9_;
			_tmp10_ = cat;
			if (feed_reader_category_getLevel (_tmp10_) == level) {
				GeeArrayList* _tmp11_;
				FeedReaderCategory* _tmp12_;
				_tmp11_ = results;
				_tmp12_ = cat;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			}
			_g_object_unref0 (cat);
		}
	}
	result = (GeeList*) results;
	_g_object_unref0 (categories);
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_categories (FeedReaderDataBaseReadOnly* self,
                                                 GeeList* feeds)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gboolean _tmp4_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	GeeArrayList* results = NULL;
	GeeArrayList* _tmp13_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "categories");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_select_field (_tmp1_, "*");
	_tmp2_ = feed_reader_settings_general ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_get_enum (_tmp3_, "feedlist-sort-by") == ((gint) FEED_READER_FEED_LIST_SORT_ALPHABETICAL);
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		FeedReaderQueryBuilder* _tmp5_;
		_tmp5_ = query;
		feed_reader_query_builder_order_by (_tmp5_, "title", TRUE);
	} else {
		FeedReaderQueryBuilder* _tmp6_;
		_tmp6_ = query;
		feed_reader_query_builder_order_by (_tmp6_, "orderID", TRUE);
	}
	_tmp7_ = self->m_db;
	_tmp8_ = query;
	_tmp9_ = feed_reader_query_builder_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = feed_reader_sq_lite_prepare (_tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	stmt = _tmp12_;
	_tmp13_ = gee_array_list_new (FEED_READER_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	results = _tmp13_;
	while (TRUE) {
		sqlite3_stmt* _tmp14_;
		gchar* catID = NULL;
		sqlite3_stmt* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp14_ = stmt;
		if (!(sqlite3_step (_tmp14_) == SQLITE_ROW)) {
			break;
		}
		_tmp15_ = stmt;
		_tmp16_ = sqlite3_column_text (_tmp15_, 0);
		_tmp17_ = g_strdup (_tmp16_);
		catID = _tmp17_;
		if (feeds == NULL) {
			_tmp18_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = catID;
			_tmp18_ = feed_reader_data_base_read_only_showCategory (self, _tmp19_, feeds);
		}
		if (_tmp18_) {
			guint _tmp20_ = 0U;
			FeedReaderCategory* category = NULL;
			const gchar* _tmp22_;
			sqlite3_stmt* _tmp23_;
			const gchar* _tmp24_;
			sqlite3_stmt* _tmp25_;
			sqlite3_stmt* _tmp26_;
			const gchar* _tmp27_;
			sqlite3_stmt* _tmp28_;
			FeedReaderCategory* _tmp29_;
			GeeArrayList* _tmp30_;
			FeedReaderCategory* _tmp31_;
			if (feeds == NULL) {
				_tmp20_ = (guint) 0;
			} else {
				const gchar* _tmp21_;
				_tmp21_ = catID;
				_tmp20_ = feed_reader_utils_categoryGetUnread (_tmp21_, feeds);
			}
			_tmp22_ = catID;
			_tmp23_ = stmt;
			_tmp24_ = sqlite3_column_text (_tmp23_, 1);
			_tmp25_ = stmt;
			_tmp26_ = stmt;
			_tmp27_ = sqlite3_column_text (_tmp26_, 4);
			_tmp28_ = stmt;
			_tmp29_ = feed_reader_category_new (_tmp22_, _tmp24_, _tmp20_, sqlite3_column_int (_tmp25_, 3), _tmp27_, sqlite3_column_int (_tmp28_, 5));
			category = _tmp29_;
			_tmp30_ = results;
			_tmp31_ = category;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
			_g_object_unref0 (category);
		}
		_g_free0 (catID);
	}
	result = (GeeList*) results;
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
	return result;
}

GeeList*
feed_reader_data_base_read_only_readUnfetchedArticles (FeedReaderDataBaseReadOnly* self)
{
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp0_;
	GeeList* _tmp1_;
	GeeLinkedList* articles = NULL;
	GeeLinkedList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_db;
	_tmp1_ = feed_reader_sq_lite_execute (_tmp0_, "SELECT articleID, url, preview, html, feedID FROM articles WHERE conte" \
"ntFetched = 0", NULL, (gint) 0);
	rows = _tmp1_;
	_tmp2_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp2_;
	{
		GeeList* _row_list = NULL;
		GeeList* _tmp3_;
		gint _row_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _row_index = 0;
		_tmp3_ = rows;
		_row_list = _tmp3_;
		_tmp4_ = _row_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_row_size = _tmp6_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GeeList* row = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			GeeLinkedList* _tmp11_;
			GeeList* _tmp12_;
			gpointer _tmp13_;
			sqlite3_value* _tmp14_;
			const gchar* _tmp15_;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			sqlite3_value* _tmp18_;
			const gchar* _tmp19_;
			GeeList* _tmp20_;
			gpointer _tmp21_;
			sqlite3_value* _tmp22_;
			const gchar* _tmp23_;
			GeeList* _tmp24_;
			gpointer _tmp25_;
			sqlite3_value* _tmp26_;
			const gchar* _tmp27_;
			GeeList* _tmp28_;
			gpointer _tmp29_;
			sqlite3_value* _tmp30_;
			const gchar* _tmp31_;
			GDateTime* _tmp32_;
			GDateTime* _tmp33_;
			FeedReaderArticle* _tmp34_;
			FeedReaderArticle* _tmp35_;
			_row_index = _row_index + 1;
			_tmp7_ = _row_index;
			_tmp8_ = _row_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _row_list;
			_tmp10_ = gee_list_get (_tmp9_, _row_index);
			row = (GeeList*) _tmp10_;
			_tmp11_ = articles;
			_tmp12_ = row;
			_tmp13_ = gee_list_get (_tmp12_, 0);
			_tmp14_ = (sqlite3_value*) _tmp13_;
			_tmp15_ = sqlite3_value_text (_tmp14_);
			_tmp16_ = row;
			_tmp17_ = gee_list_get (_tmp16_, 1);
			_tmp18_ = (sqlite3_value*) _tmp17_;
			_tmp19_ = sqlite3_value_text (_tmp18_);
			_tmp20_ = row;
			_tmp21_ = gee_list_get (_tmp20_, 4);
			_tmp22_ = (sqlite3_value*) _tmp21_;
			_tmp23_ = sqlite3_value_text (_tmp22_);
			_tmp24_ = row;
			_tmp25_ = gee_list_get (_tmp24_, 3);
			_tmp26_ = (sqlite3_value*) _tmp25_;
			_tmp27_ = sqlite3_value_text (_tmp26_);
			_tmp28_ = row;
			_tmp29_ = gee_list_get (_tmp28_, 2);
			_tmp30_ = (sqlite3_value*) _tmp29_;
			_tmp31_ = sqlite3_value_text (_tmp30_);
			_tmp32_ = g_date_time_new_now_local ();
			_tmp33_ = _tmp32_;
			_tmp34_ = feed_reader_article_new (_tmp15_, NULL, _tmp19_, _tmp23_, FEED_READER_ARTICLE_STATUS_UNREAD, FEED_READER_ARTICLE_STATUS_UNMARKED, _tmp27_, _tmp31_, NULL, _tmp33_, 0, NULL, NULL, "", 0);
			_tmp35_ = _tmp34_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp35_);
			_g_object_unref0 (_tmp35_);
			_g_date_time_unref0 (_tmp33_);
			_sqlite3_value_free0 (_tmp30_);
			_sqlite3_value_free0 (_tmp26_);
			_sqlite3_value_free0 (_tmp22_);
			_sqlite3_value_free0 (_tmp18_);
			_sqlite3_value_free0 (_tmp14_);
			_g_object_unref0 (row);
		}
	}
	result = (GeeList*) articles;
	_g_object_unref0 (rows);
	return result;
}

FeedReaderQueryBuilder*
feed_reader_data_base_read_only_articleQuery (FeedReaderDataBaseReadOnly* self,
                                              const gchar* id,
                                              FeedReaderFeedListType selectedType,
                                              FeedReaderArticleListState state,
                                              const gchar* searchTerm)
{
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	gchar* order_by = NULL;
	gchar* _tmp4_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	FeedReaderQueryBuilder* _tmp9_;
	FeedReaderQueryBuilder* _tmp10_;
	FeedReaderQueryBuilder* _tmp11_;
	FeedReaderQueryBuilder* _tmp12_;
	FeedReaderQueryBuilder* _tmp13_;
	FeedReaderQueryBuilder* _tmp14_;
	FeedReaderQueryBuilder* _tmp15_;
	FeedReaderQueryBuilder* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean desc = FALSE;
	GSettings* _tmp61_;
	GSettings* _tmp62_;
	gboolean _tmp63_;
	FeedReaderQueryBuilder* _tmp64_;
	const gchar* _tmp65_;
	FeedReaderQueryBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (searchTerm != NULL, NULL);
	_tmp1_ = feed_reader_settings_general ();
	_tmp2_ = _tmp1_;
	_tmp3_ = ((FeedReaderArticleListSort) g_settings_get_enum (_tmp2_, "articlelist-sort-by")) == FEED_READER_ARTICLE_LIST_SORT_RECEIVED;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = "rowid";
	} else {
		_tmp0_ = "date";
	}
	_tmp4_ = g_strdup (_tmp0_);
	order_by = _tmp4_;
	_tmp5_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "articles");
	query = _tmp5_;
	_tmp6_ = query;
	feed_reader_query_builder_select_field (_tmp6_, "ROWID");
	_tmp7_ = query;
	feed_reader_query_builder_select_field (_tmp7_, "feedID");
	_tmp8_ = query;
	feed_reader_query_builder_select_field (_tmp8_, "articleID");
	_tmp9_ = query;
	feed_reader_query_builder_select_field (_tmp9_, "title");
	_tmp10_ = query;
	feed_reader_query_builder_select_field (_tmp10_, "author");
	_tmp11_ = query;
	feed_reader_query_builder_select_field (_tmp11_, "url");
	_tmp12_ = query;
	feed_reader_query_builder_select_field (_tmp12_, "preview");
	_tmp13_ = query;
	feed_reader_query_builder_select_field (_tmp13_, "unread");
	_tmp14_ = query;
	feed_reader_query_builder_select_field (_tmp14_, "marked");
	_tmp15_ = query;
	feed_reader_query_builder_select_field (_tmp15_, "date");
	_tmp16_ = query;
	feed_reader_query_builder_select_field (_tmp16_, "guidHash");
	if (selectedType == FEED_READER_FEED_LIST_TYPE_FEED) {
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
		_tmp19_ = _tmp18_;
		_tmp17_ = g_strcmp0 (id, _tmp19_) != 0;
		_g_free0 (_tmp19_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		FeedReaderQueryBuilder* _tmp20_;
		_tmp20_ = query;
		feed_reader_query_builder_where_equal_string (_tmp20_, "feedID", id);
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		if (selectedType == FEED_READER_FEED_LIST_TYPE_CATEGORY) {
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
			_tmp24_ = _tmp23_;
			_tmp22_ = g_strcmp0 (id, _tmp24_) != 0;
			_g_free0 (_tmp24_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
			_tmp26_ = _tmp25_;
			_tmp21_ = g_strcmp0 (id, _tmp26_) != 0;
			_g_free0 (_tmp26_);
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			FeedReaderQueryBuilder* _tmp27_;
			GeeList* _tmp28_;
			GeeList* _tmp29_;
			_tmp27_ = query;
			_tmp28_ = feed_reader_data_base_read_only_getFeedIDofCategorie (self, id);
			_tmp29_ = _tmp28_;
			feed_reader_query_builder_where_in_strings (_tmp27_, "feedID", _tmp29_);
			_g_object_unref0 (_tmp29_);
		} else {
			gchar* _tmp30_;
			gchar* _tmp31_;
			gboolean _tmp32_;
			_tmp30_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strcmp0 (id, _tmp31_) == 0;
			_g_free0 (_tmp31_);
			if (_tmp32_) {
				FeedReaderQueryBuilder* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp33_ = query;
				_tmp34_ = feed_reader_data_base_read_only_getAllTagsCondition (self);
				_tmp35_ = _tmp34_;
				feed_reader_query_builder_where (_tmp33_, _tmp35_);
				_g_free0 (_tmp35_);
			} else {
				if (selectedType == FEED_READER_FEED_LIST_TYPE_TAG) {
					FeedReaderQueryBuilder* _tmp36_;
					GeeList* _tmp37_;
					GeeList* _tmp38_;
					_tmp36_ = query;
					_tmp37_ = feed_reader_data_base_read_only_read_taggings_by_tag_id (self, id);
					_tmp38_ = _tmp37_;
					feed_reader_query_builder_where_in_strings (_tmp36_, "articleID", _tmp38_);
					_g_object_unref0 (_tmp38_);
				}
			}
		}
	}
	if (state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
		FeedReaderQueryBuilder* _tmp39_;
		_tmp39_ = query;
		feed_reader_query_builder_where_equal_int (_tmp39_, "unread", (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_UNREAD));
	} else {
		if (state == FEED_READER_ARTICLE_LIST_STATE_MARKED) {
			FeedReaderQueryBuilder* _tmp40_;
			_tmp40_ = query;
			feed_reader_query_builder_where_equal_int (_tmp40_, "marked", (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_MARKED));
		}
	}
	if (g_strcmp0 (searchTerm, "") != 0) {
		if (g_str_has_prefix (searchTerm, "title: ")) {
			FeedReaderQueryBuilder* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp41_ = query;
			_tmp42_ = feed_reader_utils_prepareSearchQuery (searchTerm);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strdup_printf ("articleID IN (SELECT articleID FROM fts_table WHERE title MATCH '%s')", _tmp43_);
			_tmp45_ = _tmp44_;
			feed_reader_query_builder_where (_tmp41_, _tmp45_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
		} else {
			if (g_str_has_prefix (searchTerm, "author: ")) {
				FeedReaderQueryBuilder* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp46_ = query;
				_tmp47_ = feed_reader_utils_prepareSearchQuery (searchTerm);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup_printf ("articleID IN (SELECT articleID FROM fts_table WHERE author MATCH '%s')", _tmp48_);
				_tmp50_ = _tmp49_;
				feed_reader_query_builder_where (_tmp46_, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
			} else {
				if (g_str_has_prefix (searchTerm, "content: ")) {
					FeedReaderQueryBuilder* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					_tmp51_ = query;
					_tmp52_ = feed_reader_utils_prepareSearchQuery (searchTerm);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strdup_printf ("articleID IN (SELECT articleID FROM fts_table WHERE preview MATCH '%s'" \
")", _tmp53_);
					_tmp55_ = _tmp54_;
					feed_reader_query_builder_where (_tmp51_, _tmp55_);
					_g_free0 (_tmp55_);
					_g_free0 (_tmp53_);
				} else {
					FeedReaderQueryBuilder* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					gchar* _tmp60_;
					_tmp56_ = query;
					_tmp57_ = feed_reader_utils_prepareSearchQuery (searchTerm);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_strdup_printf ("articleID IN (SELECT articleID FROM fts_table WHERE fts_table MATCH '%" \
"s')", _tmp58_);
					_tmp60_ = _tmp59_;
					feed_reader_query_builder_where (_tmp56_, _tmp60_);
					_g_free0 (_tmp60_);
					_g_free0 (_tmp58_);
				}
			}
		}
	}
	desc = TRUE;
	_tmp61_ = feed_reader_settings_general ();
	_tmp62_ = _tmp61_;
	_tmp63_ = g_settings_get_boolean (_tmp62_, "articlelist-oldest-first");
	_g_object_unref0 (_tmp62_);
	if (_tmp63_) {
		desc = FALSE;
	}
	_tmp64_ = query;
	_tmp65_ = order_by;
	feed_reader_query_builder_order_by (_tmp64_, _tmp65_, desc);
	result = query;
	_g_free0 (order_by);
	return result;
}

GeeList*
feed_reader_data_base_read_only_read_articles (FeedReaderDataBaseReadOnly* self,
                                               const gchar* id,
                                               FeedReaderFeedListType selectedType,
                                               FeedReaderArticleListState state,
                                               const gchar* searchTerm,
                                               guint limit,
                                               guint offset,
                                               gint searchRows)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	gchar* desc = NULL;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gboolean _tmp4_;
	FeedReaderQueryBuilder* _tmp20_;
	FeedReaderQueryBuilder* _tmp21_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp22_;
	FeedReaderQueryBuilder* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	sqlite3_stmt* _tmp26_;
	sqlite3_stmt* _tmp27_;
	GeeLinkedList* results = NULL;
	GeeLinkedList* _tmp28_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (searchTerm != NULL, NULL);
	_vala_return_val_if_fail (limit > ((guint) 0), "limit > 0", NULL);
	_tmp0_ = feed_reader_data_base_read_only_articleQuery (self, id, selectedType, state, searchTerm);
	query = _tmp0_;
	_tmp1_ = g_strdup ("DESC");
	desc = _tmp1_;
	_tmp2_ = feed_reader_settings_general ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_get_boolean (_tmp3_, "articlelist-oldest-first");
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("ASC");
		_g_free0 (desc);
		desc = _tmp5_;
	}
	if (searchRows != 0) {
		const gchar* _tmp6_ = NULL;
		GSettings* _tmp7_;
		GSettings* _tmp8_;
		gboolean _tmp9_;
		gchar* order_by = NULL;
		gchar* _tmp10_;
		FeedReaderQueryBuilder* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp7_ = feed_reader_settings_general ();
		_tmp8_ = _tmp7_;
		_tmp9_ = ((FeedReaderArticleListSort) g_settings_get_enum (_tmp8_, "articlelist-sort-by")) == FEED_READER_ARTICLE_LIST_SORT_RECEIVED;
		_g_object_unref0 (_tmp8_);
		if (_tmp9_) {
			_tmp6_ = "rowid";
		} else {
			_tmp6_ = "date";
		}
		_tmp10_ = g_strdup (_tmp6_);
		order_by = _tmp10_;
		_tmp11_ = query;
		_tmp12_ = order_by;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = desc;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strdup_printf ("%i", searchRows);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("articleID in (SELECT articleID FROM articles ORDER BY ", _tmp13_, " ", _tmp15_, " LIMIT ", _tmp17_, ")", NULL);
		_tmp19_ = _tmp18_;
		feed_reader_query_builder_where (_tmp11_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (order_by);
	}
	_tmp20_ = query;
	feed_reader_query_builder_limit (_tmp20_, limit);
	_tmp21_ = query;
	feed_reader_query_builder_offset (_tmp21_, offset);
	_tmp22_ = self->m_db;
	_tmp23_ = query;
	_tmp24_ = feed_reader_query_builder_to_string (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = feed_reader_sq_lite_prepare (_tmp22_, _tmp25_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	stmt = _tmp27_;
	_tmp28_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	results = _tmp28_;
	while (TRUE) {
		sqlite3_stmt* _tmp29_;
		GeeLinkedList* _tmp30_;
		sqlite3_stmt* _tmp31_;
		const gchar* _tmp32_;
		sqlite3_stmt* _tmp33_;
		const gchar* _tmp34_;
		sqlite3_stmt* _tmp35_;
		const gchar* _tmp36_;
		sqlite3_stmt* _tmp37_;
		const gchar* _tmp38_;
		sqlite3_stmt* _tmp39_;
		sqlite3_stmt* _tmp40_;
		sqlite3_stmt* _tmp41_;
		const gchar* _tmp42_;
		sqlite3_stmt* _tmp43_;
		const gchar* _tmp44_;
		sqlite3_stmt* _tmp45_;
		GDateTime* _tmp46_;
		GDateTime* _tmp47_;
		sqlite3_stmt* _tmp48_;
		sqlite3_stmt* _tmp49_;
		const gchar* _tmp50_;
		GeeList* _tmp51_;
		GeeList* _tmp52_;
		sqlite3_stmt* _tmp53_;
		const gchar* _tmp54_;
		GeeList* _tmp55_;
		GeeList* _tmp56_;
		sqlite3_stmt* _tmp57_;
		const gchar* _tmp58_;
		FeedReaderArticle* _tmp59_;
		FeedReaderArticle* _tmp60_;
		_tmp29_ = stmt;
		if (!(sqlite3_step (_tmp29_) == SQLITE_ROW)) {
			break;
		}
		_tmp30_ = results;
		_tmp31_ = stmt;
		_tmp32_ = sqlite3_column_text (_tmp31_, 2);
		_tmp33_ = stmt;
		_tmp34_ = sqlite3_column_text (_tmp33_, 3);
		_tmp35_ = stmt;
		_tmp36_ = sqlite3_column_text (_tmp35_, 5);
		_tmp37_ = stmt;
		_tmp38_ = sqlite3_column_text (_tmp37_, 1);
		_tmp39_ = stmt;
		_tmp40_ = stmt;
		_tmp41_ = stmt;
		_tmp42_ = sqlite3_column_text (_tmp41_, 6);
		_tmp43_ = stmt;
		_tmp44_ = sqlite3_column_text (_tmp43_, 4);
		_tmp45_ = stmt;
		_tmp46_ = g_date_time_new_from_unix_local ((gint64) sqlite3_column_int (_tmp45_, 9));
		_tmp47_ = _tmp46_;
		_tmp48_ = stmt;
		_tmp49_ = stmt;
		_tmp50_ = sqlite3_column_text (_tmp49_, 2);
		_tmp51_ = feed_reader_data_base_read_only_read_taggings_by_article_id (self, _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = stmt;
		_tmp54_ = sqlite3_column_text (_tmp53_, 2);
		_tmp55_ = feed_reader_data_base_read_only_read_enclosures (self, _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = stmt;
		_tmp58_ = sqlite3_column_text (_tmp57_, 10);
		_tmp59_ = feed_reader_article_new (_tmp32_, _tmp34_, _tmp36_, _tmp38_, (FeedReaderArticleStatus) sqlite3_column_int (_tmp39_, 7), (FeedReaderArticleStatus) sqlite3_column_int (_tmp40_, 8), NULL, _tmp42_, _tmp44_, _tmp47_, sqlite3_column_int (_tmp48_, 0), _tmp52_, _tmp56_, _tmp58_, 0);
		_tmp60_ = _tmp59_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp60_);
		_g_object_unref0 (_tmp60_);
		_g_object_unref0 (_tmp56_);
		_g_object_unref0 (_tmp52_);
		_g_date_time_unref0 (_tmp47_);
	}
	result = (GeeList*) results;
	_sqlite3_finalize0 (stmt);
	_g_free0 (desc);
	_g_object_unref0 (query);
	return result;
}

static void
feed_reader_data_base_read_only_class_init (FeedReaderDataBaseReadOnlyClass * klass,
                                            gpointer klass_data)
{
	feed_reader_data_base_read_only_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_data_base_read_only_finalize;
	sqlite3_config (SQLITE_CONFIG_LOG, feed_reader_data_base_read_only_errorLogCallback);
}

static void
feed_reader_data_base_read_only_instance_init (FeedReaderDataBaseReadOnly * self,
                                               gpointer klass)
{
}

static void
feed_reader_data_base_read_only_finalize (GObject * obj)
{
	FeedReaderDataBaseReadOnly * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_DATA_BASE_READ_ONLY, FeedReaderDataBaseReadOnly);
	_g_object_unref0 (self->m_db);
	G_OBJECT_CLASS (feed_reader_data_base_read_only_parent_class)->finalize (obj);
}

static GType
feed_reader_data_base_read_only_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderDataBaseReadOnlyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_data_base_read_only_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderDataBaseReadOnly), 0, (GInstanceInitFunc) feed_reader_data_base_read_only_instance_init, NULL };
	GType feed_reader_data_base_read_only_type_id;
	feed_reader_data_base_read_only_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderDataBaseReadOnly", &g_define_type_info, 0);
	return feed_reader_data_base_read_only_type_id;
}

GType
feed_reader_data_base_read_only_get_type (void)
{
	static volatile gsize feed_reader_data_base_read_only_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_data_base_read_only_type_id__once)) {
		GType feed_reader_data_base_read_only_type_id;
		feed_reader_data_base_read_only_type_id = feed_reader_data_base_read_only_get_type_once ();
		g_once_init_leave (&feed_reader_data_base_read_only_type_id__once, feed_reader_data_base_read_only_type_id);
	}
	return feed_reader_data_base_read_only_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

