/* DataBaseWriteAccess.c generated by valac 0.56.3, the Vala compiler
 * generated from DataBaseWriteAccess.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

enum  {
	FEED_READER_DATA_BASE_0_PROPERTY,
	FEED_READER_DATA_BASE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_data_base_properties[FEED_READER_DATA_BASE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _sqlite3_value_free0(var) ((var == NULL) ? NULL : (var = (sqlite3_value_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer feed_reader_data_base_parent_class = NULL;

static void feed_reader_data_base_delete_article (FeedReaderDataBase* self,
                                           const gchar* articleID,
                                           const gchar* feedID);
static void _vala_GValue_free (GValue* self);
static void feed_reader_data_base_write_taggings (FeedReaderDataBase* self,
                                           FeedReaderArticle* article);
static void feed_reader_data_base_write_enclosures (FeedReaderDataBase* self,
                                             FeedReaderArticle* article);
static GType feed_reader_data_base_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

FeedReaderDataBase*
feed_reader_data_base_writeAccess (void)
{
	FeedReaderDataBase* database = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	FeedReaderDataBase* _tmp2_;
	FeedReaderDataBase* _tmp3_;
	FeedReaderDataBase* _tmp4_;
	FeedReaderDataBase* result;
	_tmp0_ = g_strdup_printf ("feedreader-%01i.db", FEED_READER_CONSTANTS_DB_SCHEMA_VERSION);
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	database = _tmp3_;
	_tmp4_ = database;
	if (feed_reader_data_base_read_only_uninitialized ((FeedReaderDataBaseReadOnly*) _tmp4_)) {
		FeedReaderDataBase* _tmp5_;
		_tmp5_ = database;
		feed_reader_data_base_read_only_init ((FeedReaderDataBaseReadOnly*) _tmp5_);
	}
	result = database;
	return result;
}

FeedReaderDataBaseReadOnly*
feed_reader_data_base_readOnly (void)
{
	FeedReaderDataBase* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	FeedReaderDataBaseReadOnly* result;
	_tmp0_ = feed_reader_data_base_writeAccess ();
	_tmp1_ = FEED_READER_IS_DATA_BASE_READ_ONLY (_tmp0_) ? ((FeedReaderDataBaseReadOnly*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

FeedReaderDataBase*
feed_reader_data_base_construct (GType object_type,
                                 const gchar* dbFile)
{
	FeedReaderDataBase * self = NULL;
	g_return_val_if_fail (dbFile != NULL, NULL);
	self = (FeedReaderDataBase*) feed_reader_data_base_read_only_construct (object_type, dbFile);
	return self;
}

FeedReaderDataBase*
feed_reader_data_base_new (const gchar* dbFile)
{
	return feed_reader_data_base_construct (FEED_READER_TYPE_DATA_BASE, dbFile);
}

void
feed_reader_data_base_checkpoint (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_checkpoint (_tmp0_);
}

gboolean
feed_reader_data_base_resetDB (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderSQLite* _tmp1_;
	FeedReaderSQLite* _tmp2_;
	FeedReaderSQLite* _tmp3_;
	FeedReaderSQLite* _tmp4_;
	FeedReaderSQLite* _tmp5_;
	FeedReaderSQLite* _tmp6_;
	FeedReaderSQLite* _tmp7_;
	FeedReaderSQLite* _tmp8_;
	gchar* query = NULL;
	gchar* _tmp9_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp10_;
	const gchar* _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint cols = 0;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	feed_reader_logger_warning ("resetDB");
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "DROP TABLE main.fts_table");
	_tmp1_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp1_, "DROP TABLE main.taggings");
	_tmp2_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp2_, "DROP TABLE main.Enclosures");
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp3_, "DROP TABLE main.CachedActions");
	_tmp4_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp4_, "DROP TABLE main.tags");
	_tmp5_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp5_, "DROP TABLE main.articles");
	_tmp6_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp6_, "DROP TABLE main.categories");
	_tmp7_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp7_, "DROP TABLE main.feeds");
	_tmp8_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp8_, "VACUUM");
	_tmp9_ = g_strdup ("PRAGMA INTEGRITY_CHECK");
	query = _tmp9_;
	_tmp10_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp11_ = query;
	_tmp12_ = feed_reader_sq_lite_prepare (_tmp10_, _tmp11_);
	stmt = _tmp12_;
	_tmp13_ = stmt;
	cols = sqlite3_column_count (_tmp13_);
	while (TRUE) {
		sqlite3_stmt* _tmp14_;
		_tmp14_ = stmt;
		if (!(sqlite3_step (_tmp14_) == SQLITE_ROW)) {
			break;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					sqlite3_stmt* _tmp17_;
					const gchar* _tmp18_;
					if (!_tmp15_) {
						gint _tmp16_;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					if (!(i < cols)) {
						break;
					}
					_tmp17_ = stmt;
					_tmp18_ = sqlite3_column_text (_tmp17_, i);
					if (g_strcmp0 (_tmp18_, "ok") != 0) {
						feed_reader_logger_error ("resetting the database failed");
						result = FALSE;
						_sqlite3_finalize0 (stmt);
						_g_free0 (query);
						return result;
					}
				}
			}
		}
	}
	_tmp19_ = stmt;
	sqlite3_reset (_tmp19_);
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	_g_free0 (query);
	return result;
}

void
feed_reader_data_base_updateFTS (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "INSERT INTO fts_table(fts_table) VALUES('rebuild')");
}

void
feed_reader_data_base_springCleaning (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "VACUUM");
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = feed_reader_settings_state ();
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp3_, "last-spring-cleaning", (gint) g_date_time_to_unix (now));
	_g_object_unref0 (_tmp3_);
	_g_date_time_unref0 (now);
}

void
feed_reader_data_base_dropOldArticles (FeedReaderDataBase* self,
                                       gint max_age_days)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	FeedReaderFeedServer* _tmp9_;
	FeedReaderFeedServer* _tmp10_;
	gboolean _tmp11_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp20_;
	FeedReaderQueryBuilder* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	sqlite3_stmt* _tmp24_;
	sqlite3_stmt* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "main.articles");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_select_field (_tmp1_, "articleID");
	_tmp2_ = query;
	feed_reader_query_builder_select_field (_tmp2_, "feedID");
	_tmp3_ = query;
	_tmp4_ = g_strdup_printf ("%i", max_age_days);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("datetime(date, 'unixepoch', 'localtime') <= datetime('now', '-", _tmp5_, " days')", NULL);
	_tmp7_ = _tmp6_;
	feed_reader_query_builder_where (_tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = query;
	feed_reader_query_builder_where_equal_int (_tmp8_, "marked", (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_UNMARKED));
	_tmp9_ = feed_reader_feed_server_get_default ();
	_tmp10_ = _tmp9_;
	_tmp11_ = feed_reader_feed_server_useMaxArticles (_tmp10_);
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		gint syncCount = 0;
		GSettings* _tmp12_;
		GSettings* _tmp13_;
		gint _tmp14_;
		FeedReaderQueryBuilder* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp12_ = feed_reader_settings_general ();
		_tmp13_ = _tmp12_;
		_tmp14_ = g_settings_get_int (_tmp13_, "max-articles");
		_g_object_unref0 (_tmp13_);
		syncCount = _tmp14_;
		_tmp15_ = query;
		_tmp16_ = g_strdup_printf ("%i", syncCount);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("rowid BETWEEN 1 AND (SELECT rowid FROM articles ORDER BY rowid DESC LI" \
"MIT 1 OFFSET ", _tmp17_, ")", NULL);
		_tmp19_ = _tmp18_;
		feed_reader_query_builder_where (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
	}
	_tmp20_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp21_ = query;
	_tmp22_ = feed_reader_query_builder_to_string (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = feed_reader_sq_lite_prepare (_tmp20_, _tmp23_);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	stmt = _tmp25_;
	while (TRUE) {
		sqlite3_stmt* _tmp26_;
		sqlite3_stmt* _tmp27_;
		const gchar* _tmp28_;
		sqlite3_stmt* _tmp29_;
		const gchar* _tmp30_;
		_tmp26_ = stmt;
		if (!(sqlite3_step (_tmp26_) == SQLITE_ROW)) {
			break;
		}
		_tmp27_ = stmt;
		_tmp28_ = sqlite3_column_text (_tmp27_, 0);
		_tmp29_ = stmt;
		_tmp30_ = sqlite3_column_text (_tmp29_, 1);
		feed_reader_data_base_delete_article (self, _tmp28_, _tmp30_);
	}
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
feed_reader_data_base_delete_article (FeedReaderDataBase* self,
                                      const gchar* articleID,
                                      const gchar* feedID)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FeedReaderSQLite* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	FeedReaderSQLite* _tmp9_;
	GValue* _tmp10_ = NULL;
	GValue** _tmp11_;
	GValue** _tmp12_;
	gint _tmp12__length1;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	gchar* folder_path = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = string_to_string (articleID);
	_tmp1_ = g_strconcat ("Deleting article \"", _tmp0_, "\"", NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_info (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, articleID);
	_tmp5_ = g_new0 (GValue*, 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp3_, "DELETE FROM main.articles WHERE articleID = ?", _tmp6_, (gint) 1);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_tmp9_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp10_ = g_new0 (GValue, 1);
	g_value_init (_tmp10_, G_TYPE_STRING);
	g_value_set_string (_tmp10_, articleID);
	_tmp11_ = g_new0 (GValue*, 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	_tmp13_ = feed_reader_sq_lite_execute (_tmp9_, "DELETE FROM main.Enclosures WHERE articleID = ?", _tmp12_, (gint) 1);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_tmp15_ = g_get_user_data_dir ();
	_tmp16_ = string_to_string (feedID);
	_tmp17_ = string_to_string (articleID);
	_tmp18_ = g_strconcat ("/feedreader/data/images/", _tmp16_, "/", _tmp17_, "/", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	folder_path = _tmp21_;
	feed_reader_utils_remove_directory (folder_path, (guint) 0);
	_g_free0 (folder_path);
}

void
feed_reader_data_base_dropTag (FeedReaderDataBase* self,
                               FeedReaderTag* tag)
{
	FeedReaderSQLite* _tmp0_;
	gchar* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue** _tmp3_;
	GValue** _tmp4_;
	gint _tmp4__length1;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	FeedReaderSQLite* _tmp7_;
	gchar* _tmp8_;
	GValue* _tmp9_ = NULL;
	GValue** _tmp10_;
	GValue** _tmp11_;
	gint _tmp11__length1;
	GeeList* _tmp12_;
	GeeList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp1_ = feed_reader_tag_getTagID (tag);
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_STRING);
	g_value_take_string (_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue*, 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = feed_reader_sq_lite_execute (_tmp0_, "DELETE FROM main.tags WHERE tagID = ?", _tmp4_, (gint) 1);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_tmp7_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp8_ = feed_reader_tag_getTagID (tag);
	_tmp9_ = g_new0 (GValue, 1);
	g_value_init (_tmp9_, G_TYPE_STRING);
	g_value_take_string (_tmp9_, _tmp8_);
	_tmp10_ = g_new0 (GValue*, 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	_tmp12_ = feed_reader_sq_lite_execute (_tmp7_, "DELETE FROM main.taggings WHERE tagID = ?", _tmp11_, (gint) 1);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) _vala_GValue_free), NULL);
}

void
feed_reader_data_base_write_feeds (FeedReaderDataBase* self,
                                   GeeCollection* feeds)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	FeedReaderQueryBuilder* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp9_;
	FeedReaderQueryBuilder* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint feedID_pos = 0;
	sqlite3_stmt* _tmp15_;
	gint feedName_pos = 0;
	sqlite3_stmt* _tmp16_;
	gint feedURL_pos = 0;
	sqlite3_stmt* _tmp17_;
	gint catID_pos = 0;
	sqlite3_stmt* _tmp18_;
	gint xmlURL_pos = 0;
	sqlite3_stmt* _tmp19_;
	gint iconURL_pos = 0;
	sqlite3_stmt* _tmp20_;
	FeedReaderSQLite* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feeds != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_REPLACE, "main.feeds");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "feed_id", "$FEEDID");
	_tmp3_ = query;
	feed_reader_query_builder_insert_param (_tmp3_, "name", "$FEEDNAME");
	_tmp4_ = query;
	feed_reader_query_builder_insert_param (_tmp4_, "url", "$FEEDURL");
	_tmp5_ = query;
	feed_reader_query_builder_insert_param (_tmp5_, "category_id", "$CATID");
	_tmp6_ = query;
	feed_reader_query_builder_insert_int (_tmp6_, "subscribed", (gint64) 1);
	_tmp7_ = query;
	feed_reader_query_builder_insert_param (_tmp7_, "xmlURL", "$XMLURL");
	_tmp8_ = query;
	feed_reader_query_builder_insert_param (_tmp8_, "iconURL", "$ICONURL");
	_tmp9_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp10_ = query;
	_tmp11_ = feed_reader_query_builder_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = feed_reader_sq_lite_prepare (_tmp9_, _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	stmt = _tmp14_;
	_tmp15_ = stmt;
	feedID_pos = sqlite3_bind_parameter_index (_tmp15_, "$FEEDID");
	_tmp16_ = stmt;
	feedName_pos = sqlite3_bind_parameter_index (_tmp16_, "$FEEDNAME");
	_tmp17_ = stmt;
	feedURL_pos = sqlite3_bind_parameter_index (_tmp17_, "$FEEDURL");
	_tmp18_ = stmt;
	catID_pos = sqlite3_bind_parameter_index (_tmp18_, "$CATID");
	_tmp19_ = stmt;
	xmlURL_pos = sqlite3_bind_parameter_index (_tmp19_, "$XMLURL");
	_tmp20_ = stmt;
	iconURL_pos = sqlite3_bind_parameter_index (_tmp20_, "$ICONURL");
	_vala_assert (feedID_pos > 0, "feedID_pos > 0");
	_vala_assert (feedName_pos > 0, "feedName_pos > 0");
	_vala_assert (feedURL_pos > 0, "feedURL_pos > 0");
	_vala_assert (catID_pos > 0, "catID_pos > 0");
	_vala_assert (xmlURL_pos > 0, "xmlURL_pos > 0");
	_vala_assert (iconURL_pos > 0, "iconURL_pos > 0");
	{
		GeeIterator* _feed_item_it = NULL;
		GeeIterator* _tmp21_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) feeds);
		_feed_item_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_;
			FeedReaderFeed* feed_item = NULL;
			GeeIterator* _tmp23_;
			gpointer _tmp24_;
			sqlite3_stmt* _tmp25_;
			FeedReaderFeed* _tmp26_;
			gchar* _tmp27_;
			GDestroyNotify _tmp28_;
			sqlite3_stmt* _tmp29_;
			FeedReaderFeed* _tmp30_;
			gchar* _tmp31_;
			GDestroyNotify _tmp32_;
			sqlite3_stmt* _tmp33_;
			FeedReaderFeed* _tmp34_;
			gchar* _tmp35_;
			GDestroyNotify _tmp36_;
			sqlite3_stmt* _tmp37_;
			FeedReaderFeed* _tmp38_;
			GeeList* _tmp39_;
			GeeList* _tmp40_;
			gchar* _tmp41_;
			GDestroyNotify _tmp42_;
			sqlite3_stmt* _tmp43_;
			FeedReaderFeed* _tmp44_;
			gchar* _tmp45_;
			GDestroyNotify _tmp46_;
			sqlite3_stmt* _tmp47_;
			FeedReaderFeed* _tmp48_;
			gchar* _tmp49_;
			GDestroyNotify _tmp50_;
			sqlite3_stmt* _tmp52_;
			_tmp22_ = _feed_item_it;
			if (!gee_iterator_next (_tmp22_)) {
				break;
			}
			_tmp23_ = _feed_item_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			feed_item = (FeedReaderFeed*) _tmp24_;
			_tmp25_ = stmt;
			_tmp26_ = feed_item;
			_tmp27_ = feed_reader_feed_getFeedID (_tmp26_);
			_tmp28_ = g_free;
			sqlite3_bind_text (_tmp25_, feedID_pos, _tmp27_, -1, _tmp28_);
			_tmp29_ = stmt;
			_tmp30_ = feed_item;
			_tmp31_ = feed_reader_feed_getTitle (_tmp30_);
			_tmp32_ = g_free;
			sqlite3_bind_text (_tmp29_, feedName_pos, _tmp31_, -1, _tmp32_);
			_tmp33_ = stmt;
			_tmp34_ = feed_item;
			_tmp35_ = feed_reader_feed_getURL (_tmp34_);
			_tmp36_ = g_free;
			sqlite3_bind_text (_tmp33_, feedURL_pos, _tmp35_, -1, _tmp36_);
			_tmp37_ = stmt;
			_tmp38_ = feed_item;
			_tmp39_ = feed_reader_feed_getCatIDs (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = feed_reader_string_utils_join ((GeeCollection*) _tmp40_, ",");
			_tmp42_ = g_free;
			sqlite3_bind_text (_tmp37_, catID_pos, _tmp41_, -1, _tmp42_);
			_g_object_unref0 (_tmp40_);
			_tmp43_ = stmt;
			_tmp44_ = feed_item;
			_tmp45_ = feed_reader_feed_getXmlUrl (_tmp44_);
			_tmp46_ = g_free;
			sqlite3_bind_text (_tmp43_, xmlURL_pos, _tmp45_, -1, _tmp46_);
			_tmp47_ = stmt;
			_tmp48_ = feed_item;
			_tmp49_ = feed_reader_feed_getIconURL (_tmp48_);
			_tmp50_ = g_free;
			sqlite3_bind_text (_tmp47_, iconURL_pos, _tmp49_, -1, _tmp50_);
			while (TRUE) {
				sqlite3_stmt* _tmp51_;
				_tmp51_ = stmt;
				if (!(sqlite3_step (_tmp51_) == SQLITE_ROW)) {
					break;
				}
			}
			_tmp52_ = stmt;
			sqlite3_reset (_tmp52_);
			_g_object_unref0 (feed_item);
		}
		_g_object_unref0 (_feed_item_it);
	}
	_tmp53_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp53_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

void
feed_reader_data_base_write_tag (FeedReaderDataBase* self,
                                 FeedReaderTag* tag)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) list, tag);
	feed_reader_data_base_write_tags (self, (GeeCollection*) list);
	_g_object_unref0 (list);
}

void
feed_reader_data_base_write_tags (FeedReaderDataBase* self,
                                  GeeCollection* tags)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	FeedReaderQueryBuilder* _tmp5_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	sqlite3_stmt* _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint tagID_position = 0;
	sqlite3_stmt* _tmp12_;
	gint label_position = 0;
	sqlite3_stmt* _tmp13_;
	gint color_position = 0;
	sqlite3_stmt* _tmp14_;
	FeedReaderSQLite* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tags != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_IGNORE, "main.tags");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "tagID", "$TAGID");
	_tmp3_ = query;
	feed_reader_query_builder_insert_param (_tmp3_, "title", "$LABEL");
	_tmp4_ = query;
	feed_reader_query_builder_insert_int (_tmp4_, "\"exists\"", (gint64) 1);
	_tmp5_ = query;
	feed_reader_query_builder_insert_param (_tmp5_, "color", "$COLOR");
	_tmp6_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp7_ = query;
	_tmp8_ = feed_reader_query_builder_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = feed_reader_sq_lite_prepare (_tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	stmt = _tmp11_;
	_tmp12_ = stmt;
	tagID_position = sqlite3_bind_parameter_index (_tmp12_, "$TAGID");
	_tmp13_ = stmt;
	label_position = sqlite3_bind_parameter_index (_tmp13_, "$LABEL");
	_tmp14_ = stmt;
	color_position = sqlite3_bind_parameter_index (_tmp14_, "$COLOR");
	_vala_assert (tagID_position > 0, "tagID_position > 0");
	_vala_assert (label_position > 0, "label_position > 0");
	_vala_assert (color_position > 0, "color_position > 0");
	{
		GeeIterator* _tag_item_it = NULL;
		GeeIterator* _tmp15_;
		_tmp15_ = gee_iterable_iterator ((GeeIterable*) tags);
		_tag_item_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			FeedReaderTag* tag_item = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			sqlite3_stmt* _tmp19_;
			FeedReaderTag* _tmp20_;
			gchar* _tmp21_;
			GDestroyNotify _tmp22_;
			sqlite3_stmt* _tmp23_;
			FeedReaderTag* _tmp24_;
			gchar* _tmp25_;
			GDestroyNotify _tmp26_;
			sqlite3_stmt* _tmp27_;
			FeedReaderTag* _tmp28_;
			sqlite3_stmt* _tmp30_;
			_tmp16_ = _tag_item_it;
			if (!gee_iterator_next (_tmp16_)) {
				break;
			}
			_tmp17_ = _tag_item_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			tag_item = (FeedReaderTag*) _tmp18_;
			_tmp19_ = stmt;
			_tmp20_ = tag_item;
			_tmp21_ = feed_reader_tag_getTagID (_tmp20_);
			_tmp22_ = g_free;
			sqlite3_bind_text (_tmp19_, tagID_position, _tmp21_, -1, _tmp22_);
			_tmp23_ = stmt;
			_tmp24_ = tag_item;
			_tmp25_ = feed_reader_tag_getTitle (_tmp24_);
			_tmp26_ = g_free;
			sqlite3_bind_text (_tmp23_, label_position, _tmp25_, -1, _tmp26_);
			_tmp27_ = stmt;
			_tmp28_ = tag_item;
			sqlite3_bind_int (_tmp27_, color_position, feed_reader_tag_getColor (_tmp28_));
			while (TRUE) {
				sqlite3_stmt* _tmp29_;
				_tmp29_ = stmt;
				if (!(sqlite3_step (_tmp29_) == SQLITE_ROW)) {
					break;
				}
			}
			_tmp30_ = stmt;
			sqlite3_reset (_tmp30_);
			_g_object_unref0 (tag_item);
		}
		_g_object_unref0 (_tag_item_it);
	}
	_tmp31_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp31_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
feed_reader_data_base_update_tag (FeedReaderDataBase* self,
                                  FeedReaderTag* tag)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	FeedReaderFeedServer* _tmp2_;
	FeedReaderFeedServer* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = feed_reader_list_utils_single (FEED_READER_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, tag);
	_tmp1_ = _tmp0_;
	feed_reader_data_base_update_tags (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = feed_reader_feed_server_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = feed_reader_feed_server_tagIDaffectedByNameChange (_tmp3_);
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		gchar* newID = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		FeedReaderSQLite* _tmp13_;
		const gchar* _tmp14_;
		GValue* _tmp15_ = NULL;
		gchar* _tmp16_;
		GValue* _tmp17_ = NULL;
		GValue** _tmp18_;
		GValue** _tmp19_;
		gint _tmp19__length1;
		GeeList* _tmp20_;
		GeeList* _tmp21_;
		_tmp5_ = feed_reader_tag_getTagID (tag);
		_tmp6_ = _tmp5_;
		_tmp7_ = feed_reader_tag_getTitle (tag);
		_tmp8_ = _tmp7_;
		_tmp9_ = feed_reader_tag_getTitle (tag);
		_tmp10_ = _tmp9_;
		_tmp11_ = string_replace (_tmp6_, _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		newID = _tmp12_;
		_tmp13_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
		_tmp14_ = newID;
		_tmp15_ = g_new0 (GValue, 1);
		g_value_init (_tmp15_, G_TYPE_STRING);
		g_value_set_string (_tmp15_, _tmp14_);
		_tmp16_ = feed_reader_tag_getTagID (tag);
		_tmp17_ = g_new0 (GValue, 1);
		g_value_init (_tmp17_, G_TYPE_STRING);
		g_value_take_string (_tmp17_, _tmp16_);
		_tmp18_ = g_new0 (GValue*, 2);
		_tmp18_[0] = _tmp15_;
		_tmp18_[1] = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp19__length1 = 2;
		_tmp20_ = feed_reader_sq_lite_execute (_tmp13_, "UPDATE tags SET tagID = ? WHERE tagID = ?", _tmp19_, (gint) 2);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp21_);
		_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) _vala_GValue_free), NULL);
		_g_free0 (newID);
	}
}

void
feed_reader_data_base_update_tags (FeedReaderDataBase* self,
                                   GeeList* tags)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	gint title_position = 0;
	sqlite3_stmt* _tmp11_;
	gint tagID_position = 0;
	sqlite3_stmt* _tmp12_;
	FeedReaderSQLite* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tags != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_UPDATE, "main.tags");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_update_param (_tmp2_, "title", "$TITLE");
	_tmp3_ = query;
	feed_reader_query_builder_update_int (_tmp3_, "\"exists\"", (gint64) 1);
	_tmp4_ = query;
	feed_reader_query_builder_where_equal_param (_tmp4_, "tagID", "$TAGID");
	_tmp5_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp6_ = query;
	_tmp7_ = feed_reader_query_builder_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = feed_reader_sq_lite_prepare (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	stmt = _tmp10_;
	_tmp11_ = stmt;
	title_position = sqlite3_bind_parameter_index (_tmp11_, "$TITLE");
	_tmp12_ = stmt;
	tagID_position = sqlite3_bind_parameter_index (_tmp12_, "$TAGID");
	_vala_assert (title_position > 0, "title_position > 0");
	_vala_assert (tagID_position > 0, "tagID_position > 0");
	{
		GeeList* _tag_item_list = NULL;
		gint _tag_item_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tag_item_index = 0;
		_tag_item_list = tags;
		_tmp13_ = _tag_item_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tag_item_size = _tmp15_;
		_tag_item_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			FeedReaderTag* tag_item = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			sqlite3_stmt* _tmp20_;
			FeedReaderTag* _tmp21_;
			gchar* _tmp22_;
			GDestroyNotify _tmp23_;
			sqlite3_stmt* _tmp24_;
			FeedReaderTag* _tmp25_;
			gchar* _tmp26_;
			GDestroyNotify _tmp27_;
			sqlite3_stmt* _tmp29_;
			_tag_item_index = _tag_item_index + 1;
			_tmp16_ = _tag_item_index;
			_tmp17_ = _tag_item_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _tag_item_list;
			_tmp19_ = gee_list_get (_tmp18_, _tag_item_index);
			tag_item = (FeedReaderTag*) _tmp19_;
			_tmp20_ = stmt;
			_tmp21_ = tag_item;
			_tmp22_ = feed_reader_tag_getTitle (_tmp21_);
			_tmp23_ = g_free;
			sqlite3_bind_text (_tmp20_, title_position, _tmp22_, -1, _tmp23_);
			_tmp24_ = stmt;
			_tmp25_ = tag_item;
			_tmp26_ = feed_reader_tag_getTagID (_tmp25_);
			_tmp27_ = g_free;
			sqlite3_bind_text (_tmp24_, tagID_position, _tmp26_, -1, _tmp27_);
			while (TRUE) {
				sqlite3_stmt* _tmp28_;
				_tmp28_ = stmt;
				if (!(sqlite3_step (_tmp28_) == SQLITE_ROW)) {
					break;
				}
			}
			_tmp29_ = stmt;
			sqlite3_reset (_tmp29_);
			_g_object_unref0 (tag_item);
		}
	}
	_tmp30_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp30_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

void
feed_reader_data_base_write_categories (FeedReaderDataBase* self,
                                        GeeList* categories)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	FeedReaderQueryBuilder* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp8_;
	FeedReaderQueryBuilder* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	sqlite3_stmt* _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint catID_position = 0;
	sqlite3_stmt* _tmp14_;
	gint feedName_position = 0;
	sqlite3_stmt* _tmp15_;
	gint orderID_position = 0;
	sqlite3_stmt* _tmp16_;
	gint parent_position = 0;
	sqlite3_stmt* _tmp17_;
	gint level_position = 0;
	sqlite3_stmt* _tmp18_;
	FeedReaderSQLite* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (categories != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_REPLACE, "main.categories");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "categorieID", "$CATID");
	_tmp3_ = query;
	feed_reader_query_builder_insert_param (_tmp3_, "title", "$FEEDNAME");
	_tmp4_ = query;
	feed_reader_query_builder_insert_param (_tmp4_, "orderID", "$ORDERID");
	_tmp5_ = query;
	feed_reader_query_builder_insert_int (_tmp5_, "\"exists\"", (gint64) 1);
	_tmp6_ = query;
	feed_reader_query_builder_insert_param (_tmp6_, "Parent", "$PARENT");
	_tmp7_ = query;
	feed_reader_query_builder_insert_param (_tmp7_, "Level", "$LEVEL");
	_tmp8_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp9_ = query;
	_tmp10_ = feed_reader_query_builder_to_string (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = feed_reader_sq_lite_prepare (_tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	stmt = _tmp13_;
	_tmp14_ = stmt;
	catID_position = sqlite3_bind_parameter_index (_tmp14_, "$CATID");
	_tmp15_ = stmt;
	feedName_position = sqlite3_bind_parameter_index (_tmp15_, "$FEEDNAME");
	_tmp16_ = stmt;
	orderID_position = sqlite3_bind_parameter_index (_tmp16_, "$ORDERID");
	_tmp17_ = stmt;
	parent_position = sqlite3_bind_parameter_index (_tmp17_, "$PARENT");
	_tmp18_ = stmt;
	level_position = sqlite3_bind_parameter_index (_tmp18_, "$LEVEL");
	_vala_assert (catID_position > 0, "catID_position > 0");
	_vala_assert (feedName_position > 0, "feedName_position > 0");
	_vala_assert (orderID_position > 0, "orderID_position > 0");
	_vala_assert (parent_position > 0, "parent_position > 0");
	_vala_assert (level_position > 0, "level_position > 0");
	{
		GeeList* _cat_item_list = NULL;
		gint _cat_item_size = 0;
		GeeList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _cat_item_index = 0;
		_cat_item_list = categories;
		_tmp19_ = _cat_item_list;
		_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_cat_item_size = _tmp21_;
		_cat_item_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			FeedReaderCategory* cat_item = NULL;
			GeeList* _tmp24_;
			gpointer _tmp25_;
			sqlite3_stmt* _tmp26_;
			FeedReaderCategory* _tmp27_;
			gchar* _tmp28_;
			GDestroyNotify _tmp29_;
			sqlite3_stmt* _tmp30_;
			FeedReaderCategory* _tmp31_;
			gchar* _tmp32_;
			GDestroyNotify _tmp33_;
			sqlite3_stmt* _tmp34_;
			FeedReaderCategory* _tmp35_;
			sqlite3_stmt* _tmp36_;
			FeedReaderCategory* _tmp37_;
			gchar* _tmp38_;
			GDestroyNotify _tmp39_;
			sqlite3_stmt* _tmp40_;
			FeedReaderCategory* _tmp41_;
			sqlite3_stmt* _tmp43_;
			_cat_item_index = _cat_item_index + 1;
			_tmp22_ = _cat_item_index;
			_tmp23_ = _cat_item_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _cat_item_list;
			_tmp25_ = gee_list_get (_tmp24_, _cat_item_index);
			cat_item = (FeedReaderCategory*) _tmp25_;
			_tmp26_ = stmt;
			_tmp27_ = cat_item;
			_tmp28_ = feed_reader_category_getCatID (_tmp27_);
			_tmp29_ = g_free;
			sqlite3_bind_text (_tmp26_, catID_position, _tmp28_, -1, _tmp29_);
			_tmp30_ = stmt;
			_tmp31_ = cat_item;
			_tmp32_ = feed_reader_category_getTitle (_tmp31_);
			_tmp33_ = g_free;
			sqlite3_bind_text (_tmp30_, feedName_position, _tmp32_, -1, _tmp33_);
			_tmp34_ = stmt;
			_tmp35_ = cat_item;
			sqlite3_bind_int (_tmp34_, orderID_position, feed_reader_category_getOrderID (_tmp35_));
			_tmp36_ = stmt;
			_tmp37_ = cat_item;
			_tmp38_ = feed_reader_category_getParent (_tmp37_);
			_tmp39_ = g_free;
			sqlite3_bind_text (_tmp36_, parent_position, _tmp38_, -1, _tmp39_);
			_tmp40_ = stmt;
			_tmp41_ = cat_item;
			sqlite3_bind_int (_tmp40_, level_position, feed_reader_category_getLevel (_tmp41_));
			while (TRUE) {
				sqlite3_stmt* _tmp42_;
				_tmp42_ = stmt;
				if (!(sqlite3_step (_tmp42_) == SQLITE_ROW)) {
					break;
				}
			}
			_tmp43_ = stmt;
			sqlite3_reset (_tmp43_);
			_g_object_unref0 (cat_item);
		}
	}
	_tmp44_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp44_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

void
feed_reader_data_base_updateArticlesByID (FeedReaderDataBase* self,
                                          GeeList* ids,
                                          const gchar* field)
{
	FeedReaderQueryBuilder* reset_query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderSQLite* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderSQLite* _tmp7_;
	FeedReaderQueryBuilder* update_query = NULL;
	FeedReaderQueryBuilder* _tmp8_;
	FeedReaderQueryBuilder* _tmp11_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp12_;
	FeedReaderQueryBuilder* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint articleID_position = 0;
	sqlite3_stmt* _tmp18_;
	FeedReaderSQLite* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ids != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_UPDATE, "main.articles");
	reset_query = _tmp0_;
	if (g_strcmp0 (field, "unread") == 0) {
		FeedReaderQueryBuilder* _tmp1_;
		_tmp1_ = reset_query;
		feed_reader_query_builder_update_int (_tmp1_, field, (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_READ));
	} else {
		if (g_strcmp0 (field, "marked") == 0) {
			FeedReaderQueryBuilder* _tmp2_;
			_tmp2_ = reset_query;
			feed_reader_query_builder_update_int (_tmp2_, field, (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_UNMARKED));
		}
	}
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp4_ = reset_query;
	_tmp5_ = feed_reader_query_builder_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	feed_reader_sq_lite_simple_query (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp7_, "BEGIN TRANSACTION");
	_tmp8_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_UPDATE, "main.articles");
	update_query = _tmp8_;
	if (g_strcmp0 (field, "unread") == 0) {
		FeedReaderQueryBuilder* _tmp9_;
		_tmp9_ = update_query;
		feed_reader_query_builder_update_int (_tmp9_, field, (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_UNREAD));
	} else {
		if (g_strcmp0 (field, "marked") == 0) {
			FeedReaderQueryBuilder* _tmp10_;
			_tmp10_ = update_query;
			feed_reader_query_builder_update_int (_tmp10_, field, (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_MARKED));
		}
	}
	_tmp11_ = update_query;
	feed_reader_query_builder_where_equal_param (_tmp11_, "articleID", "$ARTICLEID");
	_tmp12_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp13_ = update_query;
	_tmp14_ = feed_reader_query_builder_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = feed_reader_sq_lite_prepare (_tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	stmt = _tmp17_;
	_tmp18_ = stmt;
	articleID_position = sqlite3_bind_parameter_index (_tmp18_, "$ARTICLEID");
	_vala_assert (articleID_position > 0, "articleID_position > 0");
	{
		GeeList* _id_list = NULL;
		gint _id_size = 0;
		GeeList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _id_index = 0;
		_id_list = ids;
		_tmp19_ = _id_list;
		_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_id_size = _tmp21_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gchar* id = NULL;
			GeeList* _tmp24_;
			gpointer _tmp25_;
			sqlite3_stmt* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			GDestroyNotify _tmp29_;
			sqlite3_stmt* _tmp31_;
			_id_index = _id_index + 1;
			_tmp22_ = _id_index;
			_tmp23_ = _id_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _id_list;
			_tmp25_ = gee_list_get (_tmp24_, _id_index);
			id = (gchar*) _tmp25_;
			_tmp26_ = stmt;
			_tmp27_ = id;
			_tmp28_ = g_strdup (_tmp27_);
			_tmp29_ = g_free;
			sqlite3_bind_text (_tmp26_, articleID_position, _tmp28_, -1, _tmp29_);
			while (TRUE) {
				sqlite3_stmt* _tmp30_;
				_tmp30_ = stmt;
				if (!(sqlite3_step (_tmp30_) != SQLITE_DONE)) {
					break;
				}
			}
			_tmp31_ = stmt;
			sqlite3_reset (_tmp31_);
			_g_free0 (id);
		}
	}
	_tmp32_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp32_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (update_query);
	_g_object_unref0 (reset_query);
}

void
feed_reader_data_base_writeContent (FeedReaderDataBase* self,
                                    FeedReaderArticle* article)
{
	FeedReaderQueryBuilder* update_query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint html_position = 0;
	sqlite3_stmt* _tmp13_;
	gint preview_position = 0;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	gchar* _tmp16_;
	GDestroyNotify _tmp17_;
	sqlite3_stmt* _tmp18_;
	gchar* _tmp19_;
	GDestroyNotify _tmp20_;
	sqlite3_stmt* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (article != NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_UPDATE, "main.articles");
	update_query = _tmp0_;
	_tmp1_ = update_query;
	feed_reader_query_builder_update_param (_tmp1_, "html", "$HTML");
	_tmp2_ = update_query;
	feed_reader_query_builder_update_param (_tmp2_, "preview", "$PREVIEW");
	_tmp3_ = update_query;
	feed_reader_query_builder_update_int (_tmp3_, "contentFetched", (gint64) 1);
	_tmp4_ = update_query;
	_tmp5_ = feed_reader_article_getArticleID (article);
	_tmp6_ = _tmp5_;
	feed_reader_query_builder_where_equal_string (_tmp4_, "articleID", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp8_ = update_query;
	_tmp9_ = feed_reader_query_builder_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = feed_reader_sq_lite_prepare (_tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	stmt = _tmp12_;
	_tmp13_ = stmt;
	html_position = sqlite3_bind_parameter_index (_tmp13_, "$HTML");
	_tmp14_ = stmt;
	preview_position = sqlite3_bind_parameter_index (_tmp14_, "$PREVIEW");
	_vala_assert (html_position > 0, "html_position > 0");
	_vala_assert (preview_position > 0, "preview_position > 0");
	_tmp15_ = stmt;
	_tmp16_ = feed_reader_article_getHTML (article);
	_tmp17_ = g_free;
	sqlite3_bind_text (_tmp15_, html_position, _tmp16_, -1, _tmp17_);
	_tmp18_ = stmt;
	_tmp19_ = feed_reader_article_getPreview (article);
	_tmp20_ = g_free;
	sqlite3_bind_text (_tmp18_, preview_position, _tmp19_, -1, _tmp20_);
	while (TRUE) {
		sqlite3_stmt* _tmp21_;
		_tmp21_ = stmt;
		if (!(sqlite3_step (_tmp21_) != SQLITE_DONE)) {
			break;
		}
	}
	_tmp22_ = stmt;
	sqlite3_reset (_tmp22_);
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (update_query);
}

void
feed_reader_data_base_update_article (FeedReaderDataBase* self,
                                      FeedReaderArticle* article)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (article != NULL);
	_tmp0_ = feed_reader_list_utils_single (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, article);
	_tmp1_ = _tmp0_;
	feed_reader_data_base_update_articles (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

void
feed_reader_data_base_update_articles (FeedReaderDataBase* self,
                                       GeeList* articles)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* update_query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	FeedReaderQueryBuilder* _tmp5_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	sqlite3_stmt* _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint unread_position = 0;
	sqlite3_stmt* _tmp12_;
	gint marked_position = 0;
	sqlite3_stmt* _tmp13_;
	gint modified_position = 0;
	sqlite3_stmt* _tmp14_;
	gint articleID_position = 0;
	sqlite3_stmt* _tmp15_;
	FeedReaderSQLite* _tmp65_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_UPDATE, "main.articles");
	update_query = _tmp1_;
	_tmp2_ = update_query;
	feed_reader_query_builder_update_param (_tmp2_, "unread", "$UNREAD");
	_tmp3_ = update_query;
	feed_reader_query_builder_update_param (_tmp3_, "marked", "$MARKED");
	_tmp4_ = update_query;
	feed_reader_query_builder_update_param (_tmp4_, "lastModified", "$LASTMODIFIED");
	_tmp5_ = update_query;
	feed_reader_query_builder_where_equal_param (_tmp5_, "articleID", "$ARTICLEID");
	_tmp6_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp7_ = update_query;
	_tmp8_ = feed_reader_query_builder_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = feed_reader_sq_lite_prepare (_tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	stmt = _tmp11_;
	_tmp12_ = stmt;
	unread_position = sqlite3_bind_parameter_index (_tmp12_, "$UNREAD");
	_tmp13_ = stmt;
	marked_position = sqlite3_bind_parameter_index (_tmp13_, "$MARKED");
	_tmp14_ = stmt;
	modified_position = sqlite3_bind_parameter_index (_tmp14_, "$LASTMODIFIED");
	_tmp15_ = stmt;
	articleID_position = sqlite3_bind_parameter_index (_tmp15_, "$ARTICLEID");
	_vala_assert (unread_position > 0, "unread_position > 0");
	_vala_assert (marked_position > 0, "marked_position > 0");
	_vala_assert (modified_position > 0, "modified_position > 0");
	_vala_assert (articleID_position > 0, "articleID_position > 0");
	{
		GeeList* _a_list = NULL;
		gint _a_size = 0;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _a_index = 0;
		_a_list = articles;
		_tmp16_ = _a_list;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_a_size = _tmp18_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			FeedReaderArticle* a = NULL;
			GeeList* _tmp21_;
			gpointer _tmp22_;
			FeedReaderArticleStatus unread = 0;
			FeedReaderActionCache* _tmp23_;
			FeedReaderActionCache* _tmp24_;
			FeedReaderArticle* _tmp25_;
			FeedReaderArticleStatus _tmp26_;
			FeedReaderArticleStatus marked = 0;
			FeedReaderActionCache* _tmp27_;
			FeedReaderActionCache* _tmp28_;
			FeedReaderArticle* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			FeedReaderArticle* _tmp32_;
			FeedReaderArticleStatus _tmp33_;
			gboolean _tmp34_ = FALSE;
			gboolean _tmp44_ = FALSE;
			sqlite3_stmt* _tmp54_;
			sqlite3_stmt* _tmp55_;
			sqlite3_stmt* _tmp56_;
			FeedReaderArticle* _tmp57_;
			sqlite3_stmt* _tmp58_;
			FeedReaderArticle* _tmp59_;
			gchar* _tmp60_;
			GDestroyNotify _tmp61_;
			sqlite3_stmt* _tmp63_;
			FeedReaderArticle* _tmp64_;
			_a_index = _a_index + 1;
			_tmp19_ = _a_index;
			_tmp20_ = _a_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _a_list;
			_tmp22_ = gee_list_get (_tmp21_, _a_index);
			a = (FeedReaderArticle*) _tmp22_;
			_tmp23_ = feed_reader_action_cache_get_default ();
			_tmp24_ = _tmp23_;
			_tmp25_ = a;
			_tmp26_ = feed_reader_action_cache_checkRead (_tmp24_, _tmp25_);
			_g_object_unref0 (_tmp24_);
			unread = _tmp26_;
			_tmp27_ = feed_reader_action_cache_get_default ();
			_tmp28_ = _tmp27_;
			_tmp29_ = a;
			_tmp30_ = feed_reader_article_getArticleID (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = a;
			_tmp33_ = feed_reader_action_cache_checkStarred (_tmp28_, _tmp31_, feed_reader_article_getMarked (_tmp32_));
			_g_free0 (_tmp31_);
			_g_object_unref0 (_tmp28_);
			marked = _tmp33_;
			if (unread != FEED_READER_ARTICLE_STATUS_READ) {
				_tmp34_ = unread != FEED_READER_ARTICLE_STATUS_UNREAD;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				FeedReaderArticle* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp35_ = feed_reader_article_status_to_string (unread);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat ("DataBase.update_articles: writing invalid unread status ", _tmp36_, " for article ", NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = a;
				_tmp40_ = feed_reader_article_getArticleID (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				feed_reader_logger_warning (_tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
			}
			if (marked != FEED_READER_ARTICLE_STATUS_MARKED) {
				_tmp44_ = marked != FEED_READER_ARTICLE_STATUS_UNMARKED;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				FeedReaderArticle* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp45_ = feed_reader_article_status_to_string (marked);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strconcat ("DataBase.update_articles: writing invalid marked status ", _tmp46_, " for article ", NULL);
				_tmp48_ = _tmp47_;
				_tmp49_ = a;
				_tmp50_ = feed_reader_article_getArticleID (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
				_tmp53_ = _tmp52_;
				feed_reader_logger_warning (_tmp53_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
			}
			_tmp54_ = stmt;
			sqlite3_bind_int (_tmp54_, unread_position, (gint) unread);
			_tmp55_ = stmt;
			sqlite3_bind_int (_tmp55_, marked_position, (gint) marked);
			_tmp56_ = stmt;
			_tmp57_ = a;
			sqlite3_bind_int (_tmp56_, modified_position, feed_reader_article_getLastModified (_tmp57_));
			_tmp58_ = stmt;
			_tmp59_ = a;
			_tmp60_ = feed_reader_article_getArticleID (_tmp59_);
			_tmp61_ = g_free;
			sqlite3_bind_text (_tmp58_, articleID_position, _tmp60_, -1, _tmp61_);
			while (TRUE) {
				sqlite3_stmt* _tmp62_;
				_tmp62_ = stmt;
				if (!(sqlite3_step (_tmp62_) != SQLITE_DONE)) {
					break;
				}
			}
			_tmp63_ = stmt;
			sqlite3_reset (_tmp63_);
			_tmp64_ = a;
			feed_reader_data_base_write_taggings (self, _tmp64_);
			_g_object_unref0 (a);
		}
	}
	_tmp65_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp65_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (update_query);
}

void
feed_reader_data_base_write_articles (FeedReaderDataBase* self,
                                      GeeList* articles)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	FeedReaderQueryBuilder* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	FeedReaderQueryBuilder* _tmp7_;
	FeedReaderQueryBuilder* _tmp8_;
	FeedReaderQueryBuilder* _tmp9_;
	FeedReaderQueryBuilder* _tmp10_;
	FeedReaderQueryBuilder* _tmp11_;
	FeedReaderQueryBuilder* _tmp12_;
	FeedReaderQueryBuilder* _tmp13_;
	FeedReaderQueryBuilder* _tmp14_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp15_;
	FeedReaderQueryBuilder* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	sqlite3_stmt* _tmp19_;
	sqlite3_stmt* _tmp20_;
	gint articleID_position = 0;
	sqlite3_stmt* _tmp21_;
	gint feedID_position = 0;
	sqlite3_stmt* _tmp22_;
	gint url_position = 0;
	sqlite3_stmt* _tmp23_;
	gint unread_position = 0;
	sqlite3_stmt* _tmp24_;
	gint marked_position = 0;
	sqlite3_stmt* _tmp25_;
	gint title_position = 0;
	sqlite3_stmt* _tmp26_;
	gint html_position = 0;
	sqlite3_stmt* _tmp27_;
	gint preview_position = 0;
	sqlite3_stmt* _tmp28_;
	gint author_position = 0;
	sqlite3_stmt* _tmp29_;
	gint date_position = 0;
	sqlite3_stmt* _tmp30_;
	gint guidHash_position = 0;
	sqlite3_stmt* _tmp31_;
	gint modified_position = 0;
	sqlite3_stmt* _tmp32_;
	GDateTime* drop_date = NULL;
	GSettings* _tmp33_;
	GSettings* _tmp34_;
	GDateTime* _tmp35_;
	GDateTime* _tmp36_;
	FeedReaderSQLite* _tmp113_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	feed_reader_utils_generatePreviews (articles);
	feed_reader_utils_checkHTML (articles);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_IGNORE, "main.articles");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "articleID", "$ARTICLEID");
	_tmp3_ = query;
	feed_reader_query_builder_insert_param (_tmp3_, "feedID", "$FEEDID");
	_tmp4_ = query;
	feed_reader_query_builder_insert_param (_tmp4_, "title", "$TITLE");
	_tmp5_ = query;
	feed_reader_query_builder_insert_param (_tmp5_, "author", "$AUTHOR");
	_tmp6_ = query;
	feed_reader_query_builder_insert_param (_tmp6_, "url", "$URL");
	_tmp7_ = query;
	feed_reader_query_builder_insert_param (_tmp7_, "html", "$HTML");
	_tmp8_ = query;
	feed_reader_query_builder_insert_param (_tmp8_, "preview", "$PREVIEW");
	_tmp9_ = query;
	feed_reader_query_builder_insert_param (_tmp9_, "unread", "$UNREAD");
	_tmp10_ = query;
	feed_reader_query_builder_insert_param (_tmp10_, "marked", "$MARKED");
	_tmp11_ = query;
	feed_reader_query_builder_insert_param (_tmp11_, "date", "$DATE");
	_tmp12_ = query;
	feed_reader_query_builder_insert_param (_tmp12_, "guidHash", "$GUIDHASH");
	_tmp13_ = query;
	feed_reader_query_builder_insert_param (_tmp13_, "lastModified", "$LASTMODIFIED");
	_tmp14_ = query;
	feed_reader_query_builder_insert_int (_tmp14_, "contentFetched", (gint64) 0);
	_tmp15_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp16_ = query;
	_tmp17_ = feed_reader_query_builder_to_string (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = feed_reader_sq_lite_prepare (_tmp15_, _tmp18_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	stmt = _tmp20_;
	_tmp21_ = stmt;
	articleID_position = sqlite3_bind_parameter_index (_tmp21_, "$ARTICLEID");
	_tmp22_ = stmt;
	feedID_position = sqlite3_bind_parameter_index (_tmp22_, "$FEEDID");
	_tmp23_ = stmt;
	url_position = sqlite3_bind_parameter_index (_tmp23_, "$URL");
	_tmp24_ = stmt;
	unread_position = sqlite3_bind_parameter_index (_tmp24_, "$UNREAD");
	_tmp25_ = stmt;
	marked_position = sqlite3_bind_parameter_index (_tmp25_, "$MARKED");
	_tmp26_ = stmt;
	title_position = sqlite3_bind_parameter_index (_tmp26_, "$TITLE");
	_tmp27_ = stmt;
	html_position = sqlite3_bind_parameter_index (_tmp27_, "$HTML");
	_tmp28_ = stmt;
	preview_position = sqlite3_bind_parameter_index (_tmp28_, "$PREVIEW");
	_tmp29_ = stmt;
	author_position = sqlite3_bind_parameter_index (_tmp29_, "$AUTHOR");
	_tmp30_ = stmt;
	date_position = sqlite3_bind_parameter_index (_tmp30_, "$DATE");
	_tmp31_ = stmt;
	guidHash_position = sqlite3_bind_parameter_index (_tmp31_, "$GUIDHASH");
	_tmp32_ = stmt;
	modified_position = sqlite3_bind_parameter_index (_tmp32_, "$LASTMODIFIED");
	_vala_assert (articleID_position > 0, "articleID_position > 0");
	_vala_assert (feedID_position > 0, "feedID_position > 0");
	_vala_assert (url_position > 0, "url_position > 0");
	_vala_assert (unread_position > 0, "unread_position > 0");
	_vala_assert (marked_position > 0, "marked_position > 0");
	_vala_assert (title_position > 0, "title_position > 0");
	_vala_assert (html_position > 0, "html_position > 0");
	_vala_assert (preview_position > 0, "preview_position > 0");
	_vala_assert (author_position > 0, "author_position > 0");
	_vala_assert (date_position > 0, "date_position > 0");
	_vala_assert (guidHash_position > 0, "guidHash_position > 0");
	_vala_assert (modified_position > 0, "modified_position > 0");
	_tmp33_ = feed_reader_settings_general ();
	_tmp34_ = _tmp33_;
	_tmp35_ = feed_reader_drop_articles_to_start_date ((FeedReaderDropArticles) g_settings_get_enum (_tmp34_, "drop-articles-after"));
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp34_);
	drop_date = _tmp36_;
	{
		GeeList* _article_list = NULL;
		gint _article_size = 0;
		GeeList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _article_index = 0;
		_article_list = articles;
		_tmp37_ = _article_list;
		_tmp38_ = gee_collection_get_size ((GeeCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_article_size = _tmp39_;
		_article_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			FeedReaderArticle* article = NULL;
			GeeList* _tmp42_;
			gpointer _tmp43_;
			GDateTime* now = NULL;
			GDateTime* _tmp44_;
			FeedReaderArticle* _tmp45_;
			GDateTime* _tmp46_;
			GDateTime* _tmp47_;
			GDateTime* _tmp48_;
			gboolean _tmp49_;
			gboolean _tmp52_ = FALSE;
			GDateTime* _tmp53_;
			sqlite3_stmt* _tmp63_;
			FeedReaderArticle* _tmp64_;
			gchar* _tmp65_;
			GDestroyNotify _tmp66_;
			sqlite3_stmt* _tmp67_;
			FeedReaderArticle* _tmp68_;
			gchar* _tmp69_;
			GDestroyNotify _tmp70_;
			sqlite3_stmt* _tmp71_;
			FeedReaderArticle* _tmp72_;
			gchar* _tmp73_;
			GDestroyNotify _tmp74_;
			sqlite3_stmt* _tmp75_;
			FeedReaderArticle* _tmp76_;
			sqlite3_stmt* _tmp77_;
			FeedReaderArticle* _tmp78_;
			sqlite3_stmt* _tmp79_;
			FeedReaderArticle* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			GDestroyNotify _tmp84_;
			sqlite3_stmt* _tmp85_;
			FeedReaderArticle* _tmp86_;
			gchar* _tmp87_;
			GDestroyNotify _tmp88_;
			sqlite3_stmt* _tmp89_;
			FeedReaderArticle* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			GDestroyNotify _tmp94_;
			sqlite3_stmt* _tmp95_;
			FeedReaderArticle* _tmp96_;
			gchar* _tmp97_;
			GDestroyNotify _tmp98_;
			sqlite3_stmt* _tmp99_;
			FeedReaderArticle* _tmp100_;
			GDateTime* _tmp101_;
			GDateTime* _tmp102_;
			sqlite3_stmt* _tmp103_;
			FeedReaderArticle* _tmp104_;
			gchar* _tmp105_;
			GDestroyNotify _tmp106_;
			sqlite3_stmt* _tmp107_;
			FeedReaderArticle* _tmp108_;
			sqlite3_stmt* _tmp110_;
			FeedReaderArticle* _tmp111_;
			FeedReaderArticle* _tmp112_;
			_article_index = _article_index + 1;
			_tmp40_ = _article_index;
			_tmp41_ = _article_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _article_list;
			_tmp43_ = gee_list_get (_tmp42_, _article_index);
			article = (FeedReaderArticle*) _tmp43_;
			_tmp44_ = g_date_time_new_now_local ();
			now = _tmp44_;
			_tmp45_ = article;
			_tmp46_ = feed_reader_article_getDate (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = now;
			_tmp49_ = g_date_time_compare (_tmp47_, _tmp48_) == 1;
			_g_date_time_unref0 (_tmp47_);
			if (_tmp49_) {
				FeedReaderArticle* _tmp50_;
				GDateTime* _tmp51_;
				_tmp50_ = article;
				_tmp51_ = now;
				feed_reader_article_SetDate (_tmp50_, _tmp51_);
			}
			_tmp53_ = drop_date;
			if (_tmp53_ != NULL) {
				FeedReaderArticle* _tmp54_;
				GDateTime* _tmp55_;
				GDateTime* _tmp56_;
				GDateTime* _tmp57_;
				_tmp54_ = article;
				_tmp55_ = feed_reader_article_getDate (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = drop_date;
				_tmp52_ = g_date_time_compare (_tmp56_, _tmp57_) == -1;
				_g_date_time_unref0 (_tmp56_);
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				FeedReaderArticle* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				_tmp58_ = article;
				_tmp59_ = feed_reader_article_getTitle (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf ("Ignoring old article: %s", _tmp60_);
				_tmp62_ = _tmp61_;
				feed_reader_logger_info (_tmp62_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_date_time_unref0 (now);
				_g_object_unref0 (article);
				continue;
			}
			_tmp63_ = stmt;
			_tmp64_ = article;
			_tmp65_ = feed_reader_article_getArticleID (_tmp64_);
			_tmp66_ = g_free;
			sqlite3_bind_text (_tmp63_, articleID_position, _tmp65_, -1, _tmp66_);
			_tmp67_ = stmt;
			_tmp68_ = article;
			_tmp69_ = feed_reader_article_getFeedID (_tmp68_);
			_tmp70_ = g_free;
			sqlite3_bind_text (_tmp67_, feedID_position, _tmp69_, -1, _tmp70_);
			_tmp71_ = stmt;
			_tmp72_ = article;
			_tmp73_ = feed_reader_article_getURL (_tmp72_);
			_tmp74_ = g_free;
			sqlite3_bind_text (_tmp71_, url_position, _tmp73_, -1, _tmp74_);
			_tmp75_ = stmt;
			_tmp76_ = article;
			sqlite3_bind_int (_tmp75_, unread_position, (gint) feed_reader_article_getUnread (_tmp76_));
			_tmp77_ = stmt;
			_tmp78_ = article;
			sqlite3_bind_int (_tmp77_, marked_position, (gint) feed_reader_article_getMarked (_tmp78_));
			_tmp79_ = stmt;
			_tmp80_ = article;
			_tmp81_ = feed_reader_article_getTitle (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = feed_reader_utils_UTF8fix (_tmp82_, FALSE);
			_tmp84_ = g_free;
			sqlite3_bind_text (_tmp79_, title_position, _tmp83_, -1, _tmp84_);
			_g_free0 (_tmp82_);
			_tmp85_ = stmt;
			_tmp86_ = article;
			_tmp87_ = feed_reader_article_getHTML (_tmp86_);
			_tmp88_ = g_free;
			sqlite3_bind_text (_tmp85_, html_position, _tmp87_, -1, _tmp88_);
			_tmp89_ = stmt;
			_tmp90_ = article;
			_tmp91_ = feed_reader_article_getPreview (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = feed_reader_utils_UTF8fix (_tmp92_, TRUE);
			_tmp94_ = g_free;
			sqlite3_bind_text (_tmp89_, preview_position, _tmp93_, -1, _tmp94_);
			_g_free0 (_tmp92_);
			_tmp95_ = stmt;
			_tmp96_ = article;
			_tmp97_ = feed_reader_article_getAuthor (_tmp96_);
			_tmp98_ = g_free;
			sqlite3_bind_text (_tmp95_, author_position, _tmp97_, -1, _tmp98_);
			_tmp99_ = stmt;
			_tmp100_ = article;
			_tmp101_ = feed_reader_article_getDate (_tmp100_);
			_tmp102_ = _tmp101_;
			sqlite3_bind_int64 (_tmp99_, date_position, g_date_time_to_unix (_tmp102_));
			_g_date_time_unref0 (_tmp102_);
			_tmp103_ = stmt;
			_tmp104_ = article;
			_tmp105_ = feed_reader_article_getHash (_tmp104_);
			_tmp106_ = g_free;
			sqlite3_bind_text (_tmp103_, guidHash_position, _tmp105_, -1, _tmp106_);
			_tmp107_ = stmt;
			_tmp108_ = article;
			sqlite3_bind_int (_tmp107_, modified_position, feed_reader_article_getLastModified (_tmp108_));
			while (TRUE) {
				sqlite3_stmt* _tmp109_;
				_tmp109_ = stmt;
				if (!(sqlite3_step (_tmp109_) != SQLITE_DONE)) {
					break;
				}
			}
			_tmp110_ = stmt;
			sqlite3_reset (_tmp110_);
			_tmp111_ = article;
			feed_reader_data_base_write_enclosures (self, _tmp111_);
			_tmp112_ = article;
			feed_reader_data_base_write_taggings (self, _tmp112_);
			_g_date_time_unref0 (now);
			_g_object_unref0 (article);
		}
	}
	_tmp113_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp113_, "COMMIT TRANSACTION");
	_g_date_time_unref0 (drop_date);
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

static void
feed_reader_data_base_write_taggings (FeedReaderDataBase* self,
                                      FeedReaderArticle* article)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint articleID_position = 0;
	sqlite3_stmt* _tmp9_;
	gint tagID_position = 0;
	sqlite3_stmt* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (article != NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_REPLACE, "main.taggings");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_insert_param (_tmp1_, "articleID", "$ARTICLEID");
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "tagID", "$TAGID");
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp4_ = query;
	_tmp5_ = feed_reader_query_builder_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_sq_lite_prepare (_tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	stmt = _tmp8_;
	_tmp9_ = stmt;
	articleID_position = sqlite3_bind_parameter_index (_tmp9_, "$ARTICLEID");
	_tmp10_ = stmt;
	tagID_position = sqlite3_bind_parameter_index (_tmp10_, "$TAGID");
	_vala_assert (articleID_position > 0, "articleID_position > 0");
	_vala_assert (tagID_position > 0, "tagID_position > 0");
	{
		GeeList* _tagID_list = NULL;
		GeeList* _tmp11_;
		gint _tagID_size = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tagID_index = 0;
		_tmp11_ = feed_reader_article_getTagIDs (article);
		_tagID_list = _tmp11_;
		_tmp12_ = _tagID_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tagID_size = _tmp14_;
		_tagID_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gchar* tagID = NULL;
			GeeList* _tmp17_;
			gpointer _tmp18_;
			sqlite3_stmt* _tmp19_;
			gchar* _tmp20_;
			GDestroyNotify _tmp21_;
			sqlite3_stmt* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			GDestroyNotify _tmp25_;
			sqlite3_stmt* _tmp27_;
			_tagID_index = _tagID_index + 1;
			_tmp15_ = _tagID_index;
			_tmp16_ = _tagID_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _tagID_list;
			_tmp18_ = gee_list_get (_tmp17_, _tagID_index);
			tagID = (gchar*) _tmp18_;
			_tmp19_ = stmt;
			_tmp20_ = feed_reader_article_getArticleID (article);
			_tmp21_ = g_free;
			sqlite3_bind_text (_tmp19_, articleID_position, _tmp20_, -1, _tmp21_);
			_tmp22_ = stmt;
			_tmp23_ = tagID;
			_tmp24_ = g_strdup (_tmp23_);
			_tmp25_ = g_free;
			sqlite3_bind_text (_tmp22_, tagID_position, _tmp24_, -1, _tmp25_);
			while (TRUE) {
				sqlite3_stmt* _tmp26_;
				_tmp26_ = stmt;
				if (!(sqlite3_step (_tmp26_) != SQLITE_DONE)) {
					break;
				}
			}
			_tmp27_ = stmt;
			sqlite3_reset (_tmp27_);
			_g_free0 (tagID);
		}
	}
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

static void
feed_reader_data_base_write_enclosures (FeedReaderDataBase* self,
                                        FeedReaderArticle* article)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp4_;
	FeedReaderQueryBuilder* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint articleID_position = 0;
	sqlite3_stmt* _tmp10_;
	gint url_position = 0;
	sqlite3_stmt* _tmp11_;
	gint type_position = 0;
	sqlite3_stmt* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (article != NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_REPLACE, "main.Enclosures");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_insert_param (_tmp1_, "articleID", "$ARTICLEID");
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "url", "$URL");
	_tmp3_ = query;
	feed_reader_query_builder_insert_param (_tmp3_, "type", "$TYPE");
	_tmp4_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp5_ = query;
	_tmp6_ = feed_reader_query_builder_to_string (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = feed_reader_sq_lite_prepare (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	stmt = _tmp9_;
	_tmp10_ = stmt;
	articleID_position = sqlite3_bind_parameter_index (_tmp10_, "$ARTICLEID");
	_tmp11_ = stmt;
	url_position = sqlite3_bind_parameter_index (_tmp11_, "$URL");
	_tmp12_ = stmt;
	type_position = sqlite3_bind_parameter_index (_tmp12_, "$TYPE");
	_vala_assert (articleID_position > 0, "articleID_position > 0");
	_vala_assert (url_position > 0, "url_position > 0");
	_vala_assert (type_position > 0, "type_position > 0");
	{
		GeeList* _enc_list = NULL;
		GeeList* _tmp13_;
		gint _enc_size = 0;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _enc_index = 0;
		_tmp13_ = feed_reader_article_getEnclosures (article);
		_enc_list = _tmp13_;
		_tmp14_ = _enc_list;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_enc_size = _tmp16_;
		_enc_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			FeedReaderEnclosure* enc = NULL;
			GeeList* _tmp19_;
			gpointer _tmp20_;
			sqlite3_stmt* _tmp21_;
			gchar* _tmp22_;
			GDestroyNotify _tmp23_;
			sqlite3_stmt* _tmp24_;
			FeedReaderEnclosure* _tmp25_;
			gchar* _tmp26_;
			GDestroyNotify _tmp27_;
			sqlite3_stmt* _tmp28_;
			FeedReaderEnclosure* _tmp29_;
			sqlite3_stmt* _tmp31_;
			_enc_index = _enc_index + 1;
			_tmp17_ = _enc_index;
			_tmp18_ = _enc_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _enc_list;
			_tmp20_ = gee_list_get (_tmp19_, _enc_index);
			enc = (FeedReaderEnclosure*) _tmp20_;
			_tmp21_ = stmt;
			_tmp22_ = feed_reader_article_getArticleID (article);
			_tmp23_ = g_free;
			sqlite3_bind_text (_tmp21_, articleID_position, _tmp22_, -1, _tmp23_);
			_tmp24_ = stmt;
			_tmp25_ = enc;
			_tmp26_ = feed_reader_enclosure_get_url (_tmp25_);
			_tmp27_ = g_free;
			sqlite3_bind_text (_tmp24_, url_position, _tmp26_, -1, _tmp27_);
			_tmp28_ = stmt;
			_tmp29_ = enc;
			sqlite3_bind_int (_tmp28_, type_position, (gint) feed_reader_enclosure_get_enclosure_type (_tmp29_));
			while (TRUE) {
				sqlite3_stmt* _tmp30_;
				_tmp30_ = stmt;
				if (!(sqlite3_step (_tmp30_) != SQLITE_DONE)) {
					break;
				}
			}
			_tmp31_ = stmt;
			sqlite3_reset (_tmp31_);
			_g_object_unref0 (enc);
		}
	}
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

void
feed_reader_data_base_markCategorieRead (FeedReaderDataBase* self,
                                         const gchar* catID)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	FeedReaderSQLite* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_UPDATE, "main.articles");
	query = _tmp0_;
	feed_reader_query_builder_update_int (query, "unread", (gint64) feed_reader_article_status_to_int (FEED_READER_ARTICLE_STATUS_READ));
	_tmp1_ = feed_reader_data_base_read_only_getFeedIDofCategorie ((FeedReaderDataBaseReadOnly*) self, catID);
	_tmp2_ = _tmp1_;
	feed_reader_query_builder_where_in_strings (query, "feedID", _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp4_ = feed_reader_query_builder_to_string (query);
	_tmp5_ = _tmp4_;
	feed_reader_sq_lite_simple_query (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (query);
}

void
feed_reader_data_base_markFeedRead (FeedReaderDataBase* self,
                                    const gchar* feedID)
{
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue* _tmp2_ = NULL;
	GValue** _tmp3_;
	GValue** _tmp4_;
	gint _tmp4__length1;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, FEED_READER_TYPE_ARTICLE_STATUS);
	g_value_set_enum (_tmp1_, FEED_READER_ARTICLE_STATUS_READ);
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_STRING);
	g_value_set_string (_tmp2_, feedID);
	_tmp3_ = g_new0 (GValue*, 2);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = feed_reader_sq_lite_execute (_tmp0_, "UPDATE main.articles SET unread = ? WHERE feedID = ?", _tmp4_, (gint) 2);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) _vala_GValue_free), NULL);
}

void
feed_reader_data_base_markAllRead (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, FEED_READER_TYPE_ARTICLE_STATUS);
	g_value_set_enum (_tmp1_, FEED_READER_ARTICLE_STATUS_READ);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "UPDATE main.articles SET unread = ?", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
}

void
feed_reader_data_base_reset_subscribed_flag (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "UPDATE main.feeds SET \"subscribed\" = 0");
}

void
feed_reader_data_base_reset_exists_tag (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "UPDATE main.tags SET \"exists\" = 0");
}

void
feed_reader_data_base_reset_exists_flag (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "UPDATE main.categories SET \"exists\" = 0");
}

void
feed_reader_data_base_delete_unsubscribed_feeds (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_warning ("DataBase: Deleting unsubscribed feeds");
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "DELETE FROM main.feeds WHERE \"subscribed\" = 0");
}

void
feed_reader_data_base_delete_nonexisting_categories (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_warning ("DataBase: Deleting nonexisting categories");
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "DELETE FROM main.categories WHERE \"exists\" = 0");
}

void
feed_reader_data_base_delete_nonexisting_tags (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_warning ("DataBase: Deleting nonexisting tags");
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "DELETE FROM main.tags WHERE \"exists\" = 0");
}

void
feed_reader_data_base_delete_articles_without_feed (FeedReaderDataBase* self)
{
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp0_;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_warning ("DataBase: Deleting articles without feed");
	_tmp0_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_SELECT, "main.feeds");
	query = _tmp0_;
	_tmp1_ = query;
	feed_reader_query_builder_select_field (_tmp1_, "feed_id");
	_tmp2_ = query;
	feed_reader_query_builder_where_equal_int (_tmp2_, "subscribed", (gint64) 0);
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp4_ = query;
	_tmp5_ = feed_reader_query_builder_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_sq_lite_prepare (_tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	stmt = _tmp8_;
	while (TRUE) {
		sqlite3_stmt* _tmp9_;
		sqlite3_stmt* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = stmt;
		if (!(sqlite3_step (_tmp9_) == SQLITE_ROW)) {
			break;
		}
		_tmp10_ = stmt;
		_tmp11_ = sqlite3_column_text (_tmp10_, 0);
		feed_reader_data_base_delete_articles (self, _tmp11_);
	}
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

void
feed_reader_data_base_delete_articles (FeedReaderDataBase* self,
                                       const gchar* feedID)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FeedReaderSQLite* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue** _tmp5_;
	GValue** _tmp6_;
	gint _tmp6__length1;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	FeedReaderSQLite* _tmp9_;
	GValue* _tmp10_ = NULL;
	GValue** _tmp11_;
	GValue** _tmp12_;
	gint _tmp12__length1;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	gchar* folder_path = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = string_to_string (feedID);
	_tmp1_ = g_strconcat ("DataBase: Deleting all articles of feed \"", _tmp0_, "\"", NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_warning (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, feedID);
	_tmp5_ = g_new0 (GValue*, 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = feed_reader_sq_lite_execute (_tmp3_, "DELETE FROM main.articles WHERE feedID = ?", _tmp6_, (gint) 1);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_tmp9_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp10_ = g_new0 (GValue, 1);
	g_value_init (_tmp10_, G_TYPE_STRING);
	g_value_set_string (_tmp10_, feedID);
	_tmp11_ = g_new0 (GValue*, 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	_tmp13_ = feed_reader_sq_lite_execute (_tmp9_, "DELETE FROM main.Enclosures WHERE articleID IN(SELECT articleID FROM m" \
"ain.articles WHERE feedID = ?)", _tmp12_, (gint) 1);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_tmp15_ = g_get_user_data_dir ();
	_tmp16_ = string_to_string (feedID);
	_tmp17_ = g_strconcat ("/feedreader/data/images/", _tmp16_, "/", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	folder_path = _tmp20_;
	feed_reader_utils_remove_directory (folder_path, (guint) 0);
	_g_free0 (folder_path);
}

void
feed_reader_data_base_delete_category (FeedReaderDataBase* self,
                                       const gchar* catID)
{
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_STRING);
	g_value_set_string (_tmp1_, catID);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "DELETE FROM main.categories WHERE categorieID = ?", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
}

void
feed_reader_data_base_rename_category (FeedReaderDataBase* self,
                                       const gchar* catID,
                                       const gchar* newName)
{
	FeedReaderFeedServer* _tmp0_;
	FeedReaderFeedServer* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newName != NULL);
	_tmp0_ = feed_reader_feed_server_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_feed_server_tagIDaffectedByNameChange (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		FeedReaderCategory* cat = NULL;
		FeedReaderCategory* _tmp3_;
		gchar* newID = NULL;
		FeedReaderCategory* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* query = NULL;
		gchar* _tmp9_;
		FeedReaderSQLite* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GValue* _tmp13_ = NULL;
		GValue* _tmp14_ = NULL;
		GValue* _tmp15_ = NULL;
		GValue** _tmp16_;
		GValue** _tmp17_;
		gint _tmp17__length1;
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		gchar* _tmp20_;
		FeedReaderSQLite* _tmp21_;
		const gchar* _tmp22_;
		GValue* _tmp23_ = NULL;
		const gchar* _tmp24_;
		GValue* _tmp25_ = NULL;
		GValue* _tmp26_ = NULL;
		GValue** _tmp27_;
		GValue** _tmp28_;
		gint _tmp28__length1;
		GeeList* _tmp29_;
		GeeList* _tmp30_;
		_tmp3_ = feed_reader_data_base_read_only_read_category ((FeedReaderDataBaseReadOnly*) self, catID);
		cat = _tmp3_;
		_tmp4_ = cat;
		_tmp5_ = feed_reader_category_getTitle (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_replace (catID, _tmp6_, newName);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		newID = _tmp8_;
		_tmp9_ = g_strdup ("UPDATE categories SET categorieID = ?, title = ? WHERE categorieID = ?");
		query = _tmp9_;
		_tmp10_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
		_tmp11_ = query;
		_tmp12_ = newID;
		_tmp13_ = g_new0 (GValue, 1);
		g_value_init (_tmp13_, G_TYPE_STRING);
		g_value_set_string (_tmp13_, _tmp12_);
		_tmp14_ = g_new0 (GValue, 1);
		g_value_init (_tmp14_, G_TYPE_STRING);
		g_value_set_string (_tmp14_, newName);
		_tmp15_ = g_new0 (GValue, 1);
		g_value_init (_tmp15_, G_TYPE_STRING);
		g_value_set_string (_tmp15_, catID);
		_tmp16_ = g_new0 (GValue*, 3);
		_tmp16_[0] = _tmp13_;
		_tmp16_[1] = _tmp14_;
		_tmp16_[2] = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 3;
		_tmp18_ = feed_reader_sq_lite_execute (_tmp10_, _tmp11_, _tmp17_, (gint) 3);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) _vala_GValue_free), NULL);
		_tmp20_ = g_strdup ("UPDATE feeds SET category_id = replace(category_id, ?,  ?) WHERE instr" \
"(category_id, ?)");
		_g_free0 (query);
		query = _tmp20_;
		_tmp21_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
		_tmp22_ = query;
		_tmp23_ = g_new0 (GValue, 1);
		g_value_init (_tmp23_, G_TYPE_STRING);
		g_value_set_string (_tmp23_, catID);
		_tmp24_ = newID;
		_tmp25_ = g_new0 (GValue, 1);
		g_value_init (_tmp25_, G_TYPE_STRING);
		g_value_set_string (_tmp25_, _tmp24_);
		_tmp26_ = g_new0 (GValue, 1);
		g_value_init (_tmp26_, G_TYPE_STRING);
		g_value_set_string (_tmp26_, catID);
		_tmp27_ = g_new0 (GValue*, 3);
		_tmp27_[0] = _tmp23_;
		_tmp27_[1] = _tmp25_;
		_tmp27_[2] = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp28__length1 = 3;
		_tmp29_ = feed_reader_sq_lite_execute (_tmp21_, _tmp22_, _tmp28_, (gint) 3);
		_tmp30_ = _tmp29_;
		_g_object_unref0 (_tmp30_);
		_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) _vala_GValue_free), NULL);
		_g_free0 (query);
		_g_free0 (newID);
		_g_object_unref0 (cat);
	} else {
		gchar* query = NULL;
		gchar* _tmp31_;
		FeedReaderSQLite* _tmp32_;
		const gchar* _tmp33_;
		GValue* _tmp34_ = NULL;
		GValue* _tmp35_ = NULL;
		GValue** _tmp36_;
		GValue** _tmp37_;
		gint _tmp37__length1;
		GeeList* _tmp38_;
		GeeList* _tmp39_;
		_tmp31_ = g_strdup ("UPDATE categories SET title = ? WHERE categorieID = ?");
		query = _tmp31_;
		_tmp32_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
		_tmp33_ = query;
		_tmp34_ = g_new0 (GValue, 1);
		g_value_init (_tmp34_, G_TYPE_STRING);
		g_value_set_string (_tmp34_, newName);
		_tmp35_ = g_new0 (GValue, 1);
		g_value_init (_tmp35_, G_TYPE_STRING);
		g_value_set_string (_tmp35_, catID);
		_tmp36_ = g_new0 (GValue*, 2);
		_tmp36_[0] = _tmp34_;
		_tmp36_[1] = _tmp35_;
		_tmp37_ = _tmp36_;
		_tmp37__length1 = 2;
		_tmp38_ = feed_reader_sq_lite_execute (_tmp32_, _tmp33_, _tmp37_, (gint) 2);
		_tmp39_ = _tmp38_;
		_g_object_unref0 (_tmp39_);
		_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) _vala_GValue_free), NULL);
		_g_free0 (query);
	}
}

void
feed_reader_data_base_move_category (FeedReaderDataBase* self,
                                     const gchar* catID,
                                     const gchar* newParentID)
{
	FeedReaderCategory* parent = NULL;
	FeedReaderCategory* _tmp0_;
	gchar* query = NULL;
	gchar* _tmp1_;
	FeedReaderSQLite* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	GValue** _tmp6_;
	GValue** _tmp7_;
	gint _tmp7__length1;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	_tmp0_ = feed_reader_data_base_read_only_read_category ((FeedReaderDataBaseReadOnly*) self, newParentID);
	parent = _tmp0_;
	_tmp1_ = g_strdup ("UPDATE categories SET Parent = ?,  Level = ? WHERE categorieID = ?");
	query = _tmp1_;
	_tmp2_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, newParentID);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT);
	g_value_set_int (_tmp4_, feed_reader_category_getLevel (parent) + 1);
	_tmp5_ = g_new0 (GValue, 1);
	g_value_init (_tmp5_, G_TYPE_STRING);
	g_value_set_string (_tmp5_, catID);
	_tmp6_ = g_new0 (GValue*, 3);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 3;
	_tmp8_ = feed_reader_sq_lite_execute (_tmp2_, query, _tmp7_, (gint) 3);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_g_free0 (query);
	_g_object_unref0 (parent);
}

void
feed_reader_data_base_rename_feed (FeedReaderDataBase* self,
                                   const gchar* feedID,
                                   const gchar* newName)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	FeedReaderSQLite* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	GValue** _tmp4_;
	GValue** _tmp5_;
	gint _tmp5__length1;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newName != NULL);
	_tmp0_ = g_strdup ("UPDATE feeds SET name = ? WHERE feed_id = ?");
	query = _tmp0_;
	_tmp1_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_STRING);
	g_value_set_string (_tmp2_, newName);
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, feedID);
	_tmp4_ = g_new0 (GValue*, 2);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = feed_reader_sq_lite_execute (_tmp1_, query, _tmp5_, (gint) 2);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_g_free0 (query);
}

void
feed_reader_data_base_move_feed (FeedReaderDataBase* self,
                                 const gchar* feedID,
                                 const gchar* currentCatID,
                                 const gchar* newCatID)
{
	FeedReaderFeed* Feed = NULL;
	FeedReaderFeed* _tmp0_;
	GeeList* categories = NULL;
	FeedReaderFeed* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gchar* catString = NULL;
	GeeList* _tmp5_;
	gchar* _tmp6_;
	gchar* query = NULL;
	gchar* _tmp7_;
	FeedReaderSQLite* _tmp8_;
	GValue* _tmp9_ = NULL;
	GValue* _tmp10_ = NULL;
	GValue** _tmp11_;
	GValue** _tmp12_;
	gint _tmp12__length1;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (currentCatID != NULL);
	_tmp0_ = feed_reader_data_base_read_only_read_feed ((FeedReaderDataBaseReadOnly*) self, feedID);
	Feed = _tmp0_;
	_tmp1_ = Feed;
	_tmp2_ = feed_reader_feed_getCatIDs (_tmp1_);
	categories = _tmp2_;
	_tmp3_ = categories;
	gee_collection_remove ((GeeCollection*) _tmp3_, currentCatID);
	if (newCatID != NULL) {
		GeeList* _tmp4_;
		_tmp4_ = categories;
		gee_collection_add ((GeeCollection*) _tmp4_, newCatID);
	}
	_tmp5_ = categories;
	_tmp6_ = feed_reader_string_utils_join ((GeeCollection*) _tmp5_, ",");
	catString = _tmp6_;
	_tmp7_ = g_strdup ("UPDATE feeds SET category_id = ? WHERE feed_id = ?");
	query = _tmp7_;
	_tmp8_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp9_ = g_new0 (GValue, 1);
	g_value_init (_tmp9_, G_TYPE_STRING);
	g_value_set_string (_tmp9_, catString);
	_tmp10_ = g_new0 (GValue, 1);
	g_value_init (_tmp10_, G_TYPE_STRING);
	g_value_set_string (_tmp10_, feedID);
	_tmp11_ = g_new0 (GValue*, 2);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	_tmp13_ = feed_reader_sq_lite_execute (_tmp8_, query, _tmp12_, (gint) 2);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_g_free0 (query);
	_g_free0 (catString);
	_g_object_unref0 (categories);
	_g_object_unref0 (Feed);
}

void
feed_reader_data_base_removeCatFromFeed (FeedReaderDataBase* self,
                                         const gchar* feedID,
                                         const gchar* catID)
{
	FeedReaderFeed* feed = NULL;
	FeedReaderFeed* _tmp0_;
	FeedReaderSQLite* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GValue* _tmp7_ = NULL;
	GValue* _tmp8_ = NULL;
	GValue** _tmp9_;
	GValue** _tmp10_;
	gint _tmp10__length1;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = feed_reader_data_base_read_only_read_feed ((FeedReaderDataBaseReadOnly*) self, feedID);
	feed = _tmp0_;
	_tmp1_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp2_ = feed_reader_feed_getCatString (feed);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (catID, ",", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_replace (_tmp3_, _tmp5_, "");
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_STRING);
	g_value_take_string (_tmp7_, _tmp6_);
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_STRING);
	g_value_set_string (_tmp8_, feedID);
	_tmp9_ = g_new0 (GValue*, 2);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = feed_reader_sq_lite_execute (_tmp1_, "UPDATE feeds SET category_id = ? WHERE feed_id = ?", _tmp10_, (gint) 2);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (feed);
}

void
feed_reader_data_base_delete_feed (FeedReaderDataBase* self,
                                   const gchar* feedID)
{
	FeedReaderSQLite* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue** _tmp2_;
	GValue** _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp1_ = g_new0 (GValue, 1);
	g_value_init (_tmp1_, G_TYPE_STRING);
	g_value_set_string (_tmp1_, feedID);
	_tmp2_ = g_new0 (GValue*, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = feed_reader_sq_lite_execute (_tmp0_, "DELETE FROM feeds WHERE feed_id = ?", _tmp3_, (gint) 1);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	feed_reader_data_base_delete_articles (self, feedID);
}

void
feed_reader_data_base_addCachedAction (FeedReaderDataBase* self,
                                       FeedReaderCachedActions action,
                                       const gchar* id,
                                       const gchar* argument)
{
	FeedReaderSQLite* _tmp0_;
	FeedReaderQueryBuilder* query = NULL;
	FeedReaderQueryBuilder* _tmp1_;
	FeedReaderQueryBuilder* _tmp2_;
	FeedReaderQueryBuilder* _tmp3_;
	FeedReaderQueryBuilder* _tmp4_;
	sqlite3_stmt* stmt = NULL;
	FeedReaderSQLite* _tmp5_;
	FeedReaderQueryBuilder* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	gint action_position = 0;
	sqlite3_stmt* _tmp11_;
	gint id_position = 0;
	sqlite3_stmt* _tmp12_;
	gint argument_position = 0;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	gchar* _tmp16_;
	GDestroyNotify _tmp17_;
	sqlite3_stmt* _tmp18_;
	gchar* _tmp19_;
	GDestroyNotify _tmp20_;
	sqlite3_stmt* _tmp22_;
	FeedReaderSQLite* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "BEGIN TRANSACTION");
	_tmp1_ = feed_reader_query_builder_new (FEED_READER_QUERY_TYPE_INSERT_OR_IGNORE, "main.CachedActions");
	query = _tmp1_;
	_tmp2_ = query;
	feed_reader_query_builder_insert_param (_tmp2_, "action", "$ACTION");
	_tmp3_ = query;
	feed_reader_query_builder_insert_param (_tmp3_, "id", "$ID");
	_tmp4_ = query;
	feed_reader_query_builder_insert_param (_tmp4_, "argument", "$ARGUMENT");
	_tmp5_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp6_ = query;
	_tmp7_ = feed_reader_query_builder_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = feed_reader_sq_lite_prepare (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	stmt = _tmp10_;
	_tmp11_ = stmt;
	action_position = sqlite3_bind_parameter_index (_tmp11_, "$ACTION");
	_tmp12_ = stmt;
	id_position = sqlite3_bind_parameter_index (_tmp12_, "$ID");
	_tmp13_ = stmt;
	argument_position = sqlite3_bind_parameter_index (_tmp13_, "$ARGUMENT");
	_vala_assert (action_position > 0, "action_position > 0");
	_vala_assert (id_position > 0, "id_position > 0");
	_vala_assert (argument_position > 0, "argument_position > 0");
	_tmp14_ = stmt;
	sqlite3_bind_int (_tmp14_, action_position, (gint) action);
	_tmp15_ = stmt;
	_tmp16_ = g_strdup (id);
	_tmp17_ = g_free;
	sqlite3_bind_text (_tmp15_, id_position, _tmp16_, -1, _tmp17_);
	_tmp18_ = stmt;
	_tmp19_ = g_strdup (argument);
	_tmp20_ = g_free;
	sqlite3_bind_text (_tmp18_, argument_position, _tmp19_, -1, _tmp20_);
	while (TRUE) {
		sqlite3_stmt* _tmp21_;
		_tmp21_ = stmt;
		if (!(sqlite3_step (_tmp21_) == SQLITE_ROW)) {
			break;
		}
	}
	_tmp22_ = stmt;
	sqlite3_reset (_tmp22_);
	_tmp23_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp23_, "COMMIT TRANSACTION");
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (query);
}

GeeList*
feed_reader_data_base_readCachedActions (FeedReaderDataBase* self)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	GeeList* _tmp3_;
	GeeArrayList* actions = NULL;
	GeeArrayList* _tmp4_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT * FROM CachedActions");
	query = _tmp0_;
	_tmp1_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp2_ = query;
	_tmp3_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, NULL, (gint) 0);
	rows = _tmp3_;
	_tmp4_ = gee_array_list_new (FEED_READER_TYPE_CACHED_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	actions = _tmp4_;
	{
		GeeList* _row_list = NULL;
		GeeList* _tmp5_;
		gint _row_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _row_index = 0;
		_tmp5_ = rows;
		_row_list = _tmp5_;
		_tmp6_ = _row_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_row_size = _tmp8_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			GeeList* row = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			FeedReaderCachedAction* action = NULL;
			GeeList* _tmp13_;
			gpointer _tmp14_;
			sqlite3_value* _tmp15_;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			sqlite3_value* _tmp18_;
			const gchar* _tmp19_;
			GeeList* _tmp20_;
			gpointer _tmp21_;
			sqlite3_value* _tmp22_;
			const gchar* _tmp23_;
			FeedReaderCachedAction* _tmp24_;
			FeedReaderCachedAction* _tmp25_;
			FeedReaderCachedAction* _tmp26_;
			GeeArrayList* _tmp27_;
			FeedReaderCachedAction* _tmp28_;
			_row_index = _row_index + 1;
			_tmp9_ = _row_index;
			_tmp10_ = _row_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _row_list;
			_tmp12_ = gee_list_get (_tmp11_, _row_index);
			row = (GeeList*) _tmp12_;
			_tmp13_ = row;
			_tmp14_ = gee_list_get (_tmp13_, 0);
			_tmp15_ = (sqlite3_value*) _tmp14_;
			_tmp16_ = row;
			_tmp17_ = gee_list_get (_tmp16_, 1);
			_tmp18_ = (sqlite3_value*) _tmp17_;
			_tmp19_ = sqlite3_value_text (_tmp18_);
			_tmp20_ = row;
			_tmp21_ = gee_list_get (_tmp20_, 2);
			_tmp22_ = (sqlite3_value*) _tmp21_;
			_tmp23_ = sqlite3_value_text (_tmp22_);
			_tmp24_ = feed_reader_cached_action_new ((FeedReaderCachedActions) sqlite3_value_int (_tmp15_), _tmp19_, _tmp23_);
			_tmp25_ = _tmp24_;
			_sqlite3_value_free0 (_tmp22_);
			_sqlite3_value_free0 (_tmp18_);
			_sqlite3_value_free0 (_tmp15_);
			action = _tmp25_;
			_tmp26_ = action;
			feed_reader_cached_action_print (_tmp26_);
			_tmp27_ = actions;
			_tmp28_ = action;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
			_g_object_unref0 (action);
			_g_object_unref0 (row);
		}
	}
	result = (GeeList*) actions;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

void
feed_reader_data_base_resetCachedActions (FeedReaderDataBase* self)
{
	FeedReaderSQLite* _tmp0_;
	g_return_if_fail (self != NULL);
	feed_reader_logger_warning ("resetCachedActions");
	_tmp0_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	feed_reader_sq_lite_simple_query (_tmp0_, "DELETE FROM CachedActions");
}

gboolean
feed_reader_data_base_cachedActionNecessary (FeedReaderDataBase* self,
                                             FeedReaderCachedAction* action)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	GeeList* rows = NULL;
	FeedReaderSQLite* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GValue* _tmp4_ = NULL;
	gchar* _tmp5_;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	GValue** _tmp8_;
	GValue** _tmp9_;
	gint _tmp9__length1;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeList* _tmp21_;
	gpointer _tmp22_;
	GeeList* _tmp23_;
	gpointer _tmp24_;
	sqlite3_value* _tmp25_;
	gboolean _tmp26_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	_tmp0_ = g_strdup ("SELECT COUNT(*) FROM CachedActions WHERE argument = ? AND id = ? AND a" \
"ction = ?");
	query = _tmp0_;
	_tmp1_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp2_ = query;
	_tmp3_ = feed_reader_cached_action_getArgument (action);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_take_string (_tmp4_, _tmp3_);
	_tmp5_ = feed_reader_cached_action_getID (action);
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_take_string (_tmp6_, _tmp5_);
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, FEED_READER_TYPE_CACHED_ACTIONS);
	g_value_set_enum (_tmp7_, feed_reader_cached_action_opposite (action));
	_tmp8_ = g_new0 (GValue*, 3);
	_tmp8_[0] = _tmp4_;
	_tmp8_[1] = _tmp6_;
	_tmp8_[2] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = feed_reader_sq_lite_execute (_tmp1_, _tmp2_, _tmp9_, (gint) 3);
	_tmp11_ = _tmp10_;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	rows = _tmp11_;
	_tmp13_ = rows;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == 1) {
		GeeList* _tmp16_;
		gpointer _tmp17_;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp16_ = rows;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		_tmp18_ = (GeeList*) _tmp17_;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp12_ = _tmp20_ == 1;
		_g_object_unref0 (_tmp18_);
	} else {
		_tmp12_ = FALSE;
	}
	_vala_assert (_tmp12_, "rows.size == 1 && rows[0].size == 1");
	_tmp21_ = rows;
	_tmp22_ = gee_list_get (_tmp21_, 0);
	_tmp23_ = (GeeList*) _tmp22_;
	_tmp24_ = gee_list_get (_tmp23_, 0);
	_tmp25_ = (sqlite3_value*) _tmp24_;
	_tmp26_ = sqlite3_value_int (_tmp25_) == 0;
	_sqlite3_value_free0 (_tmp25_);
	_g_object_unref0 (_tmp23_);
	result = _tmp26_;
	_g_object_unref0 (rows);
	_g_free0 (query);
	return result;
}

void
feed_reader_data_base_deleteOppositeCachedAction (FeedReaderDataBase* self,
                                                  FeedReaderCachedAction* action)
{
	gchar* query = NULL;
	gchar* _tmp0_;
	FeedReaderSQLite* _tmp1_;
	gchar* _tmp2_;
	GValue* _tmp3_ = NULL;
	gchar* _tmp4_;
	GValue* _tmp5_ = NULL;
	GValue* _tmp6_ = NULL;
	GValue** _tmp7_;
	GValue** _tmp8_;
	gint _tmp8__length1;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strdup ("DELETE FROM CachedActions WHERE argument = ? AND id = ? AND action = ?");
	query = _tmp0_;
	_tmp1_ = ((FeedReaderDataBaseReadOnly*) self)->m_db;
	_tmp2_ = feed_reader_cached_action_getArgument (action);
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_take_string (_tmp3_, _tmp2_);
	_tmp4_ = feed_reader_cached_action_getID (action);
	_tmp5_ = g_new0 (GValue, 1);
	g_value_init (_tmp5_, G_TYPE_STRING);
	g_value_take_string (_tmp5_, _tmp4_);
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, FEED_READER_TYPE_CACHED_ACTIONS);
	g_value_set_enum (_tmp6_, feed_reader_cached_action_opposite (action));
	_tmp7_ = g_new0 (GValue*, 3);
	_tmp7_[0] = _tmp3_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	_tmp9_ = feed_reader_sq_lite_execute (_tmp1_, query, _tmp8_, (gint) 3);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp10_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) _vala_GValue_free), NULL);
	_g_free0 (query);
}

static void
feed_reader_data_base_class_init (FeedReaderDataBaseClass * klass,
                                  gpointer klass_data)
{
	feed_reader_data_base_parent_class = g_type_class_peek_parent (klass);
}

static void
feed_reader_data_base_instance_init (FeedReaderDataBase * self,
                                     gpointer klass)
{
}

static GType
feed_reader_data_base_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderDataBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_data_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderDataBase), 0, (GInstanceInitFunc) feed_reader_data_base_instance_init, NULL };
	GType feed_reader_data_base_type_id;
	feed_reader_data_base_type_id = g_type_register_static (FEED_READER_TYPE_DATA_BASE_READ_ONLY, "FeedReaderDataBase", &g_define_type_info, 0);
	return feed_reader_data_base_type_id;
}

GType
feed_reader_data_base_get_type (void)
{
	static volatile gsize feed_reader_data_base_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_data_base_type_id__once)) {
		GType feed_reader_data_base_type_id;
		feed_reader_data_base_type_id = feed_reader_data_base_get_type_once ();
		g_once_init_leave (&feed_reader_data_base_type_id__once, feed_reader_data_base_type_id);
	}
	return feed_reader_data_base_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

