/* Article.c generated by valac 0.56.3, the Vala compiler
 * generated from Article.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

enum  {
	FEED_READER_ARTICLE_0_PROPERTY,
	FEED_READER_ARTICLE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_article_properties[FEED_READER_ARTICLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

struct _FeedReaderArticlePrivate {
	gchar* m_articleID;
	gchar* m_title;
	gchar* m_url;
	gchar* m_html;
	gchar* m_preview;
	gchar* m_feedID;
	GeeList* m_tags;
	GeeList* m_enclosures;
	gchar* m_author;
	FeedReaderArticleStatus m_unread;
	FeedReaderArticleStatus m_marked;
	gint m_sortID;
	GDateTime* m_date;
	gchar* m_guidHash;
	gint m_lastModified;
	gint m_pos;
};

static gint FeedReaderArticle_private_offset;
static gpointer feed_reader_article_parent_class = NULL;
static GSettings* feed_reader_article_m_gnome_settings;
static GSettings* feed_reader_article_m_gnome_settings = NULL;
static gboolean feed_reader_article_m_clock_12_hour;
static gboolean feed_reader_article_m_clock_12_hour = FALSE;

static void _feed_reader_article____lambda4_ (void);
static void __feed_reader_article____lambda4__g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
static void feed_reader_article_finalize (GObject * obj);
static GType feed_reader_article_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_article_get_instance_private (FeedReaderArticle* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderArticle_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderArticle*
feed_reader_article_construct (GType object_type,
                               const gchar* articleID,
                               const gchar* title,
                               const gchar* url,
                               const gchar* feedID,
                               FeedReaderArticleStatus unread,
                               FeedReaderArticleStatus marked,
                               const gchar* html,
                               const gchar* preview,
                               const gchar* author,
                               GDateTime* date,
                               gint sortID,
                               GeeList* tags,
                               GeeList* enclosures,
                               const gchar* guidHash,
                               gint lastModified)
{
	FeedReaderArticle * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	GDateTime* _tmp19_ = NULL;
	GDateTime* _tmp22_;
	gchar* _tmp23_;
	GeeList* _tmp24_ = NULL;
	GeeList* _tmp27_;
	GeeList* _tmp28_ = NULL;
	GeeList* _tmp31_;
	g_return_val_if_fail (articleID != NULL, NULL);
	g_return_val_if_fail (guidHash != NULL, NULL);
	self = (FeedReaderArticle*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (articleID);
	_g_free0 (self->priv->m_articleID);
	self->priv->m_articleID = _tmp0_;
	if (title != NULL) {
		gchar* _tmp2_;
		_tmp2_ = feed_reader_utils_UTF8fix (title, TRUE);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->m_title);
	self->priv->m_title = _tmp4_;
	if (url != NULL) {
		_tmp5_ = url;
	} else {
		_tmp5_ = "";
	}
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->m_url);
	self->priv->m_url = _tmp6_;
	if (html != NULL) {
		gchar* _tmp8_;
		_tmp8_ = feed_reader_utils_UTF8fix (html, FALSE);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->m_html);
	self->priv->m_html = _tmp10_;
	if (preview != NULL) {
		gchar* _tmp12_;
		_tmp12_ = feed_reader_utils_UTF8fix (preview, TRUE);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp12_;
	} else {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("");
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp13_;
	}
	_tmp14_ = g_strdup (_tmp11_);
	_g_free0 (self->priv->m_preview);
	self->priv->m_preview = _tmp14_;
	if (feedID != NULL) {
		_tmp15_ = feedID;
	} else {
		_tmp15_ = "";
	}
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (self->priv->m_feedID);
	self->priv->m_feedID = _tmp16_;
	if (g_strcmp0 (author, "") != 0) {
		_tmp17_ = author;
	} else {
		_tmp17_ = NULL;
	}
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (self->priv->m_author);
	self->priv->m_author = _tmp18_;
	self->priv->m_unread = unread;
	self->priv->m_marked = marked;
	self->priv->m_sortID = sortID;
	if (date != NULL) {
		GDateTime* _tmp20_;
		_tmp20_ = _g_date_time_ref0 (date);
		_g_date_time_unref0 (_tmp19_);
		_tmp19_ = _tmp20_;
	} else {
		GDateTime* _tmp21_;
		_tmp21_ = g_date_time_new_now_utc ();
		_g_date_time_unref0 (_tmp19_);
		_tmp19_ = _tmp21_;
	}
	_tmp22_ = _g_date_time_ref0 (_tmp19_);
	_g_date_time_unref0 (self->priv->m_date);
	self->priv->m_date = _tmp22_;
	_tmp23_ = g_strdup (guidHash);
	_g_free0 (self->priv->m_guidHash);
	self->priv->m_guidHash = _tmp23_;
	self->priv->m_lastModified = lastModified;
	if (tags == NULL) {
		GeeList* _tmp25_;
		_tmp25_ = gee_list_empty (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
		_g_object_unref0 (_tmp24_);
		_tmp24_ = _tmp25_;
	} else {
		GeeList* _tmp26_;
		_tmp26_ = _g_object_ref0 (tags);
		_g_object_unref0 (_tmp24_);
		_tmp24_ = _tmp26_;
	}
	_tmp27_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->m_tags);
	self->priv->m_tags = _tmp27_;
	if (enclosures == NULL) {
		GeeList* _tmp29_;
		_tmp29_ = gee_list_empty (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
		_g_object_unref0 (_tmp28_);
		_tmp28_ = _tmp29_;
	} else {
		GeeList* _tmp30_;
		_tmp30_ = _g_object_ref0 (enclosures);
		_g_object_unref0 (_tmp28_);
		_tmp28_ = _tmp30_;
	}
	_tmp31_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->m_enclosures);
	self->priv->m_enclosures = _tmp31_;
	_g_object_unref0 (_tmp28_);
	_g_object_unref0 (_tmp24_);
	_g_date_time_unref0 (_tmp19_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp1_);
	return self;
}

FeedReaderArticle*
feed_reader_article_new (const gchar* articleID,
                         const gchar* title,
                         const gchar* url,
                         const gchar* feedID,
                         FeedReaderArticleStatus unread,
                         FeedReaderArticleStatus marked,
                         const gchar* html,
                         const gchar* preview,
                         const gchar* author,
                         GDateTime* date,
                         gint sortID,
                         GeeList* tags,
                         GeeList* enclosures,
                         const gchar* guidHash,
                         gint lastModified)
{
	return feed_reader_article_construct (FEED_READER_TYPE_ARTICLE, articleID, title, url, feedID, unread, marked, html, preview, author, date, sortID, tags, enclosures, guidHash, lastModified);
}

gchar*
feed_reader_article_getArticleID (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_articleID;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
feed_reader_article_getArticleFileName (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_articleID;
	_tmp1_ = string_get_data (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = g_base64_encode (_tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	return result;
}

gchar*
feed_reader_article_getFeedFileName (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_articleID;
	_tmp1_ = string_get_data (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = g_base64_encode (_tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	return result;
}

gchar*
feed_reader_article_getTitle (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_article_setTitle (FeedReaderArticle* self,
                              const gchar* title)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup (title);
	_g_free0 (self->priv->m_title);
	self->priv->m_title = _tmp0_;
}

gchar*
feed_reader_article_getHTML (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_html;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_article_setHTML (FeedReaderArticle* self,
                             const gchar* html)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (html != NULL);
	_tmp0_ = g_strdup (html);
	_g_free0 (self->priv->m_html);
	self->priv->m_html = _tmp0_;
}

gchar*
feed_reader_article_getPreview (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_preview;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_article_setPreview (FeedReaderArticle* self,
                                const gchar* preview)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (preview != NULL);
	_tmp0_ = g_strdup (preview);
	_g_free0 (self->priv->m_preview);
	self->priv->m_preview = _tmp0_;
}

gchar*
feed_reader_article_getAuthor (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_author;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_article_setAuthor (FeedReaderArticle* self,
                               const gchar* author)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (author);
	_g_free0 (self->priv->m_author);
	self->priv->m_author = _tmp0_;
}

gchar*
feed_reader_article_getURL (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_url;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_article_setURL (FeedReaderArticle* self,
                            const gchar* url)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = g_strdup (url);
	_g_free0 (self->priv->m_url);
	self->priv->m_url = _tmp0_;
}

gint
feed_reader_article_getSortID (FeedReaderArticle* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_sortID;
	return result;
}

GDateTime*
feed_reader_article_getDate (FeedReaderArticle* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_date;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_article_SetDate (FeedReaderArticle* self,
                             GDateTime* date)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = _g_date_time_ref0 (date);
	_g_date_time_unref0 (self->priv->m_date);
	self->priv->m_date = _tmp0_;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
feed_reader_article_getDateNice (FeedReaderArticle* self,
                                 gboolean addTime)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gint now_year = 0;
	GDateTime* _tmp1_;
	gint now_day = 0;
	GDateTime* _tmp2_;
	gint now_week = 0;
	GDateTime* _tmp3_;
	gint date_year = 0;
	GDateTime* _tmp4_;
	gint date_day = 0;
	GDateTime* _tmp5_;
	gint date_week = 0;
	GDateTime* _tmp6_;
	GeeArrayList* formats = NULL;
	GeeArrayList* _tmp7_;
	gchar* format = NULL;
	GeeArrayList* _tmp16_;
	gchar* _tmp17_;
	GDateTime* _tmp18_;
	gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	now_year = g_date_time_get_year (_tmp1_);
	_tmp2_ = now;
	now_day = g_date_time_get_day_of_year (_tmp2_);
	_tmp3_ = now;
	now_week = g_date_time_get_week_of_year (_tmp3_);
	_tmp4_ = self->priv->m_date;
	date_year = g_date_time_get_year (_tmp4_);
	_tmp5_ = self->priv->m_date;
	date_day = g_date_time_get_day_of_year (_tmp5_);
	_tmp6_ = self->priv->m_date;
	date_week = g_date_time_get_week_of_year (_tmp6_);
	_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	formats = _tmp7_;
	if (date_year == now_year) {
		if (date_day == now_day) {
			addTime = TRUE;
		} else {
			if (date_day == (now_day - 1)) {
				GeeArrayList* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = formats;
				_tmp9_ = string_replace (_ ("Yesterday"), "%", "%%");
				_tmp10_ = _tmp9_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
				_g_free0 (_tmp10_);
				addTime = TRUE;
			} else {
				if (date_week == now_week) {
					GeeArrayList* _tmp11_;
					_tmp11_ = formats;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "%A");
				} else {
					GeeArrayList* _tmp12_;
					_tmp12_ = formats;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "%B %d");
				}
			}
		}
	} else {
		GeeArrayList* _tmp13_;
		_tmp13_ = formats;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "%Y-%m-%d");
	}
	if (addTime) {
		if (feed_reader_article_m_clock_12_hour) {
			GeeArrayList* _tmp14_;
			_tmp14_ = formats;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "%l:%M %p");
		} else {
			GeeArrayList* _tmp15_;
			_tmp15_ = formats;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "%H:%M");
		}
	}
	_tmp16_ = formats;
	_tmp17_ = feed_reader_string_utils_join ((GeeCollection*) _tmp16_, ", ");
	format = _tmp17_;
	_tmp18_ = self->priv->m_date;
	_tmp19_ = g_date_time_format (_tmp18_, format);
	result = _tmp19_;
	_g_free0 (format);
	_g_object_unref0 (formats);
	_g_date_time_unref0 (now);
	return result;
}

gchar*
feed_reader_article_getFeedID (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_feedID;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

FeedReaderArticleStatus
feed_reader_article_getUnread (FeedReaderArticle* self)
{
	FeedReaderArticleStatus result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_unread;
	return result;
}

void
feed_reader_article_setUnread (FeedReaderArticle* self,
                               FeedReaderArticleStatus unread)
{
	g_return_if_fail (self != NULL);
	self->priv->m_unread = unread;
}

FeedReaderArticleStatus
feed_reader_article_getMarked (FeedReaderArticle* self)
{
	FeedReaderArticleStatus result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_marked;
	return result;
}

void
feed_reader_article_setMarked (FeedReaderArticle* self,
                               FeedReaderArticleStatus marked)
{
	g_return_if_fail (self != NULL);
	self->priv->m_marked = marked;
}

GeeList*
feed_reader_article_getTagIDs (FeedReaderArticle* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_tags;
	result = _tmp0_;
	return result;
}

void
feed_reader_article_setTags (FeedReaderArticle* self,
                             GeeList* tags)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tags != NULL);
	_tmp0_ = _g_object_ref0 (tags);
	_g_object_unref0 (self->priv->m_tags);
	self->priv->m_tags = _tmp0_;
}

void
feed_reader_article_addTag (FeedReaderArticle* self,
                            const gchar* tagID)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_tags;
	if (!gee_collection_contains ((GeeCollection*) _tmp0_, tagID)) {
		GeeList* _tmp1_;
		_tmp1_ = self->priv->m_tags;
		gee_collection_add ((GeeCollection*) _tmp1_, tagID);
	}
}

void
feed_reader_article_removeTag (FeedReaderArticle* self,
                               const gchar* tagID)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_tags;
	if (gee_collection_contains ((GeeCollection*) _tmp0_, tagID)) {
		GeeList* _tmp1_;
		_tmp1_ = self->priv->m_tags;
		gee_collection_remove ((GeeCollection*) _tmp1_, tagID);
	}
}

GeeList*
feed_reader_article_getEnclosures (FeedReaderArticle* self)
{
	GeeList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_enclosures;
	result = _tmp0_;
	return result;
}

void
feed_reader_article_setImages (FeedReaderArticle* self,
                               GeeList* enclosures)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (enclosures != NULL);
	_tmp0_ = _g_object_ref0 (enclosures);
	_g_object_unref0 (self->priv->m_enclosures);
	self->priv->m_enclosures = _tmp0_;
}

void
feed_reader_article_addEnclosure (FeedReaderArticle* self,
                                  FeedReaderEnclosure* enc)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (enc != NULL);
	_tmp0_ = self->priv->m_enclosures;
	if (!gee_collection_contains ((GeeCollection*) _tmp0_, enc)) {
		GeeList* _tmp1_;
		_tmp1_ = self->priv->m_enclosures;
		gee_collection_add ((GeeCollection*) _tmp1_, enc);
	}
}

gboolean
feed_reader_article_haveMedia (FeedReaderArticle* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeList* _enc_list = NULL;
		GeeList* _tmp0_;
		gint _enc_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _enc_index = 0;
		_tmp0_ = self->priv->m_enclosures;
		_enc_list = _tmp0_;
		_tmp1_ = _enc_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_enc_size = _tmp3_;
		_enc_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderEnclosure* enc = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FeedReaderEnclosure* _tmp9_;
			_enc_index = _enc_index + 1;
			_tmp4_ = _enc_index;
			_tmp5_ = _enc_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _enc_list;
			_tmp7_ = gee_list_get (_tmp6_, _enc_index);
			enc = (FeedReaderEnclosure*) _tmp7_;
			_tmp9_ = enc;
			if (feed_reader_enclosure_get_enclosure_type (_tmp9_) == FEED_READER_ENCLOSURE_TYPE_VIDEO) {
				_tmp8_ = TRUE;
			} else {
				FeedReaderEnclosure* _tmp10_;
				_tmp10_ = enc;
				_tmp8_ = feed_reader_enclosure_get_enclosure_type (_tmp10_) == FEED_READER_ENCLOSURE_TYPE_AUDIO;
			}
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (enc);
				return result;
			}
			_g_object_unref0 (enc);
		}
	}
	result = FALSE;
	return result;
}

gchar*
feed_reader_article_getHash (FeedReaderArticle* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_guidHash;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gint
feed_reader_article_getLastModified (FeedReaderArticle* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_lastModified;
	return result;
}

gint
feed_reader_article_getPos (FeedReaderArticle* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_pos;
	return result;
}

void
feed_reader_article_setPos (FeedReaderArticle* self,
                            gint pos)
{
	g_return_if_fail (self != NULL);
	self->priv->m_pos = pos;
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_feed_reader_article____lambda4_ (void)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = feed_reader_article_m_gnome_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "clock-format");
	_tmp2_ = _tmp1_;
	feed_reader_article_m_clock_12_hour = g_strcmp0 (_tmp2_, "12h") == 0;
	_g_free0 (_tmp2_);
}

static void
__feed_reader_article____lambda4__g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
	_feed_reader_article____lambda4_ ();
}

static void
feed_reader_article_class_init (FeedReaderArticleClass * klass,
                                gpointer klass_data)
{
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettingsSchema* _tmp4_;
	feed_reader_article_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderArticle_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_article_finalize;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	schema_source = _tmp1_;
	_tmp2_ = schema_source;
	_tmp3_ = g_settings_schema_source_lookup (_tmp2_, "org.gnome.desktop.interface", TRUE);
	schema = _tmp3_;
	_tmp4_ = schema;
	if (_tmp4_ != NULL) {
		GSettingsSchema* _tmp5_;
		GSettings* _tmp6_;
		GSettings* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GSettings* _tmp10_;
		_tmp5_ = schema;
		_tmp6_ = g_settings_new_full (_tmp5_, NULL, NULL);
		_g_object_unref0 (feed_reader_article_m_gnome_settings);
		feed_reader_article_m_gnome_settings = _tmp6_;
		_tmp7_ = feed_reader_article_m_gnome_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, "clock-format");
		_tmp9_ = _tmp8_;
		feed_reader_article_m_clock_12_hour = g_strcmp0 (_tmp9_, "12h") == 0;
		_g_free0 (_tmp9_);
		_tmp10_ = feed_reader_article_m_gnome_settings;
		g_signal_connect (_tmp10_, "changed::clock-format", (GCallback) __feed_reader_article____lambda4__g_settings_changed, NULL);
	}
	_g_settings_schema_unref0 (schema);
	_g_settings_schema_source_unref0 (schema_source);
}

static void
feed_reader_article_instance_init (FeedReaderArticle * self,
                                   gpointer klass)
{
	self->priv = feed_reader_article_get_instance_private (self);
}

static void
feed_reader_article_finalize (GObject * obj)
{
	FeedReaderArticle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_ARTICLE, FeedReaderArticle);
	_g_free0 (self->priv->m_articleID);
	_g_free0 (self->priv->m_title);
	_g_free0 (self->priv->m_url);
	_g_free0 (self->priv->m_html);
	_g_free0 (self->priv->m_preview);
	_g_free0 (self->priv->m_feedID);
	_g_object_unref0 (self->priv->m_tags);
	_g_object_unref0 (self->priv->m_enclosures);
	_g_free0 (self->priv->m_author);
	_g_date_time_unref0 (self->priv->m_date);
	_g_free0 (self->priv->m_guidHash);
	G_OBJECT_CLASS (feed_reader_article_parent_class)->finalize (obj);
}

static GType
feed_reader_article_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderArticleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_article_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderArticle), 0, (GInstanceInitFunc) feed_reader_article_instance_init, NULL };
	GType feed_reader_article_type_id;
	feed_reader_article_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderArticle", &g_define_type_info, 0);
	FeedReaderArticle_private_offset = g_type_add_instance_private (feed_reader_article_type_id, sizeof (FeedReaderArticlePrivate));
	return feed_reader_article_type_id;
}

GType
feed_reader_article_get_type (void)
{
	static volatile gsize feed_reader_article_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_article_type_id__once)) {
		GType feed_reader_article_type_id;
		feed_reader_article_type_id = feed_reader_article_get_type_once ();
		g_once_init_leave (&feed_reader_article_type_id__once, feed_reader_article_type_id);
	}
	return feed_reader_article_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

