/* Feed.c generated by valac 0.56.3, the Vala compiler
 * generated from Feed.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	FEED_READER_FEED_0_PROPERTY,
	FEED_READER_FEED_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feed_properties[FEED_READER_FEED_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FeedReaderFeedPrivate {
	gchar* m_feedID;
	gchar* m_title;
	gchar* m_url;
	gchar* m_xmlURL;
	guint m_unread;
	GeeList* m_catIDs;
	gchar* m_iconURL;
};

static gint FeedReaderFeed_private_offset;
static gpointer feed_reader_feed_parent_class = NULL;

static void feed_reader_feed_finalize (GObject * obj);
static GType feed_reader_feed_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_feed_get_instance_private (FeedReaderFeed* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeed_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderFeed*
feed_reader_feed_construct (GType object_type,
                            const gchar* feedID,
                            const gchar* title,
                            const gchar* url,
                            guint unread,
                            GeeList* catIDs,
                            const gchar* iconURL,
                            const gchar* xmlURL)
{
	FeedReaderFeed * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp6_;
	GeeList* _tmp7_ = NULL;
	GeeList* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (feedID != NULL, NULL);
	self = (FeedReaderFeed*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (feedID);
	_g_free0 (self->priv->m_feedID);
	self->priv->m_feedID = _tmp0_;
	if (url != NULL) {
		_tmp1_ = url;
	} else {
		_tmp1_ = "";
	}
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->m_url);
	self->priv->m_url = _tmp2_;
	if (title != NULL) {
		gchar* _tmp4_;
		_tmp4_ = feed_reader_utils_UTF8fix (title, TRUE);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = feed_reader_utils_URLtoFeedName (url);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->m_title);
	self->priv->m_title = _tmp6_;
	self->priv->m_unread = unread;
	if (catIDs == NULL) {
		GeeList* _tmp8_;
		_tmp8_ = gee_list_empty (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
		_g_object_unref0 (_tmp7_);
		_tmp7_ = _tmp8_;
	} else {
		GeeList* _tmp9_;
		_tmp9_ = _g_object_ref0 (catIDs);
		_g_object_unref0 (_tmp7_);
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->m_catIDs);
	self->priv->m_catIDs = _tmp10_;
	if (g_strcmp0 (iconURL, "") == 0) {
		_tmp11_ = NULL;
	} else {
		_tmp11_ = iconURL;
	}
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (self->priv->m_iconURL);
	self->priv->m_iconURL = _tmp12_;
	_tmp13_ = g_strdup (xmlURL);
	_g_free0 (self->priv->m_xmlURL);
	self->priv->m_xmlURL = _tmp13_;
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp3_);
	return self;
}

FeedReaderFeed*
feed_reader_feed_new (const gchar* feedID,
                      const gchar* title,
                      const gchar* url,
                      guint unread,
                      GeeList* catIDs,
                      const gchar* iconURL,
                      const gchar* xmlURL)
{
	return feed_reader_feed_construct (FEED_READER_TYPE_FEED, feedID, title, url, unread, catIDs, iconURL, xmlURL);
}

gchar*
feed_reader_feed_getFeedID (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_feedID;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
feed_reader_feed_getFeedFileName (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_feedID;
	_tmp1_ = string_get_data (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = g_base64_encode (_tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	return result;
}

gchar*
feed_reader_feed_getTitle (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_feed_setTitle (FeedReaderFeed* self,
                           const gchar* title)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup (title);
	_g_free0 (self->priv->m_title);
	self->priv->m_title = _tmp0_;
}

gchar*
feed_reader_feed_getURL (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_url;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_feed_setURL (FeedReaderFeed* self,
                         const gchar* url)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = g_strdup (url);
	_g_free0 (self->priv->m_url);
	self->priv->m_url = _tmp0_;
}

guint
feed_reader_feed_getUnread (FeedReaderFeed* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->m_unread;
	return result;
}

void
feed_reader_feed_setUnread (FeedReaderFeed* self,
                            guint unread)
{
	g_return_if_fail (self != NULL);
	self->priv->m_unread = unread;
}

GeeList*
feed_reader_feed_getCatIDs (FeedReaderFeed* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_catIDs;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_feed_getCatString (FeedReaderFeed* self)
{
	GeeList* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_catIDs;
	_tmp1_ = feed_reader_string_utils_join ((GeeCollection*) _tmp0_, ",");
	result = _tmp1_;
	return result;
}

gboolean
feed_reader_feed_hasCat (FeedReaderFeed* self,
                         const gchar* catID)
{
	GeeList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (catID != NULL, FALSE);
	_tmp0_ = self->priv->m_catIDs;
	result = gee_collection_contains ((GeeCollection*) _tmp0_, catID);
	return result;
}

void
feed_reader_feed_addCat (FeedReaderFeed* self,
                         const gchar* catID)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_catIDs;
	gee_collection_add ((GeeCollection*) _tmp0_, catID);
}

void
feed_reader_feed_setCats (FeedReaderFeed* self,
                          GeeCollection* catIDs)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catIDs != NULL);
	_tmp0_ = self->priv->m_catIDs;
	gee_collection_clear ((GeeCollection*) _tmp0_);
	_tmp1_ = self->priv->m_catIDs;
	gee_collection_add_all ((GeeCollection*) _tmp1_, catIDs);
}

void
feed_reader_feed_setCategory (FeedReaderFeed* self,
                              const gchar* id)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->m_catIDs;
	gee_collection_clear ((GeeCollection*) _tmp0_);
	_tmp1_ = self->priv->m_catIDs;
	gee_collection_add ((GeeCollection*) _tmp1_, id);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
feed_reader_feed_isUncategorized (FeedReaderFeed* self)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_catIDs;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp4_ = self->priv->m_catIDs;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 1) {
		GeeList* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->m_catIDs;
		_tmp8_ = gee_list_get (_tmp7_, 0);
		_tmp9_ = (gchar*) _tmp8_;
		_tmp3_ = string_contains (_tmp9_, "global.must");
		_g_free0 (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gchar*
feed_reader_feed_getIconURL (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_iconURL;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_feed_setIconURL (FeedReaderFeed* self,
                             const gchar* url)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (url);
	_g_free0 (self->priv->m_iconURL);
	self->priv->m_iconURL = _tmp0_;
}

gchar*
feed_reader_feed_getXmlUrl (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_xmlURL;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_feed_print (FeedReaderFeed* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_title;
	_tmp1_ = self->priv->m_feedID;
	_tmp2_ = self->priv->m_url;
	_tmp3_ = g_strdup_printf ("\ntitle: %s\nid: %s\nurl: %s\nunread: %u", _tmp0_, _tmp1_, _tmp2_, self->priv->m_unread);
	_tmp4_ = _tmp3_;
	feed_reader_logger_debug (_tmp4_);
	_g_free0 (_tmp4_);
}

static void
feed_reader_feed_class_init (FeedReaderFeedClass * klass,
                             gpointer klass_data)
{
	feed_reader_feed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderFeed_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feed_finalize;
}

static void
feed_reader_feed_instance_init (FeedReaderFeed * self,
                                gpointer klass)
{
	self->priv = feed_reader_feed_get_instance_private (self);
}

static void
feed_reader_feed_finalize (GObject * obj)
{
	FeedReaderFeed * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEED, FeedReaderFeed);
	_g_free0 (self->priv->m_feedID);
	_g_free0 (self->priv->m_title);
	_g_free0 (self->priv->m_url);
	_g_free0 (self->priv->m_xmlURL);
	_g_object_unref0 (self->priv->m_catIDs);
	_g_free0 (self->priv->m_iconURL);
	G_OBJECT_CLASS (feed_reader_feed_parent_class)->finalize (obj);
}

static GType
feed_reader_feed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeed), 0, (GInstanceInitFunc) feed_reader_feed_instance_init, NULL };
	GType feed_reader_feed_type_id;
	feed_reader_feed_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderFeed", &g_define_type_info, 0);
	FeedReaderFeed_private_offset = g_type_add_instance_private (feed_reader_feed_type_id, sizeof (FeedReaderFeedPrivate));
	return feed_reader_feed_type_id;
}

GType
feed_reader_feed_get_type (void)
{
	static volatile gsize feed_reader_feed_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_feed_type_id__once)) {
		GType feed_reader_feed_type_id;
		feed_reader_feed_type_id = feed_reader_feed_get_type_once ();
		g_once_init_leave (&feed_reader_feed_type_id__once, feed_reader_feed_type_id);
	}
	return feed_reader_feed_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

