/* InterfaceState.c generated by valac 0.56.3, the Vala compiler
 * generated from InterfaceState.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

enum  {
	FEED_READER_INTERFACE_STATE_0_PROPERTY,
	FEED_READER_INTERFACE_STATE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_interface_state_properties[FEED_READER_INTERFACE_STATE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FeedReaderInterfaceStatePrivate {
	gint m_WindowHeight;
	gint m_WindowWidth;
	gint m_FeedsAndArticleWidth;
	gint m_FeedListWidth;
	gint m_ArticleListRowOffset;
	gint m_ArticleViewScrollPos;
	gboolean m_WindowMaximized;
	gdouble m_ArticleListScrollPos;
	gdouble m_FeedListScrollPos;
	gchar* m_SearchTerm;
	gchar* m_FeedListSelectedRow;
	gchar* m_ArticleListSelectedRow;
	gchar* m_ArticleListTopRow;
	gchar** m_ExpandedCategories;
	gint m_ExpandedCategories_length1;
	gint _m_ExpandedCategories_size_;
	FeedReaderArticleListState m_ArticleListState;
};

static gint FeedReaderInterfaceState_private_offset;
static gpointer feed_reader_interface_state_parent_class = NULL;

static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static void feed_reader_interface_state_finalize (GObject * obj);
static GType feed_reader_interface_state_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_interface_state_get_instance_private (FeedReaderInterfaceState* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderInterfaceState_private_offset);
}

FeedReaderInterfaceState*
feed_reader_interface_state_construct (GType object_type)
{
	FeedReaderInterfaceState * self = NULL;
	self = (FeedReaderInterfaceState*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderInterfaceState*
feed_reader_interface_state_new (void)
{
	return feed_reader_interface_state_construct (FEED_READER_TYPE_INTERFACE_STATE);
}

void
feed_reader_interface_state_write (FeedReaderInterfaceState* self,
                                   gboolean shutdown)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	const gchar* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	GSettings* _tmp29_;
	GSettings* _tmp30_;
	GSettings* _tmp31_;
	const gchar* _tmp32_;
	GSettings* _tmp33_;
	GSettings* _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = feed_reader_settings_state ();
	_tmp1_ = _tmp0_;
	g_settings_set_int (_tmp1_, "window-width", self->priv->m_WindowWidth);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = feed_reader_settings_state ();
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp3_, "window-height", self->priv->m_WindowHeight);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = feed_reader_settings_state ();
	_tmp5_ = _tmp4_;
	g_settings_set_boolean (_tmp5_, "window-maximized", self->priv->m_WindowMaximized);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = feed_reader_settings_state ();
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->m_ExpandedCategories;
	_tmp8__length1 = self->priv->m_ExpandedCategories_length1;
	g_settings_set_strv (_tmp7_, "expanded-categories", _tmp8_);
	_g_object_unref0 (_tmp7_);
	_tmp9_ = feed_reader_settings_state ();
	_tmp10_ = _tmp9_;
	g_settings_set_double (_tmp10_, "feed-row-scrollpos", self->priv->m_FeedListScrollPos);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = feed_reader_settings_state ();
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->m_FeedListSelectedRow;
	g_settings_set_string (_tmp12_, "feedlist-selected-row", _tmp13_);
	_g_object_unref0 (_tmp12_);
	_tmp14_ = feed_reader_settings_state ();
	_tmp15_ = _tmp14_;
	g_settings_set_int (_tmp15_, "feed-row-width", self->priv->m_FeedListWidth);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = feed_reader_settings_state ();
	_tmp17_ = _tmp16_;
	g_settings_set_int (_tmp17_, "feeds-and-articles-width", self->priv->m_FeedsAndArticleWidth);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = feed_reader_settings_state ();
	_tmp19_ = _tmp18_;
	g_settings_set_double (_tmp19_, "articlelist-scrollpos", self->priv->m_ArticleListScrollPos);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = feed_reader_settings_state ();
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->m_ArticleListSelectedRow;
	g_settings_set_string (_tmp21_, "articlelist-selected-row", _tmp22_);
	_g_object_unref0 (_tmp21_);
	_tmp24_ = self->priv->m_ArticleListTopRow;
	if (_tmp24_ == NULL) {
		_tmp23_ = "";
	} else {
		const gchar* _tmp25_;
		_tmp25_ = self->priv->m_ArticleListTopRow;
		_tmp23_ = _tmp25_;
	}
	_tmp26_ = feed_reader_settings_state ();
	_tmp27_ = _tmp26_;
	g_settings_set_string (_tmp27_, "articlelist-top-row", _tmp23_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = feed_reader_settings_state ();
	_tmp29_ = _tmp28_;
	g_settings_set_enum (_tmp29_, "show-articles", (gint) self->priv->m_ArticleListState);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = feed_reader_settings_state ();
	_tmp31_ = _tmp30_;
	_tmp32_ = self->priv->m_SearchTerm;
	g_settings_set_string (_tmp31_, "search-term", _tmp32_);
	_g_object_unref0 (_tmp31_);
	_tmp33_ = feed_reader_settings_state ();
	_tmp34_ = _tmp33_;
	g_settings_set_int (_tmp34_, "articleview-scrollpos", self->priv->m_ArticleViewScrollPos);
	_g_object_unref0 (_tmp34_);
	if (shutdown) {
		GSettings* _tmp35_;
		GSettings* _tmp36_;
		_tmp35_ = feed_reader_settings_state ();
		_tmp36_ = _tmp35_;
		g_settings_set_int (_tmp36_, "articlelist-row-offset", self->priv->m_ArticleListRowOffset);
		_g_object_unref0 (_tmp36_);
	}
}

void
feed_reader_interface_state_setWindowSize (FeedReaderInterfaceState* self,
                                           gint height,
                                           gint width)
{
	g_return_if_fail (self != NULL);
	self->priv->m_WindowHeight = height;
	self->priv->m_WindowWidth = width;
}

gint
feed_reader_interface_state_getWindowHeight (FeedReaderInterfaceState* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_WindowHeight;
	return result;
}

gint
feed_reader_interface_state_getWindowWidth (FeedReaderInterfaceState* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_WindowWidth;
	return result;
}

void
feed_reader_interface_state_setFeedsAndArticleWidth (FeedReaderInterfaceState* self,
                                                     gint size)
{
	g_return_if_fail (self != NULL);
	self->priv->m_FeedsAndArticleWidth = size;
}

gint
feed_reader_interface_state_getFeedsAndArticleWidth (FeedReaderInterfaceState* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_FeedsAndArticleWidth;
	return result;
}

void
feed_reader_interface_state_setFeedListWidth (FeedReaderInterfaceState* self,
                                              gint size)
{
	g_return_if_fail (self != NULL);
	self->priv->m_FeedListWidth = size;
}

gint
feed_reader_interface_state_getFeedListWidth (FeedReaderInterfaceState* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_FeedListWidth;
	return result;
}

void
feed_reader_interface_state_setFeedListScrollPos (FeedReaderInterfaceState* self,
                                                  gdouble pos)
{
	g_return_if_fail (self != NULL);
	self->priv->m_FeedListScrollPos = pos;
}

gdouble
feed_reader_interface_state_getFeedListScrollPos (FeedReaderInterfaceState* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->m_FeedListScrollPos;
	return result;
}

void
feed_reader_interface_state_setArticleViewScrollPos (FeedReaderInterfaceState* self,
                                                     gint pos)
{
	g_return_if_fail (self != NULL);
	self->priv->m_ArticleViewScrollPos = pos;
}

gint
feed_reader_interface_state_getArticleViewScrollPos (FeedReaderInterfaceState* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_ArticleViewScrollPos;
	return result;
}

void
feed_reader_interface_state_setArticleListScrollPos (FeedReaderInterfaceState* self,
                                                     gdouble pos)
{
	g_return_if_fail (self != NULL);
	self->priv->m_ArticleListScrollPos = pos;
}

gdouble
feed_reader_interface_state_getArticleListScrollPos (FeedReaderInterfaceState* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->m_ArticleListScrollPos;
	return result;
}

void
feed_reader_interface_state_setArticleListRowOffset (FeedReaderInterfaceState* self,
                                                     gint count)
{
	g_return_if_fail (self != NULL);
	self->priv->m_ArticleListRowOffset = count;
}

gint
feed_reader_interface_state_getArticleListRowOffset (FeedReaderInterfaceState* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_ArticleListRowOffset;
	return result;
}

void
feed_reader_interface_state_setArticleListSelectedRow (FeedReaderInterfaceState* self,
                                                       const gchar* articleID)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	_tmp0_ = g_strdup (articleID);
	_g_free0 (self->priv->m_ArticleListSelectedRow);
	self->priv->m_ArticleListSelectedRow = _tmp0_;
}

gchar*
feed_reader_interface_state_getArticleListSelectedRow (FeedReaderInterfaceState* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_ArticleListSelectedRow;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_interface_state_setArticleListTopRow (FeedReaderInterfaceState* self,
                                                  FeedReaderArticle* article)
{
	g_return_if_fail (self != NULL);
	if (article == NULL) {
		_g_free0 (self->priv->m_ArticleListTopRow);
		self->priv->m_ArticleListTopRow = NULL;
	} else {
		gchar* _tmp0_;
		_tmp0_ = feed_reader_article_getArticleID (article);
		_g_free0 (self->priv->m_ArticleListTopRow);
		self->priv->m_ArticleListTopRow = _tmp0_;
	}
}

gchar*
feed_reader_interface_state_getArticleListTopRow (FeedReaderInterfaceState* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_ArticleListTopRow;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_interface_state_setWindowMaximized (FeedReaderInterfaceState* self,
                                                gboolean max)
{
	g_return_if_fail (self != NULL);
	self->priv->m_WindowMaximized = max;
}

gboolean
feed_reader_interface_state_getWindowMaximized (FeedReaderInterfaceState* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->m_WindowMaximized;
	return result;
}

void
feed_reader_interface_state_setSearchTerm (FeedReaderInterfaceState* self,
                                           const gchar* search)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = g_strdup (search);
	_g_free0 (self->priv->m_SearchTerm);
	self->priv->m_SearchTerm = _tmp0_;
}

gchar*
feed_reader_interface_state_getSearchTerm (FeedReaderInterfaceState* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_SearchTerm;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_interface_state_setFeedListSelectedRow (FeedReaderInterfaceState* self,
                                                    const gchar* code)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	_tmp0_ = g_strdup (code);
	_g_free0 (self->priv->m_FeedListSelectedRow);
	self->priv->m_FeedListSelectedRow = _tmp0_;
}

gchar*
feed_reader_interface_state_getFeedListSelectedRow (FeedReaderInterfaceState* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_FeedListSelectedRow;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
feed_reader_interface_state_setExpandedCategories (FeedReaderInterfaceState* self,
                                                   gchar** array,
                                                   gint array_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (array != NULL) ? _vala_array_dup6 (array, array_length1) : array;
	_tmp0__length1 = array_length1;
	self->priv->m_ExpandedCategories = (_vala_array_free (self->priv->m_ExpandedCategories, self->priv->m_ExpandedCategories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_ExpandedCategories = _tmp0_;
	self->priv->m_ExpandedCategories_length1 = _tmp0__length1;
	self->priv->_m_ExpandedCategories_size_ = self->priv->m_ExpandedCategories_length1;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
feed_reader_interface_state_getExpandedCategories (FeedReaderInterfaceState* self,
                                                   gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_ExpandedCategories;
	_tmp0__length1 = self->priv->m_ExpandedCategories_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
feed_reader_interface_state_setArticleListState (FeedReaderInterfaceState* self,
                                                 FeedReaderArticleListState state)
{
	g_return_if_fail (self != NULL);
	self->priv->m_ArticleListState = state;
}

FeedReaderArticleListState
feed_reader_interface_state_getArticleListState (FeedReaderInterfaceState* self)
{
	FeedReaderArticleListState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->m_ArticleListState;
	return result;
}

static void
feed_reader_interface_state_class_init (FeedReaderInterfaceStateClass * klass,
                                        gpointer klass_data)
{
	feed_reader_interface_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderInterfaceState_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_interface_state_finalize;
}

static void
feed_reader_interface_state_instance_init (FeedReaderInterfaceState * self,
                                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	self->priv = feed_reader_interface_state_get_instance_private (self);
	self->priv->m_WindowHeight = 900;
	self->priv->m_WindowWidth = 1600;
	self->priv->m_FeedsAndArticleWidth = 600;
	self->priv->m_FeedListWidth = 200;
	self->priv->m_ArticleListRowOffset = 15;
	self->priv->m_ArticleViewScrollPos = 0;
	self->priv->m_WindowMaximized = FALSE;
	self->priv->m_ArticleListScrollPos = 0.0;
	self->priv->m_FeedListScrollPos = 0.0;
	_tmp0_ = g_strdup ("");
	self->priv->m_SearchTerm = _tmp0_;
	_tmp1_ = g_strdup ("feed -4");
	self->priv->m_FeedListSelectedRow = _tmp1_;
	_tmp2_ = g_strdup ("0");
	self->priv->m_ArticleListSelectedRow = _tmp2_;
	self->priv->m_ArticleListTopRow = NULL;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_ExpandedCategories = _tmp3_;
	self->priv->m_ExpandedCategories_length1 = 0;
	self->priv->_m_ExpandedCategories_size_ = self->priv->m_ExpandedCategories_length1;
	self->priv->m_ArticleListState = FEED_READER_ARTICLE_LIST_STATE_ALL;
}

static void
feed_reader_interface_state_finalize (GObject * obj)
{
	FeedReaderInterfaceState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_INTERFACE_STATE, FeedReaderInterfaceState);
	_g_free0 (self->priv->m_SearchTerm);
	_g_free0 (self->priv->m_FeedListSelectedRow);
	_g_free0 (self->priv->m_ArticleListSelectedRow);
	_g_free0 (self->priv->m_ArticleListTopRow);
	self->priv->m_ExpandedCategories = (_vala_array_free (self->priv->m_ExpandedCategories, self->priv->m_ExpandedCategories_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (feed_reader_interface_state_parent_class)->finalize (obj);
}

static GType
feed_reader_interface_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderInterfaceStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_interface_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderInterfaceState), 0, (GInstanceInitFunc) feed_reader_interface_state_instance_init, NULL };
	GType feed_reader_interface_state_type_id;
	feed_reader_interface_state_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderInterfaceState", &g_define_type_info, 0);
	FeedReaderInterfaceState_private_offset = g_type_add_instance_private (feed_reader_interface_state_type_id, sizeof (FeedReaderInterfaceStatePrivate));
	return feed_reader_interface_state_type_id;
}

GType
feed_reader_interface_state_get_type (void)
{
	static volatile gsize feed_reader_interface_state_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_interface_state_type_id__once)) {
		GType feed_reader_interface_state_type_id;
		feed_reader_interface_state_type_id = feed_reader_interface_state_get_type_once ();
		g_once_init_leave (&feed_reader_interface_state_type_id__once, feed_reader_interface_state_type_id);
	}
	return feed_reader_interface_state_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

