/* Password.c generated by valac 0.56.3, the Vala compiler
 * generated from Password.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <libsecret/secret.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

enum  {
	FEED_READER_PASSWORD_0_PROPERTY,
	FEED_READER_PASSWORD_NUM_PROPERTIES
};
static GParamSpec* feed_reader_password_properties[FEED_READER_PASSWORD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FeedReaderPasswordPrivate {
	SecretCollection* m_secrets;
	SecretSchema* m_schema;
	FeedReaderPasswordGetAttributesFunc m_get_attributes;
	gpointer m_get_attributes_target;
	GDestroyNotify m_get_attributes_target_destroy_notify;
	gchar* m_label;
};

static gint FeedReaderPassword_private_offset;
static gpointer feed_reader_password_parent_class = NULL;

static void feed_reader_password_unlock_keyring (FeedReaderPassword* self,
                                          GCancellable* cancellable,
                                          GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void feed_reader_password_finalize (GObject * obj);
static GType feed_reader_password_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_password_get_instance_private (FeedReaderPassword* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderPassword_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_secret_schema_ref0 (gpointer self)
{
	return self ? secret_schema_ref (self) : NULL;
}

FeedReaderPassword*
feed_reader_password_construct (GType object_type,
                                SecretCollection* secrets,
                                SecretSchema* schema,
                                const gchar* label,
                                FeedReaderPasswordGetAttributesFunc get_attributes,
                                gpointer get_attributes_target,
                                GDestroyNotify get_attributes_target_destroy_notify)
{
	FeedReaderPassword * self = NULL;
	SecretCollection* _tmp0_;
	SecretSchema* _tmp1_;
	gchar* _tmp2_;
	FeedReaderPasswordGetAttributesFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	g_return_val_if_fail (secrets != NULL, NULL);
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (FeedReaderPassword*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (secrets);
	_g_object_unref0 (self->priv->m_secrets);
	self->priv->m_secrets = _tmp0_;
	_tmp1_ = _secret_schema_ref0 (schema);
	_secret_schema_unref0 (self->priv->m_schema);
	self->priv->m_schema = _tmp1_;
	_tmp2_ = g_strdup (label);
	_g_free0 (self->priv->m_label);
	self->priv->m_label = _tmp2_;
	_tmp3_ = get_attributes;
	_tmp3__target = get_attributes_target;
	_tmp3__target_destroy_notify = get_attributes_target_destroy_notify;
	get_attributes = NULL;
	get_attributes_target = NULL;
	get_attributes_target_destroy_notify = NULL;
	(self->priv->m_get_attributes_target_destroy_notify == NULL) ? NULL : (self->priv->m_get_attributes_target_destroy_notify (self->priv->m_get_attributes_target), NULL);
	self->priv->m_get_attributes = NULL;
	self->priv->m_get_attributes_target = NULL;
	self->priv->m_get_attributes_target_destroy_notify = NULL;
	self->priv->m_get_attributes = _tmp3_;
	self->priv->m_get_attributes_target = _tmp3__target;
	self->priv->m_get_attributes_target_destroy_notify = _tmp3__target_destroy_notify;
	(get_attributes_target_destroy_notify == NULL) ? NULL : (get_attributes_target_destroy_notify (get_attributes_target), NULL);
	get_attributes = NULL;
	get_attributes_target = NULL;
	get_attributes_target_destroy_notify = NULL;
	return self;
}

FeedReaderPassword*
feed_reader_password_new (SecretCollection* secrets,
                          SecretSchema* schema,
                          const gchar* label,
                          FeedReaderPasswordGetAttributesFunc get_attributes,
                          gpointer get_attributes_target,
                          GDestroyNotify get_attributes_target_destroy_notify)
{
	return feed_reader_password_construct (FEED_READER_TYPE_PASSWORD, secrets, schema, label, get_attributes, get_attributes_target, get_attributes_target_destroy_notify);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
feed_reader_password_unlock_keyring (FeedReaderPassword* self,
                                     GCancellable* cancellable,
                                     GError** error)
{
	SecretCollection* _tmp0_;
	GList* collections_to_unlock = NULL;
	SecretCollection* _tmp1_;
	SecretCollection* _tmp2_;
	SecretService* service = NULL;
	SecretCollection* _tmp3_;
	SecretService* _tmp4_;
	SecretService* _tmp5_;
	SecretService* _tmp6_;
	GList* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_secrets;
	if (!secret_collection_get_locked (_tmp0_)) {
		return;
	}
	collections_to_unlock = NULL;
	_tmp1_ = self->priv->m_secrets;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	collections_to_unlock = g_list_append (collections_to_unlock, _tmp2_);
	_tmp3_ = self->priv->m_secrets;
	_tmp4_ = secret_collection_get_service (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	service = _tmp5_;
	_tmp6_ = service;
	_tmp7_ = collections_to_unlock;
	secret_service_unlock_sync (_tmp6_, _tmp7_, cancellable, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (service);
		(collections_to_unlock == NULL) ? NULL : (collections_to_unlock = (_g_list_free__g_object_unref0_ (collections_to_unlock), NULL));
		return;
	}
	_g_object_unref0 (service);
	(collections_to_unlock == NULL) ? NULL : (collections_to_unlock = (_g_list_free__g_object_unref0_ (collections_to_unlock), NULL));
}

gchar*
feed_reader_password_get_password (FeedReaderPassword* self,
                                   GCancellable* cancellable)
{
	GHashTable* attributes = NULL;
	FeedReaderPasswordGetAttributesFunc _tmp0_;
	gpointer _tmp0__target;
	GHashTable* _tmp1_;
	gchar* _tmp30_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_get_attributes;
	_tmp0__target = self->priv->m_get_attributes_target;
	_tmp1_ = _tmp0_ (_tmp0__target);
	attributes = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		GList* secrets = NULL;
		SecretCollection* _tmp4_;
		SecretSchema* _tmp5_;
		GHashTable* _tmp6_;
		GList* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GList* _tmp10_;
		feed_reader_password_unlock_keyring (self, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp2_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			result = _tmp3_;
			_g_hash_table_unref0 (attributes);
			return result;
		}
		_tmp4_ = self->priv->m_secrets;
		_tmp5_ = self->priv->m_schema;
		_tmp6_ = attributes;
		_tmp7_ = secret_collection_search_sync (_tmp4_, _tmp5_, _tmp6_, SECRET_SEARCH_NONE, cancellable, &_inner_error0_);
		secrets = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp8_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("");
			result = _tmp9_;
			(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
			_g_hash_table_unref0 (attributes);
			return result;
		}
		_tmp10_ = secrets;
		if (g_list_length (_tmp10_) != ((guint) 0)) {
			SecretItem* item = NULL;
			GList* _tmp11_;
			gconstpointer _tmp12_;
			SecretItem* _tmp13_;
			SecretItem* _tmp14_;
			gboolean _tmp15_ = FALSE;
			SecretValue* secret = NULL;
			SecretItem* _tmp17_;
			SecretValue* _tmp18_;
			SecretValue* _tmp19_;
			gchar* password = NULL;
			SecretValue* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp11_ = secrets;
			_tmp12_ = _tmp11_->data;
			_tmp13_ = _g_object_ref0 ((SecretItem*) _tmp12_);
			item = _tmp13_;
			_tmp14_ = item;
			secret_item_load_secret_sync (_tmp14_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (item);
				(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
				goto __catch0_g_error;
			}
			if (cancellable != NULL) {
				_tmp15_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gchar* _tmp16_;
				_tmp16_ = g_strdup ("");
				result = _tmp16_;
				_g_object_unref0 (item);
				(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
				_g_hash_table_unref0 (attributes);
				return result;
			}
			_tmp17_ = item;
			_tmp18_ = secret_item_get_secret (_tmp17_);
			secret = _tmp18_;
			_tmp19_ = secret;
			if (_tmp19_ == NULL) {
				gchar* _tmp20_;
				feed_reader_logger_error ("Password.get_password: Got NULL secret");
				_tmp20_ = g_strdup ("");
				result = _tmp20_;
				_secret_value_unref0 (secret);
				_g_object_unref0 (item);
				(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
				_g_hash_table_unref0 (attributes);
				return result;
			}
			_tmp21_ = secret;
			_tmp22_ = secret_value_get_text (_tmp21_);
			_tmp23_ = g_strdup (_tmp22_);
			password = _tmp23_;
			_tmp24_ = password;
			if (_tmp24_ == NULL) {
				gchar* _tmp25_;
				feed_reader_logger_error ("Password.get_password: Got NULL password in non-NULL secret (secret is" \
"n't a text?)");
				_tmp25_ = g_strdup ("");
				result = _tmp25_;
				_g_free0 (password);
				_secret_value_unref0 (secret);
				_g_object_unref0 (item);
				(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
				_g_hash_table_unref0 (attributes);
				return result;
			}
			result = password;
			_secret_value_unref0 (secret);
			_g_object_unref0 (item);
			(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
			_g_hash_table_unref0 (attributes);
			return result;
		}
		(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		_tmp28_ = g_strconcat ("Password.get_password: ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		feed_reader_logger_error (_tmp29_);
		_g_free0 (_tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp30_ = g_strdup ("");
	result = _tmp30_;
	_g_hash_table_unref0 (attributes);
	return result;
}

void
feed_reader_password_set_password (FeedReaderPassword* self,
                                   const gchar* password,
                                   GCancellable* cancellable)
{
	GHashTable* attributes = NULL;
	FeedReaderPasswordGetAttributesFunc _tmp0_;
	gpointer _tmp0__target;
	GHashTable* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (password != NULL);
	_tmp0_ = self->priv->m_get_attributes;
	_tmp0__target = self->priv->m_get_attributes_target;
	_tmp1_ = _tmp0_ (_tmp0__target);
	attributes = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		SecretValue* value = NULL;
		gint _tmp3_;
		gint _tmp4_;
		SecretValue* _tmp5_;
		SecretCollection* _tmp6_;
		SecretSchema* _tmp7_;
		GHashTable* _tmp8_;
		const gchar* _tmp9_;
		SecretValue* _tmp10_;
		SecretItem* _tmp11_;
		SecretItem* _tmp12_;
		feed_reader_password_unlock_keyring (self, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp2_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_g_hash_table_unref0 (attributes);
			return;
		}
		_tmp3_ = strlen (password);
		_tmp4_ = _tmp3_;
		_tmp5_ = secret_value_new (password, (gssize) _tmp4_, "text/plain");
		value = _tmp5_;
		_tmp6_ = self->priv->m_secrets;
		_tmp7_ = self->priv->m_schema;
		_tmp8_ = attributes;
		_tmp9_ = self->priv->m_label;
		_tmp10_ = value;
		_tmp11_ = secret_item_create_sync (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, SECRET_ITEM_CREATE_REPLACE, cancellable, &_inner_error0_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp12_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_secret_value_unref0 (value);
			goto __catch0_g_error;
		}
		_secret_value_unref0 (value);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strconcat ("Password.setPassword: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		feed_reader_logger_error (_tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_hash_table_unref0 (attributes);
}

gboolean
feed_reader_password_delete_password (FeedReaderPassword* self,
                                      GCancellable* cancellable)
{
	GHashTable* attributes = NULL;
	FeedReaderPasswordGetAttributesFunc _tmp0_;
	gpointer _tmp0__target;
	GHashTable* _tmp1_;
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_get_attributes;
	_tmp0__target = self->priv->m_get_attributes_target;
	_tmp1_ = _tmp0_ (_tmp0__target);
	attributes = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		GList* secrets = NULL;
		SecretCollection* _tmp3_;
		SecretSchema* _tmp4_;
		GHashTable* _tmp5_;
		GList* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GList* _tmp8_;
		feed_reader_password_unlock_keyring (self, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp2_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = FALSE;
			_g_hash_table_unref0 (attributes);
			return result;
		}
		_tmp3_ = self->priv->m_secrets;
		_tmp4_ = self->priv->m_schema;
		_tmp5_ = attributes;
		_tmp6_ = secret_collection_search_sync (_tmp3_, _tmp4_, _tmp5_, SECRET_SEARCH_NONE, cancellable, &_inner_error0_);
		secrets = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp7_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			result = FALSE;
			(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
			_g_hash_table_unref0 (attributes);
			return result;
		}
		_tmp8_ = secrets;
		if (g_list_length (_tmp8_) != ((guint) 0)) {
			SecretItem* item = NULL;
			GList* _tmp9_;
			gconstpointer _tmp10_;
			SecretItem* _tmp11_;
			SecretItem* _tmp12_;
			_tmp9_ = secrets;
			_tmp10_ = _tmp9_->data;
			_tmp11_ = _g_object_ref0 ((SecretItem*) _tmp10_);
			item = _tmp11_;
			_tmp12_ = item;
			secret_item_delete_sync (_tmp12_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (item);
				(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_object_unref0 (item);
			(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
			_g_hash_table_unref0 (attributes);
			return result;
		}
		result = FALSE;
		(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
		_g_hash_table_unref0 (attributes);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strconcat ("Password.delete_password: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		feed_reader_logger_error (_tmp16_);
		_g_free0 (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		_g_hash_table_unref0 (attributes);
		return result;
	}
	__finally0:
	_g_hash_table_unref0 (attributes);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp17_;
}

static void
feed_reader_password_class_init (FeedReaderPasswordClass * klass,
                                 gpointer klass_data)
{
	feed_reader_password_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderPassword_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_password_finalize;
}

static void
feed_reader_password_instance_init (FeedReaderPassword * self,
                                    gpointer klass)
{
	self->priv = feed_reader_password_get_instance_private (self);
}

static void
feed_reader_password_finalize (GObject * obj)
{
	FeedReaderPassword * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_PASSWORD, FeedReaderPassword);
	_g_object_unref0 (self->priv->m_secrets);
	_secret_schema_unref0 (self->priv->m_schema);
	(self->priv->m_get_attributes_target_destroy_notify == NULL) ? NULL : (self->priv->m_get_attributes_target_destroy_notify (self->priv->m_get_attributes_target), NULL);
	self->priv->m_get_attributes = NULL;
	self->priv->m_get_attributes_target = NULL;
	self->priv->m_get_attributes_target_destroy_notify = NULL;
	_g_free0 (self->priv->m_label);
	G_OBJECT_CLASS (feed_reader_password_parent_class)->finalize (obj);
}

static GType
feed_reader_password_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderPasswordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_password_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderPassword), 0, (GInstanceInitFunc) feed_reader_password_instance_init, NULL };
	GType feed_reader_password_type_id;
	feed_reader_password_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderPassword", &g_define_type_info, 0);
	FeedReaderPassword_private_offset = g_type_add_instance_private (feed_reader_password_type_id, sizeof (FeedReaderPasswordPrivate));
	return feed_reader_password_type_id;
}

GType
feed_reader_password_get_type (void)
{
	static volatile gsize feed_reader_password_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_password_type_id__once)) {
		GType feed_reader_password_type_id;
		feed_reader_password_type_id = feed_reader_password_get_type_once ();
		g_once_init_leave (&feed_reader_password_type_id__once, feed_reader_password_type_id);
	}
	return feed_reader_password_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

