/* Rfc822.c generated by valac 0.56.3, the Vala compiler
 * generated from Rfc822.vala, do not modify */

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <float.h>
#include <math.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
* Parse a date string in RFC 822 format
* Note that we don't use Time.strptime because it uses the current locale
* to parse month names, but RFC 822 specifically requires months to be
* written in English.
* See: https://www.w3.org/Protocols/rfc822/#z28
* And: https://groups.yahoo.com/neo/groups/rss-public/conversations/topics/536
* */
GDateTime*
feed_reader_rfc822_parseDate (const gchar* str)
{
	GRegex* re = NULL;
	GMatchInfo* info = NULL;
	GRegex* _tmp6_;
	GMatchInfo* _tmp7_ = NULL;
	gboolean _tmp8_;
	gchar* dayStr = NULL;
	GMatchInfo* _tmp9_;
	gchar* _tmp10_;
	gint day = 0;
	const gchar* _tmp11_;
	gchar* monthStr = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint month = 0;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GQuark _tmp20_ = 0U;
	static GQuark _tmp19_label0 = 0;
	static GQuark _tmp19_label1 = 0;
	static GQuark _tmp19_label2 = 0;
	static GQuark _tmp19_label3 = 0;
	static GQuark _tmp19_label4 = 0;
	static GQuark _tmp19_label5 = 0;
	static GQuark _tmp19_label6 = 0;
	static GQuark _tmp19_label7 = 0;
	static GQuark _tmp19_label8 = 0;
	static GQuark _tmp19_label9 = 0;
	static GQuark _tmp19_label10 = 0;
	static GQuark _tmp19_label11 = 0;
	gchar* yearStr = NULL;
	GMatchInfo* _tmp21_;
	gchar* _tmp22_;
	gint year = 0;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gchar* hourStr = NULL;
	GMatchInfo* _tmp26_;
	gchar* _tmp27_;
	gint hour = 0;
	const gchar* _tmp28_;
	gchar* minuteStr = NULL;
	GMatchInfo* _tmp29_;
	gchar* _tmp30_;
	gint minute = 0;
	const gchar* _tmp31_;
	gchar* secondStr = NULL;
	GMatchInfo* _tmp32_;
	gchar* _tmp33_;
	gint _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	gint second = 0;
	gchar* zoneStr = NULL;
	GMatchInfo* _tmp39_;
	gchar* _tmp40_;
	GTimeZone* zone = NULL;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GQuark _tmp45_ = 0U;
	static GQuark _tmp44_label0 = 0;
	static GQuark _tmp44_label1 = 0;
	static GQuark _tmp44_label2 = 0;
	static GQuark _tmp44_label3 = 0;
	static GQuark _tmp44_label4 = 0;
	static GQuark _tmp44_label5 = 0;
	static GQuark _tmp44_label6 = 0;
	static GQuark _tmp44_label7 = 0;
	static GQuark _tmp44_label8 = 0;
	static GQuark _tmp44_label9 = 0;
	static GQuark _tmp44_label10 = 0;
	GTimeZone* _tmp54_;
	GDateTime* _tmp55_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	if (str == NULL) {
		result = NULL;
		return result;
	}
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("\n" \
"\t\t\t\t# We don't care about the day of the week\n" \
"\t\t\t\t\\s*(?:(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun),\\s*)?\n" \
"\t\t\t\t(?<day>\\d{1,2})\\s+\n" \
"\t\t\t\t(?<month>Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+\n" \
"\t\t\t\t# The standard specifies 2-digit years but 4 digit years are\n" \
"\t\t\t\t# recommended now.\n" \
"\t\t\t\t# This pattern will also accept 3-digit years, so we'll have t" \
"o\n" \
"\t\t\t\t# check for that separately\n" \
"\t\t\t\t(?<year>\\d{2,4})\\s+\n" \
"\t\t\t\t(?<hour>\\d{2})\n" \
"\t\t\t\t:(?<minute>\\d{2})\n" \
"\t\t\t\t(?::(?<second>\\d{2}))?\\s+\n" \
"\t\t\t\t(?<zone>UT|GMT|EST|EDT|MST|MDT|PST|PDT|[A-Z]|(?:[+-]\\d{4}))\n" \
"\t\t\t\t", G_REGEX_CASELESS | G_REGEX_EXTENDED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (re);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "RFC822 regex failed to parse: %s\n", _tmp5_);
		_vala_assert (FALSE, "false");
		result = NULL;
		_g_error_free0 (e);
		_g_regex_unref0 (re);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (re);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = re;
	_tmp8_ = g_regex_match (_tmp6_, str, 0, &_tmp7_);
	_g_match_info_unref0 (info);
	info = _tmp7_;
	if (!_tmp8_) {
		result = NULL;
		_g_match_info_unref0 (info);
		_g_regex_unref0 (re);
		return result;
	}
	_tmp9_ = info;
	_tmp10_ = g_match_info_fetch_named (_tmp9_, "day");
	dayStr = _tmp10_;
	_tmp11_ = dayStr;
	day = atoi (_tmp11_);
	_tmp12_ = info;
	_tmp13_ = g_match_info_fetch_named (_tmp12_, "month");
	_tmp14_ = _tmp13_;
	_tmp15_ = g_ascii_strdown (_tmp14_, (gssize) -1);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	monthStr = _tmp16_;
	_tmp17_ = monthStr;
	_tmp18_ = _tmp17_;
	_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
	if (_tmp20_ == ((0 != _tmp19_label0) ? _tmp19_label0 : (_tmp19_label0 = g_quark_from_static_string ("jan")))) {
		switch (0) {
			default:
			{
				month = 1;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label1) ? _tmp19_label1 : (_tmp19_label1 = g_quark_from_static_string ("feb")))) {
		switch (0) {
			default:
			{
				month = 2;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label2) ? _tmp19_label2 : (_tmp19_label2 = g_quark_from_static_string ("mar")))) {
		switch (0) {
			default:
			{
				month = 3;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label3) ? _tmp19_label3 : (_tmp19_label3 = g_quark_from_static_string ("apr")))) {
		switch (0) {
			default:
			{
				month = 4;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label4) ? _tmp19_label4 : (_tmp19_label4 = g_quark_from_static_string ("may")))) {
		switch (0) {
			default:
			{
				month = 5;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label5) ? _tmp19_label5 : (_tmp19_label5 = g_quark_from_static_string ("jun")))) {
		switch (0) {
			default:
			{
				month = 6;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label6) ? _tmp19_label6 : (_tmp19_label6 = g_quark_from_static_string ("jul")))) {
		switch (0) {
			default:
			{
				month = 7;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label7) ? _tmp19_label7 : (_tmp19_label7 = g_quark_from_static_string ("aug")))) {
		switch (0) {
			default:
			{
				month = 8;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label8) ? _tmp19_label8 : (_tmp19_label8 = g_quark_from_static_string ("sep")))) {
		switch (0) {
			default:
			{
				month = 9;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label9) ? _tmp19_label9 : (_tmp19_label9 = g_quark_from_static_string ("oct")))) {
		switch (0) {
			default:
			{
				month = 10;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label10) ? _tmp19_label10 : (_tmp19_label10 = g_quark_from_static_string ("nov")))) {
		switch (0) {
			default:
			{
				month = 11;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label11) ? _tmp19_label11 : (_tmp19_label11 = g_quark_from_static_string ("dec")))) {
		switch (0) {
			default:
			{
				month = 12;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_vala_assert (FALSE, "false");
				result = NULL;
				_g_free0 (monthStr);
				_g_free0 (dayStr);
				_g_match_info_unref0 (info);
				_g_regex_unref0 (re);
				return result;
			}
		}
	}
	_tmp21_ = info;
	_tmp22_ = g_match_info_fetch_named (_tmp21_, "year");
	yearStr = _tmp22_;
	_tmp23_ = yearStr;
	year = atoi (_tmp23_);
	if (year >= 0) {
		_tmp24_ = year <= 49;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		year += 2000;
	} else {
		gboolean _tmp25_ = FALSE;
		if (year >= 50) {
			_tmp25_ = year < 100;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			year += 1900;
		}
	}
	_tmp26_ = info;
	_tmp27_ = g_match_info_fetch_named (_tmp26_, "hour");
	hourStr = _tmp27_;
	_tmp28_ = hourStr;
	hour = atoi (_tmp28_);
	_tmp29_ = info;
	_tmp30_ = g_match_info_fetch_named (_tmp29_, "minute");
	minuteStr = _tmp30_;
	_tmp31_ = minuteStr;
	minute = atoi (_tmp31_);
	_tmp32_ = info;
	_tmp33_ = g_match_info_fetch_named (_tmp32_, "second");
	secondStr = _tmp33_;
	_tmp36_ = secondStr;
	if (_tmp36_ == NULL) {
		_tmp35_ = TRUE;
	} else {
		const gchar* _tmp37_;
		_tmp37_ = secondStr;
		_tmp35_ = g_strcmp0 (_tmp37_, "") == 0;
	}
	if (_tmp35_) {
		_tmp34_ = 0;
	} else {
		const gchar* _tmp38_;
		_tmp38_ = secondStr;
		_tmp34_ = atoi (_tmp38_);
	}
	second = _tmp34_;
	_tmp39_ = info;
	_tmp40_ = g_match_info_fetch_named (_tmp39_, "zone");
	zoneStr = _tmp40_;
	_tmp41_ = zoneStr;
	_tmp42_ = g_ascii_strup (_tmp41_, (gssize) -1);
	_tmp43_ = _tmp42_;
	_tmp45_ = (NULL == _tmp43_) ? 0 : g_quark_from_string (_tmp43_);
	g_free (_tmp43_);
	if (_tmp45_ == ((0 != _tmp44_label0) ? _tmp44_label0 : (_tmp44_label0 = g_quark_from_static_string ("EDT")))) {
		switch (0) {
			default:
			{
				GTimeZone* _tmp46_;
				_tmp46_ = g_time_zone_new ("-04");
				_g_time_zone_unref0 (zone);
				zone = _tmp46_;
				break;
			}
		}
	} else if ((_tmp45_ == ((0 != _tmp44_label1) ? _tmp44_label1 : (_tmp44_label1 = g_quark_from_static_string ("CDT")))) || (_tmp45_ == ((0 != _tmp44_label2) ? _tmp44_label2 : (_tmp44_label2 = g_quark_from_static_string ("EST"))))) {
		switch (0) {
			default:
			{
				GTimeZone* _tmp47_;
				_tmp47_ = g_time_zone_new ("-05");
				_g_time_zone_unref0 (zone);
				zone = _tmp47_;
				break;
			}
		}
	} else if ((_tmp45_ == ((0 != _tmp44_label3) ? _tmp44_label3 : (_tmp44_label3 = g_quark_from_static_string ("CST")))) || (_tmp45_ == ((0 != _tmp44_label4) ? _tmp44_label4 : (_tmp44_label4 = g_quark_from_static_string ("MDT"))))) {
		switch (0) {
			default:
			{
				GTimeZone* _tmp48_;
				_tmp48_ = g_time_zone_new ("-06");
				_g_time_zone_unref0 (zone);
				zone = _tmp48_;
				break;
			}
		}
	} else if ((_tmp45_ == ((0 != _tmp44_label5) ? _tmp44_label5 : (_tmp44_label5 = g_quark_from_static_string ("MST")))) || (_tmp45_ == ((0 != _tmp44_label6) ? _tmp44_label6 : (_tmp44_label6 = g_quark_from_static_string ("PDT"))))) {
		switch (0) {
			default:
			{
				GTimeZone* _tmp49_;
				_tmp49_ = g_time_zone_new ("-07");
				_g_time_zone_unref0 (zone);
				zone = _tmp49_;
				break;
			}
		}
	} else if (_tmp45_ == ((0 != _tmp44_label7) ? _tmp44_label7 : (_tmp44_label7 = g_quark_from_static_string ("PST")))) {
		switch (0) {
			default:
			{
				GTimeZone* _tmp50_;
				_tmp50_ = g_time_zone_new ("-08");
				_g_time_zone_unref0 (zone);
				zone = _tmp50_;
				break;
			}
		}
	} else if (((_tmp45_ == ((0 != _tmp44_label8) ? _tmp44_label8 : (_tmp44_label8 = g_quark_from_static_string ("GMT")))) || (_tmp45_ == ((0 != _tmp44_label9) ? _tmp44_label9 : (_tmp44_label9 = g_quark_from_static_string ("UT"))))) || (_tmp45_ == ((0 != _tmp44_label10) ? _tmp44_label10 : (_tmp44_label10 = g_quark_from_static_string ("Z"))))) {
		switch (0) {
			default:
			{
				GTimeZone* _tmp51_;
				_tmp51_ = g_time_zone_new_utc ();
				_g_time_zone_unref0 (zone);
				zone = _tmp51_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp52_;
				GTimeZone* _tmp53_;
				_tmp52_ = zoneStr;
				_tmp53_ = g_time_zone_new (_tmp52_);
				_g_time_zone_unref0 (zone);
				zone = _tmp53_;
				break;
			}
		}
	}
	_tmp54_ = zone;
	_tmp55_ = g_date_time_new (_tmp54_, year, month, day, hour, minute, (gdouble) second);
	result = _tmp55_;
	_g_time_zone_unref0 (zone);
	_g_free0 (zoneStr);
	_g_free0 (secondStr);
	_g_free0 (minuteStr);
	_g_free0 (hourStr);
	_g_free0 (yearStr);
	_g_free0 (monthStr);
	_g_free0 (dayStr);
	_g_match_info_unref0 (info);
	_g_regex_unref0 (re);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

