/* SQLite.c generated by valac 0.56.3, the Vala compiler
 * generated from SQLite.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/
/* A wrapper around the low-level SQLite API */

#include "FeedReader.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <float.h>
#include <math.h>

enum  {
	FEED_READER_SQ_LITE_0_PROPERTY,
	FEED_READER_SQ_LITE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_sq_lite_properties[FEED_READER_SQ_LITE_NUM_PROPERTIES];
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _sqlite3_value_free0(var) ((var == NULL) ? NULL : (var = (sqlite3_value_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FeedReaderSQLitePrivate {
	sqlite3* m_db;
};

static gint FeedReaderSQLite_private_offset;
static gpointer feed_reader_sq_lite_parent_class = NULL;

static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void feed_reader_sq_lite_finalize (GObject * obj);
static GType feed_reader_sq_lite_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_sq_lite_get_instance_private (FeedReaderSQLite* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderSQLite_private_offset);
}

FeedReaderSQLite*
feed_reader_sq_lite_construct (GType object_type,
                               const gchar* db_path,
                               gint busy_timeout)
{
	FeedReaderSQLite * self = NULL;
	GFile* path = NULL;
	GFile* _tmp0_;
	GFile* parent = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gint rc = 0;
	sqlite3* _tmp9_ = NULL;
	gint _tmp10_;
	sqlite3* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (db_path != NULL, NULL);
	self = (FeedReaderSQLite*) g_object_new (object_type, NULL);
	_tmp0_ = g_file_new_for_path (db_path);
	path = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_file_get_parent (_tmp1_);
	parent = _tmp2_;
	_tmp3_ = parent;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		{
			GFile* _tmp4_;
			_tmp4_ = parent;
			g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					goto __catch0_g_io_error_exists;
				}
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_io_error_exists:
		{
			g_clear_error (&_inner_error0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			_tmp7_ = g_strconcat ("SQLite: ", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			feed_reader_logger_error (_tmp8_);
			_g_free0 (_tmp8_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parent);
			_g_object_unref0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = sqlite3_open_v2 (db_path, &_tmp9_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (self->priv->m_db);
	self->priv->m_db = _tmp9_;
	rc = _tmp10_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp11_;
		sqlite3* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = self->priv->m_db;
		_tmp12_ = self->priv->m_db;
		_tmp13_ = sqlite3_errmsg (_tmp12_);
		_tmp14_ = g_strdup_printf ("Can't open database: %d: %s", sqlite3_errcode (_tmp11_), _tmp13_);
		_tmp15_ = _tmp14_;
		g_error ("SQLite.vala:42: %s", _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = self->priv->m_db;
	sqlite3_busy_timeout (_tmp16_, busy_timeout);
	_g_object_unref0 (parent);
	_g_object_unref0 (path);
	return self;
}

FeedReaderSQLite*
feed_reader_sq_lite_new (const gchar* db_path,
                         gint busy_timeout)
{
	return feed_reader_sq_lite_construct (FEED_READER_TYPE_SQ_LITE, db_path, busy_timeout);
}

sqlite3_stmt*
feed_reader_sq_lite_prepare (FeedReaderSQLite* self,
                             const gchar* query)
{
	sqlite3_stmt* stmt = NULL;
	gint rc = 0;
	sqlite3* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	sqlite3_stmt* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_vala_return_val_if_fail (g_strcmp0 (query, "") != 0, "query != \"\"", NULL);
	_tmp0_ = self->priv->m_db;
	_tmp1_ = strlen (query);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, query, _tmp2_, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	rc = _tmp4_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp5_;
		sqlite3* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->priv->m_db;
		_tmp6_ = self->priv->m_db;
		_tmp7_ = sqlite3_errmsg (_tmp6_);
		_tmp8_ = g_strdup_printf ("Can't prepare statement: %d: %s\nSQL is %s", sqlite3_errcode (_tmp5_), _tmp7_, query);
		_tmp9_ = _tmp8_;
		g_error ("SQLite.vala:56: %s", _tmp9_);
		_g_free0 (_tmp9_);
	}
	result = stmt;
	return result;
}

gchar*
feed_reader_sq_lite_errmsg (FeedReaderSQLite* self)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_db;
	_tmp1_ = sqlite3_errmsg (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
feed_reader_sq_lite_checkpoint (FeedReaderSQLite* self)
{
	sqlite3* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_db;
	sqlite3_wal_checkpoint (_tmp0_, "");
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
feed_reader_sq_lite_simple_query (FeedReaderSQLite* self,
                                  const gchar* query)
{
	gchar* errmsg = NULL;
	gint ec = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_vala_return_if_fail (g_strcmp0 (query, "") != 0, "query != \"\"");
	_tmp0_ = self->priv->m_db;
	_tmp2_ = _sqlite3_exec (_tmp0_, query, NULL, NULL, &_tmp1_);
	_g_free0 (errmsg);
	errmsg = _tmp1_;
	ec = _tmp2_;
	if (ec != SQLITE_OK) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup_printf ("Failed to execute simple query: %d: %s\nSQL is: %s", ec, errmsg, query);
		_tmp4_ = _tmp3_;
		g_error ("SQLite.vala:78: %s", _tmp4_);
		_g_free0 (_tmp4_);
	}
	_g_free0 (errmsg);
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

GeeList*
feed_reader_sq_lite_execute (FeedReaderSQLite* self,
                             const gchar* query,
                             GValue** params,
                             gint params_length1)
{
	sqlite3_stmt* stmt = NULL;
	gint rc = 0;
	sqlite3* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	GeeArrayList* rows = NULL;
	GeeArrayList* _tmp28_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_vala_return_val_if_fail (g_strcmp0 (query, "") != 0, "query != \"\"", NULL);
	_tmp0_ = self->priv->m_db;
	_tmp1_ = strlen (query);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, query, _tmp2_, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	rc = _tmp4_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp5_;
		sqlite3* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->priv->m_db;
		_tmp6_ = self->priv->m_db;
		_tmp7_ = sqlite3_errmsg (_tmp6_);
		_tmp8_ = g_strdup_printf ("Can't prepare statement: %d: %s\nSQL is: %s", sqlite3_errcode (_tmp5_), _tmp7_, query);
		_tmp9_ = _tmp8_;
		g_error ("SQLite.vala:89: %s", _tmp9_);
		_g_free0 (_tmp9_);
	}
	if (params != NULL) {
		gint i = 0;
		i = 1;
		{
			GValue** param_collection = NULL;
			gint param_collection_length1 = 0;
			gint _param_collection_size_ = 0;
			gint param_it = 0;
			param_collection = params;
			param_collection_length1 = params_length1;
			for (param_it = 0; param_it < param_collection_length1; param_it = param_it + 1) {
				GValue* _tmp10_;
				GValue* param = NULL;
				_tmp10_ = __g_value_dup0 (param_collection[param_it]);
				param = _tmp10_;
				{
					GValue* _tmp11_;
					gint _tmp27_;
					_tmp11_ = param;
					if (((gpointer) _tmp11_) == NULL) {
						sqlite3_bind_null (stmt, i);
					} else {
						gboolean _tmp12_ = FALSE;
						GValue* _tmp13_;
						_tmp13_ = param;
						if (G_VALUE_HOLDS (_tmp13_, G_TYPE_FLOAT)) {
							_tmp12_ = TRUE;
						} else {
							GValue* _tmp14_;
							_tmp14_ = param;
							_tmp12_ = G_VALUE_HOLDS (_tmp14_, G_TYPE_DOUBLE);
						}
						if (_tmp12_) {
							GValue as_double = {0};
							GValue _tmp15_ = {0};
							GValue* _tmp16_;
							GValue _tmp17_;
							g_value_init (&_tmp15_, G_TYPE_DOUBLE);
							as_double = _tmp15_;
							_tmp16_ = param;
							g_value_transform (_tmp16_, &as_double);
							_tmp17_ = as_double;
							sqlite3_bind_double (stmt, i, g_value_get_double (&_tmp17_));
							G_IS_VALUE (&as_double) ? (g_value_unset (&as_double), NULL) : NULL;
						} else {
							GValue* _tmp18_;
							_tmp18_ = param;
							if (g_value_type_transformable (G_VALUE_TYPE (_tmp18_), G_TYPE_INT64)) {
								GValue as_int = {0};
								GValue _tmp19_ = {0};
								GValue* _tmp20_;
								GValue _tmp21_;
								g_value_init (&_tmp19_, G_TYPE_INT64);
								as_int = _tmp19_;
								_tmp20_ = param;
								g_value_transform (_tmp20_, &as_int);
								_tmp21_ = as_int;
								sqlite3_bind_int64 (stmt, i, g_value_get_int64 (&_tmp21_));
								G_IS_VALUE (&as_int) ? (g_value_unset (&as_int), NULL) : NULL;
							} else {
								GValue as_string = {0};
								GValue _tmp22_ = {0};
								GValue* _tmp23_;
								GValue _tmp24_;
								gchar* _tmp25_;
								GDestroyNotify _tmp26_;
								g_value_init (&_tmp22_, G_TYPE_STRING);
								as_string = _tmp22_;
								_tmp23_ = param;
								g_value_transform (_tmp23_, &as_string);
								_tmp24_ = as_string;
								_tmp25_ = g_strdup (g_value_get_string (&_tmp24_));
								_tmp26_ = g_free;
								sqlite3_bind_text (stmt, i, _tmp25_, -1, _tmp26_);
								G_IS_VALUE (&as_string) ? (g_value_unset (&as_string), NULL) : NULL;
							}
						}
					}
					i = i + 1;
					_tmp27_ = i;
					__vala_GValue_free0 (param);
				}
			}
		}
	}
	_tmp28_ = gee_array_list_new (GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	rows = _tmp28_;
	while (TRUE) {
		GeeArrayList* row = NULL;
		GeeArrayList* _tmp29_;
		GeeArrayList* _tmp36_;
		GeeArrayList* _tmp37_;
		if (!(sqlite3_step (stmt) == SQLITE_ROW)) {
			break;
		}
		_tmp29_ = gee_array_list_new (G_TYPE_POINTER, (GBoxedCopyFunc) sqlite3_value_dup, (GDestroyNotify) sqlite3_value_free, NULL, NULL, NULL);
		row = _tmp29_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp30_ = FALSE;
				_tmp30_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp32_;
					const sqlite3_value* _tmp33_;
					sqlite3_value* _tmp34_;
					sqlite3_value* _tmp35_;
					if (!_tmp30_) {
						gint _tmp31_;
						i = i + 1;
						_tmp31_ = i;
					}
					_tmp30_ = FALSE;
					if (!(i < sqlite3_column_count (stmt))) {
						break;
					}
					_tmp32_ = row;
					_tmp33_ = sqlite3_column_value (stmt, i);
					_tmp34_ = sqlite3_value_dup (_tmp33_);
					_tmp35_ = _tmp34_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp35_);
					_sqlite3_value_free0 (_tmp35_);
				}
			}
		}
		_tmp36_ = rows;
		_tmp37_ = row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (GeeList*) _tmp37_);
		_g_object_unref0 (row);
	}
	sqlite3_reset (stmt);
	result = (GeeList*) rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
feed_reader_sq_lite_quote_string (const gchar* str)
{
	gchar* escaped = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = string_replace (str, "'", "''");
	escaped = _tmp0_;
	_tmp1_ = string_to_string (escaped);
	_tmp2_ = g_strconcat ("'", _tmp1_, "'", NULL);
	result = _tmp2_;
	_g_free0 (escaped);
	return result;
}

static void
feed_reader_sq_lite_class_init (FeedReaderSQLiteClass * klass,
                                gpointer klass_data)
{
	feed_reader_sq_lite_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderSQLite_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_sq_lite_finalize;
}

static void
feed_reader_sq_lite_instance_init (FeedReaderSQLite * self,
                                   gpointer klass)
{
	self->priv = feed_reader_sq_lite_get_instance_private (self);
}

static void
feed_reader_sq_lite_finalize (GObject * obj)
{
	FeedReaderSQLite * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_SQ_LITE, FeedReaderSQLite);
	_sqlite3_close0 (self->priv->m_db);
	G_OBJECT_CLASS (feed_reader_sq_lite_parent_class)->finalize (obj);
}

static GType
feed_reader_sq_lite_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderSQLiteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_sq_lite_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderSQLite), 0, (GInstanceInitFunc) feed_reader_sq_lite_instance_init, NULL };
	GType feed_reader_sq_lite_type_id;
	feed_reader_sq_lite_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderSQLite", &g_define_type_info, 0);
	FeedReaderSQLite_private_offset = g_type_add_instance_private (feed_reader_sq_lite_type_id, sizeof (FeedReaderSQLitePrivate));
	return feed_reader_sq_lite_type_id;
}

GType
feed_reader_sq_lite_get_type (void)
{
	static volatile gsize feed_reader_sq_lite_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_sq_lite_type_id__once)) {
		GType feed_reader_sq_lite_type_id;
		feed_reader_sq_lite_type_id = feed_reader_sq_lite_get_type_once ();
		g_once_init_leave (&feed_reader_sq_lite_type_id__once, feed_reader_sq_lite_type_id);
	}
	return feed_reader_sq_lite_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

