/* Structs.c generated by valac 0.56.3, the Vala compiler
 * generated from Structs.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <gio/gio.h>

#define FEED_READER_RESOURCE_METADATA_CACHE_GROUP "cache"
#define FEED_READER_RESOURCE_METADATA_ETAG_KEY "etag"
#define FEED_READER_RESOURCE_METADATA_LAST_MODIFIED_KEY "last_modified"
#define FEED_READER_RESOURCE_METADATA_EXPIRES_KEY "last_checked"

#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FeedReaderResourceMetadataFromFileAsyncData FeedReaderResourceMetadataFromFileAsyncData;
typedef struct _FeedReaderResourceMetadataSaveToFileAsyncData FeedReaderResourceMetadataSaveToFileAsyncData;

struct _FeedReaderResourceMetadataFromFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* filename;
	FeedReaderResourceMetadata result;
	GFile* file;
	GFile* _tmp0_;
	guint8* contents;
	gint contents_length1;
	gint _contents_size_;
	GFile* _tmp1_;
	guint8* _tmp2_;
	gsize _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	FeedReaderResourceMetadata _tmp5_;
	GError* e;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FeedReaderResourceMetadata _tmp13_;
	GError* _inner_error0_;
};

struct _FeedReaderResourceMetadataSaveToFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FeedReaderResourceMetadata self;
	gchar* filename;
	GFile* file;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GDateTime* _tmp5_;
	GFile* _tmp6_;
	GError* e;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GKeyFile* config;
	GKeyFile* _tmp14_;
	const gchar* _tmp15_;
	GKeyFile* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GKeyFile* _tmp19_;
	const gchar* _tmp20_;
	GDateTime* _tmp21_;
	GKeyFile* _tmp22_;
	GDateTime* _tmp23_;
	gchar* data;
	GKeyFile* _tmp24_;
	gchar* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	const gchar* _tmp30_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_;
	guint8* _tmp33_;
	gint _tmp33__length1;
	GError* _vala1_e;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GError* _inner_error0_;
};

static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
static gint64* _int64_dup (gint64* self);
static void feed_reader_resource_metadata_from_file_async_data_free (gpointer _data);
static gboolean feed_reader_resource_metadata_from_file_async_co (FeedReaderResourceMetadataFromFileAsyncData* _data_);
static void feed_reader_resource_metadata_from_file_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void feed_reader_resource_metadata_save_to_file_async_data_free (gpointer _data);
static gboolean feed_reader_resource_metadata_save_to_file_async_co (FeedReaderResourceMetadataSaveToFileAsyncData* _data_);
static void feed_reader_resource_metadata_save_to_file_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
feed_reader_backend_info_copy (const FeedReaderBackendInfo* self,
                               FeedReaderBackendInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).ID;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ID);
	(*dest).ID = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	(*dest).flags = (*self).flags;
	_tmp4_ = (*self).website;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).website);
	(*dest).website = _tmp5_;
	_tmp6_ = (*self).iconName;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).iconName);
	(*dest).iconName = _tmp7_;
}

void
feed_reader_backend_info_destroy (FeedReaderBackendInfo* self)
{
	_g_free0 ((*self).ID);
	_g_free0 ((*self).name);
	_g_free0 ((*self).website);
	_g_free0 ((*self).iconName);
}

FeedReaderBackendInfo*
feed_reader_backend_info_dup (const FeedReaderBackendInfo* self)
{
	FeedReaderBackendInfo* dup;
	dup = g_new0 (FeedReaderBackendInfo, 1);
	feed_reader_backend_info_copy (self, dup);
	return dup;
}

void
feed_reader_backend_info_free (FeedReaderBackendInfo* self)
{
	feed_reader_backend_info_destroy (self);
	g_free (self);
}

static GType
feed_reader_backend_info_get_type_once (void)
{
	GType feed_reader_backend_info_type_id;
	feed_reader_backend_info_type_id = g_boxed_type_register_static ("FeedReaderBackendInfo", (GBoxedCopyFunc) feed_reader_backend_info_dup, (GBoxedFreeFunc) feed_reader_backend_info_free);
	return feed_reader_backend_info_type_id;
}

GType
feed_reader_backend_info_get_type (void)
{
	static volatile gsize feed_reader_backend_info_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_backend_info_type_id__once)) {
		GType feed_reader_backend_info_type_id;
		feed_reader_backend_info_type_id = feed_reader_backend_info_get_type_once ();
		g_once_init_leave (&feed_reader_backend_info_type_id__once, feed_reader_backend_info_type_id);
	}
	return feed_reader_backend_info_type_id__once;
}

static void
_vala_SoupMessageHeaders_free (SoupMessageHeaders* self)
{
	g_boxed_free (soup_message_headers_get_type (), self);
}

gboolean
feed_reader_response_is_ok (FeedReaderResponse *self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if ((*self).status >= ((guint) 200)) {
		_tmp0_ = (*self).status < ((guint) 400);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static SoupMessageHeaders*
_vala_SoupMessageHeaders_copy (SoupMessageHeaders* self)
{
	return g_boxed_copy (soup_message_headers_get_type (), self);
}

static gpointer
__vala_SoupMessageHeaders_copy0 (gpointer self)
{
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}

void
feed_reader_response_copy (const FeedReaderResponse* self,
                           FeedReaderResponse* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	(*dest).status = (*self).status;
	_tmp0_ = (*self).data;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp1_;
	_tmp2_ = (*self).headers;
	_tmp3_ = __vala_SoupMessageHeaders_copy0 (_tmp2_);
	__vala_SoupMessageHeaders_free0 ((*dest).headers);
	(*dest).headers = _tmp3_;
}

void
feed_reader_response_destroy (FeedReaderResponse* self)
{
	_g_free0 ((*self).data);
	__vala_SoupMessageHeaders_free0 ((*self).headers);
}

FeedReaderResponse*
feed_reader_response_dup (const FeedReaderResponse* self)
{
	FeedReaderResponse* dup;
	dup = g_new0 (FeedReaderResponse, 1);
	feed_reader_response_copy (self, dup);
	return dup;
}

void
feed_reader_response_free (FeedReaderResponse* self)
{
	feed_reader_response_destroy (self);
	g_free (self);
}

static GType
feed_reader_response_get_type_once (void)
{
	GType feed_reader_response_type_id;
	feed_reader_response_type_id = g_boxed_type_register_static ("FeedReaderResponse", (GBoxedCopyFunc) feed_reader_response_dup, (GBoxedFreeFunc) feed_reader_response_free);
	return feed_reader_response_type_id;
}

GType
feed_reader_response_get_type (void)
{
	static volatile gsize feed_reader_response_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_response_type_id__once)) {
		GType feed_reader_response_type_id;
		feed_reader_response_type_id = feed_reader_response_get_type_once ();
		g_once_init_leave (&feed_reader_response_type_id__once, feed_reader_response_type_id);
	}
	return feed_reader_response_type_id__once;
}

void
feed_reader_resource_metadata_init (FeedReaderResourceMetadata *self)
{
	memset (self, 0, sizeof (FeedReaderResourceMetadata));
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
feed_reader_resource_metadata_init_from_data (FeedReaderResourceMetadata *self,
                                              const gchar* data)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (data != NULL);
	memset (self, 0, sizeof (FeedReaderResourceMetadata));
	{
		GKeyFile* config = NULL;
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint64* expires = NULL;
		gint64* _tmp15_;
		_tmp0_ = g_key_file_new ();
		config = _tmp0_;
		_tmp1_ = config;
		_tmp2_ = strlen (data);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_data (_tmp1_, data, (gsize) _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			gchar* _tmp4_ = NULL;
			GKeyFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = config;
			_tmp6_ = g_key_file_get_string (_tmp5_, FEED_READER_RESOURCE_METADATA_CACHE_GROUP, FEED_READER_RESOURCE_METADATA_ETAG_KEY, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (g_error_matches (_inner_error0_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
					goto __catch1_g_key_file_error_key_not_found;
				}
				if (g_error_matches (_inner_error0_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
					goto __catch1_g_key_file_error_group_not_found;
				}
				goto __finally1;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_free0 ((*self).etag);
			(*self).etag = _tmp7_;
			_g_free0 (_tmp4_);
		}
		goto __finally1;
		__catch1_g_key_file_error_key_not_found:
		{
			g_clear_error (&_inner_error0_);
		}
		goto __finally1;
		__catch1_g_key_file_error_group_not_found:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			gchar* _tmp8_ = NULL;
			GKeyFile* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = config;
			_tmp10_ = g_key_file_get_string (_tmp9_, FEED_READER_RESOURCE_METADATA_CACHE_GROUP, FEED_READER_RESOURCE_METADATA_LAST_MODIFIED_KEY, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (g_error_matches (_inner_error0_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
					goto __catch2_g_key_file_error_key_not_found;
				}
				if (g_error_matches (_inner_error0_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
					goto __catch2_g_key_file_error_group_not_found;
				}
				goto __finally2;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 ((*self).last_modified);
			(*self).last_modified = _tmp11_;
			_g_free0 (_tmp8_);
		}
		goto __finally2;
		__catch2_g_key_file_error_key_not_found:
		{
			g_clear_error (&_inner_error0_);
		}
		goto __finally2;
		__catch2_g_key_file_error_group_not_found:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		expires = NULL;
		{
			gint64 _tmp12_ = 0LL;
			GKeyFile* _tmp13_;
			gint64* _tmp14_;
			_tmp13_ = config;
			_tmp12_ = g_key_file_get_int64 (_tmp13_, FEED_READER_RESOURCE_METADATA_CACHE_GROUP, FEED_READER_RESOURCE_METADATA_EXPIRES_KEY, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (g_error_matches (_inner_error0_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
					goto __catch3_g_key_file_error_key_not_found;
				}
				if (g_error_matches (_inner_error0_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
					goto __catch3_g_key_file_error_group_not_found;
				}
				goto __finally3;
			}
			_tmp14_ = __int64_dup0 (&_tmp12_);
			_g_free0 (expires);
			expires = _tmp14_;
		}
		goto __finally3;
		__catch3_g_key_file_error_key_not_found:
		{
			g_clear_error (&_inner_error0_);
		}
		goto __finally3;
		__catch3_g_key_file_error_group_not_found:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (expires);
			_g_key_file_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp15_ = expires;
		if (_tmp15_ != NULL) {
			gint64* _tmp16_;
			GDateTime* _tmp17_;
			_tmp16_ = expires;
			_tmp17_ = g_date_time_new_from_unix_utc (*_tmp16_);
			_g_date_time_unref0 ((*self).expires);
			(*self).expires = _tmp17_;
		}
		_g_free0 (expires);
		_g_key_file_unref0 (config);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		g_clear_error (&_inner_error0_);
		_tmp18_ = string_to_string (data);
		_tmp19_ = g_strconcat ("FaviconMetadata.from_file: Failed to load from ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		feed_reader_logger_warning (_tmp20_);
		_g_free0 (_tmp20_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
feed_reader_resource_metadata_from_file_async_data_free (gpointer _data)
{
	FeedReaderResourceMetadataFromFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	feed_reader_resource_metadata_destroy (&_data_->result);
	g_slice_free (FeedReaderResourceMetadataFromFileAsyncData, _data_);
}

void
feed_reader_resource_metadata_from_file_async (const gchar* filename,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	FeedReaderResourceMetadataFromFileAsyncData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (FeedReaderResourceMetadataFromFileAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_resource_metadata_from_file_async_data_free);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp0_;
	feed_reader_resource_metadata_from_file_async_co (_data_);
}

void
feed_reader_resource_metadata_from_file_finish (GAsyncResult* _res_,
                                                FeedReaderResourceMetadata* result)
{
	FeedReaderResourceMetadataFromFileAsyncData* _data_;
	FeedReaderResourceMetadata _tmp0_;
	FeedReaderResourceMetadata _tmp1_ = {0};
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_tmp0_ = _data_->result;
	feed_reader_resource_metadata_copy (&_tmp0_, &_tmp1_);
	*result = _tmp1_;
}

static void
feed_reader_resource_metadata_from_file_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	FeedReaderResourceMetadataFromFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	feed_reader_resource_metadata_from_file_async_co (_data_);
}

static gboolean
feed_reader_resource_metadata_from_file_async_co (FeedReaderResourceMetadataFromFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_file_new_for_path (_data_->filename);
		_data_->file = _data_->_tmp0_;
		_data_->contents_length1 = 0;
		_data_->_contents_size_ = 0;
		_data_->_tmp1_ = _data_->file;
		_data_->_tmp2_ = NULL;
		_data_->_tmp3_ = 0;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp1_, NULL, feed_reader_resource_metadata_from_file_async_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp2_, &_data_->_tmp3_, NULL, &_data_->_inner_error0_);
		_data_->contents = (g_free (_data_->contents), NULL);
		_data_->contents = _data_->_tmp2_;
		_data_->contents_length1 = _data_->_tmp3_;
		_data_->_contents_size_ = _data_->contents_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->contents = (g_free (_data_->contents), NULL);
			_g_object_unref0 (_data_->file);
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->contents;
		_data_->_tmp4__length1 = _data_->contents_length1;
		memset (&_data_->_tmp5_, 0, sizeof (FeedReaderResourceMetadata));
		feed_reader_resource_metadata_init_from_data (&_data_->_tmp5_, (const gchar*) _data_->_tmp4_);
		_data_->result = _data_->_tmp5_;
		_data_->contents = (g_free (_data_->contents), NULL);
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->filename);
		_data_->_tmp7_ = g_strconcat ("FaviconMetadata.from_file: Failed to load ", _data_->_tmp6_, ": ", NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = g_strconcat (_data_->_tmp8_, _data_->_tmp10_, NULL);
		_data_->_tmp12_ = _data_->_tmp11_;
		feed_reader_logger_warning (_data_->_tmp12_);
		_g_free0 (_data_->_tmp12_);
		_g_free0 (_data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	memset (&_data_->_tmp13_, 0, sizeof (FeedReaderResourceMetadata));
	feed_reader_resource_metadata_init (&_data_->_tmp13_);
	_data_->result = _data_->_tmp13_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
feed_reader_resource_metadata_save_to_file_async_data_free (gpointer _data)
{
	FeedReaderResourceMetadataSaveToFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	feed_reader_resource_metadata_destroy (&_data_->self);
	g_slice_free (FeedReaderResourceMetadataSaveToFileAsyncData, _data_);
}

void
feed_reader_resource_metadata_save_to_file_async (FeedReaderResourceMetadata *self,
                                                  const gchar* filename,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FeedReaderResourceMetadataSaveToFileAsyncData* _data_;
	FeedReaderResourceMetadata _tmp0_;
	FeedReaderResourceMetadata _tmp1_ = {0};
	gchar* _tmp2_;
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (FeedReaderResourceMetadataSaveToFileAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_resource_metadata_save_to_file_async_data_free);
	_tmp0_ = *self;
	feed_reader_resource_metadata_copy (&_tmp0_, &_tmp1_);
	_data_->self = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	feed_reader_resource_metadata_save_to_file_async_co (_data_);
}

void
feed_reader_resource_metadata_save_to_file_finish (FeedReaderResourceMetadata *self,
                                                   GAsyncResult* _res_)
{
	FeedReaderResourceMetadataSaveToFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
feed_reader_resource_metadata_save_to_file_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	FeedReaderResourceMetadataSaveToFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	feed_reader_resource_metadata_save_to_file_async_co (_data_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
feed_reader_resource_metadata_save_to_file_async_co (FeedReaderResourceMetadataSaveToFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->filename);
	_data_->file = _data_->_tmp0_;
	_data_->_tmp3_ = _data_->self.etag;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = _data_->self.last_modified;
		_data_->_tmp2_ = _data_->_tmp4_ == NULL;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp5_ = _data_->self.expires;
		_data_->_tmp1_ = _data_->_tmp5_ == NULL;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		{
			_data_->_tmp6_ = _data_->file;
			_data_->_state_ = 1;
			g_file_delete_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, feed_reader_resource_metadata_save_to_file_async_ready, _data_);
			return FALSE;
			_state_1:
			g_file_delete_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
					goto __catch0_g_io_error_not_found;
				}
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_io_error_not_found:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = string_to_string (_data_->filename);
			_data_->_tmp8_ = g_strconcat ("FaviconMetadata.save_to_file: Error deleting metadata file ", _data_->_tmp7_, ": ", NULL);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			_data_->_tmp12_ = g_strconcat (_data_->_tmp9_, _data_->_tmp11_, NULL);
			_data_->_tmp13_ = _data_->_tmp12_;
			feed_reader_logger_warning (_data_->_tmp13_);
			_g_free0 (_data_->_tmp13_);
			_g_free0 (_data_->_tmp9_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp14_ = g_key_file_new ();
		_data_->config = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->self.etag;
		if (_data_->_tmp15_ != NULL) {
			_data_->_tmp16_ = _data_->config;
			_data_->_tmp17_ = _data_->self.etag;
			g_key_file_set_string (_data_->_tmp16_, FEED_READER_RESOURCE_METADATA_CACHE_GROUP, FEED_READER_RESOURCE_METADATA_ETAG_KEY, _data_->_tmp17_);
		}
		_data_->_tmp18_ = _data_->self.last_modified;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp19_ = _data_->config;
			_data_->_tmp20_ = _data_->self.last_modified;
			g_key_file_set_string (_data_->_tmp19_, FEED_READER_RESOURCE_METADATA_CACHE_GROUP, FEED_READER_RESOURCE_METADATA_LAST_MODIFIED_KEY, _data_->_tmp20_);
		}
		_data_->_tmp21_ = _data_->self.expires;
		if (_data_->_tmp21_ != NULL) {
			_data_->_tmp22_ = _data_->config;
			_data_->_tmp23_ = _data_->self.expires;
			g_key_file_set_int64 (_data_->_tmp22_, FEED_READER_RESOURCE_METADATA_CACHE_GROUP, FEED_READER_RESOURCE_METADATA_EXPIRES_KEY, g_date_time_to_unix (_data_->_tmp23_));
		}
		_data_->_tmp24_ = _data_->config;
		_data_->_tmp25_ = g_key_file_to_data (_data_->_tmp24_, NULL, NULL);
		_data_->data = _data_->_tmp25_;
		{
			{
				_data_->_tmp26_ = _data_->file;
				_data_->_tmp27_ = g_file_get_parent (_data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				g_file_make_directory_with_parents (_data_->_tmp28_, NULL, &_data_->_inner_error0_);
				_g_object_unref0 (_data_->_tmp28_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				g_clear_error (&_data_->_inner_error0_);
			}
			__finally2:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp29_ = _data_->file;
			_data_->_tmp30_ = _data_->data;
			_data_->_tmp32_ = 0;
			_data_->_tmp31_ = string_get_data (_data_->_tmp30_, &_data_->_tmp32_);
			_data_->_tmp31__length1 = _data_->_tmp32_;
			_data_->_tmp33_ = _data_->_tmp31_;
			_data_->_tmp33__length1 = _data_->_tmp31__length1;
			_data_->_state_ = 2;
			g_file_replace_contents_async (_data_->_tmp29_, _data_->_tmp33_, (gsize) _data_->_tmp33__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, feed_reader_resource_metadata_save_to_file_async_ready, _data_);
			return FALSE;
			_state_2:
			g_file_replace_contents_finish (_data_->_tmp29_, _data_->_res_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp34_ = string_to_string (_data_->filename);
			_data_->_tmp35_ = _data_->data;
			_data_->_tmp36_ = string_to_string (_data_->_tmp35_);
			_data_->_tmp37_ = g_strconcat ("FaviconMetadata.save_to_file: Failed to save metadata file ", _data_->_tmp34_, ",  ", _data_->_tmp36_, ":\n", NULL);
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = _data_->_vala1_e;
			_data_->_tmp40_ = _data_->_tmp39_->message;
			_data_->_tmp41_ = g_strconcat (_data_->_tmp38_, _data_->_tmp40_, NULL);
			_data_->_tmp42_ = _data_->_tmp41_;
			feed_reader_logger_warning (_data_->_tmp42_);
			_g_free0 (_data_->_tmp42_);
			_g_free0 (_data_->_tmp38_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->data);
			_g_key_file_unref0 (_data_->config);
			_g_object_unref0 (_data_->file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->data);
		_g_key_file_unref0 (_data_->config);
	}
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
feed_reader_resource_metadata_is_expired (FeedReaderResourceMetadata *self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	_tmp0_ = (*self).expires;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = (*self).expires;
	_tmp2_ = g_date_time_new_now_utc ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_compare (_tmp1_, _tmp3_) == 1;
	_g_date_time_unref0 (_tmp3_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
feed_reader_resource_metadata_copy (const FeedReaderResourceMetadata* self,
                                    FeedReaderResourceMetadata* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	_tmp0_ = (*self).etag;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).etag);
	(*dest).etag = _tmp1_;
	_tmp2_ = (*self).last_modified;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).last_modified);
	(*dest).last_modified = _tmp3_;
	_tmp4_ = (*self).expires;
	_tmp5_ = _g_date_time_ref0 (_tmp4_);
	_g_date_time_unref0 ((*dest).expires);
	(*dest).expires = _tmp5_;
}

void
feed_reader_resource_metadata_destroy (FeedReaderResourceMetadata* self)
{
	_g_free0 ((*self).etag);
	_g_free0 ((*self).last_modified);
	_g_date_time_unref0 ((*self).expires);
}

FeedReaderResourceMetadata*
feed_reader_resource_metadata_dup (const FeedReaderResourceMetadata* self)
{
	FeedReaderResourceMetadata* dup;
	dup = g_new0 (FeedReaderResourceMetadata, 1);
	feed_reader_resource_metadata_copy (self, dup);
	return dup;
}

void
feed_reader_resource_metadata_free (FeedReaderResourceMetadata* self)
{
	feed_reader_resource_metadata_destroy (self);
	g_free (self);
}

static GType
feed_reader_resource_metadata_get_type_once (void)
{
	GType feed_reader_resource_metadata_type_id;
	feed_reader_resource_metadata_type_id = g_boxed_type_register_static ("FeedReaderResourceMetadata", (GBoxedCopyFunc) feed_reader_resource_metadata_dup, (GBoxedFreeFunc) feed_reader_resource_metadata_free);
	return feed_reader_resource_metadata_type_id;
}

GType
feed_reader_resource_metadata_get_type (void)
{
	static volatile gsize feed_reader_resource_metadata_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_resource_metadata_type_id__once)) {
		GType feed_reader_resource_metadata_type_id;
		feed_reader_resource_metadata_type_id = feed_reader_resource_metadata_get_type_once ();
		g_once_init_leave (&feed_reader_resource_metadata_type_id__once, feed_reader_resource_metadata_type_id);
	}
	return feed_reader_resource_metadata_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

