/* Utils.c generated by valac 0.56.3, the Vala compiler
 * generated from Utils.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <libsoup/soup.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "htmlclean.h"
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gdk/gdk.h>

enum  {
	FEED_READER_UTILS_0_PROPERTY,
	FEED_READER_UTILS_NUM_PROPERTIES
};
static GParamSpec* feed_reader_utils_properties[FEED_READER_UTILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _FeedReaderUtilsFileExistsData FeedReaderUtilsFileExistsData;
typedef struct _FeedReaderUtilsEnsurePathData FeedReaderUtilsEnsurePathData;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _feed_reader_utils_inputStreamToArrayData feed_reader_utils_inputStreamToArrayData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block55Data Block55Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FeedReaderUtilsFileExistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* path_str;
	GFileType expected_type;
	gboolean result;
	GFile* path;
	GFile* _tmp0_;
	GFileInfo* info;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _FeedReaderUtilsEnsurePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* path_str;
	gboolean result;
	GFile* path;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* e;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_;
};

struct _feed_reader_utils_inputStreamToArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GInputStream* stream;
	GCancellable* cancellable;
	guint8* result;
	gint result_length1;
	GArray* _result_;
	GArray* _tmp0_;
	guint8* buffer;
	guint8* _tmp1_;
	gint buffer_length1;
	gint _buffer_size_;
	gsize bytesRead;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gsize _tmp3_;
	GArray* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GArray* _tmp6_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError* _inner_error0_;
};

struct _Block55Data {
	int _ref_count_;
	GFile* file;
	GtkFileChooserDialog* save_dialog;
};

static gpointer feed_reader_utils_parent_class = NULL;
static SoupSession* feed_reader_utils_m_session;
static SoupSession* feed_reader_utils_m_session = NULL;

static void _vala_SoupURI_free (SoupURI* self);
static void feed_reader_utils_file_exists_data_free (gpointer _data);
static gboolean feed_reader_utils_file_exists_co (FeedReaderUtilsFileExistsData* _data_);
static void feed_reader_utils_file_exists_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void feed_reader_utils_ensure_path_data_free (gpointer _data);
static gboolean feed_reader_utils_ensure_path_co (FeedReaderUtilsEnsurePathData* _data_);
static void feed_reader_utils_ensure_path_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void feed_reader_utils_inputStreamToArray_data_free (gpointer _data);
static gboolean feed_reader_utils_inputStreamToArray_co (feed_reader_utils_inputStreamToArrayData* _data_);
static void feed_reader_utils_inputStreamToArray_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static guint8* _vala_array_dup5 (guint8* self,
                          gssize length);
static guint* _uint_dup (guint* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void ___lambda359_ (Block55Data* _data55_,
                    GtkDialog* dialog,
                    gint response_id);
static void ____lambda359__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender,
                                        gpointer self);
static void feed_reader_utils_finalize (GObject * obj);
static GType feed_reader_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SoupSession*
feed_reader_utils_getSession (void)
{
	SoupSession* _tmp0_;
	SoupSession* _tmp5_;
	SoupSession* _tmp6_;
	SoupSession* result;
	_tmp0_ = feed_reader_utils_m_session;
	if (_tmp0_ == NULL) {
		SoupSession* _tmp1_;
		SoupSession* _tmp2_;
		SoupSession* _tmp3_;
		SoupSession* _tmp4_;
		_tmp1_ = soup_session_new ();
		_g_object_unref0 (feed_reader_utils_m_session);
		feed_reader_utils_m_session = _tmp1_;
		_tmp2_ = feed_reader_utils_m_session;
		g_object_set (_tmp2_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
		_tmp3_ = feed_reader_utils_m_session;
		g_object_set (_tmp3_, "ssl-strict", FALSE, NULL);
		_tmp4_ = feed_reader_utils_m_session;
		g_object_set (_tmp4_, "timeout", (guint) 5, NULL);
	}
	_tmp5_ = feed_reader_utils_m_session;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
feed_reader_utils_generatePreviews (GeeList* articles)
{
	gchar* noPreview = NULL;
	gchar* _tmp0_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp1_;
	g_return_if_fail (articles != NULL);
	_tmp0_ = g_strdup (_ ("No Preview Available"));
	noPreview = _tmp0_;
	_tmp1_ = feed_reader_data_base_readOnly ();
	db = _tmp1_;
	{
		GeeList* _Article_list = NULL;
		gint _Article_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _Article_index = 0;
		_Article_list = articles;
		_tmp2_ = _Article_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_Article_size = _tmp4_;
		_Article_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			FeedReaderArticle* Article = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			FeedReaderDataBaseReadOnly* _tmp9_;
			FeedReaderArticle* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_Article_index = _Article_index + 1;
			_tmp5_ = _Article_index;
			_tmp6_ = _Article_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _Article_list;
			_tmp8_ = gee_list_get (_tmp7_, _Article_index);
			Article = (FeedReaderArticle*) _tmp8_;
			_tmp9_ = db;
			_tmp10_ = Article;
			_tmp11_ = feed_reader_article_getArticleID (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = !feed_reader_data_base_read_only_article_exists (_tmp9_, _tmp12_);
			_g_free0 (_tmp12_);
			if (_tmp13_) {
				gboolean _tmp14_ = FALSE;
				FeedReaderArticle* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_;
				FeedReaderDataBaseReadOnly* _tmp22_;
				FeedReaderArticle* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gboolean _tmp26_;
				FeedReaderArticle* _tmp76_;
				FeedReaderArticle* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp15_ = Article;
				_tmp16_ = feed_reader_article_getPreview (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_ != NULL;
				_g_free0 (_tmp17_);
				if (_tmp18_) {
					FeedReaderArticle* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp19_ = Article;
					_tmp20_ = feed_reader_article_getPreview (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp14_ = g_strcmp0 (_tmp21_, "") != 0;
					_g_free0 (_tmp21_);
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					_g_object_unref0 (Article);
					continue;
				}
				_tmp22_ = db;
				_tmp23_ = Article;
				_tmp24_ = feed_reader_article_getArticleID (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = !feed_reader_data_base_read_only_preview_empty (_tmp22_, _tmp25_);
				_g_free0 (_tmp25_);
				if (_tmp26_) {
					_g_object_unref0 (Article);
					continue;
				} else {
					gboolean _tmp27_ = FALSE;
					FeedReaderArticle* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gboolean _tmp31_;
					_tmp28_ = Article;
					_tmp29_ = feed_reader_article_getHTML (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strcmp0 (_tmp30_, "") != 0;
					_g_free0 (_tmp30_);
					if (_tmp31_) {
						FeedReaderArticle* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp32_ = Article;
						_tmp33_ = feed_reader_article_getHTML (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp27_ = _tmp34_ != NULL;
						_g_free0 (_tmp34_);
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						FeedReaderArticle* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* output = NULL;
						FeedReaderArticle* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						gboolean _tmp48_ = FALSE;
						const gchar* _tmp49_;
						gchar* xml = NULL;
						gchar* _tmp53_;
						const gchar* _tmp66_;
						gchar* _tmp67_;
						const gchar* _tmp68_;
						gchar* _tmp69_;
						FeedReaderArticle* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						_tmp35_ = Article;
						_tmp36_ = feed_reader_article_getArticleID (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat ("Utils: generate preview for article: ", _tmp37_, NULL);
						_tmp39_ = _tmp38_;
						feed_reader_logger_debug (_tmp39_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp37_);
						_tmp40_ = Article;
						_tmp41_ = feed_reader_article_getHTML (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = feed_reader_utils_UTF8fix (_tmp42_, TRUE);
						_tmp44_ = _tmp43_;
						_g_free0 (_tmp42_);
						output = _tmp44_;
						_tmp45_ = output;
						if (_tmp45_ != NULL) {
							const gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp46_ = output;
							_tmp47_ = string_strip (_tmp46_);
							_g_free0 (output);
							output = _tmp47_;
						}
						_tmp49_ = output;
						if (g_strcmp0 (_tmp49_, "") == 0) {
							_tmp48_ = TRUE;
						} else {
							const gchar* _tmp50_;
							_tmp50_ = output;
							_tmp48_ = _tmp50_ == NULL;
						}
						if (_tmp48_) {
							FeedReaderArticle* _tmp51_;
							const gchar* _tmp52_;
							feed_reader_logger_info ("generatePreviews: no Preview");
							_tmp51_ = Article;
							_tmp52_ = noPreview;
							feed_reader_article_setPreview (_tmp51_, _tmp52_);
							_g_free0 (output);
							_g_object_unref0 (Article);
							continue;
						}
						_tmp53_ = g_strdup ("<?xml");
						xml = _tmp53_;
						while (TRUE) {
							const gchar* _tmp54_;
							const gchar* _tmp55_;
							gint end = 0;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							const gchar* _tmp58_;
							gint _tmp59_;
							gint _tmp60_;
							gchar* _tmp61_;
							gchar* _tmp62_;
							gchar* _tmp63_;
							const gchar* _tmp64_;
							gchar* _tmp65_;
							_tmp54_ = output;
							_tmp55_ = xml;
							if (!g_str_has_prefix (_tmp54_, _tmp55_)) {
								break;
							}
							_tmp56_ = output;
							end = string_index_of_char (_tmp56_, (gunichar) '>', 0);
							_tmp57_ = output;
							_tmp58_ = output;
							_tmp59_ = strlen (_tmp58_);
							_tmp60_ = _tmp59_;
							_tmp61_ = string_slice (_tmp57_, (glong) (end + 1), (glong) _tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = string_chug (_tmp62_);
							_g_free0 (output);
							output = _tmp63_;
							_g_free0 (_tmp62_);
							_tmp64_ = output;
							_tmp65_ = string_strip (_tmp64_);
							_g_free0 (output);
							output = _tmp65_;
						}
						_tmp66_ = output;
						_tmp67_ = string_replace (_tmp66_, "\n", " ");
						_g_free0 (output);
						output = _tmp67_;
						_tmp68_ = output;
						_tmp69_ = string_replace (_tmp68_, "_", " ");
						_g_free0 (output);
						output = _tmp69_;
						_tmp70_ = Article;
						_tmp71_ = output;
						_tmp72_ = string_chug (_tmp71_);
						_tmp73_ = _tmp72_;
						feed_reader_article_setPreview (_tmp70_, _tmp73_);
						_g_free0 (_tmp73_);
						_g_free0 (xml);
						_g_free0 (output);
					} else {
						FeedReaderArticle* _tmp74_;
						const gchar* _tmp75_;
						feed_reader_logger_debug ("no html to create preview from");
						_tmp74_ = Article;
						_tmp75_ = noPreview;
						feed_reader_article_setPreview (_tmp74_, _tmp75_);
					}
				}
				_tmp76_ = Article;
				_tmp77_ = Article;
				_tmp78_ = feed_reader_article_getTitle (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = feed_reader_utils_UTF8fix (_tmp79_, TRUE);
				_tmp81_ = _tmp80_;
				feed_reader_article_setTitle (_tmp76_, _tmp81_);
				_g_free0 (_tmp81_);
				_g_free0 (_tmp79_);
			}
			_g_object_unref0 (Article);
		}
	}
	_g_object_unref0 (db);
	_g_free0 (noPreview);
}

void
feed_reader_utils_checkHTML (GeeList* articles)
{
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	g_return_if_fail (articles != NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	db = _tmp0_;
	{
		GeeList* _Article_list = NULL;
		gint _Article_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _Article_index = 0;
		_Article_list = articles;
		_tmp1_ = _Article_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_Article_size = _tmp3_;
		_Article_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderArticle* Article = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			FeedReaderDataBaseReadOnly* _tmp8_;
			FeedReaderArticle* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			_Article_index = _Article_index + 1;
			_tmp4_ = _Article_index;
			_tmp5_ = _Article_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _Article_list;
			_tmp7_ = gee_list_get (_tmp6_, _Article_index);
			Article = (FeedReaderArticle*) _tmp7_;
			_tmp8_ = db;
			_tmp9_ = Article;
			_tmp10_ = feed_reader_article_getArticleID (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = !feed_reader_data_base_read_only_article_exists (_tmp8_, _tmp11_);
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				gchar* modified_html = NULL;
				gchar* _tmp13_;
				FeedReaderArticle* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gboolean _tmp17_;
				FeedReaderArticle* _tmp22_;
				const gchar* _tmp23_;
				_tmp13_ = g_strdup (_ ("No Text available for this article :("));
				modified_html = _tmp13_;
				_tmp14_ = Article;
				_tmp15_ = feed_reader_article_getHTML (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strcmp0 (_tmp16_, "") != 0;
				_g_free0 (_tmp16_);
				if (_tmp17_) {
					FeedReaderArticle* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp18_ = Article;
					_tmp19_ = feed_reader_article_getHTML (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = string_replace (_tmp20_, "src=\"//", "src=\"http://");
					_g_free0 (modified_html);
					modified_html = _tmp21_;
					_g_free0 (_tmp20_);
				}
				_tmp22_ = Article;
				_tmp23_ = modified_html;
				feed_reader_article_setHTML (_tmp22_, _tmp23_);
				_g_free0 (modified_html);
			}
			_g_object_unref0 (Article);
		}
	}
	_g_object_unref0 (db);
}

gchar*
feed_reader_utils_UTF8fix (const gchar* old_string,
                           gboolean remove_html)
{
	gchar* output = NULL;
	gchar* _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	if (old_string == NULL) {
		gchar* _tmp0_;
		feed_reader_logger_warning ("Utils.UTF8fix: string is NULL");
		_tmp0_ = g_strdup ("NULL");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strdup (old_string);
	output = _tmp1_;
	if (remove_html) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = output;
		_tmp3_ = htmlclean_strip_html (_tmp2_);
		_g_free0 (output);
		output = _tmp3_;
	}
	_tmp4_ = output;
	_tmp5_ = g_utf8_make_valid (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_replace (_tmp6_, "\n", " ");
	_tmp8_ = _tmp7_;
	_tmp9_ = string_strip (_tmp8_);
	_g_free0 (output);
	output = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	result = output;
	return result;
}

gchar**
feed_reader_utils_getDefaultExpandedCategories (gint* result_length1)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	_tmp0_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
	_tmp1_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

gboolean
feed_reader_utils_springCleaningNecessary (void)
{
	GDateTime* lastClean = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* now = NULL;
	GDateTime* _tmp4_;
	GTimeSpan difference = 0LL;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gboolean doCleaning = FALSE;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GDateTime* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	gboolean _tmp21_;
	gboolean result;
	_tmp0_ = feed_reader_settings_state ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_from_unix_local ((gint64) g_settings_get_int (_tmp1_, "last-spring-cleaning"));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	lastClean = _tmp3_;
	_tmp4_ = g_date_time_new_now_local ();
	now = _tmp4_;
	_tmp5_ = now;
	_tmp6_ = lastClean;
	difference = g_date_time_difference (_tmp5_, _tmp6_);
	doCleaning = FALSE;
	_tmp7_ = lastClean;
	_tmp8_ = g_date_time_format (_tmp7_, "%Y-%m-%d %H:%M:%S");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("last clean: %s", _tmp9_);
	_tmp11_ = _tmp10_;
	feed_reader_logger_debug (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = now;
	_tmp13_ = g_date_time_format (_tmp12_, "%Y-%m-%d %H:%M:%S");
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("now: %s", _tmp14_);
	_tmp16_ = _tmp15_;
	feed_reader_logger_debug (_tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = g_strdup_printf ("difference: %f", (gdouble) (difference / G_TIME_SPAN_DAY));
	_tmp18_ = _tmp17_;
	feed_reader_logger_debug (_tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = feed_reader_settings_general ();
	_tmp20_ = _tmp19_;
	_tmp21_ = (difference / G_TIME_SPAN_DAY) >= ((GTimeSpan) g_settings_get_int (_tmp20_, "spring-clean-after"));
	_g_object_unref0 (_tmp20_);
	if (_tmp21_) {
		doCleaning = TRUE;
	}
	result = doCleaning;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (lastClean);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

gchar*
feed_reader_utils_string_random (gint length,
                                 const gchar* charset)
{
	gchar* random = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (charset != NULL, NULL);
	_tmp0_ = g_strdup ("");
	random = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint random_index = 0;
				gint _tmp3_;
				gint _tmp4_;
				gchar* ch = NULL;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = strlen (charset);
				_tmp4_ = _tmp3_;
				random_index = (gint) g_random_int_range ((gint32) 0, (gint32) _tmp4_);
				_tmp5_ = g_unichar_to_string (string_get_char (charset, (glong) string_index_of_nth_char (charset, (glong) random_index)));
				ch = _tmp5_;
				_tmp6_ = random;
				_tmp7_ = ch;
				_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
				_g_free0 (random);
				random = _tmp8_;
				_g_free0 (ch);
			}
		}
	}
	result = random;
	return result;
}

gboolean
feed_reader_utils_arrayContains (gchar** array,
                                 gint array_length1,
                                 const gchar* key)
{
	gboolean result;
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = array;
		s_collection_length1 = array_length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp0_;
			gchar* s = NULL;
			_tmp0_ = g_strdup (s_collection[s_it]);
			s = _tmp0_;
			{
				const gchar* _tmp1_;
				_tmp1_ = s;
				if (g_strcmp0 (_tmp1_, key) == 0) {
					result = TRUE;
					_g_free0 (s);
					return result;
				}
				_g_free0 (s);
			}
		}
	}
	result = FALSE;
	return result;
}

void
feed_reader_utils_copyAutostart (void)
{
	gchar* desktop = NULL;
	gchar* _tmp0_;
	gchar* filename = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	gboolean _tmp10_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_strdup ("org.gnome.FeedReader-autostart.desktop");
	desktop = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_strconcat (_tmp1_, "/", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = desktop;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	filename = _tmp6_;
	_tmp8_ = feed_reader_settings_tweaks ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "feedreader-autostart");
	_g_object_unref0 (_tmp9_);
	if (_tmp10_) {
		const gchar* _tmp11_;
		_tmp11_ = filename;
		_tmp7_ = !g_file_test (_tmp11_, G_FILE_TEST_EXISTS);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		{
			GFile* origin = NULL;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* destination = NULL;
			const gchar* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			_tmp12_ = desktop;
			_tmp13_ = g_strconcat (FEED_READER_CONSTANTS_INSTALL_PREFIX "/share/FeedReader/", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_file_new_for_path (_tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			origin = _tmp16_;
			_tmp17_ = filename;
			_tmp18_ = g_file_new_for_path (_tmp17_);
			destination = _tmp18_;
			_tmp19_ = origin;
			_tmp20_ = destination;
			g_file_copy (_tmp19_, _tmp20_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (destination);
				_g_object_unref0 (origin);
				goto __catch0_g_error;
			}
			_g_object_unref0 (destination);
			_g_object_unref0 (origin);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			_tmp23_ = g_strdup_printf ("Utils.copyAutostart: %s", _tmp22_);
			_tmp24_ = _tmp23_;
			feed_reader_logger_error (_tmp24_);
			_g_free0 (_tmp24_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			_g_free0 (desktop);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (filename);
	_g_free0 (desktop);
}

gchar*
feed_reader_utils_printTlsCertificateFlags (GTlsCertificateFlags flag)
{
	gchar* errors = NULL;
	gchar* _tmp0_;
	gint flags = 0;
	gchar* result;
	_tmp0_ = g_strdup ("");
	errors = _tmp0_;
	flags = (gint) flag;
	if ((flags - G_TLS_CERTIFICATE_GENERIC_ERROR) >= 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = errors;
		_tmp2_ = g_strconcat (_tmp1_, "GENERIC_ERROR ", NULL);
		_g_free0 (errors);
		errors = _tmp2_;
		flags -= (gint) G_TLS_CERTIFICATE_VALIDATE_ALL;
	}
	if ((flags - G_TLS_CERTIFICATE_INSECURE) >= 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = errors;
		_tmp4_ = g_strconcat (_tmp3_, "INSECURE ", NULL);
		_g_free0 (errors);
		errors = _tmp4_;
		flags -= (gint) G_TLS_CERTIFICATE_INSECURE;
	}
	if ((flags - G_TLS_CERTIFICATE_REVOKED) >= 0) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = errors;
		_tmp6_ = g_strconcat (_tmp5_, "REVOKED ", NULL);
		_g_free0 (errors);
		errors = _tmp6_;
		flags -= (gint) G_TLS_CERTIFICATE_REVOKED;
	}
	if ((flags - G_TLS_CERTIFICATE_EXPIRED) >= 0) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = errors;
		_tmp8_ = g_strconcat (_tmp7_, "EXPIRED ", NULL);
		_g_free0 (errors);
		errors = _tmp8_;
		flags -= (gint) G_TLS_CERTIFICATE_EXPIRED;
	}
	if ((flags - G_TLS_CERTIFICATE_NOT_ACTIVATED) >= 0) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = errors;
		_tmp10_ = g_strconcat (_tmp9_, "NOT_ACTIVATED ", NULL);
		_g_free0 (errors);
		errors = _tmp10_;
		flags -= (gint) G_TLS_CERTIFICATE_NOT_ACTIVATED;
	}
	if ((flags - G_TLS_CERTIFICATE_BAD_IDENTITY) >= 0) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = errors;
		_tmp12_ = g_strconcat (_tmp11_, "BAD_IDENTITY ", NULL);
		_g_free0 (errors);
		errors = _tmp12_;
		flags -= (gint) G_TLS_CERTIFICATE_BAD_IDENTITY;
	}
	if ((flags - G_TLS_CERTIFICATE_UNKNOWN_CA) >= 0) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = errors;
		_tmp14_ = g_strconcat (_tmp13_, "UNKNOWN_CA ", NULL);
		_g_free0 (errors);
		errors = _tmp14_;
		flags -= (gint) G_TLS_CERTIFICATE_UNKNOWN_CA;
	}
	result = errors;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_SoupURI_free (SoupURI* self)
{
	g_boxed_free (soup_uri_get_type (), self);
}

gboolean
feed_reader_utils_ping (const gchar* link)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SoupURI* uri = NULL;
	SoupURI* _tmp2_;
	SoupURI* _tmp3_;
	SoupMessage* message = NULL;
	SoupURI* _tmp7_;
	SoupMessage* _tmp8_;
	SoupMessage* _tmp9_;
	guint status = 0U;
	SoupSession* _tmp13_;
	SoupSession* _tmp14_;
	SoupMessage* _tmp15_;
	guint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gboolean result;
	g_return_val_if_fail (link != NULL, FALSE);
	_tmp0_ = g_strconcat ("Ping: ", link, NULL);
	_tmp1_ = _tmp0_;
	feed_reader_logger_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = soup_uri_new (link);
	uri = _tmp2_;
	_tmp3_ = uri;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = string_to_string (link);
		_tmp5_ = g_strconcat ("Ping failed: can't parse url ", _tmp4_, "! Seems to be not valid.", NULL);
		_tmp6_ = _tmp5_;
		feed_reader_logger_error (_tmp6_);
		_g_free0 (_tmp6_);
		result = FALSE;
		__vala_SoupURI_free0 (uri);
		return result;
	}
	_tmp7_ = uri;
	_tmp8_ = soup_message_new_from_uri ("HEAD", _tmp7_);
	message = _tmp8_;
	_tmp9_ = message;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = string_to_string (link);
		_tmp11_ = g_strconcat ("Ping failed: can't send message to ", _tmp10_, "! Seems to be not valid.", NULL);
		_tmp12_ = _tmp11_;
		feed_reader_logger_error (_tmp12_);
		_g_free0 (_tmp12_);
		result = FALSE;
		_g_object_unref0 (message);
		__vala_SoupURI_free0 (uri);
		return result;
	}
	_tmp13_ = feed_reader_utils_getSession ();
	_tmp14_ = _tmp13_;
	_tmp15_ = message;
	_tmp16_ = soup_session_send_message (_tmp14_, _tmp15_);
	_g_object_unref0 (_tmp14_);
	status = _tmp16_;
	_tmp17_ = g_strdup_printf ("%u", status);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("Ping: status ", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	feed_reader_logger_debug (_tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	if (status >= ((guint) 200)) {
		_tmp21_ = status <= ((guint) 208);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		feed_reader_logger_debug ("Ping successful");
		result = TRUE;
		_g_object_unref0 (message);
		__vala_SoupURI_free0 (uri);
		return result;
	}
	_tmp22_ = soup_status_get_phrase (status);
	_tmp23_ = g_strdup_printf ("Ping: failed %u - %s", status, _tmp22_);
	_tmp24_ = _tmp23_;
	feed_reader_logger_error (_tmp24_);
	_g_free0 (_tmp24_);
	result = FALSE;
	_g_object_unref0 (message);
	__vala_SoupURI_free0 (uri);
	return result;
}

gboolean
feed_reader_utils_remove_directory (const gchar* path,
                                    guint level)
{
	guint _tmp0_;
	gboolean flag = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	level = level + 1;
	_tmp0_ = level;
	flag = FALSE;
	{
		GFile* directory = NULL;
		GFile* _tmp1_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileInfo* file_info = NULL;
		_tmp1_ = g_file_new_for_path (path);
		directory = _tmp1_;
		_tmp2_ = directory;
		_tmp3_ = g_file_enumerate_children (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (directory);
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			gchar* file_name = NULL;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			GFileInfo* _tmp12_;
			GFile* file = NULL;
			GFile* _tmp18_;
			const gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
					goto __catch0_g_io_error_not_found;
				}
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp7_;
			_tmp8_ = file_info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = file_info;
			_tmp10_ = g_file_info_get_name (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			file_name = _tmp11_;
			_tmp12_ = file_info;
			if (g_file_info_get_file_type (_tmp12_) == G_FILE_TYPE_DIRECTORY) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp13_ = file_name;
				_tmp14_ = g_strconcat (path, _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp15_, "/", NULL);
				_tmp17_ = _tmp16_;
				feed_reader_utils_remove_directory (_tmp17_, level);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
			}
			_tmp18_ = directory;
			_tmp19_ = file_name;
			_tmp20_ = g_file_get_child (_tmp18_, _tmp19_);
			file = _tmp20_;
			_tmp21_ = file;
			g_file_delete (_tmp21_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (file_name);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
					goto __catch0_g_io_error_not_found;
				}
				goto __catch0_g_error;
			}
			_g_object_unref0 (file);
			_g_free0 (file_name);
			_g_object_unref0 (_tmp4_);
		}
		if (level == ((guint) 1)) {
			GFile* _tmp22_;
			_tmp22_ = directory;
			g_file_delete (_tmp22_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
					goto __catch0_g_io_error_not_found;
				}
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = g_strconcat ("Utils - remove_directory: ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		feed_reader_logger_error (_tmp26_);
		_g_free0 (_tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp27_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp27_;
	}
	result = flag;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
feed_reader_utils_shortenURL (const gchar* url)
{
	gchar* longURL = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	const gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_strdup (url);
	longURL = _tmp0_;
	_tmp1_ = longURL;
	if (g_str_has_prefix (_tmp1_, "https://")) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = longURL;
		_tmp3_ = string_substring (_tmp2_, (glong) 8, (glong) -1);
		_g_free0 (longURL);
		longURL = _tmp3_;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = longURL;
		if (g_str_has_prefix (_tmp4_, "http://")) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = longURL;
			_tmp6_ = string_substring (_tmp5_, (glong) 7, (glong) -1);
			_g_free0 (longURL);
			longURL = _tmp6_;
		}
	}
	_tmp7_ = longURL;
	if (g_str_has_prefix (_tmp7_, "www.")) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = longURL;
		_tmp9_ = string_substring (_tmp8_, (glong) 4, (glong) -1);
		_g_free0 (longURL);
		longURL = _tmp9_;
	}
	_tmp10_ = longURL;
	if (g_str_has_suffix (_tmp10_, "api/")) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = longURL;
		_tmp12_ = longURL;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_substring (_tmp11_, (glong) 0, (glong) (_tmp14_ - 4));
		_g_free0 (longURL);
		longURL = _tmp15_;
	}
	result = longURL;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

gchar*
feed_reader_utils_prepareSearchQuery (const gchar* raw_query)
{
	gchar* quote_balanced = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** words = NULL;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint words_length1;
	gint _words_size_;
	gboolean in_quote = FALSE;
	GString* prepared_query = NULL;
	GString* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GString* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* result;
	g_return_val_if_fail (raw_query != NULL, NULL);
	_tmp0_ = feed_reader_utils_parseSearchTerm (raw_query);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "'", " ");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	quote_balanced = _tmp3_;
	if ((feed_reader_utils_countChar (raw_query, (gunichar) '"') % 2) != 0) {
		gint last_quote = 0;
		gchar* _tmp4_;
		last_quote = string_last_index_of_char (raw_query, (gunichar) '"', 0);
		_vala_assert (last_quote >= 0, "last_quote >= 0");
		_tmp4_ = string_splice (raw_query, (glong) last_quote, (glong) (last_quote + 1), " ");
		_g_free0 (quote_balanced);
		quote_balanced = _tmp4_;
	}
	_tmp5_ = quote_balanced;
	_tmp7_ = _tmp6_ = g_strsplit_set (_tmp5_, " \t\r\n:()%*\\", 0);
	words = _tmp7_;
	words_length1 = _vala_array_length (_tmp6_);
	_words_size_ = words_length1;
	in_quote = FALSE;
	_tmp8_ = g_string_new ("");
	prepared_query = _tmp8_;
	_tmp9_ = words;
	_tmp9__length1 = words_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp9_;
		s_collection_length1 = _tmp9__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp10_;
			gchar* s = NULL;
			_tmp10_ = g_strdup (s_collection[s_it]);
			s = _tmp10_;
			{
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gint quotes = 0;
				const gchar* _tmp13_;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp37_ = FALSE;
				GString* _tmp38_;
				const gchar* _tmp39_;
				GString* _tmp40_;
				_tmp11_ = s;
				_tmp12_ = string_strip (_tmp11_);
				_g_free0 (s);
				s = _tmp12_;
				_tmp13_ = s;
				quotes = feed_reader_utils_countChar (_tmp13_, (gunichar) '"');
				if (!in_quote) {
					_tmp14_ = quotes > 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gint _tmp15_;
					in_quote = TRUE;
					quotes = quotes - 1;
					_tmp15_ = quotes;
				}
				if (!in_quote) {
					gchar* lower = NULL;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					const gchar* _tmp23_;
					const gchar* _tmp29_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp16_ = s;
					_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
					lower = _tmp17_;
					_tmp23_ = lower;
					if (g_strcmp0 (_tmp23_, "") == 0) {
						_tmp22_ = TRUE;
					} else {
						const gchar* _tmp24_;
						_tmp24_ = lower;
						_tmp22_ = g_strcmp0 (_tmp24_, "and") == 0;
					}
					if (_tmp22_) {
						_tmp21_ = TRUE;
					} else {
						const gchar* _tmp25_;
						_tmp25_ = lower;
						_tmp21_ = g_strcmp0 (_tmp25_, "or") == 0;
					}
					if (_tmp21_) {
						_tmp20_ = TRUE;
					} else {
						const gchar* _tmp26_;
						_tmp26_ = lower;
						_tmp20_ = g_strcmp0 (_tmp26_, "not") == 0;
					}
					if (_tmp20_) {
						_tmp19_ = TRUE;
					} else {
						const gchar* _tmp27_;
						_tmp27_ = lower;
						_tmp19_ = g_strcmp0 (_tmp27_, "near") == 0;
					}
					if (_tmp19_) {
						_tmp18_ = TRUE;
					} else {
						const gchar* _tmp28_;
						_tmp28_ = lower;
						_tmp18_ = g_str_has_prefix (_tmp28_, "near/");
					}
					if (_tmp18_) {
						_g_free0 (lower);
						_g_free0 (s);
						continue;
					}
					_tmp29_ = s;
					if (g_str_has_prefix (_tmp29_, "-")) {
						const gchar* _tmp30_;
						gchar* _tmp31_;
						_tmp30_ = s;
						_tmp31_ = string_substring (_tmp30_, (glong) 1, (glong) -1);
						_g_free0 (s);
						s = _tmp31_;
					}
					_tmp32_ = s;
					if (g_strcmp0 (_tmp32_, "") == 0) {
						_g_free0 (lower);
						_g_free0 (s);
						continue;
					}
					_tmp33_ = s;
					_tmp34_ = g_strconcat ("\"", _tmp33_, NULL);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strconcat (_tmp35_, "*\"", NULL);
					_g_free0 (s);
					s = _tmp36_;
					_g_free0 (_tmp35_);
					_g_free0 (lower);
				}
				if (in_quote) {
					_tmp37_ = (quotes % 2) != 0;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					in_quote = FALSE;
				}
				_tmp38_ = prepared_query;
				_tmp39_ = s;
				g_string_append (_tmp38_, _tmp39_);
				_tmp40_ = prepared_query;
				g_string_append (_tmp40_, " ");
				_g_free0 (s);
			}
		}
	}
	_vala_assert (!in_quote, "!in_quote");
	_tmp41_ = prepared_query;
	_tmp42_ = _tmp41_->str;
	_tmp43_ = string_strip (_tmp42_);
	result = _tmp43_;
	_g_string_free0 (prepared_query);
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (quote_balanced);
	return result;
}

gint
feed_reader_utils_countChar (const gchar* s,
                             gunichar c)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (s != NULL, 0);
	count = 0;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					gint _tmp2_;
					index = index + 1;
					_tmp1_ = index;
					count = count + 1;
					_tmp2_ = count;
				}
				_tmp0_ = FALSE;
				index = string_index_of_char (s, c, index);
				if (!(index >= 0)) {
					break;
				}
			}
		}
	}
	result = count;
	return result;
}

gchar*
feed_reader_utils_parseSearchTerm (const gchar* searchTerm)
{
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (searchTerm != NULL, NULL);
	if (g_str_has_prefix (searchTerm, "title: ")) {
		gchar* _tmp0_;
		_tmp0_ = string_substring (searchTerm, (glong) 7, (glong) -1);
		result = _tmp0_;
		return result;
	}
	if (g_str_has_prefix (searchTerm, "author: ")) {
		gchar* _tmp1_;
		_tmp1_ = string_substring (searchTerm, (glong) 8, (glong) -1);
		result = _tmp1_;
		return result;
	}
	if (g_str_has_prefix (searchTerm, "content: ")) {
		gchar* _tmp2_;
		_tmp2_ = string_substring (searchTerm, (glong) 9, (glong) -1);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup (searchTerm);
	result = _tmp3_;
	return result;
}

gboolean
feed_reader_utils_categoryIsPopulated (const gchar* catID,
                                       GeeList* feeds)
{
	gboolean result;
	g_return_val_if_fail (catID != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	{
		GeeList* _feed_list = NULL;
		gint _feed_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _feed_index = 0;
		_feed_list = feeds;
		_tmp0_ = _feed_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_feed_size = _tmp2_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			GeeList* ids = NULL;
			FeedReaderFeed* _tmp7_;
			GeeList* _tmp8_;
			_feed_index = _feed_index + 1;
			_tmp3_ = _feed_index;
			_tmp4_ = _feed_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _feed_list;
			_tmp6_ = gee_list_get (_tmp5_, _feed_index);
			feed = (FeedReaderFeed*) _tmp6_;
			_tmp7_ = feed;
			_tmp8_ = feed_reader_feed_getCatIDs (_tmp7_);
			ids = _tmp8_;
			{
				GeeList* _id_list = NULL;
				GeeList* _tmp9_;
				gint _id_size = 0;
				GeeList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _id_index = 0;
				_tmp9_ = ids;
				_id_list = _tmp9_;
				_tmp10_ = _id_list;
				_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_id_size = _tmp12_;
				_id_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gchar* id = NULL;
					GeeList* _tmp15_;
					gpointer _tmp16_;
					const gchar* _tmp17_;
					_id_index = _id_index + 1;
					_tmp13_ = _id_index;
					_tmp14_ = _id_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _id_list;
					_tmp16_ = gee_list_get (_tmp15_, _id_index);
					id = (gchar*) _tmp16_;
					_tmp17_ = id;
					if (g_strcmp0 (_tmp17_, catID) == 0) {
						result = TRUE;
						_g_free0 (id);
						_g_object_unref0 (ids);
						_g_object_unref0 (feed);
						return result;
					}
					_g_free0 (id);
				}
			}
			_g_object_unref0 (ids);
			_g_object_unref0 (feed);
		}
	}
	result = FALSE;
	return result;
}

guint
feed_reader_utils_categoryGetUnread (const gchar* catID,
                                     GeeList* feeds)
{
	guint unread = 0U;
	guint result;
	g_return_val_if_fail (catID != NULL, 0U);
	g_return_val_if_fail (feeds != NULL, 0U);
	unread = (guint) 0;
	{
		GeeList* _feed_list = NULL;
		gint _feed_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _feed_index = 0;
		_feed_list = feeds;
		_tmp0_ = _feed_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_feed_size = _tmp2_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			GeeList* ids = NULL;
			FeedReaderFeed* _tmp7_;
			GeeList* _tmp8_;
			_feed_index = _feed_index + 1;
			_tmp3_ = _feed_index;
			_tmp4_ = _feed_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _feed_list;
			_tmp6_ = gee_list_get (_tmp5_, _feed_index);
			feed = (FeedReaderFeed*) _tmp6_;
			_tmp7_ = feed;
			_tmp8_ = feed_reader_feed_getCatIDs (_tmp7_);
			ids = _tmp8_;
			{
				GeeList* _id_list = NULL;
				GeeList* _tmp9_;
				gint _id_size = 0;
				GeeList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _id_index = 0;
				_tmp9_ = ids;
				_id_list = _tmp9_;
				_tmp10_ = _id_list;
				_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_id_size = _tmp12_;
				_id_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gchar* id = NULL;
					GeeList* _tmp15_;
					gpointer _tmp16_;
					const gchar* _tmp17_;
					_id_index = _id_index + 1;
					_tmp13_ = _id_index;
					_tmp14_ = _id_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _id_list;
					_tmp16_ = gee_list_get (_tmp15_, _id_index);
					id = (gchar*) _tmp16_;
					_tmp17_ = id;
					if (g_strcmp0 (_tmp17_, catID) == 0) {
						FeedReaderFeed* _tmp18_;
						_tmp18_ = feed;
						unread += feed_reader_feed_getUnread (_tmp18_);
						_g_free0 (id);
						break;
					}
					_g_free0 (id);
				}
			}
			_g_object_unref0 (ids);
			_g_object_unref0 (feed);
		}
	}
	result = unread;
	return result;
}

void
feed_reader_utils_resetSettings (GSettings* settings)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** keys = NULL;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (settings != NULL);
	g_object_get (settings, "schema-id", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Resetting setting ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_logger_warning (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp6_ = _tmp5_ = g_settings_list_keys (settings);
	keys = _tmp6_;
	keys_length1 = _vala_array_length (_tmp5_);
	_keys_size_ = keys_length1;
	_tmp7_ = keys;
	_tmp7__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp7_;
		key_collection_length1 = _tmp7__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp8_;
			gchar* key = NULL;
			_tmp8_ = g_strdup (key_collection[key_it]);
			key = _tmp8_;
			{
				const gchar* _tmp9_;
				_tmp9_ = key;
				g_settings_reset (settings, _tmp9_);
				_g_free0 (key);
			}
		}
	}
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
}

gchar*
feed_reader_utils_URLtoFeedName (const gchar* url)
{
	GString* feedname = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	if (url == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_string_new (url);
	feedname = _tmp1_;
	_tmp2_ = feedname;
	_tmp3_ = _tmp2_->str;
	if (g_str_has_suffix (_tmp3_, "/")) {
		GString* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = feedname;
		_tmp5_ = feedname;
		_tmp6_ = _tmp5_->str;
		g_string_erase (_tmp4_, (gssize) (g_utf8_strlen (_tmp6_, (gssize) -1) - 1), (gssize) -1);
	}
	_tmp7_ = feedname;
	_tmp8_ = _tmp7_->str;
	if (g_str_has_prefix (_tmp8_, "https://")) {
		GString* _tmp9_;
		_tmp9_ = feedname;
		g_string_erase (_tmp9_, (gssize) 0, (gssize) 8);
	}
	_tmp10_ = feedname;
	_tmp11_ = _tmp10_->str;
	if (g_str_has_prefix (_tmp11_, "http://")) {
		GString* _tmp12_;
		_tmp12_ = feedname;
		g_string_erase (_tmp12_, (gssize) 0, (gssize) 7);
	}
	_tmp13_ = feedname;
	_tmp14_ = _tmp13_->str;
	if (g_str_has_prefix (_tmp14_, "www.")) {
		GString* _tmp15_;
		_tmp15_ = feedname;
		g_string_erase (_tmp15_, (gssize) 0, (gssize) 4);
	}
	_tmp16_ = feedname;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_string_free0 (feedname);
	return result;
}

static void
feed_reader_utils_file_exists_data_free (gpointer _data)
{
	FeedReaderUtilsFileExistsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path_str);
	g_slice_free (FeedReaderUtilsFileExistsData, _data_);
}

void
feed_reader_utils_file_exists (const gchar* path_str,
                               GFileType expected_type,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	FeedReaderUtilsFileExistsData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (path_str != NULL);
	_data_ = g_slice_new0 (FeedReaderUtilsFileExistsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_utils_file_exists_data_free);
	_tmp0_ = g_strdup (path_str);
	_g_free0 (_data_->path_str);
	_data_->path_str = _tmp0_;
	_data_->expected_type = expected_type;
	feed_reader_utils_file_exists_co (_data_);
}

gboolean
feed_reader_utils_file_exists_finish (GAsyncResult* _res_)
{
	gboolean result;
	FeedReaderUtilsFileExistsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
feed_reader_utils_file_exists_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	FeedReaderUtilsFileExistsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	feed_reader_utils_file_exists_co (_data_);
}

static gboolean
feed_reader_utils_file_exists_co (FeedReaderUtilsFileExistsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->path_str);
	_data_->path = _data_->_tmp0_;
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->path, "standard::type", G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, feed_reader_utils_file_exists_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_query_info_finish (_data_->path, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->result = g_file_info_get_file_type (_data_->info) == _data_->expected_type;
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
feed_reader_utils_ensure_path_data_free (gpointer _data)
{
	FeedReaderUtilsEnsurePathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path_str);
	g_slice_free (FeedReaderUtilsEnsurePathData, _data_);
}

void
feed_reader_utils_ensure_path (const gchar* path_str,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	FeedReaderUtilsEnsurePathData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (path_str != NULL);
	_data_ = g_slice_new0 (FeedReaderUtilsEnsurePathData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_utils_ensure_path_data_free);
	_tmp0_ = g_strdup (path_str);
	_g_free0 (_data_->path_str);
	_data_->path_str = _tmp0_;
	feed_reader_utils_ensure_path_co (_data_);
}

gboolean
feed_reader_utils_ensure_path_finish (GAsyncResult* _res_)
{
	gboolean result;
	FeedReaderUtilsEnsurePathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
feed_reader_utils_ensure_path_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	FeedReaderUtilsEnsurePathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	feed_reader_utils_ensure_path_co (_data_);
}

static gboolean
feed_reader_utils_ensure_path_co (FeedReaderUtilsEnsurePathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->path_str);
	_data_->path = _data_->_tmp0_;
	_data_->_state_ = 1;
	feed_reader_utils_file_exists (_data_->path_str, G_FILE_TYPE_DIRECTORY, feed_reader_utils_ensure_path_ready, _data_);
	return FALSE;
	_state_1:
	if (feed_reader_utils_file_exists_finish (_data_->_res_)) {
		_data_->result = TRUE;
		_g_object_unref0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->path;
		g_file_make_directory_with_parents (_data_->_tmp1_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch0_g_io_error_exists;
			}
			goto __catch0_g_error;
		}
		_data_->result = TRUE;
		_g_object_unref0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = TRUE;
		_g_object_unref0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = string_to_string (_data_->path_str);
		_data_->_tmp3_ = g_strconcat ("ensure_path: Failed to create folder ", _data_->_tmp2_, ": ", NULL);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		_data_->_tmp7_ = g_strconcat (_data_->_tmp4_, _data_->_tmp6_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		feed_reader_logger_error (_data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_g_free0 (_data_->_tmp4_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
feed_reader_utils_gsettingReadString (GSettings* setting,
                                      const gchar* key)
{
	gchar* val = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (setting != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	val = _tmp0_;
	_tmp1_ = val;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		g_object_get (setting, "schema-id", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("Utils.gsettingReadString: failed to read %s %s", _tmp4_, key);
		_tmp6_ = _tmp5_;
		feed_reader_logger_warning (_tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	}
	result = val;
	return result;
}

void
feed_reader_utils_gsettingWriteString (GSettings* setting,
                                       const gchar* key,
                                       const gchar* val)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	if (g_strcmp0 (val, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = val == NULL;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_object_get (setting, "schema-id", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("Utils.gsettingWriteString: resetting %s %s", _tmp3_, key);
		_tmp5_ = _tmp4_;
		feed_reader_logger_warning (_tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	if (!g_settings_set_string (setting, key, val)) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		g_object_get (setting, "schema-id", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("Utils.gsettingWriteString: writing %s %s failed", _tmp8_, key);
		_tmp10_ = _tmp9_;
		feed_reader_logger_error (_tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
}

static void
feed_reader_utils_inputStreamToArray_data_free (gpointer _data)
{
	feed_reader_utils_inputStreamToArrayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (g_free (_data_->result), NULL);
	g_slice_free (feed_reader_utils_inputStreamToArrayData, _data_);
}

void
feed_reader_utils_inputStreamToArray (GInputStream* stream,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	feed_reader_utils_inputStreamToArrayData* _data_;
	GInputStream* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (stream != NULL);
	_data_ = g_slice_new0 (feed_reader_utils_inputStreamToArrayData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_utils_inputStreamToArray_data_free);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data_->stream);
	_data_->stream = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	feed_reader_utils_inputStreamToArray_co (_data_);
}

guint8*
feed_reader_utils_inputStreamToArray_finish (GAsyncResult* _res_,
                                             gint* result_length1,
                                             GError** error)
{
	guint8* result;
	feed_reader_utils_inputStreamToArrayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
feed_reader_utils_inputStreamToArray_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	feed_reader_utils_inputStreamToArrayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	feed_reader_utils_inputStreamToArray_co (_data_);
}

static guint8*
_vala_array_dup5 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
feed_reader_utils_inputStreamToArray_co (feed_reader_utils_inputStreamToArrayData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_array_new (TRUE, TRUE, sizeof (guint8));
	_data_->_result_ = _data_->_tmp0_;
	_data_->_tmp1_ = g_new0 (guint8, 1024);
	_data_->buffer = _data_->_tmp1_;
	_data_->buffer_length1 = 1024;
	_data_->_buffer_size_ = _data_->buffer_length1;
	while (TRUE) {
		_data_->bytesRead = (gsize) 0;
		_data_->_tmp2_ = _data_->buffer;
		_data_->_tmp2__length1 = _data_->buffer_length1;
		_data_->_tmp3_ = 0UL;
		_data_->_state_ = 1;
		g_input_stream_read_all_async (_data_->stream, _data_->_tmp2_, (gsize) _data_->_tmp2__length1, G_PRIORITY_DEFAULT_IDLE, _data_->cancellable, feed_reader_utils_inputStreamToArray_ready, _data_);
		return FALSE;
		_state_1:
		g_input_stream_read_all_finish (_data_->stream, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
		_data_->bytesRead = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->buffer = (g_free (_data_->buffer), NULL);
			_g_array_unref0 (_data_->_result_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->bytesRead == ((gsize) 0)) {
			break;
		}
		_data_->_tmp4_ = _data_->_result_;
		_data_->_tmp5_ = _data_->buffer;
		_data_->_tmp5__length1 = _data_->buffer_length1;
		g_array_append_vals (_data_->_tmp4_, _data_->_tmp5_, (guint) _data_->bytesRead);
	}
	_data_->_tmp6_ = _data_->_result_;
	_data_->_tmp7_ = _data_->_tmp6_->data;
	_data_->_tmp7__length1 = _data_->_tmp6_->len;
	_data_->_tmp8_ = (_data_->_tmp7_ != NULL) ? _vala_array_dup5 (_data_->_tmp7_, _data_->_tmp7__length1) : _data_->_tmp7_;
	_data_->_tmp8__length1 = _data_->_tmp7__length1;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp9__length1 = _data_->_tmp8__length1;
	_data_->result_length1 = _data_->_tmp9__length1;
	_data_->result = _data_->_tmp9_;
	_data_->buffer = (g_free (_data_->buffer), NULL);
	_g_array_unref0 (_data_->_result_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

gchar*
feed_reader_utils_buildArticle (const gchar* html,
                                const gchar* title,
                                const gchar* url,
                                const gchar* author,
                                const gchar* date,
                                const gchar* feedID)
{
	GString* article = NULL;
	GString* _tmp0_;
	gchar* author_date = NULL;
	gchar* _tmp1_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* html_id = NULL;
	gchar* _tmp18_;
	gint html_pos = 0;
	GString* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GString* _tmp26_;
	gchar* author_id = NULL;
	gchar* _tmp27_;
	gint author_pos = 0;
	GString* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	gchar* title_id = NULL;
	gchar* _tmp37_;
	gint title_pos = 0;
	GString* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GString* _tmp41_;
	const gchar* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GString* _tmp45_;
	gchar* url_id = NULL;
	gchar* _tmp46_;
	gint url_pos = 0;
	GString* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	GString* _tmp50_;
	const gchar* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	GString* _tmp54_;
	gchar* feed_id = NULL;
	gchar* _tmp55_;
	gint feed_pos = 0;
	GString* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	GString* _tmp59_;
	const gchar* _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	FeedReaderFeed* feed = NULL;
	FeedReaderDataBaseReadOnly* _tmp63_;
	FeedReaderDataBaseReadOnly* _tmp64_;
	FeedReaderFeed* _tmp65_;
	FeedReaderFeed* _tmp66_;
	gchar* _tmp67_ = NULL;
	FeedReaderFeed* _tmp68_;
	GString* _tmp72_;
	gchar* theme = NULL;
	gchar* _tmp73_;
	GSettings* _tmp74_;
	GSettings* _tmp75_;
	gint _tmp76_;
	gchar* theme_id = NULL;
	gchar* _tmp87_;
	gint theme_pos = 0;
	GString* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	GString* _tmp91_;
	const gchar* _tmp92_;
	gint _tmp93_;
	gint _tmp94_;
	GString* _tmp95_;
	const gchar* _tmp96_;
	gchar* select_id = NULL;
	gchar* _tmp97_;
	gint select_pos = 0;
	GString* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	GSettings* _tmp101_;
	GSettings* _tmp102_;
	gboolean _tmp103_;
	GeeArrayList* font_options = NULL;
	GeeArrayList* _tmp113_;
	GVariant* font_setting = NULL;
	GSettings* _tmp114_;
	GSettings* _tmp115_;
	GVariant* _tmp116_;
	GVariant* _tmp117_;
	GVariant* _tmp118_;
	GVariant* _tmp119_;
	GVariant* _tmp120_;
	gchar* system_font = NULL;
	GSettings* _tmp124_;
	GSettings* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	const gchar* _tmp128_;
	GeeArrayList* _tmp131_;
	GeeArrayList* font_families = NULL;
	GeeArrayList* _tmp132_;
	guint* font_size = NULL;
	guint* _tmp152_;
	guint* _tmp155_;
	guint _tmp156_;
	guint* _tmp157_;
	gchar* font_family = NULL;
	GeeArrayList* _tmp158_;
	gchar* _tmp159_;
	const gchar* _tmp160_;
	const gchar* _tmp161_;
	guint* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	gchar* _tmp165_;
	gchar* _tmp166_;
	gchar* small_size = NULL;
	guint* _tmp167_;
	gchar* _tmp168_;
	gchar* large_size = NULL;
	guint* _tmp169_;
	gchar* _tmp170_;
	gchar* normal_size = NULL;
	guint* _tmp171_;
	gchar* _tmp172_;
	gchar* fontfamily_id = NULL;
	gchar* _tmp173_;
	gint fontfamilly_pos = 0;
	GString* _tmp174_;
	const gchar* _tmp175_;
	const gchar* _tmp176_;
	GString* _tmp177_;
	const gchar* _tmp178_;
	gint _tmp179_;
	gint _tmp180_;
	GString* _tmp181_;
	const gchar* _tmp182_;
	gchar* _tmp183_;
	gchar* _tmp184_;
	gchar* fontsize_id = NULL;
	gchar* _tmp185_;
	gchar* sourcefontsize_id = NULL;
	gchar* _tmp186_;
	gint fontsize_pos = 0;
	GString* _tmp187_;
	const gchar* _tmp188_;
	const gchar* _tmp189_;
	GString* _tmp190_;
	const gchar* _tmp191_;
	gint _tmp192_;
	gint _tmp193_;
	GString* _tmp194_;
	const gchar* _tmp195_;
	gchar* largesize_id = NULL;
	gchar* _tmp196_;
	gint largesize_pos = 0;
	GString* _tmp197_;
	const gchar* _tmp198_;
	const gchar* _tmp199_;
	GString* _tmp200_;
	const gchar* _tmp201_;
	gint _tmp202_;
	gint _tmp203_;
	GString* _tmp204_;
	const gchar* _tmp205_;
	GString* _tmp235_;
	const gchar* _tmp236_;
	gchar* _tmp237_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (html != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (feedID != NULL, NULL);
	_tmp0_ = g_string_new ("");
	article = _tmp0_;
	_tmp1_ = g_strdup ("");
	author_date = _tmp1_;
	if (author != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = author_date;
		_tmp3_ = g_strdup_printf (_ ("posted by: %s, "), author);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
		_g_free0 (author_date);
		author_date = _tmp5_;
		_g_free0 (_tmp4_);
	}
	_tmp6_ = author_date;
	_tmp7_ = g_strconcat (_tmp6_, date, NULL);
	_g_free0 (author_date);
	author_date = _tmp7_;
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		GFile* file = NULL;
		GFile* _tmp8_;
		GFile* _tmp9_;
		guint8* _tmp10_ = NULL;
		gsize _tmp11_ = 0;
		GString* _tmp12_;
		guint8* _tmp13_;
		gint _tmp13__length1;
		_tmp8_ = g_file_new_for_uri ("resource:///org/gnome/FeedReader/ArticleView/article.html");
		file = _tmp8_;
		_tmp9_ = file;
		g_file_load_contents (_tmp9_, NULL, &_tmp10_, &_tmp11_, NULL, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp10_;
		contents_length1 = _tmp11_;
		_contents_size_ = contents_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			contents = (g_free (contents), NULL);
			goto __catch0_g_error;
		}
		_tmp12_ = article;
		_tmp13_ = contents;
		_tmp13__length1 = contents_length1;
		g_string_assign (_tmp12_, (const gchar*) _tmp13_);
		_g_object_unref0 (file);
		contents = (g_free (contents), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = g_strdup_printf ("Utils.buildArticle: %s", _tmp15_);
		_tmp17_ = _tmp16_;
		feed_reader_logger_error (_tmp17_);
		_g_free0 (_tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (author_date);
		_g_string_free0 (article);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp18_ = g_strdup ("$HTML");
	html_id = _tmp18_;
	_tmp19_ = article;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = html_id;
	html_pos = string_index_of (_tmp20_, _tmp21_, 0);
	_tmp22_ = article;
	_tmp23_ = html_id;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	g_string_erase (_tmp22_, (gssize) html_pos, (gssize) _tmp25_);
	_tmp26_ = article;
	g_string_insert (_tmp26_, (gssize) html_pos, html);
	_tmp27_ = g_strdup ("$AUTHOR");
	author_id = _tmp27_;
	_tmp28_ = article;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = author_id;
	author_pos = string_index_of (_tmp29_, _tmp30_, 0);
	_tmp31_ = article;
	_tmp32_ = author_id;
	_tmp33_ = strlen (_tmp32_);
	_tmp34_ = _tmp33_;
	g_string_erase (_tmp31_, (gssize) author_pos, (gssize) _tmp34_);
	_tmp35_ = article;
	_tmp36_ = author_date;
	g_string_insert (_tmp35_, (gssize) author_pos, _tmp36_);
	_tmp37_ = g_strdup ("$TITLE");
	title_id = _tmp37_;
	_tmp38_ = article;
	_tmp39_ = _tmp38_->str;
	_tmp40_ = title_id;
	title_pos = string_index_of (_tmp39_, _tmp40_, 0);
	_tmp41_ = article;
	_tmp42_ = title_id;
	_tmp43_ = strlen (_tmp42_);
	_tmp44_ = _tmp43_;
	g_string_erase (_tmp41_, (gssize) title_pos, (gssize) _tmp44_);
	_tmp45_ = article;
	g_string_insert (_tmp45_, (gssize) title_pos, title);
	_tmp46_ = g_strdup ("$URL");
	url_id = _tmp46_;
	_tmp47_ = article;
	_tmp48_ = _tmp47_->str;
	_tmp49_ = url_id;
	url_pos = string_index_of (_tmp48_, _tmp49_, 0);
	_tmp50_ = article;
	_tmp51_ = url_id;
	_tmp52_ = strlen (_tmp51_);
	_tmp53_ = _tmp52_;
	g_string_erase (_tmp50_, (gssize) url_pos, (gssize) _tmp53_);
	_tmp54_ = article;
	g_string_insert (_tmp54_, (gssize) url_pos, url);
	_tmp55_ = g_strdup ("$FEED");
	feed_id = _tmp55_;
	_tmp56_ = article;
	_tmp57_ = _tmp56_->str;
	_tmp58_ = feed_id;
	feed_pos = string_index_of (_tmp57_, _tmp58_, 0);
	_tmp59_ = article;
	_tmp60_ = feed_id;
	_tmp61_ = strlen (_tmp60_);
	_tmp62_ = _tmp61_;
	g_string_erase (_tmp59_, (gssize) feed_pos, (gssize) _tmp62_);
	_tmp63_ = feed_reader_data_base_readOnly ();
	_tmp64_ = _tmp63_;
	_tmp65_ = feed_reader_data_base_read_only_read_feed (_tmp64_, feedID);
	_tmp66_ = _tmp65_;
	_g_object_unref0 (_tmp64_);
	feed = _tmp66_;
	_tmp68_ = feed;
	if (_tmp68_ != NULL) {
		FeedReaderFeed* _tmp69_;
		gchar* _tmp70_;
		_tmp69_ = feed;
		_tmp70_ = feed_reader_feed_getTitle (_tmp69_);
		_g_free0 (_tmp67_);
		_tmp67_ = _tmp70_;
	} else {
		gchar* _tmp71_;
		_tmp71_ = g_strdup ("");
		_g_free0 (_tmp67_);
		_tmp67_ = _tmp71_;
	}
	_tmp72_ = article;
	g_string_insert (_tmp72_, (gssize) feed_pos, _tmp67_);
	_tmp73_ = g_strdup ("theme ");
	theme = _tmp73_;
	_tmp74_ = feed_reader_settings_general ();
	_tmp75_ = _tmp74_;
	_tmp76_ = g_settings_get_enum (_tmp75_, "article-theme");
	_g_object_unref0 (_tmp75_);
	switch (_tmp76_) {
		case FEED_READER_ARTICLE_THEME_DEFAULT:
		{
			const gchar* _tmp77_;
			gchar* _tmp78_;
			_tmp77_ = theme;
			_tmp78_ = g_strconcat (_tmp77_, "default", NULL);
			_g_free0 (theme);
			theme = _tmp78_;
			break;
		}
		case FEED_READER_ARTICLE_THEME_SPRING:
		{
			const gchar* _tmp79_;
			gchar* _tmp80_;
			_tmp79_ = theme;
			_tmp80_ = g_strconcat (_tmp79_, "spring", NULL);
			_g_free0 (theme);
			theme = _tmp80_;
			break;
		}
		case FEED_READER_ARTICLE_THEME_MIDNIGHT:
		{
			const gchar* _tmp81_;
			gchar* _tmp82_;
			_tmp81_ = theme;
			_tmp82_ = g_strconcat (_tmp81_, "midnight", NULL);
			_g_free0 (theme);
			theme = _tmp82_;
			break;
		}
		case FEED_READER_ARTICLE_THEME_PARCHMENT:
		{
			const gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp83_ = theme;
			_tmp84_ = g_strconcat (_tmp83_, "parchment", NULL);
			_g_free0 (theme);
			theme = _tmp84_;
			break;
		}
		case FEED_READER_ARTICLE_THEME_GRUVBOX:
		{
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = theme;
			_tmp86_ = g_strconcat (_tmp85_, "gruvbox", NULL);
			_g_free0 (theme);
			theme = _tmp86_;
			break;
		}
		default:
		break;
	}
	_tmp87_ = g_strdup ("$THEME");
	theme_id = _tmp87_;
	_tmp88_ = article;
	_tmp89_ = _tmp88_->str;
	_tmp90_ = theme_id;
	theme_pos = string_index_of (_tmp89_, _tmp90_, 0);
	_tmp91_ = article;
	_tmp92_ = theme_id;
	_tmp93_ = strlen (_tmp92_);
	_tmp94_ = _tmp93_;
	g_string_erase (_tmp91_, (gssize) theme_pos, (gssize) _tmp94_);
	_tmp95_ = article;
	_tmp96_ = theme;
	g_string_insert (_tmp95_, (gssize) theme_pos, _tmp96_);
	_tmp97_ = g_strdup ("$UNSELECTABLE");
	select_id = _tmp97_;
	_tmp98_ = article;
	_tmp99_ = _tmp98_->str;
	_tmp100_ = select_id;
	select_pos = string_index_of (_tmp99_, _tmp100_, 0);
	_tmp101_ = feed_reader_settings_tweaks ();
	_tmp102_ = _tmp101_;
	_tmp103_ = g_settings_get_boolean (_tmp102_, "article-select-text");
	_g_object_unref0 (_tmp102_);
	if (_tmp103_) {
		GString* _tmp104_;
		const gchar* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		_tmp104_ = article;
		_tmp105_ = select_id;
		_tmp106_ = strlen (_tmp105_);
		_tmp107_ = _tmp106_;
		g_string_erase (_tmp104_, (gssize) (select_pos - 1), (gssize) (_tmp107_ + 1));
	} else {
		GString* _tmp108_;
		const gchar* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		GString* _tmp112_;
		_tmp108_ = article;
		_tmp109_ = select_id;
		_tmp110_ = strlen (_tmp109_);
		_tmp111_ = _tmp110_;
		g_string_erase (_tmp108_, (gssize) select_pos, (gssize) _tmp111_);
		_tmp112_ = article;
		g_string_insert (_tmp112_, (gssize) select_pos, "unselectable");
	}
	_tmp113_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	font_options = _tmp113_;
	_tmp114_ = feed_reader_settings_general ();
	_tmp115_ = _tmp114_;
	_tmp116_ = g_settings_get_value (_tmp115_, "font");
	_tmp117_ = _tmp116_;
	_tmp118_ = g_variant_get_maybe (_tmp117_);
	_tmp119_ = _tmp118_;
	_g_variant_unref0 (_tmp117_);
	_g_object_unref0 (_tmp115_);
	font_setting = _tmp119_;
	_tmp120_ = font_setting;
	if (_tmp120_ != NULL) {
		GeeArrayList* _tmp121_;
		GVariant* _tmp122_;
		const gchar* _tmp123_;
		_tmp121_ = font_options;
		_tmp122_ = font_setting;
		_tmp123_ = g_variant_get_string (_tmp122_, NULL);
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp121_, _tmp123_);
	}
	_tmp124_ = g_settings_new ("org.gnome.desktop.interface");
	_tmp125_ = _tmp124_;
	_tmp126_ = g_settings_get_string (_tmp125_, "document-font-name");
	_tmp127_ = _tmp126_;
	_g_object_unref0 (_tmp125_);
	system_font = _tmp127_;
	_tmp128_ = system_font;
	if (_tmp128_ != NULL) {
		GeeArrayList* _tmp129_;
		const gchar* _tmp130_;
		_tmp129_ = font_options;
		_tmp130_ = system_font;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp129_, _tmp130_);
	}
	_tmp131_ = font_options;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp131_, "sans");
	_tmp132_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	font_families = _tmp132_;
	font_size = NULL;
	{
		GeeArrayList* _font_list = NULL;
		GeeArrayList* _tmp133_;
		gint _font_size = 0;
		GeeArrayList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _font_index = 0;
		_tmp133_ = font_options;
		_font_list = _tmp133_;
		_tmp134_ = _font_list;
		_tmp135_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_font_size = _tmp136_;
		_font_index = -1;
		while (TRUE) {
			gint _tmp137_;
			gint _tmp138_;
			gchar* font = NULL;
			GeeArrayList* _tmp139_;
			gpointer _tmp140_;
			PangoFontDescription* desc = NULL;
			const gchar* _tmp141_;
			PangoFontDescription* _tmp142_;
			GeeArrayList* _tmp143_;
			PangoFontDescription* _tmp144_;
			const gchar* _tmp145_;
			gboolean _tmp146_ = FALSE;
			guint* _tmp147_;
			_font_index = _font_index + 1;
			_tmp137_ = _font_index;
			_tmp138_ = _font_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _font_list;
			_tmp140_ = gee_abstract_list_get ((GeeAbstractList*) _tmp139_, _font_index);
			font = (gchar*) _tmp140_;
			_tmp141_ = font;
			_tmp142_ = pango_font_description_from_string (_tmp141_);
			desc = _tmp142_;
			_tmp143_ = font_families;
			_tmp144_ = desc;
			_tmp145_ = pango_font_description_get_family (_tmp144_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp143_, _tmp145_);
			_tmp147_ = font_size;
			if (_tmp147_ == NULL) {
				PangoFontDescription* _tmp148_;
				_tmp148_ = desc;
				_tmp146_ = pango_font_description_get_size (_tmp148_) > 0;
			} else {
				_tmp146_ = FALSE;
			}
			if (_tmp146_) {
				PangoFontDescription* _tmp149_;
				guint _tmp150_;
				guint* _tmp151_;
				_tmp149_ = desc;
				_tmp150_ = (guint) roundf ((gfloat) pango_font_description_get_size (_tmp149_));
				_tmp151_ = __uint_dup0 (&_tmp150_);
				_g_free0 (font_size);
				font_size = _tmp151_;
			}
			__vala_PangoFontDescription_free0 (desc);
			_g_free0 (font);
		}
	}
	_tmp152_ = font_size;
	if (_tmp152_ == NULL) {
		guint _tmp153_;
		guint* _tmp154_;
		_tmp153_ = (guint) 12;
		_tmp154_ = __uint_dup0 (&_tmp153_);
		_g_free0 (font_size);
		font_size = _tmp154_;
	}
	_tmp155_ = font_size;
	_tmp156_ = (*_tmp155_) / PANGO_SCALE;
	_tmp157_ = __uint_dup0 (&_tmp156_);
	_g_free0 (font_size);
	font_size = _tmp157_;
	_tmp158_ = font_families;
	_tmp159_ = feed_reader_string_utils_join ((GeeCollection*) _tmp158_, ", ");
	font_family = _tmp159_;
	_tmp160_ = font_family;
	_tmp161_ = string_to_string (_tmp160_);
	_tmp162_ = font_size;
	_tmp163_ = g_strdup_printf ("%u", *_tmp162_);
	_tmp164_ = _tmp163_;
	_tmp165_ = g_strconcat ("Font: ", _tmp161_, " @ ", _tmp164_, NULL);
	_tmp166_ = _tmp165_;
	feed_reader_logger_info (_tmp166_);
	_g_free0 (_tmp166_);
	_g_free0 (_tmp164_);
	_tmp167_ = font_size;
	_tmp168_ = g_strdup_printf ("%u", (*_tmp167_) - 2);
	small_size = _tmp168_;
	_tmp169_ = font_size;
	_tmp170_ = g_strdup_printf ("%u", (*_tmp169_) * 2);
	large_size = _tmp170_;
	_tmp171_ = font_size;
	_tmp172_ = g_strdup_printf ("%u", *_tmp171_);
	normal_size = _tmp172_;
	_tmp173_ = g_strdup ("$FONTFAMILY");
	fontfamily_id = _tmp173_;
	_tmp174_ = article;
	_tmp175_ = _tmp174_->str;
	_tmp176_ = fontfamily_id;
	fontfamilly_pos = string_index_of (_tmp175_, _tmp176_, 0);
	_tmp177_ = article;
	_tmp178_ = fontfamily_id;
	_tmp179_ = strlen (_tmp178_);
	_tmp180_ = _tmp179_;
	g_string_erase (_tmp177_, (gssize) fontfamilly_pos, (gssize) _tmp180_);
	_tmp181_ = article;
	_tmp182_ = font_family;
	_tmp183_ = g_strconcat (_tmp182_, ", sans", NULL);
	_tmp184_ = _tmp183_;
	g_string_insert (_tmp181_, (gssize) fontfamilly_pos, _tmp184_);
	_g_free0 (_tmp184_);
	_tmp185_ = g_strdup ("$FONTSIZE");
	fontsize_id = _tmp185_;
	_tmp186_ = g_strdup ("$SMALLSIZE");
	sourcefontsize_id = _tmp186_;
	_tmp187_ = article;
	_tmp188_ = _tmp187_->str;
	_tmp189_ = fontsize_id;
	fontsize_pos = string_index_of (_tmp188_, _tmp189_, 0);
	_tmp190_ = article;
	_tmp191_ = fontsize_id;
	_tmp192_ = strlen (_tmp191_);
	_tmp193_ = _tmp192_;
	g_string_erase (_tmp190_, (gssize) fontsize_pos, (gssize) _tmp193_);
	_tmp194_ = article;
	_tmp195_ = normal_size;
	g_string_insert (_tmp194_, (gssize) fontsize_pos, _tmp195_);
	_tmp196_ = g_strdup ("$LARGESIZE");
	largesize_id = _tmp196_;
	_tmp197_ = article;
	_tmp198_ = _tmp197_->str;
	_tmp199_ = largesize_id;
	largesize_pos = string_index_of (_tmp198_, _tmp199_, 0);
	_tmp200_ = article;
	_tmp201_ = largesize_id;
	_tmp202_ = strlen (_tmp201_);
	_tmp203_ = _tmp202_;
	g_string_erase (_tmp200_, (gssize) largesize_pos, (gssize) _tmp203_);
	_tmp204_ = article;
	_tmp205_ = large_size;
	g_string_insert (_tmp204_, (gssize) largesize_pos, _tmp205_);
	{
		gint i = 0;
		GString* _tmp206_;
		const gchar* _tmp207_;
		const gchar* _tmp208_;
		_tmp206_ = article;
		_tmp207_ = _tmp206_->str;
		_tmp208_ = sourcefontsize_id;
		i = string_index_of (_tmp207_, _tmp208_, 0);
		{
			gboolean _tmp209_ = FALSE;
			_tmp209_ = TRUE;
			while (TRUE) {
				GString* _tmp213_;
				const gchar* _tmp214_;
				gint _tmp215_;
				gint _tmp216_;
				GString* _tmp217_;
				const gchar* _tmp218_;
				if (!_tmp209_) {
					GString* _tmp210_;
					const gchar* _tmp211_;
					const gchar* _tmp212_;
					_tmp210_ = article;
					_tmp211_ = _tmp210_->str;
					_tmp212_ = sourcefontsize_id;
					i = string_index_of (_tmp211_, _tmp212_, i);
				}
				_tmp209_ = FALSE;
				if (!(i != -1)) {
					break;
				}
				_tmp213_ = article;
				_tmp214_ = sourcefontsize_id;
				_tmp215_ = strlen (_tmp214_);
				_tmp216_ = _tmp215_;
				g_string_erase (_tmp213_, (gssize) i, (gssize) _tmp216_);
				_tmp217_ = article;
				_tmp218_ = small_size;
				g_string_insert (_tmp217_, (gssize) i, _tmp218_);
			}
		}
	}
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		GFile* file = NULL;
		GFile* _tmp219_;
		guint8* _tmp220_ = NULL;
		gsize _tmp221_ = 0;
		gchar* css_id = NULL;
		gchar* _tmp222_;
		gint css_pos = 0;
		GString* _tmp223_;
		const gchar* _tmp224_;
		const gchar* _tmp225_;
		GString* _tmp226_;
		const gchar* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		GString* _tmp230_;
		_tmp219_ = g_file_new_for_uri ("resource:///org/gnome/FeedReader/ArticleView/style.css");
		file = _tmp219_;
		g_file_load_contents (file, NULL, &_tmp220_, &_tmp221_, NULL, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp220_;
		contents_length1 = _tmp221_;
		_contents_size_ = contents_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			contents = (g_free (contents), NULL);
			goto __catch1_g_error;
		}
		_tmp222_ = g_strdup ("$CSS");
		css_id = _tmp222_;
		_tmp223_ = article;
		_tmp224_ = _tmp223_->str;
		_tmp225_ = css_id;
		css_pos = string_index_of (_tmp224_, _tmp225_, 0);
		_tmp226_ = article;
		_tmp227_ = css_id;
		_tmp228_ = strlen (_tmp227_);
		_tmp229_ = _tmp228_;
		g_string_erase (_tmp226_, (gssize) css_pos, (gssize) _tmp229_);
		_tmp230_ = article;
		g_string_insert (_tmp230_, (gssize) css_pos, (const gchar*) contents);
		_g_free0 (css_id);
		_g_object_unref0 (file);
		contents = (g_free (contents), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp231_;
		const gchar* _tmp232_;
		gchar* _tmp233_;
		gchar* _tmp234_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp231_ = e;
		_tmp232_ = _tmp231_->message;
		_tmp233_ = g_strconcat ("Utils.buildArticle: load CSS: ", _tmp232_, NULL);
		_tmp234_ = _tmp233_;
		feed_reader_logger_error (_tmp234_);
		_g_free0 (_tmp234_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (largesize_id);
		_g_free0 (sourcefontsize_id);
		_g_free0 (fontsize_id);
		_g_free0 (fontfamily_id);
		_g_free0 (normal_size);
		_g_free0 (large_size);
		_g_free0 (small_size);
		_g_free0 (font_family);
		_g_free0 (font_size);
		_g_object_unref0 (font_families);
		_g_free0 (system_font);
		_g_variant_unref0 (font_setting);
		_g_object_unref0 (font_options);
		_g_free0 (select_id);
		_g_free0 (theme_id);
		_g_free0 (theme);
		_g_free0 (_tmp67_);
		_g_object_unref0 (feed);
		_g_free0 (feed_id);
		_g_free0 (url_id);
		_g_free0 (title_id);
		_g_free0 (author_id);
		_g_free0 (html_id);
		_g_free0 (author_date);
		_g_string_free0 (article);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp235_ = article;
	_tmp236_ = _tmp235_->str;
	_tmp237_ = g_strdup (_tmp236_);
	result = _tmp237_;
	_g_free0 (largesize_id);
	_g_free0 (sourcefontsize_id);
	_g_free0 (fontsize_id);
	_g_free0 (fontfamily_id);
	_g_free0 (normal_size);
	_g_free0 (large_size);
	_g_free0 (small_size);
	_g_free0 (font_family);
	_g_free0 (font_size);
	_g_object_unref0 (font_families);
	_g_free0 (system_font);
	_g_variant_unref0 (font_setting);
	_g_object_unref0 (font_options);
	_g_free0 (select_id);
	_g_free0 (theme_id);
	_g_free0 (theme);
	_g_free0 (_tmp67_);
	_g_object_unref0 (feed);
	_g_free0 (feed_id);
	_g_free0 (url_id);
	_g_free0 (title_id);
	_g_free0 (author_id);
	_g_free0 (html_id);
	_g_free0 (author_date);
	_g_string_free0 (article);
	return result;
}

gboolean
feed_reader_utils_canManipulateContent (gboolean* online)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	FeedReaderFeedReaderBackend* _tmp5_;
	FeedReaderFeedReaderBackend* _tmp6_;
	gboolean _tmp7_;
	FeedReaderFeedReaderBackend* _tmp8_;
	FeedReaderFeedReaderBackend* _tmp9_;
	gboolean _tmp10_;
	gboolean result;
	_tmp0_ = feed_reader_settings_general ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, "plugin");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "local") == 0;
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = feed_reader_feed_reader_backend_get_default ();
	_tmp6_ = _tmp5_;
	_tmp7_ = !feed_reader_feed_reader_backend_supportFeedManipulation (_tmp6_);
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	if (online != NULL) {
		if (*online) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = feed_reader_feed_reader_backend_get_default ();
	_tmp9_ = _tmp8_;
	_tmp10_ = feed_reader_feed_reader_backend_isOnline (_tmp9_);
	_g_object_unref0 (_tmp9_);
	result = _tmp10_;
	return result;
}

GMenu*
feed_reader_utils_getMenu (void)
{
	GMenu* urlMenu = NULL;
	GMenu* _tmp0_;
	GMenu* aboutMenu = NULL;
	GMenu* _tmp1_;
	GMenu* menu = NULL;
	GMenu* _tmp2_;
	GMenu* result;
	_tmp0_ = g_menu_new ();
	urlMenu = _tmp0_;
	g_menu_append (urlMenu, FEED_READER_MENU_bugs, "win.bugs");
	g_menu_append (urlMenu, FEED_READER_MENU_bounty, "win.bounty");
	_tmp1_ = g_menu_new ();
	aboutMenu = _tmp1_;
	g_menu_append (aboutMenu, FEED_READER_MENU_shortcuts, "win.shortcuts");
	g_menu_append (aboutMenu, FEED_READER_MENU_about, "win.about");
	_tmp2_ = g_menu_new ();
	menu = _tmp2_;
	g_menu_append (menu, FEED_READER_MENU_settings, "win.settings");
	g_menu_append (menu, FEED_READER_MENU_reset, "win.reset");
	g_menu_append_section (menu, "", (GMenuModel*) urlMenu);
	g_menu_append_section (menu, "", (GMenuModel*) aboutMenu);
	result = menu;
	_g_object_unref0 (aboutMenu);
	_g_object_unref0 (urlMenu);
	return result;
}

gboolean
feed_reader_utils_onlyShowFeeds (void)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gboolean _tmp2_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	FeedReaderDataBaseReadOnly* _tmp6_;
	gboolean result;
	_tmp0_ = feed_reader_settings_general ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "only-feeds");
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = feed_reader_data_base_readOnly ();
	db = _tmp3_;
	_tmp6_ = db;
	if (!feed_reader_data_base_read_only_haveCategories (_tmp6_)) {
		FeedReaderFeedReaderBackend* _tmp7_;
		FeedReaderFeedReaderBackend* _tmp8_;
		_tmp7_ = feed_reader_feed_reader_backend_get_default ();
		_tmp8_ = _tmp7_;
		_tmp5_ = !feed_reader_feed_reader_backend_supportTags (_tmp8_);
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		FeedReaderDataBaseReadOnly* _tmp9_;
		_tmp9_ = db;
		_tmp4_ = !feed_reader_data_base_read_only_haveFeedsWithoutCat (_tmp9_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		_g_object_unref0 (db);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (db);
	return result;
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		_g_object_unref0 (_data55_->save_dialog);
		_g_object_unref0 (_data55_->file);
		g_slice_free (Block55Data, _data55_);
	}
}

static void
___lambda359_ (Block55Data* _data55_,
               GtkDialog* dialog,
               gint response_id)
{
	GtkFileChooserDialog* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dialog != NULL);
	switch (response_id) {
		case GTK_RESPONSE_ACCEPT:
		{
			{
				GFile* savefile = NULL;
				GtkFileChooserDialog* _tmp0_;
				GFile* _tmp1_;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				gchar* etag = NULL;
				guint8* _tmp2_ = NULL;
				gsize _tmp3_ = 0;
				gchar* _tmp4_ = NULL;
				GFile* _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				_tmp0_ = _data55_->save_dialog;
				_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
				savefile = _tmp1_;
				g_file_load_contents (_data55_->file, NULL, &_tmp2_, &_tmp3_, &_tmp4_, &_inner_error0_);
				data = (g_free (data), NULL);
				data = _tmp2_;
				data_length1 = _tmp3_;
				_data_size_ = data_length1;
				_g_free0 (etag);
				etag = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (etag);
					data = (g_free (data), NULL);
					_g_object_unref0 (savefile);
					goto __catch0_g_error;
				}
				_tmp5_ = savefile;
				_tmp6_ = data;
				_tmp6__length1 = data_length1;
				g_file_replace_contents (_tmp5_, _tmp6_, (gsize) _tmp6__length1, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (etag);
					data = (g_free (data), NULL);
					_g_object_unref0 (savefile);
					goto __catch0_g_error;
				}
				_g_free0 (etag);
				data = (g_free (data), NULL);
				_g_object_unref0 (savefile);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->message;
				_tmp9_ = g_strconcat ("imagePopup: save file: ", _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				feed_reader_logger_debug (_tmp10_);
				_g_free0 (_tmp10_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
		default:
		case GTK_RESPONSE_CANCEL:
		{
			break;
		}
	}
	_tmp11_ = _data55_->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
}

static void
____lambda359__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	___lambda359_ (self, _sender, response_id);
}

void
feed_reader_utils_saveImageDialog (const gchar* imagePath)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (imagePath != NULL);
	{
		Block55Data* _data55_;
		gchar* articleName = NULL;
		gchar* _tmp0_;
		gchar* articleID = NULL;
		FeedReaderColumnView* _tmp1_;
		FeedReaderColumnView* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GFile* _tmp12_;
		GFileInfo* _tmp13_ = NULL;
		GFileInfo* _tmp14_;
		gchar* mimeType = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		GtkFileFilter* filter = NULL;
		GtkFileFilter* _tmp17_;
		GtkFileFilter* _tmp18_;
		const gchar* _tmp19_;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp20_;
		GeeHashMap* _tmp21_;
		GeeHashMap* _tmp22_;
		GeeHashMap* _tmp23_;
		GeeHashMap* _tmp24_;
		FeedReaderMainWindow* _tmp25_;
		FeedReaderMainWindow* _tmp26_;
		GtkFileChooserDialog* _tmp27_;
		GtkFileChooserDialog* _tmp28_;
		GtkFileChooserDialog* _tmp29_;
		GtkFileChooserDialog* _tmp30_;
		GtkFileChooserDialog* _tmp31_;
		const gchar* _tmp32_;
		GtkFileChooserDialog* _tmp33_;
		const gchar* _tmp34_;
		GeeHashMap* _tmp35_;
		const gchar* _tmp36_;
		gpointer _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		GtkFileChooserDialog* _tmp41_;
		GtkFileFilter* _tmp42_;
		GtkFileChooserDialog* _tmp43_;
		GtkFileChooserDialog* _tmp44_;
		_data55_ = g_slice_new0 (Block55Data);
		_data55_->_ref_count_ = 1;
		_tmp0_ = g_strdup ("Article.pdf");
		articleName = _tmp0_;
		_tmp1_ = feed_reader_column_view_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = feed_reader_column_view_displayedArticle (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		articleID = _tmp4_;
		_tmp5_ = articleID;
		if (_tmp5_ != NULL) {
			FeedReaderDataBaseReadOnly* _tmp6_;
			FeedReaderDataBaseReadOnly* _tmp7_;
			const gchar* _tmp8_;
			FeedReaderArticle* _tmp9_;
			FeedReaderArticle* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = feed_reader_data_base_readOnly ();
			_tmp7_ = _tmp6_;
			_tmp8_ = articleID;
			_tmp9_ = feed_reader_data_base_read_only_read_article (_tmp7_, _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = feed_reader_article_getTitle (_tmp10_);
			_g_free0 (articleName);
			articleName = _tmp11_;
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (_tmp7_);
		}
		_tmp12_ = g_file_new_for_path (imagePath);
		_data55_->file = _tmp12_;
		_tmp14_ = g_file_query_info (_data55_->file, "standard::content-type", 0, NULL, &_inner_error0_);
		_tmp13_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (articleID);
			_g_free0 (articleName);
			block55_data_unref (_data55_);
			_data55_ = NULL;
			goto __catch0_g_error;
		}
		_tmp15_ = g_file_info_get_content_type (_tmp13_);
		_tmp16_ = g_strdup (_tmp15_);
		mimeType = _tmp16_;
		_tmp17_ = gtk_file_filter_new ();
		g_object_ref_sink (_tmp17_);
		filter = _tmp17_;
		_tmp18_ = filter;
		_tmp19_ = mimeType;
		gtk_file_filter_add_mime_type (_tmp18_, _tmp19_);
		_tmp20_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		map = _tmp20_;
		_tmp21_ = map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, "image/gif", ".gif");
		_tmp22_ = map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "image/jpeg", ".jpeg");
		_tmp23_ = map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, "image/png", ".png");
		_tmp24_ = map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, "image/x-icon", ".ico");
		_tmp25_ = feed_reader_main_window_get_default ();
		_tmp26_ = _tmp25_;
		_tmp27_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save Image", (GtkWindow*) _tmp26_, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Cancel"), GTK_RESPONSE_CANCEL, _ ("Save"), GTK_RESPONSE_ACCEPT, NULL);
		g_object_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp26_);
		_data55_->save_dialog = _tmp28_;
		_tmp29_ = _data55_->save_dialog;
		gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp29_, TRUE);
		_tmp30_ = _data55_->save_dialog;
		gtk_window_set_modal ((GtkWindow*) _tmp30_, TRUE);
		_tmp31_ = _data55_->save_dialog;
		_tmp32_ = g_get_user_data_dir ();
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp31_, _tmp32_);
		_tmp33_ = _data55_->save_dialog;
		_tmp34_ = articleName;
		_tmp35_ = map;
		_tmp36_ = mimeType;
		_tmp37_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp35_, _tmp36_);
		_tmp38_ = (gchar*) _tmp37_;
		_tmp39_ = g_strconcat (_tmp34_, _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp33_, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_tmp41_ = _data55_->save_dialog;
		_tmp42_ = filter;
		gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp41_, _tmp42_);
		_tmp43_ = _data55_->save_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp43_, "response", (GCallback) ____lambda359__gtk_dialog_response, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
		_tmp44_ = _data55_->save_dialog;
		gtk_widget_show ((GtkWidget*) _tmp44_);
		_g_object_unref0 (map);
		_g_object_unref0 (filter);
		_g_free0 (mimeType);
		_g_object_unref0 (_tmp13_);
		_g_free0 (articleID);
		_g_free0 (articleName);
		block55_data_unref (_data55_);
		_data55_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		_tmp47_ = g_strdup_printf ("Utils.saveImageDialog: %s", _tmp46_);
		_tmp48_ = _tmp47_;
		feed_reader_logger_error (_tmp48_);
		_g_free0 (_tmp48_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender,
                                   gpointer self)
{
	gtk_main_quit ();
}

void
feed_reader_utils_playMedia (gchar** args,
                             gint args_length1,
                             const gchar* url)
{
	GtkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkHeaderBar* header = NULL;
	GtkHeaderBar* _tmp1_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp2_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp4_;
	FeedReaderMediaPlayer* player = NULL;
	FeedReaderMediaPlayer* _tmp5_;
	g_return_if_fail (url != NULL);
	gtk_init ((gint*) (&args_length1), &args);
	gst_init ((gint*) (&args_length1), &args);
	feed_reader_logger_init (TRUE);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	gtk_widget_set_size_request ((GtkWidget*) window, 800, 600);
	g_signal_connect ((GtkWidget*) window, "destroy", (GCallback) _gtk_main_quit_gtk_widget_destroy, NULL);
	_tmp1_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp1_);
	header = _tmp1_;
	gtk_header_bar_set_show_close_button (header, TRUE);
	_tmp2_ = gtk_css_provider_new ();
	provider = _tmp2_;
	gtk_css_provider_load_from_resource (provider, "/org/gnome/FeedReader/gtk-css/basics.css");
	_tmp3_ = gdk_display_get_default ();
	display = _tmp3_;
	_tmp4_ = gdk_display_get_default_screen (display);
	screen = _tmp4_;
	gtk_style_context_add_provider_for_screen (screen, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp5_ = feed_reader_media_player_new (url);
	g_object_ref_sink (_tmp5_);
	player = _tmp5_;
	gtk_container_add ((GtkContainer*) window, (GtkWidget*) player);
	gtk_window_set_titlebar (window, (GtkWidget*) header);
	gtk_widget_show_all ((GtkWidget*) window);
	gtk_main ();
	_g_object_unref0 (player);
	_g_object_unref0 (provider);
	_g_object_unref0 (header);
	_g_object_unref0 (window);
}

GtkImage*
feed_reader_utils_checkIcon (const gchar* name,
                             const gchar* fallback,
                             GtkIconSize size)
{
	GtkImage* icon = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	gboolean _tmp3_;
	GtkImage* result;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (fallback != NULL, NULL);
	icon = NULL;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = gtk_icon_theme_lookup_icon (_tmp0_, name, 0, GTK_ICON_LOOKUP_FORCE_SVG);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GtkImage* _tmp4_;
		_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name (name, (GtkIconSize) size);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (icon);
		icon = _tmp4_;
	} else {
		GtkImage* _tmp5_;
		_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name (fallback, (GtkIconSize) size);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (icon);
		icon = _tmp5_;
	}
	result = icon;
	return result;
}

void
feed_reader_utils_openInGedit (const gchar* text)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (text != NULL);
	{
		gchar* filename = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		FeedReaderMainWindow* _tmp2_;
		FeedReaderMainWindow* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = g_strdup ("file:///tmp/FeedReader_crashed_html.txt");
		filename = _tmp0_;
		_tmp1_ = filename;
		g_file_set_contents (_tmp1_, text, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			goto __catch0_g_error;
		}
		_tmp2_ = feed_reader_main_window_get_default ();
		_tmp3_ = _tmp2_;
		_tmp4_ = filename;
		gtk_show_uri_on_window ((GtkWindow*) _tmp3_, _tmp4_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			goto __catch0_g_error;
		}
		_g_free0 (filename);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("Utils.openInGedit(): %s", _tmp6_);
		_tmp8_ = _tmp7_;
		feed_reader_logger_error (_tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

guint
feed_reader_utils_getRelevantArticles (void)
{
	FeedReaderInterfaceState* interfacestate = NULL;
	FeedReaderMainWindow* _tmp0_;
	FeedReaderMainWindow* _tmp1_;
	FeedReaderInterfaceState* _tmp2_;
	FeedReaderInterfaceState* _tmp3_;
	gchar** selectedRow = NULL;
	FeedReaderInterfaceState* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint selectedRow_length1;
	gint _selectedRow_size_;
	FeedReaderArticleListState state = 0;
	FeedReaderInterfaceState* _tmp10_;
	gchar* searchTerm = NULL;
	FeedReaderInterfaceState* _tmp11_;
	gchar* _tmp12_;
	gchar* topRow = NULL;
	FeedReaderInterfaceState* _tmp13_;
	gchar* _tmp14_;
	FeedReaderFeedListType IDtype = 0;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GQuark _tmp27_ = 0U;
	static GQuark _tmp26_label0 = 0;
	static GQuark _tmp26_label1 = 0;
	static GQuark _tmp26_label2 = 0;
	gint count = 0;
	const gchar* _tmp28_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	guint result;
	_tmp0_ = feed_reader_main_window_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_main_window_getInterfaceState (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	interfacestate = _tmp3_;
	_tmp4_ = interfacestate;
	_tmp5_ = feed_reader_interface_state_getFeedListSelectedRow (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 2);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_g_free0 (_tmp6_);
	selectedRow = _tmp9_;
	selectedRow_length1 = _tmp9__length1;
	_selectedRow_size_ = selectedRow_length1;
	_tmp10_ = interfacestate;
	state = feed_reader_interface_state_getArticleListState (_tmp10_);
	_tmp11_ = interfacestate;
	_tmp12_ = feed_reader_interface_state_getSearchTerm (_tmp11_);
	searchTerm = _tmp12_;
	_tmp13_ = interfacestate;
	_tmp14_ = feed_reader_interface_state_getArticleListTopRow (_tmp13_);
	topRow = _tmp14_;
	IDtype = FEED_READER_FEED_LIST_TYPE_FEED;
	_tmp15_ = selectedRow;
	_tmp15__length1 = selectedRow_length1;
	_tmp16_ = _tmp15_[0];
	_tmp17_ = g_strdup_printf ("selectedRow 0: %s", _tmp16_);
	_tmp18_ = _tmp17_;
	feed_reader_logger_debug (_tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = selectedRow;
	_tmp19__length1 = selectedRow_length1;
	_tmp20_ = _tmp19_[1];
	_tmp21_ = g_strdup_printf ("selectedRow 1: %s", _tmp20_);
	_tmp22_ = _tmp21_;
	feed_reader_logger_debug (_tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = selectedRow;
	_tmp23__length1 = selectedRow_length1;
	_tmp24_ = _tmp23_[0];
	_tmp25_ = _tmp24_;
	_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
	if (_tmp27_ == ((0 != _tmp26_label0) ? _tmp26_label0 : (_tmp26_label0 = g_quark_from_static_string ("feed")))) {
		switch (0) {
			default:
			{
				IDtype = FEED_READER_FEED_LIST_TYPE_FEED;
				break;
			}
		}
	} else if (_tmp27_ == ((0 != _tmp26_label1) ? _tmp26_label1 : (_tmp26_label1 = g_quark_from_static_string ("cat")))) {
		switch (0) {
			default:
			{
				IDtype = FEED_READER_FEED_LIST_TYPE_CATEGORY;
				break;
			}
		}
	} else if (_tmp27_ == ((0 != _tmp26_label2) ? _tmp26_label2 : (_tmp26_label2 = g_quark_from_static_string ("tag")))) {
		switch (0) {
			default:
			{
				IDtype = FEED_READER_FEED_LIST_TYPE_TAG;
				break;
			}
		}
	}
	count = 0;
	_tmp28_ = topRow;
	if (_tmp28_ != NULL) {
		FeedReaderDataBaseReadOnly* _tmp29_;
		FeedReaderDataBaseReadOnly* _tmp30_;
		const gchar* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp29_ = feed_reader_data_base_readOnly ();
		_tmp30_ = _tmp29_;
		_tmp31_ = topRow;
		_tmp32_ = selectedRow;
		_tmp32__length1 = selectedRow_length1;
		_tmp33_ = _tmp32_[1];
		_tmp34_ = searchTerm;
		count = feed_reader_data_base_read_only_getArticleCountNewerThanID (_tmp30_, _tmp31_, _tmp33_, IDtype, state, _tmp34_);
		_g_object_unref0 (_tmp30_);
	}
	_tmp35_ = g_strdup_printf ("%i", count);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat ("getRelevantArticles: ", _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	feed_reader_logger_debug (_tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	result = (guint) count;
	_g_free0 (topRow);
	_g_free0 (searchTerm);
	selectedRow = (_vala_array_free (selectedRow, selectedRow_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (interfacestate);
	return result;
}

FeedReaderUtils*
feed_reader_utils_construct (GType object_type)
{
	FeedReaderUtils * self = NULL;
	self = (FeedReaderUtils*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderUtils*
feed_reader_utils_new (void)
{
	return feed_reader_utils_construct (FEED_READER_TYPE_UTILS);
}

static void
feed_reader_utils_class_init (FeedReaderUtilsClass * klass,
                              gpointer klass_data)
{
	feed_reader_utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_utils_finalize;
}

static void
feed_reader_utils_instance_init (FeedReaderUtils * self,
                                 gpointer klass)
{
}

static void
feed_reader_utils_finalize (GObject * obj)
{
	FeedReaderUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_UTILS, FeedReaderUtils);
	G_OBJECT_CLASS (feed_reader_utils_parent_class)->finalize (obj);
}

static GType
feed_reader_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderUtils), 0, (GInstanceInitFunc) feed_reader_utils_instance_init, NULL };
	GType feed_reader_utils_type_id;
	feed_reader_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedReaderUtils", &g_define_type_info, 0);
	return feed_reader_utils_type_id;
}

GType
feed_reader_utils_get_type (void)
{
	static volatile gsize feed_reader_utils_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_utils_type_id__once)) {
		GType feed_reader_utils_type_id;
		feed_reader_utils_type_id = feed_reader_utils_get_type_once ();
		g_once_init_leave (&feed_reader_utils_type_id__once, feed_reader_utils_type_id);
	}
	return feed_reader_utils_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

