/* ArticleListBox.c generated by valac 0.56.3, the Vala compiler
 * generated from ArticleListBox.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General public License for more details.*/
/**/
/*You should have received a copy of the GNU General public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

enum  {
	FEED_READER_ARTICLE_LIST_BOX_0_PROPERTY,
	FEED_READER_ARTICLE_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* feed_reader_article_list_box_properties[FEED_READER_ARTICLE_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block45Data Block45Data;
typedef struct _Block46Data Block46Data;
typedef struct _Block47Data Block47Data;
typedef struct _Block48Data Block48Data;
typedef struct _Block49Data Block49Data;
typedef struct _Block50Data Block50Data;
enum  {
	FEED_READER_ARTICLE_LIST_BOX_BALANCE_NEXT_SCROLL_SIGNAL,
	FEED_READER_ARTICLE_LIST_BOX_LOAD_DONE_SIGNAL,
	FEED_READER_ARTICLE_LIST_BOX_NUM_SIGNALS
};
static guint feed_reader_article_list_box_signals[FEED_READER_ARTICLE_LIST_BOX_NUM_SIGNALS] = {0};

struct _FeedReaderArticleListBoxPrivate {
	GeeList* m_lazyQeue;
	guint m_idleID;
	gchar* m_name;
	guint m_selectSourceID;
	FeedReaderArticleListState m_state;
	FeedReaderFeedListType m_selectedFeedListType;
	gchar* m_selectedFeedListID;
	gchar* m_selectedArticle;
	GeeHashMap* m_articles;
	GeeHashSet* m_visibleArticles;
};

struct _Block45Data {
	int _ref_count_;
	FeedReaderArticleListBox* self;
	FeedReaderArticleListBalance balance;
	gboolean reverse;
	gboolean animate;
};

struct _Block46Data {
	int _ref_count_;
	Block45Data * _data45_;
	FeedReaderArticle* item;
};

struct _Block47Data {
	int _ref_count_;
	FeedReaderArticleListBox* self;
	FeedReaderArticleRow* row;
};

struct _Block48Data {
	int _ref_count_;
	FeedReaderArticleListBox* self;
	FeedReaderArticleRow* row;
};

struct _Block49Data {
	int _ref_count_;
	FeedReaderArticleListBox* self;
	GeeHashSet* invisibleRows;
	GeeHashSet* visibleArticles;
};

struct _Block50Data {
	int _ref_count_;
	FeedReaderArticleListBox* self;
	GeeLinkedList* tmp;
};

static gint FeedReaderArticleListBox_private_offset;
static gpointer feed_reader_article_list_box_parent_class = NULL;

static void feed_reader_article_list_box_rowActivated (FeedReaderArticleListBox* self,
                                                GtkListBoxRow* row);
static void _feed_reader_article_list_box_rowActivated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                            GtkListBoxRow* row,
                                                                            gpointer self);
static gboolean feed_reader_article_list_box_stopLoading (FeedReaderArticleListBox* self);
static void feed_reader_article_list_box_setPos (FeedReaderArticleListBox* self,
                                          GeeList* articles,
                                          gint pos);
static void feed_reader_article_list_box_addRow (FeedReaderArticleListBox* self,
                                          FeedReaderArticleListBalance balance,
                                          gboolean reverse,
                                          gboolean animate);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static gboolean __lambda189_ (Block45Data* _data45_);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static void feed_reader_article_list_box_checkQueue (FeedReaderArticleListBox* self,
                                              FeedReaderArticle* item,
                                              FeedReaderArticleListBalance balance,
                                              gboolean reverse,
                                              gboolean animate);
static void feed_reader_article_list_box_rowStateChanged (FeedReaderArticleListBox* self,
                                                   FeedReaderArticleStatus status);
static void _feed_reader_article_list_box_rowStateChanged_feed_reader_article_row_row_state_changed (FeedReaderArticleRow* _sender,
                                                                                              FeedReaderArticleStatus status,
                                                                                              gpointer self);
static void __lambda191_ (FeedReaderArticleListBox* self,
                   GtkWidget* widget,
                   GdkDragContext* context);
static void feed_reader_article_list_box_highlightRow (FeedReaderArticleListBox* self,
                                                const gchar* articleID);
static void ___lambda191__gtk_widget_drag_begin (GtkWidget* _sender,
                                          GdkDragContext* context,
                                          gpointer self);
static void __lambda192_ (FeedReaderArticleListBox* self,
                   GtkWidget* widget,
                   GdkDragContext* context);
static void feed_reader_article_list_box_unHighlightRow (FeedReaderArticleListBox* self);
static void ___lambda192__gtk_widget_drag_end (GtkWidget* _sender,
                                        GdkDragContext* context,
                                        gpointer self);
static gboolean __lambda193_ (FeedReaderArticleListBox* self,
                       GdkDragContext* context,
                       GtkDragResult _result_);
static gboolean ___lambda193__gtk_widget_drag_failed (GtkWidget* _sender,
                                               GdkDragContext* context,
                                               GtkDragResult _result_,
                                               gpointer self);
static void __lambda194_ (Block46Data* _data46_);
static void ___lambda194__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self);
static gboolean ___lambda189__gsource_func (gpointer self);
static gboolean ___lambda190_ (FeedReaderArticleListBox* self);
static gboolean ____lambda190__gsource_func (gpointer self);
static void feed_reader_article_list_box_selectAfter (FeedReaderArticleListBox* self,
                                               FeedReaderArticleRow* row,
                                               gint time);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static void feed_reader_article_list_box_setRead (FeedReaderArticleListBox* self,
                                           FeedReaderArticleRow* row);
static gboolean __lambda197_ (Block47Data* _data47_);
static gboolean ___lambda197__gsource_func (gpointer self);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static gboolean __lambda187_ (Block48Data* _data48_);
static gboolean ___lambda187__gsource_func (gpointer self);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static gboolean __lambda186_ (Block49Data* _data49_,
                       gchar* id);
static gboolean ___lambda186__gee_forall_func (gpointer g,
                                        gpointer self);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static gboolean __lambda238_ (Block50Data* _data50_,
                       GeeMapEntry* entry);
static gboolean ___lambda238__gee_forall_func (gpointer g,
                                        gpointer self);
static void feed_reader_article_list_box_finalize (GObject * obj);
static GType feed_reader_article_list_box_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_article_list_box_get_instance_private (FeedReaderArticleListBox* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderArticleListBox_private_offset);
}

static void
_feed_reader_article_list_box_rowActivated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self)
{
	feed_reader_article_list_box_rowActivated ((FeedReaderArticleListBox*) self, row);
}

FeedReaderArticleListBox*
feed_reader_article_list_box_construct (GType object_type,
                                        const gchar* name)
{
	FeedReaderArticleListBox * self = NULL;
	gchar* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashSet* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (FeedReaderArticleListBox*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->m_name);
	self->priv->m_name = _tmp0_;
	_tmp1_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_lazyQeue);
	self->priv->m_lazyQeue = (GeeList*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FEED_READER_TYPE_ARTICLE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_articles);
	self->priv->m_articles = _tmp2_;
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->m_visibleArticles);
	self->priv->m_visibleArticles = _tmp3_;
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_BROWSE);
	g_signal_connect_object ((GtkListBox*) self, "row-activated", (GCallback) _feed_reader_article_list_box_rowActivated_gtk_list_box_row_activated, self, 0);
	return self;
}

FeedReaderArticleListBox*
feed_reader_article_list_box_new (const gchar* name)
{
	return feed_reader_article_list_box_construct (FEED_READER_TYPE_ARTICLE_LIST_BOX, name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
feed_reader_article_list_box_newList (FeedReaderArticleListBox* self,
                                      GeeList* articles)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	feed_reader_article_list_box_stopLoading (self);
	feed_reader_article_list_box_emptyList (self);
	feed_reader_article_list_box_setPos (self, articles, -1);
	_tmp0_ = _g_object_ref0 (articles);
	_g_object_unref0 (self->priv->m_lazyQeue);
	self->priv->m_lazyQeue = _tmp0_;
	feed_reader_article_list_box_addRow (self, FEED_READER_ARTICLE_LIST_BALANCE_NONE, FALSE, FALSE);
}

void
feed_reader_article_list_box_addTop (FeedReaderArticleListBox* self,
                                     GeeList* articles)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	feed_reader_article_list_box_stopLoading (self);
	feed_reader_article_list_box_setPos (self, articles, 0);
	_tmp0_ = _g_object_ref0 (articles);
	_g_object_unref0 (self->priv->m_lazyQeue);
	self->priv->m_lazyQeue = _tmp0_;
	feed_reader_article_list_box_addRow (self, FEED_READER_ARTICLE_LIST_BALANCE_TOP, TRUE, FALSE);
}

void
feed_reader_article_list_box_addBottom (FeedReaderArticleListBox* self,
                                        GeeList* articles)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	feed_reader_article_list_box_stopLoading (self);
	feed_reader_article_list_box_setPos (self, articles, -1);
	_tmp0_ = _g_object_ref0 (articles);
	_g_object_unref0 (self->priv->m_lazyQeue);
	self->priv->m_lazyQeue = _tmp0_;
	feed_reader_article_list_box_addRow (self, FEED_READER_ARTICLE_LIST_BALANCE_NONE, FALSE, FALSE);
}

static gboolean
feed_reader_article_list_box_stopLoading (FeedReaderArticleListBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->m_idleID > ((guint) 0)) {
		g_source_remove (self->priv->m_idleID);
		self->priv->m_idleID = (guint) 0;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
feed_reader_article_list_box_setPos (FeedReaderArticleListBox* self,
                                     GeeList* articles,
                                     gint pos)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	{
		GeeList* _a_list = NULL;
		gint _a_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _a_index = 0;
		_a_list = articles;
		_tmp0_ = _a_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_a_size = _tmp2_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FeedReaderArticle* a = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			FeedReaderArticle* _tmp7_;
			_a_index = _a_index + 1;
			_tmp3_ = _a_index;
			_tmp4_ = _a_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _a_list;
			_tmp6_ = gee_list_get (_tmp5_, _a_index);
			a = (FeedReaderArticle*) _tmp6_;
			_tmp7_ = a;
			feed_reader_article_setPos (_tmp7_, pos);
			_g_object_unref0 (a);
		}
	}
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		FeedReaderArticleListBox* self;
		self = _data45_->self;
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		FeedReaderArticleListBox* self;
		self = _data46_->_data45_->self;
		_g_object_unref0 (_data46_->item);
		block45_data_unref (_data46_->_data45_);
		_data46_->_data45_ = NULL;
		g_slice_free (Block46Data, _data46_);
	}
}

static void
_feed_reader_article_list_box_rowStateChanged_feed_reader_article_row_row_state_changed (FeedReaderArticleRow* _sender,
                                                                                         FeedReaderArticleStatus status,
                                                                                         gpointer self)
{
	feed_reader_article_list_box_rowStateChanged ((FeedReaderArticleListBox*) self, status);
}

static void
__lambda191_ (FeedReaderArticleListBox* self,
              GtkWidget* widget,
              GdkDragContext* context)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = feed_reader_article_row_getID (FEED_READER_IS_ARTICLE_ROW (widget) ? ((FeedReaderArticleRow*) widget) : NULL);
	_tmp1_ = _tmp0_;
	feed_reader_article_list_box_highlightRow (self, _tmp1_);
	_g_free0 (_tmp1_);
	g_signal_emit_by_name ((GtkWidget*) self, "drag-begin", context);
}

static void
___lambda191__gtk_widget_drag_begin (GtkWidget* _sender,
                                     GdkDragContext* context,
                                     gpointer self)
{
	__lambda191_ ((FeedReaderArticleListBox*) self, _sender, context);
}

static void
__lambda192_ (FeedReaderArticleListBox* self,
              GtkWidget* widget,
              GdkDragContext* context)
{
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	feed_reader_article_list_box_unHighlightRow (self);
	g_signal_emit_by_name ((GtkWidget*) self, "drag-end", context);
}

static void
___lambda192__gtk_widget_drag_end (GtkWidget* _sender,
                                   GdkDragContext* context,
                                   gpointer self)
{
	__lambda192_ ((FeedReaderArticleListBox*) self, _sender, context);
}

static gboolean
__lambda193_ (FeedReaderArticleListBox* self,
              GdkDragContext* context,
              GtkDragResult _result_)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	g_signal_emit_by_name ((GtkWidget*) self, "drag-failed", context, _result_, &_tmp0_);
	result = FALSE;
	return result;
}

static gboolean
___lambda193__gtk_widget_drag_failed (GtkWidget* _sender,
                                      GdkDragContext* context,
                                      GtkDragResult _result_,
                                      gpointer self)
{
	gboolean result;
	result = __lambda193_ ((FeedReaderArticleListBox*) self, context, _result_);
	return result;
}

static void
__lambda194_ (Block46Data* _data46_)
{
	Block45Data* _data45_;
	FeedReaderArticleListBox* self;
	FeedReaderArticle* _tmp0_;
	_data45_ = _data46_->_data45_;
	self = _data45_->self;
	_tmp0_ = _data46_->item;
	feed_reader_article_list_box_checkQueue (self, _tmp0_, _data45_->balance, _data45_->reverse, _data45_->animate);
}

static void
___lambda194__gtk_widget_realize (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda194_ (self);
}

static gboolean
__lambda189_ (Block45Data* _data45_)
{
	FeedReaderArticleListBox* self;
	Block46Data* _data46_;
	gboolean _tmp0_ = FALSE;
	GeeList* _tmp1_;
	GeeHashMap* _tmp9_;
	FeedReaderArticle* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	FeedReaderArticleRow* newRow = NULL;
	FeedReaderArticle* _tmp24_;
	FeedReaderArticleRow* _tmp25_;
	FeedReaderArticleRow* _tmp26_;
	FeedReaderArticleRow* _tmp27_;
	FeedReaderArticleRow* _tmp28_;
	FeedReaderArticleRow* _tmp29_;
	FeedReaderArticleRow* _tmp30_;
	GeeHashMap* _tmp31_;
	FeedReaderArticle* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	FeedReaderArticleRow* _tmp35_;
	FeedReaderArticleRow* _tmp36_;
	FeedReaderArticle* _tmp37_;
	gboolean result;
	self = _data45_->self;
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->_data45_ = block45_data_ref (_data45_);
	_tmp1_ = self->priv->m_lazyQeue;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->m_lazyQeue;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		block46_data_unref (_data46_);
		_data46_ = NULL;
		return result;
	}
	if (_data45_->reverse) {
		GeeList* _tmp5_;
		gpointer _tmp6_;
		_tmp5_ = self->priv->m_lazyQeue;
		_tmp6_ = gee_list_last (_tmp5_);
		_g_object_unref0 (_data46_->item);
		_data46_->item = (FeedReaderArticle*) _tmp6_;
	} else {
		GeeList* _tmp7_;
		gpointer _tmp8_;
		_tmp7_ = self->priv->m_lazyQeue;
		_tmp8_ = gee_list_first (_tmp7_);
		_g_object_unref0 (_data46_->item);
		_data46_->item = (FeedReaderArticle*) _tmp8_;
	}
	_tmp9_ = self->priv->m_articles;
	_tmp10_ = _data46_->item;
	_tmp11_ = feed_reader_article_getArticleID (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	if (_tmp13_) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FeedReaderArticle* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		FeedReaderArticle* _tmp23_;
		_tmp14_ = self->priv->m_name;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("ArticleListbox", _tmp15_, ": row with ID %s is already present", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = _data46_->item;
		_tmp19_ = feed_reader_article_getArticleID (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf (_tmp17_, _tmp20_);
		_tmp22_ = _tmp21_;
		feed_reader_logger_debug (_tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_tmp23_ = _data46_->item;
		feed_reader_article_list_box_checkQueue (self, _tmp23_, _data45_->balance, _data45_->reverse, _data45_->animate);
		result = FALSE;
		block46_data_unref (_data46_);
		_data46_ = NULL;
		return result;
	}
	g_signal_emit (self, feed_reader_article_list_box_signals[FEED_READER_ARTICLE_LIST_BOX_BALANCE_NEXT_SCROLL_SIGNAL], 0, _data45_->balance);
	_tmp24_ = _data46_->item;
	_tmp25_ = feed_reader_article_row_new (_tmp24_);
	g_object_ref_sink (_tmp25_);
	newRow = _tmp25_;
	_tmp26_ = newRow;
	g_signal_connect_object (_tmp26_, "row-state-changed", (GCallback) _feed_reader_article_list_box_rowStateChanged_feed_reader_article_row_row_state_changed, self, 0);
	_tmp27_ = newRow;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "drag-begin", (GCallback) ___lambda191__gtk_widget_drag_begin, self, 0);
	_tmp28_ = newRow;
	g_signal_connect_object ((GtkWidget*) _tmp28_, "drag-end", (GCallback) ___lambda192__gtk_widget_drag_end, self, 0);
	_tmp29_ = newRow;
	g_signal_connect_object ((GtkWidget*) _tmp29_, "drag-failed", (GCallback) ___lambda193__gtk_widget_drag_failed, self, 0);
	_tmp30_ = newRow;
	g_signal_connect_data ((GtkWidget*) _tmp30_, "realize", (GCallback) ___lambda194__gtk_widget_realize, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_tmp31_ = self->priv->m_articles;
	_tmp32_ = _data46_->item;
	_tmp33_ = feed_reader_article_getArticleID (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = newRow;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp34_, _tmp35_);
	_g_free0 (_tmp34_);
	_tmp36_ = newRow;
	_tmp37_ = _data46_->item;
	gtk_list_box_insert ((GtkListBox*) self, (GtkWidget*) _tmp36_, feed_reader_article_getPos (_tmp37_));
	if (_data45_->animate) {
		FeedReaderArticleRow* _tmp38_;
		_tmp38_ = newRow;
		feed_reader_article_row_reveal (_tmp38_, TRUE, (guint) 150);
	} else {
		FeedReaderArticleRow* _tmp39_;
		_tmp39_ = newRow;
		feed_reader_article_row_reveal (_tmp39_, TRUE, (guint) 0);
	}
	result = FALSE;
	_g_object_unref0 (newRow);
	block46_data_unref (_data46_);
	_data46_ = NULL;
	return result;
}

static gboolean
___lambda189__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda189_ (self);
	return result;
}

static void
feed_reader_article_list_box_addRow (FeedReaderArticleListBox* self,
                                     FeedReaderArticleListBalance balance,
                                     gboolean reverse,
                                     gboolean animate)
{
	Block45Data* _data45_;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint priority = 0;
	FeedReaderColumnView* _tmp7_;
	FeedReaderColumnView* _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_data45_ = g_slice_new0 (Block45Data);
	_data45_->_ref_count_ = 1;
	_data45_->self = g_object_ref (self);
	_data45_->balance = balance;
	_data45_->reverse = reverse;
	_data45_->animate = animate;
	_tmp0_ = self->priv->m_lazyQeue;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->priv->m_name;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("ArticleListbox", _tmp4_, ": lazyQueu == 0 -> return", NULL);
		_tmp6_ = _tmp5_;
		feed_reader_logger_debug (_tmp6_);
		_g_free0 (_tmp6_);
		block45_data_unref (_data45_);
		_data45_ = NULL;
		return;
	}
	priority = G_PRIORITY_DEFAULT_IDLE;
	_tmp7_ = feed_reader_column_view_get_default ();
	_tmp8_ = _tmp7_;
	_tmp9_ = feed_reader_column_view_playingMedia (_tmp8_);
	_g_object_unref0 (_tmp8_);
	if (_tmp9_) {
		priority = G_PRIORITY_HIGH_IDLE;
	}
	self->priv->m_idleID = g_idle_add_full (priority, ___lambda189__gsource_func, block45_data_ref (_data45_), block45_data_unref);
	block45_data_unref (_data45_);
	_data45_ = NULL;
}

static gboolean
___lambda190_ (FeedReaderArticleListBox* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	_tmp0_ = self->priv->m_name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("ArticleListbox", _tmp1_, ": loadDone()", NULL);
	_tmp3_ = _tmp2_;
	feed_reader_logger_debug (_tmp3_);
	_g_free0 (_tmp3_);
	g_signal_emit (self, feed_reader_article_list_box_signals[FEED_READER_ARTICLE_LIST_BOX_LOAD_DONE_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
____lambda190__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda190_ ((FeedReaderArticleListBox*) self);
	return result;
}

static void
feed_reader_article_list_box_checkQueue (FeedReaderArticleListBox* self,
                                         FeedReaderArticle* item,
                                         FeedReaderArticleListBalance balance,
                                         gboolean reverse,
                                         gboolean animate)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->m_lazyQeue;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 1) {
		GeeList* _tmp3_;
		_tmp3_ = self->priv->m_lazyQeue;
		gee_collection_remove ((GeeCollection*) _tmp3_, item);
		feed_reader_article_list_box_addRow (self, balance, reverse, animate);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GeeLinkedList* _tmp8_;
		_tmp4_ = self->priv->m_name;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("ArticleListbox", _tmp5_, ": all articles added to the list", NULL);
		_tmp7_ = _tmp6_;
		feed_reader_logger_debug (_tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->m_lazyQeue);
		self->priv->m_lazyQeue = (GeeList*) _tmp8_;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ____lambda190__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->m_idleID = (guint) 0;
	}
}

void
feed_reader_article_list_box_emptyList (FeedReaderArticleListBox* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* row = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) row_it->data);
			row = _tmp2_;
			{
				GtkWidget* _tmp3_;
				GtkWidget* _tmp4_;
				_tmp3_ = row;
				gtk_container_remove ((GtkContainer*) self, _tmp3_);
				_tmp4_ = row;
				gtk_widget_destroy (_tmp4_);
				_g_object_unref0 (row);
			}
		}
	}
	_tmp5_ = self->priv->m_articles;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp5_);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

void
feed_reader_article_list_box_setSelectedFeed (FeedReaderArticleListBox* self,
                                              const gchar* feedID)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = g_strdup (feedID);
	_g_free0 (self->priv->m_selectedFeedListID);
	self->priv->m_selectedFeedListID = _tmp0_;
}

void
feed_reader_article_list_box_setSelectedType (FeedReaderArticleListBox* self,
                                              FeedReaderFeedListType type)
{
	g_return_if_fail (self != NULL);
	self->priv->m_selectedFeedListType = type;
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		FeedReaderArticleListBox* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->row);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static gboolean
__lambda197_ (Block47Data* _data47_)
{
	FeedReaderArticleListBox* self;
	FeedReaderColumnView* _tmp0_;
	FeedReaderColumnView* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data47_->self;
	_tmp0_ = feed_reader_column_view_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = !feed_reader_column_view_searchFocused (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		g_signal_emit_by_name ((GtkListBoxRow*) _data47_->row, "activate");
	}
	self->priv->m_selectSourceID = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda197__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda197_ (self);
	return result;
}

static void
feed_reader_article_list_box_selectAfter (FeedReaderArticleListBox* self,
                                          FeedReaderArticleRow* row,
                                          gint time)
{
	Block47Data* _data47_;
	FeedReaderArticleRow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (_data47_->row);
	_data47_->row = _tmp0_;
	gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _data47_->row);
	feed_reader_article_list_box_setRead (self, _data47_->row);
	if (self->priv->m_selectSourceID > ((guint) 0)) {
		g_source_remove (self->priv->m_selectSourceID);
		self->priv->m_selectSourceID = (guint) 0;
	}
	self->priv->m_selectSourceID = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) time, ___lambda197__gsource_func, block47_data_ref (_data47_), block47_data_unref);
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

static void
feed_reader_article_list_box_setRead (FeedReaderArticleListBox* self,
                                      FeedReaderArticleRow* row)
{
	FeedReaderArticle* _tmp0_;
	FeedReaderArticle* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = feed_reader_article_row_getArticle (row);
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_article_getUnread (_tmp1_) == FEED_READER_ARTICLE_STATUS_UNREAD;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		FeedReaderFeedReaderBackend* _tmp3_;
		FeedReaderFeedReaderBackend* _tmp4_;
		FeedReaderArticle* _tmp5_;
		FeedReaderArticle* _tmp6_;
		feed_reader_article_row_updateUnread (row, FEED_READER_ARTICLE_STATUS_READ);
		_tmp3_ = feed_reader_feed_reader_backend_get_default ();
		_tmp4_ = _tmp3_;
		_tmp5_ = feed_reader_article_row_getArticle (row);
		_tmp6_ = _tmp5_;
		feed_reader_feed_reader_backend_updateArticleRead (_tmp4_, _tmp6_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
	}
}

FeedReaderArticleStatus
feed_reader_article_list_box_toggleReadSelected (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	FeedReaderArticleRow* _tmp2_;
	FeedReaderArticleRow* _tmp3_;
	FeedReaderArticleStatus result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = selectedRow;
	if (_tmp2_ == NULL) {
		result = FEED_READER_ARTICLE_STATUS_READ;
		_g_object_unref0 (selectedRow);
		return result;
	}
	_tmp3_ = selectedRow;
	result = feed_reader_article_row_toggleUnread (_tmp3_);
	_g_object_unref0 (selectedRow);
	return result;
}

FeedReaderArticleStatus
feed_reader_article_list_box_toggleMarkedSelected (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	FeedReaderArticleRow* _tmp2_;
	FeedReaderArticleRow* _tmp3_;
	FeedReaderArticleStatus result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = selectedRow;
	if (_tmp2_ == NULL) {
		result = FEED_READER_ARTICLE_STATUS_UNMARKED;
		_g_object_unref0 (selectedRow);
		return result;
	}
	_tmp3_ = selectedRow;
	result = feed_reader_article_row_toggleMarked (_tmp3_);
	_g_object_unref0 (selectedRow);
	return result;
}

void
feed_reader_article_list_box_setState (FeedReaderArticleListBox* self,
                                       FeedReaderArticleListState state)
{
	g_return_if_fail (self != NULL);
	self->priv->m_state = state;
}

FeedReaderArticle*
feed_reader_article_list_box_getSelectedArticle (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	FeedReaderArticleRow* _tmp2_;
	FeedReaderArticle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = selectedRow;
	if (_tmp2_ != NULL) {
		FeedReaderArticleRow* _tmp3_;
		FeedReaderArticle* _tmp4_;
		_tmp3_ = selectedRow;
		_tmp4_ = feed_reader_article_row_getArticle (_tmp3_);
		result = _tmp4_;
		_g_object_unref0 (selectedRow);
		return result;
	}
	result = NULL;
	_g_object_unref0 (selectedRow);
	return result;
}

gchar*
feed_reader_article_list_box_getSelectedURL (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	FeedReaderArticleRow* _tmp2_;
	GList* _tmp5_;
	GList* _tmp6_;
	gboolean _tmp7_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = selectedRow;
	if (_tmp2_ != NULL) {
		FeedReaderArticleRow* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = selectedRow;
		_tmp4_ = feed_reader_article_row_getURL (_tmp3_);
		result = _tmp4_;
		_g_object_unref0 (selectedRow);
		return result;
	}
	_tmp5_ = gtk_container_get_children ((GtkContainer*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_list_length (_tmp6_) == ((guint) 0);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (g_list_free (_tmp6_), NULL));
	if (_tmp7_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("empty");
		result = _tmp8_;
		_g_object_unref0 (selectedRow);
		return result;
	}
	_tmp9_ = g_strdup ("");
	result = _tmp9_;
	_g_object_unref0 (selectedRow);
	return result;
}

gint
feed_reader_article_list_box_move (FeedReaderArticleListBox* self,
                                   gboolean down)
{
	gint time = 0;
	FeedReaderArticle* sel = NULL;
	FeedReaderArticle* _tmp0_;
	FeedReaderArticle* _tmp1_;
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp5_;
	FeedReaderArticleRow* _tmp6_;
	gint height = 0;
	FeedReaderArticleRow* _tmp7_;
	FeedReaderArticleRow* nextRow = NULL;
	GList* rows = NULL;
	GList* _tmp8_;
	gint current = 0;
	GList* _tmp9_;
	FeedReaderArticleRow* _tmp10_;
	guint length = 0U;
	GList* _tmp11_;
	FeedReaderArticleRow* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	time = 300;
	_tmp0_ = feed_reader_article_list_box_getSelectedArticle (self);
	sel = _tmp0_;
	_tmp1_ = sel;
	if (_tmp1_ == NULL) {
		FeedReaderArticleRow* firstRow = NULL;
		FeedReaderArticleRow* _tmp2_;
		FeedReaderArticleRow* _tmp3_;
		_tmp2_ = feed_reader_article_list_box_getFirstRow (self);
		firstRow = _tmp2_;
		_tmp3_ = firstRow;
		if (_tmp3_ == NULL) {
			result = 0;
			_g_object_unref0 (firstRow);
			_g_object_unref0 (sel);
			return result;
		} else {
			FeedReaderArticleRow* _tmp4_;
			_tmp4_ = firstRow;
			feed_reader_article_list_box_selectAfter (self, _tmp4_, time);
			result = 0;
			_g_object_unref0 (firstRow);
			_g_object_unref0 (sel);
			return result;
		}
		_g_object_unref0 (firstRow);
	}
	_tmp5_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp6_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp5_) ? ((FeedReaderArticleRow*) _tmp5_) : NULL);
	selectedRow = _tmp6_;
	_tmp7_ = selectedRow;
	height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp7_);
	nextRow = NULL;
	_tmp8_ = gtk_container_get_children ((GtkContainer*) self);
	rows = _tmp8_;
	if (!down) {
		rows = g_list_reverse (rows);
	}
	_tmp9_ = rows;
	_tmp10_ = selectedRow;
	current = g_list_index (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = rows;
	length = g_list_length (_tmp11_);
	{
		gboolean _tmp12_ = FALSE;
		_tmp12_ = TRUE;
		while (TRUE) {
			gint _tmp14_;
			GList* _tmp15_;
			gconstpointer _tmp16_;
			GtkWidget* _tmp17_;
			FeedReaderArticleRow* _tmp18_;
			if (!_tmp12_) {
				FeedReaderArticleRow* _tmp13_;
				_tmp13_ = nextRow;
				if (!(!feed_reader_article_row_isBeingRevealed (_tmp13_))) {
					break;
				}
			}
			_tmp12_ = FALSE;
			_tmp14_ = current;
			current = _tmp14_ + 1;
			if (((guint) current) >= length) {
				result = 0;
				(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
				_g_object_unref0 (nextRow);
				_g_object_unref0 (selectedRow);
				_g_object_unref0 (sel);
				return result;
			}
			_tmp15_ = rows;
			_tmp16_ = g_list_nth_data (_tmp15_, (guint) current);
			_tmp17_ = (GtkWidget*) _tmp16_;
			_tmp18_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp17_) ? ((FeedReaderArticleRow*) _tmp17_) : NULL);
			_g_object_unref0 (nextRow);
			nextRow = _tmp18_;
		}
	}
	_tmp19_ = nextRow;
	feed_reader_article_list_box_selectAfter (self, _tmp19_, time);
	_tmp20_ = g_strdup_printf ("%i", height);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("ArticleListBox.move: height: ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	feed_reader_logger_debug (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	if (down) {
		result = height;
		(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
		_g_object_unref0 (nextRow);
		_g_object_unref0 (selectedRow);
		_g_object_unref0 (sel);
		return result;
	}
	result = -height;
	(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
	_g_object_unref0 (nextRow);
	_g_object_unref0 (selectedRow);
	_g_object_unref0 (sel);
	return result;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		FeedReaderArticleListBox* self;
		self = _data48_->self;
		_g_object_unref0 (_data48_->row);
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static gboolean
__lambda187_ (Block48Data* _data48_)
{
	FeedReaderArticleListBox* self;
	GtkContainer* _tmp0_;
	gboolean result;
	self = _data48_->self;
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) _data48_->row);
	if (_tmp0_ != NULL) {
		gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _data48_->row);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda187__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda187_ (self);
	return result;
}

void
feed_reader_article_list_box_removeRow (FeedReaderArticleListBox* self,
                                        FeedReaderArticleRow* row,
                                        gint animateDuration)
{
	Block48Data* _data48_;
	FeedReaderArticleRow* _tmp0_;
	gchar* id = NULL;
	gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	_data48_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (_data48_->row);
	_data48_->row = _tmp0_;
	_tmp1_ = feed_reader_article_row_getID (_data48_->row);
	id = _tmp1_;
	feed_reader_article_row_reveal (_data48_->row, FALSE, (guint) animateDuration);
	_tmp2_ = self->priv->m_articles;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, id, NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (animateDuration + 50), ___lambda187__gsource_func, block48_data_ref (_data48_), block48_data_unref);
	_g_free0 (id);
	block48_data_unref (_data48_);
	_data48_ = NULL;
}

static void
feed_reader_article_list_box_rowActivated (FeedReaderArticleListBox* self,
                                           GtkListBoxRow* row)
{
	FeedReaderArticleRow* selectedRow = NULL;
	FeedReaderArticleRow* _tmp0_;
	gchar* selectedID = NULL;
	FeedReaderArticleRow* _tmp1_;
	gchar* _tmp2_;
	FeedReaderArticleRow* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, FEED_READER_TYPE_ARTICLE_ROW, FeedReaderArticleRow));
	selectedRow = _tmp0_;
	_tmp1_ = selectedRow;
	_tmp2_ = feed_reader_article_row_getID (_tmp1_);
	selectedID = _tmp2_;
	_tmp3_ = selectedRow;
	feed_reader_article_list_box_setRead (self, _tmp3_);
	_tmp4_ = self->priv->m_selectedArticle;
	_tmp5_ = selectedID;
	if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
		gboolean _tmp6_ = FALSE;
		if (self->priv->m_state != FEED_READER_ARTICLE_LIST_STATE_ALL) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = self->priv->m_selectedFeedListType == FEED_READER_FEED_LIST_TYPE_TAG;
		}
		if (_tmp6_) {
			GList* articleChildList = NULL;
			GList* _tmp7_;
			GList* _tmp8_;
			_tmp7_ = gtk_container_get_children ((GtkContainer*) self);
			articleChildList = _tmp7_;
			_tmp8_ = articleChildList;
			{
				GList* r_collection = NULL;
				GList* r_it = NULL;
				r_collection = _tmp8_;
				for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
					GtkWidget* _tmp9_;
					GtkWidget* r = NULL;
					_tmp9_ = _g_object_ref0 ((GtkWidget*) r_it->data);
					r = _tmp9_;
					{
						FeedReaderArticleRow* tmpRow = NULL;
						GtkWidget* _tmp10_;
						FeedReaderArticleRow* _tmp11_;
						gboolean _tmp12_ = FALSE;
						FeedReaderArticleRow* _tmp13_;
						_tmp10_ = r;
						_tmp11_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp10_) ? ((FeedReaderArticleRow*) _tmp10_) : NULL);
						tmpRow = _tmp11_;
						_tmp13_ = tmpRow;
						if (_tmp13_ != NULL) {
							FeedReaderArticleRow* _tmp14_;
							_tmp14_ = tmpRow;
							_tmp12_ = feed_reader_article_row_isBeingRevealed (_tmp14_);
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							gboolean _tmp15_ = FALSE;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp17_ = FALSE;
							FeedReaderArticleRow* _tmp18_;
							FeedReaderArticle* _tmp19_;
							FeedReaderArticle* _tmp20_;
							gboolean _tmp21_;
							_tmp18_ = tmpRow;
							_tmp19_ = feed_reader_article_row_getArticle (_tmp18_);
							_tmp20_ = _tmp19_;
							_tmp21_ = feed_reader_article_getUnread (_tmp20_) == FEED_READER_ARTICLE_STATUS_READ;
							_g_object_unref0 (_tmp20_);
							if (_tmp21_) {
								_tmp17_ = self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_UNREAD;
							} else {
								_tmp17_ = FALSE;
							}
							if (_tmp17_) {
								_tmp16_ = TRUE;
							} else {
								gboolean _tmp22_ = FALSE;
								FeedReaderArticleRow* _tmp23_;
								FeedReaderArticle* _tmp24_;
								FeedReaderArticle* _tmp25_;
								gboolean _tmp26_;
								_tmp23_ = tmpRow;
								_tmp24_ = feed_reader_article_row_getArticle (_tmp23_);
								_tmp25_ = _tmp24_;
								_tmp26_ = feed_reader_article_getMarked (_tmp25_) == FEED_READER_ARTICLE_STATUS_UNMARKED;
								_g_object_unref0 (_tmp25_);
								if (_tmp26_) {
									_tmp22_ = self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_MARKED;
								} else {
									_tmp22_ = FALSE;
								}
								_tmp16_ = _tmp22_;
							}
							if (_tmp16_) {
								_tmp15_ = TRUE;
							} else {
								gboolean _tmp27_ = FALSE;
								if (self->priv->m_selectedFeedListType == FEED_READER_FEED_LIST_TYPE_TAG) {
									FeedReaderArticleRow* _tmp28_;
									const gchar* _tmp29_;
									_tmp28_ = tmpRow;
									_tmp29_ = self->priv->m_selectedFeedListID;
									_tmp27_ = !feed_reader_article_row_hasTag (_tmp28_, _tmp29_);
								} else {
									_tmp27_ = FALSE;
								}
								_tmp15_ = _tmp27_;
							}
							if (_tmp15_) {
								FeedReaderArticleRow* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								const gchar* _tmp33_;
								gboolean _tmp34_;
								_tmp30_ = tmpRow;
								_tmp31_ = feed_reader_article_row_getID (_tmp30_);
								_tmp32_ = _tmp31_;
								_tmp33_ = selectedID;
								_tmp34_ = g_strcmp0 (_tmp32_, _tmp33_) != 0;
								_g_free0 (_tmp32_);
								if (_tmp34_) {
									FeedReaderArticleRow* _tmp35_;
									_tmp35_ = tmpRow;
									feed_reader_article_list_box_removeRow (self, _tmp35_, 700);
								}
							}
						}
						_g_object_unref0 (tmpRow);
						_g_object_unref0 (r);
					}
				}
			}
			(articleChildList == NULL) ? NULL : (articleChildList = (g_list_free (articleChildList), NULL));
		}
	}
	_tmp36_ = selectedID;
	_tmp37_ = g_strdup (_tmp36_);
	_g_free0 (self->priv->m_selectedArticle);
	self->priv->m_selectedArticle = _tmp37_;
	_g_free0 (selectedID);
	_g_object_unref0 (selectedRow);
}

static void
feed_reader_article_list_box_rowStateChanged (FeedReaderArticleListBox* self,
                                              FeedReaderArticleStatus status)
{
	g_return_if_fail (self != NULL);
	feed_reader_logger_debug ("state changed");
	switch (status) {
		case FEED_READER_ARTICLE_STATUS_UNREAD:
		case FEED_READER_ARTICLE_STATUS_MARKED:
		{
			return;
		}
		case FEED_READER_ARTICLE_STATUS_READ:
		case FEED_READER_ARTICLE_STATUS_UNMARKED:
		{
			FeedReaderArticleRow* selectedRow = NULL;
			GtkListBoxRow* _tmp0_;
			FeedReaderArticleRow* _tmp1_;
			GList* articleChildList = NULL;
			GList* _tmp2_;
			GList* _tmp3_;
			_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
			_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
			selectedRow = _tmp1_;
			_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
			articleChildList = _tmp2_;
			_tmp3_ = articleChildList;
			{
				GList* row_collection = NULL;
				GList* row_it = NULL;
				row_collection = _tmp3_;
				for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
					GtkWidget* _tmp4_;
					GtkWidget* row = NULL;
					_tmp4_ = _g_object_ref0 ((GtkWidget*) row_it->data);
					row = _tmp4_;
					{
						FeedReaderArticleRow* tmpRow = NULL;
						GtkWidget* _tmp5_;
						FeedReaderArticleRow* _tmp6_;
						FeedReaderArticleRow* _tmp7_;
						_tmp5_ = row;
						_tmp6_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp5_) ? ((FeedReaderArticleRow*) _tmp5_) : NULL);
						tmpRow = _tmp6_;
						_tmp7_ = tmpRow;
						if (_tmp7_ != NULL) {
							gboolean _tmp8_ = FALSE;
							gboolean _tmp9_ = FALSE;
							FeedReaderArticleRow* _tmp10_;
							_tmp10_ = selectedRow;
							if (_tmp10_ != NULL) {
								FeedReaderArticleRow* _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								FeedReaderArticleRow* _tmp14_;
								gchar* _tmp15_;
								gchar* _tmp16_;
								_tmp11_ = tmpRow;
								_tmp12_ = feed_reader_article_row_getID (_tmp11_);
								_tmp13_ = _tmp12_;
								_tmp14_ = selectedRow;
								_tmp15_ = feed_reader_article_row_getID (_tmp14_);
								_tmp16_ = _tmp15_;
								_tmp9_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
								_g_free0 (_tmp16_);
								_g_free0 (_tmp13_);
							} else {
								_tmp9_ = FALSE;
							}
							if (_tmp9_) {
								_tmp8_ = TRUE;
							} else {
								FeedReaderArticleRow* _tmp17_;
								_tmp17_ = selectedRow;
								_tmp8_ = _tmp17_ == NULL;
							}
							if (_tmp8_) {
								GeeHashMap* _tmp18_;
								FeedReaderArticleRow* _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								gboolean _tmp22_;
								_tmp18_ = self->priv->m_articles;
								_tmp19_ = tmpRow;
								_tmp20_ = feed_reader_article_row_getID (_tmp19_);
								_tmp21_ = _tmp20_;
								_tmp22_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp18_, _tmp21_);
								_g_free0 (_tmp21_);
								if (_tmp22_) {
									gboolean _tmp23_ = FALSE;
									gboolean _tmp24_ = FALSE;
									if (self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
										FeedReaderArticleRow* _tmp25_;
										FeedReaderArticle* _tmp26_;
										FeedReaderArticle* _tmp27_;
										_tmp25_ = tmpRow;
										_tmp26_ = feed_reader_article_row_getArticle (_tmp25_);
										_tmp27_ = _tmp26_;
										_tmp24_ = feed_reader_article_getUnread (_tmp27_) == FEED_READER_ARTICLE_STATUS_READ;
										_g_object_unref0 (_tmp27_);
									} else {
										_tmp24_ = FALSE;
									}
									if (_tmp24_) {
										_tmp23_ = TRUE;
									} else {
										gboolean _tmp28_ = FALSE;
										if (self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_MARKED) {
											FeedReaderArticleRow* _tmp29_;
											FeedReaderArticle* _tmp30_;
											FeedReaderArticle* _tmp31_;
											_tmp29_ = tmpRow;
											_tmp30_ = feed_reader_article_row_getArticle (_tmp29_);
											_tmp31_ = _tmp30_;
											_tmp28_ = feed_reader_article_getMarked (_tmp31_) == FEED_READER_ARTICLE_STATUS_UNMARKED;
											_g_object_unref0 (_tmp31_);
										} else {
											_tmp28_ = FALSE;
										}
										_tmp23_ = _tmp28_;
									}
									if (_tmp23_) {
										FeedReaderArticleRow* _tmp32_;
										_tmp32_ = tmpRow;
										feed_reader_article_list_box_removeRow (self, _tmp32_, 700);
										_g_object_unref0 (tmpRow);
										_g_object_unref0 (row);
										break;
									}
								}
							}
						}
						_g_object_unref0 (tmpRow);
						_g_object_unref0 (row);
					}
				}
			}
			(articleChildList == NULL) ? NULL : (articleChildList = (g_list_free (articleChildList), NULL));
			_g_object_unref0 (selectedRow);
			break;
		}
		default:
		break;
	}
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		FeedReaderArticleListBox* self;
		self = _data49_->self;
		_g_object_unref0 (_data49_->invisibleRows);
		_g_object_unref0 (_data49_->visibleArticles);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static gboolean
__lambda186_ (Block49Data* _data49_,
              gchar* id)
{
	FeedReaderArticleListBox* self;
	gboolean result;
	self = _data49_->self;
	g_return_val_if_fail (id != NULL, FALSE);
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _data49_->visibleArticles, id)) {
		GeeHashSet* _tmp0_;
		_tmp0_ = _data49_->invisibleRows;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, id);
	}
	result = TRUE;
	_g_free0 (id);
	return result;
}

static gboolean
___lambda186__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda186_ (self, (gchar*) g);
	return result;
}

void
feed_reader_article_list_box_setVisibleRows (FeedReaderArticleListBox* self,
                                             GeeHashSet* visibleArticles)
{
	Block49Data* _data49_;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GList* children = NULL;
	GList* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visibleArticles != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (visibleArticles);
	_g_object_unref0 (_data49_->visibleArticles);
	_data49_->visibleArticles = _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data49_->invisibleRows = _tmp1_;
	_tmp2_ = self->priv->m_visibleArticles;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp2_, ___lambda186__gee_forall_func, _data49_);
	_tmp3_ = _g_object_ref0 (_data49_->visibleArticles);
	_g_object_unref0 (self->priv->m_visibleArticles);
	self->priv->m_visibleArticles = _tmp3_;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp4_;
	_tmp5_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp5_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp6_;
				FeedReaderArticleRow* _tmp7_;
				gboolean _tmp8_ = FALSE;
				FeedReaderArticleRow* _tmp9_;
				_tmp6_ = row;
				_tmp7_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp6_) ? ((FeedReaderArticleRow*) _tmp6_) : NULL);
				tmpRow = _tmp7_;
				_tmp9_ = tmpRow;
				if (_tmp9_ != NULL) {
					GeeHashSet* _tmp10_;
					FeedReaderArticleRow* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp10_ = _data49_->invisibleRows;
					_tmp11_ = tmpRow;
					_tmp12_ = feed_reader_article_row_getID (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp8_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp10_, _tmp13_);
					_g_free0 (_tmp13_);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					FeedReaderArticleRow* _tmp14_;
					gboolean _tmp15_ = FALSE;
					_tmp14_ = tmpRow;
					feed_reader_article_list_box_setRead (self, _tmp14_);
					if (self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
						FeedReaderArticleRow* _tmp16_;
						FeedReaderArticle* _tmp17_;
						FeedReaderArticle* _tmp18_;
						_tmp16_ = tmpRow;
						_tmp17_ = feed_reader_article_row_getArticle (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp15_ = feed_reader_article_getUnread (_tmp18_) == FEED_READER_ARTICLE_STATUS_READ;
						_g_object_unref0 (_tmp18_);
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						FeedReaderArticleRow* _tmp19_;
						g_signal_emit (self, feed_reader_article_list_box_signals[FEED_READER_ARTICLE_LIST_BOX_BALANCE_NEXT_SCROLL_SIGNAL], 0, FEED_READER_ARTICLE_LIST_BALANCE_BOTTOM);
						_tmp19_ = tmpRow;
						feed_reader_article_list_box_removeRow (self, _tmp19_, 0);
					}
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

void
feed_reader_article_list_box_removeTagFromSelectedRow (FeedReaderArticleListBox* self,
                                                       const gchar* tagID)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	FeedReaderArticleRow* _tmp2_;
	FeedReaderArticleRow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = selectedRow;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (selectedRow);
		return;
	}
	_tmp3_ = selectedRow;
	feed_reader_article_row_removeTag (_tmp3_, tagID);
	_g_object_unref0 (selectedRow);
}

FeedReaderArticleRow*
feed_reader_article_list_box_getFirstRow (FeedReaderArticleListBox* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	FeedReaderArticleRow* firstRow = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkWidget* _tmp5_;
	FeedReaderArticleRow* _tmp6_;
	FeedReaderArticleRow* _tmp7_;
	FeedReaderArticleRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	if (_tmp1_ == NULL) {
		result = NULL;
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	_tmp2_ = children;
	_tmp3_ = g_list_first (_tmp2_);
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (GtkWidget*) _tmp4_;
	_tmp6_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp5_) ? ((FeedReaderArticleRow*) _tmp5_) : NULL);
	firstRow = _tmp6_;
	_tmp7_ = firstRow;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (firstRow);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	result = firstRow;
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

FeedReaderArticleRow*
feed_reader_article_list_box_getLastRow (FeedReaderArticleListBox* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	FeedReaderArticleRow* lastRow = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkWidget* _tmp5_;
	FeedReaderArticleRow* _tmp6_;
	FeedReaderArticleRow* _tmp7_;
	FeedReaderArticleRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	if (_tmp1_ == NULL) {
		result = NULL;
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	_tmp2_ = children;
	_tmp3_ = g_list_last (_tmp2_);
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (GtkWidget*) _tmp4_;
	_tmp6_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp5_) ? ((FeedReaderArticleRow*) _tmp5_) : NULL);
	lastRow = _tmp6_;
	_tmp7_ = lastRow;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (lastRow);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	result = lastRow;
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

gboolean
feed_reader_article_list_box_selectedIsFirst (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	GList* children = NULL;
	GList* _tmp2_;
	gint n = 0;
	GList* _tmp3_;
	FeedReaderArticleRow* _tmp4_;
	FeedReaderArticleRow* lastRow = NULL;
	GList* _tmp5_;
	GList* _tmp6_;
	gconstpointer _tmp7_;
	GtkWidget* _tmp8_;
	FeedReaderArticleRow* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp2_;
	_tmp3_ = children;
	_tmp4_ = selectedRow;
	n = g_list_index (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = children;
	_tmp6_ = g_list_first (_tmp5_);
	_tmp7_ = _tmp6_->data;
	_tmp8_ = (GtkWidget*) _tmp7_;
	_tmp9_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp8_) ? ((FeedReaderArticleRow*) _tmp8_) : NULL);
	lastRow = _tmp9_;
	if (n == 0) {
		result = TRUE;
		_g_object_unref0 (lastRow);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		_g_object_unref0 (selectedRow);
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		if (self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
			_tmp11_ = n == 1;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			FeedReaderArticleRow* _tmp12_;
			_tmp12_ = lastRow;
			_tmp10_ = !feed_reader_article_row_isBeingRevealed (_tmp12_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			result = TRUE;
			_g_object_unref0 (lastRow);
			(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
			_g_object_unref0 (selectedRow);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (lastRow);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	_g_object_unref0 (selectedRow);
	return result;
}

gboolean
feed_reader_article_list_box_selectedIsLast (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	GList* children = NULL;
	GList* _tmp2_;
	gint n = 0;
	GList* _tmp3_;
	FeedReaderArticleRow* _tmp4_;
	guint length = 0U;
	GList* _tmp5_;
	FeedReaderArticleRow* lastRow = NULL;
	GList* _tmp6_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GtkWidget* _tmp9_;
	FeedReaderArticleRow* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp2_;
	_tmp3_ = children;
	_tmp4_ = selectedRow;
	n = g_list_index (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = children;
	length = g_list_length (_tmp5_);
	_tmp6_ = children;
	_tmp7_ = g_list_last (_tmp6_);
	_tmp8_ = _tmp7_->data;
	_tmp9_ = (GtkWidget*) _tmp8_;
	_tmp10_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp9_) ? ((FeedReaderArticleRow*) _tmp9_) : NULL);
	lastRow = _tmp10_;
	if (((guint) (n + 1)) == length) {
		result = TRUE;
		_g_object_unref0 (lastRow);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		_g_object_unref0 (selectedRow);
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		if (self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
			_tmp12_ = ((guint) (n + 2)) == length;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			FeedReaderArticleRow* _tmp13_;
			_tmp13_ = lastRow;
			_tmp11_ = !feed_reader_article_row_isBeingRevealed (_tmp13_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_g_object_unref0 (lastRow);
			(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
			_g_object_unref0 (selectedRow);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (lastRow);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	_g_object_unref0 (selectedRow);
	return result;
}

void
feed_reader_article_list_box_markAllAsRead (FeedReaderArticleListBox* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp2_;
				FeedReaderArticleRow* _tmp3_;
				FeedReaderArticleRow* _tmp4_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
				tmpRow = _tmp3_;
				_tmp4_ = tmpRow;
				if (_tmp4_ != NULL) {
					FeedReaderArticleRow* _tmp5_;
					_tmp5_ = tmpRow;
					feed_reader_article_row_updateUnread (_tmp5_, FEED_READER_ARTICLE_STATUS_READ);
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

gint
feed_reader_article_list_box_selectedRowPosition (FeedReaderArticleListBox* self)
{
	FeedReaderArticleRow* selectedRow = NULL;
	GtkListBoxRow* _tmp0_;
	FeedReaderArticleRow* _tmp1_;
	gint scroll = 0;
	FeedReaderArticleRow* _tmp2_;
	GList* FeedChildList = NULL;
	GList* _tmp3_;
	GList* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp0_) ? ((FeedReaderArticleRow*) _tmp0_) : NULL);
	selectedRow = _tmp1_;
	scroll = 0;
	_tmp2_ = selectedRow;
	if (_tmp2_ == NULL) {
		result = scroll;
		_g_object_unref0 (selectedRow);
		return result;
	}
	_tmp3_ = gtk_container_get_children ((GtkContainer*) self);
	FeedChildList = _tmp3_;
	_tmp4_ = FeedChildList;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp4_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* _tmp5_;
			GtkWidget* row = NULL;
			_tmp5_ = _g_object_ref0 ((GtkWidget*) row_it->data);
			row = _tmp5_;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp6_;
				FeedReaderArticleRow* _tmp7_;
				FeedReaderArticleRow* _tmp8_;
				_tmp6_ = row;
				_tmp7_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp6_) ? ((FeedReaderArticleRow*) _tmp6_) : NULL);
				tmpRow = _tmp7_;
				_tmp8_ = tmpRow;
				if (_tmp8_ != NULL) {
					FeedReaderArticleRow* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					FeedReaderArticleRow* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gboolean _tmp15_;
					_tmp9_ = tmpRow;
					_tmp10_ = feed_reader_article_row_getID (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = selectedRow;
					_tmp13_ = feed_reader_article_row_getID (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strcmp0 (_tmp11_, _tmp14_) == 0;
					_g_free0 (_tmp14_);
					_g_free0 (_tmp11_);
					if (_tmp15_) {
						FeedReaderArticleRow* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						_tmp16_ = tmpRow;
						scroll += gtk_widget_get_allocated_height ((GtkWidget*) _tmp16_) / 2;
						_tmp17_ = g_strdup_printf ("scroll: %i", scroll);
						_tmp18_ = _tmp17_;
						feed_reader_logger_debug (_tmp18_);
						_g_free0 (_tmp18_);
						_g_object_unref0 (tmpRow);
						_g_object_unref0 (row);
						break;
					} else {
						FeedReaderArticleRow* _tmp19_;
						_tmp19_ = tmpRow;
						if (feed_reader_article_row_isRevealed (_tmp19_)) {
							FeedReaderArticleRow* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp20_ = tmpRow;
							scroll += gtk_widget_get_allocated_height ((GtkWidget*) _tmp20_);
							_tmp21_ = g_strdup_printf ("scroll: %i", scroll);
							_tmp22_ = _tmp21_;
							feed_reader_logger_debug (_tmp22_);
							_g_free0 (_tmp22_);
						}
					}
				}
				_g_object_unref0 (tmpRow);
				_g_object_unref0 (row);
			}
		}
	}
	result = scroll;
	(FeedChildList == NULL) ? NULL : (FeedChildList = (g_list_free (FeedChildList), NULL));
	_g_object_unref0 (selectedRow);
	return result;
}

gboolean
feed_reader_article_list_box_has_id (FeedReaderArticleListBox* self,
                                     const gchar* article_id)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (article_id != NULL, FALSE);
	_tmp0_ = self->priv->m_articles;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, article_id);
	return result;
}

void
feed_reader_article_list_box_selectRow (FeedReaderArticleListBox* self,
                                        const gchar* articleID,
                                        gint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	if (feed_reader_article_list_box_has_id (self, articleID)) {
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		FeedReaderArticleRow* _tmp2_;
		_tmp0_ = self->priv->m_articles;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, articleID);
		_tmp2_ = (FeedReaderArticleRow*) _tmp1_;
		feed_reader_article_list_box_selectAfter (self, _tmp2_, time);
		_g_object_unref0 (_tmp2_);
	}
}

static void
feed_reader_article_list_box_highlightRow (FeedReaderArticleListBox* self,
                                           const gchar* articleID)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp2_;
				FeedReaderArticleRow* _tmp3_;
				gboolean _tmp4_ = FALSE;
				FeedReaderArticleRow* _tmp5_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
				tmpRow = _tmp3_;
				_tmp5_ = tmpRow;
				if (_tmp5_ != NULL) {
					FeedReaderArticleRow* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = tmpRow;
					_tmp7_ = feed_reader_article_row_getID (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp4_ = g_strcmp0 (_tmp8_, articleID) != 0;
					_g_free0 (_tmp8_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					FeedReaderArticleRow* _tmp9_;
					_tmp9_ = tmpRow;
					gtk_widget_set_opacity ((GtkWidget*) _tmp9_, 0.5);
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

static void
feed_reader_article_list_box_unHighlightRow (FeedReaderArticleListBox* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp2_;
				FeedReaderArticleRow* _tmp3_;
				FeedReaderArticleRow* _tmp4_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
				tmpRow = _tmp3_;
				_tmp4_ = tmpRow;
				if (_tmp4_ != NULL) {
					FeedReaderArticleRow* _tmp5_;
					_tmp5_ = tmpRow;
					gtk_widget_set_opacity ((GtkWidget*) _tmp5_, 1.0);
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

gint
feed_reader_article_list_box_getSize (FeedReaderArticleListBox* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_articles;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
feed_reader_article_list_box_getSizeForState (FeedReaderArticleListBox* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->m_state == FEED_READER_ARTICLE_LIST_STATE_UNREAD) {
		gint unread = 0;
		GList* children = NULL;
		GList* _tmp0_;
		GList* _tmp1_;
		unread = 0;
		_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
		children = _tmp0_;
		_tmp1_ = children;
		{
			GList* row_collection = NULL;
			GList* row_it = NULL;
			row_collection = _tmp1_;
			for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
				GtkWidget* row = NULL;
				row = (GtkWidget*) row_it->data;
				{
					FeedReaderArticleRow* tmpRow = NULL;
					GtkWidget* _tmp2_;
					FeedReaderArticleRow* _tmp3_;
					gboolean _tmp4_ = FALSE;
					FeedReaderArticleRow* _tmp5_;
					_tmp2_ = row;
					_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
					tmpRow = _tmp3_;
					_tmp5_ = tmpRow;
					if (_tmp5_ != NULL) {
						FeedReaderArticleRow* _tmp6_;
						FeedReaderArticle* _tmp7_;
						FeedReaderArticle* _tmp8_;
						_tmp6_ = tmpRow;
						_tmp7_ = feed_reader_article_row_getArticle (_tmp6_);
						_tmp8_ = _tmp7_;
						_tmp4_ = feed_reader_article_getUnread (_tmp8_) == FEED_READER_ARTICLE_STATUS_UNREAD;
						_g_object_unref0 (_tmp8_);
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						unread += 1;
					}
					_g_object_unref0 (tmpRow);
				}
			}
		}
		result = unread;
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	result = feed_reader_article_list_box_getSize (self);
	return result;
}

gboolean
feed_reader_article_list_box_needLoadMore (FeedReaderArticleListBox* self,
                                           gint height)
{
	gint rowHeight = 0;
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	rowHeight = 0;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp2_;
				FeedReaderArticleRow* _tmp3_;
				gboolean _tmp4_ = FALSE;
				FeedReaderArticleRow* _tmp5_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
				tmpRow = _tmp3_;
				_tmp5_ = tmpRow;
				if (_tmp5_ != NULL) {
					FeedReaderArticleRow* _tmp6_;
					_tmp6_ = tmpRow;
					_tmp4_ = feed_reader_article_row_isRevealed (_tmp6_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					FeedReaderArticleRow* _tmp7_;
					_tmp7_ = tmpRow;
					rowHeight += gtk_widget_get_allocated_height ((GtkWidget*) _tmp7_);
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	if (rowHeight < (height + 100)) {
		result = TRUE;
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	result = FALSE;
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		FeedReaderArticleListBox* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->tmp);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static gboolean
__lambda238_ (Block50Data* _data50_,
              GeeMapEntry* entry)
{
	FeedReaderArticleListBox* self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gboolean result;
	self = _data50_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_key (entry);
	_tmp1_ = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data50_->tmp, (const gchar*) _tmp1_);
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}

static gboolean
___lambda238__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda238_ (self, (GeeMapEntry*) g);
	return result;
}

GeeList*
feed_reader_article_list_box_getIDs (FeedReaderArticleListBox* self)
{
	Block50Data* _data50_;
	GeeLinkedList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data50_->tmp = _tmp0_;
	_tmp1_ = self->priv->m_articles;
	gee_abstract_map_foreach ((GeeAbstractMap*) _tmp1_, ___lambda238__gee_forall_func, _data50_);
	_tmp2_ = _g_object_ref0 ((GeeList*) _data50_->tmp);
	result = _tmp2_;
	block50_data_unref (_data50_);
	_data50_ = NULL;
	return result;
}

void
feed_reader_article_list_box_setAllUpdated (FeedReaderArticleListBox* self,
                                            gboolean updated)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp2_;
				FeedReaderArticleRow* _tmp3_;
				FeedReaderArticleRow* _tmp4_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
				tmpRow = _tmp3_;
				_tmp4_ = tmpRow;
				if (_tmp4_ != NULL) {
					FeedReaderArticleRow* _tmp5_;
					_tmp5_ = tmpRow;
					feed_reader_article_row_setUpdated (_tmp5_, updated);
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

void
feed_reader_article_list_box_removeObsoleteRows (FeedReaderArticleListBox* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				FeedReaderArticleRow* tmpRow = NULL;
				GtkWidget* _tmp2_;
				FeedReaderArticleRow* _tmp3_;
				gboolean _tmp4_ = FALSE;
				FeedReaderArticleRow* _tmp5_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (FEED_READER_IS_ARTICLE_ROW (_tmp2_) ? ((FeedReaderArticleRow*) _tmp2_) : NULL);
				tmpRow = _tmp3_;
				_tmp5_ = tmpRow;
				if (_tmp5_ != NULL) {
					FeedReaderArticleRow* _tmp6_;
					_tmp6_ = tmpRow;
					_tmp4_ = !feed_reader_article_row_getUpdated (_tmp6_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					FeedReaderArticleRow* _tmp7_;
					_tmp7_ = tmpRow;
					feed_reader_article_list_box_removeRow (self, _tmp7_, 50);
				}
				_g_object_unref0 (tmpRow);
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

gboolean
feed_reader_article_list_box_insertArticle (FeedReaderArticleListBox* self,
                                            FeedReaderArticle* a,
                                            gint pos)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp12_;
	GeeLinkedList* _tmp13_;
	GeeLinkedList* _tmp14_;
	GeeList* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	_tmp0_ = self->priv->m_articles;
	_tmp1_ = feed_reader_article_getArticleID (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp4_ = self->priv->m_name;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("ArticleListbox", _tmp5_, ": row with ID %s is already present", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = feed_reader_article_getArticleID (a);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (_tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		feed_reader_logger_debug (_tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		result = FALSE;
		return result;
	}
	feed_reader_article_setPos (a, pos);
	feed_reader_article_list_box_stopLoading (self);
	_tmp12_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp12_;
	_tmp13_ = list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, a);
	_tmp14_ = list;
	_tmp15_ = _g_object_ref0 ((GeeList*) _tmp14_);
	_g_object_unref0 (self->priv->m_lazyQeue);
	self->priv->m_lazyQeue = _tmp15_;
	feed_reader_article_list_box_addRow (self, FEED_READER_ARTICLE_LIST_BALANCE_NONE, FALSE, FALSE);
	result = TRUE;
	_g_object_unref0 (list);
	return result;
}

static void
feed_reader_article_list_box_class_init (FeedReaderArticleListBoxClass * klass,
                                         gpointer klass_data)
{
	feed_reader_article_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderArticleListBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_article_list_box_finalize;
	feed_reader_article_list_box_signals[FEED_READER_ARTICLE_LIST_BOX_BALANCE_NEXT_SCROLL_SIGNAL] = g_signal_new ("balance-next-scroll", FEED_READER_TYPE_ARTICLE_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, FEED_READER_TYPE_ARTICLE_LIST_BALANCE);
	feed_reader_article_list_box_signals[FEED_READER_ARTICLE_LIST_BOX_LOAD_DONE_SIGNAL] = g_signal_new ("load-done", FEED_READER_TYPE_ARTICLE_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
feed_reader_article_list_box_instance_init (FeedReaderArticleListBox * self,
                                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = feed_reader_article_list_box_get_instance_private (self);
	self->priv->m_idleID = (guint) 0;
	self->priv->m_selectSourceID = (guint) 0;
	self->priv->m_state = FEED_READER_ARTICLE_LIST_STATE_ALL;
	self->priv->m_selectedFeedListType = FEED_READER_FEED_LIST_TYPE_FEED;
	_tmp0_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
	self->priv->m_selectedFeedListID = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->m_selectedArticle = _tmp1_;
}

static void
feed_reader_article_list_box_finalize (GObject * obj)
{
	FeedReaderArticleListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_ARTICLE_LIST_BOX, FeedReaderArticleListBox);
	_g_object_unref0 (self->priv->m_lazyQeue);
	_g_free0 (self->priv->m_name);
	_g_free0 (self->priv->m_selectedFeedListID);
	_g_free0 (self->priv->m_selectedArticle);
	_g_object_unref0 (self->priv->m_articles);
	_g_object_unref0 (self->priv->m_visibleArticles);
	G_OBJECT_CLASS (feed_reader_article_list_box_parent_class)->finalize (obj);
}

static GType
feed_reader_article_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderArticleListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_article_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderArticleListBox), 0, (GInstanceInitFunc) feed_reader_article_list_box_instance_init, NULL };
	GType feed_reader_article_list_box_type_id;
	feed_reader_article_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "FeedReaderArticleListBox", &g_define_type_info, 0);
	FeedReaderArticleListBox_private_offset = g_type_add_instance_private (feed_reader_article_list_box_type_id, sizeof (FeedReaderArticleListBoxPrivate));
	return feed_reader_article_list_box_type_id;
}

GType
feed_reader_article_list_box_get_type (void)
{
	static volatile gsize feed_reader_article_list_box_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_article_list_box_type_id__once)) {
		GType feed_reader_article_list_box_type_id;
		feed_reader_article_list_box_type_id = feed_reader_article_list_box_get_type_once ();
		g_once_init_leave (&feed_reader_article_list_box_type_id__once, feed_reader_article_list_box_type_id);
	}
	return feed_reader_article_list_box_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

