/* ArticleListScroll.c generated by valac 0.56.3, the Vala compiler
 * generated from ArticleListScroll.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General public License for more details.*/
/**/
/*You should have received a copy of the GNU General public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

enum  {
	FEED_READER_ARTICLE_LIST_SCROLL_0_PROPERTY,
	FEED_READER_ARTICLE_LIST_SCROLL_NUM_PROPERTIES
};
static GParamSpec* feed_reader_article_list_scroll_properties[FEED_READER_ARTICLE_LIST_SCROLL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_TOP_SIGNAL,
	FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_BOTTOM_SIGNAL,
	FEED_READER_ARTICLE_LIST_SCROLL_VALUE_CHANGED_SIGNAL,
	FEED_READER_ARTICLE_LIST_SCROLL_NUM_SIGNALS
};
static guint feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_NUM_SIGNALS] = {0};

struct _FeedReaderArticleListScrollPrivate {
	gdouble m_upperCache;
	gdouble m_valueCache;
	gdouble m_valueThreshold;
	gdouble m_bottomThreshold;
	FeedReaderArticleListBalance m_balance;
	gboolean m_allowSignals;
	gboolean m_scrolledTopOnCooldown;
	gboolean m_scrolledBottomOnCooldown;
	gint m_scrollCooldown;
	gint64 m_startTime;
	gint64 m_endTime;
	gdouble m_transitionDiff;
	gdouble m_transitionStartValue;
	gint m_transitionDuration;
	guint m_scrollCallbackID;
	guint m_savetyFallbackID;
	guint m_scrollCooldownID;
};

static gint FeedReaderArticleListScroll_private_offset;
static gpointer feed_reader_article_list_scroll_parent_class = NULL;

static void feed_reader_article_list_scroll_trackUpper (FeedReaderArticleListScroll* self);
static void _feed_reader_article_list_scroll_trackUpper_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void feed_reader_article_list_scroll_trackValue (FeedReaderArticleListScroll* self);
static void _feed_reader_article_list_scroll_trackValue_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void feed_reader_article_list_scroll_checkScrolledDown (FeedReaderArticleListScroll* self);
static void feed_reader_article_list_scroll_checkScrolledTop (FeedReaderArticleListScroll* self);
static gboolean ___lambda115_ (FeedReaderArticleListScroll* self);
static gboolean ____lambda115__gsource_func (gpointer self);
static gboolean ___lambda114_ (FeedReaderArticleListScroll* self);
static gboolean ____lambda114__gsource_func (gpointer self);
static gboolean __lambda116_ (FeedReaderArticleListScroll* self);
static gboolean ___lambda116__gsource_func (gpointer self);
static void feed_reader_article_list_scroll_setScroll (FeedReaderArticleListScroll* self,
                                                gdouble pos);
static gboolean feed_reader_article_list_scroll_scrollTick (FeedReaderArticleListScroll* self,
                                                     GtkWidget* widget,
                                                     GdkFrameClock* frame_clock);
static gboolean _feed_reader_article_list_scroll_scrollTick_gtk_tick_callback (GtkWidget* widget,
                                                                        GdkFrameClock* frame_clock,
                                                                        gpointer self);
static inline gdouble feed_reader_article_list_scroll_easeOutCubic (FeedReaderArticleListScroll* self,
                                                      gdouble t);
static void feed_reader_article_list_scroll_finalize (GObject * obj);
static GType feed_reader_article_list_scroll_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_article_list_scroll_get_instance_private (FeedReaderArticleListScroll* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderArticleListScroll_private_offset);
}

static void
_feed_reader_article_list_scroll_trackUpper_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	feed_reader_article_list_scroll_trackUpper ((FeedReaderArticleListScroll*) self);
}

static void
_feed_reader_article_list_scroll_trackValue_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	feed_reader_article_list_scroll_trackValue ((FeedReaderArticleListScroll*) self);
}

FeedReaderArticleListScroll*
feed_reader_article_list_scroll_construct (GType object_type)
{
	FeedReaderArticleListScroll * self = NULL;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	self = (FeedReaderArticleListScroll*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::upper", (GCallback) _feed_reader_article_list_scroll_trackUpper_g_object_notify, self, 0);
	_tmp2_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::value", (GCallback) _feed_reader_article_list_scroll_trackValue_g_object_notify, self, 0);
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 0);
	return self;
}

FeedReaderArticleListScroll*
feed_reader_article_list_scroll_new (void)
{
	return feed_reader_article_list_scroll_construct (FEED_READER_TYPE_ARTICLE_LIST_SCROLL);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
feed_reader_article_list_scroll_trackUpper (FeedReaderArticleListScroll* self)
{
	gdouble upper = 0.0;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp24_;
	GtkAdjustment* _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	GtkAdjustment* _tmp28_;
	GtkAdjustment* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	GtkAdjustment* _tmp32_;
	GtkAdjustment* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	_tmp3_ = _tmp2_;
	upper = _tmp3_;
	if (self->priv->m_balance == FEED_READER_ARTICLE_LIST_BALANCE_TOP) {
		gdouble inc = 0.0;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkAdjustment* _tmp8_;
		GtkAdjustment* _tmp9_;
		GtkAdjustment* _tmp10_;
		GtkAdjustment* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		inc = upper - self->priv->m_upperCache;
		_tmp4_ = double_to_string (inc);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("Balance TOP ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		feed_reader_logger_debug (_tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp8_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_adjustment_get_value (_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_adjustment_set_value (_tmp11_, _tmp13_ + inc);
		self->priv->m_balance = FEED_READER_ARTICLE_LIST_BALANCE_NONE;
	} else {
		if (self->priv->m_balance == FEED_READER_ARTICLE_LIST_BALANCE_BOTTOM) {
			gdouble inc = 0.0;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GtkAdjustment* _tmp18_;
			GtkAdjustment* _tmp19_;
			GtkAdjustment* _tmp20_;
			GtkAdjustment* _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			inc = self->priv->m_upperCache - upper;
			_tmp14_ = double_to_string (inc);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat ("Balance BOTTOM ", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			feed_reader_logger_debug (_tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp21_ = _tmp20_;
			_tmp22_ = gtk_adjustment_get_value (_tmp21_);
			_tmp23_ = _tmp22_;
			gtk_adjustment_set_value (_tmp21_, _tmp23_ - inc);
			self->priv->m_balance = FEED_READER_ARTICLE_LIST_BALANCE_NONE;
		}
	}
	_tmp24_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = gtk_adjustment_get_upper (_tmp25_);
	_tmp27_ = _tmp26_;
	if (fabs (_tmp27_ - self->priv->m_upperCache) > 2.0) {
		feed_reader_article_list_scroll_checkScrolledDown (self);
	}
	_tmp28_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = gtk_adjustment_get_upper (_tmp29_);
	_tmp31_ = _tmp30_;
	self->priv->m_upperCache = _tmp31_;
	_tmp32_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = gtk_adjustment_get_value (_tmp33_);
	_tmp35_ = _tmp34_;
	self->priv->m_valueCache = _tmp35_;
}

static void
feed_reader_article_list_scroll_trackValue (FeedReaderArticleListScroll* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > (self->priv->m_valueCache + self->priv->m_valueThreshold)) {
		g_signal_emit (self, feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_VALUE_CHANGED_SIGNAL], 0, FEED_READER_SCROLL_DIRECTION_DOWN);
	} else {
		GtkAdjustment* _tmp4_;
		GtkAdjustment* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp4_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ < (self->priv->m_valueCache - self->priv->m_valueThreshold)) {
			g_signal_emit (self, feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_VALUE_CHANGED_SIGNAL], 0, FEED_READER_SCROLL_DIRECTION_UP);
		}
	}
	feed_reader_article_list_scroll_checkScrolledTop (self);
	feed_reader_article_list_scroll_checkScrolledDown (self);
	_tmp8_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_adjustment_get_upper (_tmp9_);
	_tmp11_ = _tmp10_;
	self->priv->m_upperCache = _tmp11_;
	_tmp12_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_adjustment_get_value (_tmp13_);
	_tmp15_ = _tmp14_;
	self->priv->m_valueCache = _tmp15_;
}

static gboolean
___lambda115_ (FeedReaderArticleListScroll* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean result;
	self->priv->m_scrolledTopOnCooldown = FALSE;
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2.0) {
		g_signal_emit (self, feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_TOP_SIGNAL], 0);
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda115__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda115_ ((FeedReaderArticleListScroll*) self);
	return result;
}

static void
feed_reader_article_list_scroll_checkScrolledTop (FeedReaderArticleListScroll* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->m_allowSignals) {
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp2_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_adjustment_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ < 2.0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !self->priv->m_scrolledTopOnCooldown;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->m_scrolledTopOnCooldown = TRUE;
		g_signal_emit (self, feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_TOP_SIGNAL], 0);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->m_scrollCooldown, ____lambda115__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
___lambda114_ (FeedReaderArticleListScroll* self)
{
	gboolean result;
	self->priv->m_savetyFallbackID = (guint) 0;
	self->priv->m_scrolledBottomOnCooldown = FALSE;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda114__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda114_ ((FeedReaderArticleListScroll*) self);
	return result;
}

static void
feed_reader_article_list_scroll_checkScrolledDown (FeedReaderArticleListScroll* self)
{
	gdouble max = 0.0;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_adjustment_get_page_size (_tmp5_);
	_tmp7_ = _tmp6_;
	max = _tmp3_ - _tmp7_;
	if (self->priv->m_allowSignals) {
		_tmp10_ = max > 0.0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GtkAdjustment* _tmp11_;
		GtkAdjustment* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		_tmp11_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_adjustment_get_value (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp9_ = _tmp14_ >= (max - self->priv->m_bottomThreshold);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = !self->priv->m_scrolledBottomOnCooldown;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		feed_reader_logger_debug ("ArticleListScroll: scrolled down");
		self->priv->m_scrolledBottomOnCooldown = TRUE;
		g_signal_emit (self, feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_BOTTOM_SIGNAL], 0);
		self->priv->m_savetyFallbackID = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ____lambda114__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
__lambda116_ (FeedReaderArticleListScroll* self)
{
	gdouble max = 0.0;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gboolean result;
	feed_reader_logger_debug ("ArticleListScroll: scrolled down off cooldown");
	self->priv->m_scrollCooldownID = (guint) 0;
	self->priv->m_scrolledBottomOnCooldown = FALSE;
	if (self->priv->m_savetyFallbackID != ((guint) 0)) {
		g_source_remove (self->priv->m_savetyFallbackID);
		self->priv->m_savetyFallbackID = (guint) 0;
	}
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_adjustment_get_page_size (_tmp5_);
	_tmp7_ = _tmp6_;
	max = _tmp3_ - _tmp7_;
	_tmp8_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_adjustment_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ >= (max - 5)) {
		feed_reader_logger_debug ("ArticleListScroll: trigger scrolledBottom()");
		g_signal_emit (self, feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_BOTTOM_SIGNAL], 0);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda116__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda116_ ((FeedReaderArticleListScroll*) self);
	return result;
}

void
feed_reader_article_list_scroll_startScrolledDownCooldown (FeedReaderArticleListScroll* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->m_scrollCooldownID != ((guint) 0)) {
		g_source_remove (self->priv->m_scrollCooldownID);
		self->priv->m_scrollCooldownID = (guint) 0;
	}
	self->priv->m_scrollCooldownID = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->m_scrollCooldown, ___lambda116__gsource_func, g_object_ref (self), g_object_unref);
}

void
feed_reader_article_list_scroll_balanceNextScroll (FeedReaderArticleListScroll* self,
                                                   FeedReaderArticleListBalance mode)
{
	g_return_if_fail (self != NULL);
	self->priv->m_balance = mode;
}

void
feed_reader_article_list_scroll_scrollDiff (FeedReaderArticleListScroll* self,
                                            gdouble diff,
                                            gboolean animate)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("ArticleListScroll.scrollDiff: value: %f - diff: %f", _tmp3_, diff);
	_tmp5_ = _tmp4_;
	feed_reader_logger_debug (_tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_adjustment_get_value (_tmp7_);
	_tmp9_ = _tmp8_;
	feed_reader_article_list_scroll_scrollToPos (self, _tmp9_ + diff, animate);
}

static gboolean
_feed_reader_article_list_scroll_scrollTick_gtk_tick_callback (GtkWidget* widget,
                                                               GdkFrameClock* frame_clock,
                                                               gpointer self)
{
	gboolean result;
	result = feed_reader_article_list_scroll_scrollTick ((FeedReaderArticleListScroll*) self, widget, frame_clock);
	return result;
}

void
feed_reader_article_list_scroll_scrollToPos (FeedReaderArticleListScroll* self,
                                             gdouble pos,
                                             gboolean animate)
{
	gboolean _tmp0_ = FALSE;
	GtkSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		feed_reader_article_list_scroll_setScroll (self, pos);
		return;
	}
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-enable-animations", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = animate;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GdkFrameClock* _tmp8_;
		gdouble leftOverScroll = 0.0;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GtkAdjustment* _tmp35_;
		GtkAdjustment* _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp4_ = double_to_string (pos);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("ArticleListScroll.scrollToPos: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		feed_reader_logger_debug (_tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp8_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
		self->priv->m_startTime = gdk_frame_clock_get_frame_time (_tmp8_);
		self->priv->m_endTime = self->priv->m_startTime + self->priv->m_transitionDuration;
		leftOverScroll = 0.0;
		if (self->priv->m_scrollCallbackID != ((guint) 0)) {
			GtkAdjustment* _tmp9_;
			GtkAdjustment* _tmp10_;
			gdouble _tmp11_;
			gdouble _tmp12_;
			_tmp9_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = gtk_adjustment_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			leftOverScroll = (self->priv->m_transitionStartValue + self->priv->m_transitionDiff) - _tmp12_;
			gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->m_scrollCallbackID);
			self->priv->m_scrollCallbackID = (guint) 0;
		}
		_tmp13_ = double_to_string (leftOverScroll);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("ArticleListScroll.scrollToPos: leftOverScroll ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		feed_reader_logger_debug (_tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_tmp17_ = g_strdup_printf ("ArticleListScroll.scrollToPos: %f", pos + leftOverScroll);
		_tmp18_ = _tmp17_;
		feed_reader_logger_debug (_tmp18_);
		_g_free0 (_tmp18_);
		if (pos == ((gdouble) -1)) {
			GtkAdjustment* _tmp19_;
			GtkAdjustment* _tmp20_;
			gdouble _tmp21_;
			gdouble _tmp22_;
			GtkAdjustment* _tmp23_;
			GtkAdjustment* _tmp24_;
			gdouble _tmp25_;
			gdouble _tmp26_;
			GtkAdjustment* _tmp27_;
			GtkAdjustment* _tmp28_;
			gdouble _tmp29_;
			gdouble _tmp30_;
			_tmp19_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = gtk_adjustment_get_upper (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = gtk_adjustment_get_page_size (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = gtk_adjustment_get_value (_tmp28_);
			_tmp30_ = _tmp29_;
			self->priv->m_transitionDiff = (_tmp22_ - _tmp26_) - _tmp30_;
		} else {
			GtkAdjustment* _tmp31_;
			GtkAdjustment* _tmp32_;
			gdouble _tmp33_;
			gdouble _tmp34_;
			_tmp31_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
			_tmp32_ = _tmp31_;
			_tmp33_ = gtk_adjustment_get_value (_tmp32_);
			_tmp34_ = _tmp33_;
			self->priv->m_transitionDiff = (pos - _tmp34_) + leftOverScroll;
		}
		_tmp35_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = gtk_adjustment_get_value (_tmp36_);
		_tmp38_ = _tmp37_;
		self->priv->m_transitionStartValue = _tmp38_;
		_tmp39_ = double_to_string (self->priv->m_transitionStartValue);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat ("ArticleListScroll.scrollDiff: startValue ", _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		feed_reader_logger_debug (_tmp42_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		self->priv->m_scrollCallbackID = gtk_widget_add_tick_callback ((GtkWidget*) self, _feed_reader_article_list_scroll_scrollTick_gtk_tick_callback, g_object_ref (self), g_object_unref);
	} else {
		feed_reader_article_list_scroll_setScroll (self, pos);
	}
}

gdouble
feed_reader_article_list_scroll_getScroll (FeedReaderArticleListScroll* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
feed_reader_article_list_scroll_setScroll (FeedReaderArticleListScroll* self,
                                           gdouble pos)
{
	g_return_if_fail (self != NULL);
	if (pos == ((gdouble) -1)) {
		GtkAdjustment* _tmp0_;
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		GtkAdjustment* _tmp6_;
		GtkAdjustment* _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_adjustment_get_upper (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_adjustment_get_page_size (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_adjustment_set_value (_tmp1_, _tmp5_ - _tmp9_);
	} else {
		GtkAdjustment* _tmp10_;
		GtkAdjustment* _tmp11_;
		_tmp10_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp11_ = _tmp10_;
		gtk_adjustment_set_value (_tmp11_, pos);
	}
}

gdouble
feed_reader_article_list_scroll_getPageSize (FeedReaderArticleListScroll* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_page_size (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

gint
feed_reader_article_list_scroll_isVisible (FeedReaderArticleListScroll* self,
                                           GtkListBoxRow* row,
                                           gint additionalRows)
{
	gint rowHeight = 0;
	gint scrollHeight = 0;
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row != NULL, 0);
	rowHeight = gtk_widget_get_allocated_height ((GtkWidget*) row);
	scrollHeight = gtk_widget_get_allocated_height ((GtkWidget*) self);
	y = 0;
	gtk_widget_translate_coordinates ((GtkWidget*) row, (GtkWidget*) self, 0, 0, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	if (y < (-((1 + additionalRows) * rowHeight))) {
		result = -1;
		return result;
	}
	if (y > ((additionalRows * rowHeight) + scrollHeight)) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gboolean
feed_reader_article_list_scroll_scrollTick (FeedReaderArticleListScroll* self,
                                            GtkWidget* widget,
                                            GdkFrameClock* frame_clock)
{
	gint64 now = 0LL;
	gdouble t = 0.0;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		GtkAdjustment* _tmp0_;
		GtkAdjustment* _tmp1_;
		_tmp0_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp1_ = _tmp0_;
		gtk_adjustment_set_value (_tmp1_, self->priv->m_transitionStartValue + self->priv->m_transitionDiff);
		result = FALSE;
		return result;
	}
	now = gdk_frame_clock_get_frame_time (frame_clock);
	t = 1.0;
	if (now < self->priv->m_endTime) {
		t = (now - self->priv->m_startTime) / ((gdouble) (self->priv->m_endTime - self->priv->m_startTime));
	}
	t = feed_reader_article_list_scroll_easeOutCubic (self, t);
	_tmp2_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp3_ = _tmp2_;
	gtk_adjustment_set_value (_tmp3_, self->priv->m_transitionStartValue + (t * self->priv->m_transitionDiff));
	_tmp5_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_adjustment_get_value (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ <= ((gdouble) 0)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = now >= self->priv->m_endTime;
	}
	if (_tmp4_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
		self->priv->m_transitionStartValue = 0.0;
		self->priv->m_scrollCallbackID = (guint) 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static inline gdouble
feed_reader_article_list_scroll_easeOutCubic (FeedReaderArticleListScroll* self,
                                              gdouble t)
{
	gdouble p = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	p = t - 1;
	result = ((p * p) * p) + 1;
	return result;
}

void
feed_reader_article_list_scroll_allowSignals (FeedReaderArticleListScroll* self,
                                              gboolean allow)
{
	g_return_if_fail (self != NULL);
	self->priv->m_allowSignals = allow;
}

static void
feed_reader_article_list_scroll_class_init (FeedReaderArticleListScrollClass * klass,
                                            gpointer klass_data)
{
	feed_reader_article_list_scroll_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderArticleListScroll_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_article_list_scroll_finalize;
	feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_TOP_SIGNAL] = g_signal_new ("scrolled-top", FEED_READER_TYPE_ARTICLE_LIST_SCROLL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_SCROLLED_BOTTOM_SIGNAL] = g_signal_new ("scrolled-bottom", FEED_READER_TYPE_ARTICLE_LIST_SCROLL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_article_list_scroll_signals[FEED_READER_ARTICLE_LIST_SCROLL_VALUE_CHANGED_SIGNAL] = g_signal_new ("value-changed", FEED_READER_TYPE_ARTICLE_LIST_SCROLL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, FEED_READER_TYPE_SCROLL_DIRECTION);
}

static void
feed_reader_article_list_scroll_instance_init (FeedReaderArticleListScroll * self,
                                               gpointer klass)
{
	self->priv = feed_reader_article_list_scroll_get_instance_private (self);
	self->priv->m_upperCache = 0.0;
	self->priv->m_valueCache = 0.0;
	self->priv->m_valueThreshold = 50.0;
	self->priv->m_bottomThreshold = 200.0;
	self->priv->m_balance = FEED_READER_ARTICLE_LIST_BALANCE_NONE;
	self->priv->m_allowSignals = TRUE;
	self->priv->m_scrolledTopOnCooldown = FALSE;
	self->priv->m_scrolledBottomOnCooldown = FALSE;
	self->priv->m_scrollCooldown = 500;
	self->priv->m_startTime = (gint64) 0;
	self->priv->m_endTime = (gint64) 0;
	self->priv->m_transitionDiff = 0.0;
	self->priv->m_transitionStartValue = 0.0;
	self->priv->m_transitionDuration = 500 * 1000;
	self->priv->m_scrollCallbackID = (guint) 0;
	self->priv->m_savetyFallbackID = (guint) 0;
	self->priv->m_scrollCooldownID = (guint) 0;
}

static void
feed_reader_article_list_scroll_finalize (GObject * obj)
{
	FeedReaderArticleListScroll * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_ARTICLE_LIST_SCROLL, FeedReaderArticleListScroll);
	G_OBJECT_CLASS (feed_reader_article_list_scroll_parent_class)->finalize (obj);
}

static GType
feed_reader_article_list_scroll_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderArticleListScrollClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_article_list_scroll_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderArticleListScroll), 0, (GInstanceInitFunc) feed_reader_article_list_scroll_instance_init, NULL };
	GType feed_reader_article_list_scroll_type_id;
	feed_reader_article_list_scroll_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "FeedReaderArticleListScroll", &g_define_type_info, 0);
	FeedReaderArticleListScroll_private_offset = g_type_add_instance_private (feed_reader_article_list_scroll_type_id, sizeof (FeedReaderArticleListScrollPrivate));
	return feed_reader_article_list_scroll_type_id;
}

GType
feed_reader_article_list_scroll_get_type (void)
{
	static volatile gsize feed_reader_article_list_scroll_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_article_list_scroll_type_id__once)) {
		GType feed_reader_article_list_scroll_type_id;
		feed_reader_article_list_scroll_type_id = feed_reader_article_list_scroll_get_type_once ();
		g_once_init_leave (&feed_reader_article_list_scroll_type_id__once, feed_reader_article_list_scroll_type_id);
	}
	return feed_reader_article_list_scroll_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

