/* ColorCircle.c generated by valac 0.56.3, the Vala compiler
 * generated from ColorCircle.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>

enum  {
	FEED_READER_COLOR_CIRCLE_0_PROPERTY,
	FEED_READER_COLOR_CIRCLE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_color_circle_properties[FEED_READER_COLOR_CIRCLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
enum  {
	FEED_READER_COLOR_CIRCLE_CLICKED_SIGNAL,
	FEED_READER_COLOR_CIRCLE_NUM_SIGNALS
};
static guint feed_reader_color_circle_signals[FEED_READER_COLOR_CIRCLE_NUM_SIGNALS] = {0};

struct _FeedReaderColorCirclePrivate {
	GtkImage* m_icon;
	GtkImage* m_icon_light;
	gint m_color;
};

static gint FeedReaderColorCircle_private_offset;
static gpointer feed_reader_color_circle_parent_class = NULL;

static cairo_surface_t* feed_reader_color_circle_drawIcon (FeedReaderColorCircle* self,
                                                    gboolean light);
static gboolean feed_reader_color_circle_IconEnter (FeedReaderColorCircle* self);
static gboolean _feed_reader_color_circle_IconEnter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                            GdkEventCrossing* event,
                                                                            gpointer self);
static gboolean feed_reader_color_circle_IconLeave (FeedReaderColorCircle* self);
static gboolean _feed_reader_color_circle_IconLeave_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                            GdkEventCrossing* event,
                                                                            gpointer self);
static gboolean feed_reader_color_circle_IconClicked (FeedReaderColorCircle* self,
                                               GdkEventButton* event);
static gboolean _feed_reader_color_circle_IconClicked_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static void feed_reader_color_circle_finalize (GObject * obj);
static GType feed_reader_color_circle_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const gchar* FEED_READER_CONSTANTS_COLORS[24];

static inline gpointer
feed_reader_color_circle_get_instance_private (FeedReaderColorCircle* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderColorCircle_private_offset);
}

static gboolean
_feed_reader_color_circle_IconEnter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                   GdkEventCrossing* event,
                                                                   gpointer self)
{
	gboolean result;
	result = feed_reader_color_circle_IconEnter ((FeedReaderColorCircle*) self);
	return result;
}

static gboolean
_feed_reader_color_circle_IconLeave_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                   GdkEventCrossing* event,
                                                                   gpointer self)
{
	gboolean result;
	result = feed_reader_color_circle_IconLeave ((FeedReaderColorCircle*) self);
	return result;
}

static gboolean
_feed_reader_color_circle_IconClicked_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = feed_reader_color_circle_IconClicked ((FeedReaderColorCircle*) self, event);
	return result;
}

FeedReaderColorCircle*
feed_reader_color_circle_construct (GType object_type,
                                    gint color,
                                    gboolean clickable)
{
	FeedReaderColorCircle * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	GtkImage* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	self = (FeedReaderColorCircle*) g_object_new (object_type, NULL);
	self->priv->m_color = color;
	_tmp0_ = feed_reader_color_circle_drawIcon (self, FALSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkImage*) gtk_image_new_from_surface (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->m_icon);
	self->priv->m_icon = _tmp2_;
	_cairo_surface_destroy0 (_tmp1_);
	_tmp3_ = feed_reader_color_circle_drawIcon (self, TRUE);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkImage*) gtk_image_new_from_surface (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_icon_light);
	self->priv->m_icon_light = _tmp5_;
	_cairo_surface_destroy0 (_tmp4_);
	gtk_widget_set_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	gtk_widget_set_events ((GtkWidget*) self, (gint) GDK_ENTER_NOTIFY_MASK);
	gtk_widget_set_events ((GtkWidget*) self, (gint) GDK_LEAVE_NOTIFY_MASK);
	gtk_widget_set_size_request ((GtkWidget*) self, 16, 16);
	if (clickable) {
		g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _feed_reader_color_circle_IconEnter_gtk_widget_enter_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _feed_reader_color_circle_IconLeave_gtk_widget_leave_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _feed_reader_color_circle_IconClicked_gtk_widget_button_press_event, self, 0);
	}
	_tmp6_ = self->priv->m_icon;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

FeedReaderColorCircle*
feed_reader_color_circle_new (gint color,
                              gboolean clickable)
{
	return feed_reader_color_circle_construct (FEED_READER_TYPE_COLOR_CIRCLE, color, clickable);
}

void
feed_reader_color_circle_newColor (FeedReaderColorCircle* self,
                                   gint color)
{
	GtkImage* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	GtkImage* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	g_return_if_fail (self != NULL);
	self->priv->m_color = color;
	_tmp0_ = self->priv->m_icon;
	_tmp1_ = feed_reader_color_circle_drawIcon (self, FALSE);
	_tmp2_ = _tmp1_;
	gtk_image_set_from_surface (_tmp0_, _tmp2_);
	_cairo_surface_destroy0 (_tmp2_);
	_tmp3_ = self->priv->m_icon_light;
	_tmp4_ = feed_reader_color_circle_drawIcon (self, TRUE);
	_tmp5_ = _tmp4_;
	gtk_image_set_from_surface (_tmp3_, _tmp5_);
	_cairo_surface_destroy0 (_tmp5_);
}

static gboolean
feed_reader_color_circle_IconEnter (FeedReaderColorCircle* self)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_icon;
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->m_icon_light;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	gtk_widget_show_all ((GtkWidget*) self);
	result = TRUE;
	return result;
}

static gboolean
feed_reader_color_circle_IconLeave (FeedReaderColorCircle* self)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_icon_light;
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->m_icon;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	gtk_widget_show_all ((GtkWidget*) self);
	result = TRUE;
	return result;
}

static gboolean
feed_reader_color_circle_IconClicked (FeedReaderColorCircle* self,
                                      GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	switch (event->type) {
		case GDK_BUTTON_RELEASE:
		case GDK_2BUTTON_PRESS:
		case GDK_3BUTTON_PRESS:
		{
			result = FALSE;
			return result;
		}
		default:
		break;
	}
	feed_reader_logger_debug ("ColorCircle: click");
	g_signal_emit (self, feed_reader_color_circle_signals[FEED_READER_COLOR_CIRCLE_CLICKED_SIGNAL], 0, self->priv->m_color);
	result = TRUE;
	return result;
}

static cairo_surface_t*
feed_reader_color_circle_drawIcon (FeedReaderColorCircle* self,
                                   gboolean light)
{
	gint scaleFactor = 0;
	gint size = 0;
	GdkRGBA color = {0};
	const gchar* _tmp0_;
	gdouble lighten = 0.0;
	cairo_surface_t* surface = NULL;
	GdkWindow* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_t* context = NULL;
	cairo_t* _tmp3_;
	gdouble half = 0.0;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	scaleFactor = gtk_widget_get_scale_factor ((GtkWidget*) self);
	size = 16 * scaleFactor;
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = FEED_READER_CONSTANTS_COLORS[self->priv->m_color];
	gdk_rgba_parse (&color, _tmp0_);
	lighten = 1.0;
	if (light) {
		lighten = 0.7;
	}
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_window_create_similar_image_surface (_tmp1_, 0, size, size, 0);
	surface = _tmp2_;
	_tmp3_ = cairo_create (surface);
	context = _tmp3_;
	cairo_set_line_width (context, (gdouble) 2);
	cairo_set_fill_rule (context, CAIRO_FILL_RULE_EVEN_ODD);
	half = (gdouble) (size / (2 * scaleFactor));
	_tmp4_ = color;
	_tmp5_ = color;
	_tmp6_ = color;
	cairo_set_source_rgba (context, _tmp4_.red, _tmp5_.green, _tmp6_.blue, 0.6 * lighten);
	cairo_arc (context, half, half, half, (gdouble) 0, 2 * G_PI);
	cairo_fill_preserve (context);
	cairo_arc (context, half, half, half - (half / 4), (gdouble) 0, 2 * G_PI);
	_tmp7_ = color;
	_tmp8_ = color;
	_tmp9_ = color;
	cairo_set_source_rgba (context, _tmp7_.red, _tmp8_.green, _tmp9_.blue, 0.6 * lighten);
	cairo_fill_preserve (context);
	result = surface;
	_cairo_destroy0 (context);
	return result;
}

static void
feed_reader_color_circle_class_init (FeedReaderColorCircleClass * klass,
                                     gpointer klass_data)
{
	feed_reader_color_circle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderColorCircle_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_color_circle_finalize;
	feed_reader_color_circle_signals[FEED_READER_COLOR_CIRCLE_CLICKED_SIGNAL] = g_signal_new ("clicked", FEED_READER_TYPE_COLOR_CIRCLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
feed_reader_color_circle_instance_init (FeedReaderColorCircle * self,
                                        gpointer klass)
{
	self->priv = feed_reader_color_circle_get_instance_private (self);
}

static void
feed_reader_color_circle_finalize (GObject * obj)
{
	FeedReaderColorCircle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_COLOR_CIRCLE, FeedReaderColorCircle);
	_g_object_unref0 (self->priv->m_icon);
	_g_object_unref0 (self->priv->m_icon_light);
	G_OBJECT_CLASS (feed_reader_color_circle_parent_class)->finalize (obj);
}

static GType
feed_reader_color_circle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderColorCircleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_color_circle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderColorCircle), 0, (GInstanceInitFunc) feed_reader_color_circle_instance_init, NULL };
	GType feed_reader_color_circle_type_id;
	feed_reader_color_circle_type_id = g_type_register_static (gtk_event_box_get_type (), "FeedReaderColorCircle", &g_define_type_info, 0);
	FeedReaderColorCircle_private_offset = g_type_add_instance_private (feed_reader_color_circle_type_id, sizeof (FeedReaderColorCirclePrivate));
	return feed_reader_color_circle_type_id;
}

GType
feed_reader_color_circle_get_type (void)
{
	static volatile gsize feed_reader_color_circle_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_color_circle_type_id__once)) {
		GType feed_reader_color_circle_type_id;
		feed_reader_color_circle_type_id = feed_reader_color_circle_get_type_once ();
		g_once_init_leave (&feed_reader_color_circle_type_id__once, feed_reader_color_circle_type_id);
	}
	return feed_reader_color_circle_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

