/* ColumnView.c generated by valac 0.56.3, the Vala compiler
 * generated from ColumnView.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

enum  {
	FEED_READER_COLUMN_VIEW_0_PROPERTY,
	FEED_READER_COLUMN_VIEW_NUM_PROPERTIES
};
static GParamSpec* feed_reader_column_view_properties[FEED_READER_COLUMN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;

struct _FeedReaderColumnViewPrivate {
	GtkPaned* m_pane;
	FeedReaderArticleView* m_article_view;
	FeedReaderArticleList* m_articleList;
	FeedReaderfeedList* m_feedList;
	FeedReaderFeedListFooter* m_footer;
	FeedReaderColumnViewHeader* m_headerbar;
};

struct _Block15Data {
	int _ref_count_;
	FeedReaderColumnView* self;
	GtkStackTransitionType transition;
};

struct _Block16Data {
	int _ref_count_;
	Block15Data * _data15_;
	gulong id;
};

static gint FeedReaderColumnView_private_offset;
static gpointer feed_reader_column_view_parent_class = NULL;
static FeedReaderColumnView* feed_reader_column_view_m_columnView;
static FeedReaderColumnView* feed_reader_column_view_m_columnView = NULL;

static FeedReaderColumnView* feed_reader_column_view_new (void);
static FeedReaderColumnView* feed_reader_column_view_construct (GType object_type);
static void __lambda342_ (FeedReaderColumnView* self);
static void ___lambda342__feed_reader_feed_list_clear_selected (FeedReaderfeedList* _sender,
                                                         gpointer self);
static void __lambda343_ (FeedReaderColumnView* self,
                   const gchar* feedID);
static void ___lambda343__feed_reader_feed_list_new_feed_selected (FeedReaderfeedList* _sender,
                                                            const gchar* feedID,
                                                            gpointer self);
static void __lambda344_ (FeedReaderColumnView* self,
                   const gchar* tagID);
static void ___lambda344__feed_reader_feed_list_new_tag_selected (FeedReaderfeedList* _sender,
                                                           const gchar* tagID,
                                                           gpointer self);
static void __lambda345_ (FeedReaderColumnView* self,
                   const gchar* categorieID);
static void ___lambda345__feed_reader_feed_list_new_categorie_selected (FeedReaderfeedList* _sender,
                                                                 const gchar* categorieID,
                                                                 gpointer self);
static void _feed_reader_column_view_markAllArticlesAsRead_feed_reader_feed_list_mark_all_articles_as_read (FeedReaderfeedList* _sender,
                                                                                                     gpointer self);
static void __lambda346_ (FeedReaderColumnView* self,
                   GdkDragContext* context);
static void ___lambda346__gtk_widget_drag_begin (GtkWidget* _sender,
                                          GdkDragContext* context,
                                          gpointer self);
static void __lambda347_ (FeedReaderColumnView* self,
                   GdkDragContext* context);
static void ___lambda347__gtk_widget_drag_end (GtkWidget* _sender,
                                        GdkDragContext* context,
                                        gpointer self);
static gboolean __lambda348_ (FeedReaderColumnView* self,
                       GdkDragContext* context,
                       GtkDragResult _result_);
static gboolean ___lambda348__gtk_widget_drag_failed (GtkWidget* _sender,
                                               GdkDragContext* context,
                                               GtkDragResult _result_,
                                               gpointer self);
static void feed_reader_column_view_setArticleListState (FeedReaderColumnView* self,
                                                  FeedReaderArticleListState state);
static void __lambda349_ (FeedReaderColumnView* self,
                   FeedReaderArticleRow* row);
static void ___lambda349__feed_reader_article_list_row_activated (FeedReaderArticleList* _sender,
                                                           FeedReaderArticleRow* row,
                                                           gpointer self);
static void __lambda350_ (FeedReaderColumnView* self);
static void ___lambda350__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda351_ (FeedReaderColumnView* self);
static void ___lambda351__feed_reader_column_view_header_refresh (FeedReaderColumnViewHeader* _sender,
                                                           gpointer self);
static void __lambda352_ (FeedReaderColumnView* self);
static void ___lambda352__feed_reader_column_view_header_cancel (FeedReaderColumnViewHeader* _sender,
                                                          gpointer self);
static void __lambda353_ (FeedReaderColumnView* self,
                   FeedReaderArticleListState state,
                   GtkStackTransitionType transition);
static void ___lambda353__feed_reader_column_view_header_change_state (FeedReaderColumnViewHeader* _sender,
                                                                FeedReaderArticleListState state,
                                                                GtkStackTransitionType transition,
                                                                gpointer self);
static void __lambda354_ (FeedReaderColumnView* self,
                   const gchar* searchTerm);
static void feed_reader_column_view_setSearchTerm (FeedReaderColumnView* self,
                                            const gchar* searchTerm);
static void ___lambda354__feed_reader_column_view_header_search_term (FeedReaderColumnViewHeader* _sender,
                                                               const gchar* searchTerm,
                                                               gpointer self);
static void __lambda355_ (FeedReaderColumnView* self);
static void ___lambda355__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda356_ (FeedReaderColumnView* self);
static void ___lambda356__feed_reader_column_view_header_toggled_marked (FeedReaderColumnViewHeader* _sender,
                                                                  gpointer self);
static void __lambda357_ (FeedReaderColumnView* self);
static void ___lambda357__feed_reader_column_view_header_toggled_read (FeedReaderColumnViewHeader* _sender,
                                                                gpointer self);
static void __lambda358_ (FeedReaderColumnView* self);
static void feed_reader_column_view_clearArticleView (FeedReaderColumnView* self);
static void ___lambda358__feed_reader_column_view_header_close_article (FeedReaderColumnViewHeader* _sender,
                                                                 gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean ___lambda185_ (Block16Data* _data16_);
static gboolean ____lambda185__gtk_widget_draw (GtkWidget* _sender,
                                         cairo_t* cr,
                                         gpointer self);
static void feed_reader_column_view_finalize (GObject * obj);
static GType feed_reader_column_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_column_view_get_instance_private (FeedReaderColumnView* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderColumnView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderColumnView*
feed_reader_column_view_get_default (void)
{
	FeedReaderColumnView* _tmp0_;
	FeedReaderColumnView* _tmp2_;
	FeedReaderColumnView* _tmp3_;
	FeedReaderColumnView* result;
	_tmp0_ = feed_reader_column_view_m_columnView;
	if (_tmp0_ == NULL) {
		FeedReaderColumnView* _tmp1_;
		_tmp1_ = feed_reader_column_view_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (feed_reader_column_view_m_columnView);
		feed_reader_column_view_m_columnView = _tmp1_;
	}
	_tmp2_ = feed_reader_column_view_m_columnView;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
__lambda342_ (FeedReaderColumnView* self)
{
	FeedReaderFeedListFooter* _tmp0_;
	_tmp0_ = self->priv->m_footer;
	feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp0_, FALSE);
}

static void
___lambda342__feed_reader_feed_list_clear_selected (FeedReaderfeedList* _sender,
                                                    gpointer self)
{
	__lambda342_ ((FeedReaderColumnView*) self);
}

static void
__lambda343_ (FeedReaderColumnView* self,
              const gchar* feedID)
{
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (feedID != NULL);
	feed_reader_logger_debug ("ContentPage: new Feed selected");
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_setSelectedType (_tmp0_, FEED_READER_FEED_LIST_TYPE_FEED);
	_tmp1_ = self->priv->m_articleList;
	feed_reader_article_list_setSelectedFeed (_tmp1_, feedID);
	feed_reader_column_view_newArticleList (self, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp2_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (feedID, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		FeedReaderFeedListFooter* _tmp5_;
		_tmp5_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp5_, FALSE);
	} else {
		FeedReaderFeedListFooter* _tmp6_;
		FeedReaderFeedListFooter* _tmp7_;
		_tmp6_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp6_, TRUE);
		_tmp7_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setSelectedRow (_tmp7_, FEED_READER_FEED_LIST_TYPE_FEED, feedID);
	}
}

static void
___lambda343__feed_reader_feed_list_new_feed_selected (FeedReaderfeedList* _sender,
                                                       const gchar* feedID,
                                                       gpointer self)
{
	__lambda343_ ((FeedReaderColumnView*) self, feedID);
}

static void
__lambda344_ (FeedReaderColumnView* self,
              const gchar* tagID)
{
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	FeedReaderFeedListFooter* _tmp2_;
	FeedReaderFeedListFooter* _tmp3_;
	g_return_if_fail (tagID != NULL);
	feed_reader_logger_debug ("ContentPage: new Tag selected");
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_setSelectedType (_tmp0_, FEED_READER_FEED_LIST_TYPE_TAG);
	_tmp1_ = self->priv->m_articleList;
	feed_reader_article_list_setSelectedFeed (_tmp1_, tagID);
	feed_reader_column_view_newArticleList (self, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp2_ = self->priv->m_footer;
	feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp2_, TRUE);
	_tmp3_ = self->priv->m_footer;
	feed_reader_feed_list_footer_setSelectedRow (_tmp3_, FEED_READER_FEED_LIST_TYPE_TAG, tagID);
}

static void
___lambda344__feed_reader_feed_list_new_tag_selected (FeedReaderfeedList* _sender,
                                                      const gchar* tagID,
                                                      gpointer self)
{
	__lambda344_ ((FeedReaderColumnView*) self, tagID);
}

static void
__lambda345_ (FeedReaderColumnView* self,
              const gchar* categorieID)
{
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (categorieID != NULL);
	feed_reader_logger_debug ("ContentPage: new Category selected");
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_setSelectedType (_tmp0_, FEED_READER_FEED_LIST_TYPE_CATEGORY);
	_tmp1_ = self->priv->m_articleList;
	feed_reader_article_list_setSelectedFeed (_tmp1_, categorieID);
	feed_reader_column_view_newArticleList (self, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp3_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (categorieID, _tmp4_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
		_tmp7_ = _tmp6_;
		_tmp2_ = g_strcmp0 (categorieID, _tmp7_) != 0;
		_g_free0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		FeedReaderFeedListFooter* _tmp8_;
		FeedReaderFeedListFooter* _tmp9_;
		_tmp8_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp8_, TRUE);
		_tmp9_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setSelectedRow (_tmp9_, FEED_READER_FEED_LIST_TYPE_CATEGORY, categorieID);
	} else {
		FeedReaderFeedListFooter* _tmp10_;
		_tmp10_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp10_, FALSE);
	}
}

static void
___lambda345__feed_reader_feed_list_new_categorie_selected (FeedReaderfeedList* _sender,
                                                            const gchar* categorieID,
                                                            gpointer self)
{
	__lambda345_ ((FeedReaderColumnView*) self, categorieID);
}

static void
_feed_reader_column_view_markAllArticlesAsRead_feed_reader_feed_list_mark_all_articles_as_read (FeedReaderfeedList* _sender,
                                                                                                gpointer self)
{
	feed_reader_column_view_markAllArticlesAsRead ((FeedReaderColumnView*) self);
}

static void
__lambda346_ (FeedReaderColumnView* self,
              GdkDragContext* context)
{
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FeedReaderfeedList* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FeedReaderfeedList* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	FeedReaderfeedList* _tmp15_;
	g_return_if_fail (context != NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_read_tags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_is_empty ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp6_) {
		FeedReaderfeedList* _tmp7_;
		FeedReaderArticleList* _tmp8_;
		_tmp7_ = self->priv->m_feedList;
		_tmp8_ = self->priv->m_articleList;
		feed_reader_feed_list_newFeedlist (_tmp7_, feed_reader_article_list_getState (_tmp8_), FALSE, TRUE);
	}
	_tmp9_ = self->priv->m_feedList;
	_tmp10_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
	_tmp11_ = _tmp10_;
	feed_reader_feed_list_expand_collapse_category (_tmp9_, _tmp11_, TRUE);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->m_feedList;
	_tmp13_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
	_tmp14_ = _tmp13_;
	feed_reader_feed_list_expand_collapse_category (_tmp12_, _tmp14_, FALSE);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->m_feedList;
	feed_reader_feed_list_addEmptyTagRow (_tmp15_);
}

static void
___lambda346__gtk_widget_drag_begin (GtkWidget* _sender,
                                     GdkDragContext* context,
                                     gpointer self)
{
	__lambda346_ ((FeedReaderColumnView*) self, context);
}

static void
__lambda347_ (FeedReaderColumnView* self,
              GdkDragContext* context)
{
	FeedReaderfeedList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (context != NULL);
	feed_reader_logger_debug ("ContentPage: articleList drag_end signal");
	_tmp0_ = self->priv->m_feedList;
	_tmp1_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
	_tmp2_ = _tmp1_;
	feed_reader_feed_list_expand_collapse_category (_tmp0_, _tmp2_, TRUE);
	_g_free0 (_tmp2_);
}

static void
___lambda347__gtk_widget_drag_end (GtkWidget* _sender,
                                   GdkDragContext* context,
                                   gpointer self)
{
	__lambda347_ ((FeedReaderColumnView*) self, context);
}

static gboolean
__lambda348_ (FeedReaderColumnView* self,
              GdkDragContext* context,
              GtkDragResult _result_)
{
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	feed_reader_logger_debug ("ContentPage: articleList drag_failed signal");
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_read_tags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_is_empty ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp6_) {
		FeedReaderfeedList* _tmp7_;
		FeedReaderArticleList* _tmp8_;
		_tmp7_ = self->priv->m_feedList;
		_tmp8_ = self->priv->m_articleList;
		feed_reader_feed_list_newFeedlist (_tmp7_, feed_reader_article_list_getState (_tmp8_), FALSE, FALSE);
	} else {
		FeedReaderfeedList* _tmp9_;
		_tmp9_ = self->priv->m_feedList;
		feed_reader_feed_list_removeEmptyTagRow (_tmp9_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda348__gtk_widget_drag_failed (GtkWidget* _sender,
                                      GdkDragContext* context,
                                      GtkDragResult _result_,
                                      gpointer self)
{
	gboolean result;
	result = __lambda348_ ((FeedReaderColumnView*) self, context, _result_);
	return result;
}

static void
__lambda349_ (FeedReaderColumnView* self,
              FeedReaderArticleRow* row)
{
	FeedReaderArticleView* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = self->priv->m_article_view;
	_tmp1_ = feed_reader_article_view_getCurrentArticle (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_article_row_getID (row);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp2_, _tmp4_) != 0;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		FeedReaderArticleView* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		FeedReaderColumnViewHeader* _tmp9_;
		FeedReaderColumnViewHeader* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		FeedReaderColumnViewHeader* _tmp13_;
		FeedReaderArticle* _tmp14_;
		FeedReaderArticle* _tmp15_;
		FeedReaderColumnViewHeader* _tmp16_;
		FeedReaderArticle* _tmp17_;
		FeedReaderArticle* _tmp18_;
		FeedReaderColumnViewHeader* _tmp19_;
		FeedReaderArticleView* _tmp20_;
		_tmp6_ = self->priv->m_article_view;
		_tmp7_ = feed_reader_article_row_getID (row);
		_tmp8_ = _tmp7_;
		feed_reader_article_view_load (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = self->priv->m_headerbar;
		feed_reader_column_view_header_showArticleButtons (_tmp9_, TRUE);
		_tmp10_ = self->priv->m_headerbar;
		_tmp11_ = feed_reader_article_row_getName (row);
		_tmp12_ = _tmp11_;
		feed_reader_column_view_header_setTitle (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
		feed_reader_logger_debug ("ContentPage: set headerbar");
		_tmp13_ = self->priv->m_headerbar;
		_tmp14_ = feed_reader_article_row_getArticle (row);
		_tmp15_ = _tmp14_;
		feed_reader_column_view_header_setRead (_tmp13_, feed_reader_article_getUnread (_tmp15_));
		_g_object_unref0 (_tmp15_);
		_tmp16_ = self->priv->m_headerbar;
		_tmp17_ = feed_reader_article_row_getArticle (row);
		_tmp18_ = _tmp17_;
		feed_reader_column_view_header_setMarked (_tmp16_, feed_reader_article_getMarked (_tmp18_));
		_g_object_unref0 (_tmp18_);
		_tmp19_ = self->priv->m_headerbar;
		feed_reader_column_view_header_showMediaButton (_tmp19_, feed_reader_article_row_haveMedia (row));
		_tmp20_ = self->priv->m_article_view;
		feed_reader_article_view_showMediaButton (_tmp20_, feed_reader_article_row_haveMedia (row));
	}
}

static void
___lambda349__feed_reader_article_list_row_activated (FeedReaderArticleList* _sender,
                                                      FeedReaderArticleRow* row,
                                                      gpointer self)
{
	__lambda349_ ((FeedReaderColumnView*) self, row);
}

static void
__lambda350_ (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	_tmp0_ = self->priv->m_headerbar;
	gtk_paned_set_position ((GtkPaned*) _tmp0_, gtk_paned_get_position ((GtkPaned*) self));
}

static void
___lambda350__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda350_ ((FeedReaderColumnView*) self);
}

static void
__lambda351_ (FeedReaderColumnView* self)
{
	FeedReaderFeedReaderApp* app = NULL;
	FeedReaderFeedReaderApp* _tmp0_;
	feed_reader_column_view_syncStarted (self);
	_tmp0_ = feed_reader_feed_reader_app_get_default ();
	app = _tmp0_;
	feed_reader_feed_reader_app_sync (app);
	_g_object_unref0 (app);
}

static void
___lambda351__feed_reader_column_view_header_refresh (FeedReaderColumnViewHeader* _sender,
                                                      gpointer self)
{
	__lambda351_ ((FeedReaderColumnView*) self);
}

static void
__lambda352_ (FeedReaderColumnView* self)
{
	FeedReaderFeedReaderApp* _tmp0_;
	FeedReaderFeedReaderApp* _tmp1_;
	_tmp0_ = feed_reader_feed_reader_app_get_default ();
	_tmp1_ = _tmp0_;
	feed_reader_feed_reader_app_cancelSync (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda352__feed_reader_column_view_header_cancel (FeedReaderColumnViewHeader* _sender,
                                                     gpointer self)
{
	__lambda352_ ((FeedReaderColumnView*) self);
}

static void
__lambda353_ (FeedReaderColumnView* self,
              FeedReaderArticleListState state,
              GtkStackTransitionType transition)
{
	feed_reader_column_view_setArticleListState (self, state);
	feed_reader_column_view_newArticleList (self, transition);
}

static void
___lambda353__feed_reader_column_view_header_change_state (FeedReaderColumnViewHeader* _sender,
                                                           FeedReaderArticleListState state,
                                                           GtkStackTransitionType transition,
                                                           gpointer self)
{
	__lambda353_ ((FeedReaderColumnView*) self, state, transition);
}

static void
__lambda354_ (FeedReaderColumnView* self,
              const gchar* searchTerm)
{
	g_return_if_fail (searchTerm != NULL);
	feed_reader_logger_debug ("MainWindow: new search term");
	feed_reader_column_view_setSearchTerm (self, searchTerm);
	feed_reader_column_view_newArticleList (self, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
}

static void
___lambda354__feed_reader_column_view_header_search_term (FeedReaderColumnViewHeader* _sender,
                                                          const gchar* searchTerm,
                                                          gpointer self)
{
	__lambda354_ ((FeedReaderColumnView*) self, searchTerm);
}

static void
__lambda355_ (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	_tmp0_ = self->priv->m_headerbar;
	gtk_paned_set_position ((GtkPaned*) self, gtk_paned_get_position ((GtkPaned*) _tmp0_));
}

static void
___lambda355__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda355_ ((FeedReaderColumnView*) self);
}

static void
__lambda356_ (FeedReaderColumnView* self)
{
	feed_reader_column_view_toggleMarkedSelectedArticle (self);
}

static void
___lambda356__feed_reader_column_view_header_toggled_marked (FeedReaderColumnViewHeader* _sender,
                                                             gpointer self)
{
	__lambda356_ ((FeedReaderColumnView*) self);
}

static void
__lambda357_ (FeedReaderColumnView* self)
{
	feed_reader_column_view_toggleReadSelectedArticle (self);
}

static void
___lambda357__feed_reader_column_view_header_toggled_read (FeedReaderColumnViewHeader* _sender,
                                                           gpointer self)
{
	__lambda357_ ((FeedReaderColumnView*) self);
}

static void
__lambda358_ (FeedReaderColumnView* self)
{
	feed_reader_column_view_clearArticleView (self);
}

static void
___lambda358__feed_reader_column_view_header_close_article (FeedReaderColumnViewHeader* _sender,
                                                            gpointer self)
{
	__lambda358_ ((FeedReaderColumnView*) self);
}

static FeedReaderColumnView*
feed_reader_column_view_construct (GType object_type)
{
	FeedReaderColumnView * self = NULL;
	FeedReaderfeedList* _tmp0_;
	FeedReaderFeedListFooter* _tmp1_;
	GtkBox* feedListBox = NULL;
	GtkBox* _tmp2_;
	FeedReaderfeedList* _tmp3_;
	FeedReaderFeedListFooter* _tmp4_;
	GtkPaned* _tmp5_;
	GtkPaned* _tmp6_;
	GtkPaned* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GtkPaned* _tmp10_;
	FeedReaderfeedList* _tmp11_;
	FeedReaderfeedList* _tmp12_;
	FeedReaderfeedList* _tmp13_;
	FeedReaderfeedList* _tmp14_;
	FeedReaderfeedList* _tmp15_;
	FeedReaderArticleList* _tmp16_;
	FeedReaderArticleList* _tmp17_;
	FeedReaderArticleList* _tmp18_;
	FeedReaderArticleList* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	GtkPaned* _tmp22_;
	FeedReaderArticleList* _tmp23_;
	FeedReaderArticleList* _tmp24_;
	FeedReaderArticleView* _tmp25_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	GtkPaned* _tmp28_;
	FeedReaderArticleView* _tmp29_;
	FeedReaderColumnViewHeader* _tmp30_;
	FeedReaderColumnViewHeader* _tmp31_;
	FeedReaderColumnViewHeader* _tmp32_;
	FeedReaderColumnViewHeader* _tmp33_;
	FeedReaderColumnViewHeader* _tmp34_;
	FeedReaderColumnViewHeader* _tmp35_;
	FeedReaderColumnViewHeader* _tmp36_;
	FeedReaderColumnViewHeader* _tmp37_;
	FeedReaderColumnViewHeader* _tmp38_;
	self = (FeedReaderColumnView*) g_object_new (object_type, NULL);
	feed_reader_logger_debug ("ColumnView: setup");
	_tmp0_ = feed_reader_feed_list_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_feedList);
	self->priv->m_feedList = _tmp0_;
	_tmp1_ = feed_reader_feed_list_footer_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->m_footer);
	self->priv->m_footer = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	feedListBox = _tmp2_;
	_tmp3_ = self->priv->m_feedList;
	gtk_box_pack_start (feedListBox, (GtkWidget*) _tmp3_, TRUE, TRUE, (guint) 0);
	_tmp4_ = self->priv->m_footer;
	gtk_box_pack_end (feedListBox, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_pane);
	self->priv->m_pane = _tmp5_;
	_tmp6_ = self->priv->m_pane;
	gtk_widget_set_size_request ((GtkWidget*) _tmp6_, 0, 300);
	_tmp7_ = self->priv->m_pane;
	_tmp8_ = feed_reader_settings_state ();
	_tmp9_ = _tmp8_;
	gtk_paned_set_position (_tmp7_, g_settings_get_int (_tmp9_, "feed-row-width"));
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->m_pane;
	gtk_paned_pack1 (_tmp10_, (GtkWidget*) feedListBox, FALSE, FALSE);
	_tmp11_ = self->priv->m_feedList;
	g_signal_connect_object (_tmp11_, "clear-selected", (GCallback) ___lambda342__feed_reader_feed_list_clear_selected, self, 0);
	_tmp12_ = self->priv->m_feedList;
	g_signal_connect_object (_tmp12_, "new-feed-selected", (GCallback) ___lambda343__feed_reader_feed_list_new_feed_selected, self, 0);
	_tmp13_ = self->priv->m_feedList;
	g_signal_connect_object (_tmp13_, "new-tag-selected", (GCallback) ___lambda344__feed_reader_feed_list_new_tag_selected, self, 0);
	_tmp14_ = self->priv->m_feedList;
	g_signal_connect_object (_tmp14_, "new-categorie-selected", (GCallback) ___lambda345__feed_reader_feed_list_new_categorie_selected, self, 0);
	_tmp15_ = self->priv->m_feedList;
	g_signal_connect_object (_tmp15_, "mark-all-articles-as-read", (GCallback) _feed_reader_column_view_markAllArticlesAsRead_feed_reader_feed_list_mark_all_articles_as_read, self, 0);
	_tmp16_ = feed_reader_article_list_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->m_articleList);
	self->priv->m_articleList = _tmp16_;
	_tmp17_ = self->priv->m_articleList;
	g_signal_connect_object ((GtkWidget*) _tmp17_, "drag-begin", (GCallback) ___lambda346__gtk_widget_drag_begin, self, 0);
	_tmp18_ = self->priv->m_articleList;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "drag-end", (GCallback) ___lambda347__gtk_widget_drag_end, self, 0);
	_tmp19_ = self->priv->m_articleList;
	g_signal_connect_object ((GtkWidget*) _tmp19_, "drag-failed", (GCallback) ___lambda348__gtk_widget_drag_failed, self, 0);
	_tmp20_ = feed_reader_settings_state ();
	_tmp21_ = _tmp20_;
	feed_reader_column_view_setArticleListState (self, (FeedReaderArticleListState) g_settings_get_enum (_tmp21_, "show-articles"));
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->m_pane;
	_tmp23_ = self->priv->m_articleList;
	gtk_paned_pack2 (_tmp22_, (GtkWidget*) _tmp23_, FALSE, FALSE);
	_tmp24_ = self->priv->m_articleList;
	g_signal_connect_object (_tmp24_, "row-activated", (GCallback) ___lambda349__feed_reader_article_list_row_activated, self, 0);
	_tmp25_ = feed_reader_article_view_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->m_article_view);
	self->priv->m_article_view = _tmp25_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	_tmp26_ = feed_reader_settings_state ();
	_tmp27_ = _tmp26_;
	gtk_paned_set_position ((GtkPaned*) self, g_settings_get_int (_tmp27_, "feeds-and-articles-width"));
	_g_object_unref0 (_tmp27_);
	_tmp28_ = self->priv->m_pane;
	gtk_paned_pack1 ((GtkPaned*) self, (GtkWidget*) _tmp28_, FALSE, FALSE);
	_tmp29_ = self->priv->m_article_view;
	gtk_paned_pack2 ((GtkPaned*) self, (GtkWidget*) _tmp29_, TRUE, FALSE);
	g_signal_connect_object ((GObject*) self, "notify::position", (GCallback) ___lambda350__g_object_notify, self, 0);
	_tmp30_ = feed_reader_column_view_header_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->m_headerbar);
	self->priv->m_headerbar = _tmp30_;
	_tmp31_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp31_, "refresh", (GCallback) ___lambda351__feed_reader_column_view_header_refresh, self, 0);
	_tmp32_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp32_, "cancel", (GCallback) ___lambda352__feed_reader_column_view_header_cancel, self, 0);
	_tmp33_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp33_, "change-state", (GCallback) ___lambda353__feed_reader_column_view_header_change_state, self, 0);
	_tmp34_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp34_, "search-term", (GCallback) ___lambda354__feed_reader_column_view_header_search_term, self, 0);
	_tmp35_ = self->priv->m_headerbar;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::position", (GCallback) ___lambda355__g_object_notify, self, 0);
	_tmp36_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp36_, "toggled-marked", (GCallback) ___lambda356__feed_reader_column_view_header_toggled_marked, self, 0);
	_tmp37_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp37_, "toggled-read", (GCallback) ___lambda357__feed_reader_column_view_header_toggled_read, self, 0);
	_tmp38_ = self->priv->m_headerbar;
	g_signal_connect_object (_tmp38_, "close-article", (GCallback) ___lambda358__feed_reader_column_view_header_close_article, self, 0);
	_g_object_unref0 (feedListBox);
	return self;
}

static FeedReaderColumnView*
feed_reader_column_view_new (void)
{
	return feed_reader_column_view_construct (FEED_READER_TYPE_COLUMN_VIEW);
}

void
feed_reader_column_view_hidePane (FeedReaderColumnView* self)
{
	GtkPaned* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_pane;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
}

void
feed_reader_column_view_showPane (FeedReaderColumnView* self)
{
	GtkPaned* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_pane;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
}

gint
feed_reader_column_view_ArticleListNEXT (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	FeedReaderArticleList* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_article_view;
	if (feed_reader_article_view_fullscreenArticle (_tmp0_)) {
		FeedReaderArticleView* _tmp1_;
		_tmp1_ = self->priv->m_article_view;
		feed_reader_article_view_setTransition (_tmp1_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT, (guint) 500);
	}
	_tmp2_ = self->priv->m_articleList;
	result = feed_reader_article_list_move (_tmp2_, FALSE);
	return result;
}

gint
feed_reader_column_view_ArticleListPREV (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	FeedReaderArticleList* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_article_view;
	if (feed_reader_article_view_fullscreenArticle (_tmp0_)) {
		FeedReaderArticleView* _tmp1_;
		_tmp1_ = self->priv->m_article_view;
		feed_reader_article_view_setTransition (_tmp1_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT, (guint) 500);
	}
	_tmp2_ = self->priv->m_articleList;
	result = feed_reader_article_list_move (_tmp2_, TRUE);
	return result;
}

void
feed_reader_column_view_FeedListNEXT (FeedReaderColumnView* self)
{
	FeedReaderfeedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_feedList;
	feed_reader_feed_list_move (_tmp0_, FALSE);
}

void
feed_reader_column_view_FeedListPREV (FeedReaderColumnView* self)
{
	FeedReaderfeedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_feedList;
	feed_reader_feed_list_move (_tmp0_, TRUE);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		FeedReaderColumnView* self;
		self = _data15_->self;
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		FeedReaderColumnView* self;
		self = _data16_->_data15_->self;
		block15_data_unref (_data16_->_data15_);
		_data16_->_data15_ = NULL;
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
___lambda185_ (Block16Data* _data16_)
{
	Block15Data* _data15_;
	FeedReaderColumnView* self;
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	gboolean result;
	_data15_ = _data16_->_data15_;
	self = _data15_->self;
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_newList (_tmp0_, _data15_->transition);
	_tmp1_ = self->priv->m_articleList;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data16_->id);
	result = FALSE;
	return result;
}

static gboolean
____lambda185__gtk_widget_draw (GtkWidget* _sender,
                                cairo_t* cr,
                                gpointer self)
{
	gboolean result;
	result = ___lambda185_ (self);
	return result;
}

void
feed_reader_column_view_newArticleList (FeedReaderColumnView* self,
                                        GtkStackTransitionType transition)
{
	Block15Data* _data15_;
	gint height = 0;
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_data15_->transition = transition;
	feed_reader_logger_debug ("ContentPage.newArticleList");
	_tmp0_ = self->priv->m_articleList;
	height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp0_);
	if (height == 1) {
		Block16Data* _data16_;
		FeedReaderArticleList* _tmp1_;
		gulong _tmp2_;
		_data16_ = g_slice_new0 (Block16Data);
		_data16_->_ref_count_ = 1;
		_data16_->_data15_ = block15_data_ref (_data15_);
		_data16_->id = (gulong) 0;
		_tmp1_ = self->priv->m_articleList;
		_tmp2_ = g_signal_connect_data ((GtkWidget*) _tmp1_, "draw", (GCallback) ____lambda185__gtk_widget_draw, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, G_CONNECT_AFTER);
		_data16_->id = _tmp2_;
		block16_data_unref (_data16_);
		_data16_ = NULL;
	} else {
		FeedReaderArticleList* _tmp3_;
		_tmp3_ = self->priv->m_articleList;
		feed_reader_article_list_newList (_tmp3_, _data15_->transition);
	}
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

void
feed_reader_column_view_newFeedList (FeedReaderColumnView* self,
                                     gboolean defaultSettings)
{
	FeedReaderfeedList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_feedList;
	_tmp1_ = self->priv->m_articleList;
	feed_reader_feed_list_newFeedlist (_tmp0_, feed_reader_article_list_getState (_tmp1_), defaultSettings, FALSE);
}

void
feed_reader_column_view_refreshFeedListCounter (FeedReaderColumnView* self)
{
	FeedReaderfeedList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_feedList;
	_tmp1_ = self->priv->m_articleList;
	feed_reader_feed_list_refreshCounters (_tmp0_, feed_reader_article_list_getState (_tmp1_));
}

void
feed_reader_column_view_reloadArticleView (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_load (_tmp0_, NULL);
}

void
feed_reader_column_view_updateArticleList (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_updateArticleList (_tmp0_);
}

static void
feed_reader_column_view_setArticleListState (FeedReaderColumnView* self,
                                             FeedReaderArticleListState state)
{
	FeedReaderArticleListState oldState = 0;
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	oldState = feed_reader_article_list_getState (_tmp0_);
	_tmp1_ = self->priv->m_articleList;
	feed_reader_article_list_setState (_tmp1_, state);
	if (oldState == FEED_READER_ARTICLE_LIST_STATE_MARKED) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = state == FEED_READER_ARTICLE_LIST_STATE_MARKED;
	}
	if (_tmp2_) {
		FeedReaderfeedList* _tmp3_;
		_tmp3_ = self->priv->m_feedList;
		feed_reader_feed_list_refreshCounters (_tmp3_, state);
	}
}

static void
feed_reader_column_view_setSearchTerm (FeedReaderColumnView* self,
                                       const gchar* searchTerm)
{
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticleView* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (searchTerm != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_setSearchTerm (_tmp0_, searchTerm);
	_tmp1_ = self->priv->m_article_view;
	feed_reader_article_view_setSearchTerm (_tmp1_, searchTerm);
}

static void
feed_reader_column_view_clearArticleView (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderColumnViewHeader* _tmp1_;
	FeedReaderArticleView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_headerbar;
	feed_reader_column_view_header_showArticleButtons (_tmp0_, FALSE);
	_tmp1_ = self->priv->m_headerbar;
	feed_reader_column_view_header_clearTitle (_tmp1_);
	_tmp2_ = self->priv->m_article_view;
	feed_reader_article_view_clearContent (_tmp2_);
}

gchar*
feed_reader_column_view_getSelectedFeedListRow (FeedReaderColumnView* self)
{
	FeedReaderfeedList* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_feedList;
	_tmp1_ = feed_reader_feed_list_getSelectedRow (_tmp0_);
	result = _tmp1_;
	return result;
}

FeedReaderArticle*
feed_reader_column_view_getSelectedArticle (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	FeedReaderArticle* _tmp1_;
	FeedReaderArticle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_articleList;
	_tmp1_ = feed_reader_article_list_getSelectedArticle (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_column_view_markAllArticlesAsRead (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderArticleList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_headerbar;
	feed_reader_column_view_header_setRead (_tmp0_, FEED_READER_ARTICLE_STATUS_READ);
	_tmp1_ = self->priv->m_articleList;
	feed_reader_article_list_markAllAsRead (_tmp1_);
}

void
feed_reader_column_view_toggleReadSelectedArticle (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderArticleView* _tmp1_;
	FeedReaderArticleList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_headerbar;
	feed_reader_column_view_header_toggleRead (_tmp0_);
	_tmp1_ = self->priv->m_article_view;
	_tmp2_ = self->priv->m_articleList;
	feed_reader_article_view_setRead (_tmp1_, feed_reader_article_list_toggleReadSelected (_tmp2_));
}

void
feed_reader_column_view_toggleMarkedSelectedArticle (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderArticleView* _tmp1_;
	FeedReaderArticleList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_headerbar;
	feed_reader_column_view_header_toggleMarked (_tmp0_);
	_tmp1_ = self->priv->m_article_view;
	_tmp2_ = self->priv->m_articleList;
	feed_reader_article_view_setMarked (_tmp1_, feed_reader_article_list_toggleMarkedSelected (_tmp2_));
}

void
feed_reader_column_view_openSelectedArticle (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_openSelected (_tmp0_);
}

void
feed_reader_column_view_centerSelectedRow (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_centerSelectedRow (_tmp0_);
}

void
feed_reader_column_view_removeTagFromSelectedRow (FeedReaderColumnView* self,
                                                  const gchar* tagID)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_removeTagFromSelectedRow (_tmp0_, tagID);
}

void
feed_reader_column_view_syncStarted (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_syncStarted (_tmp0_);
}

void
feed_reader_column_view_syncFinished (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_syncFinished (_tmp0_);
}

void
feed_reader_column_view_getBackgroundColor (FeedReaderColumnView* self,
                                            GdkRGBA* result)
{
	FeedReaderArticleList* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_getBackgroundColor (_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

void
feed_reader_column_view_showArticleListOverlay (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_showOverlay (_tmp0_);
}

void
feed_reader_column_view_setOffline (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderfeedList* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_headerbar;
	feed_reader_column_view_header_setOffline (_tmp0_);
	_tmp1_ = self->priv->m_feedList;
	feed_reader_feed_list_setOffline (_tmp1_);
	_tmp2_ = FALSE;
	if (!feed_reader_utils_canManipulateContent (&_tmp2_)) {
		FeedReaderFeedListFooter* _tmp3_;
		FeedReaderfeedList* _tmp4_;
		FeedReaderArticleList* _tmp5_;
		_tmp3_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setAddButtonSensitive (_tmp3_, FALSE);
		_tmp4_ = self->priv->m_feedList;
		_tmp5_ = self->priv->m_articleList;
		feed_reader_feed_list_newFeedlist (_tmp4_, feed_reader_article_list_getState (_tmp5_), FALSE, FALSE);
	}
}

void
feed_reader_column_view_setOnline (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderfeedList* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_headerbar;
	feed_reader_column_view_header_setOnline (_tmp0_);
	_tmp1_ = self->priv->m_feedList;
	feed_reader_feed_list_setOnline (_tmp1_);
	_tmp2_ = TRUE;
	if (feed_reader_utils_canManipulateContent (&_tmp2_)) {
		FeedReaderFeedListFooter* _tmp3_;
		FeedReaderfeedList* _tmp4_;
		FeedReaderArticleList* _tmp5_;
		gchar* selected_row = NULL;
		FeedReaderfeedList* _tmp6_;
		gchar* _tmp7_;
		gchar** selected = NULL;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint selected_length1;
		gint _selected_size_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		_tmp3_ = self->priv->m_footer;
		feed_reader_feed_list_footer_setAddButtonSensitive (_tmp3_, TRUE);
		_tmp4_ = self->priv->m_feedList;
		_tmp5_ = self->priv->m_articleList;
		feed_reader_feed_list_newFeedlist (_tmp4_, feed_reader_article_list_getState (_tmp5_), FALSE, FALSE);
		_tmp6_ = self->priv->m_feedList;
		_tmp7_ = feed_reader_feed_list_getSelectedRow (_tmp6_);
		selected_row = _tmp7_;
		_tmp8_ = selected_row;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
		selected = _tmp10_;
		selected_length1 = _vala_array_length (_tmp9_);
		_selected_size_ = selected_length1;
		_tmp13_ = selected;
		_tmp13__length1 = selected_length1;
		_tmp14_ = _tmp13_[0];
		if (g_strcmp0 (_tmp14_, "feed") == 0) {
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = selected;
			_tmp15__length1 = selected_length1;
			_tmp16_ = _tmp15_[1];
			_tmp17_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
			_tmp18_ = _tmp17_;
			_tmp12_ = g_strcmp0 (_tmp16_, _tmp18_) == 0;
			_g_free0 (_tmp18_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp19_ = FALSE;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			_tmp20_ = selected;
			_tmp20__length1 = selected_length1;
			_tmp21_ = _tmp20_[0];
			if (g_strcmp0 (_tmp21_, "cat") == 0) {
				gboolean _tmp22_ = FALSE;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gboolean _tmp27_;
				_tmp23_ = selected;
				_tmp23__length1 = selected_length1;
				_tmp24_ = _tmp23_[1];
				_tmp25_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strcmp0 (_tmp24_, _tmp26_) == 0;
				_g_free0 (_tmp26_);
				if (_tmp27_) {
					_tmp22_ = TRUE;
				} else {
					gchar** _tmp28_;
					gint _tmp28__length1;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp28_ = selected;
					_tmp28__length1 = selected_length1;
					_tmp29_ = _tmp28_[1];
					_tmp30_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
					_tmp31_ = _tmp30_;
					_tmp22_ = g_strcmp0 (_tmp29_, _tmp31_) == 0;
					_g_free0 (_tmp31_);
				}
				_tmp19_ = _tmp22_;
			} else {
				_tmp19_ = FALSE;
			}
			_tmp11_ = _tmp19_;
		}
		if (_tmp11_) {
			FeedReaderFeedListFooter* _tmp32_;
			_tmp32_ = self->priv->m_footer;
			feed_reader_feed_list_footer_setRemoveButtonSensitive (_tmp32_, FALSE);
		}
		selected = (_vala_array_free (selected, selected_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (selected_row);
	}
}

void
feed_reader_column_view_footerSetBusy (FeedReaderColumnView* self)
{
	FeedReaderFeedListFooter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_footer;
	feed_reader_feed_list_footer_setBusy (_tmp0_);
}

void
feed_reader_column_view_footerSetReady (FeedReaderColumnView* self)
{
	FeedReaderFeedListFooter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_footer;
	feed_reader_feed_list_footer_setReady (_tmp0_);
}

void
feed_reader_column_view_footerShowError (FeedReaderColumnView* self,
                                         const gchar* errmsg)
{
	FeedReaderFeedListFooter* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errmsg != NULL);
	_tmp0_ = self->priv->m_footer;
	feed_reader_feed_list_footer_showError (_tmp0_, errmsg);
}

FeedReaderfeedList*
feed_reader_column_view_getFeedList (FeedReaderColumnView* self)
{
	FeedReaderfeedList* _tmp0_;
	FeedReaderfeedList* _tmp1_;
	FeedReaderfeedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_feedList;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_column_view_enterFullscreenArticle (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_enterFullscreenArticle (_tmp0_);
}

void
feed_reader_column_view_leaveFullscreenArticle (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_leaveFullscreenArticle (_tmp0_);
}

gboolean
feed_reader_column_view_isFullscreen (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_article_view;
	result = feed_reader_article_view_fullscreenArticle (_tmp0_);
	return result;
}

void
feed_reader_column_view_exitFullscreenVideo (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_exitFullscreenVideo (_tmp0_);
}

gboolean
feed_reader_column_view_isFullscreenVideo (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_article_view;
	result = feed_reader_article_view_fullscreenVideo (_tmp0_);
	return result;
}

gboolean
feed_reader_column_view_ArticleListSelectedIsFirst (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_articleList;
	result = feed_reader_article_list_selectedIsFirst (_tmp0_);
	return result;
}

gboolean
feed_reader_column_view_ArticleListSelectedIsLast (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_articleList;
	result = feed_reader_article_list_selectedIsLast (_tmp0_);
	return result;
}

void
feed_reader_column_view_ArticleViewAddMedia (FeedReaderColumnView* self,
                                             FeedReaderMediaPlayer* media)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_addMedia (_tmp0_, media);
}

void
feed_reader_column_view_articleViewKillMedia (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_killMedia (_tmp0_);
}

void
feed_reader_column_view_print (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_print (_tmp0_);
}

gboolean
feed_reader_column_view_playingMedia (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_article_view;
	result = feed_reader_article_view_playingMedia (_tmp0_);
	return result;
}

gchar*
feed_reader_column_view_displayedArticle (FeedReaderColumnView* self)
{
	FeedReaderArticleView* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_article_view;
	_tmp1_ = feed_reader_article_view_getCurrentArticle (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_column_view_saveState (FeedReaderColumnView* self,
                                   FeedReaderInterfaceState** state)
{
	gint offset = 0;
	gdouble scrollPos = 0.0;
	FeedReaderArticleList* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gint _tmp2_ = 0;
	FeedReaderfeedList* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderfeedList* _tmp6_;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GtkPaned* _tmp10_;
	FeedReaderfeedList* _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	FeedReaderArticleView* _tmp16_;
	FeedReaderArticle* selectedArticle = NULL;
	FeedReaderArticleList* _tmp17_;
	FeedReaderArticle* _tmp18_;
	FeedReaderArticle* _tmp19_;
	FeedReaderArticleList* _tmp23_;
	FeedReaderArticle* _tmp24_;
	FeedReaderArticle* _tmp25_;
	FeedReaderColumnViewHeader* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*state != NULL);
	offset = 0;
	scrollPos = 0.0;
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_getSavedState (_tmp0_, &_tmp1_, &_tmp2_);
	scrollPos = _tmp1_;
	offset = _tmp2_;
	feed_reader_interface_state_setArticleListScrollPos (*state, scrollPos);
	feed_reader_interface_state_setArticleListRowOffset (*state, offset);
	_tmp3_ = self->priv->m_feedList;
	_tmp4_ = feed_reader_feed_list_getSelectedRow (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_interface_state_setFeedListSelectedRow (*state, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->m_feedList;
	_tmp8_ = feed_reader_feed_list_getExpandedCategories (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	feed_reader_interface_state_setExpandedCategories (*state, _tmp9_, (gint) _tmp7_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	feed_reader_interface_state_setFeedsAndArticleWidth (*state, gtk_paned_get_position ((GtkPaned*) self));
	_tmp10_ = self->priv->m_pane;
	feed_reader_interface_state_setFeedListWidth (*state, gtk_paned_get_position (_tmp10_));
	_tmp11_ = self->priv->m_feedList;
	_tmp12_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_adjustment_get_value (_tmp13_);
	_tmp15_ = _tmp14_;
	feed_reader_interface_state_setFeedListScrollPos (*state, _tmp15_);
	_tmp16_ = self->priv->m_article_view;
	feed_reader_interface_state_setArticleViewScrollPos (*state, feed_reader_article_view_getScrollPos (_tmp16_));
	_tmp17_ = self->priv->m_articleList;
	_tmp18_ = feed_reader_article_list_getSelectedArticle (_tmp17_);
	selectedArticle = _tmp18_;
	_tmp19_ = selectedArticle;
	if (_tmp19_ != NULL) {
		FeedReaderArticle* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = selectedArticle;
		_tmp21_ = feed_reader_article_getArticleID (_tmp20_);
		_tmp22_ = _tmp21_;
		feed_reader_interface_state_setArticleListSelectedRow (*state, _tmp22_);
		_g_free0 (_tmp22_);
	}
	_tmp23_ = self->priv->m_articleList;
	_tmp24_ = feed_reader_article_list_getFirstArticle (_tmp23_);
	_tmp25_ = _tmp24_;
	feed_reader_interface_state_setArticleListTopRow (*state, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = self->priv->m_headerbar;
	feed_reader_column_view_header_saveState (_tmp26_, state);
	_g_object_unref0 (selectedArticle);
}

gboolean
feed_reader_column_view_searchFocused (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_headerbar;
	result = feed_reader_column_view_header_searchFocused (_tmp0_);
	return result;
}

FeedReaderColumnViewHeader*
feed_reader_column_view_getHeader (FeedReaderColumnView* self)
{
	FeedReaderColumnViewHeader* _tmp0_;
	FeedReaderColumnViewHeader* _tmp1_;
	FeedReaderColumnViewHeader* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_headerbar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_column_view_ArticleViewSendEvent (FeedReaderColumnView* self,
                                              GdkEventKey* event)
{
	FeedReaderArticleView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_article_view;
	feed_reader_article_view_sendEvent (_tmp0_, event);
}

void
feed_reader_column_view_clear (FeedReaderColumnView* self)
{
	FeedReaderArticleList* _tmp0_;
	FeedReaderfeedList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_articleList;
	feed_reader_article_list_clear (_tmp0_);
	feed_reader_column_view_clearArticleView (self);
	_tmp1_ = self->priv->m_feedList;
	feed_reader_feed_list_clear (_tmp1_);
}

static void
feed_reader_column_view_class_init (FeedReaderColumnViewClass * klass,
                                    gpointer klass_data)
{
	feed_reader_column_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderColumnView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_column_view_finalize;
}

static void
feed_reader_column_view_instance_init (FeedReaderColumnView * self,
                                       gpointer klass)
{
	self->priv = feed_reader_column_view_get_instance_private (self);
}

static void
feed_reader_column_view_finalize (GObject * obj)
{
	FeedReaderColumnView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_COLUMN_VIEW, FeedReaderColumnView);
	_g_object_unref0 (self->priv->m_pane);
	_g_object_unref0 (self->priv->m_article_view);
	_g_object_unref0 (self->priv->m_articleList);
	_g_object_unref0 (self->priv->m_feedList);
	_g_object_unref0 (self->priv->m_footer);
	_g_object_unref0 (self->priv->m_headerbar);
	G_OBJECT_CLASS (feed_reader_column_view_parent_class)->finalize (obj);
}

static GType
feed_reader_column_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderColumnViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_column_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderColumnView), 0, (GInstanceInitFunc) feed_reader_column_view_instance_init, NULL };
	GType feed_reader_column_view_type_id;
	feed_reader_column_view_type_id = g_type_register_static (gtk_paned_get_type (), "FeedReaderColumnView", &g_define_type_info, 0);
	FeedReaderColumnView_private_offset = g_type_add_instance_private (feed_reader_column_view_type_id, sizeof (FeedReaderColumnViewPrivate));
	return feed_reader_column_view_type_id;
}

GType
feed_reader_column_view_get_type (void)
{
	static volatile gsize feed_reader_column_view_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_column_view_type_id__once)) {
		GType feed_reader_column_view_type_id;
		feed_reader_column_view_type_id = feed_reader_column_view_get_type_once ();
		g_once_init_leave (&feed_reader_column_view_type_id__once, feed_reader_column_view_type_id);
	}
	return feed_reader_column_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

