/* ImagePopup.c generated by valac 0.56.3, the Vala compiler
 * generated from ImagePopup.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gtkimageview.h"
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <cairo-gobject.h>

enum  {
	FEED_READER_IMAGE_POPUP_0_PROPERTY,
	FEED_READER_IMAGE_POPUP_NUM_PROPERTIES
};
static GParamSpec* feed_reader_image_popup_properties[FEED_READER_IMAGE_POPUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block23Data Block23Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FeedReaderimagePopupPrivate {
	GtkScrolledWindow* m_scroll;
	gchar* m_imagePath;
	GtkImageView* m_image;
	GtkScale* m_scale;
	GtkRevealer* m_scaleRevealer;
	GtkEventBox* m_eventBox;
	GtkOverlay* m_overlay;
	GtkRevealer* m_revealer;
	GtkButton* m_saveButton;
	GtkToggleButton* m_zoomButton;
	gdouble m_dndX;
	gdouble m_dndY;
	gdouble m_adjX;
	gdouble m_adjY;
	gdouble m_dragBufferX[10];
	gdouble m_dragBufferY[10];
	gdouble m_momentumX;
	gdouble m_momentumY;
	gdouble m_posX;
	gdouble m_posY;
	gboolean m_hoverHeader;
	gboolean m_hoverImage;
	gboolean m_dragWindow;
	gboolean m_inDrag;
	guint m_OngoingScrollID;
	gdouble m_maxZoom;
	gdouble m_minZoom;
	gdouble m_initZoom;
};

struct _Block23Data {
	int _ref_count_;
	FeedReaderimagePopup* self;
	gchar* url;
};

static gint FeedReaderimagePopup_private_offset;
static gpointer feed_reader_image_popup_parent_class = NULL;

static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static gboolean __lambda333_ (FeedReaderimagePopup* self,
                       GdkEventButton* evt);
static void feed_reader_image_popup_closeWindow (FeedReaderimagePopup* self);
static gboolean ___lambda333__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static void __lambda334_ (FeedReaderimagePopup* self);
static void ___lambda334__gtk_range_value_changed (GtkRange* _sender,
                                            gpointer self);
static void __lambda335_ (FeedReaderimagePopup* self);
static void ___lambda335__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void _feed_reader_image_popup_onImageScrolled_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void __lambda336_ (FeedReaderimagePopup* self);
static gboolean ___lambda337_ (FeedReaderimagePopup* self);
static gboolean ____lambda337__gsource_func (gpointer self);
static void ___lambda336__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static gboolean feed_reader_image_popup_headerButtonPressed (FeedReaderimagePopup* self,
                                                      GdkEventButton* evt);
static gboolean _feed_reader_image_popup_headerButtonPressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                     GdkEventButton* event,
                                                                                     gpointer self);
static gboolean __lambda338_ (FeedReaderimagePopup* self);
static gboolean ___lambda338__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
static gboolean __lambda339_ (FeedReaderimagePopup* self,
                       GdkEventCrossing* event);
static gboolean ___lambda339__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
static void ___lambda340_ (Block23Data* _data23_);
static void ____lambda340__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static gboolean feed_reader_image_popup_eventButtonPressed (FeedReaderimagePopup* self,
                                                     GdkEventButton* evt);
static gboolean _feed_reader_image_popup_eventButtonPressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                    GdkEventButton* event,
                                                                                    gpointer self);
static gboolean feed_reader_image_popup_eventButtonReleased (FeedReaderimagePopup* self,
                                                      GdkEventButton* evt);
static gboolean _feed_reader_image_popup_eventButtonReleased_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                       GdkEventButton* event,
                                                                                       gpointer self);
static gboolean feed_reader_image_popup_onEnter (FeedReaderimagePopup* self,
                                          GdkEventCrossing* event);
static gboolean _feed_reader_image_popup_onEnter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                         GdkEventCrossing* event,
                                                                         gpointer self);
static gboolean feed_reader_image_popup_onLeave (FeedReaderimagePopup* self,
                                          GdkEventCrossing* event);
static gboolean _feed_reader_image_popup_onLeave_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                         GdkEventCrossing* event,
                                                                         gpointer self);
static gboolean feed_reader_image_popup_keyPressed (FeedReaderimagePopup* self,
                                             GdkEventKey* evt);
static gboolean _feed_reader_image_popup_keyPressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                         GdkEventKey* event,
                                                                         gpointer self);
static gboolean feed_reader_image_popup_motionNotify (FeedReaderimagePopup* self,
                                               GdkEventMotion* evt);
static gboolean feed_reader_image_popup_updateDragMomentum (FeedReaderimagePopup* self);
static gboolean _feed_reader_image_popup_updateDragMomentum_gsource_func (gpointer self);
static gboolean _feed_reader_image_popup_motionNotify_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                               GdkEventMotion* event,
                                                                               gpointer self);
static gboolean feed_reader_image_popup_ScrollDragRelease (FeedReaderimagePopup* self);
static gboolean _feed_reader_image_popup_ScrollDragRelease_gsource_func (gpointer self);
static void feed_reader_image_popup_finalize (GObject * obj);
static GType feed_reader_image_popup_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_image_popup_get_instance_private (FeedReaderimagePopup* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderimagePopup_private_offset);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		FeedReaderimagePopup* self;
		self = _data23_->self;
		_g_free0 (_data23_->url);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static gboolean
__lambda333_ (FeedReaderimagePopup* self,
              GdkEventButton* evt)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (evt != NULL, FALSE);
	if (!self->priv->m_hoverImage) {
		_tmp0_ = !self->priv->m_hoverHeader;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		feed_reader_image_popup_closeWindow (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda333__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda333_ ((FeedReaderimagePopup*) self, event);
	return result;
}

static void
__lambda334_ (FeedReaderimagePopup* self)
{
	GtkImageView* _tmp0_;
	GtkScale* _tmp1_;
	_tmp0_ = self->priv->m_image;
	_tmp1_ = self->priv->m_scale;
	gtk_image_view_set_scale (_tmp0_, gtk_range_get_value ((GtkRange*) _tmp1_));
}

static void
___lambda334__gtk_range_value_changed (GtkRange* _sender,
                                       gpointer self)
{
	__lambda334_ ((FeedReaderimagePopup*) self);
}

static void
__lambda335_ (FeedReaderimagePopup* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->m_imagePath;
	feed_reader_utils_saveImageDialog (_tmp0_);
}

static void
___lambda335__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda335_ ((FeedReaderimagePopup*) self);
}

static void
_feed_reader_image_popup_onImageScrolled_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	feed_reader_image_popup_onImageScrolled ((FeedReaderimagePopup*) self);
}

static gboolean
___lambda337_ (FeedReaderimagePopup* self)
{
	GtkImageView* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->m_image;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::scale", (GCallback) _feed_reader_image_popup_onImageScrolled_g_object_notify, self, 0);
	result = FALSE;
	return result;
}

static gboolean
____lambda337__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda337_ ((FeedReaderimagePopup*) self);
	return result;
}

static void
__lambda336_ (FeedReaderimagePopup* self)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp4_;
	GtkToggleButton* _tmp12_;
	_tmp0_ = self->priv->m_zoomButton;
	if (!gtk_toggle_button_get_active (_tmp0_)) {
		GtkImageView* _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		_tmp1_ = self->priv->m_image;
		g_signal_parse_name ("notify::scale", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _feed_reader_image_popup_onImageScrolled_g_object_notify, self);
	}
	_tmp4_ = self->priv->m_zoomButton;
	if (gtk_toggle_button_get_active (_tmp4_)) {
		GtkScale* _tmp5_;
		GtkImageView* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		GtkRevealer* _tmp9_;
		_tmp5_ = self->priv->m_scale;
		_tmp6_ = self->priv->m_image;
		_tmp7_ = gtk_image_view_get_scale (_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_range_set_value ((GtkRange*) _tmp5_, _tmp8_);
		_tmp9_ = self->priv->m_scaleRevealer;
		gtk_revealer_set_reveal_child (_tmp9_, TRUE);
	} else {
		GtkImageView* _tmp10_;
		GtkRevealer* _tmp11_;
		_tmp10_ = self->priv->m_image;
		gtk_image_view_set_scale (_tmp10_, self->priv->m_initZoom);
		_tmp11_ = self->priv->m_scaleRevealer;
		gtk_revealer_set_reveal_child (_tmp11_, FALSE);
	}
	_tmp12_ = self->priv->m_zoomButton;
	if (!gtk_toggle_button_get_active (_tmp12_)) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ____lambda337__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
___lambda336__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	__lambda336_ ((FeedReaderimagePopup*) self);
}

static gboolean
_feed_reader_image_popup_headerButtonPressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_headerButtonPressed ((FeedReaderimagePopup*) self, event);
	return result;
}

static gboolean
__lambda338_ (FeedReaderimagePopup* self)
{
	gboolean result;
	self->priv->m_hoverHeader = TRUE;
	self->priv->m_dragWindow = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda338__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda338_ ((FeedReaderimagePopup*) self);
	return result;
}

static gboolean
__lambda339_ (FeedReaderimagePopup* self,
              GdkEventCrossing* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail != GDK_NOTIFY_VIRTUAL) {
		_tmp0_ = event->mode != GDK_CROSSING_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->m_hoverHeader = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda339__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda339_ ((FeedReaderimagePopup*) self, event);
	return result;
}

static void
___lambda340_ (Block23Data* _data23_)
{
	FeedReaderimagePopup* self;
	GError* _inner_error0_ = NULL;
	self = _data23_->self;
	{
		FeedReaderMainWindow* _tmp0_;
		FeedReaderMainWindow* _tmp1_;
		_tmp0_ = feed_reader_main_window_get_default ();
		_tmp1_ = _tmp0_;
		gtk_show_uri_on_window ((GtkWindow*) _tmp1_, _data23_->url, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_strdup_printf ("could not open the link in an external browser: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		feed_reader_logger_debug (_tmp5_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda340__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	___lambda340_ (self);
}

static gboolean
_feed_reader_image_popup_eventButtonPressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_eventButtonPressed ((FeedReaderimagePopup*) self, event);
	return result;
}

static gboolean
_feed_reader_image_popup_eventButtonReleased_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_eventButtonReleased ((FeedReaderimagePopup*) self, event);
	return result;
}

static gboolean
_feed_reader_image_popup_onEnter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                GdkEventCrossing* event,
                                                                gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_onEnter ((FeedReaderimagePopup*) self, event);
	return result;
}

static gboolean
_feed_reader_image_popup_onLeave_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                GdkEventCrossing* event,
                                                                gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_onLeave ((FeedReaderimagePopup*) self, event);
	return result;
}

static gboolean
_feed_reader_image_popup_keyPressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                GdkEventKey* event,
                                                                gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_keyPressed ((FeedReaderimagePopup*) self, event);
	return result;
}

FeedReaderimagePopup*
feed_reader_image_popup_construct (GType object_type,
                                   const gchar* imagePath,
                                   const gchar* url,
                                   GtkWindow* parent,
                                   gdouble img_height,
                                   gdouble img_width)
{
	FeedReaderimagePopup * self = NULL;
	Block23Data* _data23_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GtkImageView* _tmp4_;
	GtkImageView* _tmp5_;
	GtkImageView* _tmp6_;
	GFile* _tmp7_;
	GtkScale* _tmp8_;
	GtkScale* _tmp9_;
	GtkScale* _tmp10_;
	GtkScale* _tmp11_;
	GtkScale* _tmp12_;
	GtkRevealer* _tmp13_;
	GtkRevealer* _tmp14_;
	GtkRevealer* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkScale* _tmp17_;
	GdkRectangle geo = {0};
	GdkDisplay* _tmp18_;
	GdkWindow* _tmp19_;
	GdkMonitor* _tmp20_;
	GdkRectangle _tmp21_ = {0};
	gdouble win_width = 0.0;
	GdkRectangle _tmp22_;
	gdouble win_height = 0.0;
	GdkRectangle _tmp23_;
	gdouble min_height = 0.0;
	gdouble min_widht = 0.0;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkImageView* _tmp26_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkImageView* _tmp30_;
	GtkToggleButton* _tmp31_;
	GtkToggleButton* _tmp32_;
	GtkImage* _tmp33_;
	GtkImage* _tmp34_;
	GtkToggleButton* _tmp35_;
	GtkHeaderBar* header = NULL;
	GtkHeaderBar* _tmp36_;
	GtkHeaderBar* _tmp37_;
	GtkHeaderBar* _tmp38_;
	GtkHeaderBar* _tmp39_;
	GtkStyleContext* _tmp40_;
	GtkHeaderBar* _tmp41_;
	GtkStyleContext* _tmp42_;
	GtkHeaderBar* _tmp43_;
	GtkButton* _tmp44_;
	GtkHeaderBar* _tmp45_;
	GtkToggleButton* _tmp46_;
	GtkHeaderBar* _tmp47_;
	GtkRevealer* _tmp48_;
	GtkEventBox* headerEvents = NULL;
	GtkEventBox* _tmp49_;
	GtkEventBox* _tmp50_;
	GtkEventBox* _tmp51_;
	GtkEventBox* _tmp52_;
	GtkEventBox* _tmp53_;
	GtkHeaderBar* _tmp54_;
	gboolean _tmp55_ = FALSE;
	GtkRevealer* _tmp63_;
	GtkRevealer* _tmp64_;
	GtkRevealer* _tmp65_;
	GtkRevealer* _tmp66_;
	GtkEventBox* _tmp67_;
	GtkOverlay* _tmp68_;
	GtkOverlay* _tmp69_;
	GtkScrolledWindow* _tmp70_;
	GtkOverlay* _tmp71_;
	GtkRevealer* _tmp72_;
	GtkEventBox* _tmp73_;
	GtkEventBox* _tmp74_;
	GtkEventBox* _tmp75_;
	GtkEventBox* _tmp76_;
	GtkEventBox* _tmp77_;
	GtkEventBox* _tmp78_;
	GtkEventBox* _tmp79_;
	GtkOverlay* _tmp80_;
	GtkEventBox* _tmp81_;
	g_return_val_if_fail (imagePath != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_tmp0_ = g_strdup (url);
	_g_free0 (_data23_->url);
	_data23_->url = _tmp0_;
	self = (FeedReaderimagePopup*) g_object_new (object_type, NULL);
	_data23_->self = g_object_ref (self);
	gtk_window_set_title ((GtkWindow*) self, "");
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DIALOG);
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER_ON_PARENT, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda333__gtk_widget_button_press_event, self, 0);
	_tmp1_ = g_strdup (imagePath);
	_g_free0 (self->priv->m_imagePath);
	self->priv->m_imagePath = _tmp1_;
	_tmp2_ = self->priv->m_imagePath;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = gtk_image_view_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_image);
	self->priv->m_image = _tmp4_;
	_tmp5_ = self->priv->m_image;
	gtk_image_view_set_zoomable (_tmp5_, TRUE);
	_tmp6_ = self->priv->m_image;
	_tmp7_ = file;
	gtk_image_view_load_from_file_async (_tmp6_, _tmp7_, 0, NULL, NULL, NULL);
	_tmp8_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, self->priv->m_minZoom, self->priv->m_maxZoom, 0.2);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->m_scale);
	self->priv->m_scale = _tmp8_;
	_tmp9_ = self->priv->m_scale;
	gtk_scale_set_draw_value (_tmp9_, FALSE);
	_tmp10_ = self->priv->m_scale;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, 200, 0);
	_tmp11_ = self->priv->m_scale;
	gtk_scale_add_mark (_tmp11_, 1.0, GTK_POS_BOTTOM, NULL);
	_tmp12_ = self->priv->m_scale;
	g_signal_connect_object ((GtkRange*) _tmp12_, "value-changed", (GCallback) ___lambda334__gtk_range_value_changed, self, 0);
	_tmp13_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->m_scaleRevealer);
	self->priv->m_scaleRevealer = _tmp13_;
	_tmp14_ = self->priv->m_scaleRevealer;
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_FILL);
	_tmp15_ = self->priv->m_scaleRevealer;
	gtk_revealer_set_transition_type (_tmp15_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp16_ = self->priv->m_scaleRevealer;
	_tmp17_ = self->priv->m_scale;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = gdk_display_get_default ();
	_tmp19_ = gtk_widget_get_root_window ((GtkWidget*) self);
	_tmp20_ = gdk_display_get_monitor_at_window (_tmp18_, _tmp19_);
	gdk_monitor_get_geometry (_tmp20_, &_tmp21_);
	geo = _tmp21_;
	_tmp22_ = geo;
	win_width = (gdouble) ((gint) (_tmp22_.width * 0.8));
	_tmp23_ = geo;
	win_height = (gdouble) ((gint) (_tmp23_.height * 0.8));
	min_height = (gdouble) 300;
	min_widht = (gdouble) 500;
	_tmp24_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->m_scroll);
	self->priv->m_scroll = _tmp24_;
	_tmp25_ = self->priv->m_scroll;
	_tmp26_ = self->priv->m_image;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	if (img_width <= win_width) {
		if (img_width < min_widht) {
			win_width = min_widht;
		} else {
			win_width = img_width;
		}
	} else {
		if (img_width > win_width) {
			GtkImageView* _tmp27_;
			self->priv->m_initZoom = win_width / img_width;
			_tmp27_ = self->priv->m_image;
			gtk_image_view_set_scale (_tmp27_, self->priv->m_initZoom);
		}
	}
	if ((img_height * self->priv->m_initZoom) <= win_height) {
		if (img_height < min_height) {
			win_height = min_height;
		} else {
			win_height = img_height * self->priv->m_initZoom;
		}
	}
	_tmp28_ = (GtkButton*) gtk_button_new_from_icon_name ("document-save-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->m_saveButton);
	self->priv->m_saveButton = _tmp28_;
	_tmp29_ = self->priv->m_saveButton;
	g_signal_connect_object (_tmp29_, "clicked", (GCallback) ___lambda335__gtk_button_clicked, self, 0);
	_tmp30_ = self->priv->m_image;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::scale", (GCallback) _feed_reader_image_popup_onImageScrolled_g_object_notify, self, 0);
	_tmp31_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->m_zoomButton);
	self->priv->m_zoomButton = _tmp31_;
	_tmp32_ = self->priv->m_zoomButton;
	_tmp33_ = (GtkImage*) gtk_image_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = self->priv->m_zoomButton;
	g_signal_connect_object (_tmp35_, "toggled", (GCallback) ___lambda336__gtk_toggle_button_toggled, self, 0);
	_tmp36_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp36_);
	header = _tmp36_;
	_tmp37_ = header;
	gtk_header_bar_set_show_close_button (_tmp37_, TRUE);
	_tmp38_ = header;
	gtk_widget_set_size_request ((GtkWidget*) _tmp38_, 0, 30);
	_tmp39_ = header;
	_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) _tmp39_);
	gtk_style_context_add_class (_tmp40_, "imageOverlay");
	_tmp41_ = header;
	_tmp42_ = gtk_widget_get_style_context ((GtkWidget*) _tmp41_);
	gtk_style_context_add_class (_tmp42_, "titlebar");
	_tmp43_ = header;
	_tmp44_ = self->priv->m_saveButton;
	gtk_header_bar_pack_start (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = header;
	_tmp46_ = self->priv->m_zoomButton;
	gtk_header_bar_pack_start (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = header;
	_tmp48_ = self->priv->m_scaleRevealer;
	gtk_header_bar_pack_start (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp49_);
	headerEvents = _tmp49_;
	_tmp50_ = headerEvents;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "button-press-event", (GCallback) _feed_reader_image_popup_headerButtonPressed_gtk_widget_button_press_event, self, 0);
	_tmp51_ = headerEvents;
	g_signal_connect_object ((GtkWidget*) _tmp51_, "enter-notify-event", (GCallback) ___lambda338__gtk_widget_enter_notify_event, self, 0);
	_tmp52_ = headerEvents;
	g_signal_connect_object ((GtkWidget*) _tmp52_, "leave-notify-event", (GCallback) ___lambda339__gtk_widget_leave_notify_event, self, 0);
	_tmp53_ = headerEvents;
	_tmp54_ = header;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	if (_data23_->url != NULL) {
		_tmp55_ = g_strcmp0 (_data23_->url, "") != 0;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		GtkButton* urlButton = NULL;
		GtkButton* _tmp56_;
		GtkButton* _tmp57_;
		GtkButton* _tmp58_;
		GtkStyleContext* _tmp59_;
		GtkButton* _tmp60_;
		GtkHeaderBar* _tmp61_;
		GtkButton* _tmp62_;
		_tmp56_ = (GtkButton*) gtk_button_new_with_label ("Open URL");
		g_object_ref_sink (_tmp56_);
		urlButton = _tmp56_;
		_tmp57_ = urlButton;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp57_, _data23_->url);
		_tmp58_ = urlButton;
		_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
		gtk_style_context_add_class (_tmp59_, "headerbutton");
		_tmp60_ = urlButton;
		g_signal_connect_data (_tmp60_, "clicked", (GCallback) ____lambda340__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_tmp61_ = header;
		_tmp62_ = urlButton;
		gtk_header_bar_pack_start (_tmp61_, (GtkWidget*) _tmp62_);
		_g_object_unref0 (urlButton);
	}
	_tmp63_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->m_revealer);
	self->priv->m_revealer = _tmp63_;
	_tmp64_ = self->priv->m_revealer;
	gtk_widget_set_valign ((GtkWidget*) _tmp64_, GTK_ALIGN_START);
	_tmp65_ = self->priv->m_revealer;
	gtk_revealer_set_transition_type (_tmp65_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp66_ = self->priv->m_revealer;
	_tmp67_ = headerEvents;
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->m_overlay);
	self->priv->m_overlay = _tmp68_;
	_tmp69_ = self->priv->m_overlay;
	_tmp70_ = self->priv->m_scroll;
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = self->priv->m_overlay;
	_tmp72_ = self->priv->m_revealer;
	gtk_overlay_add_overlay (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->m_eventBox);
	self->priv->m_eventBox = _tmp73_;
	_tmp74_ = self->priv->m_eventBox;
	g_signal_connect_object ((GtkWidget*) _tmp74_, "button-press-event", (GCallback) _feed_reader_image_popup_eventButtonPressed_gtk_widget_button_press_event, self, 0);
	_tmp75_ = self->priv->m_eventBox;
	g_signal_connect_object ((GtkWidget*) _tmp75_, "button-release-event", (GCallback) _feed_reader_image_popup_eventButtonReleased_gtk_widget_button_release_event, self, 0);
	_tmp76_ = self->priv->m_eventBox;
	g_signal_connect_object ((GtkWidget*) _tmp76_, "enter-notify-event", (GCallback) _feed_reader_image_popup_onEnter_gtk_widget_enter_notify_event, self, 0);
	_tmp77_ = self->priv->m_eventBox;
	g_signal_connect_object ((GtkWidget*) _tmp77_, "leave-notify-event", (GCallback) _feed_reader_image_popup_onLeave_gtk_widget_leave_notify_event, self, 0);
	_tmp78_ = self->priv->m_eventBox;
	g_signal_connect_object ((GtkWidget*) _tmp78_, "key-press-event", (GCallback) _feed_reader_image_popup_keyPressed_gtk_widget_key_press_event, self, 0);
	_tmp79_ = self->priv->m_eventBox;
	_tmp80_ = self->priv->m_overlay;
	gtk_container_add ((GtkContainer*) _tmp79_, (GtkWidget*) _tmp80_);
	_tmp81_ = self->priv->m_eventBox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp81_);
	gtk_widget_set_size_request ((GtkWidget*) self, (gint) win_width, (gint) win_height);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (headerEvents);
	_g_object_unref0 (header);
	_g_object_unref0 (file);
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return self;
}

FeedReaderimagePopup*
feed_reader_image_popup_new (const gchar* imagePath,
                             const gchar* url,
                             GtkWindow* parent,
                             gdouble img_height,
                             gdouble img_width)
{
	return feed_reader_image_popup_construct (FEED_READER_TYPE_IMAGE_POPUP, imagePath, url, parent, img_height, img_width);
}

void
feed_reader_image_popup_onImageScrolled (FeedReaderimagePopup* self)
{
	GtkImageView* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GtkImageView* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GtkToggleButton* _tmp8_;
	GtkRevealer* _tmp9_;
	GtkScale* _tmp10_;
	GtkImageView* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_image;
	_tmp1_ = gtk_image_view_get_scale (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > self->priv->m_maxZoom) {
		GtkImageView* _tmp3_;
		_tmp3_ = self->priv->m_image;
		gtk_image_view_set_scale (_tmp3_, self->priv->m_maxZoom);
		return;
	}
	_tmp4_ = self->priv->m_image;
	_tmp5_ = gtk_image_view_get_scale (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ < self->priv->m_minZoom) {
		GtkImageView* _tmp7_;
		_tmp7_ = self->priv->m_image;
		gtk_image_view_set_scale (_tmp7_, self->priv->m_minZoom);
		return;
	}
	_tmp8_ = self->priv->m_zoomButton;
	gtk_toggle_button_set_active (_tmp8_, TRUE);
	_tmp9_ = self->priv->m_scaleRevealer;
	gtk_revealer_set_reveal_child (_tmp9_, TRUE);
	_tmp10_ = self->priv->m_scale;
	_tmp11_ = self->priv->m_image;
	_tmp12_ = gtk_image_view_get_scale (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_range_set_value ((GtkRange*) _tmp10_, _tmp13_);
}

static gboolean
feed_reader_image_popup_headerButtonPressed (FeedReaderimagePopup* self,
                                             GdkEventButton* evt)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (evt->button == ((guint) FEED_READER_MOUSE_BUTTON_LEFT)) {
		GdkWindow* _tmp0_;
		self->priv->m_dragWindow = TRUE;
		_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_begin_move_drag (_tmp0_, (gint) FEED_READER_MOUSE_BUTTON_LEFT, (gint) evt->x_root, (gint) evt->y_root, (guint32) GDK_CURRENT_TIME);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
feed_reader_image_popup_motionNotify (FeedReaderimagePopup* self,
                                      GdkEventMotion* evt)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if ((evt->state & GDK_MODIFIER_MASK) >= GDK_BUTTON2_MASK) {
		gdouble diff_x = 0.0;
		gdouble diff_y = 0.0;
		GtkScrolledWindow* _tmp0_;
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkScrolledWindow* _tmp3_;
		GtkAdjustment* _tmp4_;
		GtkAdjustment* _tmp5_;
		self->priv->m_posX = evt->x;
		self->priv->m_posY = evt->y;
		diff_x = self->priv->m_dndX - evt->x;
		diff_y = self->priv->m_dndY - evt->y;
		_tmp0_ = self->priv->m_scroll;
		_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
		_tmp2_ = _tmp1_;
		gtk_adjustment_set_value (_tmp2_, self->priv->m_adjY + diff_y);
		_tmp3_ = self->priv->m_scroll;
		_tmp4_ = gtk_scrolled_window_get_hadjustment (_tmp3_);
		_tmp5_ = _tmp4_;
		gtk_adjustment_set_value (_tmp5_, self->priv->m_adjX + diff_x);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_feed_reader_image_popup_updateDragMomentum_gsource_func (gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_updateDragMomentum ((FeedReaderimagePopup*) self);
	return result;
}

static gboolean
_feed_reader_image_popup_motionNotify_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                      GdkEventMotion* event,
                                                                      gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_motionNotify ((FeedReaderimagePopup*) self, event);
	return result;
}

static gboolean
feed_reader_image_popup_eventButtonPressed (FeedReaderimagePopup* self,
                                            GdkEventButton* evt)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (!self->priv->m_hoverHeader) {
		if (evt->button == ((guint) FEED_READER_MOUSE_BUTTON_MIDDLE)) {
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp2_;
			GdkDisplay* _tmp3_;
			GdkSeat* seat = NULL;
			GdkDisplay* _tmp4_;
			GdkSeat* _tmp5_;
			GdkSeat* _tmp6_;
			GdkDevice* pointer = NULL;
			GdkSeat* _tmp7_;
			GdkDevice* _tmp8_;
			GdkDevice* _tmp9_;
			GdkCursor* cursor = NULL;
			GdkDisplay* _tmp10_;
			GdkCursor* _tmp11_;
			GdkSeat* _tmp12_;
			GdkWindow* _tmp13_;
			GdkCursor* _tmp14_;
			GtkEventBox* _tmp15_;
			GdkDevice* _tmp16_;
			GtkScrolledWindow* _tmp17_;
			GtkAdjustment* _tmp18_;
			GtkAdjustment* _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp21_;
			GtkScrolledWindow* _tmp22_;
			GtkAdjustment* _tmp23_;
			GtkAdjustment* _tmp24_;
			gdouble _tmp25_;
			gdouble _tmp26_;
			GtkEventBox* _tmp27_;
			if (self->priv->m_OngoingScrollID > ((guint) 0)) {
				g_source_remove (self->priv->m_OngoingScrollID);
				self->priv->m_OngoingScrollID = (guint) 0;
			}
			self->priv->m_posX = evt->x;
			self->priv->m_posY = evt->y;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp0_ = FALSE;
					_tmp0_ = TRUE;
					while (TRUE) {
						if (!_tmp0_) {
							gint _tmp1_;
							i = i + 1;
							_tmp1_ = i;
						}
						_tmp0_ = FALSE;
						if (!(i < 10)) {
							break;
						}
						self->priv->m_dragBufferX[i] = self->priv->m_posX;
						self->priv->m_dragBufferY[i] = self->priv->m_posY;
					}
				}
			}
			self->priv->m_inDrag = TRUE;
			_tmp2_ = gdk_display_get_default ();
			_tmp3_ = _g_object_ref0 (_tmp2_);
			display = _tmp3_;
			_tmp4_ = display;
			_tmp5_ = gdk_display_get_default_seat (_tmp4_);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			seat = _tmp6_;
			_tmp7_ = seat;
			_tmp8_ = gdk_seat_get_pointer (_tmp7_);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			pointer = _tmp9_;
			_tmp10_ = display;
			_tmp11_ = gdk_cursor_new_for_display (_tmp10_, GDK_FLEUR);
			cursor = _tmp11_;
			_tmp12_ = seat;
			_tmp13_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp14_ = cursor;
			gdk_seat_grab (_tmp12_, _tmp13_, GDK_SEAT_CAPABILITY_POINTER, FALSE, _tmp14_, NULL, NULL, NULL);
			_tmp15_ = self->priv->m_eventBox;
			_tmp16_ = pointer;
			gtk_device_grab_add ((GtkWidget*) _tmp15_, _tmp16_, FALSE);
			self->priv->m_dndX = evt->x;
			self->priv->m_dndY = evt->y;
			_tmp17_ = self->priv->m_scroll;
			_tmp18_ = gtk_scrolled_window_get_hadjustment (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = gtk_adjustment_get_value (_tmp19_);
			_tmp21_ = _tmp20_;
			self->priv->m_adjX = _tmp21_;
			_tmp22_ = self->priv->m_scroll;
			_tmp23_ = gtk_scrolled_window_get_vadjustment (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = gtk_adjustment_get_value (_tmp24_);
			_tmp26_ = _tmp25_;
			self->priv->m_adjY = _tmp26_;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _feed_reader_image_popup_updateDragMomentum_gsource_func, g_object_ref (self), g_object_unref);
			_tmp27_ = self->priv->m_eventBox;
			g_signal_connect_object ((GtkWidget*) _tmp27_, "motion-notify-event", (GCallback) _feed_reader_image_popup_motionNotify_gtk_widget_motion_notify_event, self, 0);
			result = TRUE;
			_g_object_unref0 (cursor);
			_g_object_unref0 (pointer);
			_g_object_unref0 (seat);
			_g_object_unref0 (display);
			return result;
		} else {
			if (evt->button == ((guint) FEED_READER_MOUSE_BUTTON_LEFT)) {
				feed_reader_image_popup_closeWindow (self);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
_feed_reader_image_popup_ScrollDragRelease_gsource_func (gpointer self)
{
	gboolean result;
	result = feed_reader_image_popup_ScrollDragRelease ((FeedReaderimagePopup*) self);
	return result;
}

static gboolean
feed_reader_image_popup_eventButtonReleased (FeedReaderimagePopup* self,
                                             GdkEventButton* evt)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (evt->button == ((guint) FEED_READER_MOUSE_BUTTON_MIDDLE)) {
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp0_;
		GdkDisplay* _tmp1_;
		GdkSeat* seat = NULL;
		GdkDisplay* _tmp2_;
		GdkSeat* _tmp3_;
		GdkSeat* _tmp4_;
		GdkDevice* pointer = NULL;
		GdkSeat* _tmp5_;
		GdkDevice* _tmp6_;
		GdkDevice* _tmp7_;
		GtkEventBox* _tmp8_;
		GdkDevice* _tmp9_;
		GdkSeat* _tmp10_;
		GtkEventBox* _tmp11_;
		guint _tmp12_;
		self->priv->m_posX = (gdouble) 0;
		self->priv->m_posY = (gdouble) 0;
		self->priv->m_inDrag = FALSE;
		_tmp0_ = gdk_display_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		display = _tmp1_;
		_tmp2_ = display;
		_tmp3_ = gdk_display_get_default_seat (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		seat = _tmp4_;
		_tmp5_ = seat;
		_tmp6_ = gdk_seat_get_pointer (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		pointer = _tmp7_;
		_tmp8_ = self->priv->m_eventBox;
		_tmp9_ = pointer;
		gtk_device_grab_remove ((GtkWidget*) _tmp8_, _tmp9_);
		_tmp10_ = seat;
		gdk_seat_ungrab (_tmp10_);
		_tmp11_ = self->priv->m_eventBox;
		g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _feed_reader_image_popup_motionNotify_gtk_widget_motion_notify_event, self);
		self->priv->m_OngoingScrollID = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 20, _feed_reader_image_popup_ScrollDragRelease_gsource_func, g_object_ref (self), g_object_unref);
		result = TRUE;
		_g_object_unref0 (pointer);
		_g_object_unref0 (seat);
		_g_object_unref0 (display);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
feed_reader_image_popup_keyPressed (FeedReaderimagePopup* self,
                                    GdkEventKey* evt)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (evt->keyval == GDK_KEY_Escape) {
		feed_reader_image_popup_closeWindow (self);
	}
	result = FALSE;
	return result;
}

static gboolean
feed_reader_image_popup_onEnter (FeedReaderimagePopup* self,
                                 GdkEventCrossing* event)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->m_hoverImage = TRUE;
	_tmp0_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	_tmp1_ = self->priv->m_revealer;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	result = TRUE;
	return result;
}

static gboolean
feed_reader_image_popup_onLeave (FeedReaderimagePopup* self,
                                 GdkEventCrossing* event)
{
	gboolean _tmp0_ = FALSE;
	GtkRevealer* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail != GDK_NOTIFY_VIRTUAL) {
		_tmp0_ = event->mode != GDK_CROSSING_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->m_dragWindow) {
		result = FALSE;
		return result;
	}
	self->priv->m_hoverImage = FALSE;
	_tmp1_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
	result = TRUE;
	return result;
}

static gboolean
feed_reader_image_popup_updateDragMomentum (FeedReaderimagePopup* self)
{
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->m_inDrag) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 9;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_;
				gdouble _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i - 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				if (!(i > 0)) {
					break;
				}
				_tmp2_ = self->priv->m_dragBufferX[i - 1];
				self->priv->m_dragBufferX[i] = _tmp2_;
				_tmp3_ = self->priv->m_dragBufferY[i - 1];
				self->priv->m_dragBufferY[i] = _tmp3_;
			}
		}
	}
	self->priv->m_dragBufferX[0] = self->priv->m_posX;
	self->priv->m_dragBufferY[0] = self->priv->m_posY;
	_tmp4_ = self->priv->m_dragBufferX[9];
	_tmp5_ = self->priv->m_dragBufferX[0];
	self->priv->m_momentumX = (_tmp4_ - _tmp5_) / 2;
	_tmp6_ = self->priv->m_dragBufferY[9];
	_tmp7_ = self->priv->m_dragBufferY[0];
	self->priv->m_momentumY = (_tmp6_ - _tmp7_) / 2;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_image_popup_ScrollDragRelease (FeedReaderimagePopup* self)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->m_inDrag) {
		result = TRUE;
		return result;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	if (self->priv->m_momentumX != ((gdouble) 0)) {
		gdouble pageWidth = 0.0;
		gdouble adjhValue = 0.0;
		GtkAllocation _tmp1_;
		gdouble oldhAdj = 0.0;
		GtkScrolledWindow* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		gdouble upperH = 0.0;
		GtkScrolledWindow* _tmp7_;
		GtkAdjustment* _tmp8_;
		GtkAdjustment* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		gboolean _tmp12_ = FALSE;
		gdouble newXScrollPos = 0.0;
		GtkScrolledWindow* _tmp13_;
		GtkAdjustment* _tmp14_;
		GtkAdjustment* _tmp15_;
		self->priv->m_momentumX = self->priv->m_momentumX / 1.2;
		pageWidth = (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp1_ = allocation;
		adjhValue = (pageWidth * self->priv->m_momentumX) / _tmp1_.width;
		_tmp2_ = self->priv->m_scroll;
		_tmp3_ = gtk_scrolled_window_get_hadjustment (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		oldhAdj = _tmp6_;
		_tmp7_ = self->priv->m_scroll;
		_tmp8_ = gtk_scrolled_window_get_hadjustment (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_adjustment_get_upper (_tmp9_);
		_tmp11_ = _tmp10_;
		upperH = _tmp11_;
		if ((oldhAdj + adjhValue) > (upperH - pageWidth)) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = (oldhAdj + adjhValue) < ((gdouble) 0);
		}
		if (_tmp12_) {
			self->priv->m_momentumX = (gdouble) 0;
		}
		newXScrollPos = MIN (oldhAdj + adjhValue, upperH - pageWidth);
		_tmp13_ = self->priv->m_scroll;
		_tmp14_ = gtk_scrolled_window_get_hadjustment (_tmp13_);
		_tmp15_ = _tmp14_;
		gtk_adjustment_set_value (_tmp15_, (gdouble) ((gint) newXScrollPos));
	}
	if (self->priv->m_momentumY != ((gdouble) 0)) {
		gdouble pageHeight = 0.0;
		gdouble adjvValue = 0.0;
		GtkAllocation _tmp16_;
		gdouble oldvAdj = 0.0;
		GtkScrolledWindow* _tmp17_;
		GtkAdjustment* _tmp18_;
		GtkAdjustment* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		gdouble upperV = 0.0;
		GtkScrolledWindow* _tmp22_;
		GtkAdjustment* _tmp23_;
		GtkAdjustment* _tmp24_;
		gdouble _tmp25_;
		gdouble _tmp26_;
		gboolean _tmp27_ = FALSE;
		gdouble newYScrollPos = 0.0;
		GtkScrolledWindow* _tmp28_;
		GtkAdjustment* _tmp29_;
		GtkAdjustment* _tmp30_;
		self->priv->m_momentumY = self->priv->m_momentumY / 1.2;
		pageHeight = (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp16_ = allocation;
		adjvValue = (pageHeight * self->priv->m_momentumY) / _tmp16_.height;
		_tmp17_ = self->priv->m_scroll;
		_tmp18_ = gtk_scrolled_window_get_vadjustment (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gtk_adjustment_get_value (_tmp19_);
		_tmp21_ = _tmp20_;
		oldvAdj = _tmp21_;
		_tmp22_ = self->priv->m_scroll;
		_tmp23_ = gtk_scrolled_window_get_vadjustment (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gtk_adjustment_get_upper (_tmp24_);
		_tmp26_ = _tmp25_;
		upperV = _tmp26_;
		if ((oldvAdj + adjvValue) > (upperV - pageHeight)) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = (oldvAdj + adjvValue) < ((gdouble) 0);
		}
		if (_tmp27_) {
			self->priv->m_momentumY = (gdouble) 0;
		}
		newYScrollPos = MIN (oldvAdj + adjvValue, upperV - pageHeight);
		_tmp28_ = self->priv->m_scroll;
		_tmp29_ = gtk_scrolled_window_get_vadjustment (_tmp28_);
		_tmp30_ = _tmp29_;
		gtk_adjustment_set_value (_tmp30_, (gdouble) ((gint) newYScrollPos));
	}
	if (self->priv->m_momentumX < ((gdouble) 1)) {
		_tmp32_ = self->priv->m_momentumX > ((gdouble) -1);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gboolean _tmp33_ = FALSE;
		if (self->priv->m_momentumY < ((gdouble) 1)) {
			_tmp33_ = self->priv->m_momentumY > ((gdouble) -1);
		} else {
			_tmp33_ = FALSE;
		}
		_tmp31_ = _tmp33_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		self->priv->m_OngoingScrollID = (guint) 0;
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

static void
feed_reader_image_popup_closeWindow (FeedReaderimagePopup* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->m_OngoingScrollID != ((guint) 0)) {
		g_source_remove (self->priv->m_OngoingScrollID);
		self->priv->m_OngoingScrollID = (guint) 0;
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
feed_reader_image_popup_class_init (FeedReaderimagePopupClass * klass,
                                    gpointer klass_data)
{
	feed_reader_image_popup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderimagePopup_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_image_popup_finalize;
}

static void
feed_reader_image_popup_instance_init (FeedReaderimagePopup * self,
                                       gpointer klass)
{
	self->priv = feed_reader_image_popup_get_instance_private (self);
	self->priv->m_momentumX = (gdouble) 0;
	self->priv->m_momentumY = (gdouble) 0;
	self->priv->m_posX = (gdouble) 0;
	self->priv->m_posY = (gdouble) 0;
	self->priv->m_hoverHeader = FALSE;
	self->priv->m_hoverImage = FALSE;
	self->priv->m_dragWindow = FALSE;
	self->priv->m_inDrag = FALSE;
	self->priv->m_OngoingScrollID = (guint) 0;
	self->priv->m_maxZoom = 5.0;
	self->priv->m_minZoom = 0.2;
	self->priv->m_initZoom = 1.0;
}

static void
feed_reader_image_popup_finalize (GObject * obj)
{
	FeedReaderimagePopup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_IMAGE_POPUP, FeedReaderimagePopup);
	_g_object_unref0 (self->priv->m_scroll);
	_g_free0 (self->priv->m_imagePath);
	_g_object_unref0 (self->priv->m_image);
	_g_object_unref0 (self->priv->m_scale);
	_g_object_unref0 (self->priv->m_scaleRevealer);
	_g_object_unref0 (self->priv->m_eventBox);
	_g_object_unref0 (self->priv->m_overlay);
	_g_object_unref0 (self->priv->m_revealer);
	_g_object_unref0 (self->priv->m_saveButton);
	_g_object_unref0 (self->priv->m_zoomButton);
	G_OBJECT_CLASS (feed_reader_image_popup_parent_class)->finalize (obj);
}

static GType
feed_reader_image_popup_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderimagePopupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_image_popup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderimagePopup), 0, (GInstanceInitFunc) feed_reader_image_popup_instance_init, NULL };
	GType feed_reader_image_popup_type_id;
	feed_reader_image_popup_type_id = g_type_register_static (gtk_window_get_type (), "FeedReaderimagePopup", &g_define_type_info, 0);
	FeedReaderimagePopup_private_offset = g_type_add_instance_private (feed_reader_image_popup_type_id, sizeof (FeedReaderimagePopupPrivate));
	return feed_reader_image_popup_type_id;
}

GType
feed_reader_image_popup_get_type (void)
{
	static volatile gsize feed_reader_image_popup_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_image_popup_type_id__once)) {
		GType feed_reader_image_popup_type_id;
		feed_reader_image_popup_type_id = feed_reader_image_popup_get_type_once ();
		g_once_init_leave (&feed_reader_image_popup_type_id__once, feed_reader_image_popup_type_id);
	}
	return feed_reader_image_popup_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

