/* MediaPlayer.c generated by valac 0.56.3, the Vala compiler
 * generated from MediaPlayer.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gst/gst.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gst/pbutils/pbutils.h>
#include <cairo-gobject.h>

enum  {
	FEED_READER_MEDIA_PLAYER_0_PROPERTY,
	FEED_READER_MEDIA_PLAYER_NUM_PROPERTIES
};
static GParamSpec* feed_reader_media_player_properties[FEED_READER_MEDIA_PLAYER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block27Data Block27Data;
enum  {
	FEED_READER_MEDIA_PLAYER_LOADED_SIGNAL,
	FEED_READER_MEDIA_PLAYER_NUM_SIGNALS
};
static guint feed_reader_media_player_signals[FEED_READER_MEDIA_PLAYER_NUM_SIGNALS] = {0};

struct _FeedReaderMediaPlayerPrivate {
	GstElement* m_player;
	GtkWidget* m_videoWidget;
	GtkStack* m_playStack;
	GtkButton* m_playButton;
	GtkSpinner* m_playSpinner;
	GtkButton* m_muteButton;
	GtkButton* m_closeButton;
	GtkScale* m_scale;
	GtkButton* m_labelButton;
	GtkLabel* m_bufferLabel;
	gint m_margin;
	GtkImage* m_playIcon;
	GtkImage* m_pauseIcon;
	GtkImage* m_muteIcon;
	GtkImage* m_noiseIcon;
	GtkImage* m_closeIcon;
	gboolean m_muted;
	gdouble m_aspectRatio;
	guint m_seek_source_id;
	FeedReaderMediaType m_type;
	gchar* m_URL;
	FeedReaderDisplayPosition m_display;
};

struct _Block27Data {
	int _ref_count_;
	FeedReaderMediaPlayer* self;
	gdouble startValue;
};

static gint FeedReaderMediaPlayer_private_offset;
static gpointer feed_reader_media_player_parent_class = NULL;

static void feed_reader_media_player_inspectMedia (FeedReaderMediaPlayer* self);
static void feed_reader_media_player_buildUI (FeedReaderMediaPlayer* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void feed_reader_media_player_onAllocation (FeedReaderMediaPlayer* self,
                                            GtkAllocation* allocation);
static void _feed_reader_media_player_onAllocation_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                      GtkAllocation* allocation,
                                                                      gpointer self);
static gboolean feed_reader_media_player_busCallback (FeedReaderMediaPlayer* self,
                                               GstBus* bus,
                                               GstMessage* message);
static gboolean _feed_reader_media_player_busCallback_gst_bus_func (GstBus* bus,
                                                             GstMessage* message,
                                                             gpointer self);
static gboolean __lambda97_ (FeedReaderMediaPlayer* self);
static void feed_reader_media_player_calcTime (FeedReaderMediaPlayer* self);
static gboolean ___lambda97__gsource_func (gpointer self);
static void feed_reader_media_player_togglePause (FeedReaderMediaPlayer* self);
static void _feed_reader_media_player_togglePause_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void feed_reader_media_player_toggleMute (FeedReaderMediaPlayer* self);
static void _feed_reader_media_player_toggleMute_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void __lambda98_ (FeedReaderMediaPlayer* self);
static void ___lambda98__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean feed_reader_media_player_valueChanged (FeedReaderMediaPlayer* self,
                                                GtkScrollType scroll,
                                                gdouble new_value);
static gboolean _feed_reader_media_player_valueChanged_gtk_range_change_value (GtkRange* _sender,
                                                                        GtkScrollType scroll,
                                                                        gdouble new_value,
                                                                        gpointer self);
static void feed_reader_media_player_switchDisplay (FeedReaderMediaPlayer* self);
static void _feed_reader_media_player_switchDisplay_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static gdouble* _double_dup (gdouble* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static gboolean ___lambda99_ (Block27Data* _data27_);
static void feed_reader_media_player_seek (FeedReaderMediaPlayer* self,
                                    gdouble new_value);
static gboolean ____lambda99__gsource_func (gpointer self);
static void feed_reader_media_player_finalize (GObject * obj);
static GType feed_reader_media_player_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_media_player_get_instance_private (FeedReaderMediaPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderMediaPlayer_private_offset);
}

FeedReaderMediaPlayer*
feed_reader_media_player_construct (GType object_type,
                                    const gchar* url)
{
	FeedReaderMediaPlayer * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (FeedReaderMediaPlayer*) g_object_new (object_type, NULL);
	self->priv->m_type = FEED_READER_MEDIA_TYPE_AUDIO;
	_tmp0_ = g_strdup (url);
	_g_free0 (self->priv->m_URL);
	self->priv->m_URL = _tmp0_;
	feed_reader_media_player_inspectMedia (self);
	feed_reader_media_player_buildUI (self);
	g_signal_emit (self, feed_reader_media_player_signals[FEED_READER_MEDIA_PLAYER_LOADED_SIGNAL], 0);
	return self;
}

FeedReaderMediaPlayer*
feed_reader_media_player_new (const gchar* url)
{
	return feed_reader_media_player_construct (FEED_READER_TYPE_MEDIA_PLAYER, url);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
feed_reader_media_player_inspectMedia (FeedReaderMediaPlayer* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GstDiscoverer* discoverer = NULL;
		GstDiscoverer* _tmp0_;
		GstDiscovererInfo* info = NULL;
		GstDiscoverer* _tmp1_;
		const gchar* _tmp2_;
		GstDiscovererInfo* _tmp3_;
		GstDiscovererInfo* _tmp4_;
		GList* _tmp5_;
		_tmp0_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_inner_error0_);
		discoverer = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = discoverer;
		_tmp2_ = self->priv->m_URL;
		_tmp3_ = gst_discoverer_discover_uri (_tmp1_, _tmp2_, &_inner_error0_);
		info = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (discoverer);
			goto __catch0_g_error;
		}
		_tmp4_ = info;
		_tmp5_ = gst_discoverer_info_get_stream_list (_tmp4_);
		{
			GList* i_collection = NULL;
			GList* i_it = NULL;
			i_collection = _tmp5_;
			for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
				GstDiscovererStreamInfo* _tmp6_;
				GstDiscovererStreamInfo* i = NULL;
				_tmp6_ = _g_object_ref0 ((GstDiscovererStreamInfo*) i_it->data);
				i = _tmp6_;
				{
					GstDiscovererStreamInfo* _tmp7_;
					_tmp7_ = i;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gst_discoverer_video_info_get_type ())) {
						GstDiscovererVideoInfo* v = NULL;
						GstDiscovererStreamInfo* _tmp8_;
						GstDiscovererVideoInfo* _tmp9_;
						GstDiscovererVideoInfo* _tmp10_;
						GstDiscovererVideoInfo* _tmp11_;
						_tmp8_ = i;
						_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gst_discoverer_video_info_get_type (), GstDiscovererVideoInfo));
						v = _tmp9_;
						_tmp10_ = v;
						_tmp11_ = v;
						self->priv->m_aspectRatio = ((gdouble) gst_discoverer_video_info_get_width (_tmp10_)) / ((gdouble) gst_discoverer_video_info_get_height (_tmp11_));
						self->priv->m_type = FEED_READER_MEDIA_TYPE_VIDEO;
						_g_object_unref0 (v);
					}
					_g_object_unref0 (i);
				}
			}
			(i_collection == NULL) ? NULL : (i_collection = (_g_list_free__g_object_unref0_ (i_collection), NULL));
		}
		_g_object_unref0 (info);
		_g_object_unref0 (discoverer);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strconcat ("Unable discover_uri: ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		feed_reader_logger_error (_tmp15_);
		_g_free0 (_tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_feed_reader_media_player_onAllocation_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                 GtkAllocation* allocation,
                                                                 gpointer self)
{
	feed_reader_media_player_onAllocation ((FeedReaderMediaPlayer*) self, allocation);
}

static gboolean
_feed_reader_media_player_busCallback_gst_bus_func (GstBus* bus,
                                                    GstMessage* message,
                                                    gpointer self)
{
	gboolean result;
	result = feed_reader_media_player_busCallback ((FeedReaderMediaPlayer*) self, bus, message);
	return result;
}

static gboolean
__lambda97_ (FeedReaderMediaPlayer* self)
{
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	gboolean result;
	_tmp0_ = self->priv->m_player;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) 1000);
	state = _tmp1_;
	pending = _tmp2_;
	if (state == GST_STATE_PLAYING) {
		gint64 pos = 0LL;
		gint64 dur = 0LL;
		GstElement* _tmp3_;
		gint64 _tmp4_ = 0LL;
		GstElement* _tmp5_;
		gint64 _tmp6_ = 0LL;
		gdouble position = 0.0;
		gdouble duration = 0.0;
		gdouble percent = 0.0;
		_tmp3_ = self->priv->m_player;
		gst_element_query_position (_tmp3_, GST_FORMAT_TIME, &_tmp4_);
		pos = _tmp4_;
		_tmp5_ = self->priv->m_player;
		gst_element_query_duration (_tmp5_, GST_FORMAT_TIME, &_tmp6_);
		dur = _tmp6_;
		position = ((gdouble) pos) / 1000000000;
		duration = ((gdouble) dur) / 1000000000;
		percent = (position * 100.0) / duration;
		if (self->priv->m_seek_source_id == ((guint) 0)) {
			GtkScale* _tmp7_;
			_tmp7_ = self->priv->m_scale;
			gtk_range_set_value ((GtkRange*) _tmp7_, percent);
		}
		feed_reader_media_player_calcTime (self);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda97__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda97_ ((FeedReaderMediaPlayer*) self);
	return result;
}

static void
_feed_reader_media_player_togglePause_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	feed_reader_media_player_togglePause ((FeedReaderMediaPlayer*) self);
}

static void
_feed_reader_media_player_toggleMute_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	feed_reader_media_player_toggleMute ((FeedReaderMediaPlayer*) self);
}

static void
__lambda98_ (FeedReaderMediaPlayer* self)
{
	feed_reader_media_player_kill (self);
}

static void
___lambda98__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda98_ ((FeedReaderMediaPlayer*) self);
}

static gboolean
_feed_reader_media_player_valueChanged_gtk_range_change_value (GtkRange* _sender,
                                                               GtkScrollType scroll,
                                                               gdouble new_value,
                                                               gpointer self)
{
	gboolean result;
	result = feed_reader_media_player_valueChanged ((FeedReaderMediaPlayer*) self, scroll, new_value);
	return result;
}

static void
_feed_reader_media_player_switchDisplay_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	feed_reader_media_player_switchDisplay ((FeedReaderMediaPlayer*) self);
}

static void
feed_reader_media_player_buildUI (FeedReaderMediaPlayer* self)
{
	GstElement* gtksink = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	const gchar* _tmp12_;
	GstBus* bus = NULL;
	GstElement* _tmp13_;
	GstBus* _tmp14_;
	GstBus* _tmp15_;
	GtkImage* _tmp16_;
	GtkImage* _tmp17_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkImage* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkSpinner* _tmp29_;
	GtkStack* _tmp30_;
	GtkStack* _tmp31_;
	GtkButton* _tmp32_;
	GtkStack* _tmp33_;
	GtkSpinner* _tmp34_;
	GtkStack* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkImage* _tmp38_;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkImage* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* _tmp50_;
	GtkButton* _tmp51_;
	GtkScale* _tmp52_;
	GtkScale* _tmp53_;
	GtkScale* _tmp54_;
	GtkScale* _tmp55_;
	GtkButton* _tmp56_;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkStyleContext* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkBox* hBox = NULL;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkStack* _tmp67_;
	GtkBox* _tmp68_;
	GtkButton* _tmp69_;
	GtkBox* _tmp70_;
	GtkScale* _tmp71_;
	GtkBox* _tmp72_;
	GtkButton* _tmp73_;
	GtkBox* _tmp74_;
	GtkButton* _tmp75_;
	GtkLabel* _tmp76_;
	GtkLabel* _tmp77_;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	GtkLabel* _tmp80_;
	GtkOverlay* bufferOverlay = NULL;
	GtkOverlay* _tmp81_;
	GtkOverlay* _tmp82_;
	GtkWidget* _tmp83_;
	GtkOverlay* _tmp84_;
	GtkLabel* _tmp85_;
	GtkStyleContext* _tmp86_;
	GtkBox* _tmp88_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gst_element_factory_make ("gtksink", "sink");
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	gtksink = _tmp0_;
	_tmp1_ = gtksink;
	g_object_get ((GObject*) _tmp1_, "widget", &_tmp2_, NULL);
	_g_object_unref0 (self->priv->m_videoWidget);
	self->priv->m_videoWidget = _tmp2_;
	_tmp3_ = self->priv->m_videoWidget;
	gtk_widget_set_margin_start (_tmp3_, self->priv->m_margin);
	_tmp4_ = self->priv->m_videoWidget;
	gtk_widget_set_margin_end (_tmp4_, self->priv->m_margin);
	_tmp5_ = self->priv->m_videoWidget;
	gtk_widget_set_margin_top (_tmp5_, self->priv->m_margin);
	_tmp6_ = self->priv->m_videoWidget;
	g_signal_connect_object (_tmp6_, "size-allocate", (GCallback) _feed_reader_media_player_onAllocation_gtk_widget_size_allocate, self, 0);
	_tmp7_ = gst_element_factory_make ("playbin", "player");
	if (_tmp7_ != NULL) {
		g_object_ref_sink (_tmp7_);
	}
	_g_object_unref0 (self->priv->m_player);
	self->priv->m_player = _tmp7_;
	_tmp8_ = self->priv->m_player;
	_tmp9_ = gtksink;
	g_object_set ((GObject*) _tmp8_, "video_sink", _tmp9_, NULL);
	_tmp10_ = self->priv->m_player;
	g_object_set ((GObject*) _tmp10_, "volume", 1.0, NULL);
	_tmp11_ = self->priv->m_player;
	_tmp12_ = self->priv->m_URL;
	g_object_set ((GObject*) _tmp11_, "uri", _tmp12_, NULL);
	_tmp13_ = self->priv->m_player;
	_tmp14_ = gst_element_get_bus (_tmp13_);
	bus = _tmp14_;
	_tmp15_ = bus;
	gst_bus_add_watch_full (_tmp15_, G_PRIORITY_LOW, _feed_reader_media_player_busCallback_gst_bus_func, g_object_ref (self), g_object_unref);
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 500, ___lambda97__gsource_func, g_object_ref (self), g_object_unref);
	_tmp16_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->m_playIcon);
	self->priv->m_playIcon = _tmp16_;
	_tmp17_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->m_pauseIcon);
	self->priv->m_pauseIcon = _tmp17_;
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("audio-volume-muted-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->m_muteIcon);
	self->priv->m_muteIcon = _tmp18_;
	_tmp19_ = (GtkImage*) gtk_image_new_from_icon_name ("audio-volume-high-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->m_noiseIcon);
	self->priv->m_noiseIcon = _tmp19_;
	_tmp20_ = (GtkImage*) gtk_image_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->m_closeIcon);
	self->priv->m_closeIcon = _tmp20_;
	_tmp21_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->m_playButton);
	self->priv->m_playButton = _tmp21_;
	_tmp22_ = self->priv->m_playButton;
	_tmp23_ = self->priv->m_playIcon;
	gtk_button_set_image (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->m_playButton;
	g_signal_connect_object (_tmp24_, "clicked", (GCallback) _feed_reader_media_player_togglePause_gtk_button_clicked, self, 0);
	_tmp25_ = self->priv->m_playButton;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, FEED_READER_MEDIA_BUTTON_PLAY);
	_tmp26_ = self->priv->m_playButton;
	gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	_tmp27_ = self->priv->m_playButton;
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
	_tmp28_ = self->priv->m_playButton;
	gtk_widget_set_size_request ((GtkWidget*) _tmp28_, 48, 48);
	_tmp29_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->m_playSpinner);
	self->priv->m_playSpinner = _tmp29_;
	_tmp30_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->m_playStack);
	self->priv->m_playStack = _tmp30_;
	_tmp31_ = self->priv->m_playStack;
	_tmp32_ = self->priv->m_playButton;
	gtk_stack_add_named (_tmp31_, (GtkWidget*) _tmp32_, "button");
	_tmp33_ = self->priv->m_playStack;
	_tmp34_ = self->priv->m_playSpinner;
	gtk_stack_add_named (_tmp33_, (GtkWidget*) _tmp34_, "spinner");
	_tmp35_ = self->priv->m_playStack;
	gtk_stack_set_visible_child_name (_tmp35_, "button");
	_tmp36_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->m_muteButton);
	self->priv->m_muteButton = _tmp36_;
	_tmp37_ = self->priv->m_muteButton;
	_tmp38_ = self->priv->m_noiseIcon;
	gtk_button_set_image (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->m_muteButton;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp39_, FEED_READER_MEDIA_BUTTON_MUTE);
	_tmp40_ = self->priv->m_muteButton;
	g_signal_connect_object (_tmp40_, "clicked", (GCallback) _feed_reader_media_player_toggleMute_gtk_button_clicked, self, 0);
	_tmp41_ = self->priv->m_muteButton;
	gtk_widget_set_valign ((GtkWidget*) _tmp41_, GTK_ALIGN_CENTER);
	_tmp42_ = self->priv->m_muteButton;
	gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_CENTER);
	_tmp43_ = self->priv->m_muteButton;
	gtk_widget_set_size_request ((GtkWidget*) _tmp43_, 48, 48);
	_tmp44_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->m_closeButton);
	self->priv->m_closeButton = _tmp44_;
	_tmp45_ = self->priv->m_closeButton;
	_tmp46_ = self->priv->m_closeIcon;
	gtk_button_set_image (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->m_closeButton;
	g_signal_connect_object (_tmp47_, "clicked", (GCallback) ___lambda98__gtk_button_clicked, self, 0);
	_tmp48_ = self->priv->m_closeButton;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp48_, FEED_READER_MEDIA_BUTTON_CLOSE);
	_tmp49_ = self->priv->m_closeButton;
	gtk_widget_set_valign ((GtkWidget*) _tmp49_, GTK_ALIGN_CENTER);
	_tmp50_ = self->priv->m_closeButton;
	gtk_widget_set_halign ((GtkWidget*) _tmp50_, GTK_ALIGN_CENTER);
	_tmp51_ = self->priv->m_closeButton;
	gtk_widget_set_size_request ((GtkWidget*) _tmp51_, 48, 48);
	_tmp52_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, 0.0, 100.0, 5.0);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->m_scale);
	self->priv->m_scale = _tmp52_;
	_tmp53_ = self->priv->m_scale;
	gtk_scale_set_draw_value (_tmp53_, FALSE);
	_tmp54_ = self->priv->m_scale;
	gtk_widget_set_size_request ((GtkWidget*) _tmp54_, 200, 48);
	_tmp55_ = self->priv->m_scale;
	g_signal_connect_object ((GtkRange*) _tmp55_, "change-value", (GCallback) _feed_reader_media_player_valueChanged_gtk_range_change_value, self, 0);
	_tmp56_ = (GtkButton*) gtk_button_new_with_label ("00:00");
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->m_labelButton);
	self->priv->m_labelButton = _tmp56_;
	_tmp57_ = self->priv->m_labelButton;
	gtk_button_set_relief (_tmp57_, GTK_RELIEF_NONE);
	_tmp58_ = self->priv->m_labelButton;
	_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
	gtk_style_context_add_class (_tmp59_, "h3");
	_tmp60_ = self->priv->m_labelButton;
	g_signal_connect_object (_tmp60_, "clicked", (GCallback) _feed_reader_media_player_switchDisplay_gtk_button_clicked, self, 0);
	_tmp61_ = self->priv->m_labelButton;
	gtk_widget_set_valign ((GtkWidget*) _tmp61_, GTK_ALIGN_CENTER);
	_tmp62_ = self->priv->m_labelButton;
	gtk_widget_set_halign ((GtkWidget*) _tmp62_, GTK_ALIGN_CENTER);
	_tmp63_ = self->priv->m_labelButton;
	gtk_widget_set_size_request ((GtkWidget*) _tmp63_, 48, 48);
	_tmp64_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp64_);
	hBox = _tmp64_;
	_tmp65_ = hBox;
	g_object_set ((GtkWidget*) _tmp65_, "margin", self->priv->m_margin, NULL);
	_tmp66_ = hBox;
	_tmp67_ = self->priv->m_playStack;
	gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, FALSE, FALSE, (guint) 0);
	_tmp68_ = hBox;
	_tmp69_ = self->priv->m_muteButton;
	gtk_box_pack_start (_tmp68_, (GtkWidget*) _tmp69_, FALSE, FALSE, (guint) 0);
	_tmp70_ = hBox;
	_tmp71_ = self->priv->m_scale;
	gtk_box_pack_start (_tmp70_, (GtkWidget*) _tmp71_, TRUE, TRUE, (guint) 0);
	_tmp72_ = hBox;
	_tmp73_ = self->priv->m_labelButton;
	gtk_box_pack_start (_tmp72_, (GtkWidget*) _tmp73_, FALSE, FALSE, (guint) 0);
	_tmp74_ = hBox;
	_tmp75_ = self->priv->m_closeButton;
	gtk_box_pack_start (_tmp74_, (GtkWidget*) _tmp75_, FALSE, FALSE, (guint) 0);
	_tmp76_ = (GtkLabel*) gtk_label_new ("0%");
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->m_bufferLabel);
	self->priv->m_bufferLabel = _tmp76_;
	_tmp77_ = self->priv->m_bufferLabel;
	gtk_widget_set_valign ((GtkWidget*) _tmp77_, GTK_ALIGN_CENTER);
	_tmp78_ = self->priv->m_bufferLabel;
	gtk_widget_set_halign ((GtkWidget*) _tmp78_, GTK_ALIGN_CENTER);
	_tmp79_ = self->priv->m_bufferLabel;
	gtk_widget_set_size_request ((GtkWidget*) _tmp79_, 48, 48);
	_tmp80_ = self->priv->m_bufferLabel;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp80_, TRUE);
	_tmp81_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp81_);
	bufferOverlay = _tmp81_;
	_tmp82_ = bufferOverlay;
	_tmp83_ = self->priv->m_videoWidget;
	gtk_container_add ((GtkContainer*) _tmp82_, _tmp83_);
	_tmp84_ = bufferOverlay;
	_tmp85_ = self->priv->m_bufferLabel;
	gtk_overlay_add_overlay (_tmp84_, (GtkWidget*) _tmp85_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp86_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp86_, "osd");
	g_object_set ((GtkWidget*) self, "margin", 40, NULL);
	if (self->priv->m_type == FEED_READER_MEDIA_TYPE_VIDEO) {
		GtkOverlay* _tmp87_;
		_tmp87_ = bufferOverlay;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp87_, TRUE, TRUE, (guint) 0);
	}
	_tmp88_ = hBox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp88_, FALSE, FALSE, (guint) 0);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_END);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (bufferOverlay);
	_g_object_unref0 (hBox);
	_g_object_unref0 (bus);
	_g_object_unref0 (gtksink);
}

static void
feed_reader_media_player_togglePause (FeedReaderMediaPlayer* self)
{
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_player;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) 1000);
	state = _tmp1_;
	pending = _tmp2_;
	switch (state) {
		case GST_STATE_PLAYING:
		{
			GtkButton* _tmp3_;
			GtkImage* _tmp4_;
			GtkButton* _tmp5_;
			GstElement* _tmp6_;
			_tmp3_ = self->priv->m_playButton;
			_tmp4_ = self->priv->m_playIcon;
			gtk_button_set_image (_tmp3_, (GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->m_playButton;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, FEED_READER_MEDIA_BUTTON_PLAY);
			_tmp6_ = self->priv->m_player;
			gst_element_set_state (_tmp6_, GST_STATE_PAUSED);
			break;
		}
		default:
		case GST_STATE_PAUSED:
		case GST_STATE_READY:
		{
			GtkButton* _tmp7_;
			GtkImage* _tmp8_;
			GtkButton* _tmp9_;
			GstElement* _tmp10_;
			_tmp7_ = self->priv->m_playButton;
			_tmp8_ = self->priv->m_pauseIcon;
			gtk_button_set_image (_tmp7_, (GtkWidget*) _tmp8_);
			_tmp9_ = self->priv->m_playButton;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, FEED_READER_MEDIA_BUTTON_PAUSE);
			_tmp10_ = self->priv->m_player;
			gst_element_set_state (_tmp10_, GST_STATE_PLAYING);
			break;
		}
	}
	if (self->priv->m_muted) {
		GstElement* _tmp11_;
		_tmp11_ = self->priv->m_player;
		g_object_set ((GObject*) _tmp11_, "volume", 0.0, NULL);
	} else {
		GstElement* _tmp12_;
		_tmp12_ = self->priv->m_player;
		g_object_set ((GObject*) _tmp12_, "volume", 1.0, NULL);
	}
}

static void
feed_reader_media_player_switchDisplay (FeedReaderMediaPlayer* self)
{
	g_return_if_fail (self != NULL);
	switch (self->priv->m_display) {
		case FEED_READER_DISPLAY_POSITION_ALL:
		{
			self->priv->m_display = FEED_READER_DISPLAY_POSITION_POS;
			break;
		}
		case FEED_READER_DISPLAY_POSITION_POS:
		{
			self->priv->m_display = FEED_READER_DISPLAY_POSITION_LEFT;
			break;
		}
		case FEED_READER_DISPLAY_POSITION_LEFT:
		{
			self->priv->m_display = FEED_READER_DISPLAY_POSITION_ALL;
			break;
		}
		default:
		break;
	}
	feed_reader_media_player_calcTime (self);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

static void
feed_reader_media_player_calcTime (FeedReaderMediaPlayer* self)
{
	gint64 pos = 0LL;
	gint64 dur = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	GstElement* _tmp2_;
	gint64 _tmp3_ = 0LL;
	gdouble position = 0.0;
	gdouble duration = 0.0;
	gdouble* sd = NULL;
	gdouble* _tmp4_;
	gdouble* md = NULL;
	gdouble* hd = NULL;
	gdouble* _tmp5_;
	gdouble* sp = NULL;
	gdouble* _tmp21_;
	gdouble* mp = NULL;
	gdouble* hp = NULL;
	gdouble* _tmp22_;
	gdouble* sr = NULL;
	gdouble _tmp38_;
	gdouble* _tmp39_;
	gdouble* mr = NULL;
	gdouble* hr = NULL;
	gdouble* _tmp40_;
	gchar* pLabel = NULL;
	gchar* _tmp56_;
	const gchar* _tmp57_ = NULL;
	gdouble* _tmp58_;
	const gchar* _tmp65_ = NULL;
	gdouble* _tmp66_;
	const gchar* _tmp73_ = NULL;
	gdouble* _tmp74_;
	const gchar* _tmp81_;
	gdouble* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* dLabel = NULL;
	gchar* _tmp86_;
	const gchar* _tmp87_ = NULL;
	gdouble* _tmp88_;
	const gchar* _tmp95_ = NULL;
	gdouble* _tmp96_;
	const gchar* _tmp103_ = NULL;
	gdouble* _tmp104_;
	const gchar* _tmp111_;
	gdouble* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* rLabel = NULL;
	gchar* _tmp116_;
	const gchar* _tmp117_ = NULL;
	gdouble* _tmp118_;
	const gchar* _tmp125_ = NULL;
	gdouble* _tmp126_;
	const gchar* _tmp133_ = NULL;
	gdouble* _tmp134_;
	const gchar* _tmp141_;
	gdouble* _tmp142_;
	gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_player;
	gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	pos = _tmp1_;
	_tmp2_ = self->priv->m_player;
	gst_element_query_duration (_tmp2_, GST_FORMAT_TIME, &_tmp3_);
	dur = _tmp3_;
	position = (gdouble) ((gint) (((gdouble) pos) / 1000000000));
	duration = (gdouble) ((gint) (((gdouble) dur) / 1000000000));
	_tmp4_ = __double_dup0 (&duration);
	sd = _tmp4_;
	md = NULL;
	hd = NULL;
	_tmp5_ = sd;
	if (((gint) (*_tmp5_)) >= 60) {
		gdouble* _tmp6_;
		gdouble _tmp7_;
		gdouble* _tmp8_;
		gdouble* _tmp9_;
		gdouble* _tmp10_;
		gdouble _tmp11_;
		gdouble* _tmp12_;
		gdouble* _tmp13_;
		_tmp6_ = sd;
		_tmp7_ = (gdouble) ((gint) ((*_tmp6_) / 60));
		_tmp8_ = __double_dup0 (&_tmp7_);
		_g_free0 (md);
		md = _tmp8_;
		_tmp9_ = sd;
		_tmp10_ = md;
		_tmp11_ = (*_tmp9_) - ((*_tmp10_) * 60);
		_tmp12_ = __double_dup0 (&_tmp11_);
		_g_free0 (sd);
		sd = _tmp12_;
		_tmp13_ = md;
		if (((gint) (*_tmp13_)) >= 60) {
			gdouble* _tmp14_;
			gdouble _tmp15_;
			gdouble* _tmp16_;
			gdouble* _tmp17_;
			gdouble* _tmp18_;
			gdouble _tmp19_;
			gdouble* _tmp20_;
			_tmp14_ = md;
			_tmp15_ = (gdouble) ((gint) ((*_tmp14_) / 60));
			_tmp16_ = __double_dup0 (&_tmp15_);
			_g_free0 (hd);
			hd = _tmp16_;
			_tmp17_ = md;
			_tmp18_ = hd;
			_tmp19_ = (*_tmp17_) - ((*_tmp18_) * 60);
			_tmp20_ = __double_dup0 (&_tmp19_);
			_g_free0 (md);
			md = _tmp20_;
		}
	}
	_tmp21_ = __double_dup0 (&position);
	sp = _tmp21_;
	mp = NULL;
	hp = NULL;
	_tmp22_ = sp;
	if (((gint) (*_tmp22_)) >= 60) {
		gdouble* _tmp23_;
		gdouble _tmp24_;
		gdouble* _tmp25_;
		gdouble* _tmp26_;
		gdouble* _tmp27_;
		gdouble _tmp28_;
		gdouble* _tmp29_;
		gdouble* _tmp30_;
		_tmp23_ = sp;
		_tmp24_ = (gdouble) ((gint) ((*_tmp23_) / 60));
		_tmp25_ = __double_dup0 (&_tmp24_);
		_g_free0 (mp);
		mp = _tmp25_;
		_tmp26_ = sp;
		_tmp27_ = mp;
		_tmp28_ = (*_tmp26_) - ((*_tmp27_) * 60);
		_tmp29_ = __double_dup0 (&_tmp28_);
		_g_free0 (sp);
		sp = _tmp29_;
		_tmp30_ = mp;
		if (((gint) (*_tmp30_)) >= 60) {
			gdouble* _tmp31_;
			gdouble _tmp32_;
			gdouble* _tmp33_;
			gdouble* _tmp34_;
			gdouble* _tmp35_;
			gdouble _tmp36_;
			gdouble* _tmp37_;
			_tmp31_ = mp;
			_tmp32_ = (gdouble) ((gint) ((*_tmp31_) / 60));
			_tmp33_ = __double_dup0 (&_tmp32_);
			_g_free0 (hp);
			hp = _tmp33_;
			_tmp34_ = mp;
			_tmp35_ = hp;
			_tmp36_ = (*_tmp34_) - ((*_tmp35_) * 60);
			_tmp37_ = __double_dup0 (&_tmp36_);
			_g_free0 (mp);
			mp = _tmp37_;
		}
	}
	_tmp38_ = duration - position;
	_tmp39_ = __double_dup0 (&_tmp38_);
	sr = _tmp39_;
	mr = NULL;
	hr = NULL;
	_tmp40_ = sr;
	if (((gint) (*_tmp40_)) >= 60) {
		gdouble* _tmp41_;
		gdouble _tmp42_;
		gdouble* _tmp43_;
		gdouble* _tmp44_;
		gdouble* _tmp45_;
		gdouble _tmp46_;
		gdouble* _tmp47_;
		gdouble* _tmp48_;
		_tmp41_ = sr;
		_tmp42_ = (gdouble) ((gint) ((*_tmp41_) / 60));
		_tmp43_ = __double_dup0 (&_tmp42_);
		_g_free0 (mr);
		mr = _tmp43_;
		_tmp44_ = sr;
		_tmp45_ = mr;
		_tmp46_ = (*_tmp44_) - ((*_tmp45_) * 60);
		_tmp47_ = __double_dup0 (&_tmp46_);
		_g_free0 (sr);
		sr = _tmp47_;
		_tmp48_ = mr;
		if (((gint) (*_tmp48_)) >= 60) {
			gdouble* _tmp49_;
			gdouble _tmp50_;
			gdouble* _tmp51_;
			gdouble* _tmp52_;
			gdouble* _tmp53_;
			gdouble _tmp54_;
			gdouble* _tmp55_;
			_tmp49_ = mr;
			_tmp50_ = (gdouble) ((gint) ((*_tmp49_) / 60));
			_tmp51_ = __double_dup0 (&_tmp50_);
			_g_free0 (hr);
			hr = _tmp51_;
			_tmp52_ = mr;
			_tmp53_ = hr;
			_tmp54_ = (*_tmp52_) - ((*_tmp53_) * 60);
			_tmp55_ = __double_dup0 (&_tmp54_);
			_g_free0 (mr);
			mr = _tmp55_;
		}
	}
	_tmp56_ = g_strdup ("");
	pLabel = _tmp56_;
	_tmp58_ = hp;
	if (_tmp58_ != NULL) {
		const gchar* _tmp59_;
		gdouble* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		const gchar* _tmp64_;
		_tmp59_ = pLabel;
		_tmp60_ = hp;
		_tmp61_ = g_strdup_printf ("%02.0f:", *_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strconcat (_tmp59_, _tmp62_, NULL);
		_g_free0 (pLabel);
		pLabel = _tmp63_;
		_tmp64_ = pLabel;
		_tmp57_ = _tmp64_;
		_g_free0 (_tmp62_);
	} else {
		_tmp57_ = NULL;
	}
	_tmp66_ = mp;
	if (_tmp66_ != NULL) {
		const gchar* _tmp67_;
		gdouble* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		const gchar* _tmp72_;
		_tmp67_ = pLabel;
		_tmp68_ = mp;
		_tmp69_ = g_strdup_printf ("%02.0f", *_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strconcat (_tmp67_, _tmp70_, NULL);
		_g_free0 (pLabel);
		pLabel = _tmp71_;
		_tmp72_ = pLabel;
		_tmp65_ = _tmp72_;
		_g_free0 (_tmp70_);
	} else {
		_tmp65_ = NULL;
	}
	_tmp74_ = mp;
	if (_tmp74_ != NULL) {
		const gchar* _tmp75_;
		gchar* _tmp76_;
		const gchar* _tmp77_;
		_tmp75_ = pLabel;
		_tmp76_ = g_strconcat (_tmp75_, ":", NULL);
		_g_free0 (pLabel);
		pLabel = _tmp76_;
		_tmp77_ = pLabel;
		_tmp73_ = _tmp77_;
	} else {
		const gchar* _tmp78_;
		gchar* _tmp79_;
		const gchar* _tmp80_;
		_tmp78_ = pLabel;
		_tmp79_ = g_strconcat (_tmp78_, "0:", NULL);
		_g_free0 (pLabel);
		pLabel = _tmp79_;
		_tmp80_ = pLabel;
		_tmp73_ = _tmp80_;
	}
	_tmp81_ = pLabel;
	_tmp82_ = sp;
	_tmp83_ = g_strdup_printf ("%02.0f", *_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strconcat (_tmp81_, _tmp84_, NULL);
	_g_free0 (pLabel);
	pLabel = _tmp85_;
	_g_free0 (_tmp84_);
	_tmp86_ = g_strdup ("");
	dLabel = _tmp86_;
	_tmp88_ = hd;
	if (_tmp88_ != NULL) {
		const gchar* _tmp89_;
		gdouble* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		const gchar* _tmp94_;
		_tmp89_ = dLabel;
		_tmp90_ = hd;
		_tmp91_ = g_strdup_printf ("%02.0f:", *_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp93_ = g_strconcat (_tmp89_, _tmp92_, NULL);
		_g_free0 (dLabel);
		dLabel = _tmp93_;
		_tmp94_ = dLabel;
		_tmp87_ = _tmp94_;
		_g_free0 (_tmp92_);
	} else {
		_tmp87_ = NULL;
	}
	_tmp96_ = md;
	if (_tmp96_ != NULL) {
		const gchar* _tmp97_;
		gdouble* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		const gchar* _tmp102_;
		_tmp97_ = dLabel;
		_tmp98_ = md;
		_tmp99_ = g_strdup_printf ("%02.0f", *_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = g_strconcat (_tmp97_, _tmp100_, NULL);
		_g_free0 (dLabel);
		dLabel = _tmp101_;
		_tmp102_ = dLabel;
		_tmp95_ = _tmp102_;
		_g_free0 (_tmp100_);
	} else {
		_tmp95_ = NULL;
	}
	_tmp104_ = md;
	if (_tmp104_ != NULL) {
		const gchar* _tmp105_;
		gchar* _tmp106_;
		const gchar* _tmp107_;
		_tmp105_ = dLabel;
		_tmp106_ = g_strconcat (_tmp105_, ":", NULL);
		_g_free0 (dLabel);
		dLabel = _tmp106_;
		_tmp107_ = dLabel;
		_tmp103_ = _tmp107_;
	} else {
		const gchar* _tmp108_;
		gchar* _tmp109_;
		const gchar* _tmp110_;
		_tmp108_ = dLabel;
		_tmp109_ = g_strconcat (_tmp108_, "0:", NULL);
		_g_free0 (dLabel);
		dLabel = _tmp109_;
		_tmp110_ = dLabel;
		_tmp103_ = _tmp110_;
	}
	_tmp111_ = dLabel;
	_tmp112_ = sd;
	_tmp113_ = g_strdup_printf ("%02.0f", *_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = g_strconcat (_tmp111_, _tmp114_, NULL);
	_g_free0 (dLabel);
	dLabel = _tmp115_;
	_g_free0 (_tmp114_);
	_tmp116_ = g_strdup ("-");
	rLabel = _tmp116_;
	_tmp118_ = hr;
	if (_tmp118_ != NULL) {
		const gchar* _tmp119_;
		gdouble* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		const gchar* _tmp124_;
		_tmp119_ = rLabel;
		_tmp120_ = hr;
		_tmp121_ = g_strdup_printf ("%02.0f:", *_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = g_strconcat (_tmp119_, _tmp122_, NULL);
		_g_free0 (rLabel);
		rLabel = _tmp123_;
		_tmp124_ = rLabel;
		_tmp117_ = _tmp124_;
		_g_free0 (_tmp122_);
	} else {
		_tmp117_ = NULL;
	}
	_tmp126_ = mr;
	if (_tmp126_ != NULL) {
		const gchar* _tmp127_;
		gdouble* _tmp128_;
		gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		const gchar* _tmp132_;
		_tmp127_ = rLabel;
		_tmp128_ = mr;
		_tmp129_ = g_strdup_printf ("%02.0f", *_tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = g_strconcat (_tmp127_, _tmp130_, NULL);
		_g_free0 (rLabel);
		rLabel = _tmp131_;
		_tmp132_ = rLabel;
		_tmp125_ = _tmp132_;
		_g_free0 (_tmp130_);
	} else {
		_tmp125_ = NULL;
	}
	_tmp134_ = mr;
	if (_tmp134_ != NULL) {
		const gchar* _tmp135_;
		gchar* _tmp136_;
		const gchar* _tmp137_;
		_tmp135_ = rLabel;
		_tmp136_ = g_strconcat (_tmp135_, ":", NULL);
		_g_free0 (rLabel);
		rLabel = _tmp136_;
		_tmp137_ = rLabel;
		_tmp133_ = _tmp137_;
	} else {
		const gchar* _tmp138_;
		gchar* _tmp139_;
		const gchar* _tmp140_;
		_tmp138_ = rLabel;
		_tmp139_ = g_strconcat (_tmp138_, "0:", NULL);
		_g_free0 (rLabel);
		rLabel = _tmp139_;
		_tmp140_ = rLabel;
		_tmp133_ = _tmp140_;
	}
	_tmp141_ = rLabel;
	_tmp142_ = sr;
	_tmp143_ = g_strdup_printf ("%02.0f", *_tmp142_);
	_tmp144_ = _tmp143_;
	_tmp145_ = g_strconcat (_tmp141_, _tmp144_, NULL);
	_g_free0 (rLabel);
	rLabel = _tmp145_;
	_g_free0 (_tmp144_);
	if (dur == ((gint64) -1)) {
		GtkButton* _tmp146_;
		const gchar* _tmp147_;
		_tmp146_ = self->priv->m_labelButton;
		_tmp147_ = pLabel;
		gtk_button_set_label (_tmp146_, _tmp147_);
		_g_free0 (rLabel);
		_g_free0 (dLabel);
		_g_free0 (pLabel);
		_g_free0 (hr);
		_g_free0 (mr);
		_g_free0 (sr);
		_g_free0 (hp);
		_g_free0 (mp);
		_g_free0 (sp);
		_g_free0 (hd);
		_g_free0 (md);
		_g_free0 (sd);
		return;
	}
	switch (self->priv->m_display) {
		case FEED_READER_DISPLAY_POSITION_ALL:
		{
			GtkButton* _tmp148_;
			const gchar* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			const gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			_tmp148_ = self->priv->m_labelButton;
			_tmp149_ = pLabel;
			_tmp150_ = g_strconcat (_tmp149_, " / ", NULL);
			_tmp151_ = _tmp150_;
			_tmp152_ = dLabel;
			_tmp153_ = g_strconcat (_tmp151_, _tmp152_, NULL);
			_tmp154_ = _tmp153_;
			gtk_button_set_label (_tmp148_, _tmp154_);
			_g_free0 (_tmp154_);
			_g_free0 (_tmp151_);
			break;
		}
		case FEED_READER_DISPLAY_POSITION_POS:
		{
			GtkButton* _tmp155_;
			const gchar* _tmp156_;
			_tmp155_ = self->priv->m_labelButton;
			_tmp156_ = pLabel;
			gtk_button_set_label (_tmp155_, _tmp156_);
			break;
		}
		case FEED_READER_DISPLAY_POSITION_LEFT:
		{
			GtkButton* _tmp157_;
			const gchar* _tmp158_;
			_tmp157_ = self->priv->m_labelButton;
			_tmp158_ = rLabel;
			gtk_button_set_label (_tmp157_, _tmp158_);
			break;
		}
		default:
		break;
	}
	_g_free0 (rLabel);
	_g_free0 (dLabel);
	_g_free0 (pLabel);
	_g_free0 (hr);
	_g_free0 (mr);
	_g_free0 (sr);
	_g_free0 (hp);
	_g_free0 (mp);
	_g_free0 (sp);
	_g_free0 (hd);
	_g_free0 (md);
	_g_free0 (sd);
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		FeedReaderMediaPlayer* self;
		self = _data27_->self;
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static gboolean
___lambda99_ (Block27Data* _data27_)
{
	FeedReaderMediaPlayer* self;
	GtkScale* _tmp0_;
	gboolean result;
	self = _data27_->self;
	_tmp0_ = self->priv->m_scale;
	if (gtk_range_get_value ((GtkRange*) _tmp0_) != _data27_->startValue) {
		GtkScale* _tmp1_;
		_tmp1_ = self->priv->m_scale;
		_data27_->startValue = gtk_range_get_value ((GtkRange*) _tmp1_);
		result = TRUE;
		return result;
	} else {
		self->priv->m_seek_source_id = (guint) 0;
		feed_reader_media_player_seek (self, _data27_->startValue);
		result = FALSE;
		return result;
	}
}

static gboolean
____lambda99__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda99_ (self);
	return result;
}

static gboolean
feed_reader_media_player_valueChanged (FeedReaderMediaPlayer* self,
                                       GtkScrollType scroll,
                                       gdouble new_value)
{
	GtkScale* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_scale;
	gtk_range_set_value ((GtkRange*) _tmp0_, new_value);
	if (self->priv->m_seek_source_id == ((guint) 0)) {
		Block27Data* _data27_;
		_data27_ = g_slice_new0 (Block27Data);
		_data27_->_ref_count_ = 1;
		_data27_->self = g_object_ref (self);
		_data27_->startValue = new_value;
		self->priv->m_seek_source_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda99__gsource_func, block27_data_ref (_data27_), block27_data_unref);
		block27_data_unref (_data27_);
		_data27_ = NULL;
	}
	result = TRUE;
	return result;
}

static void
feed_reader_media_player_seek (FeedReaderMediaPlayer* self,
                               gdouble new_value)
{
	gint64 dur = 0LL;
	gdouble percent = 0.0;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gint64 pos = 0LL;
	GstElement* _tmp2_;
	GtkButton* _tmp3_;
	GtkImage* _tmp4_;
	GstElement* _tmp5_;
	g_return_if_fail (self != NULL);
	percent = new_value / 100.0;
	_tmp0_ = self->priv->m_player;
	gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	dur = _tmp1_;
	pos = (gint64) (percent * ((gdouble) dur));
	_tmp2_ = self->priv->m_player;
	gst_element_seek_simple (_tmp2_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, pos);
	_tmp3_ = self->priv->m_playButton;
	_tmp4_ = self->priv->m_pauseIcon;
	gtk_button_set_image (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->m_player;
	gst_element_set_state (_tmp5_, GST_STATE_PLAYING);
}

static void
feed_reader_media_player_toggleMute (FeedReaderMediaPlayer* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->m_muted) {
		GtkButton* _tmp0_;
		GtkImage* _tmp1_;
		GtkButton* _tmp2_;
		GstElement* _tmp3_;
		_tmp0_ = self->priv->m_muteButton;
		_tmp1_ = self->priv->m_noiseIcon;
		gtk_button_set_image (_tmp0_, (GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->m_muteButton;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, FEED_READER_MEDIA_BUTTON_MUTE);
		_tmp3_ = self->priv->m_player;
		g_object_set ((GObject*) _tmp3_, "volume", 1.0, NULL);
		self->priv->m_muted = FALSE;
	} else {
		GtkButton* _tmp4_;
		GtkImage* _tmp5_;
		GtkButton* _tmp6_;
		GstElement* _tmp7_;
		_tmp4_ = self->priv->m_muteButton;
		_tmp5_ = self->priv->m_muteIcon;
		gtk_button_set_image (_tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->m_muteButton;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, FEED_READER_MEDIA_BUTTON_UNMUTE);
		_tmp7_ = self->priv->m_player;
		g_object_set ((GObject*) _tmp7_, "volume", 0.0, NULL);
		self->priv->m_muted = TRUE;
	}
}

static gboolean
feed_reader_media_player_busCallback (FeedReaderMediaPlayer* self,
                                      GstBus* bus,
                                      GstMessage* message)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_ERROR:
		{
			GError* err = NULL;
			gchar* debug = NULL;
			GError* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GstElement* _tmp6_;
			gst_message_parse_error (message, &_tmp0_, &_tmp1_);
			_g_error_free0 (err);
			err = _tmp0_;
			_g_free0 (debug);
			debug = _tmp1_;
			_tmp2_ = err;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strconcat ("MediaPlayer: ", _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			feed_reader_logger_error (_tmp5_);
			_g_free0 (_tmp5_);
			_tmp6_ = self->priv->m_player;
			gst_element_set_state (_tmp6_, GST_STATE_NULL);
			_g_free0 (debug);
			_g_error_free0 (err);
			break;
		}
		case GST_MESSAGE_EOS:
		{
			GstElement* _tmp7_;
			GtkButton* _tmp8_;
			GtkImage* _tmp9_;
			_tmp7_ = self->priv->m_player;
			gst_element_set_state (_tmp7_, GST_STATE_READY);
			_tmp8_ = self->priv->m_playButton;
			_tmp9_ = self->priv->m_playIcon;
			gtk_button_set_image (_tmp8_, (GtkWidget*) _tmp9_);
			break;
		}
		case GST_MESSAGE_BUFFERING:
		{
			gint percent = 0;
			gint _tmp10_ = 0;
			percent = 0;
			gst_message_parse_buffering (message, &_tmp10_);
			percent = _tmp10_;
			if (percent < 100) {
				GstElement* _tmp11_;
				_tmp11_ = self->priv->m_player;
				gst_element_set_state (_tmp11_, GST_STATE_PAUSED);
				if (self->priv->m_type == FEED_READER_MEDIA_TYPE_VIDEO) {
					GtkLabel* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					GtkLabel* _tmp17_;
					_tmp12_ = self->priv->m_bufferLabel;
					_tmp13_ = g_strdup_printf ("%i", percent);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp14_, "%", NULL);
					_tmp16_ = _tmp15_;
					gtk_label_set_text (_tmp12_, _tmp16_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					_tmp17_ = self->priv->m_bufferLabel;
					gtk_widget_show ((GtkWidget*) _tmp17_);
				} else {
					GtkStack* _tmp18_;
					GtkSpinner* _tmp19_;
					_tmp18_ = self->priv->m_playStack;
					gtk_stack_set_visible_child_name (_tmp18_, "spinner");
					_tmp19_ = self->priv->m_playSpinner;
					gtk_spinner_start (_tmp19_);
				}
			} else {
				GstElement* _tmp20_;
				_tmp20_ = self->priv->m_player;
				gst_element_set_state (_tmp20_, GST_STATE_PLAYING);
				if (self->priv->m_type == FEED_READER_MEDIA_TYPE_VIDEO) {
					GtkLabel* _tmp21_;
					_tmp21_ = self->priv->m_bufferLabel;
					gtk_widget_hide ((GtkWidget*) _tmp21_);
				} else {
					GtkStack* _tmp22_;
					_tmp22_ = self->priv->m_playStack;
					gtk_stack_set_visible_child_name (_tmp22_, "button");
				}
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstState oldstate = 0;
			GstState newstate = 0;
			GstState pending = 0;
			GstState _tmp23_ = 0;
			GstState _tmp24_ = 0;
			GstState _tmp25_ = 0;
			gst_message_parse_state_changed (message, &_tmp23_, &_tmp24_, &_tmp25_);
			oldstate = _tmp23_;
			newstate = _tmp24_;
			pending = _tmp25_;
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}

static void
feed_reader_media_player_onAllocation (FeedReaderMediaPlayer* self,
                                       GtkAllocation* allocation)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	if (self->priv->m_aspectRatio != ((gdouble) 0)) {
		gdouble width = 0.0;
		GtkAllocation _tmp0_;
		gint height = 0;
		GtkWidget* _tmp1_;
		_tmp0_ = *allocation;
		width = (gdouble) _tmp0_.width;
		height = (gint) (width / self->priv->m_aspectRatio);
		_tmp1_ = self->priv->m_videoWidget;
		gtk_widget_set_size_request (_tmp1_, -1, height);
	}
}

void
feed_reader_media_player_kill (FeedReaderMediaPlayer* self)
{
	GstElement* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_player;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
feed_reader_media_player_class_init (FeedReaderMediaPlayerClass * klass,
                                     gpointer klass_data)
{
	feed_reader_media_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderMediaPlayer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_media_player_finalize;
	feed_reader_media_player_signals[FEED_READER_MEDIA_PLAYER_LOADED_SIGNAL] = g_signal_new ("loaded", FEED_READER_TYPE_MEDIA_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
feed_reader_media_player_instance_init (FeedReaderMediaPlayer * self,
                                        gpointer klass)
{
	self->priv = feed_reader_media_player_get_instance_private (self);
	self->priv->m_margin = 20;
	self->priv->m_muted = FALSE;
	self->priv->m_aspectRatio = 0.0;
	self->priv->m_seek_source_id = (guint) 0;
	self->priv->m_display = FEED_READER_DISPLAY_POSITION_ALL;
}

static void
feed_reader_media_player_finalize (GObject * obj)
{
	FeedReaderMediaPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_MEDIA_PLAYER, FeedReaderMediaPlayer);
	_g_object_unref0 (self->priv->m_player);
	_g_object_unref0 (self->priv->m_videoWidget);
	_g_object_unref0 (self->priv->m_playStack);
	_g_object_unref0 (self->priv->m_playButton);
	_g_object_unref0 (self->priv->m_playSpinner);
	_g_object_unref0 (self->priv->m_muteButton);
	_g_object_unref0 (self->priv->m_closeButton);
	_g_object_unref0 (self->priv->m_scale);
	_g_object_unref0 (self->priv->m_labelButton);
	_g_object_unref0 (self->priv->m_bufferLabel);
	_g_object_unref0 (self->priv->m_playIcon);
	_g_object_unref0 (self->priv->m_pauseIcon);
	_g_object_unref0 (self->priv->m_muteIcon);
	_g_object_unref0 (self->priv->m_noiseIcon);
	_g_object_unref0 (self->priv->m_closeIcon);
	_g_free0 (self->priv->m_URL);
	G_OBJECT_CLASS (feed_reader_media_player_parent_class)->finalize (obj);
}

static GType
feed_reader_media_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderMediaPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_media_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderMediaPlayer), 0, (GInstanceInitFunc) feed_reader_media_player_instance_init, NULL };
	GType feed_reader_media_player_type_id;
	feed_reader_media_player_type_id = g_type_register_static (gtk_box_get_type (), "FeedReaderMediaPlayer", &g_define_type_info, 0);
	FeedReaderMediaPlayer_private_offset = g_type_add_instance_private (feed_reader_media_player_type_id, sizeof (FeedReaderMediaPlayerPrivate));
	return feed_reader_media_player_type_id;
}

GType
feed_reader_media_player_get_type (void)
{
	static volatile gsize feed_reader_media_player_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_media_player_type_id__once)) {
		GType feed_reader_media_player_type_id;
		feed_reader_media_player_type_id = feed_reader_media_player_get_type_once ();
		g_once_init_leave (&feed_reader_media_player_type_id__once, feed_reader_media_player_type_id);
	}
	return feed_reader_media_player_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

