/* ModeButton.c generated by valac 0.56.3, the Vala compiler
 * generated from ModeButton.vala, do not modify */

/*
*  Copyright (C) 2008-2013 Christian Hergert <chris@dronelabs.com>,
*                          Giulio Collura <random.cpp@gmail.com>,
*                          Victor Eduardo <victoreduardm@gmail.com>,
*                          ammonkey <am.monkeyd@gmail.com>
*
*  This program or library is free software; you can redistribute it
*  and/or modify it under the terms of the GNU Lesser General Public
*  License as published by the Free Software Foundation; either
*  version 3 of the License, or (at your option) any later version.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*  Lesser General Public License for more details.
*
*  You should have received a copy of the GNU Lesser General
*  Public License along with this library; if not, write to the
*  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
*  Boston, MA 02110-1301 USA.
*/

#include "FeedReader.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define FEED_READER_MODE_BUTTON_TYPE_ITEM (feed_reader_mode_button_item_get_type ())
#define FEED_READER_MODE_BUTTON_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FEED_READER_MODE_BUTTON_TYPE_ITEM, FeedReaderModeButtonItem))
#define FEED_READER_MODE_BUTTON_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FEED_READER_MODE_BUTTON_TYPE_ITEM, FeedReaderModeButtonItemClass))
#define FEED_READER_MODE_BUTTON_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FEED_READER_MODE_BUTTON_TYPE_ITEM))
#define FEED_READER_MODE_BUTTON_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FEED_READER_MODE_BUTTON_TYPE_ITEM))
#define FEED_READER_MODE_BUTTON_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FEED_READER_MODE_BUTTON_TYPE_ITEM, FeedReaderModeButtonItemClass))

typedef struct _FeedReaderModeButtonItem FeedReaderModeButtonItem;
typedef struct _FeedReaderModeButtonItemClass FeedReaderModeButtonItemClass;
enum  {
	FEED_READER_MODE_BUTTON_0_PROPERTY,
	FEED_READER_MODE_BUTTON_SELECTED_PROPERTY,
	FEED_READER_MODE_BUTTON_N_ITEMS_PROPERTY,
	FEED_READER_MODE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* feed_reader_mode_button_properties[FEED_READER_MODE_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _FeedReaderModeButtonItemPrivate FeedReaderModeButtonItemPrivate;
enum  {
	FEED_READER_MODE_BUTTON_ITEM_0_PROPERTY,
	FEED_READER_MODE_BUTTON_ITEM_INDEX_PROPERTY,
	FEED_READER_MODE_BUTTON_ITEM_NUM_PROPERTIES
};
static GParamSpec* feed_reader_mode_button_item_properties[FEED_READER_MODE_BUTTON_ITEM_NUM_PROPERTIES];
enum  {
	FEED_READER_MODE_BUTTON_MODE_ADDED_SIGNAL,
	FEED_READER_MODE_BUTTON_MODE_REMOVED_SIGNAL,
	FEED_READER_MODE_BUTTON_MODE_CHANGED_SIGNAL,
	FEED_READER_MODE_BUTTON_NUM_SIGNALS
};
static guint feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FeedReaderModeButtonPrivate {
	gint _selected;
	GeeHashMap* item_map;
	guint m_timeout_source_id;
};

struct _Block28Data {
	int _ref_count_;
	FeedReaderModeButton* self;
	FeedReaderModeButtonItem* item;
};

struct _Block29Data {
	int _ref_count_;
	FeedReaderModeButton* self;
	FeedReaderModeButtonItem* new_item;
};

struct _FeedReaderModeButtonItem {
	GtkToggleButton parent_instance;
	FeedReaderModeButtonItemPrivate * priv;
};

struct _FeedReaderModeButtonItemClass {
	GtkToggleButtonClass parent_class;
};

struct _FeedReaderModeButtonItemPrivate {
	gint _index;
};

static gint FeedReaderModeButton_private_offset;
static gpointer feed_reader_mode_button_parent_class = NULL;
static gint FeedReaderModeButtonItem_private_offset;
static gpointer feed_reader_mode_button_item_parent_class = NULL;

static GType feed_reader_mode_button_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static FeedReaderModeButtonItem* feed_reader_mode_button_item_new (gint index);
static FeedReaderModeButtonItem* feed_reader_mode_button_item_construct (GType object_type,
                                                                  gint index);
static gboolean feed_reader_mode_button_on_scroll_event (FeedReaderModeButton* self,
                                                  GtkWidget* widget,
                                                  GdkEventScroll* ev);
static gboolean _feed_reader_mode_button_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                           GdkEventScroll* event,
                                                                           gpointer self);
static gboolean __lambda118_ (Block28Data* _data28_);
static gint feed_reader_mode_button_item_get_index (FeedReaderModeButtonItem* self);
static gboolean ___lambda118__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static gboolean ____lambda117_ (Block29Data* _data29_);
static gboolean _____lambda117__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__INT_OBJECT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void feed_reader_mode_button_item_set_index (FeedReaderModeButtonItem* self,
                                             gint value);
static void feed_reader_mode_button_item_finalize (GObject * obj);
static GType feed_reader_mode_button_item_get_type_once (void);
static void _vala_feed_reader_mode_button_item_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_feed_reader_mode_button_item_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void feed_reader_mode_button_finalize (GObject * obj);
static GType feed_reader_mode_button_get_type_once (void);
static void _vala_feed_reader_mode_button_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_feed_reader_mode_button_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_mode_button_get_instance_private (FeedReaderModeButton* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderModeButton_private_offset);
}

/**
* Makes new ModeButton
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderModeButton*
feed_reader_mode_button_construct (GType object_type)
{
	FeedReaderModeButton * self = NULL;
	GeeHashMap* _tmp0_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	self = (FeedReaderModeButton*) g_object_new (object_type, NULL);
	gtk_box_set_homogeneous ((GtkBox*) self, TRUE);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp0_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, FEED_READER_MODE_BUTTON_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->item_map);
	self->priv->item_map = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	style = _tmp2_;
	gtk_style_context_add_class (style, GTK_STYLE_CLASS_LINKED);
	gtk_style_context_add_class (style, "raised");
	_g_object_unref0 (style);
	return self;
}

FeedReaderModeButton*
feed_reader_mode_button_new (void)
{
	return feed_reader_mode_button_construct (FEED_READER_TYPE_MODE_BUTTON);
}

/**
* Appends Pixbuf to ModeButton
*
* @param pixbuf Gdk.Pixbuf to append to ModeButton
*/
gint
feed_reader_mode_button_append_pixbuf (FeedReaderModeButton* self,
                                       GdkPixbuf* pixbuf,
                                       const gchar* tooltip)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pixbuf != NULL, 0);
	g_return_val_if_fail (tooltip != NULL, 0);
	_tmp0_ = (GtkImage*) gtk_image_new_from_pixbuf (pixbuf);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_mode_button_append (self, (GtkWidget*) _tmp1_, tooltip);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
* Appends text to ModeButton
*
* @param text text to append to ModeButton
* @return index of new item
*/
gint
feed_reader_mode_button_append_text (FeedReaderModeButton* self,
                                     const gchar* text,
                                     const gchar* tooltip)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	g_return_val_if_fail (tooltip != NULL, 0);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_mode_button_append (self, (GtkWidget*) _tmp1_, tooltip);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
* Appends icon to ModeButton
*
* @param icon_name name of icon to append
* @param size desired size of icon
* @return index of appended item
*/
gint
feed_reader_mode_button_append_icon (FeedReaderModeButton* self,
                                     const gchar* icon_name,
                                     GtkIconSize size,
                                     const gchar* tooltip)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (icon_name != NULL, 0);
	g_return_val_if_fail (tooltip != NULL, 0);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) size);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_mode_button_append (self, (GtkWidget*) _tmp1_, tooltip);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
* Appends given widget to ModeButton
*
* @param w widget to add to ModeButton
* @return index of new item
*/
static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		FeedReaderModeButton* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->item);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static gboolean
_feed_reader_mode_button_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                  GdkEventScroll* event,
                                                                  gpointer self)
{
	gboolean result;
	result = feed_reader_mode_button_on_scroll_event ((FeedReaderModeButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda118_ (Block28Data* _data28_)
{
	FeedReaderModeButton* self;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	self = _data28_->self;
	_tmp0_ = feed_reader_mode_button_item_get_index (_data28_->item);
	_tmp1_ = _tmp0_;
	feed_reader_mode_button_set_active (self, _tmp1_, FALSE);
	result = TRUE;
	return result;
}

static gboolean
___lambda118__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda118_ (self);
	return result;
}

gint
feed_reader_mode_button_append (FeedReaderModeButton* self,
                                GtkWidget* w,
                                const gchar* tooltip)
{
	Block28Data* _data28_;
	gint index = 0;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	FeedReaderModeButtonItem* _tmp8_;
	FeedReaderModeButtonItem* _tmp9_;
	GeeHashMap* _tmp10_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (w != NULL, 0);
	g_return_val_if_fail (tooltip != NULL, 0);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	{
		GeeHashMap* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = self->priv->item_map;
		_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		index = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			GeeHashMap* _tmp5_;
			if (!_tmp3_) {
				gint _tmp4_;
				_tmp4_ = index;
				index = _tmp4_ + 1;
			}
			_tmp3_ = FALSE;
			_tmp5_ = self->priv->item_map;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) index))) {
				break;
			}
		}
	}
	_tmp6_ = self->priv->item_map;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (gpointer) ((gintptr) index));
	_tmp8_ = (FeedReaderModeButtonItem*) _tmp7_;
	_vala_assert (_tmp8_ == NULL, "item_map[index] == null");
	_g_object_unref0 (_tmp8_);
	gtk_widget_set_tooltip_text (w, tooltip);
	_tmp9_ = feed_reader_mode_button_item_new (index);
	g_object_ref_sink (_tmp9_);
	_data28_->item = _tmp9_;
	g_signal_connect_object ((GtkWidget*) _data28_->item, "scroll-event", (GCallback) _feed_reader_mode_button_on_scroll_event_gtk_widget_scroll_event, self, 0);
	gtk_container_add ((GtkContainer*) _data28_->item, w);
	g_signal_connect_data ((GtkWidget*) _data28_->item, "button-press-event", (GCallback) ___lambda118__gtk_widget_button_press_event, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	_tmp10_ = self->priv->item_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) index), _data28_->item);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _data28_->item);
	gtk_widget_show_all ((GtkWidget*) _data28_->item);
	g_signal_emit (self, feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_MODE_ADDED_SIGNAL], 0, index, w);
	result = index;
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return result;
}

/**
* Sets item of given index's activity
*
* @param new_active_index index of changed item
*/
static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		FeedReaderModeButton* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->new_item);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static gboolean
____lambda117_ (Block29Data* _data29_)
{
	FeedReaderModeButton* self;
	FeedReaderModeButtonItem* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean result;
	self = _data29_->self;
	_tmp0_ = _data29_->new_item;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	g_signal_emit (self, feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_MODE_CHANGED_SIGNAL], 0, _tmp1_);
	self->priv->m_timeout_source_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
_____lambda117__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda117_ (self);
	return result;
}

void
feed_reader_mode_button_set_active (FeedReaderModeButton* self,
                                    gint new_active_index,
                                    gboolean initSet)
{
	Block29Data* _data29_;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	FeedReaderModeButtonItem* _tmp3_;
	FeedReaderModeButtonItem* _tmp4_;
	FeedReaderModeButtonItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = self->priv->item_map;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) new_active_index)));
	_tmp1_ = self->priv->item_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) new_active_index));
	_tmp3_ = (FeedReaderModeButtonItem*) _tmp2_;
	_tmp4_ = FEED_READER_MODE_BUTTON_IS_ITEM (_tmp3_) ? ((FeedReaderModeButtonItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_data29_->new_item = _tmp4_;
	_tmp5_ = _data29_->new_item;
	if (_tmp5_ != NULL) {
		FeedReaderModeButtonItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		FeedReaderModeButtonItem* _tmp9_;
		FeedReaderModeButtonItem* old_item = NULL;
		GeeHashMap* _tmp10_;
		gpointer _tmp11_;
		FeedReaderModeButtonItem* _tmp12_;
		FeedReaderModeButtonItem* _tmp13_;
		FeedReaderModeButtonItem* _tmp14_;
		_tmp6_ = _data29_->new_item;
		_tmp7_ = feed_reader_mode_button_item_get_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ == new_active_index, "new_item.index == new_active_index");
		_tmp9_ = _data29_->new_item;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp9_, TRUE);
		if (self->priv->_selected == new_active_index) {
			block29_data_unref (_data29_);
			_data29_ = NULL;
			return;
		}
		_tmp10_ = self->priv->item_map;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) self->priv->_selected));
		_tmp12_ = (FeedReaderModeButtonItem*) _tmp11_;
		_tmp13_ = FEED_READER_MODE_BUTTON_IS_ITEM (_tmp12_) ? ((FeedReaderModeButtonItem*) _tmp12_) : NULL;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (_tmp12_);
		}
		old_item = _tmp13_;
		_tmp14_ = old_item;
		if (_tmp14_ != NULL) {
			FeedReaderModeButtonItem* _tmp15_;
			_tmp15_ = old_item;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp15_, FALSE);
		}
		self->priv->_selected = new_active_index;
		if (!initSet) {
			if (self->priv->m_timeout_source_id > ((guint) 0)) {
				g_source_remove (self->priv->m_timeout_source_id);
				self->priv->m_timeout_source_id = (guint) 0;
			}
			self->priv->m_timeout_source_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _____lambda117__gsource_func, block29_data_ref (_data29_), block29_data_unref);
		}
		_g_object_unref0 (old_item);
	}
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

/**
* Changes visibility of item of given index
*
* @param index index of item to be modified
* @param val value to change the visiblity to
*/
void
feed_reader_mode_button_set_item_visible (FeedReaderModeButton* self,
                                          gint index,
                                          gboolean val)
{
	GeeHashMap* _tmp0_;
	FeedReaderModeButtonItem* item = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	FeedReaderModeButtonItem* _tmp3_;
	FeedReaderModeButtonItem* _tmp4_;
	FeedReaderModeButtonItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->item_map;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) index)));
	_tmp1_ = self->priv->item_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) index));
	_tmp3_ = (FeedReaderModeButtonItem*) _tmp2_;
	_tmp4_ = FEED_READER_MODE_BUTTON_IS_ITEM (_tmp3_) ? ((FeedReaderModeButtonItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		FeedReaderModeButtonItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		FeedReaderModeButtonItem* _tmp9_;
		FeedReaderModeButtonItem* _tmp10_;
		_tmp6_ = item;
		_tmp7_ = feed_reader_mode_button_item_get_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ == index, "item.index == index");
		_tmp9_ = item;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, !val);
		_tmp10_ = item;
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, val);
	}
	_g_object_unref0 (item);
}

/**
* Removes item at given index
*
* @param index index of item to remove
*/
void
feed_reader_mode_button_remove (FeedReaderModeButton* self,
                                gint index)
{
	GeeHashMap* _tmp0_;
	FeedReaderModeButtonItem* item = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	FeedReaderModeButtonItem* _tmp3_;
	FeedReaderModeButtonItem* _tmp4_;
	FeedReaderModeButtonItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->item_map;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) index)));
	_tmp1_ = self->priv->item_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) index));
	_tmp3_ = (FeedReaderModeButtonItem*) _tmp2_;
	_tmp4_ = FEED_READER_MODE_BUTTON_IS_ITEM (_tmp3_) ? ((FeedReaderModeButtonItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		FeedReaderModeButtonItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GeeHashMap* _tmp9_;
		FeedReaderModeButtonItem* _tmp10_;
		GtkWidget* _tmp11_;
		FeedReaderModeButtonItem* _tmp12_;
		_tmp6_ = item;
		_tmp7_ = feed_reader_mode_button_item_get_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ == index, "item.index == index");
		_tmp9_ = self->priv->item_map;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) index), NULL);
		_tmp10_ = item;
		_tmp11_ = gtk_bin_get_child ((GtkBin*) _tmp10_);
		g_signal_emit (self, feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_MODE_REMOVED_SIGNAL], 0, index, _tmp11_);
		_tmp12_ = item;
		gtk_widget_destroy ((GtkWidget*) _tmp12_);
	}
	_g_object_unref0 (item);
}

/**
* Clears all children
*/
void
feed_reader_mode_button_clear_children (FeedReaderModeButton* self)
{
	GList* _tmp0_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkWidget* button = NULL;
			button = (GtkWidget*) button_it->data;
			{
				GtkWidget* _tmp1_;
				GtkWidget* _tmp2_;
				GtkContainer* _tmp3_;
				_tmp1_ = button;
				gtk_widget_hide (_tmp1_);
				_tmp2_ = button;
				_tmp3_ = gtk_widget_get_parent (_tmp2_);
				if (_tmp3_ != NULL) {
					GtkWidget* _tmp4_;
					_tmp4_ = button;
					GTK_CONTAINER_CLASS (feed_reader_mode_button_parent_class)->remove ((GtkContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), _tmp4_);
				}
			}
		}
		(button_collection == NULL) ? NULL : (button_collection = (g_list_free (button_collection), NULL));
	}
	_tmp5_ = self->priv->item_map;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp5_);
	self->priv->_selected = -1;
}

static gboolean
feed_reader_mode_button_on_scroll_event (FeedReaderModeButton* self,
                                         GtkWidget* widget,
                                         GdkEventScroll* ev)
{
	gint offset = 0;
	GList* children = NULL;
	GList* _tmp0_;
	guint n_children = 0U;
	GList* _tmp1_;
	FeedReaderModeButtonItem* selected_item = NULL;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	FeedReaderModeButtonItem* _tmp6_;
	gint new_item = 0;
	GList* _tmp7_;
	FeedReaderModeButtonItem* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	switch (ev->direction) {
		case GDK_SCROLL_DOWN:
		case GDK_SCROLL_RIGHT:
		{
			offset = 1;
			break;
		}
		case GDK_SCROLL_UP:
		case GDK_SCROLL_LEFT:
		{
			offset = -1;
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	n_children = g_list_length (_tmp1_);
	_tmp2_ = self->priv->item_map;
	_tmp3_ = feed_reader_mode_button_get_selected (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) _tmp4_));
	selected_item = (FeedReaderModeButtonItem*) _tmp5_;
	_tmp6_ = selected_item;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (selected_item);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	_tmp7_ = children;
	_tmp8_ = selected_item;
	new_item = g_list_index (_tmp7_, (GtkWidget*) _tmp8_);
	if (new_item < 0) {
		result = FALSE;
		_g_object_unref0 (selected_item);
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			FeedReaderModeButtonItem* item = NULL;
			GList* _tmp11_;
			gconstpointer _tmp12_;
			GtkWidget* _tmp13_;
			FeedReaderModeButtonItem* _tmp14_;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			FeedReaderModeButtonItem* _tmp17_;
			if (!_tmp9_) {
				gboolean _tmp10_ = FALSE;
				if (new_item >= 0) {
					_tmp10_ = ((guint) new_item) < n_children;
				} else {
					_tmp10_ = FALSE;
				}
				if (!_tmp10_) {
					break;
				}
			}
			_tmp9_ = FALSE;
			new_item += offset;
			_tmp11_ = children;
			_tmp12_ = g_list_nth_data (_tmp11_, (guint) new_item);
			_tmp13_ = (GtkWidget*) _tmp12_;
			_tmp14_ = _g_object_ref0 (FEED_READER_MODE_BUTTON_IS_ITEM (_tmp13_) ? ((FeedReaderModeButtonItem*) _tmp13_) : NULL);
			item = _tmp14_;
			_tmp17_ = item;
			if (_tmp17_ != NULL) {
				FeedReaderModeButtonItem* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp18_ = item;
				_tmp19_ = gtk_widget_get_visible ((GtkWidget*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp16_ = _tmp20_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				FeedReaderModeButtonItem* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = item;
				_tmp22_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp15_ = _tmp23_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				FeedReaderModeButtonItem* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				_tmp24_ = item;
				_tmp25_ = feed_reader_mode_button_item_get_index (_tmp24_);
				_tmp26_ = _tmp25_;
				feed_reader_mode_button_set_selected (self, _tmp26_);
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (item);
		}
	}
	result = FALSE;
	_g_object_unref0 (selected_item);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

gint
feed_reader_mode_button_get_selected (FeedReaderModeButton* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_selected;
	return result;
}

void
feed_reader_mode_button_set_selected (FeedReaderModeButton* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	feed_reader_mode_button_set_active (self, value, FALSE);
	g_object_notify_by_pspec ((GObject *) self, feed_reader_mode_button_properties[FEED_READER_MODE_BUTTON_SELECTED_PROPERTY]);
}

guint
feed_reader_mode_button_get_n_items (FeedReaderModeButton* self)
{
	guint result;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->item_map;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__INT_OBJECT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_OBJECT) (gpointer data1, gint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static inline gpointer
feed_reader_mode_button_item_get_instance_private (FeedReaderModeButtonItem* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderModeButtonItem_private_offset);
}

static FeedReaderModeButtonItem*
feed_reader_mode_button_item_construct (GType object_type,
                                        gint index)
{
	FeedReaderModeButtonItem * self = NULL;
	self = (FeedReaderModeButtonItem*) g_object_new (object_type, "index", index, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	return self;
}

static FeedReaderModeButtonItem*
feed_reader_mode_button_item_new (gint index)
{
	return feed_reader_mode_button_item_construct (FEED_READER_MODE_BUTTON_TYPE_ITEM, index);
}

static gint
feed_reader_mode_button_item_get_index (FeedReaderModeButtonItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}

static void
feed_reader_mode_button_item_set_index (FeedReaderModeButtonItem* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = feed_reader_mode_button_item_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, feed_reader_mode_button_item_properties[FEED_READER_MODE_BUTTON_ITEM_INDEX_PROPERTY]);
	}
}

static void
feed_reader_mode_button_item_class_init (FeedReaderModeButtonItemClass * klass,
                                         gpointer klass_data)
{
	feed_reader_mode_button_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderModeButtonItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_feed_reader_mode_button_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_feed_reader_mode_button_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_mode_button_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FEED_READER_MODE_BUTTON_ITEM_INDEX_PROPERTY, feed_reader_mode_button_item_properties[FEED_READER_MODE_BUTTON_ITEM_INDEX_PROPERTY] = g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
feed_reader_mode_button_item_instance_init (FeedReaderModeButtonItem * self,
                                            gpointer klass)
{
	self->priv = feed_reader_mode_button_item_get_instance_private (self);
}

static void
feed_reader_mode_button_item_finalize (GObject * obj)
{
	FeedReaderModeButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_MODE_BUTTON_TYPE_ITEM, FeedReaderModeButtonItem);
	G_OBJECT_CLASS (feed_reader_mode_button_item_parent_class)->finalize (obj);
}

static GType
feed_reader_mode_button_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderModeButtonItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_mode_button_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderModeButtonItem), 0, (GInstanceInitFunc) feed_reader_mode_button_item_instance_init, NULL };
	GType feed_reader_mode_button_item_type_id;
	feed_reader_mode_button_item_type_id = g_type_register_static (gtk_toggle_button_get_type (), "FeedReaderModeButtonItem", &g_define_type_info, 0);
	FeedReaderModeButtonItem_private_offset = g_type_add_instance_private (feed_reader_mode_button_item_type_id, sizeof (FeedReaderModeButtonItemPrivate));
	return feed_reader_mode_button_item_type_id;
}

static GType
feed_reader_mode_button_item_get_type (void)
{
	static volatile gsize feed_reader_mode_button_item_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_mode_button_item_type_id__once)) {
		GType feed_reader_mode_button_item_type_id;
		feed_reader_mode_button_item_type_id = feed_reader_mode_button_item_get_type_once ();
		g_once_init_leave (&feed_reader_mode_button_item_type_id__once, feed_reader_mode_button_item_type_id);
	}
	return feed_reader_mode_button_item_type_id__once;
}

static void
_vala_feed_reader_mode_button_item_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FeedReaderModeButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FEED_READER_MODE_BUTTON_TYPE_ITEM, FeedReaderModeButtonItem);
	switch (property_id) {
		case FEED_READER_MODE_BUTTON_ITEM_INDEX_PROPERTY:
		g_value_set_int (value, feed_reader_mode_button_item_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_feed_reader_mode_button_item_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FeedReaderModeButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FEED_READER_MODE_BUTTON_TYPE_ITEM, FeedReaderModeButtonItem);
	switch (property_id) {
		case FEED_READER_MODE_BUTTON_ITEM_INDEX_PROPERTY:
		feed_reader_mode_button_item_set_index (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
feed_reader_mode_button_class_init (FeedReaderModeButtonClass * klass,
                                    gpointer klass_data)
{
	feed_reader_mode_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderModeButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_feed_reader_mode_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_feed_reader_mode_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_mode_button_finalize;
	/**
	* Index of currently selected item.
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), FEED_READER_MODE_BUTTON_SELECTED_PROPERTY, feed_reader_mode_button_properties[FEED_READER_MODE_BUTTON_SELECTED_PROPERTY] = g_param_spec_int ("selected", "selected", "selected", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Read-only length of current ModeButton
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), FEED_READER_MODE_BUTTON_N_ITEMS_PROPERTY, feed_reader_mode_button_properties[FEED_READER_MODE_BUTTON_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_MODE_ADDED_SIGNAL] = g_signal_new ("mode-added", FEED_READER_TYPE_MODE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_OBJECT, G_TYPE_NONE, 2, G_TYPE_INT, gtk_widget_get_type ());
	feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_MODE_REMOVED_SIGNAL] = g_signal_new ("mode-removed", FEED_READER_TYPE_MODE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_OBJECT, G_TYPE_NONE, 2, G_TYPE_INT, gtk_widget_get_type ());
	feed_reader_mode_button_signals[FEED_READER_MODE_BUTTON_MODE_CHANGED_SIGNAL] = g_signal_new ("mode-changed", FEED_READER_TYPE_MODE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gtk_widget_get_type ());
}

static void
feed_reader_mode_button_instance_init (FeedReaderModeButton * self,
                                       gpointer klass)
{
	self->priv = feed_reader_mode_button_get_instance_private (self);
	self->priv->_selected = -1;
	self->priv->m_timeout_source_id = (guint) 0;
}

static void
feed_reader_mode_button_finalize (GObject * obj)
{
	FeedReaderModeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_MODE_BUTTON, FeedReaderModeButton);
	_g_object_unref0 (self->priv->item_map);
	G_OBJECT_CLASS (feed_reader_mode_button_parent_class)->finalize (obj);
}

/**
* This widget is a multiple option modal switch
*
* {{../../doc/images/ModeButton.png}}
*/
static GType
feed_reader_mode_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderModeButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_mode_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderModeButton), 0, (GInstanceInitFunc) feed_reader_mode_button_instance_init, NULL };
	GType feed_reader_mode_button_type_id;
	feed_reader_mode_button_type_id = g_type_register_static (gtk_box_get_type (), "FeedReaderModeButton", &g_define_type_info, 0);
	FeedReaderModeButton_private_offset = g_type_add_instance_private (feed_reader_mode_button_type_id, sizeof (FeedReaderModeButtonPrivate));
	return feed_reader_mode_button_type_id;
}

GType
feed_reader_mode_button_get_type (void)
{
	static volatile gsize feed_reader_mode_button_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_mode_button_type_id__once)) {
		GType feed_reader_mode_button_type_id;
		feed_reader_mode_button_type_id = feed_reader_mode_button_get_type_once ();
		g_once_init_leave (&feed_reader_mode_button_type_id__once, feed_reader_mode_button_type_id);
	}
	return feed_reader_mode_button_type_id__once;
}

static void
_vala_feed_reader_mode_button_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	FeedReaderModeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FEED_READER_TYPE_MODE_BUTTON, FeedReaderModeButton);
	switch (property_id) {
		case FEED_READER_MODE_BUTTON_SELECTED_PROPERTY:
		g_value_set_int (value, feed_reader_mode_button_get_selected (self));
		break;
		case FEED_READER_MODE_BUTTON_N_ITEMS_PROPERTY:
		g_value_set_uint (value, feed_reader_mode_button_get_n_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_feed_reader_mode_button_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	FeedReaderModeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FEED_READER_TYPE_MODE_BUTTON, FeedReaderModeButton);
	switch (property_id) {
		case FEED_READER_MODE_BUTTON_SELECTED_PROPERTY:
		feed_reader_mode_button_set_selected (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

