/* TagRow.c generated by valac 0.56.3, the Vala compiler
 * generated from TagRow.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "FeedReader.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "libgd/gd.h"

enum  {
	FEED_READER_TAG_ROW_0_PROPERTY,
	FEED_READER_TAG_ROW_NUM_PROPERTIES
};
static GParamSpec* feed_reader_tag_row_properties[FEED_READER_TAG_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block43Data Block43Data;
typedef struct _Block44Data Block44Data;
enum  {
	FEED_READER_TAG_ROW_MOVE_UP_SIGNAL,
	FEED_READER_TAG_ROW_REMOVE_ROW_SIGNAL,
	FEED_READER_TAG_ROW_NUM_SIGNALS
};
static guint feed_reader_tag_row_signals[FEED_READER_TAG_ROW_NUM_SIGNALS] = {0};

struct _FeedReaderTagRowPrivate {
	GtkBox* m_box;
	GtkLabel* m_label;
	gboolean m_exits;
	gchar* m_catID;
	FeedReaderColorCircle* m_circle;
	FeedReaderColorPopover* m_pop;
	GtkRevealer* m_revealer;
	GtkEventBox* m_eventBox;
};

struct _Block43Data {
	int _ref_count_;
	FeedReaderTagRow* self;
	guint time;
	FeedReaderInAppNotification* notification;
	gulong eventID;
};

struct _Block44Data {
	int _ref_count_;
	FeedReaderTagRow* self;
	GtkPopover* popRename;
	GtkEntry* renameEntry;
	GdkDragContext* context;
	guint time;
	FeedReaderArticle* article;
};

static gint FeedReaderTagRow_private_offset;
static gpointer feed_reader_tag_row_parent_class = NULL;

static void __lambda134_ (FeedReaderTagRow* self,
                   gint color);
static void ___lambda134__feed_reader_color_circle_clicked (FeedReaderColorCircle* _sender,
                                                     gint color,
                                                     gpointer self);
static void __lambda135_ (FeedReaderTagRow* self,
                   gint color);
static void ___lambda135__feed_reader_color_popover_new_color_selected (FeedReaderColorPopover* _sender,
                                                                 gint color,
                                                                 gpointer self);
static gboolean feed_reader_tag_row_onClick (FeedReaderTagRow* self,
                                      GdkEventButton* event);
static gboolean _feed_reader_tag_row_onClick_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self);
static gboolean feed_reader_tag_row_onDragMotion (FeedReaderTagRow* self,
                                           GtkWidget* widget,
                                           GdkDragContext* context,
                                           gint x,
                                           gint y,
                                           guint time);
static gboolean _feed_reader_tag_row_onDragMotion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   gint x,
                                                                   gint y,
                                                                   guint time_,
                                                                   gpointer self);
static void feed_reader_tag_row_onDragLeave (FeedReaderTagRow* self,
                                      GtkWidget* widget,
                                      GdkDragContext* context,
                                      guint time);
static void _feed_reader_tag_row_onDragLeave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             guint time_,
                                                             gpointer self);
static gboolean feed_reader_tag_row_onDragDrop (FeedReaderTagRow* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context,
                                         gint x,
                                         gint y,
                                         guint time);
static gboolean _feed_reader_tag_row_onDragDrop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               gint x,
                                                               gint y,
                                                               guint time_,
                                                               gpointer self);
static void feed_reader_tag_row_onDragDataReceived (FeedReaderTagRow* self,
                                             GtkWidget* widget,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             GtkSelectionData* selection_data,
                                             guint target_type,
                                             guint time);
static void _feed_reader_tag_row_onDragDataReceived_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                            GdkDragContext* context,
                                                                            gint x,
                                                                            gint y,
                                                                            GtkSelectionData* selection_data,
                                                                            guint info,
                                                                            guint time_,
                                                                            gpointer self);
static void feed_reader_tag_row_showRenamePopover (FeedReaderTagRow* self,
                                            GdkDragContext* context,
                                            guint time,
                                            FeedReaderArticle* article);
static void __lambda136_ (FeedReaderTagRow* self);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void __lambda137_ (FeedReaderTagRow* self);
static void ___lambda137__gd_notification_dismissed (GdNotification* _sender,
                                              gpointer self);
static void __lambda138_ (Block43Data* _data43_);
static void ___lambda138__feed_reader_in_app_notification_action (FeedReaderInAppNotification* _sender,
                                                           gpointer self);
static void ___lambda136__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void __lambda139_ (FeedReaderTagRow* self);
static void ___lambda139__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void __lambda143_ (FeedReaderTagRow* self);
static void ___lambda143__gtk_popover_closed (GtkPopover* _sender,
                                       gpointer self);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static void __lambda140_ (Block44Data* _data44_);
static void ___lambda140__gtk_popover_closed (GtkPopover* _sender,
                                       gpointer self);
static void __lambda141_ (Block44Data* _data44_);
static void ___lambda141__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static void __lambda142_ (Block44Data* _data44_);
static void ___lambda142__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void feed_reader_tag_row_finalize (GObject * obj);
static GType feed_reader_tag_row_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_tag_row_get_instance_private (FeedReaderTagRow* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderTagRow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda134_ (FeedReaderTagRow* self,
              gint color)
{
	FeedReaderColorPopover* _tmp0_;
	_tmp0_ = self->priv->m_pop;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}

static void
___lambda134__feed_reader_color_circle_clicked (FeedReaderColorCircle* _sender,
                                                gint color,
                                                gpointer self)
{
	__lambda134_ ((FeedReaderTagRow*) self, color);
}

static void
__lambda135_ (FeedReaderTagRow* self,
              gint color)
{
	FeedReaderColorCircle* _tmp0_;
	FeedReaderTag* _tmp1_;
	FeedReaderFeedReaderBackend* _tmp2_;
	FeedReaderFeedReaderBackend* _tmp3_;
	FeedReaderTag* _tmp4_;
	_tmp0_ = self->priv->m_circle;
	feed_reader_color_circle_newColor (_tmp0_, color);
	_tmp1_ = self->m_tag;
	feed_reader_tag_setColor (_tmp1_, color);
	_tmp2_ = feed_reader_feed_reader_backend_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = self->m_tag;
	feed_reader_feed_reader_backend_updateTagColor (_tmp3_, _tmp4_);
	_g_object_unref0 (_tmp3_);
}

static void
___lambda135__feed_reader_color_popover_new_color_selected (FeedReaderColorPopover* _sender,
                                                            gint color,
                                                            gpointer self)
{
	__lambda135_ ((FeedReaderTagRow*) self, color);
}

static gboolean
_feed_reader_tag_row_onClick_gtk_widget_button_press_event (GtkWidget* _sender,
                                                            GdkEventButton* event,
                                                            gpointer self)
{
	gboolean result;
	result = feed_reader_tag_row_onClick ((FeedReaderTagRow*) self, event);
	return result;
}

static gboolean
_feed_reader_tag_row_onDragMotion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                          GdkDragContext* context,
                                                          gint x,
                                                          gint y,
                                                          guint time_,
                                                          gpointer self)
{
	gboolean result;
	result = feed_reader_tag_row_onDragMotion ((FeedReaderTagRow*) self, _sender, context, x, y, time_);
	return result;
}

static void
_feed_reader_tag_row_onDragLeave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                        GdkDragContext* context,
                                                        guint time_,
                                                        gpointer self)
{
	feed_reader_tag_row_onDragLeave ((FeedReaderTagRow*) self, _sender, context, time_);
}

static gboolean
_feed_reader_tag_row_onDragDrop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                      GdkDragContext* context,
                                                      gint x,
                                                      gint y,
                                                      guint time_,
                                                      gpointer self)
{
	gboolean result;
	result = feed_reader_tag_row_onDragDrop ((FeedReaderTagRow*) self, _sender, context, x, y, time_);
	return result;
}

static void
_feed_reader_tag_row_onDragDataReceived_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                       GdkDragContext* context,
                                                                       gint x,
                                                                       gint y,
                                                                       GtkSelectionData* selection_data,
                                                                       guint info,
                                                                       guint time_,
                                                                       gpointer self)
{
	feed_reader_tag_row_onDragDataReceived ((FeedReaderTagRow*) self, _sender, context, x, y, selection_data, info, time_);
}

FeedReaderTagRow*
feed_reader_tag_row_construct (GType object_type,
                               FeedReaderTag* tag)
{
	FeedReaderTagRow * self = NULL;
	FeedReaderTag* _tmp0_;
	GtkStyleContext* _tmp1_;
	FeedReaderTag* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint rowhight = 0;
	GtkBox* _tmp7_;
	FeedReaderTag* _tmp8_;
	FeedReaderColorCircle* _tmp9_;
	FeedReaderColorCircle* _tmp10_;
	FeedReaderColorCircle* _tmp11_;
	FeedReaderColorPopover* _tmp12_;
	FeedReaderColorCircle* _tmp13_;
	FeedReaderColorPopover* _tmp14_;
	const gchar* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkBox* _tmp21_;
	FeedReaderColorCircle* _tmp22_;
	GtkBox* _tmp23_;
	GtkLabel* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkRevealer* _tmp26_;
	GtkRevealer* _tmp27_;
	GtkBox* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkEventBox* _tmp30_;
	GtkEventBox* _tmp31_;
	GtkEventBox* _tmp32_;
	GtkEventBox* _tmp33_;
	GtkRevealer* _tmp34_;
	GtkEventBox* _tmp35_;
	g_return_val_if_fail (tag != NULL, NULL);
	self = (FeedReaderTagRow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (tag);
	_g_object_unref0 (self->m_tag);
	self->m_tag = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "fr-sidebar-row");
	self->priv->m_exits = TRUE;
	_tmp2_ = self->m_tag;
	_tmp3_ = feed_reader_tag_getTitle (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "&", "&amp;");
	_g_free0 (self->m_name);
	self->m_name = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_TAGS);
	_g_free0 (self->priv->m_catID);
	self->priv->m_catID = _tmp6_;
	rowhight = 30;
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->m_box);
	self->priv->m_box = _tmp7_;
	_tmp8_ = self->m_tag;
	_tmp9_ = feed_reader_color_circle_new (feed_reader_tag_getColor (_tmp8_), TRUE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->m_circle);
	self->priv->m_circle = _tmp9_;
	_tmp10_ = self->priv->m_circle;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp10_, 24);
	_tmp11_ = self->priv->m_circle;
	_tmp12_ = feed_reader_color_popover_new ((GtkWidget*) _tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->m_pop);
	self->priv->m_pop = _tmp12_;
	_tmp13_ = self->priv->m_circle;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda134__feed_reader_color_circle_clicked, self, 0);
	_tmp14_ = self->priv->m_pop;
	g_signal_connect_object (_tmp14_, "new-color-selected", (GCallback) ___lambda135__feed_reader_color_popover_new_color_selected, self, 0);
	_tmp15_ = self->m_name;
	_tmp16_ = (GtkLabel*) gtk_label_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_label = _tmp16_;
	_tmp17_ = self->priv->m_label;
	gtk_label_set_use_markup (_tmp17_, TRUE);
	_tmp18_ = self->priv->m_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp18_, 0, rowhight);
	_tmp19_ = self->priv->m_label;
	gtk_label_set_ellipsize (_tmp19_, PANGO_ELLIPSIZE_END);
	_tmp20_ = self->priv->m_label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp20_, (gfloat) 0, 0.5f);
	_tmp21_ = self->priv->m_box;
	_tmp22_ = self->priv->m_circle;
	gtk_box_pack_start (_tmp21_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 8);
	_tmp23_ = self->priv->m_box;
	_tmp24_ = self->priv->m_label;
	gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
	_tmp25_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->m_revealer);
	self->priv->m_revealer = _tmp25_;
	_tmp26_ = self->priv->m_revealer;
	gtk_revealer_set_transition_type (_tmp26_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp27_ = self->priv->m_revealer;
	_tmp28_ = self->priv->m_box;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp29_, FALSE);
	_tmp30_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->m_eventBox);
	self->priv->m_eventBox = _tmp30_;
	_tmp31_ = self->priv->m_eventBox;
	gtk_widget_set_events ((GtkWidget*) _tmp31_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp32_ = self->priv->m_eventBox;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "button-press-event", (GCallback) _feed_reader_tag_row_onClick_gtk_widget_button_press_event, self, 0);
	_tmp33_ = self->priv->m_eventBox;
	_tmp34_ = self->priv->m_revealer;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->m_eventBox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp35_);
	gtk_widget_show_all ((GtkWidget*) self);
	if (feed_reader_utils_canManipulateContent (NULL)) {
		static const GtkTargetEntry accepted_targets[1] = {{"STRING", (guint) 0, (guint) FEED_READER_DRAG_TARGET_TAG}};
		gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_MOTION, accepted_targets, (gint) G_N_ELEMENTS (accepted_targets), GDK_ACTION_COPY);
		g_signal_connect_object ((GtkWidget*) self, "drag-motion", (GCallback) _feed_reader_tag_row_onDragMotion_gtk_widget_drag_motion, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-leave", (GCallback) _feed_reader_tag_row_onDragLeave_gtk_widget_drag_leave, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-drop", (GCallback) _feed_reader_tag_row_onDragDrop_gtk_widget_drag_drop, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _feed_reader_tag_row_onDragDataReceived_gtk_widget_drag_data_received, self, 0);
	}
	return self;
}

FeedReaderTagRow*
feed_reader_tag_row_new (FeedReaderTag* tag)
{
	return feed_reader_tag_row_construct (FEED_READER_TYPE_TAG_ROW, tag);
}

static gboolean
feed_reader_tag_row_onDragMotion (FeedReaderTagRow* self,
                                  GtkWidget* widget,
                                  GdkDragContext* context,
                                  gint x,
                                  gint y,
                                  guint time)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_PRELIGHT, FALSE);
	result = FALSE;
	return result;
}

static void
feed_reader_tag_row_onDragLeave (FeedReaderTagRow* self,
                                 GtkWidget* widget,
                                 GdkDragContext* context,
                                 guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_PRELIGHT);
}

static gboolean
feed_reader_tag_row_onDragDrop (FeedReaderTagRow* self,
                                GtkWidget* widget,
                                GdkDragContext* context,
                                gint x,
                                gint y,
                                guint time)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = gdk_drag_context_list_targets (context);
	if (_tmp0_ != NULL) {
		GdkAtom target_type = (GdkAtom) 0U;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = gdk_drag_context_list_targets (context);
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
		target_type = (GdkAtom) ((GdkAtom) ((guintptr) _tmp2_));
		gtk_drag_get_data (widget, context, target_type, (guint32) time);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
feed_reader_tag_row_onDragDataReceived (FeedReaderTagRow* self,
                                        GtkWidget* widget,
                                        GdkDragContext* context,
                                        gint x,
                                        gint y,
                                        GtkSelectionData* selection_data,
                                        guint target_type,
                                        guint time)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	if (selection_data != NULL) {
		_tmp1_ = gtk_selection_data_get_length (selection_data) >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = target_type == ((guint) FEED_READER_DRAG_TARGET_TAG);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* articleID = NULL;
		guint8* _tmp2_;
		gchar* _tmp3_;
		FeedReaderArticle* article = NULL;
		FeedReaderDataBaseReadOnly* _tmp4_;
		FeedReaderDataBaseReadOnly* _tmp5_;
		const gchar* _tmp6_;
		FeedReaderArticle* _tmp7_;
		FeedReaderArticle* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		FeedReaderTag* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gboolean _tmp16_;
		_tmp2_ = gtk_selection_data_get_data (selection_data);
		_tmp3_ = g_strdup ((const gchar*) _tmp2_);
		articleID = _tmp3_;
		_tmp4_ = feed_reader_data_base_readOnly ();
		_tmp5_ = _tmp4_;
		_tmp6_ = articleID;
		_tmp7_ = feed_reader_data_base_read_only_read_article (_tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
		article = _tmp8_;
		_tmp9_ = articleID;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("drag articleID: ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		feed_reader_logger_debug (_tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = self->m_tag;
		_tmp14_ = feed_reader_tag_getTagID (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strcmp0 (_tmp15_, FEED_READER_TAG_ID_NEW) != 0;
		_g_free0 (_tmp15_);
		if (_tmp16_) {
			FeedReaderFeedReaderBackend* _tmp17_;
			FeedReaderFeedReaderBackend* _tmp18_;
			FeedReaderArticle* _tmp19_;
			FeedReaderTag* _tmp20_;
			_tmp17_ = feed_reader_feed_reader_backend_get_default ();
			_tmp18_ = _tmp17_;
			_tmp19_ = article;
			_tmp20_ = self->m_tag;
			feed_reader_feed_reader_backend_tagArticle (_tmp18_, _tmp19_, _tmp20_, TRUE);
			_g_object_unref0 (_tmp18_);
			gtk_drag_finish (context, TRUE, FALSE, (guint32) time);
		} else {
			FeedReaderArticle* _tmp21_;
			_tmp21_ = article;
			feed_reader_tag_row_showRenamePopover (self, context, time, _tmp21_);
		}
		_g_object_unref0 (article);
		_g_free0 (articleID);
	}
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		FeedReaderTagRow* self;
		self = _data43_->self;
		_g_object_unref0 (_data43_->notification);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static void
__lambda137_ (FeedReaderTagRow* self)
{
	FeedReaderFeedReaderBackend* _tmp0_;
	FeedReaderFeedReaderBackend* _tmp1_;
	FeedReaderTag* _tmp2_;
	feed_reader_logger_debug ("TagRow: delete Tag");
	_tmp0_ = feed_reader_feed_reader_backend_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->m_tag;
	feed_reader_feed_reader_backend_deleteTag (_tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda137__gd_notification_dismissed (GdNotification* _sender,
                                         gpointer self)
{
	__lambda137_ ((FeedReaderTagRow*) self);
}

static void
__lambda138_ (Block43Data* _data43_)
{
	FeedReaderTagRow* self;
	self = _data43_->self;
	g_signal_handler_disconnect ((GObject*) _data43_->notification, _data43_->eventID);
	feed_reader_tag_row_reveal (self, TRUE, _data43_->time);
	gd_notification_dismiss ((GdNotification*) _data43_->notification);
}

static void
___lambda138__feed_reader_in_app_notification_action (FeedReaderInAppNotification* _sender,
                                                      gpointer self)
{
	__lambda138_ (self);
}

static void
__lambda136_ (FeedReaderTagRow* self)
{
	Block43Data* _data43_;
	gchar* text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FeedReaderMainWindow* _tmp2_;
	FeedReaderMainWindow* _tmp3_;
	FeedReaderInAppNotification* _tmp4_;
	FeedReaderInAppNotification* _tmp5_;
	gulong _tmp6_;
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	if (gtk_list_box_row_is_selected ((GtkListBoxRow*) self)) {
		g_signal_emit (self, feed_reader_tag_row_signals[FEED_READER_TAG_ROW_MOVE_UP_SIGNAL], 0);
	}
	_data43_->time = (guint) 300;
	feed_reader_tag_row_reveal (self, FALSE, _data43_->time);
	_tmp0_ = self->m_name;
	_tmp1_ = g_strdup_printf (_ ("Tag \"%s\" removed"), _tmp0_);
	text = _tmp1_;
	_tmp2_ = feed_reader_main_window_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = feed_reader_main_window_showNotification (_tmp3_, text, "undo");
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_data43_->notification = _tmp5_;
	_tmp6_ = g_signal_connect_object ((GdNotification*) _data43_->notification, "dismissed", (GCallback) ___lambda137__gd_notification_dismissed, self, 0);
	_data43_->eventID = _tmp6_;
	g_signal_connect_data (_data43_->notification, "action", (GCallback) ___lambda138__feed_reader_in_app_notification_action, block43_data_ref (_data43_), (GClosureNotify) block43_data_unref, 0);
	_g_free0 (text);
	block43_data_unref (_data43_);
	_data43_ = NULL;
}

static void
___lambda136__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda136_ ((FeedReaderTagRow*) self);
}

static void
__lambda139_ (FeedReaderTagRow* self)
{
	feed_reader_tag_row_showRenamePopover (self, NULL, (guint) 0, NULL);
}

static void
___lambda139__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda139_ ((FeedReaderTagRow*) self);
}

static void
__lambda143_ (FeedReaderTagRow* self)
{
	gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_PRELIGHT);
}

static void
___lambda143__gtk_popover_closed (GtkPopover* _sender,
                                  gpointer self)
{
	__lambda143_ ((FeedReaderTagRow*) self);
}

static gboolean
feed_reader_tag_row_onClick (FeedReaderTagRow* self,
                             GdkEventButton* event)
{
	GSimpleAction* remove_action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* rename_action = NULL;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	FeedReaderFeedReaderApp* app = NULL;
	FeedReaderFeedReaderApp* _tmp4_;
	FeedReaderFeedReaderApp* _tmp5_;
	GSimpleAction* _tmp6_;
	FeedReaderFeedReaderApp* _tmp7_;
	GSimpleAction* _tmp8_;
	GMenu* menu = NULL;
	GMenu* _tmp9_;
	GMenu* _tmp10_;
	GMenu* _tmp11_;
	GtkPopover* pop = NULL;
	GtkPopover* _tmp12_;
	GtkPopover* _tmp13_;
	GtkPopover* _tmp14_;
	GMenu* _tmp15_;
	GtkPopover* _tmp16_;
	GtkPopover* _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 3)) {
		result = FALSE;
		return result;
	}
	if (!feed_reader_utils_canManipulateContent (NULL)) {
		result = FALSE;
		return result;
	}
	switch (event->type) {
		case GDK_BUTTON_RELEASE:
		case GDK_2BUTTON_PRESS:
		case GDK_3BUTTON_PRESS:
		{
			result = FALSE;
			return result;
		}
		default:
		break;
	}
	_tmp0_ = g_simple_action_new ("deleteTag", NULL);
	remove_action = _tmp0_;
	_tmp1_ = remove_action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda136__g_simple_action_activate, self, 0);
	_tmp2_ = g_simple_action_new ("renameTag", NULL);
	rename_action = _tmp2_;
	_tmp3_ = rename_action;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) ___lambda139__g_simple_action_activate, self, 0);
	_tmp4_ = feed_reader_feed_reader_app_get_default ();
	app = _tmp4_;
	_tmp5_ = app;
	_tmp6_ = rename_action;
	g_action_map_add_action ((GActionMap*) _tmp5_, (GAction*) _tmp6_);
	_tmp7_ = app;
	_tmp8_ = remove_action;
	g_action_map_add_action ((GActionMap*) _tmp7_, (GAction*) _tmp8_);
	_tmp9_ = g_menu_new ();
	menu = _tmp9_;
	_tmp10_ = menu;
	g_menu_append (_tmp10_, _ ("Rename"), "renameTag");
	_tmp11_ = menu;
	g_menu_append (_tmp11_, _ ("Remove"), "deleteTag");
	_tmp12_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp12_);
	pop = _tmp12_;
	_tmp13_ = pop;
	gtk_popover_set_position (_tmp13_, GTK_POS_BOTTOM);
	_tmp14_ = pop;
	_tmp15_ = menu;
	gtk_popover_bind_model (_tmp14_, (GMenuModel*) _tmp15_, "app");
	_tmp16_ = pop;
	g_signal_connect_object (_tmp16_, "closed", (GCallback) ___lambda143__gtk_popover_closed, self, 0);
	_tmp17_ = pop;
	gtk_widget_show ((GtkWidget*) _tmp17_);
	gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_PRELIGHT, FALSE);
	result = TRUE;
	_g_object_unref0 (pop);
	_g_object_unref0 (menu);
	_g_object_unref0 (app);
	_g_object_unref0 (rename_action);
	_g_object_unref0 (remove_action);
	return result;
}

void
feed_reader_tag_row_update (FeedReaderTagRow* self,
                            const gchar* name)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->m_label;
	_tmp1_ = string_replace (name, "&", "&amp;");
	_tmp2_ = _tmp1_;
	gtk_label_set_text (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->m_label;
	gtk_label_set_use_markup (_tmp3_, TRUE);
}

FeedReaderTag*
feed_reader_tag_row_getTag (FeedReaderTagRow* self)
{
	FeedReaderTag* _tmp0_;
	FeedReaderTag* _tmp1_;
	FeedReaderTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->m_tag;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
feed_reader_tag_row_setExits (FeedReaderTagRow* self,
                              gboolean subscribed)
{
	g_return_if_fail (self != NULL);
	self->priv->m_exits = subscribed;
}

gboolean
feed_reader_tag_row_stillExits (FeedReaderTagRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->m_exits;
	return result;
}

gboolean
feed_reader_tag_row_isRevealed (FeedReaderTagRow* self)
{
	GtkRevealer* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_revealer;
	result = gtk_revealer_get_reveal_child (_tmp0_);
	return result;
}

void
feed_reader_tag_row_reveal (FeedReaderTagRow* self,
                            gboolean reveal,
                            guint duration)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_revealer;
	gtk_revealer_set_transition_duration (_tmp0_, duration);
	_tmp1_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, reveal);
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		FeedReaderTagRow* self;
		self = _data44_->self;
		_g_object_unref0 (_data44_->renameEntry);
		_g_object_unref0 (_data44_->popRename);
		_g_object_unref0 (_data44_->context);
		_g_object_unref0 (_data44_->article);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static void
__lambda140_ (Block44Data* _data44_)
{
	FeedReaderTagRow* self;
	gboolean _tmp0_ = FALSE;
	FeedReaderTag* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	self = _data44_->self;
	gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_PRELIGHT);
	_tmp1_ = self->m_tag;
	_tmp2_ = feed_reader_tag_getTagID (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, FEED_READER_TAG_ID_NEW) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = _data44_->context != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		feed_reader_logger_debug ("TagRow: cancel drag");
		gtk_drag_finish (_data44_->context, FALSE, FALSE, (guint32) _data44_->time);
	}
}

static void
___lambda140__gtk_popover_closed (GtkPopover* _sender,
                                  gpointer self)
{
	__lambda140_ (self);
}

static void
__lambda141_ (Block44Data* _data44_)
{
	FeedReaderTagRow* self;
	FeedReaderTag* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	self = _data44_->self;
	_tmp0_ = self->m_tag;
	_tmp1_ = feed_reader_tag_getTagID (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, FEED_READER_TAG_ID_NEW) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GtkPopover* _tmp4_;
		FeedReaderFeedReaderBackend* _tmp5_;
		FeedReaderFeedReaderBackend* _tmp6_;
		FeedReaderTag* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		FeedReaderTag* _tmp10_;
		_tmp4_ = _data44_->popRename;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		_tmp5_ = feed_reader_feed_reader_backend_get_default ();
		_tmp6_ = _tmp5_;
		_tmp7_ = self->m_tag;
		_tmp8_ = _data44_->renameEntry;
		_tmp9_ = gtk_entry_get_text (_tmp8_);
		_tmp10_ = feed_reader_feed_reader_backend_renameTag (_tmp6_, _tmp7_, _tmp9_);
		_g_object_unref0 (self->m_tag);
		self->m_tag = _tmp10_;
		_g_object_unref0 (_tmp6_);
	} else {
		if (_data44_->context != NULL) {
			FeedReaderFeedReaderBackend* _tmp11_;
			FeedReaderFeedReaderBackend* _tmp12_;
			GtkEntry* _tmp13_;
			const gchar* _tmp14_;
			FeedReaderTag* _tmp15_;
			GtkPopover* _tmp16_;
			FeedReaderFeedReaderBackend* _tmp17_;
			FeedReaderFeedReaderBackend* _tmp18_;
			FeedReaderTag* _tmp19_;
			_tmp11_ = feed_reader_feed_reader_backend_get_default ();
			_tmp12_ = _tmp11_;
			_tmp13_ = _data44_->renameEntry;
			_tmp14_ = gtk_entry_get_text (_tmp13_);
			_tmp15_ = feed_reader_feed_reader_backend_createTag (_tmp12_, _tmp14_);
			_g_object_unref0 (self->m_tag);
			self->m_tag = _tmp15_;
			_g_object_unref0 (_tmp12_);
			_tmp16_ = _data44_->popRename;
			gtk_widget_hide ((GtkWidget*) _tmp16_);
			_tmp17_ = feed_reader_feed_reader_backend_get_default ();
			_tmp18_ = _tmp17_;
			_tmp19_ = self->m_tag;
			feed_reader_feed_reader_backend_tagArticle (_tmp18_, _data44_->article, _tmp19_, TRUE);
			_g_object_unref0 (_tmp18_);
			gtk_drag_finish (_data44_->context, TRUE, FALSE, (guint32) _data44_->time);
		}
	}
}

static void
___lambda141__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	__lambda141_ (self);
}

static void
__lambda142_ (Block44Data* _data44_)
{
	FeedReaderTagRow* self;
	GtkEntry* _tmp0_;
	self = _data44_->self;
	_tmp0_ = _data44_->renameEntry;
	g_signal_emit_by_name (_tmp0_, "activate");
}

static void
___lambda142__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda142_ (self);
}

static void
feed_reader_tag_row_showRenamePopover (FeedReaderTagRow* self,
                                       GdkDragContext* context,
                                       guint time,
                                       FeedReaderArticle* article)
{
	Block44Data* _data44_;
	GdkDragContext* _tmp0_;
	FeedReaderArticle* _tmp1_;
	GtkPopover* _tmp2_;
	GtkPopover* _tmp3_;
	GtkPopover* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	GtkEntry* _tmp8_;
	gchar* label = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	FeedReaderTag* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	GtkButton* renameButton = NULL;
	const gchar* _tmp16_;
	GtkButton* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkBox* renameBox = NULL;
	GtkBox* _tmp19_;
	GtkEntry* _tmp20_;
	GtkPopover* _tmp21_;
	GtkPopover* _tmp22_;
	g_return_if_fail (self != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (_data44_->context);
	_data44_->context = _tmp0_;
	_data44_->time = time;
	_tmp1_ = _g_object_ref0 (article);
	_g_object_unref0 (_data44_->article);
	_data44_->article = _tmp1_;
	_tmp2_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_data44_->popRename = _tmp2_;
	_tmp3_ = _data44_->popRename;
	gtk_popover_set_position (_tmp3_, GTK_POS_BOTTOM);
	_tmp4_ = _data44_->popRename;
	g_signal_connect_data (_tmp4_, "closed", (GCallback) ___lambda140__gtk_popover_closed, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	_data44_->renameEntry = _tmp5_;
	_tmp6_ = _data44_->renameEntry;
	_tmp7_ = self->m_name;
	gtk_entry_set_text (_tmp6_, _tmp7_);
	_tmp8_ = _data44_->renameEntry;
	g_signal_connect_data (_tmp8_, "activate", (GCallback) ___lambda141__gtk_entry_activate, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
	_tmp9_ = g_strdup (_ ("rename"));
	label = _tmp9_;
	_tmp11_ = self->m_tag;
	_tmp12_ = feed_reader_tag_getTagID (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, FEED_READER_TAG_ID_NEW) == 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		_tmp10_ = _data44_->context != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (_ ("add"));
		_g_free0 (label);
		label = _tmp15_;
	}
	_tmp16_ = label;
	_tmp17_ = (GtkButton*) gtk_button_new_with_label (_tmp16_);
	g_object_ref_sink (_tmp17_);
	renameButton = _tmp17_;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) renameButton);
	gtk_style_context_add_class (_tmp18_, "suggested-action");
	g_signal_connect_data (renameButton, "clicked", (GCallback) ___lambda142__gtk_button_clicked, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp19_);
	renameBox = _tmp19_;
	g_object_set ((GtkWidget*) renameBox, "margin", 5, NULL);
	_tmp20_ = _data44_->renameEntry;
	gtk_box_pack_start (renameBox, (GtkWidget*) _tmp20_, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (renameBox, (GtkWidget*) renameButton, FALSE, FALSE, (guint) 0);
	_tmp21_ = _data44_->popRename;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) renameBox);
	_tmp22_ = _data44_->popRename;
	gtk_widget_show_all ((GtkWidget*) _tmp22_);
	gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_PRELIGHT, FALSE);
	_g_object_unref0 (renameBox);
	_g_object_unref0 (renameButton);
	_g_free0 (label);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

static void
feed_reader_tag_row_class_init (FeedReaderTagRowClass * klass,
                                gpointer klass_data)
{
	feed_reader_tag_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderTagRow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_tag_row_finalize;
	feed_reader_tag_row_signals[FEED_READER_TAG_ROW_MOVE_UP_SIGNAL] = g_signal_new ("move-up", FEED_READER_TYPE_TAG_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	feed_reader_tag_row_signals[FEED_READER_TAG_ROW_REMOVE_ROW_SIGNAL] = g_signal_new ("remove-row", FEED_READER_TYPE_TAG_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
feed_reader_tag_row_instance_init (FeedReaderTagRow * self,
                                   gpointer klass)
{
	self->priv = feed_reader_tag_row_get_instance_private (self);
}

static void
feed_reader_tag_row_finalize (GObject * obj)
{
	FeedReaderTagRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TAG_ROW, FeedReaderTagRow);
	_g_object_unref0 (self->priv->m_box);
	_g_object_unref0 (self->priv->m_label);
	_g_free0 (self->priv->m_catID);
	_g_object_unref0 (self->priv->m_circle);
	_g_object_unref0 (self->priv->m_pop);
	_g_object_unref0 (self->priv->m_revealer);
	_g_object_unref0 (self->priv->m_eventBox);
	_g_free0 (self->m_name);
	_g_object_unref0 (self->m_tag);
	G_OBJECT_CLASS (feed_reader_tag_row_parent_class)->finalize (obj);
}

static GType
feed_reader_tag_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderTagRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_tag_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderTagRow), 0, (GInstanceInitFunc) feed_reader_tag_row_instance_init, NULL };
	GType feed_reader_tag_row_type_id;
	feed_reader_tag_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "FeedReaderTagRow", &g_define_type_info, 0);
	FeedReaderTagRow_private_offset = g_type_add_instance_private (feed_reader_tag_row_type_id, sizeof (FeedReaderTagRowPrivate));
	return feed_reader_tag_row_type_id;
}

GType
feed_reader_tag_row_get_type (void)
{
	static volatile gsize feed_reader_tag_row_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_tag_row_type_id__once)) {
		GType feed_reader_tag_row_type_id;
		feed_reader_tag_row_type_id = feed_reader_tag_row_get_type_once ();
		g_once_init_leave (&feed_reader_tag_row_type_id__once, feed_reader_tag_row_type_id);
	}
	return feed_reader_tag_row_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

