/* Extractor.c generated by valac 0.56.3, the Vala compiler
 * generated from Extractor.vala, do not modify */

/*
* Copyright (C) 2014 PerfectCarl - https://github.com/PerfectCarl/vala-stacktrace
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "ivy.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <unistd.h>
#include <stdio.h>
#include <execinfo.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _ivy_frame_unref0(var) ((var == NULL) ? NULL : (var = (ivy_frame_unref (var), NULL)))
typedef struct _IvyParamSpecExtractor IvyParamSpecExtractor;

struct _IvyExtractorPrivate {
	gboolean show_debug_frames;
	gchar* func;
	gchar* file_path;
	gchar* short_file_path;
	gchar* l;
	gchar* file_line;
	gchar* func_line;
	gchar* lib_address;
};

struct _IvyParamSpecExtractor {
	GParamSpec parent_instance;
};

static gint IvyExtractor_private_offset;
static gpointer ivy_extractor_parent_class = NULL;
static GeeList* ivy_extractor_libraries_with_no_info;
static GRecMutex __lock_ivy_extractor_ivy_extractor_libraries_with_no_info = {0};
static GeeList* ivy_extractor_libraries_with_no_info = NULL;

static gchar* ivy_extractor_get_module_name (IvyExtractor* self);
static gchar* ivy_extractor_get_relative_path (const gchar* p_fullDestinationPath,
                                        const gchar* p_startPath);
static gchar* ivy_extractor_extract_short_file_path (IvyExtractor* self,
                                              const gchar* file_path);
static gint ivy_extractor_extract_base_address (IvyExtractor* self,
                                         const gchar* line);
static void ivy_extractor_process_info_for_file (IvyExtractor* self,
                                          const gchar* full_line,
                                          const gchar* str);
static gchar* ivy_extractor_extract_function_name (IvyExtractor* self,
                                            const gchar* line);
static gchar* ivy_extractor_extract_function_name_from_line (IvyExtractor* self,
                                                      const gchar* line);
static gchar* ivy_extractor_extract_file_path (IvyExtractor* self,
                                        const gchar* line);
static gchar* ivy_extractor_extract_line (const gchar* line);
static void ivy_extractor_process_info_from_lib (IvyExtractor* self,
                                          const gchar* file_path,
                                          const gchar* str);
static gchar* ivy_extractor_execute_command_sync_get_output (IvyExtractor* self,
                                                      const gchar* cmd);
static gchar* ivy_extractor_process_line (IvyExtractor* self,
                                   const gchar* module,
                                   const gchar* address);
static gchar* ivy_extractor_extract_file_path_from (IvyExtractor* self,
                                             const gchar* str);
static gchar* ivy_extractor_extract_address (IvyExtractor* self,
                                      const gchar* line);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
static void ivy_extractor_finalize (IvyExtractor * obj);
static GType ivy_extractor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
ivy_extractor_get_instance_private (IvyExtractor* self)
{
	return G_STRUCT_MEMBER_P (self, IvyExtractor_private_offset);
}

static gchar*
ivy_extractor_get_module_name (IvyExtractor* self)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gint path_length1;
	gint _path_size_;
	gchar* _result_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 1024);
	path = _tmp0_;
	path_length1 = 1024;
	_path_size_ = path_length1;
	readlink ("/proc/self/exe", path, (gint) path_length1);
	_tmp1_ = g_strdup ((const gchar*) path);
	_result_ = _tmp1_;
	result = _result_;
	path = (g_free (path), NULL);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
ivy_extractor_get_relative_path (const gchar* p_fullDestinationPath,
                                 const gchar* p_startPath)
{
	gchar** l_startPathParts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint l_startPathParts_length1;
	gint _l_startPathParts_size_;
	gchar** l_destinationPathParts = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint l_destinationPathParts_length1;
	gint _l_destinationPathParts_size_;
	gint l_sameCounter = 0;
	GString* l_builder = NULL;
	GString* _tmp14_;
	gchar* _result_ = NULL;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gchar* _tmp34_;
	gchar* result;
	g_return_val_if_fail (p_fullDestinationPath != NULL, NULL);
	g_return_val_if_fail (p_startPath != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (p_startPath, "/", 0);
	l_startPathParts = _tmp1_;
	l_startPathParts_length1 = _vala_array_length (_tmp0_);
	_l_startPathParts_size_ = l_startPathParts_length1;
	_tmp3_ = _tmp2_ = g_strsplit (p_fullDestinationPath, "/", 0);
	l_destinationPathParts = _tmp3_;
	l_destinationPathParts_length1 = _vala_array_length (_tmp2_);
	_l_destinationPathParts_size_ = l_destinationPathParts_length1;
	l_sameCounter = 0;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gint _tmp12_;
		_tmp6_ = l_startPathParts;
		_tmp6__length1 = l_startPathParts_length1;
		if (l_sameCounter < _tmp6__length1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			_tmp7_ = l_destinationPathParts;
			_tmp7__length1 = l_destinationPathParts_length1;
			_tmp5_ = l_sameCounter < _tmp7__length1;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			_tmp8_ = l_startPathParts;
			_tmp8__length1 = l_startPathParts_length1;
			_tmp9_ = _tmp8_[l_sameCounter];
			_tmp10_ = l_destinationPathParts;
			_tmp10__length1 = l_destinationPathParts_length1;
			_tmp11_ = _tmp10_[l_sameCounter];
			_tmp4_ = g_strcmp0 (_tmp9_, _tmp11_) == 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_tmp12_ = l_sameCounter;
		l_sameCounter = _tmp12_ + 1;
	}
	if (l_sameCounter == 0) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup (p_fullDestinationPath);
		result = _tmp13_;
		l_destinationPathParts = (_vala_array_free (l_destinationPathParts, l_destinationPathParts_length1, (GDestroyNotify) g_free), NULL);
		l_startPathParts = (_vala_array_free (l_startPathParts, l_startPathParts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp14_ = g_string_new ("");
	l_builder = _tmp14_;
	{
		gint i = 0;
		i = l_sameCounter;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gchar** _tmp17_;
				gint _tmp17__length1;
				GString* _tmp18_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = l_startPathParts;
				_tmp17__length1 = l_startPathParts_length1;
				if (!(i < _tmp17__length1)) {
					break;
				}
				_tmp18_ = l_builder;
				g_string_append (_tmp18_, "../");
			}
		}
	}
	{
		gint i = 0;
		i = l_sameCounter;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gchar** _tmp21_;
				gint _tmp21__length1;
				GString* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = l_destinationPathParts;
				_tmp21__length1 = l_destinationPathParts_length1;
				if (!(i < _tmp21__length1)) {
					break;
				}
				_tmp22_ = l_builder;
				_tmp23_ = l_destinationPathParts;
				_tmp23__length1 = l_destinationPathParts_length1;
				_tmp24_ = _tmp23_[i];
				_tmp25_ = g_strconcat (_tmp24_, "/", NULL);
				_tmp26_ = _tmp25_;
				g_string_append (_tmp22_, _tmp26_);
				_g_free0 (_tmp26_);
			}
		}
	}
	_tmp27_ = l_builder;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = g_strdup (_tmp28_);
	_result_ = _tmp29_;
	_tmp30_ = _result_;
	_tmp31_ = _result_;
	_tmp32_ = strlen (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = string_substring (_tmp30_, (glong) 0, (glong) (_tmp33_ - 1));
	_g_free0 (_result_);
	_result_ = _tmp34_;
	result = _result_;
	_g_string_free0 (l_builder);
	l_destinationPathParts = (_vala_array_free (l_destinationPathParts, l_destinationPathParts_length1, (GDestroyNotify) g_free), NULL);
	l_startPathParts = (_vala_array_free (l_startPathParts, l_startPathParts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
ivy_extractor_extract_short_file_path (IvyExtractor* self,
                                       const gchar* file_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* _result_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_get_current_dir ();
	path = _tmp0_;
	_tmp1_ = ivy_extractor_get_relative_path (file_path, path);
	_result_ = _tmp1_;
	result = _result_;
	_g_free0 (path);
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint
ivy_extractor_extract_base_address (IvyExtractor* self,
                                    const gchar* line)
{
	gint _result_ = 0;
	gint start = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (line != NULL, 0);
	_result_ = 0;
	start = string_last_index_of (line, "+", 0);
	if (start >= 0) {
		gint end = 0;
		end = string_last_index_of (line, ")", 0);
		if (end > start) {
			gchar* text = NULL;
			gchar* _tmp0_;
			const gchar* _tmp1_;
			_tmp0_ = string_substring (line, (glong) (start + 3), (glong) ((end - start) - 3));
			text = _tmp0_;
			_tmp1_ = text;
			sscanf (_tmp1_, "%x", &_result_);
			_g_free0 (text);
		}
	}
	result = _result_;
	return result;
}

static void
ivy_extractor_process_info_for_file (IvyExtractor* self,
                                     const gchar* full_line,
                                     const gchar* str)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** lines = NULL;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_line != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->func);
	self->priv->func = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->file_path);
	self->priv->file_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->short_file_path);
	self->priv->short_file_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->l);
	self->priv->l = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->file_line);
	self->priv->file_line = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->func_line);
	self->priv->func_line = _tmp5_;
	if (g_strcmp0 (full_line, "") == 0) {
		return;
	}
	_tmp7_ = _tmp6_ = g_strsplit (full_line, "\n", 0);
	lines = _tmp7_;
	lines_length1 = _vala_array_length (_tmp6_);
	_lines_size_ = lines_length1;
	_tmp8_ = lines;
	_tmp8__length1 = lines_length1;
	if (_tmp8__length1 > 0) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = lines;
		_tmp9__length1 = lines_length1;
		_tmp10_ = _tmp9_[0];
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->priv->func_line);
		self->priv->func_line = _tmp11_;
	}
	_tmp12_ = lines;
	_tmp12__length1 = lines_length1;
	if (_tmp12__length1 > 1) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = lines;
		_tmp13__length1 = lines_length1;
		_tmp14_ = _tmp13_[1];
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (self->priv->file_line);
		self->priv->file_line = _tmp15_;
	}
	_tmp17_ = self->priv->file_line;
	if (g_strcmp0 (_tmp17_, "??:0") == 0) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp18_;
		_tmp18_ = self->priv->file_line;
		_tmp16_ = g_strcmp0 (_tmp18_, "??:?") == 0;
	}
	if (_tmp16_) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("");
		_g_free0 (self->priv->file_line);
		self->priv->file_line = _tmp19_;
	}
	_tmp20_ = ivy_extractor_extract_function_name (self, str);
	_g_free0 (self->priv->func);
	self->priv->func = _tmp20_;
	_tmp21_ = g_strdup ("");
	_g_free0 (self->priv->file_path);
	self->priv->file_path = _tmp21_;
	_tmp22_ = g_strdup ("");
	_g_free0 (self->priv->short_file_path);
	self->priv->short_file_path = _tmp22_;
	_tmp23_ = g_strdup ("");
	_g_free0 (self->priv->l);
	self->priv->l = _tmp23_;
	_tmp24_ = self->priv->file_line;
	if (g_strcmp0 (_tmp24_, "") != 0) {
		const gchar* _tmp25_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp25_ = self->priv->func;
		if (g_strcmp0 (_tmp25_, "") == 0) {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = self->priv->func_line;
			_tmp27_ = ivy_extractor_extract_function_name_from_line (self, _tmp26_);
			_g_free0 (self->priv->func);
			self->priv->func = _tmp27_;
		}
		_tmp28_ = self->priv->file_line;
		_tmp29_ = ivy_extractor_extract_file_path (self, _tmp28_);
		_g_free0 (self->priv->file_path);
		self->priv->file_path = _tmp29_;
		_tmp30_ = self->priv->file_path;
		_tmp31_ = ivy_extractor_extract_short_file_path (self, _tmp30_);
		_g_free0 (self->priv->short_file_path);
		self->priv->short_file_path = _tmp31_;
		_tmp32_ = self->priv->file_line;
		_tmp33_ = ivy_extractor_extract_line (_tmp32_);
		_g_free0 (self->priv->l);
		self->priv->l = _tmp33_;
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
ivy_extractor_process_info_from_lib (IvyExtractor* self,
                                     const gchar* file_path,
                                     const gchar* str)
{
	gboolean has_info = FALSE;
	gchar* addr1_s = NULL;
	gchar* _tmp0_;
	gchar* lib_addr = NULL;
	gchar* _tmp1_;
	gchar* cmd2 = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp14_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (str != NULL);
	has_info = TRUE;
	_tmp0_ = g_strdup ("");
	addr1_s = _tmp0_;
	_tmp1_ = g_strdup ("");
	lib_addr = _tmp1_;
	_tmp2_ = g_strdup ("");
	cmd2 = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->lib_address);
	self->priv->lib_address = _tmp3_;
	{
		GeeList* _tmp4_;
		_tmp4_ = ivy_extractor_libraries_with_no_info;
		g_rec_mutex_lock (&__lock_ivy_extractor_ivy_extractor_libraries_with_no_info);
		{
			GeeList* _tmp5_;
			_tmp5_ = ivy_extractor_libraries_with_no_info;
			if (gee_list_index_of (_tmp5_, file_path) == -1) {
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				_tmp6_ = g_strdup_printf ("nm %s", file_path);
				_g_free0 (cmd2);
				cmd2 = _tmp6_;
				_tmp7_ = cmd2;
				_tmp8_ = ivy_extractor_execute_command_sync_get_output (self, _tmp7_);
				_g_free0 (addr1_s);
				addr1_s = _tmp8_;
				_tmp10_ = addr1_s;
				if (_tmp10_ == NULL) {
					_tmp9_ = TRUE;
				} else {
					const gchar* _tmp11_;
					_tmp11_ = addr1_s;
					_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
				}
				if (_tmp9_) {
					GeeList* _tmp12_;
					_tmp12_ = ivy_extractor_libraries_with_no_info;
					gee_collection_add ((GeeCollection*) _tmp12_, file_path);
					has_info = FALSE;
				}
			} else {
				has_info = FALSE;
			}
		}
		__finally0:
		{
			GeeList* _tmp13_;
			_tmp13_ = ivy_extractor_libraries_with_no_info;
			g_rec_mutex_unlock (&__lock_ivy_extractor_ivy_extractor_libraries_with_no_info);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (cmd2);
			_g_free0 (lib_addr);
			_g_free0 (addr1_s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (has_info) {
		const gchar* _tmp15_;
		_tmp15_ = self->priv->func;
		_tmp14_ = g_strcmp0 (_tmp15_, "") != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GMatchInfo* info = NULL;
		gchar* expression = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gint addr1 = 0;
		const gchar* _tmp45_;
		_tmp16_ = self->priv->func;
		_tmp17_ = g_strconcat ("\\n[^ ]* T ", _tmp16_, NULL);
		expression = _tmp17_;
		{
			GRegex* regex = NULL;
			const gchar* _tmp18_;
			GRegex* _tmp19_;
			gint count = 0;
			gchar* matches = NULL;
			gchar* _tmp20_;
			GRegex* _tmp21_;
			const gchar* _tmp22_;
			GMatchInfo* _tmp23_ = NULL;
			gboolean _tmp24_;
			_tmp18_ = expression;
			_tmp19_ = g_regex_new (_tmp18_, 0, 0, &_inner_error0_);
			regex = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch1_g_regex_error;
				}
				_g_free0 (expression);
				_g_match_info_unref0 (info);
				_g_free0 (cmd2);
				_g_free0 (lib_addr);
				_g_free0 (addr1_s);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			count = 0;
			_tmp20_ = g_strdup ("");
			matches = _tmp20_;
			_tmp21_ = regex;
			_tmp22_ = addr1_s;
			_tmp24_ = g_regex_match (_tmp21_, _tmp22_, 0, &_tmp23_);
			_g_match_info_unref0 (info);
			info = _tmp23_;
			if (_tmp24_) {
				while (TRUE) {
					GMatchInfo* _tmp25_;
					gchar* lll = NULL;
					GMatchInfo* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					GMatchInfo* _tmp36_;
					gint _tmp37_;
					_tmp25_ = info;
					if (!g_match_info_matches (_tmp25_)) {
						break;
					}
					_tmp26_ = info;
					_tmp27_ = g_match_info_fetch (_tmp26_, 0);
					lll = _tmp27_;
					_tmp28_ = lll;
					_tmp29_ = lll;
					_tmp30_ = string_substring (_tmp28_, (glong) 0, (glong) string_index_of (_tmp29_, " ", 0));
					_g_free0 (lib_addr);
					lib_addr = _tmp30_;
					_tmp31_ = matches;
					_tmp32_ = lib_addr;
					_tmp33_ = g_strconcat (_tmp32_, "\n", NULL);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
					_g_free0 (matches);
					matches = _tmp35_;
					_g_free0 (_tmp34_);
					_tmp36_ = info;
					g_match_info_next (_tmp36_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (lll);
						_g_free0 (matches);
						_g_regex_unref0 (regex);
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						_g_free0 (expression);
						_g_match_info_unref0 (info);
						_g_free0 (cmd2);
						_g_free0 (lib_addr);
						_g_free0 (addr1_s);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp37_ = count;
					count = _tmp37_ + 1;
					_g_free0 (lll);
				}
				if (count > 1) {
					FILE* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					_tmp38_ = stdout;
					_tmp39_ = self->priv->func;
					_tmp40_ = cmd2;
					_tmp41_ = matches;
					fprintf (_tmp38_, "  XX %d matches for '%s'. Command: '%s'. Matches: '%s'\n", count, _tmp39_, _tmp40_, _tmp41_);
				}
			}
			_g_free0 (matches);
			_g_regex_unref0 (regex);
		}
		goto __finally1;
		__catch1_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp42_;
			GError* _tmp43_;
			const gchar* _tmp44_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp42_ = expression;
			_tmp43_ = e;
			_tmp44_ = _tmp43_->message;
			g_critical ("Extractor.vala:205: Error while processing regex '%s. Err: '%s", _tmp42_, _tmp44_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (expression);
			_g_match_info_unref0 (info);
			_g_free0 (cmd2);
			_g_free0 (lib_addr);
			_g_free0 (addr1_s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		addr1 = 0;
		_tmp45_ = lib_addr;
		sscanf (_tmp45_, "%x", &addr1);
		if (addr1 != 0) {
			gint addr2 = 0;
			gchar* addr3 = NULL;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* new_full_line = NULL;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			const gchar* _tmp51_;
			addr2 = ivy_extractor_extract_base_address (self, str);
			_tmp46_ = g_strdup_printf ("%#08x", (guint) (addr1 + addr2));
			addr3 = _tmp46_;
			_tmp47_ = addr3;
			_tmp48_ = g_strdup (_tmp47_);
			_g_free0 (self->priv->lib_address);
			self->priv->lib_address = _tmp48_;
			_tmp49_ = addr3;
			_tmp50_ = ivy_extractor_process_line (self, file_path, _tmp49_);
			new_full_line = _tmp50_;
			_tmp51_ = new_full_line;
			ivy_extractor_process_info_for_file (self, _tmp51_, str);
			_g_free0 (new_full_line);
			_g_free0 (addr3);
		} else {
			FILE* _tmp52_;
			_tmp52_ = stdout;
			fprintf (_tmp52_, "NULL\n");
		}
		_g_free0 (expression);
		_g_match_info_unref0 (info);
	}
	_g_free0 (cmd2);
	_g_free0 (lib_addr);
	_g_free0 (addr1_s);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
ivy_extractor_extract_function_name (IvyExtractor* self,
                                     const gchar* line)
{
	gint start = 0;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	if (g_strcmp0 (line, "") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	start = string_index_of (line, "(", 0);
	if (start >= 0) {
		gint end = 0;
		end = string_index_of (line, "+", start);
		if (end >= 0) {
			gchar* _result_ = NULL;
			gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = string_substring (line, (glong) (start + 1), (glong) ((end - start) - 1));
			_result_ = _tmp1_;
			_tmp2_ = _result_;
			_tmp3_ = string_strip (_tmp2_);
			result = _tmp3_;
			_g_free0 (_result_);
			return result;
		}
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static gchar*
ivy_extractor_extract_function_name_from_line (IvyExtractor* self,
                                               const gchar* line)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = string_strip (line);
	result = _tmp0_;
	return result;
}

static gchar*
ivy_extractor_extract_file_path_from (IvyExtractor* self,
                                      const gchar* str)
{
	gint start = 0;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	if (g_strcmp0 (str, "") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	start = string_index_of (str, "(", 0);
	if (start >= 0) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = string_substring (str, (glong) 0, (glong) start);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_strip (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = string_strip (str);
	result = _tmp5_;
	return result;
}

static gchar*
ivy_extractor_extract_file_path (IvyExtractor* self,
                                 const gchar* line)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gint start = 0;
	const gchar* _tmp10_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = g_strdup (line);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_free0 (_result_);
		return result;
	}
	_tmp3_ = _result_;
	if (g_strcmp0 (_tmp3_, "??:0??:0") == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		_g_free0 (_result_);
		return result;
	}
	_tmp5_ = _result_;
	if (g_str_has_prefix (_tmp5_, "??:0")) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = _result_;
		_tmp7_ = strlen (line);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_substring (_tmp6_, (glong) 4, (glong) (_tmp8_ - 4));
		_g_free0 (_result_);
		_result_ = _tmp9_;
	}
	_tmp10_ = _result_;
	start = string_index_of (_tmp10_, ":", 0);
	if (start >= 0) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = _result_;
		_tmp12_ = string_substring (_tmp11_, (glong) 0, (glong) start);
		_g_free0 (_result_);
		_result_ = _tmp12_;
		_tmp13_ = _result_;
		_tmp14_ = string_strip (_tmp13_);
		result = _tmp14_;
		_g_free0 (_result_);
		return result;
	}
	_tmp15_ = g_strdup ("");
	result = _tmp15_;
	_g_free0 (_result_);
	return result;
}

static gchar*
ivy_extractor_extract_line (const gchar* line)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gint start = 0;
	const gchar* _tmp8_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = g_strdup (line);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_free0 (_result_);
		return result;
	}
	_tmp3_ = _result_;
	if (g_str_has_prefix (_tmp3_, "??:0")) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = _result_;
		_tmp5_ = strlen (line);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_substring (_tmp4_, (glong) 4, (glong) (_tmp6_ - 4));
		_g_free0 (_result_);
		_result_ = _tmp7_;
	}
	_tmp8_ = _result_;
	start = string_index_of (_tmp8_, ":", 0);
	if (start >= 0) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
		gint end = 0;
		const gchar* _tmp13_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp9_ = _result_;
		_tmp10_ = strlen (line);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp9_, (glong) (start + 1), (glong) ((_tmp11_ - start) - 1));
		_g_free0 (_result_);
		_result_ = _tmp12_;
		_tmp13_ = _result_;
		end = string_index_of (_tmp13_, "(", 0);
		if (end >= 0) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = _result_;
			_tmp15_ = string_substring (_tmp14_, (glong) 0, (glong) end);
			_g_free0 (_result_);
			_result_ = _tmp15_;
		}
		_tmp16_ = _result_;
		_tmp17_ = string_strip (_tmp16_);
		result = _tmp17_;
		_g_free0 (_result_);
		return result;
	}
	_tmp18_ = g_strdup ("");
	result = _tmp18_;
	_g_free0 (_result_);
	return result;
}

static gchar*
ivy_extractor_extract_address (IvyExtractor* self,
                               const gchar* line)
{
	gint start = 0;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	if (g_strcmp0 (line, "") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	start = string_index_of (line, "[", 0);
	if (start >= 0) {
		gint end = 0;
		end = string_index_of (line, "]", start);
		if (end >= 0) {
			gchar* _result_ = NULL;
			gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = string_substring (line, (glong) (start + 1), (glong) ((end - start) - 1));
			_result_ = _tmp1_;
			_tmp2_ = _result_;
			_tmp3_ = string_strip (_tmp2_);
			result = _tmp3_;
			_g_free0 (_result_);
			return result;
		}
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static gchar*
ivy_extractor_execute_command_sync_get_output (IvyExtractor* self,
                                               const gchar* cmd)
{
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	{
		gint exitCode = 0;
		gchar* std_out = NULL;
		gchar* std_err = NULL;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		g_spawn_command_line_sync (cmd, &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
		_g_free0 (std_out);
		std_out = _tmp0_;
		_g_free0 (std_err);
		std_err = _tmp1_;
		exitCode = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (std_err);
			_g_free0 (std_out);
			goto __catch0_g_error;
		}
		if (exitCode == 0) {
			result = std_out;
			_g_free0 (std_err);
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_strdup_printf ("Error while executing '%s'. Exit code '%d'\n", cmd, exitCode);
			_tmp4_ = _tmp3_;
			g_print ("%s", _tmp4_);
			_g_free0 (_tmp4_);
		}
		_g_free0 (std_err);
		_g_free0 (std_out);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("Error while executing '%s': %s\n", cmd, _tmp6_);
		_tmp8_ = _tmp7_;
		g_print ("%s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp9_ = g_strdup ("");
	result = _tmp9_;
	return result;
}

static gchar*
ivy_extractor_process_line (IvyExtractor* self,
                            const gchar* module,
                            const gchar* address)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* _result_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	g_return_val_if_fail (address != NULL, NULL);
	_tmp0_ = g_strdup_printf ("addr2line -f -e %s %s", module, address);
	cmd = _tmp0_;
	_tmp1_ = ivy_extractor_execute_command_sync_get_output (self, cmd);
	_result_ = _tmp1_;
	result = _result_;
	_g_free0 (cmd);
	return result;
}

/**
* Populates the stacktrace with frames
*
* The frames are extracted from ``Linux.Backtrace`` and enriched
* via calls to unix tools ``nm`` and ``addr2line``.
*
* ''Warning:'' because this methods calls synchronously other applications (nm and addr2line), it
* can have a significant impact on performance.
*
* @param trace the stacktrace
*/
static const gchar**
_vala_backtrace_symbols (void** buffer,
                         gint buffer_length1,
                         gint* result_length1)
{
	const gchar** s = NULL;
	const gchar** _tmp0_;
	gint s_length1;
	gint _s_size_;
	const gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar** result;
	_tmp0_ = backtrace_symbols (buffer, (gint) buffer_length1);
	s = _tmp0_;
	s_length1 = -1;
	_s_size_ = s_length1;
	s_length1 = buffer_length1;
	_tmp1_ = s;
	_tmp1__length1 = s_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_ivy_frame_ref0 (gpointer self)
{
	return self ? ivy_frame_ref (self) : NULL;
}

void
ivy_extractor_create_stacktrace (IvyExtractor* self,
                                 IvyStacktrace* trace)
{
	gint frame_count = 0;
	gint skipped_frames_count = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	void** array = NULL;
	void** _tmp2_;
	gint array_length1;
	gint _array_size_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	gint size = 0;
	void** _tmp5_;
	gint _tmp5__length1;
	const gchar** strings = NULL;
	void** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	const gchar** _tmp8_;
	gint strings_length1;
	gint _strings_size_;
	gint* addresses = NULL;
	void** _tmp9_;
	gint _tmp9__length1;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint addresses_length1;
	gint _addresses_size_;
	gchar* module = NULL;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (trace != NULL);
	frame_count = 100;
	skipped_frames_count = 5;
	_tmp0_ = ivy_stacktrace_get_is_custom (trace);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		skipped_frames_count = 3;
	}
	_tmp2_ = g_new0 (void*, frame_count);
	array = _tmp2_;
	array_length1 = frame_count;
	_array_size_ = array_length1;
	_tmp3_ = ivy_stacktrace_get_frames (trace);
	_tmp4_ = _tmp3_;
	gee_collection_clear ((GeeCollection*) _tmp4_);
	_ivy_frame_unref0 (trace->first_vala);
	trace->first_vala = NULL;
	trace->max_file_name_length = 0;
	trace->is_all_function_name_blank = TRUE;
	trace->is_all_file_name_blank = TRUE;
	_tmp5_ = array;
	_tmp5__length1 = array_length1;
	size = backtrace (_tmp5_, (gint) _tmp5__length1);
	_tmp6_ = array;
	_tmp6__length1 = array_length1;
	_tmp8_ = _vala_backtrace_symbols (_tmp6_, (gint) _tmp6__length1, &_tmp7_);
	strings = _tmp8_;
	strings_length1 = _tmp7_;
	_strings_size_ = strings_length1;
	_tmp9_ = array;
	_tmp9__length1 = array_length1;
	_tmp10_ = (((gint*) _tmp9_) != NULL) ? _vala_array_dup1 ((gint*) _tmp9_, (_tmp9__length1 * sizeof (void*)) / sizeof (gint)) : ((gint*) _tmp9_);
	_tmp10__length1 = (_tmp9__length1 * sizeof (void*)) / sizeof (gint);
	addresses = _tmp10_;
	addresses_length1 = _tmp10__length1;
	_addresses_size_ = addresses_length1;
	_tmp11_ = ivy_extractor_get_module_name (self);
	module = _tmp11_;
	{
		gint i = 0;
		i = skipped_frames_count;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint address = 0;
				gint* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gchar* str = NULL;
				const gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* addr = NULL;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* full_line = NULL;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp31_;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				const gchar* _tmp46_;
				gboolean _tmp48_ = FALSE;
				const gchar* _tmp49_;
				gchar* line_number = NULL;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				IvyFrame* frame = NULL;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				IvyFrame* _tmp58_;
				gboolean _tmp59_ = FALSE;
				IvyFrame* _tmp60_;
				const gchar* _tmp64_;
				gint _tmp65_;
				gint _tmp66_;
				const gchar* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				GeeList* _tmp76_;
				GeeList* _tmp77_;
				IvyFrame* _tmp78_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp14_ = addresses;
				_tmp14__length1 = addresses_length1;
				_tmp15_ = _tmp14_[i];
				address = _tmp15_;
				_tmp16_ = strings;
				_tmp16__length1 = strings_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = g_strdup (_tmp17_);
				str = _tmp18_;
				_tmp19_ = str;
				_tmp20_ = ivy_extractor_extract_address (self, _tmp19_);
				addr = _tmp20_;
				_tmp21_ = g_strdup ("");
				_g_free0 (self->priv->lib_address);
				self->priv->lib_address = _tmp21_;
				_tmp22_ = module;
				_tmp23_ = addr;
				_tmp24_ = ivy_extractor_process_line (self, _tmp22_, _tmp23_);
				full_line = _tmp24_;
				_tmp25_ = full_line;
				if (g_strcmp0 (_tmp25_, "") == 0) {
					g_print ("Something went very wrong. Your stacktrace cannot be displayed\n");
					_g_free0 (full_line);
					_g_free0 (addr);
					_g_free0 (str);
					break;
				}
				_tmp26_ = full_line;
				_tmp27_ = str;
				ivy_extractor_process_info_for_file (self, _tmp26_, _tmp27_);
				_tmp28_ = self->priv->file_line;
				if (g_strcmp0 (_tmp28_, "") == 0) {
					const gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp29_ = str;
					_tmp30_ = ivy_extractor_extract_file_path_from (self, _tmp29_);
					_g_free0 (self->priv->file_path);
					self->priv->file_path = _tmp30_;
				}
				_tmp31_ = self->priv->file_path;
				if (string_contains (_tmp31_, ".so")) {
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp32_ = self->priv->file_path;
					_tmp33_ = str;
					ivy_extractor_process_info_from_lib (self, _tmp32_, _tmp33_);
				}
				if (self->priv->show_debug_frames) {
					FILE* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					_tmp34_ = stdout;
					_tmp35_ = addr;
					_tmp36_ = full_line;
					_tmp37_ = self->priv->file_line;
					_tmp38_ = self->priv->func_line;
					_tmp39_ = str;
					_tmp40_ = self->priv->func;
					_tmp41_ = self->priv->file_path;
					_tmp42_ = self->priv->l;
					_tmp43_ = self->priv->lib_address;
					fprintf (_tmp34_, "\n" \
"Frame %d \n" \
"--------\n" \
"  . addr: [%s]\n" \
"  . full_line: '%s'\n" \
"  . file_line: '%s'\n" \
"  . func_line: '%s'\n" \
"  . str : '%s'\n" \
"  . func: '%s'\n" \
"  . file: '%s'\n" \
"  . line: '%s'\n" \
"  . address: '%#08x'\n" \
"  . lib_address: '%s'\n", i, _tmp35_, _tmp36_, _tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp42_, (guint) address, _tmp43_);
				}
				_tmp46_ = self->priv->func;
				if (g_strcmp0 (_tmp46_, "") != 0) {
					const gchar* _tmp47_;
					_tmp47_ = self->priv->file_path;
					_tmp45_ = g_str_has_suffix (_tmp47_, ".vala");
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					_tmp44_ = trace->is_all_function_name_blank;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					trace->is_all_function_name_blank = FALSE;
				}
				_tmp49_ = self->priv->short_file_path;
				if (g_strcmp0 (_tmp49_, "") != 0) {
					_tmp48_ = trace->is_all_file_name_blank;
				} else {
					_tmp48_ = FALSE;
				}
				if (_tmp48_) {
					trace->is_all_file_name_blank = FALSE;
				}
				_tmp50_ = self->priv->file_line;
				_tmp51_ = ivy_extractor_extract_line (_tmp50_);
				line_number = _tmp51_;
				_tmp52_ = addr;
				_tmp53_ = self->priv->file_line;
				_tmp54_ = self->priv->func;
				_tmp55_ = self->priv->file_path;
				_tmp56_ = self->priv->short_file_path;
				_tmp57_ = line_number;
				_tmp58_ = ivy_frame_new (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
				frame = _tmp58_;
				_tmp60_ = trace->first_vala;
				if (_tmp60_ == NULL) {
					const gchar* _tmp61_;
					_tmp61_ = self->priv->file_path;
					_tmp59_ = g_str_has_suffix (_tmp61_, ".vala");
				} else {
					_tmp59_ = FALSE;
				}
				if (_tmp59_) {
					IvyFrame* _tmp62_;
					IvyFrame* _tmp63_;
					_tmp62_ = frame;
					_tmp63_ = _ivy_frame_ref0 (_tmp62_);
					_ivy_frame_unref0 (trace->first_vala);
					trace->first_vala = _tmp63_;
				}
				_tmp64_ = self->priv->short_file_path;
				_tmp65_ = strlen (_tmp64_);
				_tmp66_ = _tmp65_;
				if (_tmp66_ > trace->max_file_name_length) {
					const gchar* _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					_tmp67_ = self->priv->short_file_path;
					_tmp68_ = strlen (_tmp67_);
					_tmp69_ = _tmp68_;
					trace->max_file_name_length = _tmp69_;
				}
				_tmp70_ = self->priv->l;
				_tmp71_ = strlen (_tmp70_);
				_tmp72_ = _tmp71_;
				if (_tmp72_ > trace->max_line_number_length) {
					const gchar* _tmp73_;
					gint _tmp74_;
					gint _tmp75_;
					_tmp73_ = self->priv->l;
					_tmp74_ = strlen (_tmp73_);
					_tmp75_ = _tmp74_;
					trace->max_line_number_length = _tmp75_;
				}
				_tmp76_ = ivy_stacktrace_get_frames (trace);
				_tmp77_ = _tmp76_;
				_tmp78_ = frame;
				gee_collection_add ((GeeCollection*) _tmp77_, _tmp78_);
				_ivy_frame_unref0 (frame);
				_g_free0 (line_number);
				_g_free0 (full_line);
				_g_free0 (addr);
				_g_free0 (str);
			}
		}
	}
	_g_free0 (module);
	addresses = (g_free (addresses), NULL);
	strings = (g_free (strings), NULL);
	array = (g_free (array), NULL);
}

IvyExtractor*
ivy_extractor_construct (GType object_type)
{
	IvyExtractor* self = NULL;
	self = (IvyExtractor*) g_type_create_instance (object_type);
	return self;
}

IvyExtractor*
ivy_extractor_new (void)
{
	return ivy_extractor_construct (IVY_TYPE_EXTRACTOR);
}

static void
ivy_value_extractor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ivy_value_extractor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ivy_extractor_unref (value->data[0].v_pointer);
	}
}

static void
ivy_value_extractor_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ivy_extractor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ivy_value_extractor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ivy_value_extractor_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		IvyExtractor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ivy_extractor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ivy_value_extractor_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	IvyExtractor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ivy_extractor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ivy_param_spec_extractor (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	IvyParamSpecExtractor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IVY_TYPE_EXTRACTOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ivy_value_get_extractor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_EXTRACTOR), NULL);
	return value->data[0].v_pointer;
}

void
ivy_value_set_extractor (GValue* value,
                         gpointer v_object)
{
	IvyExtractor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_EXTRACTOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_EXTRACTOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ivy_extractor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_extractor_unref (old);
	}
}

void
ivy_value_take_extractor (GValue* value,
                          gpointer v_object)
{
	IvyExtractor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_EXTRACTOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_EXTRACTOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_extractor_unref (old);
	}
}

static void
ivy_extractor_class_init (IvyExtractorClass * klass,
                          gpointer klass_data)
{
	GeeArrayList* _tmp0_;
	ivy_extractor_parent_class = g_type_class_peek_parent (klass);
	((IvyExtractorClass *) klass)->finalize = ivy_extractor_finalize;
	g_type_class_adjust_private_offset (klass, &IvyExtractor_private_offset);
	g_rec_mutex_init (&__lock_ivy_extractor_ivy_extractor_libraries_with_no_info);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	ivy_extractor_libraries_with_no_info = (GeeList*) _tmp0_;
}

static void
ivy_extractor_instance_init (IvyExtractor * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self->priv = ivy_extractor_get_instance_private (self);
	self->priv->show_debug_frames = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->func = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->file_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->short_file_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->l = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->file_line = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->func_line = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->lib_address = _tmp6_;
	self->ref_count = 1;
}

static void
ivy_extractor_finalize (IvyExtractor * obj)
{
	IvyExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IVY_TYPE_EXTRACTOR, IvyExtractor);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->func);
	_g_free0 (self->priv->file_path);
	_g_free0 (self->priv->short_file_path);
	_g_free0 (self->priv->l);
	_g_free0 (self->priv->file_line);
	_g_free0 (self->priv->func_line);
	_g_free0 (self->priv->lib_address);
}

/**
* Extracts frames and builds a {@link Stacktrace}
*
*/
static GType
ivy_extractor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ivy_value_extractor_init, ivy_value_extractor_free_value, ivy_value_extractor_copy_value, ivy_value_extractor_peek_pointer, "p", ivy_value_extractor_collect_value, "p", ivy_value_extractor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IvyExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ivy_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IvyExtractor), 0, (GInstanceInitFunc) ivy_extractor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ivy_extractor_type_id;
	ivy_extractor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IvyExtractor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IvyExtractor_private_offset = g_type_add_instance_private (ivy_extractor_type_id, sizeof (IvyExtractorPrivate));
	return ivy_extractor_type_id;
}

GType
ivy_extractor_get_type (void)
{
	static volatile gsize ivy_extractor_type_id__once = 0;
	if (g_once_init_enter (&ivy_extractor_type_id__once)) {
		GType ivy_extractor_type_id;
		ivy_extractor_type_id = ivy_extractor_get_type_once ();
		g_once_init_leave (&ivy_extractor_type_id__once, ivy_extractor_type_id);
	}
	return ivy_extractor_type_id__once;
}

gpointer
ivy_extractor_ref (gpointer instance)
{
	IvyExtractor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ivy_extractor_unref (gpointer instance)
{
	IvyExtractor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IVY_EXTRACTOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

