/* Frame.c generated by valac 0.56.3, the Vala compiler
 * generated from Frame.vala, do not modify */

/*
* Copyright (C) 2014 PerfectCarl - https://github.com/PerfectCarl/vala-stacktrace
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "ivy.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _IvyParamSpecFrame IvyParamSpecFrame;

struct _IvyFramePrivate {
	gchar* _address;
	gchar* _line;
	gchar* _line_number;
	gchar* _file_path;
	gchar* _file_short_path;
	gchar* _function;
};

struct _IvyParamSpecFrame {
	GParamSpec parent_instance;
};

static gint IvyFrame_private_offset;
static gpointer ivy_frame_parent_class = NULL;

static void ivy_frame_set_line_number (IvyFrame* self,
                                const gchar* value);
static void ivy_frame_set_address (IvyFrame* self,
                            const gchar* value);
static void ivy_frame_set_line (IvyFrame* self,
                         const gchar* value);
static void ivy_frame_set_file_path (IvyFrame* self,
                              const gchar* value);
static void ivy_frame_set_file_short_path (IvyFrame* self,
                                    const gchar* value);
static void ivy_frame_set_function (IvyFrame* self,
                             const gchar* value);
static void ivy_frame_finalize (IvyFrame * obj);
static GType ivy_frame_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
ivy_frame_get_instance_private (IvyFrame* self)
{
	return G_STRUCT_MEMBER_P (self, IvyFrame_private_offset);
}

IvyFrame*
ivy_frame_construct (GType object_type,
                     const gchar* address,
                     const gchar* line,
                     const gchar* function,
                     const gchar* file_path,
                     const gchar* file_short_path,
                     const gchar* line_number)
{
	IvyFrame* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (address != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	g_return_val_if_fail (file_short_path != NULL, NULL);
	g_return_val_if_fail (line_number != NULL, NULL);
	self = (IvyFrame*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (address);
	_g_free0 (self->priv->_address);
	self->priv->_address = _tmp0_;
	_tmp1_ = g_strdup (line);
	_g_free0 (self->priv->_line);
	self->priv->_line = _tmp1_;
	_tmp2_ = g_strdup (file_path);
	_g_free0 (self->priv->_file_path);
	self->priv->_file_path = _tmp2_;
	_tmp3_ = g_strdup (file_short_path);
	_g_free0 (self->priv->_file_short_path);
	self->priv->_file_short_path = _tmp3_;
	_tmp4_ = g_strdup (function);
	_g_free0 (self->priv->_function);
	self->priv->_function = _tmp4_;
	ivy_frame_set_line_number (self, line_number);
	return self;
}

IvyFrame*
ivy_frame_new (const gchar* address,
               const gchar* line,
               const gchar* function,
               const gchar* file_path,
               const gchar* file_short_path,
               const gchar* line_number)
{
	return ivy_frame_construct (IVY_TYPE_FRAME, address, line, function, file_path, file_short_path, line_number);
}

const gchar*
ivy_frame_get_address (IvyFrame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address;
	result = _tmp0_;
	return result;
}

static void
ivy_frame_set_address (IvyFrame* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_address);
	self->priv->_address = _tmp0_;
}

const gchar*
ivy_frame_get_line (IvyFrame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_line;
	result = _tmp0_;
	return result;
}

static void
ivy_frame_set_line (IvyFrame* self,
                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_line);
	self->priv->_line = _tmp0_;
}

const gchar*
ivy_frame_get_line_number (IvyFrame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_line_number;
	result = _tmp0_;
	return result;
}

static void
ivy_frame_set_line_number (IvyFrame* self,
                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_line_number);
	self->priv->_line_number = _tmp0_;
}

const gchar*
ivy_frame_get_file_path (IvyFrame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_path;
	result = _tmp0_;
	return result;
}

static void
ivy_frame_set_file_path (IvyFrame* self,
                         const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_file_path);
	self->priv->_file_path = _tmp0_;
}

const gchar*
ivy_frame_get_file_short_path (IvyFrame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_short_path;
	result = _tmp0_;
	return result;
}

static void
ivy_frame_set_file_short_path (IvyFrame* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_file_short_path);
	self->priv->_file_short_path = _tmp0_;
}

const gchar*
ivy_frame_get_function (IvyFrame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_function;
	result = _tmp0_;
	return result;
}

static void
ivy_frame_set_function (IvyFrame* self,
                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_function);
	self->priv->_function = _tmp0_;
}

static void
ivy_value_frame_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ivy_value_frame_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ivy_frame_unref (value->data[0].v_pointer);
	}
}

static void
ivy_value_frame_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ivy_frame_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ivy_value_frame_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ivy_value_frame_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		IvyFrame * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ivy_frame_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ivy_value_frame_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	IvyFrame ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ivy_frame_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ivy_param_spec_frame (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	IvyParamSpecFrame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IVY_TYPE_FRAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ivy_value_get_frame (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_FRAME), NULL);
	return value->data[0].v_pointer;
}

void
ivy_value_set_frame (GValue* value,
                     gpointer v_object)
{
	IvyFrame * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_FRAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_FRAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ivy_frame_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_frame_unref (old);
	}
}

void
ivy_value_take_frame (GValue* value,
                      gpointer v_object)
{
	IvyFrame * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_FRAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_FRAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_frame_unref (old);
	}
}

static void
ivy_frame_class_init (IvyFrameClass * klass,
                      gpointer klass_data)
{
	ivy_frame_parent_class = g_type_class_peek_parent (klass);
	((IvyFrameClass *) klass)->finalize = ivy_frame_finalize;
	g_type_class_adjust_private_offset (klass, &IvyFrame_private_offset);
}

static void
ivy_frame_instance_init (IvyFrame * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = ivy_frame_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_address = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_line = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_line_number = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_file_path = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_file_short_path = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_function = _tmp5_;
	self->ref_count = 1;
}

static void
ivy_frame_finalize (IvyFrame * obj)
{
	IvyFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IVY_TYPE_FRAME, IvyFrame);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_address);
	_g_free0 (self->priv->_line);
	_g_free0 (self->priv->_line_number);
	_g_free0 (self->priv->_file_path);
	_g_free0 (self->priv->_file_short_path);
	_g_free0 (self->priv->_function);
}

/**
* A part of a stacktrace
*
* This class represent on instance of a frame, ie a particular location
* in a binary (application or library) on the system called by the application
*
* ''Note:'' frames from system libraries without code information available are
* not displayed by default. See {@link Stacktrace.hide_installed_libraries} for how to
* display them.
**/
static GType
ivy_frame_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ivy_value_frame_init, ivy_value_frame_free_value, ivy_value_frame_copy_value, ivy_value_frame_peek_pointer, "p", ivy_value_frame_collect_value, "p", ivy_value_frame_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IvyFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ivy_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IvyFrame), 0, (GInstanceInitFunc) ivy_frame_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ivy_frame_type_id;
	ivy_frame_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IvyFrame", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IvyFrame_private_offset = g_type_add_instance_private (ivy_frame_type_id, sizeof (IvyFramePrivate));
	return ivy_frame_type_id;
}

GType
ivy_frame_get_type (void)
{
	static volatile gsize ivy_frame_type_id__once = 0;
	if (g_once_init_enter (&ivy_frame_type_id__once)) {
		GType ivy_frame_type_id;
		ivy_frame_type_id = ivy_frame_get_type_once ();
		g_once_init_leave (&ivy_frame_type_id__once, ivy_frame_type_id);
	}
	return ivy_frame_type_id__once;
}

gpointer
ivy_frame_ref (gpointer instance)
{
	IvyFrame * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ivy_frame_unref (gpointer instance)
{
	IvyFrame * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IVY_FRAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

