/* Printer.c generated by valac 0.56.3, the Vala compiler
 * generated from Printer.vala, do not modify */

/*
* Copyright (C) 2014 PerfectCarl - https://github.com/PerfectCarl/vala-stacktrace
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "ivy.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <signal.h>
#include <stdio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define _ivy_stacktrace_unref0(var) ((var == NULL) ? NULL : (var = (ivy_stacktrace_unref (var), NULL)))
typedef enum  {
	IVY_STYLE_RESET = 0,
	IVY_STYLE_BRIGHT = 1,
	IVY_STYLE_DIM = 2,
	IVY_STYLE_UNDERLINE = 3,
	IVY_STYLE_BLINK = 4,
	IVY_STYLE_REVERSE = 7,
	IVY_STYLE_HIDDEN = 8
} IvyStyle;

#define IVY_TYPE_STYLE (ivy_style_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _ivy_frame_unref0(var) ((var == NULL) ? NULL : (var = (ivy_frame_unref (var), NULL)))
typedef struct _IvyParamSpecPrinter IvyParamSpecPrinter;

struct _IvyPrinterPrivate {
	IvyColor background_color;
	gint title_length;
	IvyStacktrace* stacktrace;
};

struct _IvyParamSpecPrinter {
	GParamSpec parent_instance;
};

static gint IvyPrinter_private_offset;
static gpointer ivy_printer_parent_class = NULL;

static gchar* ivy_printer_get_reset_code (IvyPrinter* self);
static gchar* ivy_printer_get_reset_style (IvyPrinter* self);
VALA_EXTERN GType ivy_style_get_type (void) G_GNUC_CONST ;
static gchar* ivy_printer_get_color_code (IvyPrinter* self,
                                   IvyStyle attr,
                                   IvyColor fg,
                                   IvyColor bg);
static gchar* ivy_printer_get_signal_name (IvyPrinter* self);
static const char* _g_process_signal_to_string (int value);
static gchar* ivy_printer_get_highlight_code (IvyPrinter* self);
static gchar* ivy_printer_get_printable_function (IvyPrinter* self,
                                           IvyFrame* frame,
                                           gint padding);
static gchar* ivy_printer_get_printable_line_number (IvyPrinter* self,
                                              IvyFrame* frame,
                                              gboolean pad);
static gchar* ivy_printer_get_printable_file_short_path (IvyPrinter* self,
                                                  IvyFrame* frame,
                                                  gboolean pad);
static gchar* ivy_printer_get_printable_title (IvyPrinter* self);
static gchar* ivy_printer_get_reason (IvyPrinter* self);
static void ivy_printer_real_print (IvyPrinter* self,
                             IvyStacktrace* trace);
static void ivy_printer_finalize (IvyPrinter * obj);
static GType ivy_printer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
ivy_printer_get_instance_private (IvyPrinter* self)
{
	return G_STRUCT_MEMBER_P (self, IvyPrinter_private_offset);
}

static gchar*
ivy_printer_get_reset_code (IvyPrinter* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\x1b[0m");
	result = _tmp0_;
	return result;
}

static gchar*
ivy_printer_get_reset_style (IvyPrinter* self)
{
	IvyStacktrace* _tmp0_;
	IvyColor _tmp1_;
	IvyColor _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stacktrace;
	_tmp1_ = ivy_stacktrace_get_highlight_color (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ivy_printer_get_color_code (self, IVY_STYLE_DIM, _tmp2_, self->priv->background_color);
	result = _tmp3_;
	return result;
}

static gchar*
ivy_printer_get_color_code (IvyPrinter* self,
                            IvyStyle attr,
                            IvyColor fg,
                            IvyColor bg)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (bg == IVY_COLOR_BLACK) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("%c[%d;%dm", 0x1B, (gint) attr, ((gint) fg) + 30);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%c[%d;%d;%dm", 0x1B, (gint) attr, ((gint) fg) + 30, ((gint) bg) + 40);
		result = _tmp1_;
		return result;
	}
}

static const char*
_g_process_signal_to_string (int value)
{
	switch (value) {
		case SIGHUP:
		return "SIGHUP";
		case SIGINT:
		return "SIGINT";
		case SIGQUIT:
		return "SIGQUIT";
		case SIGILL:
		return "SIGILL";
		case SIGTRAP:
		return "SIGTRAP";
		case SIGABRT:
		return "SIGABRT";
		case SIGBUS:
		return "SIGBUS";
		case SIGFPE:
		return "SIGFPE";
		case SIGKILL:
		return "SIGKILL";
		case SIGSEGV:
		return "SIGSEGV";
		case SIGPIPE:
		return "SIGPIPE";
		case SIGALRM:
		return "SIGALRM";
		case SIGTERM:
		return "SIGTERM";
		case SIGUSR1:
		return "SIGUSR1";
		case SIGUSR2:
		return "SIGUSR2";
		case SIGCHLD:
		return "SIGCHLD";
		case SIGCONT:
		return "SIGCONT";
		case SIGSTOP:
		return "SIGSTOP";
		case SIGTSTP:
		return "SIGTSTP";
		case SIGTTIN:
		return "SIGTTIN";
		case SIGTTOU:
		return "SIGTTOU";
	}
	return NULL;
}

static gchar*
ivy_printer_get_signal_name (IvyPrinter* self)
{
	IvyStacktrace* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stacktrace;
	_tmp1_ = _g_process_signal_to_string (_tmp0_->sig);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
ivy_printer_get_highlight_code (IvyPrinter* self)
{
	IvyStacktrace* _tmp0_;
	IvyColor _tmp1_;
	IvyColor _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stacktrace;
	_tmp1_ = ivy_stacktrace_get_highlight_color (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ivy_printer_get_color_code (self, IVY_STYLE_BRIGHT, _tmp2_, self->priv->background_color);
	result = _tmp3_;
	return result;
}

static gchar*
ivy_printer_get_printable_function (IvyPrinter* self,
                                    IvyFrame* frame,
                                    gint padding)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gboolean is_unknown = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (frame != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	is_unknown = FALSE;
	_tmp1_ = ivy_frame_get_function (frame);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = ivy_frame_get_address (frame);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("<unknown> ", _tmp4_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp5_;
		is_unknown = TRUE;
	} else {
		gchar* s = NULL;
		gchar* _tmp6_;
		gint count = 0;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp6_ = g_strdup ("");
		s = _tmp6_;
		_tmp7_ = ivy_printer_get_signal_name (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = padding - _tmp10_;
		_g_free0 (_tmp8_);
		count = _tmp11_;
		if (padding != 0) {
			_tmp12_ = count > 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* _tmp13_;
			_tmp13_ = g_strnfill ((gsize) count, ' ');
			_g_free0 (s);
			s = _tmp13_;
		}
		_tmp14_ = ivy_frame_get_function (frame);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat ("'", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, "'", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = s;
		_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp21_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (s);
	}
	if (is_unknown) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp22_ = _result_;
		_tmp23_ = ivy_printer_get_reset_code (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		result = _tmp26_;
		_g_free0 (_result_);
		return result;
	} else {
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp27_ = ivy_printer_get_highlight_code (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = _result_;
		_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = ivy_printer_get_reset_code (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp28_);
		result = _tmp35_;
		_g_free0 (_result_);
		return result;
	}
}

static gchar*
ivy_printer_get_printable_line_number (IvyPrinter* self,
                                       IvyFrame* frame,
                                       gboolean pad)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint max_line_number_length = 0;
	IvyStacktrace* _tmp3_;
	gchar* _result_ = NULL;
	gchar* _tmp4_;
	gchar* color = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (frame != NULL, NULL);
	_tmp0_ = ivy_frame_get_line_number (frame);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = self->priv->stacktrace;
	max_line_number_length = _tmp3_->max_line_number_length;
	_tmp4_ = g_strdup ("");
	_result_ = _tmp4_;
	_tmp5_ = ivy_printer_get_highlight_code (self);
	color = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ >= max_line_number_length) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !pad;
	}
	if (_tmp6_) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp10_ = color;
		_tmp11_ = path;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = ivy_printer_get_reset_style (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp17_ = color;
		_tmp18_ = path;
		_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = ivy_printer_get_reset_style (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp24_ = path;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strnfill ((gsize) (max_line_number_length - _tmp26_), ' ');
		_tmp28_ = _tmp27_;
		_tmp29_ = _result_;
		_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp30_;
		_g_free0 (_tmp28_);
	}
	result = _result_;
	_g_free0 (color);
	_g_free0 (path);
	return result;
}

static gchar*
ivy_printer_get_printable_file_short_path (IvyPrinter* self,
                                           IvyFrame* frame,
                                           gboolean pad)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint max_file_name_length = 0;
	IvyStacktrace* _tmp3_;
	gchar* _result_ = NULL;
	gchar* _tmp4_;
	gchar* color = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (frame != NULL, NULL);
	_tmp0_ = ivy_frame_get_file_short_path (frame);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = self->priv->stacktrace;
	max_file_name_length = _tmp3_->max_file_name_length;
	_tmp4_ = g_strdup ("");
	_result_ = _tmp4_;
	_tmp5_ = ivy_printer_get_highlight_code (self);
	color = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ >= max_file_name_length) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !pad;
	}
	if (_tmp6_) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp10_ = color;
		_tmp11_ = path;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = ivy_printer_get_reset_style (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp17_ = color;
		_tmp18_ = path;
		_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = ivy_printer_get_reset_style (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp24_ = _result_;
		_tmp25_ = path;
		_tmp26_ = strlen (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strnfill ((gsize) (max_file_name_length - _tmp27_), ' ');
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp24_, _tmp29_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp30_;
		_g_free0 (_tmp29_);
	}
	result = _result_;
	_g_free0 (color);
	_g_free0 (path);
	return result;
}

static gchar*
ivy_printer_get_printable_title (IvyPrinter* self)
{
	gchar* c = NULL;
	IvyStacktrace* _tmp0_;
	IvyColor _tmp1_;
	IvyColor _tmp2_;
	gchar* _tmp3_;
	gchar* color = NULL;
	gchar* _tmp4_;
	gchar* _result_ = NULL;
	gchar* _tmp5_;
	IvyStacktrace* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stacktrace;
	_tmp1_ = ivy_stacktrace_get_highlight_color (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ivy_printer_get_color_code (self, IVY_STYLE_DIM, _tmp2_, self->priv->background_color);
	c = _tmp3_;
	_tmp4_ = ivy_printer_get_highlight_code (self);
	color = _tmp4_;
	_tmp5_ = g_strdup ("");
	_result_ = _tmp5_;
	_tmp6_ = self->priv->stacktrace;
	_tmp7_ = ivy_stacktrace_get_is_custom (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = c;
		_tmp10_ = ivy_printer_get_reset_style (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("%sA function was called in %s", _tmp9_, _tmp11_);
		_g_free0 (_result_);
		_result_ = _tmp12_;
		_g_free0 (_tmp11_);
	} else {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = c;
		_tmp14_ = color;
		_tmp15_ = ivy_printer_get_signal_name (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = ivy_printer_get_reset_style (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%sAn error occured %s(%s)%s", _tmp13_, _tmp14_, _tmp16_, _tmp18_);
		_g_free0 (_result_);
		_result_ = _tmp19_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	_tmp20_ = ivy_printer_get_signal_name (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	self->priv->title_length = _tmp23_;
	_g_free0 (_tmp21_);
	result = _result_;
	_g_free0 (color);
	_g_free0 (c);
	return result;
}

static gchar*
ivy_printer_get_reason (IvyPrinter* self)
{
	int sig = 0;
	IvyStacktrace* _tmp0_;
	gchar* color = NULL;
	gchar* _tmp1_;
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stacktrace;
	sig = _tmp0_->sig;
	_tmp1_ = ivy_printer_get_highlight_code (self);
	color = _tmp1_;
	if (sig == SIGTRAP) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = color;
		_tmp3_ = ivy_printer_get_reset_code (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("The reason is likely %san uncaught error%s", _tmp2_, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		_g_free0 (color);
		return result;
	}
	if (sig == SIGABRT) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = color;
		_tmp8_ = ivy_printer_get_reset_code (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("The reason is likely %sa failed assertion (assert...)%s", _tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		_g_free0 (color);
		return result;
	}
	if (sig == SIGSEGV) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = color;
		_tmp13_ = ivy_printer_get_reset_code (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("The reason is likely %sa null reference being used%s", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		result = _tmp16_;
		_g_free0 (color);
		return result;
	}
	_tmp17_ = g_strdup ("Unknown reason");
	result = _tmp17_;
	_g_free0 (color);
	return result;
}

/**
* Print the stacktrace to ``stdout``
*
* @param trace the stacktrace
*
*/
static gpointer
_ivy_stacktrace_ref0 (gpointer self)
{
	return self ? ivy_stacktrace_ref (self) : NULL;
}

static gpointer
_ivy_frame_ref0 (gpointer self)
{
	return self ? ivy_frame_ref (self) : NULL;
}

static void
ivy_printer_real_print (IvyPrinter* self,
                        IvyStacktrace* trace)
{
	IvyStacktrace* _tmp0_;
	IvyStacktrace* _tmp1_;
	IvyColor _tmp2_;
	IvyColor _tmp3_;
	gchar* header = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	IvyFrame* first_vala = NULL;
	IvyFrame* _tmp10_;
	IvyFrame* _tmp11_;
	IvyFrame* _tmp12_;
	FILE* _tmp44_;
	const gchar* _tmp45_;
	IvyStacktrace* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean is_all_file_name_blank = FALSE;
	IvyStacktrace* _tmp52_;
	gboolean _tmp63_ = FALSE;
	IvyStacktrace* _tmp64_;
	FILE* _tmp75_;
	gint i = 0;
	gboolean has_displayed_first_vala = FALSE;
	g_return_if_fail (trace != NULL);
	_tmp0_ = _ivy_stacktrace_ref0 (trace);
	_ivy_stacktrace_unref0 (self->priv->stacktrace);
	self->priv->stacktrace = _tmp0_;
	_tmp1_ = self->priv->stacktrace;
	_tmp2_ = ivy_stacktrace_get_error_background (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->background_color = _tmp3_;
	_tmp4_ = ivy_printer_get_printable_title (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = ivy_printer_get_reset_code (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s%s\n", _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	header = _tmp9_;
	_tmp10_ = trace->first_vala;
	_tmp11_ = _ivy_frame_ref0 (_tmp10_);
	first_vala = _tmp11_;
	_tmp12_ = trace->first_vala;
	if (_tmp12_ != NULL) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		IvyFrame* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		IvyFrame* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		IvyFrame* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		IvyFrame* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		IvyFrame* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		IvyFrame* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		_tmp13_ = ivy_printer_get_printable_title (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = first_vala;
		_tmp16_ = ivy_printer_get_printable_file_short_path (self, _tmp15_, FALSE);
		_tmp17_ = _tmp16_;
		_tmp18_ = first_vala;
		_tmp19_ = ivy_printer_get_printable_line_number (self, _tmp18_, FALSE);
		_tmp20_ = _tmp19_;
		_tmp21_ = first_vala;
		_tmp22_ = ivy_printer_get_printable_function (self, _tmp21_, 0);
		_tmp23_ = _tmp22_;
		_tmp24_ = ivy_printer_get_reset_code (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("%s in %s, line %s in %s\n", _tmp14_, _tmp17_, _tmp20_, _tmp27_);
		_g_free0 (header);
		header = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		_tmp29_ = first_vala;
		_tmp30_ = ivy_frame_get_line_number (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = strlen (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = first_vala;
		_tmp35_ = ivy_frame_get_function (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = strlen (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = first_vala;
		_tmp40_ = ivy_frame_get_file_short_path (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = strlen (_tmp41_);
		_tmp43_ = _tmp42_;
		self->priv->title_length = self->priv->title_length + ((_tmp33_ + _tmp38_) + _tmp43_);
	}
	_tmp44_ = stdout;
	_tmp45_ = header;
	fprintf (_tmp44_, "%s", _tmp45_);
	self->priv->background_color = IVY_COLOR_BLACK;
	_tmp46_ = self->priv->stacktrace;
	_tmp47_ = ivy_stacktrace_get_is_custom (_tmp46_);
	_tmp48_ = _tmp47_;
	if (!_tmp48_) {
		gchar* reason = NULL;
		gchar* _tmp49_;
		FILE* _tmp50_;
		const gchar* _tmp51_;
		_tmp49_ = ivy_printer_get_reason (self);
		reason = _tmp49_;
		_tmp50_ = stdout;
		_tmp51_ = reason;
		fprintf (_tmp50_, "   %s.\n", _tmp51_);
		_g_free0 (reason);
	}
	_tmp52_ = self->priv->stacktrace;
	is_all_file_name_blank = _tmp52_->is_all_file_name_blank;
	if (is_all_file_name_blank) {
		gchar* advice = NULL;
		gchar* _tmp53_;
		gchar* color = NULL;
		gchar* _tmp54_;
		FILE* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		_tmp53_ = g_strdup ("   %sNote%s: no file path and line numbers can be retrieved. Are you s" \
"ure %syou added -g -X -rdynamic%s to valac command line?\n");
		advice = _tmp53_;
		_tmp54_ = ivy_printer_get_highlight_code (self);
		color = _tmp54_;
		_tmp55_ = stdout;
		_tmp56_ = advice;
		_tmp57_ = color;
		_tmp58_ = ivy_printer_get_reset_code (self);
		_tmp59_ = _tmp58_;
		_tmp60_ = color;
		_tmp61_ = ivy_printer_get_reset_code (self);
		_tmp62_ = _tmp61_;
		fprintf (_tmp55_, _tmp56_, _tmp57_, _tmp59_, _tmp60_, _tmp62_);
		_g_free0 (_tmp62_);
		_g_free0 (_tmp59_);
		_g_free0 (color);
		_g_free0 (advice);
	}
	_tmp64_ = self->priv->stacktrace;
	if (_tmp64_->is_all_function_name_blank) {
		_tmp63_ = !is_all_file_name_blank;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gchar* advice = NULL;
		gchar* _tmp65_;
		gchar* color = NULL;
		gchar* _tmp66_;
		FILE* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		const gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp65_ = g_strdup ("   %sNote%s: no vala function name can be retrieved. Are you sure %syo" \
"u added -X -rdynamic%s to valac command line?\n");
		advice = _tmp65_;
		_tmp66_ = ivy_printer_get_highlight_code (self);
		color = _tmp66_;
		_tmp67_ = stdout;
		_tmp68_ = advice;
		_tmp69_ = color;
		_tmp70_ = ivy_printer_get_reset_code (self);
		_tmp71_ = _tmp70_;
		_tmp72_ = color;
		_tmp73_ = ivy_printer_get_reset_code (self);
		_tmp74_ = _tmp73_;
		fprintf (_tmp67_, _tmp68_, _tmp69_, _tmp71_, _tmp72_, _tmp74_);
		_g_free0 (_tmp74_);
		_g_free0 (_tmp71_);
		_g_free0 (color);
		_g_free0 (advice);
	}
	_tmp75_ = stdout;
	fprintf (_tmp75_, "\n");
	i = 1;
	has_displayed_first_vala = FALSE;
	{
		GeeList* _frame_list = NULL;
		GeeList* _tmp76_;
		GeeList* _tmp77_;
		gint _frame_size = 0;
		GeeList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _frame_index = 0;
		_tmp76_ = ivy_stacktrace_get_frames (trace);
		_tmp77_ = _tmp76_;
		_frame_list = _tmp77_;
		_tmp78_ = _frame_list;
		_tmp79_ = gee_collection_get_size ((GeeCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_frame_size = _tmp80_;
		_frame_index = -1;
		while (TRUE) {
			gint _tmp81_;
			gint _tmp82_;
			IvyFrame* frame = NULL;
			GeeList* _tmp83_;
			gpointer _tmp84_;
			gboolean _tmp85_ = FALSE;
			gboolean _tmp86_ = FALSE;
			IvyFrame* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			gboolean show_frame = FALSE;
			gboolean _tmp96_ = FALSE;
			gboolean _tmp97_;
			gboolean _tmp98_;
			gboolean _tmp103_ = FALSE;
			gboolean _tmp104_ = FALSE;
			IvyFrame* _tmp105_;
			const gchar* _tmp106_;
			const gchar* _tmp107_;
			_frame_index = _frame_index + 1;
			_tmp81_ = _frame_index;
			_tmp82_ = _frame_size;
			if (!(_tmp81_ < _tmp82_)) {
				break;
			}
			_tmp83_ = _frame_list;
			_tmp84_ = gee_list_get (_tmp83_, _frame_index);
			frame = (IvyFrame*) _tmp84_;
			_tmp87_ = frame;
			_tmp88_ = ivy_frame_get_function (_tmp87_);
			_tmp89_ = _tmp88_;
			if (g_strcmp0 (_tmp89_, "") != 0) {
				_tmp86_ = TRUE;
			} else {
				IvyFrame* _tmp90_;
				const gchar* _tmp91_;
				const gchar* _tmp92_;
				_tmp90_ = frame;
				_tmp91_ = ivy_frame_get_file_path (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp86_ = g_str_has_suffix (_tmp92_, ".vala");
			}
			if (_tmp86_) {
				_tmp85_ = TRUE;
			} else {
				IvyFrame* _tmp93_;
				const gchar* _tmp94_;
				const gchar* _tmp95_;
				_tmp93_ = frame;
				_tmp94_ = ivy_frame_get_file_path (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp85_ = g_str_has_suffix (_tmp95_, ".c");
			}
			show_frame = _tmp85_;
			_tmp97_ = ivy_stacktrace_get_hide_installed_libraries ();
			_tmp98_ = _tmp97_;
			if (_tmp98_) {
				_tmp96_ = has_displayed_first_vala;
			} else {
				_tmp96_ = FALSE;
			}
			if (_tmp96_) {
				gboolean _tmp99_ = FALSE;
				if (show_frame) {
					IvyFrame* _tmp100_;
					const gchar* _tmp101_;
					const gchar* _tmp102_;
					_tmp100_ = frame;
					_tmp101_ = ivy_frame_get_file_short_path (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp99_ = g_strcmp0 (_tmp102_, "") != 0;
				} else {
					_tmp99_ = FALSE;
				}
				show_frame = _tmp99_;
			}
			_tmp105_ = frame;
			_tmp106_ = ivy_frame_get_function (_tmp105_);
			_tmp107_ = _tmp106_;
			if (g_strcmp0 (_tmp107_, "g_logv") == 0) {
				_tmp104_ = TRUE;
			} else {
				IvyFrame* _tmp108_;
				const gchar* _tmp109_;
				const gchar* _tmp110_;
				_tmp108_ = frame;
				_tmp109_ = ivy_frame_get_function (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp104_ = g_strcmp0 (_tmp110_, "g_log") == 0;
			}
			if (_tmp104_) {
				_tmp103_ = !has_displayed_first_vala;
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				show_frame = FALSE;
			}
			if (show_frame) {
				gchar* str = NULL;
				gchar* _tmp111_;
				gchar* lead = NULL;
				gchar* _tmp112_;
				gint function_padding = 0;
				IvyFrame* _tmp113_;
				IvyFrame* _tmp114_;
				gchar* l_number = NULL;
				gchar* _tmp119_;
				IvyFrame* _tmp120_;
				const gchar* _tmp121_;
				const gchar* _tmp122_;
				FILE* _tmp150_;
				const gchar* _tmp151_;
				IvyFrame* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				const gchar* _tmp155_;
				gchar* _tmp156_;
				FILE* _tmp157_;
				const gchar* _tmp158_;
				gint _tmp159_;
				_tmp111_ = g_strdup (" %s  #%d  %s    line %s in %s\n");
				str = _tmp111_;
				self->priv->background_color = IVY_COLOR_BLACK;
				_tmp112_ = g_strdup (" ");
				lead = _tmp112_;
				function_padding = 0;
				_tmp113_ = frame;
				_tmp114_ = first_vala;
				if (_tmp113_ == _tmp114_) {
					gchar* _tmp115_;
					IvyStacktrace* _tmp116_;
					IvyColor _tmp117_;
					IvyColor _tmp118_;
					has_displayed_first_vala = TRUE;
					_tmp115_ = g_strdup ("*");
					_g_free0 (lead);
					lead = _tmp115_;
					_tmp116_ = self->priv->stacktrace;
					_tmp117_ = ivy_stacktrace_get_error_background (_tmp116_);
					_tmp118_ = _tmp117_;
					self->priv->background_color = _tmp118_;
					function_padding = 22;
				}
				_tmp119_ = g_strdup ("");
				l_number = _tmp119_;
				_tmp120_ = frame;
				_tmp121_ = ivy_frame_get_line_number (_tmp120_);
				_tmp122_ = _tmp121_;
				if (g_strcmp0 (_tmp122_, "") == 0) {
					gchar* _tmp123_;
					gchar* func_name = NULL;
					IvyFrame* _tmp124_;
					gchar* _tmp125_;
					gint fill_len = 0;
					IvyStacktrace* _tmp126_;
					IvyStacktrace* _tmp127_;
					const gchar* _tmp128_;
					const gchar* _tmp129_;
					gchar* _tmp130_;
					gchar* _tmp131_;
					const gchar* _tmp132_;
					gchar* _tmp133_;
					_tmp123_ = g_strdup (" %s  #%d  <unknown>  %s in %s\n");
					_g_free0 (str);
					str = _tmp123_;
					_tmp124_ = frame;
					_tmp125_ = ivy_printer_get_printable_function (self, _tmp124_, 0);
					func_name = _tmp125_;
					_tmp126_ = self->priv->stacktrace;
					_tmp127_ = self->priv->stacktrace;
					fill_len = MAX ((_tmp126_->max_file_name_length + _tmp127_->max_line_number_length) - 1, 0);
					_tmp128_ = str;
					_tmp129_ = lead;
					_tmp130_ = g_strnfill ((gsize) fill_len, ' ');
					_tmp131_ = _tmp130_;
					_tmp132_ = func_name;
					_tmp133_ = g_strdup_printf (_tmp128_, _tmp129_, i, _tmp131_, _tmp132_);
					_g_free0 (str);
					str = _tmp133_;
					_g_free0 (_tmp131_);
					_g_free0 (func_name);
				} else {
					const gchar* _tmp134_;
					const gchar* _tmp135_;
					IvyFrame* _tmp136_;
					gchar* _tmp137_;
					gchar* _tmp138_;
					IvyFrame* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					IvyFrame* _tmp142_;
					gchar* _tmp143_;
					gchar* _tmp144_;
					gchar* _tmp145_;
					IvyFrame* _tmp146_;
					const gchar* _tmp147_;
					const gchar* _tmp148_;
					gchar* _tmp149_;
					_tmp134_ = str;
					_tmp135_ = lead;
					_tmp136_ = frame;
					_tmp137_ = ivy_printer_get_printable_file_short_path (self, _tmp136_, TRUE);
					_tmp138_ = _tmp137_;
					_tmp139_ = frame;
					_tmp140_ = ivy_printer_get_printable_line_number (self, _tmp139_, TRUE);
					_tmp141_ = _tmp140_;
					_tmp142_ = frame;
					_tmp143_ = ivy_printer_get_printable_function (self, _tmp142_, function_padding);
					_tmp144_ = _tmp143_;
					_tmp145_ = g_strdup_printf (_tmp134_, _tmp135_, i, _tmp138_, _tmp141_, _tmp144_);
					_g_free0 (str);
					str = _tmp145_;
					_g_free0 (_tmp144_);
					_g_free0 (_tmp141_);
					_g_free0 (_tmp138_);
					_tmp146_ = frame;
					_tmp147_ = ivy_frame_get_line_number (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = g_strconcat (":", _tmp148_, NULL);
					_g_free0 (l_number);
					l_number = _tmp149_;
				}
				_tmp150_ = stdout;
				_tmp151_ = str;
				fprintf (_tmp150_, "%s", _tmp151_);
				_tmp152_ = frame;
				_tmp153_ = ivy_frame_get_file_path (_tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = l_number;
				_tmp156_ = g_strdup_printf ("        at %s%s\n", _tmp154_, _tmp155_);
				_g_free0 (str);
				str = _tmp156_;
				_tmp157_ = stdout;
				_tmp158_ = str;
				fprintf (_tmp157_, "%s", _tmp158_);
				_tmp159_ = i;
				i = _tmp159_ + 1;
				_g_free0 (l_number);
				_g_free0 (lead);
				_g_free0 (str);
			}
			_ivy_frame_unref0 (frame);
		}
	}
	_ivy_frame_unref0 (first_vala);
	_g_free0 (header);
}

void
ivy_printer_print (IvyPrinter* self,
                   IvyStacktrace* trace)
{
	IvyPrinterClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = IVY_PRINTER_GET_CLASS (self);
	if (_klass_->print) {
		_klass_->print (self, trace);
	}
}

IvyPrinter*
ivy_printer_construct (GType object_type)
{
	IvyPrinter* self = NULL;
	self = (IvyPrinter*) g_type_create_instance (object_type);
	return self;
}

IvyPrinter*
ivy_printer_new (void)
{
	return ivy_printer_construct (IVY_TYPE_PRINTER);
}

static void
ivy_value_printer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ivy_value_printer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ivy_printer_unref (value->data[0].v_pointer);
	}
}

static void
ivy_value_printer_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ivy_printer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ivy_value_printer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ivy_value_printer_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		IvyPrinter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ivy_printer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ivy_value_printer_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	IvyPrinter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ivy_printer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ivy_param_spec_printer (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	IvyParamSpecPrinter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IVY_TYPE_PRINTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ivy_value_get_printer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_PRINTER), NULL);
	return value->data[0].v_pointer;
}

void
ivy_value_set_printer (GValue* value,
                       gpointer v_object)
{
	IvyPrinter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_PRINTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_PRINTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ivy_printer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_printer_unref (old);
	}
}

void
ivy_value_take_printer (GValue* value,
                        gpointer v_object)
{
	IvyPrinter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_PRINTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_PRINTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_printer_unref (old);
	}
}

static void
ivy_printer_class_init (IvyPrinterClass * klass,
                        gpointer klass_data)
{
	ivy_printer_parent_class = g_type_class_peek_parent (klass);
	((IvyPrinterClass *) klass)->finalize = ivy_printer_finalize;
	g_type_class_adjust_private_offset (klass, &IvyPrinter_private_offset);
	((IvyPrinterClass *) klass)->print = (void (*) (IvyPrinter*, IvyStacktrace*)) ivy_printer_real_print;
}

static void
ivy_printer_instance_init (IvyPrinter * self,
                           gpointer klass)
{
	self->priv = ivy_printer_get_instance_private (self);
	self->priv->background_color = IVY_COLOR_BLACK;
	self->priv->title_length = 0;
	self->ref_count = 1;
}

static void
ivy_printer_finalize (IvyPrinter * obj)
{
	IvyPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IVY_TYPE_PRINTER, IvyPrinter);
	g_signal_handlers_destroy (self);
	_ivy_stacktrace_unref0 (self->priv->stacktrace);
}

/**
* Prints the stacktrace to ``stdout`` in colors
*
*/
static GType
ivy_printer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ivy_value_printer_init, ivy_value_printer_free_value, ivy_value_printer_copy_value, ivy_value_printer_peek_pointer, "p", ivy_value_printer_collect_value, "p", ivy_value_printer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IvyPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ivy_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IvyPrinter), 0, (GInstanceInitFunc) ivy_printer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ivy_printer_type_id;
	ivy_printer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IvyPrinter", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IvyPrinter_private_offset = g_type_add_instance_private (ivy_printer_type_id, sizeof (IvyPrinterPrivate));
	return ivy_printer_type_id;
}

GType
ivy_printer_get_type (void)
{
	static volatile gsize ivy_printer_type_id__once = 0;
	if (g_once_init_enter (&ivy_printer_type_id__once)) {
		GType ivy_printer_type_id;
		ivy_printer_type_id = ivy_printer_get_type_once ();
		g_once_init_leave (&ivy_printer_type_id__once, ivy_printer_type_id);
	}
	return ivy_printer_type_id__once;
}

gpointer
ivy_printer_ref (gpointer instance)
{
	IvyPrinter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ivy_printer_unref (gpointer instance)
{
	IvyPrinter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IVY_PRINTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

