/* Stacktrace.c generated by valac 0.56.3, the Vala compiler
 * generated from Stacktrace.vala, do not modify */

/*
* Copyright (C) 2014 PerfectCarl - https://github.com/PerfectCarl/vala-stacktrace
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <glib-object.h>
#include "ivy.h"
#include <gee.h>
#include <glib.h>
#include <signal.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

typedef enum  {
	IVY_STYLE_RESET = 0,
	IVY_STYLE_BRIGHT = 1,
	IVY_STYLE_DIM = 2,
	IVY_STYLE_UNDERLINE = 3,
	IVY_STYLE_BLINK = 4,
	IVY_STYLE_REVERSE = 7,
	IVY_STYLE_HIDDEN = 8
} IvyStyle;

#define IVY_TYPE_STYLE (ivy_style_get_type ())
#define _ivy_frame_unref0(var) ((var == NULL) ? NULL : (var = (ivy_frame_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ivy_printer_unref0(var) ((var == NULL) ? NULL : (var = (ivy_printer_unref (var), NULL)))
#define _ivy_extractor_unref0(var) ((var == NULL) ? NULL : (var = (ivy_extractor_unref (var), NULL)))
#define _ivy_stacktrace_unref0(var) ((var == NULL) ? NULL : (var = (ivy_stacktrace_unref (var), NULL)))
typedef struct _IvyParamSpecStacktrace IvyParamSpecStacktrace;

struct _IvyStacktracePrivate {
	GeeList* _frames;
	IvyColor _highlight_color;
	IvyColor _error_background;
	IvyPrinter* printer;
	IvyExtractor* extractor;
};

struct _IvyParamSpecStacktrace {
	GParamSpec parent_instance;
};

static gint IvyStacktrace_private_offset;
static gpointer ivy_stacktrace_parent_class = NULL;
static gboolean ivy_stacktrace__enabled;
static gboolean ivy_stacktrace__enabled = TRUE;
static gboolean ivy_stacktrace__hide_installed_libraries;
static gboolean ivy_stacktrace__hide_installed_libraries = TRUE;
static IvyColor ivy_stacktrace__default_highlight_color;
static IvyColor ivy_stacktrace__default_highlight_color = IVY_COLOR_WHITE;
static IvyColor ivy_stacktrace__default_error_background;
static IvyColor ivy_stacktrace__default_error_background = IVY_COLOR_RED;
static IvyCriticalHandler ivy_stacktrace__critical_handling;
static IvyCriticalHandler ivy_stacktrace__critical_handling = IVY_CRITICAL_HANDLER_PRINT_STACKTRACE;

VALA_EXTERN GType ivy_style_get_type (void) G_GNUC_CONST ;
static void ivy_stacktrace_handler (gint sig);
static void _ivy_stacktrace_handler_gsignal_handler_func (gint signum);
static void ivy_stacktrace_finalize (IvyStacktrace * obj);
static GType ivy_stacktrace_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
ivy_style_get_type_once (void)
{
	static const GEnumValue values[] = {{IVY_STYLE_RESET, "IVY_STYLE_RESET", "reset"}, {IVY_STYLE_BRIGHT, "IVY_STYLE_BRIGHT", "bright"}, {IVY_STYLE_DIM, "IVY_STYLE_DIM", "dim"}, {IVY_STYLE_UNDERLINE, "IVY_STYLE_UNDERLINE", "underline"}, {IVY_STYLE_BLINK, "IVY_STYLE_BLINK", "blink"}, {IVY_STYLE_REVERSE, "IVY_STYLE_REVERSE", "reverse"}, {IVY_STYLE_HIDDEN, "IVY_STYLE_HIDDEN", "hidden"}, {0, NULL, NULL}};
	GType ivy_style_type_id;
	ivy_style_type_id = g_enum_register_static ("IvyStyle", values);
	return ivy_style_type_id;
}

GType
ivy_style_get_type (void)
{
	static volatile gsize ivy_style_type_id__once = 0;
	if (g_once_init_enter (&ivy_style_type_id__once)) {
		GType ivy_style_type_id;
		ivy_style_type_id = ivy_style_get_type_once ();
		g_once_init_leave (&ivy_style_type_id__once, ivy_style_type_id);
	}
	return ivy_style_type_id__once;
}

/**
* Defines how Unix signals are processed
*/
static GType
ivy_critical_handler_get_type_once (void)
{
	static const GEnumValue values[] = {{IVY_CRITICAL_HANDLER_IGNORE, "IVY_CRITICAL_HANDLER_IGNORE", "ignore"}, {IVY_CRITICAL_HANDLER_PRINT_STACKTRACE, "IVY_CRITICAL_HANDLER_PRINT_STACKTRACE", "print-stacktrace"}, {IVY_CRITICAL_HANDLER_CRASH, "IVY_CRITICAL_HANDLER_CRASH", "crash"}, {0, NULL, NULL}};
	GType ivy_critical_handler_type_id;
	ivy_critical_handler_type_id = g_enum_register_static ("IvyCriticalHandler", values);
	return ivy_critical_handler_type_id;
}

GType
ivy_critical_handler_get_type (void)
{
	static volatile gsize ivy_critical_handler_type_id__once = 0;
	if (g_once_init_enter (&ivy_critical_handler_type_id__once)) {
		GType ivy_critical_handler_type_id;
		ivy_critical_handler_type_id = ivy_critical_handler_get_type_once ();
		g_once_init_leave (&ivy_critical_handler_type_id__once, ivy_critical_handler_type_id);
	}
	return ivy_critical_handler_type_id__once;
}

/**
* Colors used for displaying stacktraces
*/
static GType
ivy_color_get_type_once (void)
{
	static const GEnumValue values[] = {{IVY_COLOR_BLACK, "IVY_COLOR_BLACK", "black"}, {IVY_COLOR_RED, "IVY_COLOR_RED", "red"}, {IVY_COLOR_GREEN, "IVY_COLOR_GREEN", "green"}, {IVY_COLOR_YELLOW, "IVY_COLOR_YELLOW", "yellow"}, {IVY_COLOR_BLUE, "IVY_COLOR_BLUE", "blue"}, {IVY_COLOR_MAGENTA, "IVY_COLOR_MAGENTA", "magenta"}, {IVY_COLOR_CYAN, "IVY_COLOR_CYAN", "cyan"}, {IVY_COLOR_WHITE, "IVY_COLOR_WHITE", "white"}, {0, NULL, NULL}};
	GType ivy_color_type_id;
	ivy_color_type_id = g_enum_register_static ("IvyColor", values);
	return ivy_color_type_id;
}

GType
ivy_color_get_type (void)
{
	static volatile gsize ivy_color_type_id__once = 0;
	if (g_once_init_enter (&ivy_color_type_id__once)) {
		GType ivy_color_type_id;
		ivy_color_type_id = ivy_color_get_type_once ();
		g_once_init_leave (&ivy_color_type_id__once, ivy_color_type_id);
	}
	return ivy_color_type_id__once;
}

static inline gpointer
ivy_stacktrace_get_instance_private (IvyStacktrace* self)
{
	return G_STRUCT_MEMBER_P (self, IvyStacktrace_private_offset);
}

IvyStacktrace*
ivy_stacktrace_construct (GType object_type,
                          int sig)
{
	IvyStacktrace* self = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	IvyExtractor* _tmp6_;
	self = (IvyStacktrace*) g_type_create_instance (object_type);
	self->sig = sig;
	_tmp0_ = ivy_stacktrace_get_is_custom (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ivy_stacktrace_set_hide_installed_libraries (FALSE);
		ivy_stacktrace_set_error_background (self, IVY_COLOR_BLUE);
	} else {
		IvyColor _tmp2_;
		IvyColor _tmp3_;
		IvyColor _tmp4_;
		IvyColor _tmp5_;
		_tmp2_ = ivy_stacktrace_get_default_error_background ();
		_tmp3_ = _tmp2_;
		ivy_stacktrace_set_error_background (self, _tmp3_);
		_tmp4_ = ivy_stacktrace_get_default_highlight_color ();
		_tmp5_ = _tmp4_;
		ivy_stacktrace_set_highlight_color (self, _tmp5_);
	}
	_tmp6_ = self->priv->extractor;
	ivy_extractor_create_stacktrace (_tmp6_, self);
	return self;
}

IvyStacktrace*
ivy_stacktrace_new (int sig)
{
	return ivy_stacktrace_construct (IVY_TYPE_STACKTRACE, sig);
}

/**
* Prints the stacktrace to ``stdout`` with colors
*
*/
void
ivy_stacktrace_print (IvyStacktrace* self)
{
	IvyPrinter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->printer;
	ivy_printer_print (_tmp0_, self);
}

/**
* Registers handlers to intercept Unix signals
*
* Calling ``register_handlers`` is required for the
* library to display a stacktrace when the application encounters an error (ie raises a ``SIGABRT``,
* a ``SIGSEV`` or a ``SIGTRAP`` signal).
*
* ''Note:'' calling ``register_handlers`` is not needed to be able to display custom stacktraces. <<BR>>
* (See {@link is_custom} for more information about custom stacktraces).
*
* How to initialize the library so it can intercept Unix signals:
* {{{
*
*   static int main (string[] arg) {
*      Stacktrace.register_handlers ();
*      // Start your application
*      ...
*      return 0;
*   }
* }}}
*
*/
static void
_ivy_stacktrace_handler_gsignal_handler_func (gint signum)
{
	ivy_stacktrace_handler (signum);
}

void
ivy_stacktrace_register_handlers (void)
{
	IvyCriticalHandler _tmp0_;
	IvyCriticalHandler _tmp1_;
	g_log_set_always_fatal (G_LOG_LEVEL_ERROR);
	signal (SIGSEGV, _ivy_stacktrace_handler_gsignal_handler_func);
	signal (SIGTRAP, _ivy_stacktrace_handler_gsignal_handler_func);
	_tmp0_ = ivy_stacktrace_get_critical_handling ();
	_tmp1_ = _tmp0_;
	if (_tmp1_ != IVY_CRITICAL_HANDLER_IGNORE) {
		signal (SIGABRT, _ivy_stacktrace_handler_gsignal_handler_func);
	}
}

static void
ivy_stacktrace_handler (gint sig)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	IvyStacktrace* stack = NULL;
	IvyStacktrace* _tmp2_;
	IvyStacktrace* _tmp3_;
	gboolean _tmp4_ = FALSE;
	_tmp0_ = ivy_stacktrace_get_enabled ();
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = ivy_stacktrace_new ((int) sig);
	stack = _tmp2_;
	_tmp3_ = stack;
	ivy_stacktrace_print (_tmp3_);
	if (sig != ((gint) SIGTRAP)) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (sig == ((gint) SIGTRAP)) {
			IvyCriticalHandler _tmp6_;
			IvyCriticalHandler _tmp7_;
			_tmp6_ = ivy_stacktrace_get_critical_handling ();
			_tmp7_ = _tmp6_;
			_tmp5_ = _tmp7_ == IVY_CRITICAL_HANDLER_CRASH;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	}
	if (_tmp4_) {
		exit (1);
	}
	_ivy_stacktrace_unref0 (stack);
}

gboolean
ivy_stacktrace_get_enabled (void)
{
	gboolean result;
	result = ivy_stacktrace__enabled;
	return result;
}

void
ivy_stacktrace_set_enabled (gboolean value)
{
	ivy_stacktrace__enabled = value;
}

gboolean
ivy_stacktrace_get_hide_installed_libraries (void)
{
	gboolean result;
	result = ivy_stacktrace__hide_installed_libraries;
	return result;
}

void
ivy_stacktrace_set_hide_installed_libraries (gboolean value)
{
	ivy_stacktrace__hide_installed_libraries = value;
}

IvyColor
ivy_stacktrace_get_default_highlight_color (void)
{
	IvyColor result;
	result = ivy_stacktrace__default_highlight_color;
	return result;
}

void
ivy_stacktrace_set_default_highlight_color (IvyColor value)
{
	ivy_stacktrace__default_highlight_color = value;
}

IvyColor
ivy_stacktrace_get_default_error_background (void)
{
	IvyColor result;
	result = ivy_stacktrace__default_error_background;
	return result;
}

void
ivy_stacktrace_set_default_error_background (IvyColor value)
{
	ivy_stacktrace__default_error_background = value;
}

IvyColor
ivy_stacktrace_get_highlight_color (IvyStacktrace* self)
{
	IvyColor result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_highlight_color;
	return result;
}

void
ivy_stacktrace_set_highlight_color (IvyStacktrace* self,
                                    IvyColor value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_color = value;
}

IvyColor
ivy_stacktrace_get_error_background (IvyStacktrace* self)
{
	IvyColor result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_error_background;
	return result;
}

void
ivy_stacktrace_set_error_background (IvyStacktrace* self,
                                     IvyColor value)
{
	g_return_if_fail (self != NULL);
	self->priv->_error_background = value;
}

GeeList*
ivy_stacktrace_get_frames (IvyStacktrace* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_frames;
	result = _tmp0_;
	return result;
}

gboolean
ivy_stacktrace_get_is_custom (IvyStacktrace* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->sig == SIGTTOU;
	return result;
}

IvyCriticalHandler
ivy_stacktrace_get_critical_handling (void)
{
	IvyCriticalHandler result;
	result = ivy_stacktrace__critical_handling;
	return result;
}

void
ivy_stacktrace_set_critical_handling (IvyCriticalHandler value)
{
	ivy_stacktrace__critical_handling = value;
}

static void
ivy_value_stacktrace_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ivy_value_stacktrace_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ivy_stacktrace_unref (value->data[0].v_pointer);
	}
}

static void
ivy_value_stacktrace_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ivy_stacktrace_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ivy_value_stacktrace_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ivy_value_stacktrace_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		IvyStacktrace * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ivy_stacktrace_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ivy_value_stacktrace_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	IvyStacktrace ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ivy_stacktrace_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ivy_param_spec_stacktrace (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	IvyParamSpecStacktrace* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IVY_TYPE_STACKTRACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ivy_value_get_stacktrace (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_STACKTRACE), NULL);
	return value->data[0].v_pointer;
}

void
ivy_value_set_stacktrace (GValue* value,
                          gpointer v_object)
{
	IvyStacktrace * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_STACKTRACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_STACKTRACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ivy_stacktrace_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_stacktrace_unref (old);
	}
}

void
ivy_value_take_stacktrace (GValue* value,
                           gpointer v_object)
{
	IvyStacktrace * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IVY_TYPE_STACKTRACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IVY_TYPE_STACKTRACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ivy_stacktrace_unref (old);
	}
}

static void
ivy_stacktrace_class_init (IvyStacktraceClass * klass,
                           gpointer klass_data)
{
	ivy_stacktrace_parent_class = g_type_class_peek_parent (klass);
	((IvyStacktraceClass *) klass)->finalize = ivy_stacktrace_finalize;
	g_type_class_adjust_private_offset (klass, &IvyStacktrace_private_offset);
}

static void
ivy_stacktrace_instance_init (IvyStacktrace * self,
                              gpointer klass)
{
	GeeArrayList* _tmp0_;
	IvyPrinter* _tmp1_;
	IvyExtractor* _tmp2_;
	self->priv = ivy_stacktrace_get_instance_private (self);
	self->first_vala = NULL;
	self->max_file_name_length = 0;
	self->max_line_number_length = 0;
	self->is_all_function_name_blank = TRUE;
	self->is_all_file_name_blank = TRUE;
	_tmp0_ = gee_array_list_new (IVY_TYPE_FRAME, (GBoxedCopyFunc) ivy_frame_ref, (GDestroyNotify) ivy_frame_unref, NULL, NULL, NULL);
	self->priv->_frames = (GeeList*) _tmp0_;
	self->priv->_highlight_color = IVY_COLOR_WHITE;
	self->priv->_error_background = IVY_COLOR_RED;
	_tmp1_ = ivy_printer_new ();
	self->priv->printer = _tmp1_;
	_tmp2_ = ivy_extractor_new ();
	self->priv->extractor = _tmp2_;
	self->ref_count = 1;
}

static void
ivy_stacktrace_finalize (IvyStacktrace * obj)
{
	IvyStacktrace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IVY_TYPE_STACKTRACE, IvyStacktrace);
	g_signal_handlers_destroy (self);
	_ivy_frame_unref0 (self->first_vala);
	_g_object_unref0 (self->priv->_frames);
	_ivy_printer_unref0 (self->priv->printer);
	_ivy_extractor_unref0 (self->priv->extractor);
}

/**
* A complete execution stacktrace
*
* Holds a collection of {@link Frame} and the basic methods to intercept Unix signals
* and prints the complete stacktrace to ``stdout`` in colors.
*
* For more information, refer to the [[https://github.com/I-hate-farms/stacktrace|official website]].
*
* Here's a sample of a printed stacktrace:
* {{{
* An error occured (SIGSEGV) in samples/vala_file.vala, line 21 in 'this_will_crash_harder'
* The reason is likely a null reference being used.
*
*    #1  <unknown>                                   in 'strlen'
*        at /lib/x86_64-linux-gnu/libc.so.6
* *  #2  samples/vala_file.vala             line  21 in 'this_will_crash_harder'
*        at /home/cran/Documents/Projects/i-hate-farms/stacktrace/samples/vala_file.vala:21
*    #3  samples/module/OtherModule.vala    line  11 in 'other_module_do_it'
*        at /home/cran/Documents/Projects/i-hate-farms/stacktrace/samples/module/OtherModule.vala:11
*    #4  samples/error_sigsegv.vala         line  19 in 'namespace_someclass_exec'
*        at /home/cran/Documents/Projects/i-hate-farms/stacktrace/samples/error_sigsegv.vala:19
*    #5  samples/error_sigsegv.vala         line  29 in 'this_will_crash'
*        at /home/cran/Documents/Projects/i-hate-farms/stacktrace/samples/error_sigsegv.vala:29
*    #6  samples/error_sigsegv.vala         line  39 in '_vala_main'
*        at /home/cran/Documents/Projects/i-hate-farms/stacktrace/samples/error_sigsegv.vala:39
*    #7  error_sigsegv.vala.c               line 421 in 'main'
*        at /home/cran/Documents/Projects/i-hate-farms/stacktrace/error_sigsegv.vala.c:421
*    #8  <unknown>                                   in '__libc_start_main'
*        at /lib/x86_64-linux-gnu/libc.so.6
* }}}
*/
static GType
ivy_stacktrace_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ivy_value_stacktrace_init, ivy_value_stacktrace_free_value, ivy_value_stacktrace_copy_value, ivy_value_stacktrace_peek_pointer, "p", ivy_value_stacktrace_collect_value, "p", ivy_value_stacktrace_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IvyStacktraceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ivy_stacktrace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IvyStacktrace), 0, (GInstanceInitFunc) ivy_stacktrace_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ivy_stacktrace_type_id;
	ivy_stacktrace_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IvyStacktrace", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IvyStacktrace_private_offset = g_type_add_instance_private (ivy_stacktrace_type_id, sizeof (IvyStacktracePrivate));
	return ivy_stacktrace_type_id;
}

GType
ivy_stacktrace_get_type (void)
{
	static volatile gsize ivy_stacktrace_type_id__once = 0;
	if (g_once_init_enter (&ivy_stacktrace_type_id__once)) {
		GType ivy_stacktrace_type_id;
		ivy_stacktrace_type_id = ivy_stacktrace_get_type_once ();
		g_once_init_leave (&ivy_stacktrace_type_id__once, ivy_stacktrace_type_id);
	}
	return ivy_stacktrace_type_id__once;
}

gpointer
ivy_stacktrace_ref (gpointer instance)
{
	IvyStacktrace * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ivy_stacktrace_unref (gpointer instance)
{
	IvyStacktrace * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IVY_STACKTRACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

